# mode: run

# cython: test_assert_c_code_has = cint_constants_1\[\] = .*127
# cython: test_assert_c_code_has = cint_constants_2\[\] = .*128.*32767
# cython: test_assert_c_code_has = cint_constants_4\[\] = .*32768
# cython: test_assert_c_code_has = cint_constants_8\[\] = .*2147483648
# cython: test_assert_c_code_has = const char\* c_constant =

pylong_constants = [
    -130,
    126,
    -129,
    127,
    -128,
    128,
    -127,
    129,
    -258,
    254,
    -257,
    255,
    -256,
    256,
    -255,
    257,
    -32770,
    32766,
    -32769,
    32767,
    -32768,
    32768,
    -32767,
    32769,
    -65538,
    65534,
    -65537,
    65535,
    -65536,
    65536,
    -65535,
    65537,
    -8388610,
    8388606,
    -8388609,
    8388607,
    -8388608,
    8388608,
    -8388607,
    8388609,
    -16777218,
    16777214,
    -16777217,
    16777215,
    -16777216,
    16777216,
    -16777215,
    16777217,
    -2147483650,
    2147483646,
    -2147483649,
    2147483647,
    -2147483648,
    2147483648,
    -2147483647,
    2147483649,
    -4294967298,
    4294967294,
    -4294967297,
    4294967295,
    -4294967296,
    4294967296,
    -4294967295,
    4294967297,
    -549755813890,
    549755813886,
    -549755813889,
    549755813887,
    -549755813888,
    549755813888,
    -549755813887,
    549755813889,
    -1099511627778,
    1099511627774,
    -1099511627777,
    1099511627775,
    -1099511627776,
    1099511627776,
    -1099511627775,
    1099511627777,
    -140737488355330,
    140737488355326,
    -140737488355329,
    140737488355327,
    -140737488355328,
    140737488355328,
    -140737488355327,
    140737488355329,
    -281474976710658,
    281474976710654,
    -281474976710657,
    281474976710655,
    -281474976710656,
    281474976710656,
    -281474976710655,
    281474976710657,
    -36028797018963970,
    36028797018963966,
    -36028797018963969,
    36028797018963967,
    -36028797018963968,
    36028797018963968,
    -36028797018963967,
    36028797018963969,
    -72057594037927938,
    72057594037927934,
    -72057594037927937,
    72057594037927935,
    -72057594037927936,
    72057594037927936,
    -72057594037927935,
    72057594037927937,
    -9223372036854775810,
    9223372036854775806,
    -9223372036854775809,
    9223372036854775807,
    -9223372036854775808,
    9223372036854775808,
    -9223372036854775807,
    9223372036854775809,
    -18446744073709551618,
    18446744073709551614,
    -18446744073709551617,
    18446744073709551615,
    -18446744073709551616,
    18446744073709551616,
    -18446744073709551615,
    18446744073709551617,
]


def test_pylong_constants(constants):
    """
    >>> constants = [
    ... -130,
    ... 126,
    ... -129,
    ... 127,
    ... -128,
    ... 128,
    ... -127,
    ... 129,
    ... -258,
    ... 254,
    ... -257,
    ... 255,
    ... -256,
    ... 256,
    ... -255,
    ... 257,
    ... -32770,
    ... 32766,
    ... -32769,
    ... 32767,
    ... -32768,
    ... 32768,
    ... -32767,
    ... 32769,
    ... -65538,
    ... 65534,
    ... -65537,
    ... 65535,
    ... -65536,
    ... 65536,
    ... -65535,
    ... 65537,
    ... -8388610,
    ... 8388606,
    ... -8388609,
    ... 8388607,
    ... -8388608,
    ... 8388608,
    ... -8388607,
    ... 8388609,
    ... -16777218,
    ... 16777214,
    ... -16777217,
    ... 16777215,
    ... -16777216,
    ... 16777216,
    ... -16777215,
    ... 16777217,
    ... -2147483650,
    ... 2147483646,
    ... -2147483649,
    ... 2147483647,
    ... -2147483648,
    ... 2147483648,
    ... -2147483647,
    ... 2147483649,
    ... -4294967298,
    ... 4294967294,
    ... -4294967297,
    ... 4294967295,
    ... -4294967296,
    ... 4294967296,
    ... -4294967295,
    ... 4294967297,
    ... -549755813890,
    ... 549755813886,
    ... -549755813889,
    ... 549755813887,
    ... -549755813888,
    ... 549755813888,
    ... -549755813887,
    ... 549755813889,
    ... -1099511627778,
    ... 1099511627774,
    ... -1099511627777,
    ... 1099511627775,
    ... -1099511627776,
    ... 1099511627776,
    ... -1099511627775,
    ... 1099511627777,
    ... -140737488355330,
    ... 140737488355326,
    ... -140737488355329,
    ... 140737488355327,
    ... -140737488355328,
    ... 140737488355328,
    ... -140737488355327,
    ... 140737488355329,
    ... -281474976710658,
    ... 281474976710654,
    ... -281474976710657,
    ... 281474976710655,
    ... -281474976710656,
    ... 281474976710656,
    ... -281474976710655,
    ... 281474976710657,
    ... -36028797018963970,
    ... 36028797018963966,
    ... -36028797018963969,
    ... 36028797018963967,
    ... -36028797018963968,
    ... 36028797018963968,
    ... -36028797018963967,
    ... 36028797018963969,
    ... -72057594037927938,
    ... 72057594037927934,
    ... -72057594037927937,
    ... 72057594037927935,
    ... -72057594037927936,
    ... 72057594037927936,
    ... -72057594037927935,
    ... 72057594037927937,
    ... -9223372036854775810,
    ... 9223372036854775806,
    ... -9223372036854775809,
    ... 9223372036854775807,
    ... -9223372036854775808,
    ... 9223372036854775808,
    ... -9223372036854775807,
    ... 9223372036854775809,
    ... -18446744073709551618,
    ... 18446744073709551614,
    ... -18446744073709551617,
    ... 18446744073709551615,
    ... -18446744073709551616,
    ... 18446744073709551616,
    ... -18446744073709551615,
    ... 18446744073709551617,
    ... ]

    >>> test_pylong_constants(constants)

    """
    if constants == pylong_constants:
        return None

    if len(constants) < len(pylong_constants):
        print(pylong_constants[len(constants):])
    elif len(constants) > len(pylong_constants):
        print(constants[len(pylong_constants):])

    return [
        (c, py)
        for c, py in zip(constants, pylong_constants)
        if c != py
    ]
