/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of DSA.xs. Do not edit this file, edit DSA.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "DSA.xs"
/* $Id: */


#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <openssl/bn.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/dsa.h>
#include <openssl/ssl.h>
#include <openssl/opensslv.h>

#ifdef __cplusplus
}
#endif

#if OPENSSL_VERSION_NUMBER < 0x10100000L
static void DSA_get0_pqg(const DSA *d,
                  const BIGNUM **p, const BIGNUM **q, const BIGNUM **g)
{
    if (p != NULL)
        *p = d->p;
    if (q != NULL)
        *q = d->q;
    if (g != NULL)
        *g = d->g;
}

static int DSA_set0_pqg(DSA *d, BIGNUM *p, BIGNUM *q, BIGNUM *g)
{
    /* If the fields p, q and g in d are NULL, the corresponding input
     * parameters MUST be non-NULL.
     */
    if ((d->p == NULL && p == NULL)
        || (d->q == NULL && q == NULL)
        || (d->g == NULL && g == NULL))
        return 0;

    if (p != NULL) {
        BN_free(d->p);
        d->p = p;
    }
    if (q != NULL) {
        BN_free(d->q);
        d->q = q;
    }
    if (g != NULL) {
        BN_free(d->g);
        d->g = g;
    }

    return 1;
}

static void DSA_get0_key(const DSA *d,
                  const BIGNUM **pub_key, const BIGNUM **priv_key)
{
    if (pub_key != NULL)
        *pub_key = d->pub_key;
    if (priv_key != NULL)
        *priv_key = d->priv_key;
}

static int DSA_set0_key(DSA *d, BIGNUM *pub_key, BIGNUM *priv_key)
{
    /* If the field pub_key in d is NULL, the corresponding input
     * parameters MUST be non-NULL.  The priv_key field may
     * be left NULL.
     */
    if (d->pub_key == NULL && pub_key == NULL)
        return 0;

    if (pub_key != NULL) {
        BN_free(d->pub_key);
        d->pub_key = pub_key;
    }
    if (priv_key != NULL) {
        BN_free(d->priv_key);
        d->priv_key = priv_key;
    }

    return 1;
}

static void DSA_SIG_get0(const DSA_SIG *sig, const BIGNUM **pr,
     const BIGNUM **ps)
{
    if (pr != NULL)
        *pr = sig->r;
    if (ps != NULL)
        *ps = sig->s;
}

static int DSA_SIG_set0(DSA_SIG *sig, BIGNUM *r, BIGNUM *s)
{
    if (r == NULL || s == NULL)
        return 0;
    BN_clear_free(sig->r);
    BN_clear_free(sig->s);
    sig->r = r;
    sig->s = s;
    return 1;
}
#endif

#line 121 "DSA.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 265 "DSA.c"

XS_EUPXS(XS_Crypt__OpenSSL__DSA_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	DSA *	RETVAL;
#line 124 "DSA.xs"
        RETVAL = DSA_new();
#line 279 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::DESTROY() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 132 "DSA.xs"
        DSA_free(dsa);
#line 309 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_parameters); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_parameters)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, bits, seed = NULL");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	int	bits = (int)SvIV(ST(1))
;
	SV *	seed;
#line 140 "DSA.xs"
        DSA * dsa;
        STRLEN seed_len = 0;
        char * seedpv = NULL;
        unsigned long err;
#line 332 "DSA.c"
	DSA *	RETVAL;

	if (items < 3)
	    seed = NULL;
	else {
	    seed = ST(2)
;
	}
#line 145 "DSA.xs"
        if (seed) {
          seedpv = SvPV(seed, seed_len);
        }
#if OPENSSL_VERSION_NUMBER < 0x10100000L
        dsa = DSA_generate_parameters(bits, seedpv, (int)seed_len, NULL, NULL, NULL, NULL);
        if (!dsa) {
#else
	dsa = DSA_new();
	if (!DSA_generate_parameters_ex(dsa, bits, seedpv, (int)seed_len, NULL, NULL, NULL)) {
#endif
          err = ERR_get_error();
          if (err == 0) {
            croak("DSA_generate_parameters() returned NULL");
          }
          else {
            croak("%s", ERR_reason_error_string(err));
          }
        }
        RETVAL = dsa;
#line 361 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::generate_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 171 "DSA.xs"
        RETVAL = DSA_generate_key(dsa);
#line 393 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_sig_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_sig_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_sig_size() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 179 "DSA.xs"
        RETVAL = DSA_size(dsa);
#line 421 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_sign)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, dgst");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
#line 188 "DSA.xs"
        DSA_SIG * sig;
        char * CLASS = "Crypt::OpenSSL::DSA::Signature";
        char * dgst_pv = NULL;
        STRLEN dgst_len = 0;
#line 444 "DSA.c"
	DSA_SIG *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_sign() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 193 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        if (!(sig = DSA_do_sign((const unsigned char *) dgst_pv, (int)dgst_len, dsa))) {
          croak("Error in dsa_sign: %s",ERR_error_string(ERR_get_error(), NULL));
        }
        RETVAL = sig;
#line 460 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_sign)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, dgst");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
#line 206 "DSA.xs"
        unsigned char *sigret;
        unsigned int siglen;
        char * dgst_pv = NULL;
        STRLEN dgst_len = 0;
#line 487 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::sign() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 211 "DSA.xs"
        siglen = DSA_size(dsa);
        sigret = malloc(siglen);

        dgst_pv = SvPV(dgst, dgst_len);
        /* warn("Length of sign [%s] is %d\n", dgst_pv, dgst_len); */

        if (!(DSA_sign(0, (const unsigned char *) dgst_pv, (int)dgst_len, sigret, &siglen, dsa))) {
          croak("Error in DSA_sign: %s",ERR_error_string(ERR_get_error(), NULL));
        }
        RETVAL = newSVpvn(sigret, siglen);
        free(sigret);
#line 509 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_verify)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dsa, dgst, sigbuf");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
	SV *	sigbuf = ST(2)
;
#line 231 "DSA.xs"
        char * dgst_pv = NULL;
        STRLEN dgst_len = 0;
        char * sig_pv = NULL;
        STRLEN sig_len = 0;
#line 534 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::verify() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 236 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        sig_pv = SvPV(sigbuf, sig_len);
        RETVAL = DSA_verify(0, dgst_pv, (int)dgst_len, sig_pv, (int)sig_len, dsa);
        if (RETVAL == -1)
          croak("Error in DSA_verify: %s",ERR_error_string(ERR_get_error(), NULL));
#line 551 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_verify)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dsa, dgst, sig");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
	DSA_SIG *	sig;
#line 250 "DSA.xs"
        char * dgst_pv = NULL;
        STRLEN dgst_len = 0;
#line 573 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_verify() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(2)) && (SvTYPE(SvRV(ST(2))) == SVt_PVMG) )
            sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(2) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_verify() -- sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 253 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        RETVAL = DSA_do_verify(dgst_pv, (int)dgst_len, sig, dsa);
	if (RETVAL == -1)
	  croak("Error in DSA_do_verify: %s",ERR_error_string(ERR_get_error(), NULL));
#line 597 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_params); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_params)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 265 "DSA.xs"
        FILE *f;
#line 618 "DSA.c"
	DSA *	RETVAL;
#line 267 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSAparams(f, NULL, NULL, NULL);
        fclose(f);
#line 625 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_params); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_params)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 279 "DSA.xs"
        FILE *f;
#line 649 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_params() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 281 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSAparams(f, dsa);
        fclose(f);
#line 665 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__load_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__load_key)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "CLASS, private_flag_SV, key_string_SV");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	private_flag_SV = ST(1)
;
	SV *	key_string_SV = ST(2)
;
#line 294 "DSA.xs"
        STRLEN key_string_length;  /* Needed to pass to SvPV */
        char *key_string;
        char private_flag;
        BIO *stringBIO;
#line 691 "DSA.c"
	DSA *	RETVAL;
#line 299 "DSA.xs"
        private_flag = SvTRUE( private_flag_SV );
        key_string = SvPV( key_string_SV, key_string_length );
        if( (stringBIO = BIO_new_mem_buf(key_string, (int)key_string_length)) == NULL )
            croak( "Failed to create memory BIO %s", ERR_error_string(ERR_get_error(), NULL));
        RETVAL = private_flag
            ? PEM_read_bio_DSAPrivateKey( stringBIO, NULL, NULL, NULL )
            : PEM_read_bio_DSA_PUBKEY( stringBIO, NULL, NULL, NULL );
        BIO_set_close(stringBIO, BIO_CLOSE);
        BIO_free( stringBIO );
        if ( RETVAL == NULL )
            croak( "Failed to read key %s", ERR_error_string(ERR_get_error(), NULL));
#line 705 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 318 "DSA.xs"
        FILE *f;
#line 730 "DSA.c"
	DSA *	RETVAL;
#line 320 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSA_PUBKEY(f, NULL, NULL, NULL);
        fclose(f);
#line 737 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 332 "DSA.xs"
        FILE *f;
#line 761 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 334 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSA_PUBKEY(f, dsa);
        fclose(f);
#line 777 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 346 "DSA.xs"
        FILE *f;
#line 798 "DSA.c"
	DSA *	RETVAL;
#line 348 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSAPrivateKey(f, NULL, NULL, NULL);
        fclose(f);
#line 805 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 360 "DSA.xs"
        FILE *f;
#line 829 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 362 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSAPrivateKey(f, dsa, NULL, NULL, 0, NULL, NULL);
        fclose(f);
#line 845 "DSA.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_p); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_p)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 373 "DSA.xs"
        const BIGNUM *p;
        char *to;
        int len;
        int bnlen;
#line 866 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_p() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 378 "DSA.xs"
        DSA_get0_pqg(dsa, &p, NULL, NULL);
        bnlen = BN_num_bytes(p);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(p, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 883 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_q); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_q)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 391 "DSA.xs"
        const BIGNUM *q;
        char *to;
        int len;
        int bnlen;
#line 904 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_q() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 396 "DSA.xs"
        DSA_get0_pqg(dsa, NULL, &q, NULL);
        bnlen = BN_num_bytes(q);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(q, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 921 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_g); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_g)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 409 "DSA.xs"
        const BIGNUM *g;
        char *to;
        int len;
        int bnlen;
#line 942 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_g() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 414 "DSA.xs"
        DSA_get0_pqg(dsa, NULL, NULL, &g);
        bnlen = BN_num_bytes(g);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(g, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 959 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_pub_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 427 "DSA.xs"
        const BIGNUM *pub_key;
        char *to;
        int len;
        int bnlen;
#line 980 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 432 "DSA.xs"
        DSA_get0_key(dsa, &pub_key, NULL);
        bnlen = BN_num_bytes(pub_key);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(pub_key, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 997 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_priv_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 445 "DSA.xs"
        const BIGNUM *priv_key;
        char *to;
        int len;
        int bnlen;
#line 1018 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 450 "DSA.xs"
        DSA_get0_key(dsa, NULL, &priv_key);
        bnlen = BN_num_bytes(priv_key);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(priv_key, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 1035 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_p); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_p)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, p_SV");
    {
	DSA *	dsa;
	SV *	p_SV = ST(1)
;
#line 464 "DSA.xs"
        STRLEN len;
        BIGNUM *p;
        BIGNUM *q;
        BIGNUM *g;
        const BIGNUM *old_q;
        const BIGNUM *old_g;
#line 1060 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_p() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 471 "DSA.xs"
        len = SvCUR(p_SV);
        p = BN_bin2bn(SvPV(p_SV, len), (int)len, NULL);
        DSA_get0_pqg(dsa, NULL, &old_q, &old_g);
        if (NULL == old_q) {
            q = BN_new();
        } else {
            q = BN_dup(old_q);
        }
        if (NULL == q) {
            BN_free(p);
            croak("Could not duplicate another prime");
        }
        if (NULL == old_g) {
            g = BN_new();
        } else {
            g = BN_dup(old_g);
        }
        if (NULL == g) {
            BN_free(p);
            BN_free(q);
            croak("Could not duplicate another prime");
        }
        if (!DSA_set0_pqg(dsa, p, q, g)) {
            BN_free(p);
            BN_free(q);
            BN_free(g);
            croak("Could not set a prime");
        }
#line 1098 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_q); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_q)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, q_SV");
    {
	DSA *	dsa;
	SV *	q_SV = ST(1)
;
#line 505 "DSA.xs"
        STRLEN len;
        BIGNUM *p;
        BIGNUM *q;
        BIGNUM *g;
        const BIGNUM *old_p;
        const BIGNUM *old_g;
#line 1121 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_q() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 512 "DSA.xs"
        len = SvCUR(q_SV);
        q = BN_bin2bn(SvPV(q_SV, len), (int)len, NULL);
        DSA_get0_pqg(dsa, &old_p, NULL, &old_g);
        if (NULL == old_p) {
            p = BN_new();
        } else {
            p = BN_dup(old_p);
        }
        if (NULL == p) {
            BN_free(q);
            croak("Could not duplicate another prime");
        }
        if (NULL == old_g) {
            g = BN_new();
        } else {
            g = BN_dup(old_g);
        }
        if (NULL == g) {
            BN_free(p);
            BN_free(q);
            croak("Could not duplicate another prime");
        }
        if (!DSA_set0_pqg(dsa, p, q, g)) {
            BN_free(p);
            BN_free(q);
            BN_free(g);
            croak("Could not set a prime");
        }
#line 1159 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_g); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_g)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, g_SV");
    {
	DSA *	dsa;
	SV *	g_SV = ST(1)
;
#line 546 "DSA.xs"
        STRLEN len;
        BIGNUM *p;
        BIGNUM *q;
        BIGNUM *g;
        const BIGNUM *old_p;
        const BIGNUM *old_q;
#line 1182 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_g() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 553 "DSA.xs"
        len = SvCUR(g_SV);
        g = BN_bin2bn(SvPV(g_SV, len), (int)len, NULL);
        DSA_get0_pqg(dsa, &old_p, &old_q, NULL);
        if (NULL == old_p) {
            p = BN_new();
        } else {
            p = BN_dup(old_p);
        }
        if (NULL == p) {
            BN_free(g);
            croak("Could not duplicate another prime");
        }
        if (NULL == old_q) {
            q = BN_new();
        } else {
            q = BN_dup(old_q);
        }
        if (NULL == q) {
            BN_free(p);
            BN_free(g);
            croak("Could not duplicate another prime");
        }
        if (!DSA_set0_pqg(dsa, p, q, g)) {
            BN_free(p);
            BN_free(q);
            BN_free(g);
            croak("Could not set a prime");
        }
#line 1220 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, pub_key_SV");
    {
	DSA *	dsa;
	SV *	pub_key_SV = ST(1)
;
#line 587 "DSA.xs"
        STRLEN len;
	    BIGNUM *pub_key;
#line 1239 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 590 "DSA.xs"
        len = SvCUR(pub_key_SV);
        pub_key = BN_bin2bn(SvPV(pub_key_SV, len), (int)len, NULL);
		if (!DSA_set0_key(dsa, pub_key, NULL)) {
			BN_free(pub_key);
			croak("Could not set a key");
		}
#line 1255 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, priv_key_SV");
    {
	DSA *	dsa;
	SV *	priv_key_SV = ST(1)
;
#line 602 "DSA.xs"
        STRLEN len;
        const BIGNUM *old_pub_key;
        BIGNUM *pub_key;
        BIGNUM *priv_key;
#line 1276 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 607 "DSA.xs"
        DSA_get0_key(dsa, &old_pub_key, NULL);
        if (NULL == old_pub_key) {
            pub_key = BN_new();
            if (NULL == pub_key) {
                croak("Could not create a dummy public key");
            }
            if (!DSA_set0_key(dsa, pub_key, NULL)) {
                BN_free(pub_key);
                croak("Could not set a dummy public key");
            }
        }
        len = SvCUR(priv_key_SV);
        priv_key = BN_bin2bn(SvPV(priv_key_SV, len), (int)len, NULL);
		if (!DSA_set0_key(dsa, NULL, priv_key)) {
			BN_free(priv_key);
			croak("Could not set a key");
		}
#line 1303 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	DSA_SIG *	RETVAL;
#line 631 "DSA.xs"
        RETVAL = DSA_SIG_new();
#line 1321 "DSA.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::DESTROY() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 639 "DSA.xs"
        DSA_SIG_free(dsa_sig);
#line 1351 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_r)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;
#line 645 "DSA.xs"
        const BIGNUM *r;
        char *to;
        int len;
        int bnlen;
#line 1370 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::get_r() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 650 "DSA.xs"
        DSA_SIG_get0(dsa_sig, &r, NULL);
        bnlen = BN_num_bytes(r);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(r, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 1387 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_s); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_s)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;
#line 663 "DSA.xs"
        const BIGNUM *s;
        char *to;
        int len;
        int bnlen;
#line 1408 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::get_s() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 668 "DSA.xs"
        DSA_SIG_get0(dsa_sig, NULL, &s);
        bnlen = BN_num_bytes(s);
        to = malloc(sizeof(char) * bnlen);
        len = BN_bn2bin(s, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 1425 "DSA.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_r)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa_sig, r_SV");
    {
	DSA_SIG *	dsa_sig;
	SV *	r_SV = ST(1)
;
#line 682 "DSA.xs"
        STRLEN len;
		BIGNUM *r;
        BIGNUM *s;
        const BIGNUM *old_s;
#line 1448 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::set_r() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 687 "DSA.xs"
        len = SvCUR(r_SV);
        r = BN_bin2bn(SvPV(r_SV, len), (int)len, NULL);
        DSA_SIG_get0(dsa_sig, NULL, &old_s);
        if (NULL == old_s) {
            s = BN_new();
        } else {
            s = BN_dup(old_s);
        }
        if (NULL == s) {
            BN_free(r);
            croak("Could not duplicate another signature value");
        }
		if (!DSA_SIG_set0(dsa_sig, r, s)) {
			BN_free(r);
            BN_free(s);
			croak("Could not set a signature");
		}
#line 1475 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_s); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_s)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa_sig, s_SV");
    {
	DSA_SIG *	dsa_sig;
	SV *	s_SV = ST(1)
;
#line 710 "DSA.xs"
        STRLEN len;
		BIGNUM *s;
		BIGNUM *r;
        const BIGNUM *old_r;
#line 1496 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::set_s() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 715 "DSA.xs"
        len = SvCUR(s_SV);
        s = BN_bin2bn(SvPV(s_SV, len), (int)len, NULL);
        DSA_SIG_get0(dsa_sig, &old_r, NULL);
        if (NULL == old_r) {
            r = BN_new();
        } else {
            r = BN_dup(old_r);
        }
        if (NULL == r) {
            BN_free(s);
            croak("Could not duplicate another signature value");
        }
		if (!DSA_SIG_set0(dsa_sig, r, s)) {
			BN_free(s);
			croak("Could not set a signature");
		}
#line 1522 "DSA.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Crypt__OpenSSL__DSA); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Crypt__OpenSSL__DSA)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Crypt::OpenSSL::DSA::new", XS_Crypt__OpenSSL__DSA_new);
        newXS_deffile("Crypt::OpenSSL::DSA::DESTROY", XS_Crypt__OpenSSL__DSA_DESTROY);
        newXS_deffile("Crypt::OpenSSL::DSA::generate_parameters", XS_Crypt__OpenSSL__DSA_generate_parameters);
        newXS_deffile("Crypt::OpenSSL::DSA::generate_key", XS_Crypt__OpenSSL__DSA_generate_key);
        newXS_deffile("Crypt::OpenSSL::DSA::get_sig_size", XS_Crypt__OpenSSL__DSA_get_sig_size);
        newXS_deffile("Crypt::OpenSSL::DSA::do_sign", XS_Crypt__OpenSSL__DSA_do_sign);
        newXS_deffile("Crypt::OpenSSL::DSA::sign", XS_Crypt__OpenSSL__DSA_sign);
        newXS_deffile("Crypt::OpenSSL::DSA::verify", XS_Crypt__OpenSSL__DSA_verify);
        newXS_deffile("Crypt::OpenSSL::DSA::do_verify", XS_Crypt__OpenSSL__DSA_do_verify);
        newXS_deffile("Crypt::OpenSSL::DSA::read_params", XS_Crypt__OpenSSL__DSA_read_params);
        newXS_deffile("Crypt::OpenSSL::DSA::write_params", XS_Crypt__OpenSSL__DSA_write_params);
        newXS_deffile("Crypt::OpenSSL::DSA::_load_key", XS_Crypt__OpenSSL__DSA__load_key);
        newXS_deffile("Crypt::OpenSSL::DSA::read_pub_key", XS_Crypt__OpenSSL__DSA_read_pub_key);
        newXS_deffile("Crypt::OpenSSL::DSA::write_pub_key", XS_Crypt__OpenSSL__DSA_write_pub_key);
        newXS_deffile("Crypt::OpenSSL::DSA::read_priv_key", XS_Crypt__OpenSSL__DSA_read_priv_key);
        newXS_deffile("Crypt::OpenSSL::DSA::write_priv_key", XS_Crypt__OpenSSL__DSA_write_priv_key);
        newXS_deffile("Crypt::OpenSSL::DSA::get_p", XS_Crypt__OpenSSL__DSA_get_p);
        newXS_deffile("Crypt::OpenSSL::DSA::get_q", XS_Crypt__OpenSSL__DSA_get_q);
        newXS_deffile("Crypt::OpenSSL::DSA::get_g", XS_Crypt__OpenSSL__DSA_get_g);
        newXS_deffile("Crypt::OpenSSL::DSA::get_pub_key", XS_Crypt__OpenSSL__DSA_get_pub_key);
        newXS_deffile("Crypt::OpenSSL::DSA::get_priv_key", XS_Crypt__OpenSSL__DSA_get_priv_key);
        newXS_deffile("Crypt::OpenSSL::DSA::set_p", XS_Crypt__OpenSSL__DSA_set_p);
        newXS_deffile("Crypt::OpenSSL::DSA::set_q", XS_Crypt__OpenSSL__DSA_set_q);
        newXS_deffile("Crypt::OpenSSL::DSA::set_g", XS_Crypt__OpenSSL__DSA_set_g);
        newXS_deffile("Crypt::OpenSSL::DSA::set_pub_key", XS_Crypt__OpenSSL__DSA_set_pub_key);
        newXS_deffile("Crypt::OpenSSL::DSA::set_priv_key", XS_Crypt__OpenSSL__DSA_set_priv_key);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::new", XS_Crypt__OpenSSL__DSA__Signature_new);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::DESTROY", XS_Crypt__OpenSSL__DSA__Signature_DESTROY);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::get_r", XS_Crypt__OpenSSL__DSA__Signature_get_r);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::get_s", XS_Crypt__OpenSSL__DSA__Signature_get_s);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::set_r", XS_Crypt__OpenSSL__DSA__Signature_set_r);
        newXS_deffile("Crypt::OpenSSL::DSA::Signature::set_s", XS_Crypt__OpenSSL__DSA__Signature_set_s);

    /* Initialisation Section */

#line 116 "DSA.xs"
#if OPENSSL_VERSION_NUMBER < 0x10100000L
    ERR_load_crypto_strings();
#endif

#line 1595 "DSA.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
