#include <octave/oct.h>
#include <cgreen/cgreen.h>

#include "../../Permute_event_fcn.h"
#include "../assert_octave.h"

using namespace cgreen;

double data_event [] = {1,2,3,4,5,6,7,8,9,10};

Ensure (scrambling_does_not_alter_this_data)
{
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_event, sizeof (data_event));
  Matrix data_original (mat);
  Permute_event_fcn perm_f (&mat);

  // Perform test
  perm_f.scramble ();

  assert_matrix_equal_with_tol (mat, data_original, 0);
}

Ensure (permute_n1_is_never_0_or_9)
{
  Matrix mat (10,1);
  memcpy (mat.fortran_vec (), data_event, sizeof (data_event));
  Permute_event_fcn perm_f (&mat);

  // Perform test
  bool is_not_0_or_9 = true;
  for (octave_idx_type i = 0; i < 30; i++)
    {
      octave_idx_type n1, n2;
      perm_f.permute (n1, n2);
      if (n1 == 0 || n1 == 9)
        is_not_0_or_9 = false;
    }

  assert_that (is_not_0_or_9, is_true);
}

Ensure (exch_for_set_1_3_9_sets_3_to_7)
{
  Matrix mat (3,1);
  mat(0) = 1;
  mat(1) = 3;
  mat(2) = 9;
  Permute_event_fcn perm_f (&mat);

  // Perform test
  perm_f.exch (1,0);

  assert_that_double (mat(1), is_equal_to_double (7));
}

void prepare_permute_event()
{
  srand (time (NULL));
}

TestSuite *permute_event_tests ()
{
  TestSuite *suite = create_test_suite ();
  set_setup (suite, prepare_permute_event);
  add_test (suite, scrambling_does_not_alter_this_data);
  add_test (suite, permute_n1_is_never_0_or_9);
  add_test (suite, exch_for_set_1_3_9_sets_3_to_7);
  return suite;
}
