/**
Copyright (c) 2012-2020, Brice Videau <bvideau@anl.gov>
Copyright (c) 2012-2020, Vincent Danjean <Vincent.Danjean@ens-lyon.org>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Do not edit this file. It is automatically generated.

*/
#include <string.h>
#include "ocl_icd_loader.h"
#define DEBUG_OCL_ICD_PROVIDE_DUMP_FIELD
#include "ocl_icd_debug.h"
#define hidden_alias(name) \
  typeof(name) name##_hid __attribute__ ((alias (#name), visibility("hidden")))
__attribute__((visibility("hidden")))  cl_int  
clGetPlatformInfo_disp(cl_platform_id    platform , 
                  cl_platform_info  param_name ,
                  size_t            param_value_size , 
                  void *            param_value ,
                  size_t *          param_value_size_ret ){
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetPlatformInfo(platform, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetDeviceIDs_disp(cl_platform_id    platform ,
               cl_device_type    device_type , 
               cl_uint           num_entries , 
               cl_device_id *    devices , 
               cl_uint *         num_devices ){
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetDeviceIDs(platform, device_type, num_entries, devices, num_devices));
}

__attribute__((visibility("hidden")))  cl_int 
clGetDeviceInfo_disp(cl_device_id     device ,
                cl_device_info   param_name , 
                size_t           param_value_size , 
                void *           param_value ,
                size_t *         param_value_size_ret ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceInfo(device, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainContext_disp(cl_context  context ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clRetainContext(context));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseContext_disp(cl_context  context ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clReleaseContext(context));
}

__attribute__((visibility("hidden")))  cl_int 
clGetContextInfo_disp(cl_context          context , 
                 cl_context_info     param_name , 
                 size_t              param_value_size , 
                 void *              param_value , 
                 size_t *            param_value_size_ret ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetContextInfo(context, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_command_queue 
clCreateCommandQueue_disp(cl_context                      context , 
                     cl_device_id                    device , 
                     cl_command_queue_properties     properties ,
                     cl_int *                        errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueue(context, device, properties, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainCommandQueue_disp(cl_command_queue  command_queue ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clRetainCommandQueue(command_queue));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseCommandQueue_disp(cl_command_queue  command_queue ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clReleaseCommandQueue(command_queue));
}

__attribute__((visibility("hidden")))  cl_int 
clGetCommandQueueInfo_disp(cl_command_queue       command_queue ,
                      cl_command_queue_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clGetCommandQueueInfo(command_queue, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetCommandQueueProperty_disp(cl_command_queue               command_queue ,
                          cl_command_queue_properties    properties , 
                          cl_bool                         enable ,
                          cl_command_queue_properties *  old_properties ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clSetCommandQueueProperty(command_queue, properties, enable, old_properties));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateBuffer_disp(cl_context    context ,
               cl_mem_flags  flags ,
               size_t        size ,
               void *        host_ptr ,
               cl_int *      errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateBuffer(context, flags, size, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateImage2D_disp(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width ,
                size_t                   image_height ,
                size_t                   image_row_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage2D(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateImage3D_disp(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width , 
                size_t                   image_height ,
                size_t                   image_depth , 
                size_t                   image_row_pitch , 
                size_t                   image_slice_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage3D(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainMemObject_disp(cl_mem  memobj ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clRetainMemObject(memobj));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseMemObject_disp(cl_mem  memobj ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clReleaseMemObject(memobj));
}

__attribute__((visibility("hidden")))  cl_int 
clGetSupportedImageFormats_disp(cl_context            context ,
                           cl_mem_flags          flags ,
                           cl_mem_object_type    image_type ,
                           cl_uint               num_entries ,
                           cl_image_format *     image_formats ,
                           cl_uint *             num_image_formats ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetSupportedImageFormats(context, flags, image_type, num_entries, image_formats, num_image_formats));
}

__attribute__((visibility("hidden")))  cl_int 
clGetMemObjectInfo_disp(cl_mem            memobj ,
                   cl_mem_info       param_name , 
                   size_t            param_value_size ,
                   void *            param_value ,
                   size_t *          param_value_size_ret ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetMemObjectInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetImageInfo_disp(cl_mem            image ,
               cl_image_info     param_name , 
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  if( (struct _cl_mem *)image == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)image)->dispatch->clGetImageInfo(image, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_sampler 
clCreateSampler_disp(cl_context           context ,
                cl_bool              normalized_coords , 
                cl_addressing_mode   addressing_mode , 
                cl_filter_mode       filter_mode ,
                cl_int *             errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSampler(context, normalized_coords, addressing_mode, filter_mode, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainSampler_disp(cl_sampler  sampler ){
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clRetainSampler(sampler));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseSampler_disp(cl_sampler  sampler ){
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clReleaseSampler(sampler));
}

__attribute__((visibility("hidden")))  cl_int 
clGetSamplerInfo_disp(cl_sampler          sampler ,
                 cl_sampler_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clGetSamplerInfo(sampler, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_program 
clCreateProgramWithSource_disp(cl_context         context ,
                          cl_uint            count ,
                          const char **      strings ,
                          const size_t *     lengths ,
                          cl_int *           errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithSource(context, count, strings, lengths, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_program 
clCreateProgramWithBinary_disp(cl_context                      context ,
                          cl_uint                         num_devices ,
                          const cl_device_id *            device_list ,
                          const size_t *                  lengths ,
                          const unsigned char **          binaries ,
                          cl_int *                        binary_status ,
                          cl_int *                        errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBinary(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainProgram_disp(cl_program  program ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clRetainProgram(program));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseProgram_disp(cl_program  program ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clReleaseProgram(program));
}

__attribute__((visibility("hidden")))  cl_int 
clBuildProgram_disp(cl_program            program ,
               cl_uint               num_devices ,
               const cl_device_id *  device_list ,
               const char *          options , 
               void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
               void *                user_data ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clBuildProgram(program, num_devices, device_list, options, pfn_notify, user_data));
}

__attribute__((visibility("hidden")))  cl_int 
clGetProgramInfo_disp(cl_program          program ,
                 cl_program_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramInfo(program, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetProgramBuildInfo_disp(cl_program             program ,
                      cl_device_id           device ,
                      cl_program_build_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramBuildInfo(program, device, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_kernel 
clCreateKernel_disp(cl_program       program ,
               const char *     kernel_name ,
               cl_int *         errcode_ret ){
  if( (struct _cl_program *)program == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_PROGRAM;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernel(program, kernel_name, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clCreateKernelsInProgram_disp(cl_program      program ,
                         cl_uint         num_kernels ,
                         cl_kernel *     kernels ,
                         cl_uint *       num_kernels_ret ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernelsInProgram(program, num_kernels, kernels, num_kernels_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainKernel_disp(cl_kernel     kernel ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clRetainKernel(kernel));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseKernel_disp(cl_kernel    kernel ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clReleaseKernel(kernel));
}

__attribute__((visibility("hidden")))  cl_int 
clSetKernelArg_disp(cl_kernel     kernel ,
               cl_uint       arg_index ,
               size_t        arg_size ,
               const void *  arg_value ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArg(kernel, arg_index, arg_size, arg_value));
}

__attribute__((visibility("hidden")))  cl_int 
clGetKernelInfo_disp(cl_kernel        kernel ,
                cl_kernel_info   param_name ,
                size_t           param_value_size ,
                void *           param_value ,
                size_t *         param_value_size_ret ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelInfo(kernel, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetKernelWorkGroupInfo_disp(cl_kernel                   kernel ,
                         cl_device_id                device ,
                         cl_kernel_work_group_info   param_name ,
                         size_t                      param_value_size ,
                         void *                      param_value ,
                         size_t *                    param_value_size_ret ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetEventInfo_disp(cl_event          event ,
               cl_event_info     param_name ,
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainEvent_disp(cl_event  event ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clRetainEvent(event));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseEvent_disp(cl_event  event ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clReleaseEvent(event));
}

__attribute__((visibility("hidden")))  cl_int 
clGetEventProfilingInfo_disp(cl_event             event ,
                        cl_profiling_info    param_name ,
                        size_t               param_value_size ,
                        void *               param_value ,
                        size_t *             param_value_size_ret ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventProfilingInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clFlush_disp(cl_command_queue  command_queue ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFlush(command_queue));
}

__attribute__((visibility("hidden")))  cl_int 
clFinish_disp(cl_command_queue  command_queue ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFinish(command_queue));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueReadBuffer_disp(cl_command_queue     command_queue ,
                    cl_mem               buffer ,
                    cl_bool              blocking_read ,
                    size_t               offset ,
                    size_t               cb , 
                    void *               ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueWriteBuffer_disp(cl_command_queue    command_queue , 
                     cl_mem              buffer , 
                     cl_bool             blocking_write , 
                     size_t              offset , 
                     size_t              cb , 
                     const void *        ptr , 
                     cl_uint             num_events_in_wait_list , 
                     const cl_event *    event_wait_list , 
                     cl_event *          event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueCopyBuffer_disp(cl_command_queue     command_queue , 
                    cl_mem               src_buffer ,
                    cl_mem               dst_buffer , 
                    size_t               src_offset ,
                    size_t               dst_offset ,
                    size_t               cb , 
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, cb, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueReadImage_disp(cl_command_queue      command_queue ,
                   cl_mem                image ,
                   cl_bool               blocking_read , 
                   const size_t *        origin ,
                   const size_t *        region ,
                   size_t                row_pitch ,
                   size_t                slice_pitch , 
                   void *                ptr ,
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadImage(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueWriteImage_disp(cl_command_queue     command_queue ,
                    cl_mem               image ,
                    cl_bool              blocking_write , 
                    const size_t *       origin ,
                    const size_t *       region ,
                    size_t               input_row_pitch ,
                    size_t               input_slice_pitch , 
                    const void *         ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteImage(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueCopyImage_disp(cl_command_queue      command_queue ,
                   cl_mem                src_image ,
                   cl_mem                dst_image , 
                   const size_t *        src_origin ,
                   const size_t *        dst_origin ,
                   const size_t *        region , 
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImage(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueCopyImageToBuffer_disp(cl_command_queue  command_queue ,
                           cl_mem            src_image ,
                           cl_mem            dst_buffer , 
                           const size_t *    src_origin ,
                           const size_t *    region , 
                           size_t            dst_offset ,
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueCopyBufferToImage_disp(cl_command_queue  command_queue ,
                           cl_mem            src_buffer ,
                           cl_mem            dst_image , 
                           size_t            src_offset ,
                           const size_t *    dst_origin ,
                           const size_t *    region , 
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  void * 
clEnqueueMapBuffer_disp(cl_command_queue  command_queue ,
                   cl_mem            buffer ,
                   cl_bool           blocking_map , 
                   cl_map_flags      map_flags ,
                   size_t            offset ,
                   size_t            cb ,
                   cl_uint           num_events_in_wait_list ,
                   const cl_event *  event_wait_list ,
                   cl_event *        event ,
                   cl_int *          errcode_ret ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

__attribute__((visibility("hidden")))  void * 
clEnqueueMapImage_disp(cl_command_queue   command_queue ,
                  cl_mem             image , 
                  cl_bool            blocking_map , 
                  cl_map_flags       map_flags , 
                  const size_t *     origin ,
                  const size_t *     region ,
                  size_t *           image_row_pitch ,
                  size_t *           image_slice_pitch ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ,
                  cl_int *           errcode_ret ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapImage(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueUnmapMemObject_disp(cl_command_queue  command_queue ,
                        cl_mem            memobj ,
                        void *            mapped_ptr ,
                        cl_uint           num_events_in_wait_list ,
                        const cl_event *   event_wait_list ,
                        cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueUnmapMemObject(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueNDRangeKernel_disp(cl_command_queue  command_queue ,
                       cl_kernel         kernel ,
                       cl_uint           work_dim ,
                       const size_t *    global_work_offset ,
                       const size_t *    global_work_size ,
                       const size_t *    local_work_size ,
                       cl_uint           num_events_in_wait_list ,
                       const cl_event *  event_wait_list ,
                       cl_event *        event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNDRangeKernel(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueTask_disp(cl_command_queue   command_queue ,
              cl_kernel          kernel ,
              cl_uint            num_events_in_wait_list ,
              const cl_event *   event_wait_list ,
              cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueTask(command_queue, kernel, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueNativeKernel_disp(cl_command_queue   command_queue ,
					  void (*user_func)(void *), 
                      void *             args ,
                      size_t             cb_args , 
                      cl_uint            num_mem_objects ,
                      const cl_mem *     mem_list ,
                      const void **      args_mem_loc ,
                      cl_uint            num_events_in_wait_list ,
                      const cl_event *   event_wait_list ,
                      cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNativeKernel(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueMarker_disp(cl_command_queue     command_queue ,
                cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarker(command_queue, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueWaitForEvents_disp(cl_command_queue  command_queue ,
                       cl_uint           num_events ,
                       const cl_event *  event_list ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWaitForEvents(command_queue, num_events, event_list));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueBarrier_disp(cl_command_queue  command_queue ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrier(command_queue));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromGLBuffer_disp(cl_context      context ,
                     cl_mem_flags    flags ,
                     cl_GLuint       bufobj ,
                     int *           errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLBuffer(context, flags, bufobj, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromGLTexture2D_disp(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture2D(context, flags, target, miplevel, texture, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromGLTexture3D_disp(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture3D(context, flags, target, miplevel, texture, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromGLRenderbuffer_disp(cl_context    context ,
                           cl_mem_flags  flags ,
                           cl_GLuint     renderbuffer ,
                           cl_int *      errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLRenderbuffer(context, flags, renderbuffer, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetGLObjectInfo_disp(cl_mem                 memobj ,
                  cl_gl_object_type *    gl_object_type ,
                  cl_GLuint *               gl_object_name ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLObjectInfo(memobj, gl_object_type, gl_object_name));
}

__attribute__((visibility("hidden")))  cl_int 
clGetGLTextureInfo_disp(cl_mem                memobj ,
                   cl_gl_texture_info    param_name ,
                   size_t                param_value_size ,
                   void *                param_value ,
                   size_t *              param_value_size_ret ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLTextureInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueAcquireGLObjects_disp(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueReleaseGLObjects_disp(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clSetEventCallback_disp(cl_event     event ,
                   cl_int       command_exec_callback_type ,
                   void (CL_CALLBACK *  pfn_notify )(cl_event, cl_int, void *),
                   void *       user_data ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetEventCallback(event, command_exec_callback_type, pfn_notify, user_data));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateSubBuffer_disp(cl_mem                    buffer ,
                  cl_mem_flags              flags ,
                  cl_buffer_create_type     buffer_create_type ,
                  const void *              buffer_create_info ,
                  cl_int *                  errcode_ret ){
  if( (struct _cl_mem *)buffer == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_MEM_OBJECT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_mem *)buffer)->dispatch->clCreateSubBuffer(buffer, flags, buffer_create_type, buffer_create_info, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetMemObjectDestructorCallback_disp(cl_mem  memobj ,
                                 void (CL_CALLBACK * pfn_notify)( cl_mem  memobj , void* user_data),
                                 void * user_data  ){
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clSetMemObjectDestructorCallback(memobj, pfn_notify, user_data));
}

__attribute__((visibility("hidden")))  cl_event 
clCreateUserEvent_disp(cl_context     context ,
                  cl_int *       errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateUserEvent(context, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetUserEventStatus_disp(cl_event    event ,
                     cl_int      execution_status ){
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetUserEventStatus(event, execution_status));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueReadBufferRect_disp(cl_command_queue     command_queue ,
                        cl_mem               buffer ,
                        cl_bool              blocking_read ,
                        const size_t *       buffer_origin ,
                        const size_t *       host_origin , 
                        const size_t *       region ,
                        size_t               buffer_row_pitch ,
                        size_t               buffer_slice_pitch ,
                        size_t               host_row_pitch ,
                        size_t               host_slice_pitch ,                        
                        void *               ptr ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBufferRect(command_queue, buffer, blocking_read, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueWriteBufferRect_disp(cl_command_queue     command_queue ,
                         cl_mem               buffer ,
                         cl_bool              blocking_write ,
                         const size_t *       buffer_origin ,
                         const size_t *       host_origin , 
                         const size_t *       region ,
                         size_t               buffer_row_pitch ,
                         size_t               buffer_slice_pitch ,
                         size_t               host_row_pitch ,
                         size_t               host_slice_pitch ,                        
                         const void *         ptr ,
                         cl_uint              num_events_in_wait_list ,
                         const cl_event *     event_wait_list ,
                         cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBufferRect(command_queue, buffer, blocking_write, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueCopyBufferRect_disp(cl_command_queue     command_queue , 
                        cl_mem               src_buffer ,
                        cl_mem               dst_buffer , 
                        const size_t *       src_origin ,
                        const size_t *       dst_origin ,
                        const size_t *       region , 
                        size_t               src_row_pitch ,
                        size_t               src_slice_pitch ,
                        size_t               dst_row_pitch ,
                        size_t               dst_slice_pitch ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clCreateSubDevicesEXT_disp(cl_device_id in_device,
                      const cl_device_partition_property_ext *  properties ,
                      cl_uint num_entries,
                      cl_device_id * out_devices,
                      cl_uint * num_devices ){
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevicesEXT(in_device, properties, num_entries, out_devices, num_devices));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainDeviceEXT_disp( cl_device_id device ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDeviceEXT(device));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseDeviceEXT_disp( cl_device_id device ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDeviceEXT(device));
}

__attribute__((visibility("hidden")))  cl_event 
clCreateEventFromGLsyncKHR_disp(cl_context            context ,
                           cl_GLsync             cl_GLsync ,
                           cl_int *              errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromGLsyncKHR(context, cl_GLsync, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clCreateSubDevices_disp(cl_device_id                          in_device ,
                   const cl_device_partition_property *  properties ,
                   cl_uint                               num_devices ,
                   cl_device_id *                        out_devices ,
                   cl_uint *                             num_devices_ret ){
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevices(in_device, properties, num_devices, out_devices, num_devices_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clRetainDevice_disp(cl_device_id  device ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDevice(device));
}

__attribute__((visibility("hidden")))  cl_int 
clReleaseDevice_disp(cl_device_id  device ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDevice(device));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateImage_disp(cl_context               context ,
              cl_mem_flags             flags ,
              const cl_image_format *  image_format ,
              const cl_image_desc *    image_desc , 
              void *                   host_ptr ,
              cl_int *                 errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage(context, flags, image_format, image_desc, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_program 
clCreateProgramWithBuiltInKernels_disp(cl_context             context ,
                                  cl_uint                num_devices ,
                                  const cl_device_id *   device_list ,
                                  const char *           kernel_names ,
                                  cl_int *               errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBuiltInKernels(context, num_devices, device_list, kernel_names, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clCompileProgram_disp(cl_program            program ,
                 cl_uint               num_devices ,
                 const cl_device_id *  device_list ,
                 const char *          options , 
                 cl_uint               num_input_headers ,
                 const cl_program *    input_headers ,
                 const char **         header_include_names ,
                 void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
                 void *                user_data ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCompileProgram(program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data));
}

__attribute__((visibility("hidden")))  cl_program 
clLinkProgram_disp(cl_context            context ,
              cl_uint               num_devices ,
              const cl_device_id *  device_list ,
              const char *          options , 
              cl_uint               num_input_programs ,
              const cl_program *    input_programs ,
              void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
              void *                user_data ,
              cl_int *              errcode_ret  ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clLinkProgram(context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clUnloadPlatformCompiler_disp(cl_platform_id  platform ){
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clUnloadPlatformCompiler(platform));
}

__attribute__((visibility("hidden")))  cl_int 
clGetKernelArgInfo_disp(cl_kernel        kernel ,
                   cl_uint          arg_indx ,
                   cl_kernel_arg_info   param_name ,
                   size_t           param_value_size ,
                   void *           param_value ,
                   size_t *         param_value_size_ret ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueFillBuffer_disp(cl_command_queue    command_queue ,
                    cl_mem              buffer , 
                    const void *        pattern , 
                    size_t              pattern_size , 
                    size_t              offset , 
                    size_t              size , 
                    cl_uint             num_events_in_wait_list , 
                    const cl_event *    event_wait_list , 
                    cl_event *          event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillBuffer(command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueFillImage_disp(cl_command_queue    command_queue ,
                   cl_mem              image , 
                   const void *        fill_color , 
                   const size_t *      origin , 
                   const size_t *      region , 
                   cl_uint             num_events_in_wait_list , 
                   const cl_event *    event_wait_list , 
                   cl_event *          event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillImage(command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueMigrateMemObjects_disp(cl_command_queue        command_queue ,
                           cl_uint                 num_mem_objects ,
                           const cl_mem *          mem_objects ,
                           cl_mem_migration_flags  flags ,
                           cl_uint                 num_events_in_wait_list ,
                           const cl_event *        event_wait_list ,
                           cl_event *              event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMigrateMemObjects(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueMarkerWithWaitList_disp(cl_command_queue  command_queue ,
                            cl_uint            num_events_in_wait_list ,
                            const cl_event *   event_wait_list ,
                            cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueBarrierWithWaitList_disp(cl_command_queue  command_queue ,
                             cl_uint            num_events_in_wait_list ,
                             const cl_event *   event_wait_list ,
                             cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  void *  
clGetExtensionFunctionAddressForPlatform_disp(cl_platform_id  platform ,
                                         const char *    func_name ){
  if( func_name == NULL )
    return NULL;
  struct func_desc const * fn=&function_description[0];
  int lenfn=strlen(func_name);
  if (lenfn > 3 &&
      (strcmp(func_name+lenfn-3, "KHR")==0 || strcmp(func_name+lenfn-3, "EXT")==0)) {
    while (fn->name != NULL) {
      if (strcmp(func_name, fn->name)==0)
        RETURN(fn->addr);
      fn++;
    }
  }
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetExtensionFunctionAddressForPlatform(platform, func_name));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromGLTexture_disp(cl_context       context ,
                      cl_mem_flags     flags ,
                      cl_GLenum        target ,
                      cl_GLint         miplevel ,
                      cl_GLuint        texture ,
                      cl_int *         errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture(context, flags, target, miplevel, texture, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateFromEGLImageKHR_disp(cl_context                   context ,
                        CLeglDisplayKHR              egldisplay ,
                        CLeglImageKHR                eglimage ,
                        cl_mem_flags                 flags ,
                        const cl_egl_image_properties_khr *  properties ,
                        cl_int *                     errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromEGLImageKHR(context, egldisplay, eglimage, flags, properties, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueAcquireEGLObjectsKHR_disp(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueReleaseEGLObjectsKHR_disp(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_event 
clCreateEventFromEGLSyncKHR_disp(cl_context       context ,
                            CLeglSyncKHR     sync ,
                            CLeglDisplayKHR  display ,
                            cl_int *         errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromEGLSyncKHR(context, sync, display, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_command_queue 
clCreateCommandQueueWithProperties_disp(cl_context                context ,
                                   cl_device_id              device ,
                                   const cl_queue_properties *     properties ,
                                   cl_int *                  errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueueWithProperties(context, device, properties, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreatePipe_disp(cl_context                  context ,
             cl_mem_flags                flags ,
             cl_uint                     pipe_packet_size ,
             cl_uint                     pipe_max_packets ,
             const cl_pipe_properties *  properties ,
             cl_int *                    errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clGetPipeInfo_disp(cl_mem            pipe ,
              cl_pipe_info      param_name ,
              size_t            param_value_size ,
              void *            param_value ,
              size_t *          param_value_size_ret ){
  if( (struct _cl_mem *)pipe == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)pipe)->dispatch->clGetPipeInfo(pipe, param_name, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  void * 
clSVMAlloc_disp(cl_context        context ,
           cl_svm_mem_flags  flags ,
           size_t            size ,
           cl_uint           alignment ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSVMAlloc(context, flags, size, alignment));
}

__attribute__((visibility("hidden")))  void 
clSVMFree_disp(cl_context         context ,
          void *             svm_pointer ){
  if( (struct _cl_context *)context == NULL) {
    return;
  }
  return(((struct _cl_context *)context)->dispatch->clSVMFree(context, svm_pointer));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMFree_disp(cl_command_queue   command_queue ,
                 cl_uint            num_svm_pointers ,
                 void *             svm_pointers[] ,
                 void (CL_CALLBACK * pfn_free_func)(cl_command_queue  queue ,
                                                        cl_uint           num_svm_pointers ,
                                                        void *            svm_pointers[] ,
                                                        void *            user_data ),
                 void *             user_data ,
                 cl_uint            num_events_in_wait_list ,
                 const cl_event *   event_wait_list ,
                 cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMFree(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMMemcpy_disp(cl_command_queue   command_queue ,
                   cl_bool            blocking_copy ,
                   void *             dst_ptr ,
                   const void *       src_ptr ,
                   size_t             size ,
                   cl_uint            num_events_in_wait_list ,
                   const cl_event *   event_wait_list ,
                   cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemcpy(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMMemFill_disp(cl_command_queue   command_queue ,
                    void *             svm_ptr ,
                    const void *       pattern ,
                    size_t             pattern_size ,
                    size_t             size ,
                    cl_uint            num_events_in_wait_list ,
                    const cl_event *   event_wait_list ,
                    cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemFill(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMMap_disp(cl_command_queue   command_queue ,
                cl_bool            blocking_map ,
                cl_map_flags       flags ,
                void *             svm_ptr ,
                size_t             size ,
                cl_uint            num_events_in_wait_list ,
                const cl_event *   event_wait_list ,
                cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMap(command_queue, blocking_map, flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMUnmap_disp(cl_command_queue   command_queue ,
                  void *             svm_ptr ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMUnmap(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_sampler 
clCreateSamplerWithProperties_disp(cl_context                      context ,
                              const cl_sampler_properties *   normalized_coords ,
                              cl_int *                        errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSamplerWithProperties(context, normalized_coords, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetKernelArgSVMPointer_disp(cl_kernel     kernel ,
                         cl_uint       arg_index ,
                         const void *  arg_value ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArgSVMPointer(kernel, arg_index, arg_value));
}

__attribute__((visibility("hidden")))  cl_int 
clSetKernelExecInfo_disp(cl_kernel             kernel ,
                    cl_kernel_exec_info   param_name ,
                    size_t                param_value_size ,
                    const void *          param_value ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelExecInfo(kernel, param_name, param_value_size, param_value));
}

__attribute__((visibility("hidden")))  cl_int 
clGetKernelSubGroupInfoKHR_disp(cl_kernel  in_kernel ,
                           cl_device_id in_device,
                           cl_kernel_sub_group_info  param_name ,
                           size_t input_value_size,
                           const void * input_value,
                           size_t param_value_size,
                           void* param_value,
                           size_t* param_value_size_ret ){
  if( (struct _cl_kernel *)in_kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)in_kernel)->dispatch->clGetKernelSubGroupInfoKHR(in_kernel, in_device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_kernel 
clCloneKernel_disp(cl_kernel      source_kernel ,
              cl_int*        errcode_ret ){
  if( (struct _cl_kernel *)source_kernel == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_KERNEL;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_kernel *)source_kernel)->dispatch->clCloneKernel(source_kernel, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_program 
clCreateProgramWithIL_disp(cl_context     context ,
                      const void*     il ,
                      size_t          length ,
                      cl_int*         errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithIL(context, il, length, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clEnqueueSVMMigrateMem_disp(cl_command_queue          command_queue ,
                       cl_uint                   num_svm_pointers ,
                       const void **             svm_pointers ,
                       const size_t *            sizes ,
                       cl_mem_migration_flags    flags ,
                       cl_uint                   num_events_in_wait_list ,
                       const cl_event *          event_wait_list ,
                       cl_event *                event ){
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMigrateMem(command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event));
}

__attribute__((visibility("hidden")))  cl_int 
clGetDeviceAndHostTimer_disp(cl_device_id     device ,
                        cl_ulong*        device_timestamp ,
                        cl_ulong*        host_timestamp ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceAndHostTimer(device, device_timestamp, host_timestamp));
}

__attribute__((visibility("hidden")))  cl_int 
clGetHostTimer_disp(cl_device_id  device ,
               cl_ulong *    host_timestamp ){
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetHostTimer(device, host_timestamp));
}

__attribute__((visibility("hidden")))  cl_int 
clGetKernelSubGroupInfo_disp(cl_kernel                    kernel ,
                        cl_device_id                 device ,
                        cl_kernel_sub_group_info     param_name ,
                        size_t                       input_value_size ,
                        const void*                  input_value ,
                        size_t                       param_value_size ,
                        void*                        param_value ,
                        size_t*                      param_value_size_ret  ){
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetDefaultDeviceCommandQueue_disp(cl_context            context ,
                               cl_device_id          device ,
                               cl_command_queue      command_queue ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSetDefaultDeviceCommandQueue(context, device, command_queue));
}

__attribute__((visibility("hidden")))  cl_int 
clSetProgramReleaseCallback_disp(cl_program           program ,
                            void (CL_CALLBACK *  pfn_notify )(cl_program  program , void *  user_data ),
                            void *               user_data ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramReleaseCallback(program, pfn_notify, user_data));
}

__attribute__((visibility("hidden")))  cl_int 
clSetProgramSpecializationConstant_disp(cl_program   program ,
                                   cl_uint      spec_id ,
                                   size_t       spec_size ,
                                   const void*  spec_value ){
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramSpecializationConstant(program, spec_id, spec_size, spec_value));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateBufferWithProperties_disp(cl_context                 context ,
                             const cl_mem_properties *  properties ,
                             cl_mem_flags               flags ,
                             size_t                     size ,
                             void *                     host_ptr ,
                             cl_int *                   errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateBufferWithProperties(context, properties, flags, size, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_mem 
clCreateImageWithProperties_disp(cl_context                 context ,
                            const cl_mem_properties *  properties ,
                            cl_mem_flags               flags ,
                            const cl_image_format *    image_format ,
                            const cl_image_desc *      image_desc ,
                            void *                     host_ptr ,
                            cl_int *                   errcode_ret ){
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImageWithProperties(context, properties, flags, image_format, image_desc, host_ptr, errcode_ret));
}

__attribute__((visibility("hidden")))  cl_int 
clSetContextDestructorCallback_disp(cl_context           context ,
                               void (CL_CALLBACK *  pfn_notify )(cl_context  context , void*  user_data ),
                               void *               user_data ){
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSetContextDestructorCallback(context, pfn_notify, user_data));
}

CL_API_ENTRY cl_int CL_API_CALL 
clGetPlatformInfo(cl_platform_id    platform , 
                  cl_platform_info  param_name ,
                  size_t            param_value_size , 
                  void *            param_value ,
                  size_t *          param_value_size_ret ){
  debug_trace();
  _initClIcd_no_inline();
  if (_first_layer)
    return _first_layer->dispatch.clGetPlatformInfo(platform, param_name, param_value_size, param_value, param_value_size_ret);
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetPlatformInfo(platform, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceIDs(cl_platform_id    platform ,
               cl_device_type    device_type , 
               cl_uint           num_entries , 
               cl_device_id *    devices , 
               cl_uint *         num_devices ){
  debug_trace();
  _initClIcd_no_inline();
  if (_first_layer)
    return _first_layer->dispatch.clGetDeviceIDs(platform, device_type, num_entries, devices, num_devices);
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetDeviceIDs(platform, device_type, num_entries, devices, num_devices));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceInfo(cl_device_id     device ,
                cl_device_info   param_name , 
                size_t           param_value_size , 
                void *           param_value ,
                size_t *         param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetDeviceInfo(device, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceInfo(device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainContext(cl_context  context ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainContext(context);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clRetainContext(context));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseContext(cl_context  context ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseContext(context);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clReleaseContext(context));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetContextInfo(cl_context          context , 
                 cl_context_info     param_name , 
                 size_t              param_value_size , 
                 void *              param_value , 
                 size_t *            param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetContextInfo(context, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetContextInfo(context, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_command_queue CL_API_CALL
clCreateCommandQueue(cl_context                      context , 
                     cl_device_id                    device , 
                     cl_command_queue_properties     properties ,
                     cl_int *                        errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateCommandQueue(context, device, properties, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueue(context, device, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainCommandQueue(cl_command_queue  command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainCommandQueue(command_queue);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clRetainCommandQueue(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseCommandQueue(cl_command_queue  command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseCommandQueue(command_queue);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clReleaseCommandQueue(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetCommandQueueInfo(cl_command_queue       command_queue ,
                      cl_command_queue_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetCommandQueueInfo(command_queue, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clGetCommandQueueInfo(command_queue, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetCommandQueueProperty(cl_command_queue               command_queue ,
                          cl_command_queue_properties    properties , 
                          cl_bool                         enable ,
                          cl_command_queue_properties *  old_properties ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetCommandQueueProperty(command_queue, properties, enable, old_properties);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clSetCommandQueueProperty(command_queue, properties, enable, old_properties));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateBuffer(cl_context    context ,
               cl_mem_flags  flags ,
               size_t        size ,
               void *        host_ptr ,
               cl_int *      errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateBuffer(context, flags, size, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateBuffer(context, flags, size, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage2D(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width ,
                size_t                   image_height ,
                size_t                   image_row_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateImage2D(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage2D(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage3D(cl_context               context ,
                cl_mem_flags             flags ,
                const cl_image_format *  image_format ,
                size_t                   image_width , 
                size_t                   image_height ,
                size_t                   image_depth , 
                size_t                   image_row_pitch , 
                size_t                   image_slice_pitch , 
                void *                   host_ptr ,
                cl_int *                 errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateImage3D(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage3D(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainMemObject(cl_mem  memobj ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainMemObject(memobj);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clRetainMemObject(memobj));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseMemObject(cl_mem  memobj ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseMemObject(memobj);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clReleaseMemObject(memobj));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetSupportedImageFormats(cl_context            context ,
                           cl_mem_flags          flags ,
                           cl_mem_object_type    image_type ,
                           cl_uint               num_entries ,
                           cl_image_format *     image_formats ,
                           cl_uint *             num_image_formats ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetSupportedImageFormats(context, flags, image_type, num_entries, image_formats, num_image_formats);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clGetSupportedImageFormats(context, flags, image_type, num_entries, image_formats, num_image_formats));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetMemObjectInfo(cl_mem            memobj ,
                   cl_mem_info       param_name , 
                   size_t            param_value_size ,
                   void *            param_value ,
                   size_t *          param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetMemObjectInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetMemObjectInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetImageInfo(cl_mem            image ,
               cl_image_info     param_name , 
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetImageInfo(image, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_mem *)image == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)image)->dispatch->clGetImageInfo(image, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_sampler CL_API_CALL
clCreateSampler(cl_context           context ,
                cl_bool              normalized_coords , 
                cl_addressing_mode   addressing_mode , 
                cl_filter_mode       filter_mode ,
                cl_int *             errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateSampler(context, normalized_coords, addressing_mode, filter_mode, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSampler(context, normalized_coords, addressing_mode, filter_mode, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainSampler(cl_sampler  sampler ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainSampler(sampler);
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clRetainSampler(sampler));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseSampler(cl_sampler  sampler ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseSampler(sampler);
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clReleaseSampler(sampler));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetSamplerInfo(cl_sampler          sampler ,
                 cl_sampler_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetSamplerInfo(sampler, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_sampler *)sampler == NULL) {
    RETURN(CL_INVALID_SAMPLER);
  }
  RETURN(((struct _cl_sampler *)sampler)->dispatch->clGetSamplerInfo(sampler, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithSource(cl_context         context ,
                          cl_uint            count ,
                          const char **      strings ,
                          const size_t *     lengths ,
                          cl_int *           errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateProgramWithSource(context, count, strings, lengths, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithSource(context, count, strings, lengths, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithBinary(cl_context                      context ,
                          cl_uint                         num_devices ,
                          const cl_device_id *            device_list ,
                          const size_t *                  lengths ,
                          const unsigned char **          binaries ,
                          cl_int *                        binary_status ,
                          cl_int *                        errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateProgramWithBinary(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBinary(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainProgram(cl_program  program ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainProgram(program);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clRetainProgram(program));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseProgram(cl_program  program ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseProgram(program);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clReleaseProgram(program));
}

CL_API_ENTRY cl_int CL_API_CALL
clBuildProgram(cl_program            program ,
               cl_uint               num_devices ,
               const cl_device_id *  device_list ,
               const char *          options , 
               void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
               void *                user_data ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clBuildProgram(program, num_devices, device_list, options, pfn_notify, user_data);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clBuildProgram(program, num_devices, device_list, options, pfn_notify, user_data));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetProgramInfo(cl_program          program ,
                 cl_program_info     param_name ,
                 size_t              param_value_size ,
                 void *              param_value ,
                 size_t *            param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetProgramInfo(program, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramInfo(program, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetProgramBuildInfo(cl_program             program ,
                      cl_device_id           device ,
                      cl_program_build_info  param_name ,
                      size_t                 param_value_size ,
                      void *                 param_value ,
                      size_t *               param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetProgramBuildInfo(program, device, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clGetProgramBuildInfo(program, device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_kernel CL_API_CALL
clCreateKernel(cl_program       program ,
               const char *     kernel_name ,
               cl_int *         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateKernel(program, kernel_name, errcode_ret);
  if( (struct _cl_program *)program == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_PROGRAM;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernel(program, kernel_name, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateKernelsInProgram(cl_program      program ,
                         cl_uint         num_kernels ,
                         cl_kernel *     kernels ,
                         cl_uint *       num_kernels_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateKernelsInProgram(program, num_kernels, kernels, num_kernels_ret);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCreateKernelsInProgram(program, num_kernels, kernels, num_kernels_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainKernel(cl_kernel     kernel ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainKernel(kernel);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clRetainKernel(kernel));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseKernel(cl_kernel    kernel ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseKernel(kernel);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clReleaseKernel(kernel));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelArg(cl_kernel     kernel ,
               cl_uint       arg_index ,
               size_t        arg_size ,
               const void *  arg_value ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetKernelArg(kernel, arg_index, arg_size, arg_value);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArg(kernel, arg_index, arg_size, arg_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelInfo(cl_kernel        kernel ,
                cl_kernel_info   param_name ,
                size_t           param_value_size ,
                void *           param_value ,
                size_t *         param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetKernelInfo(kernel, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelInfo(kernel, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelWorkGroupInfo(cl_kernel                   kernel ,
                         cl_device_id                device ,
                         cl_kernel_work_group_info   param_name ,
                         size_t                      param_value_size ,
                         void *                      param_value ,
                         size_t *                    param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetEventInfo(cl_event          event ,
               cl_event_info     param_name ,
               size_t            param_value_size ,
               void *            param_value ,
               size_t *          param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetEventInfo(event, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainEvent(cl_event  event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainEvent(event);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clRetainEvent(event));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseEvent(cl_event  event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseEvent(event);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clReleaseEvent(event));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetEventProfilingInfo(cl_event             event ,
                        cl_profiling_info    param_name ,
                        size_t               param_value_size ,
                        void *               param_value ,
                        size_t *             param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetEventProfilingInfo(event, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clGetEventProfilingInfo(event, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clFlush(cl_command_queue  command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clFlush(command_queue);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFlush(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clFinish(cl_command_queue  command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clFinish(command_queue);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clFinish(command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadBuffer(cl_command_queue     command_queue ,
                    cl_mem               buffer ,
                    cl_bool              blocking_read ,
                    size_t               offset ,
                    size_t               cb , 
                    void *               ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteBuffer(cl_command_queue    command_queue , 
                     cl_mem              buffer , 
                     cl_bool             blocking_write , 
                     size_t              offset , 
                     size_t              cb , 
                     const void *        ptr , 
                     cl_uint             num_events_in_wait_list , 
                     const cl_event *    event_wait_list , 
                     cl_event *          event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBuffer(cl_command_queue     command_queue , 
                    cl_mem               src_buffer ,
                    cl_mem               dst_buffer , 
                    size_t               src_offset ,
                    size_t               dst_offset ,
                    size_t               cb , 
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, cb, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, cb, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadImage(cl_command_queue      command_queue ,
                   cl_mem                image ,
                   cl_bool               blocking_read , 
                   const size_t *        origin ,
                   const size_t *        region ,
                   size_t                row_pitch ,
                   size_t                slice_pitch , 
                   void *                ptr ,
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueReadImage(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadImage(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteImage(cl_command_queue     command_queue ,
                    cl_mem               image ,
                    cl_bool              blocking_write , 
                    const size_t *       origin ,
                    const size_t *       region ,
                    size_t               input_row_pitch ,
                    size_t               input_slice_pitch , 
                    const void *         ptr ,
                    cl_uint              num_events_in_wait_list ,
                    const cl_event *     event_wait_list ,
                    cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueWriteImage(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteImage(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyImage(cl_command_queue      command_queue ,
                   cl_mem                src_image ,
                   cl_mem                dst_image , 
                   const size_t *        src_origin ,
                   const size_t *        dst_origin ,
                   const size_t *        region , 
                   cl_uint               num_events_in_wait_list ,
                   const cl_event *      event_wait_list ,
                   cl_event *            event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueCopyImage(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImage(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyImageToBuffer(cl_command_queue  command_queue ,
                           cl_mem            src_image ,
                           cl_mem            dst_buffer , 
                           const size_t *    src_origin ,
                           const size_t *    region , 
                           size_t            dst_offset ,
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBufferToImage(cl_command_queue  command_queue ,
                           cl_mem            src_buffer ,
                           cl_mem            dst_image , 
                           size_t            src_offset ,
                           const size_t *    dst_origin ,
                           const size_t *    region , 
                           cl_uint           num_events_in_wait_list ,
                           const cl_event *  event_wait_list ,
                           cl_event *        event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY void * CL_API_CALL
clEnqueueMapBuffer(cl_command_queue  command_queue ,
                   cl_mem            buffer ,
                   cl_bool           blocking_map , 
                   cl_map_flags      map_flags ,
                   size_t            offset ,
                   size_t            cb ,
                   cl_uint           num_events_in_wait_list ,
                   const cl_event *  event_wait_list ,
                   cl_event *        event ,
                   cl_int *          errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

CL_API_ENTRY void * CL_API_CALL
clEnqueueMapImage(cl_command_queue   command_queue ,
                  cl_mem             image , 
                  cl_bool            blocking_map , 
                  cl_map_flags       map_flags , 
                  const size_t *     origin ,
                  const size_t *     region ,
                  size_t *           image_row_pitch ,
                  size_t *           image_slice_pitch ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ,
                  cl_int *           errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueMapImage(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_COMMAND_QUEUE;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMapImage(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueUnmapMemObject(cl_command_queue  command_queue ,
                        cl_mem            memobj ,
                        void *            mapped_ptr ,
                        cl_uint           num_events_in_wait_list ,
                        const cl_event *   event_wait_list ,
                        cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueUnmapMemObject(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueUnmapMemObject(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueNDRangeKernel(cl_command_queue  command_queue ,
                       cl_kernel         kernel ,
                       cl_uint           work_dim ,
                       const size_t *    global_work_offset ,
                       const size_t *    global_work_size ,
                       const size_t *    local_work_size ,
                       cl_uint           num_events_in_wait_list ,
                       const cl_event *  event_wait_list ,
                       cl_event *        event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueNDRangeKernel(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNDRangeKernel(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueTask(cl_command_queue   command_queue ,
              cl_kernel          kernel ,
              cl_uint            num_events_in_wait_list ,
              const cl_event *   event_wait_list ,
              cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueTask(command_queue, kernel, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueTask(command_queue, kernel, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueNativeKernel(cl_command_queue   command_queue ,
					  void (*user_func)(void *), 
                      void *             args ,
                      size_t             cb_args , 
                      cl_uint            num_mem_objects ,
                      const cl_mem *     mem_list ,
                      const void **      args_mem_loc ,
                      cl_uint            num_events_in_wait_list ,
                      const cl_event *   event_wait_list ,
                      cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueNativeKernel(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueNativeKernel(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMarker(cl_command_queue     command_queue ,
                cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueMarker(command_queue, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarker(command_queue, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWaitForEvents(cl_command_queue  command_queue ,
                       cl_uint           num_events ,
                       const cl_event *  event_list ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueWaitForEvents(command_queue, num_events, event_list);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWaitForEvents(command_queue, num_events, event_list));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueBarrier(cl_command_queue  command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueBarrier(command_queue);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrier(command_queue));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLBuffer(cl_context      context ,
                     cl_mem_flags    flags ,
                     cl_GLuint       bufobj ,
                     int *           errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromGLBuffer(context, flags, bufobj, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLBuffer(context, flags, bufobj, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture2D(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromGLTexture2D(context, flags, target, miplevel, texture, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture2D(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture3D(cl_context       context ,
                        cl_mem_flags     flags ,
                        cl_GLenum        target ,
                        cl_GLint         miplevel ,
                        cl_GLuint        texture ,
                        cl_int *         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromGLTexture3D(context, flags, target, miplevel, texture, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture3D(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLRenderbuffer(cl_context    context ,
                           cl_mem_flags  flags ,
                           cl_GLuint     renderbuffer ,
                           cl_int *      errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromGLRenderbuffer(context, flags, renderbuffer, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLRenderbuffer(context, flags, renderbuffer, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetGLObjectInfo(cl_mem                 memobj ,
                  cl_gl_object_type *    gl_object_type ,
                  cl_GLuint *               gl_object_name ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetGLObjectInfo(memobj, gl_object_type, gl_object_name);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLObjectInfo(memobj, gl_object_type, gl_object_name));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetGLTextureInfo(cl_mem                memobj ,
                   cl_gl_texture_info    param_name ,
                   size_t                param_value_size ,
                   void *                param_value ,
                   size_t *              param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetGLTextureInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clGetGLTextureInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueAcquireGLObjects(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueAcquireGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReleaseGLObjects(cl_command_queue       command_queue ,
                          cl_uint                num_objects ,
                          const cl_mem *         mem_objects ,
                          cl_uint                num_events_in_wait_list ,
                          const cl_event *       event_wait_list ,
                          cl_event *             event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueReleaseGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetEventCallback(cl_event     event ,
                   cl_int       command_exec_callback_type ,
                   void (CL_CALLBACK *  pfn_notify )(cl_event, cl_int, void *),
                   void *       user_data ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetEventCallback(event, command_exec_callback_type, pfn_notify, user_data);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetEventCallback(event, command_exec_callback_type, pfn_notify, user_data));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateSubBuffer(cl_mem                    buffer ,
                  cl_mem_flags              flags ,
                  cl_buffer_create_type     buffer_create_type ,
                  const void *              buffer_create_info ,
                  cl_int *                  errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateSubBuffer(buffer, flags, buffer_create_type, buffer_create_info, errcode_ret);
  if( (struct _cl_mem *)buffer == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_MEM_OBJECT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_mem *)buffer)->dispatch->clCreateSubBuffer(buffer, flags, buffer_create_type, buffer_create_info, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetMemObjectDestructorCallback(cl_mem  memobj ,
                                 void (CL_CALLBACK * pfn_notify)( cl_mem  memobj , void* user_data),
                                 void * user_data  ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetMemObjectDestructorCallback(memobj, pfn_notify, user_data);
  if( (struct _cl_mem *)memobj == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)memobj)->dispatch->clSetMemObjectDestructorCallback(memobj, pfn_notify, user_data));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateUserEvent(cl_context     context ,
                  cl_int *       errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateUserEvent(context, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateUserEvent(context, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetUserEventStatus(cl_event    event ,
                     cl_int      execution_status ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetUserEventStatus(event, execution_status);
  if( (struct _cl_event *)event == NULL) {
    RETURN(CL_INVALID_EVENT);
  }
  RETURN(((struct _cl_event *)event)->dispatch->clSetUserEventStatus(event, execution_status));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReadBufferRect(cl_command_queue     command_queue ,
                        cl_mem               buffer ,
                        cl_bool              blocking_read ,
                        const size_t *       buffer_origin ,
                        const size_t *       host_origin , 
                        const size_t *       region ,
                        size_t               buffer_row_pitch ,
                        size_t               buffer_slice_pitch ,
                        size_t               host_row_pitch ,
                        size_t               host_slice_pitch ,                        
                        void *               ptr ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueReadBufferRect(command_queue, buffer, blocking_read, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReadBufferRect(command_queue, buffer, blocking_read, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueWriteBufferRect(cl_command_queue     command_queue ,
                         cl_mem               buffer ,
                         cl_bool              blocking_write ,
                         const size_t *       buffer_origin ,
                         const size_t *       host_origin , 
                         const size_t *       region ,
                         size_t               buffer_row_pitch ,
                         size_t               buffer_slice_pitch ,
                         size_t               host_row_pitch ,
                         size_t               host_slice_pitch ,                        
                         const void *         ptr ,
                         cl_uint              num_events_in_wait_list ,
                         const cl_event *     event_wait_list ,
                         cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueWriteBufferRect(command_queue, buffer, blocking_write, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueWriteBufferRect(command_queue, buffer, blocking_write, buffer_origin, host_origin, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueCopyBufferRect(cl_command_queue     command_queue , 
                        cl_mem               src_buffer ,
                        cl_mem               dst_buffer , 
                        const size_t *       src_origin ,
                        const size_t *       dst_origin ,
                        const size_t *       region , 
                        size_t               src_row_pitch ,
                        size_t               src_slice_pitch ,
                        size_t               dst_row_pitch ,
                        size_t               dst_slice_pitch ,
                        cl_uint              num_events_in_wait_list ,
                        const cl_event *     event_wait_list ,
                        cl_event *           event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateSubDevicesEXT(cl_device_id in_device,
                      const cl_device_partition_property_ext *  properties ,
                      cl_uint num_entries,
                      cl_device_id * out_devices,
                      cl_uint * num_devices ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateSubDevicesEXT(in_device, properties, num_entries, out_devices, num_devices);
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevicesEXT(in_device, properties, num_entries, out_devices, num_devices));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainDeviceEXT( cl_device_id device ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainDeviceEXT(device);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDeviceEXT(device));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseDeviceEXT( cl_device_id device ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseDeviceEXT(device);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDeviceEXT(device));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateEventFromGLsyncKHR(cl_context            context ,
                           cl_GLsync             cl_GLsync ,
                           cl_int *              errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateEventFromGLsyncKHR(context, cl_GLsync, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromGLsyncKHR(context, cl_GLsync, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCreateSubDevices(cl_device_id                          in_device ,
                   const cl_device_partition_property *  properties ,
                   cl_uint                               num_devices ,
                   cl_device_id *                        out_devices ,
                   cl_uint *                             num_devices_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateSubDevices(in_device, properties, num_devices, out_devices, num_devices_ret);
  if( (struct _cl_device_id *)in_device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)in_device)->dispatch->clCreateSubDevices(in_device, properties, num_devices, out_devices, num_devices_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clRetainDevice(cl_device_id  device ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clRetainDevice(device);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clRetainDevice(device));
}

CL_API_ENTRY cl_int CL_API_CALL
clReleaseDevice(cl_device_id  device ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clReleaseDevice(device);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clReleaseDevice(device));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImage(cl_context               context ,
              cl_mem_flags             flags ,
              const cl_image_format *  image_format ,
              const cl_image_desc *    image_desc , 
              void *                   host_ptr ,
              cl_int *                 errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateImage(context, flags, image_format, image_desc, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImage(context, flags, image_format, image_desc, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithBuiltInKernels(cl_context             context ,
                                  cl_uint                num_devices ,
                                  const cl_device_id *   device_list ,
                                  const char *           kernel_names ,
                                  cl_int *               errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateProgramWithBuiltInKernels(context, num_devices, device_list, kernel_names, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithBuiltInKernels(context, num_devices, device_list, kernel_names, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clCompileProgram(cl_program            program ,
                 cl_uint               num_devices ,
                 const cl_device_id *  device_list ,
                 const char *          options , 
                 cl_uint               num_input_headers ,
                 const cl_program *    input_headers ,
                 const char **         header_include_names ,
                 void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
                 void *                user_data ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCompileProgram(program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clCompileProgram(program, num_devices, device_list, options, num_input_headers, input_headers, header_include_names, pfn_notify, user_data));
}

CL_API_ENTRY cl_program CL_API_CALL
clLinkProgram(cl_context            context ,
              cl_uint               num_devices ,
              const cl_device_id *  device_list ,
              const char *          options , 
              cl_uint               num_input_programs ,
              const cl_program *    input_programs ,
              void (CL_CALLBACK *   pfn_notify )(cl_program  program , void *  user_data ),
              void *                user_data ,
              cl_int *              errcode_ret  ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clLinkProgram(context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clLinkProgram(context, num_devices, device_list, options, num_input_programs, input_programs, pfn_notify, user_data, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clUnloadPlatformCompiler(cl_platform_id  platform ){
  debug_trace();
  _initClIcd_no_inline();
  if (_first_layer)
    return _first_layer->dispatch.clUnloadPlatformCompiler(platform);
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(CL_INVALID_PLATFORM);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clUnloadPlatformCompiler(platform));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelArgInfo(cl_kernel        kernel ,
                   cl_uint          arg_indx ,
                   cl_kernel_arg_info   param_name ,
                   size_t           param_value_size ,
                   void *           param_value ,
                   size_t *         param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelArgInfo(kernel, arg_indx, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueFillBuffer(cl_command_queue    command_queue ,
                    cl_mem              buffer , 
                    const void *        pattern , 
                    size_t              pattern_size , 
                    size_t              offset , 
                    size_t              size , 
                    cl_uint             num_events_in_wait_list , 
                    const cl_event *    event_wait_list , 
                    cl_event *          event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueFillBuffer(command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillBuffer(command_queue, buffer, pattern, pattern_size, offset, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueFillImage(cl_command_queue    command_queue ,
                   cl_mem              image , 
                   const void *        fill_color , 
                   const size_t *      origin , 
                   const size_t *      region , 
                   cl_uint             num_events_in_wait_list , 
                   const cl_event *    event_wait_list , 
                   cl_event *          event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueFillImage(command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueFillImage(command_queue, image, fill_color, origin, region, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMigrateMemObjects(cl_command_queue        command_queue ,
                           cl_uint                 num_mem_objects ,
                           const cl_mem *          mem_objects ,
                           cl_mem_migration_flags  flags ,
                           cl_uint                 num_events_in_wait_list ,
                           const cl_event *        event_wait_list ,
                           cl_event *              event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueMigrateMemObjects(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMigrateMemObjects(command_queue, num_mem_objects, mem_objects, flags, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueMarkerWithWaitList(cl_command_queue  command_queue ,
                            cl_uint            num_events_in_wait_list ,
                            const cl_event *   event_wait_list ,
                            cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueMarkerWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueBarrierWithWaitList(cl_command_queue  command_queue ,
                             cl_uint            num_events_in_wait_list ,
                             const cl_event *   event_wait_list ,
                             cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueBarrierWithWaitList(command_queue, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY void * CL_API_CALL 
clGetExtensionFunctionAddressForPlatform(cl_platform_id  platform ,
                                         const char *    func_name ){
  debug_trace();
  _initClIcd_no_inline();
  if (_first_layer)
    return _first_layer->dispatch.clGetExtensionFunctionAddressForPlatform(platform, func_name);
  if( func_name == NULL )
    return NULL;
  struct func_desc const * fn=&function_description[0];
  int lenfn=strlen(func_name);
  if (lenfn > 3 &&
      (strcmp(func_name+lenfn-3, "KHR")==0 || strcmp(func_name+lenfn-3, "EXT")==0)) {
    while (fn->name != NULL) {
      if (strcmp(func_name, fn->name)==0)
        RETURN(fn->addr);
      fn++;
    }
  }
  platform=selectPlatformID(platform);
  if( (struct _cl_platform_id *)platform == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_platform_id *)platform)->dispatch->clGetExtensionFunctionAddressForPlatform(platform, func_name));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromGLTexture(cl_context       context ,
                      cl_mem_flags     flags ,
                      cl_GLenum        target ,
                      cl_GLint         miplevel ,
                      cl_GLuint        texture ,
                      cl_int *         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromGLTexture(context, flags, target, miplevel, texture, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromGLTexture(context, flags, target, miplevel, texture, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateFromEGLImageKHR(cl_context                   context ,
                        CLeglDisplayKHR              egldisplay ,
                        CLeglImageKHR                eglimage ,
                        cl_mem_flags                 flags ,
                        const cl_egl_image_properties_khr *  properties ,
                        cl_int *                     errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateFromEGLImageKHR(context, egldisplay, eglimage, flags, properties, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateFromEGLImageKHR(context, egldisplay, eglimage, flags, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueAcquireEGLObjectsKHR(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueAcquireEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueAcquireEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueReleaseEGLObjectsKHR(cl_command_queue  command_queue ,
                              cl_uint           num_objects ,
                              const cl_mem *    mem_objects ,
                              cl_uint           num_events_in_wait_list ,
                              const cl_event *  event_wait_list ,
                              cl_event *        event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_event CL_API_CALL
clCreateEventFromEGLSyncKHR(cl_context       context ,
                            CLeglSyncKHR     sync ,
                            CLeglDisplayKHR  display ,
                            cl_int *         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateEventFromEGLSyncKHR(context, sync, display, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateEventFromEGLSyncKHR(context, sync, display, errcode_ret));
}

CL_API_ENTRY cl_command_queue CL_API_CALL
clCreateCommandQueueWithProperties(cl_context                context ,
                                   cl_device_id              device ,
                                   const cl_queue_properties *     properties ,
                                   cl_int *                  errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateCommandQueueWithProperties(context, device, properties, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateCommandQueueWithProperties(context, device, properties, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreatePipe(cl_context                  context ,
             cl_mem_flags                flags ,
             cl_uint                     pipe_packet_size ,
             cl_uint                     pipe_max_packets ,
             const cl_pipe_properties *  properties ,
             cl_int *                    errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreatePipe(context, flags, pipe_packet_size, pipe_max_packets, properties, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetPipeInfo(cl_mem            pipe ,
              cl_pipe_info      param_name ,
              size_t            param_value_size ,
              void *            param_value ,
              size_t *          param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetPipeInfo(pipe, param_name, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_mem *)pipe == NULL) {
    RETURN(CL_INVALID_MEM_OBJECT);
  }
  RETURN(((struct _cl_mem *)pipe)->dispatch->clGetPipeInfo(pipe, param_name, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY void * CL_API_CALL
clSVMAlloc(cl_context        context ,
           cl_svm_mem_flags  flags ,
           size_t            size ,
           cl_uint           alignment ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSVMAlloc(context, flags, size, alignment);
  if( (struct _cl_context *)context == NULL) {
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSVMAlloc(context, flags, size, alignment));
}

CL_API_ENTRY void CL_API_CALL
clSVMFree(cl_context         context ,
          void *             svm_pointer ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSVMFree(context, svm_pointer);
  if( (struct _cl_context *)context == NULL) {
    return;
  }
  return(((struct _cl_context *)context)->dispatch->clSVMFree(context, svm_pointer));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMFree(cl_command_queue   command_queue ,
                 cl_uint            num_svm_pointers ,
                 void *             svm_pointers[] ,
                 void (CL_CALLBACK * pfn_free_func)(cl_command_queue  queue ,
                                                        cl_uint           num_svm_pointers ,
                                                        void *            svm_pointers[] ,
                                                        void *            user_data ),
                 void *             user_data ,
                 cl_uint            num_events_in_wait_list ,
                 const cl_event *   event_wait_list ,
                 cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMFree(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMFree(command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMemcpy(cl_command_queue   command_queue ,
                   cl_bool            blocking_copy ,
                   void *             dst_ptr ,
                   const void *       src_ptr ,
                   size_t             size ,
                   cl_uint            num_events_in_wait_list ,
                   const cl_event *   event_wait_list ,
                   cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMMemcpy(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemcpy(command_queue, blocking_copy, dst_ptr, src_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMemFill(cl_command_queue   command_queue ,
                    void *             svm_ptr ,
                    const void *       pattern ,
                    size_t             pattern_size ,
                    size_t             size ,
                    cl_uint            num_events_in_wait_list ,
                    const cl_event *   event_wait_list ,
                    cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMMemFill(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMemFill(command_queue, svm_ptr, pattern, pattern_size, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMap(cl_command_queue   command_queue ,
                cl_bool            blocking_map ,
                cl_map_flags       flags ,
                void *             svm_ptr ,
                size_t             size ,
                cl_uint            num_events_in_wait_list ,
                const cl_event *   event_wait_list ,
                cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMMap(command_queue, blocking_map, flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMap(command_queue, blocking_map, flags, svm_ptr, size, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMUnmap(cl_command_queue   command_queue ,
                  void *             svm_ptr ,
                  cl_uint            num_events_in_wait_list ,
                  const cl_event *   event_wait_list ,
                  cl_event *         event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMUnmap(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMUnmap(command_queue, svm_ptr, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_sampler CL_API_CALL
clCreateSamplerWithProperties(cl_context                      context ,
                              const cl_sampler_properties *   normalized_coords ,
                              cl_int *                        errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateSamplerWithProperties(context, normalized_coords, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateSamplerWithProperties(context, normalized_coords, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelArgSVMPointer(cl_kernel     kernel ,
                         cl_uint       arg_index ,
                         const void *  arg_value ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetKernelArgSVMPointer(kernel, arg_index, arg_value);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelArgSVMPointer(kernel, arg_index, arg_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetKernelExecInfo(cl_kernel             kernel ,
                    cl_kernel_exec_info   param_name ,
                    size_t                param_value_size ,
                    const void *          param_value ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetKernelExecInfo(kernel, param_name, param_value_size, param_value);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clSetKernelExecInfo(kernel, param_name, param_value_size, param_value));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelSubGroupInfoKHR(cl_kernel  in_kernel ,
                           cl_device_id in_device,
                           cl_kernel_sub_group_info  param_name ,
                           size_t input_value_size,
                           const void * input_value,
                           size_t param_value_size,
                           void* param_value,
                           size_t* param_value_size_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetKernelSubGroupInfoKHR(in_kernel, in_device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_kernel *)in_kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)in_kernel)->dispatch->clGetKernelSubGroupInfoKHR(in_kernel, in_device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_kernel CL_API_CALL
clCloneKernel(cl_kernel      source_kernel ,
              cl_int*        errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCloneKernel(source_kernel, errcode_ret);
  if( (struct _cl_kernel *)source_kernel == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_KERNEL;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_kernel *)source_kernel)->dispatch->clCloneKernel(source_kernel, errcode_ret));
}

CL_API_ENTRY cl_program CL_API_CALL
clCreateProgramWithIL(cl_context     context ,
                      const void*     il ,
                      size_t          length ,
                      cl_int*         errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateProgramWithIL(context, il, length, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateProgramWithIL(context, il, length, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clEnqueueSVMMigrateMem(cl_command_queue          command_queue ,
                       cl_uint                   num_svm_pointers ,
                       const void **             svm_pointers ,
                       const size_t *            sizes ,
                       cl_mem_migration_flags    flags ,
                       cl_uint                   num_events_in_wait_list ,
                       const cl_event *          event_wait_list ,
                       cl_event *                event ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clEnqueueSVMMigrateMem(command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event);
  if( (struct _cl_command_queue *)command_queue == NULL) {
    RETURN(CL_INVALID_COMMAND_QUEUE);
  }
  RETURN(((struct _cl_command_queue *)command_queue)->dispatch->clEnqueueSVMMigrateMem(command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetDeviceAndHostTimer(cl_device_id     device ,
                        cl_ulong*        device_timestamp ,
                        cl_ulong*        host_timestamp ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetDeviceAndHostTimer(device, device_timestamp, host_timestamp);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetDeviceAndHostTimer(device, device_timestamp, host_timestamp));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetHostTimer(cl_device_id  device ,
               cl_ulong *    host_timestamp ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetHostTimer(device, host_timestamp);
  if( (struct _cl_device_id *)device == NULL) {
    RETURN(CL_INVALID_DEVICE);
  }
  RETURN(((struct _cl_device_id *)device)->dispatch->clGetHostTimer(device, host_timestamp));
}

CL_API_ENTRY cl_int CL_API_CALL
clGetKernelSubGroupInfo(cl_kernel                    kernel ,
                        cl_device_id                 device ,
                        cl_kernel_sub_group_info     param_name ,
                        size_t                       input_value_size ,
                        const void*                  input_value ,
                        size_t                       param_value_size ,
                        void*                        param_value ,
                        size_t*                      param_value_size_ret  ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret);
  if( (struct _cl_kernel *)kernel == NULL) {
    RETURN(CL_INVALID_KERNEL);
  }
  RETURN(((struct _cl_kernel *)kernel)->dispatch->clGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetDefaultDeviceCommandQueue(cl_context            context ,
                               cl_device_id          device ,
                               cl_command_queue      command_queue ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetDefaultDeviceCommandQueue(context, device, command_queue);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSetDefaultDeviceCommandQueue(context, device, command_queue));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetProgramReleaseCallback(cl_program           program ,
                            void (CL_CALLBACK *  pfn_notify )(cl_program  program , void *  user_data ),
                            void *               user_data ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetProgramReleaseCallback(program, pfn_notify, user_data);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramReleaseCallback(program, pfn_notify, user_data));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetProgramSpecializationConstant(cl_program   program ,
                                   cl_uint      spec_id ,
                                   size_t       spec_size ,
                                   const void*  spec_value ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetProgramSpecializationConstant(program, spec_id, spec_size, spec_value);
  if( (struct _cl_program *)program == NULL) {
    RETURN(CL_INVALID_PROGRAM);
  }
  RETURN(((struct _cl_program *)program)->dispatch->clSetProgramSpecializationConstant(program, spec_id, spec_size, spec_value));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateBufferWithProperties(cl_context                 context ,
                             const cl_mem_properties *  properties ,
                             cl_mem_flags               flags ,
                             size_t                     size ,
                             void *                     host_ptr ,
                             cl_int *                   errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateBufferWithProperties(context, properties, flags, size, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateBufferWithProperties(context, properties, flags, size, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_mem CL_API_CALL
clCreateImageWithProperties(cl_context                 context ,
                            const cl_mem_properties *  properties ,
                            cl_mem_flags               flags ,
                            const cl_image_format *    image_format ,
                            const cl_image_desc *      image_desc ,
                            void *                     host_ptr ,
                            cl_int *                   errcode_ret ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clCreateImageWithProperties(context, properties, flags, image_format, image_desc, host_ptr, errcode_ret);
  if( (struct _cl_context *)context == NULL) {
    if( errcode_ret != NULL ) {
      *errcode_ret = CL_INVALID_CONTEXT;
    }
    RETURN(NULL);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clCreateImageWithProperties(context, properties, flags, image_format, image_desc, host_ptr, errcode_ret));
}

CL_API_ENTRY cl_int CL_API_CALL
clSetContextDestructorCallback(cl_context           context ,
                               void (CL_CALLBACK *  pfn_notify )(cl_context  context , void*  user_data ),
                               void *               user_data ){
  debug_trace();
  if (_first_layer)
    return _first_layer->dispatch.clSetContextDestructorCallback(context, pfn_notify, user_data);
  if( (struct _cl_context *)context == NULL) {
    RETURN(CL_INVALID_CONTEXT);
  }
  RETURN(((struct _cl_context *)context)->dispatch->clSetContextDestructorCallback(context, pfn_notify, user_data));
}

#pragma GCC visibility push(hidden)

#if defined(__APPLE__) || defined(__MACOSX)
#define clGetPlatformIDs_hid clGetPlatformIDs
#else
extern typeof(clGetPlatformIDs) clGetPlatformIDs_hid;
#endif
extern typeof(clGetPlatformIDs) clGetPlatformIDs_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetPlatformInfo_hid clGetPlatformInfo
#else
hidden_alias(clGetPlatformInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetDeviceIDs_hid clGetDeviceIDs
#else
hidden_alias(clGetDeviceIDs);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetDeviceInfo_hid clGetDeviceInfo
#else
hidden_alias(clGetDeviceInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateContext_hid clCreateContext
#else
extern typeof(clCreateContext) clCreateContext_hid;
#endif
extern typeof(clCreateContext) clCreateContext_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateContextFromType_hid clCreateContextFromType
#else
extern typeof(clCreateContextFromType) clCreateContextFromType_hid;
#endif
extern typeof(clCreateContextFromType) clCreateContextFromType_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainContext_hid clRetainContext
#else
hidden_alias(clRetainContext);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseContext_hid clReleaseContext
#else
hidden_alias(clReleaseContext);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetContextInfo_hid clGetContextInfo
#else
hidden_alias(clGetContextInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateCommandQueue_hid clCreateCommandQueue
#else
hidden_alias(clCreateCommandQueue);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainCommandQueue_hid clRetainCommandQueue
#else
hidden_alias(clRetainCommandQueue);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseCommandQueue_hid clReleaseCommandQueue
#else
hidden_alias(clReleaseCommandQueue);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetCommandQueueInfo_hid clGetCommandQueueInfo
#else
hidden_alias(clGetCommandQueueInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetCommandQueueProperty_hid clSetCommandQueueProperty
#else
hidden_alias(clSetCommandQueueProperty);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateBuffer_hid clCreateBuffer
#else
hidden_alias(clCreateBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateImage2D_hid clCreateImage2D
#else
hidden_alias(clCreateImage2D);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateImage3D_hid clCreateImage3D
#else
hidden_alias(clCreateImage3D);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainMemObject_hid clRetainMemObject
#else
hidden_alias(clRetainMemObject);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseMemObject_hid clReleaseMemObject
#else
hidden_alias(clReleaseMemObject);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetSupportedImageFormats_hid clGetSupportedImageFormats
#else
hidden_alias(clGetSupportedImageFormats);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetMemObjectInfo_hid clGetMemObjectInfo
#else
hidden_alias(clGetMemObjectInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetImageInfo_hid clGetImageInfo
#else
hidden_alias(clGetImageInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateSampler_hid clCreateSampler
#else
hidden_alias(clCreateSampler);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainSampler_hid clRetainSampler
#else
hidden_alias(clRetainSampler);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseSampler_hid clReleaseSampler
#else
hidden_alias(clReleaseSampler);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetSamplerInfo_hid clGetSamplerInfo
#else
hidden_alias(clGetSamplerInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateProgramWithSource_hid clCreateProgramWithSource
#else
hidden_alias(clCreateProgramWithSource);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateProgramWithBinary_hid clCreateProgramWithBinary
#else
hidden_alias(clCreateProgramWithBinary);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainProgram_hid clRetainProgram
#else
hidden_alias(clRetainProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseProgram_hid clReleaseProgram
#else
hidden_alias(clReleaseProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clBuildProgram_hid clBuildProgram
#else
hidden_alias(clBuildProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clUnloadCompiler_hid clUnloadCompiler
#else
extern typeof(clUnloadCompiler) clUnloadCompiler_hid;
#endif
extern typeof(clUnloadCompiler) clUnloadCompiler_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetProgramInfo_hid clGetProgramInfo
#else
hidden_alias(clGetProgramInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetProgramBuildInfo_hid clGetProgramBuildInfo
#else
hidden_alias(clGetProgramBuildInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateKernel_hid clCreateKernel
#else
hidden_alias(clCreateKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateKernelsInProgram_hid clCreateKernelsInProgram
#else
hidden_alias(clCreateKernelsInProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainKernel_hid clRetainKernel
#else
hidden_alias(clRetainKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseKernel_hid clReleaseKernel
#else
hidden_alias(clReleaseKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetKernelArg_hid clSetKernelArg
#else
hidden_alias(clSetKernelArg);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetKernelInfo_hid clGetKernelInfo
#else
hidden_alias(clGetKernelInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetKernelWorkGroupInfo_hid clGetKernelWorkGroupInfo
#else
hidden_alias(clGetKernelWorkGroupInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clWaitForEvents_hid clWaitForEvents
#else
extern typeof(clWaitForEvents) clWaitForEvents_hid;
#endif
extern typeof(clWaitForEvents) clWaitForEvents_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetEventInfo_hid clGetEventInfo
#else
hidden_alias(clGetEventInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainEvent_hid clRetainEvent
#else
hidden_alias(clRetainEvent);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseEvent_hid clReleaseEvent
#else
hidden_alias(clReleaseEvent);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetEventProfilingInfo_hid clGetEventProfilingInfo
#else
hidden_alias(clGetEventProfilingInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clFlush_hid clFlush
#else
hidden_alias(clFlush);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clFinish_hid clFinish
#else
hidden_alias(clFinish);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueReadBuffer_hid clEnqueueReadBuffer
#else
hidden_alias(clEnqueueReadBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueWriteBuffer_hid clEnqueueWriteBuffer
#else
hidden_alias(clEnqueueWriteBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueCopyBuffer_hid clEnqueueCopyBuffer
#else
hidden_alias(clEnqueueCopyBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueReadImage_hid clEnqueueReadImage
#else
hidden_alias(clEnqueueReadImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueWriteImage_hid clEnqueueWriteImage
#else
hidden_alias(clEnqueueWriteImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueCopyImage_hid clEnqueueCopyImage
#else
hidden_alias(clEnqueueCopyImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueCopyImageToBuffer_hid clEnqueueCopyImageToBuffer
#else
hidden_alias(clEnqueueCopyImageToBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueCopyBufferToImage_hid clEnqueueCopyBufferToImage
#else
hidden_alias(clEnqueueCopyBufferToImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueMapBuffer_hid clEnqueueMapBuffer
#else
hidden_alias(clEnqueueMapBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueMapImage_hid clEnqueueMapImage
#else
hidden_alias(clEnqueueMapImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueUnmapMemObject_hid clEnqueueUnmapMemObject
#else
hidden_alias(clEnqueueUnmapMemObject);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueNDRangeKernel_hid clEnqueueNDRangeKernel
#else
hidden_alias(clEnqueueNDRangeKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueTask_hid clEnqueueTask
#else
hidden_alias(clEnqueueTask);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueNativeKernel_hid clEnqueueNativeKernel
#else
hidden_alias(clEnqueueNativeKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueMarker_hid clEnqueueMarker
#else
hidden_alias(clEnqueueMarker);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueWaitForEvents_hid clEnqueueWaitForEvents
#else
hidden_alias(clEnqueueWaitForEvents);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueBarrier_hid clEnqueueBarrier
#else
hidden_alias(clEnqueueBarrier);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetExtensionFunctionAddress_hid clGetExtensionFunctionAddress
#else
extern typeof(clGetExtensionFunctionAddress) clGetExtensionFunctionAddress_hid;
#endif
extern typeof(clGetExtensionFunctionAddress) clGetExtensionFunctionAddress_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromGLBuffer_hid clCreateFromGLBuffer
#else
hidden_alias(clCreateFromGLBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromGLTexture2D_hid clCreateFromGLTexture2D
#else
hidden_alias(clCreateFromGLTexture2D);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromGLTexture3D_hid clCreateFromGLTexture3D
#else
hidden_alias(clCreateFromGLTexture3D);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromGLRenderbuffer_hid clCreateFromGLRenderbuffer
#else
hidden_alias(clCreateFromGLRenderbuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetGLObjectInfo_hid clGetGLObjectInfo
#else
hidden_alias(clGetGLObjectInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetGLTextureInfo_hid clGetGLTextureInfo
#else
hidden_alias(clGetGLTextureInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueAcquireGLObjects_hid clEnqueueAcquireGLObjects
#else
hidden_alias(clEnqueueAcquireGLObjects);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueReleaseGLObjects_hid clEnqueueReleaseGLObjects
#else
hidden_alias(clEnqueueReleaseGLObjects);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetGLContextInfoKHR_hid clGetGLContextInfoKHR
#else
extern typeof(clGetGLContextInfoKHR) clGetGLContextInfoKHR_hid;
#endif
extern typeof(clGetGLContextInfoKHR) clGetGLContextInfoKHR_disp;
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetEventCallback_hid clSetEventCallback
#else
hidden_alias(clSetEventCallback);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateSubBuffer_hid clCreateSubBuffer
#else
hidden_alias(clCreateSubBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetMemObjectDestructorCallback_hid clSetMemObjectDestructorCallback
#else
hidden_alias(clSetMemObjectDestructorCallback);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateUserEvent_hid clCreateUserEvent
#else
hidden_alias(clCreateUserEvent);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetUserEventStatus_hid clSetUserEventStatus
#else
hidden_alias(clSetUserEventStatus);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueReadBufferRect_hid clEnqueueReadBufferRect
#else
hidden_alias(clEnqueueReadBufferRect);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueWriteBufferRect_hid clEnqueueWriteBufferRect
#else
hidden_alias(clEnqueueWriteBufferRect);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueCopyBufferRect_hid clEnqueueCopyBufferRect
#else
hidden_alias(clEnqueueCopyBufferRect);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateSubDevicesEXT_hid clCreateSubDevicesEXT
#else
hidden_alias(clCreateSubDevicesEXT);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainDeviceEXT_hid clRetainDeviceEXT
#else
hidden_alias(clRetainDeviceEXT);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseDeviceEXT_hid clReleaseDeviceEXT
#else
hidden_alias(clReleaseDeviceEXT);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateEventFromGLsyncKHR_hid clCreateEventFromGLsyncKHR
#else
hidden_alias(clCreateEventFromGLsyncKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateSubDevices_hid clCreateSubDevices
#else
hidden_alias(clCreateSubDevices);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clRetainDevice_hid clRetainDevice
#else
hidden_alias(clRetainDevice);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clReleaseDevice_hid clReleaseDevice
#else
hidden_alias(clReleaseDevice);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateImage_hid clCreateImage
#else
hidden_alias(clCreateImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateProgramWithBuiltInKernels_hid clCreateProgramWithBuiltInKernels
#else
hidden_alias(clCreateProgramWithBuiltInKernels);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCompileProgram_hid clCompileProgram
#else
hidden_alias(clCompileProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clLinkProgram_hid clLinkProgram
#else
hidden_alias(clLinkProgram);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clUnloadPlatformCompiler_hid clUnloadPlatformCompiler
#else
hidden_alias(clUnloadPlatformCompiler);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetKernelArgInfo_hid clGetKernelArgInfo
#else
hidden_alias(clGetKernelArgInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueFillBuffer_hid clEnqueueFillBuffer
#else
hidden_alias(clEnqueueFillBuffer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueFillImage_hid clEnqueueFillImage
#else
hidden_alias(clEnqueueFillImage);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueMigrateMemObjects_hid clEnqueueMigrateMemObjects
#else
hidden_alias(clEnqueueMigrateMemObjects);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueMarkerWithWaitList_hid clEnqueueMarkerWithWaitList
#else
hidden_alias(clEnqueueMarkerWithWaitList);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueBarrierWithWaitList_hid clEnqueueBarrierWithWaitList
#else
hidden_alias(clEnqueueBarrierWithWaitList);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetExtensionFunctionAddressForPlatform_hid clGetExtensionFunctionAddressForPlatform
#else
hidden_alias(clGetExtensionFunctionAddressForPlatform);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromGLTexture_hid clCreateFromGLTexture
#else
hidden_alias(clCreateFromGLTexture);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateFromEGLImageKHR_hid clCreateFromEGLImageKHR
#else
hidden_alias(clCreateFromEGLImageKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueAcquireEGLObjectsKHR_hid clEnqueueAcquireEGLObjectsKHR
#else
hidden_alias(clEnqueueAcquireEGLObjectsKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueReleaseEGLObjectsKHR_hid clEnqueueReleaseEGLObjectsKHR
#else
hidden_alias(clEnqueueReleaseEGLObjectsKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateEventFromEGLSyncKHR_hid clCreateEventFromEGLSyncKHR
#else
hidden_alias(clCreateEventFromEGLSyncKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateCommandQueueWithProperties_hid clCreateCommandQueueWithProperties
#else
hidden_alias(clCreateCommandQueueWithProperties);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreatePipe_hid clCreatePipe
#else
hidden_alias(clCreatePipe);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetPipeInfo_hid clGetPipeInfo
#else
hidden_alias(clGetPipeInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSVMAlloc_hid clSVMAlloc
#else
hidden_alias(clSVMAlloc);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSVMFree_hid clSVMFree
#else
hidden_alias(clSVMFree);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMFree_hid clEnqueueSVMFree
#else
hidden_alias(clEnqueueSVMFree);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMMemcpy_hid clEnqueueSVMMemcpy
#else
hidden_alias(clEnqueueSVMMemcpy);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMMemFill_hid clEnqueueSVMMemFill
#else
hidden_alias(clEnqueueSVMMemFill);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMMap_hid clEnqueueSVMMap
#else
hidden_alias(clEnqueueSVMMap);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMUnmap_hid clEnqueueSVMUnmap
#else
hidden_alias(clEnqueueSVMUnmap);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateSamplerWithProperties_hid clCreateSamplerWithProperties
#else
hidden_alias(clCreateSamplerWithProperties);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetKernelArgSVMPointer_hid clSetKernelArgSVMPointer
#else
hidden_alias(clSetKernelArgSVMPointer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetKernelExecInfo_hid clSetKernelExecInfo
#else
hidden_alias(clSetKernelExecInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetKernelSubGroupInfoKHR_hid clGetKernelSubGroupInfoKHR
#else
hidden_alias(clGetKernelSubGroupInfoKHR);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCloneKernel_hid clCloneKernel
#else
hidden_alias(clCloneKernel);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateProgramWithIL_hid clCreateProgramWithIL
#else
hidden_alias(clCreateProgramWithIL);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clEnqueueSVMMigrateMem_hid clEnqueueSVMMigrateMem
#else
hidden_alias(clEnqueueSVMMigrateMem);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetDeviceAndHostTimer_hid clGetDeviceAndHostTimer
#else
hidden_alias(clGetDeviceAndHostTimer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetHostTimer_hid clGetHostTimer
#else
hidden_alias(clGetHostTimer);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clGetKernelSubGroupInfo_hid clGetKernelSubGroupInfo
#else
hidden_alias(clGetKernelSubGroupInfo);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetDefaultDeviceCommandQueue_hid clSetDefaultDeviceCommandQueue
#else
hidden_alias(clSetDefaultDeviceCommandQueue);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetProgramReleaseCallback_hid clSetProgramReleaseCallback
#else
hidden_alias(clSetProgramReleaseCallback);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetProgramSpecializationConstant_hid clSetProgramSpecializationConstant
#else
hidden_alias(clSetProgramSpecializationConstant);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateBufferWithProperties_hid clCreateBufferWithProperties
#else
hidden_alias(clCreateBufferWithProperties);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clCreateImageWithProperties_hid clCreateImageWithProperties
#else
hidden_alias(clCreateImageWithProperties);
#endif
#if defined(__APPLE__) || defined(__MACOSX)
#define clSetContextDestructorCallback_hid clSetContextDestructorCallback
#else
hidden_alias(clSetContextDestructorCallback);
#endif


struct func_desc const function_description[]= {
  {"clGetPlatformIDs", (void(* const)(void))&clGetPlatformIDs_hid },
  {"clGetPlatformInfo", (void(* const)(void))&clGetPlatformInfo_hid },
  {"clGetDeviceIDs", (void(* const)(void))&clGetDeviceIDs_hid },
  {"clGetDeviceInfo", (void(* const)(void))&clGetDeviceInfo_hid },
  {"clCreateContext", (void(* const)(void))&clCreateContext_hid },
  {"clCreateContextFromType", (void(* const)(void))&clCreateContextFromType_hid },
  {"clRetainContext", (void(* const)(void))&clRetainContext_hid },
  {"clReleaseContext", (void(* const)(void))&clReleaseContext_hid },
  {"clGetContextInfo", (void(* const)(void))&clGetContextInfo_hid },
  {"clCreateCommandQueue", (void(* const)(void))&clCreateCommandQueue_hid },
  {"clRetainCommandQueue", (void(* const)(void))&clRetainCommandQueue_hid },
  {"clReleaseCommandQueue", (void(* const)(void))&clReleaseCommandQueue_hid },
  {"clGetCommandQueueInfo", (void(* const)(void))&clGetCommandQueueInfo_hid },
  {"clSetCommandQueueProperty", (void(* const)(void))&clSetCommandQueueProperty_hid },
  {"clCreateBuffer", (void(* const)(void))&clCreateBuffer_hid },
  {"clCreateImage2D", (void(* const)(void))&clCreateImage2D_hid },
  {"clCreateImage3D", (void(* const)(void))&clCreateImage3D_hid },
  {"clRetainMemObject", (void(* const)(void))&clRetainMemObject_hid },
  {"clReleaseMemObject", (void(* const)(void))&clReleaseMemObject_hid },
  {"clGetSupportedImageFormats", (void(* const)(void))&clGetSupportedImageFormats_hid },
  {"clGetMemObjectInfo", (void(* const)(void))&clGetMemObjectInfo_hid },
  {"clGetImageInfo", (void(* const)(void))&clGetImageInfo_hid },
  {"clCreateSampler", (void(* const)(void))&clCreateSampler_hid },
  {"clRetainSampler", (void(* const)(void))&clRetainSampler_hid },
  {"clReleaseSampler", (void(* const)(void))&clReleaseSampler_hid },
  {"clGetSamplerInfo", (void(* const)(void))&clGetSamplerInfo_hid },
  {"clCreateProgramWithSource", (void(* const)(void))&clCreateProgramWithSource_hid },
  {"clCreateProgramWithBinary", (void(* const)(void))&clCreateProgramWithBinary_hid },
  {"clRetainProgram", (void(* const)(void))&clRetainProgram_hid },
  {"clReleaseProgram", (void(* const)(void))&clReleaseProgram_hid },
  {"clBuildProgram", (void(* const)(void))&clBuildProgram_hid },
  {"clUnloadCompiler", (void(* const)(void))&clUnloadCompiler_hid },
  {"clGetProgramInfo", (void(* const)(void))&clGetProgramInfo_hid },
  {"clGetProgramBuildInfo", (void(* const)(void))&clGetProgramBuildInfo_hid },
  {"clCreateKernel", (void(* const)(void))&clCreateKernel_hid },
  {"clCreateKernelsInProgram", (void(* const)(void))&clCreateKernelsInProgram_hid },
  {"clRetainKernel", (void(* const)(void))&clRetainKernel_hid },
  {"clReleaseKernel", (void(* const)(void))&clReleaseKernel_hid },
  {"clSetKernelArg", (void(* const)(void))&clSetKernelArg_hid },
  {"clGetKernelInfo", (void(* const)(void))&clGetKernelInfo_hid },
  {"clGetKernelWorkGroupInfo", (void(* const)(void))&clGetKernelWorkGroupInfo_hid },
  {"clWaitForEvents", (void(* const)(void))&clWaitForEvents_hid },
  {"clGetEventInfo", (void(* const)(void))&clGetEventInfo_hid },
  {"clRetainEvent", (void(* const)(void))&clRetainEvent_hid },
  {"clReleaseEvent", (void(* const)(void))&clReleaseEvent_hid },
  {"clGetEventProfilingInfo", (void(* const)(void))&clGetEventProfilingInfo_hid },
  {"clFlush", (void(* const)(void))&clFlush_hid },
  {"clFinish", (void(* const)(void))&clFinish_hid },
  {"clEnqueueReadBuffer", (void(* const)(void))&clEnqueueReadBuffer_hid },
  {"clEnqueueWriteBuffer", (void(* const)(void))&clEnqueueWriteBuffer_hid },
  {"clEnqueueCopyBuffer", (void(* const)(void))&clEnqueueCopyBuffer_hid },
  {"clEnqueueReadImage", (void(* const)(void))&clEnqueueReadImage_hid },
  {"clEnqueueWriteImage", (void(* const)(void))&clEnqueueWriteImage_hid },
  {"clEnqueueCopyImage", (void(* const)(void))&clEnqueueCopyImage_hid },
  {"clEnqueueCopyImageToBuffer", (void(* const)(void))&clEnqueueCopyImageToBuffer_hid },
  {"clEnqueueCopyBufferToImage", (void(* const)(void))&clEnqueueCopyBufferToImage_hid },
  {"clEnqueueMapBuffer", (void(* const)(void))&clEnqueueMapBuffer_hid },
  {"clEnqueueMapImage", (void(* const)(void))&clEnqueueMapImage_hid },
  {"clEnqueueUnmapMemObject", (void(* const)(void))&clEnqueueUnmapMemObject_hid },
  {"clEnqueueNDRangeKernel", (void(* const)(void))&clEnqueueNDRangeKernel_hid },
  {"clEnqueueTask", (void(* const)(void))&clEnqueueTask_hid },
  {"clEnqueueNativeKernel", (void(* const)(void))&clEnqueueNativeKernel_hid },
  {"clEnqueueMarker", (void(* const)(void))&clEnqueueMarker_hid },
  {"clEnqueueWaitForEvents", (void(* const)(void))&clEnqueueWaitForEvents_hid },
  {"clEnqueueBarrier", (void(* const)(void))&clEnqueueBarrier_hid },
  {"clGetExtensionFunctionAddress", (void(* const)(void))&clGetExtensionFunctionAddress_hid },
  {"clCreateFromGLBuffer", (void(* const)(void))&clCreateFromGLBuffer_hid },
  {"clCreateFromGLTexture2D", (void(* const)(void))&clCreateFromGLTexture2D_hid },
  {"clCreateFromGLTexture3D", (void(* const)(void))&clCreateFromGLTexture3D_hid },
  {"clCreateFromGLRenderbuffer", (void(* const)(void))&clCreateFromGLRenderbuffer_hid },
  {"clGetGLObjectInfo", (void(* const)(void))&clGetGLObjectInfo_hid },
  {"clGetGLTextureInfo", (void(* const)(void))&clGetGLTextureInfo_hid },
  {"clEnqueueAcquireGLObjects", (void(* const)(void))&clEnqueueAcquireGLObjects_hid },
  {"clEnqueueReleaseGLObjects", (void(* const)(void))&clEnqueueReleaseGLObjects_hid },
  {"clGetGLContextInfoKHR", (void(* const)(void))&clGetGLContextInfoKHR_hid },
  {"clSetEventCallback", (void(* const)(void))&clSetEventCallback_hid },
  {"clCreateSubBuffer", (void(* const)(void))&clCreateSubBuffer_hid },
  {"clSetMemObjectDestructorCallback", (void(* const)(void))&clSetMemObjectDestructorCallback_hid },
  {"clCreateUserEvent", (void(* const)(void))&clCreateUserEvent_hid },
  {"clSetUserEventStatus", (void(* const)(void))&clSetUserEventStatus_hid },
  {"clEnqueueReadBufferRect", (void(* const)(void))&clEnqueueReadBufferRect_hid },
  {"clEnqueueWriteBufferRect", (void(* const)(void))&clEnqueueWriteBufferRect_hid },
  {"clEnqueueCopyBufferRect", (void(* const)(void))&clEnqueueCopyBufferRect_hid },
  {"clCreateSubDevicesEXT", (void(* const)(void))&clCreateSubDevicesEXT_hid },
  {"clRetainDeviceEXT", (void(* const)(void))&clRetainDeviceEXT_hid },
  {"clReleaseDeviceEXT", (void(* const)(void))&clReleaseDeviceEXT_hid },
  {"clCreateEventFromGLsyncKHR", (void(* const)(void))&clCreateEventFromGLsyncKHR_hid },
  {"clCreateSubDevices", (void(* const)(void))&clCreateSubDevices_hid },
  {"clRetainDevice", (void(* const)(void))&clRetainDevice_hid },
  {"clReleaseDevice", (void(* const)(void))&clReleaseDevice_hid },
  {"clCreateImage", (void(* const)(void))&clCreateImage_hid },
  {"clCreateProgramWithBuiltInKernels", (void(* const)(void))&clCreateProgramWithBuiltInKernels_hid },
  {"clCompileProgram", (void(* const)(void))&clCompileProgram_hid },
  {"clLinkProgram", (void(* const)(void))&clLinkProgram_hid },
  {"clUnloadPlatformCompiler", (void(* const)(void))&clUnloadPlatformCompiler_hid },
  {"clGetKernelArgInfo", (void(* const)(void))&clGetKernelArgInfo_hid },
  {"clEnqueueFillBuffer", (void(* const)(void))&clEnqueueFillBuffer_hid },
  {"clEnqueueFillImage", (void(* const)(void))&clEnqueueFillImage_hid },
  {"clEnqueueMigrateMemObjects", (void(* const)(void))&clEnqueueMigrateMemObjects_hid },
  {"clEnqueueMarkerWithWaitList", (void(* const)(void))&clEnqueueMarkerWithWaitList_hid },
  {"clEnqueueBarrierWithWaitList", (void(* const)(void))&clEnqueueBarrierWithWaitList_hid },
  {"clGetExtensionFunctionAddressForPlatform", (void(* const)(void))&clGetExtensionFunctionAddressForPlatform_hid },
  {"clCreateFromGLTexture", (void(* const)(void))&clCreateFromGLTexture_hid },
  {"clCreateFromEGLImageKHR", (void(* const)(void))&clCreateFromEGLImageKHR_hid },
  {"clEnqueueAcquireEGLObjectsKHR", (void(* const)(void))&clEnqueueAcquireEGLObjectsKHR_hid },
  {"clEnqueueReleaseEGLObjectsKHR", (void(* const)(void))&clEnqueueReleaseEGLObjectsKHR_hid },
  {"clCreateEventFromEGLSyncKHR", (void(* const)(void))&clCreateEventFromEGLSyncKHR_hid },
  {"clCreateCommandQueueWithProperties", (void(* const)(void))&clCreateCommandQueueWithProperties_hid },
  {"clCreatePipe", (void(* const)(void))&clCreatePipe_hid },
  {"clGetPipeInfo", (void(* const)(void))&clGetPipeInfo_hid },
  {"clSVMAlloc", (void(* const)(void))&clSVMAlloc_hid },
  {"clSVMFree", (void(* const)(void))&clSVMFree_hid },
  {"clEnqueueSVMFree", (void(* const)(void))&clEnqueueSVMFree_hid },
  {"clEnqueueSVMMemcpy", (void(* const)(void))&clEnqueueSVMMemcpy_hid },
  {"clEnqueueSVMMemFill", (void(* const)(void))&clEnqueueSVMMemFill_hid },
  {"clEnqueueSVMMap", (void(* const)(void))&clEnqueueSVMMap_hid },
  {"clEnqueueSVMUnmap", (void(* const)(void))&clEnqueueSVMUnmap_hid },
  {"clCreateSamplerWithProperties", (void(* const)(void))&clCreateSamplerWithProperties_hid },
  {"clSetKernelArgSVMPointer", (void(* const)(void))&clSetKernelArgSVMPointer_hid },
  {"clSetKernelExecInfo", (void(* const)(void))&clSetKernelExecInfo_hid },
  {"clGetKernelSubGroupInfoKHR", (void(* const)(void))&clGetKernelSubGroupInfoKHR_hid },
  {"clCloneKernel", (void(* const)(void))&clCloneKernel_hid },
  {"clCreateProgramWithIL", (void(* const)(void))&clCreateProgramWithIL_hid },
  {"clEnqueueSVMMigrateMem", (void(* const)(void))&clEnqueueSVMMigrateMem_hid },
  {"clGetDeviceAndHostTimer", (void(* const)(void))&clGetDeviceAndHostTimer_hid },
  {"clGetHostTimer", (void(* const)(void))&clGetHostTimer_hid },
  {"clGetKernelSubGroupInfo", (void(* const)(void))&clGetKernelSubGroupInfo_hid },
  {"clSetDefaultDeviceCommandQueue", (void(* const)(void))&clSetDefaultDeviceCommandQueue_hid },
  {"clSetProgramReleaseCallback", (void(* const)(void))&clSetProgramReleaseCallback_hid },
  {"clSetProgramSpecializationConstant", (void(* const)(void))&clSetProgramSpecializationConstant_hid },
  {"clCreateBufferWithProperties", (void(* const)(void))&clCreateBufferWithProperties_hid },
  {"clCreateImageWithProperties", (void(* const)(void))&clCreateImageWithProperties_hid },
  {"clSetContextDestructorCallback", (void(* const)(void))&clSetContextDestructorCallback_hid },
  {NULL, NULL}
};

struct _cl_icd_dispatch master_dispatch = {
  clGetPlatformIDs_disp,
  clGetPlatformInfo_disp,
  clGetDeviceIDs_disp,
  clGetDeviceInfo_disp,
  clCreateContext_disp,
  clCreateContextFromType_disp,
  clRetainContext_disp,
  clReleaseContext_disp,
  clGetContextInfo_disp,
  clCreateCommandQueue_disp,
  clRetainCommandQueue_disp,
  clReleaseCommandQueue_disp,
  clGetCommandQueueInfo_disp,
  clSetCommandQueueProperty_disp,
  clCreateBuffer_disp,
  clCreateImage2D_disp,
  clCreateImage3D_disp,
  clRetainMemObject_disp,
  clReleaseMemObject_disp,
  clGetSupportedImageFormats_disp,
  clGetMemObjectInfo_disp,
  clGetImageInfo_disp,
  clCreateSampler_disp,
  clRetainSampler_disp,
  clReleaseSampler_disp,
  clGetSamplerInfo_disp,
  clCreateProgramWithSource_disp,
  clCreateProgramWithBinary_disp,
  clRetainProgram_disp,
  clReleaseProgram_disp,
  clBuildProgram_disp,
  clUnloadCompiler_disp,
  clGetProgramInfo_disp,
  clGetProgramBuildInfo_disp,
  clCreateKernel_disp,
  clCreateKernelsInProgram_disp,
  clRetainKernel_disp,
  clReleaseKernel_disp,
  clSetKernelArg_disp,
  clGetKernelInfo_disp,
  clGetKernelWorkGroupInfo_disp,
  clWaitForEvents_disp,
  clGetEventInfo_disp,
  clRetainEvent_disp,
  clReleaseEvent_disp,
  clGetEventProfilingInfo_disp,
  clFlush_disp,
  clFinish_disp,
  clEnqueueReadBuffer_disp,
  clEnqueueWriteBuffer_disp,
  clEnqueueCopyBuffer_disp,
  clEnqueueReadImage_disp,
  clEnqueueWriteImage_disp,
  clEnqueueCopyImage_disp,
  clEnqueueCopyImageToBuffer_disp,
  clEnqueueCopyBufferToImage_disp,
  clEnqueueMapBuffer_disp,
  clEnqueueMapImage_disp,
  clEnqueueUnmapMemObject_disp,
  clEnqueueNDRangeKernel_disp,
  clEnqueueTask_disp,
  clEnqueueNativeKernel_disp,
  clEnqueueMarker_disp,
  clEnqueueWaitForEvents_disp,
  clEnqueueBarrier_disp,
  clGetExtensionFunctionAddress_disp,
  clCreateFromGLBuffer_disp,
  clCreateFromGLTexture2D_disp,
  clCreateFromGLTexture3D_disp,
  clCreateFromGLRenderbuffer_disp,
  clGetGLObjectInfo_disp,
  clGetGLTextureInfo_disp,
  clEnqueueAcquireGLObjects_disp,
  clEnqueueReleaseGLObjects_disp,
  clGetGLContextInfoKHR_disp,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  clSetEventCallback_disp,
  clCreateSubBuffer_disp,
  clSetMemObjectDestructorCallback_disp,
  clCreateUserEvent_disp,
  clSetUserEventStatus_disp,
  clEnqueueReadBufferRect_disp,
  clEnqueueWriteBufferRect_disp,
  clEnqueueCopyBufferRect_disp,
  clCreateSubDevicesEXT_disp,
  clRetainDeviceEXT_disp,
  clReleaseDeviceEXT_disp,
  clCreateEventFromGLsyncKHR_disp,
  clCreateSubDevices_disp,
  clRetainDevice_disp,
  clReleaseDevice_disp,
  clCreateImage_disp,
  clCreateProgramWithBuiltInKernels_disp,
  clCompileProgram_disp,
  clLinkProgram_disp,
  clUnloadPlatformCompiler_disp,
  clGetKernelArgInfo_disp,
  clEnqueueFillBuffer_disp,
  clEnqueueFillImage_disp,
  clEnqueueMigrateMemObjects_disp,
  clEnqueueMarkerWithWaitList_disp,
  clEnqueueBarrierWithWaitList_disp,
  clGetExtensionFunctionAddressForPlatform_disp,
  clCreateFromGLTexture_disp,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  clCreateFromEGLImageKHR_disp,
  clEnqueueAcquireEGLObjectsKHR_disp,
  clEnqueueReleaseEGLObjectsKHR_disp,
  clCreateEventFromEGLSyncKHR_disp,
  clCreateCommandQueueWithProperties_disp,
  clCreatePipe_disp,
  clGetPipeInfo_disp,
  clSVMAlloc_disp,
  clSVMFree_disp,
  clEnqueueSVMFree_disp,
  clEnqueueSVMMemcpy_disp,
  clEnqueueSVMMemFill_disp,
  clEnqueueSVMMap_disp,
  clEnqueueSVMUnmap_disp,
  clCreateSamplerWithProperties_disp,
  clSetKernelArgSVMPointer_disp,
  clSetKernelExecInfo_disp,
  clGetKernelSubGroupInfoKHR_disp,
  clCloneKernel_disp,
  clCreateProgramWithIL_disp,
  clEnqueueSVMMigrateMem_disp,
  clGetDeviceAndHostTimer_disp,
  clGetHostTimer_disp,
  clGetKernelSubGroupInfo_disp,
  clSetDefaultDeviceCommandQueue_disp,
  clSetProgramReleaseCallback_disp,
  clSetProgramSpecializationConstant_disp,
  clCreateBufferWithProperties_disp,
  clCreateImageWithProperties_disp,
  clSetContextDestructorCallback_disp,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL
};

#ifdef DEBUG_OCL_ICD
void dump_platform(clGEFA_t f, cl_platform_id pid) {
  debug(D_ALWAYS, "platform @%p:  name=field_in_struct [clGetExtensionFunctionAddress(name)/clGetExtensionFunctionAddressForPlatform(name)]", pid);
  dump_field(pid, f, clGetPlatformIDs);
  dump_field(pid, f, clGetPlatformInfo);
  dump_field(pid, f, clGetDeviceIDs);
  dump_field(pid, f, clGetDeviceInfo);
  dump_field(pid, f, clCreateContext);
  dump_field(pid, f, clCreateContextFromType);
  dump_field(pid, f, clRetainContext);
  dump_field(pid, f, clReleaseContext);
  dump_field(pid, f, clGetContextInfo);
  dump_field(pid, f, clCreateCommandQueue);
  dump_field(pid, f, clRetainCommandQueue);
  dump_field(pid, f, clReleaseCommandQueue);
  dump_field(pid, f, clGetCommandQueueInfo);
  dump_field(pid, f, clSetCommandQueueProperty);
  dump_field(pid, f, clCreateBuffer);
  dump_field(pid, f, clCreateImage2D);
  dump_field(pid, f, clCreateImage3D);
  dump_field(pid, f, clRetainMemObject);
  dump_field(pid, f, clReleaseMemObject);
  dump_field(pid, f, clGetSupportedImageFormats);
  dump_field(pid, f, clGetMemObjectInfo);
  dump_field(pid, f, clGetImageInfo);
  dump_field(pid, f, clCreateSampler);
  dump_field(pid, f, clRetainSampler);
  dump_field(pid, f, clReleaseSampler);
  dump_field(pid, f, clGetSamplerInfo);
  dump_field(pid, f, clCreateProgramWithSource);
  dump_field(pid, f, clCreateProgramWithBinary);
  dump_field(pid, f, clRetainProgram);
  dump_field(pid, f, clReleaseProgram);
  dump_field(pid, f, clBuildProgram);
  dump_field(pid, f, clUnloadCompiler);
  dump_field(pid, f, clGetProgramInfo);
  dump_field(pid, f, clGetProgramBuildInfo);
  dump_field(pid, f, clCreateKernel);
  dump_field(pid, f, clCreateKernelsInProgram);
  dump_field(pid, f, clRetainKernel);
  dump_field(pid, f, clReleaseKernel);
  dump_field(pid, f, clSetKernelArg);
  dump_field(pid, f, clGetKernelInfo);
  dump_field(pid, f, clGetKernelWorkGroupInfo);
  dump_field(pid, f, clWaitForEvents);
  dump_field(pid, f, clGetEventInfo);
  dump_field(pid, f, clRetainEvent);
  dump_field(pid, f, clReleaseEvent);
  dump_field(pid, f, clGetEventProfilingInfo);
  dump_field(pid, f, clFlush);
  dump_field(pid, f, clFinish);
  dump_field(pid, f, clEnqueueReadBuffer);
  dump_field(pid, f, clEnqueueWriteBuffer);
  dump_field(pid, f, clEnqueueCopyBuffer);
  dump_field(pid, f, clEnqueueReadImage);
  dump_field(pid, f, clEnqueueWriteImage);
  dump_field(pid, f, clEnqueueCopyImage);
  dump_field(pid, f, clEnqueueCopyImageToBuffer);
  dump_field(pid, f, clEnqueueCopyBufferToImage);
  dump_field(pid, f, clEnqueueMapBuffer);
  dump_field(pid, f, clEnqueueMapImage);
  dump_field(pid, f, clEnqueueUnmapMemObject);
  dump_field(pid, f, clEnqueueNDRangeKernel);
  dump_field(pid, f, clEnqueueTask);
  dump_field(pid, f, clEnqueueNativeKernel);
  dump_field(pid, f, clEnqueueMarker);
  dump_field(pid, f, clEnqueueWaitForEvents);
  dump_field(pid, f, clEnqueueBarrier);
  dump_field(pid, f, clGetExtensionFunctionAddress);
  dump_field(pid, f, clCreateFromGLBuffer);
  dump_field(pid, f, clCreateFromGLTexture2D);
  dump_field(pid, f, clCreateFromGLTexture3D);
  dump_field(pid, f, clCreateFromGLRenderbuffer);
  dump_field(pid, f, clGetGLObjectInfo);
  dump_field(pid, f, clGetGLTextureInfo);
  dump_field(pid, f, clEnqueueAcquireGLObjects);
  dump_field(pid, f, clEnqueueReleaseGLObjects);
  dump_field(pid, f, clGetGLContextInfoKHR);
  dump_field(pid, f, clUnknown75);
  dump_field(pid, f, clUnknown76);
  dump_field(pid, f, clUnknown77);
  dump_field(pid, f, clUnknown78);
  dump_field(pid, f, clUnknown79);
  dump_field(pid, f, clUnknown80);
  dump_field(pid, f, clSetEventCallback);
  dump_field(pid, f, clCreateSubBuffer);
  dump_field(pid, f, clSetMemObjectDestructorCallback);
  dump_field(pid, f, clCreateUserEvent);
  dump_field(pid, f, clSetUserEventStatus);
  dump_field(pid, f, clEnqueueReadBufferRect);
  dump_field(pid, f, clEnqueueWriteBufferRect);
  dump_field(pid, f, clEnqueueCopyBufferRect);
  dump_field(pid, f, clCreateSubDevicesEXT);
  dump_field(pid, f, clRetainDeviceEXT);
  dump_field(pid, f, clReleaseDeviceEXT);
  dump_field(pid, f, clCreateEventFromGLsyncKHR);
  dump_field(pid, f, clCreateSubDevices);
  dump_field(pid, f, clRetainDevice);
  dump_field(pid, f, clReleaseDevice);
  dump_field(pid, f, clCreateImage);
  dump_field(pid, f, clCreateProgramWithBuiltInKernels);
  dump_field(pid, f, clCompileProgram);
  dump_field(pid, f, clLinkProgram);
  dump_field(pid, f, clUnloadPlatformCompiler);
  dump_field(pid, f, clGetKernelArgInfo);
  dump_field(pid, f, clEnqueueFillBuffer);
  dump_field(pid, f, clEnqueueFillImage);
  dump_field(pid, f, clEnqueueMigrateMemObjects);
  dump_field(pid, f, clEnqueueMarkerWithWaitList);
  dump_field(pid, f, clEnqueueBarrierWithWaitList);
  dump_field(pid, f, clGetExtensionFunctionAddressForPlatform);
  dump_field(pid, f, clCreateFromGLTexture);
  dump_field(pid, f, clUnknown109);
  dump_field(pid, f, clUnknown110);
  dump_field(pid, f, clUnknown111);
  dump_field(pid, f, clUnknown112);
  dump_field(pid, f, clUnknown113);
  dump_field(pid, f, clUnknown114);
  dump_field(pid, f, clUnknown115);
  dump_field(pid, f, clUnknown116);
  dump_field(pid, f, clUnknown117);
  dump_field(pid, f, clUnknown118);
  dump_field(pid, f, clCreateFromEGLImageKHR);
  dump_field(pid, f, clEnqueueAcquireEGLObjectsKHR);
  dump_field(pid, f, clEnqueueReleaseEGLObjectsKHR);
  dump_field(pid, f, clCreateEventFromEGLSyncKHR);
  dump_field(pid, f, clCreateCommandQueueWithProperties);
  dump_field(pid, f, clCreatePipe);
  dump_field(pid, f, clGetPipeInfo);
  dump_field(pid, f, clSVMAlloc);
  dump_field(pid, f, clSVMFree);
  dump_field(pid, f, clEnqueueSVMFree);
  dump_field(pid, f, clEnqueueSVMMemcpy);
  dump_field(pid, f, clEnqueueSVMMemFill);
  dump_field(pid, f, clEnqueueSVMMap);
  dump_field(pid, f, clEnqueueSVMUnmap);
  dump_field(pid, f, clCreateSamplerWithProperties);
  dump_field(pid, f, clSetKernelArgSVMPointer);
  dump_field(pid, f, clSetKernelExecInfo);
  dump_field(pid, f, clGetKernelSubGroupInfoKHR);
  dump_field(pid, f, clCloneKernel);
  dump_field(pid, f, clCreateProgramWithIL);
  dump_field(pid, f, clEnqueueSVMMigrateMem);
  dump_field(pid, f, clGetDeviceAndHostTimer);
  dump_field(pid, f, clGetHostTimer);
  dump_field(pid, f, clGetKernelSubGroupInfo);
  dump_field(pid, f, clSetDefaultDeviceCommandQueue);
  dump_field(pid, f, clSetProgramReleaseCallback);
  dump_field(pid, f, clSetProgramSpecializationConstant);
  dump_field(pid, f, clCreateBufferWithProperties);
  dump_field(pid, f, clCreateImageWithProperties);
  dump_field(pid, f, clSetContextDestructorCallback);
  dump_field(pid, f, clUnknown149);
  dump_field(pid, f, clUnknown150);
  dump_field(pid, f, clUnknown151);
  dump_field(pid, f, clUnknown152);
  dump_field(pid, f, clUnknown153);
  dump_field(pid, f, clUnknown154);
  dump_field(pid, f, clUnknown155);
  dump_field(pid, f, clUnknown156);
  dump_field(pid, f, clUnknown157);
  dump_field(pid, f, clUnknown158);
  dump_field(pid, f, clUnknown159);
  dump_field(pid, f, clUnknown160);
  dump_field(pid, f, clUnknown161);
  dump_field(pid, f, clUnknown162);
  dump_field(pid, f, clUnknown163);
  dump_field(pid, f, clUnknown164);
  dump_field(pid, f, clUnknown165);
  dump_field(pid, f, clUnknown166);
  dump_field(pid, f, clUnknown167);
  dump_field(pid, f, clUnknown168);
  dump_field(pid, f, clUnknown169);
  dump_field(pid, f, clUnknown170);
  dump_field(pid, f, clUnknown171);
  dump_field(pid, f, clUnknown172);
  dump_field(pid, f, clUnknown173);
  dump_field(pid, f, clUnknown174);
  dump_field(pid, f, clUnknown175);
  dump_field(pid, f, clUnknown176);
  dump_field(pid, f, clUnknown177);
  dump_field(pid, f, clUnknown178);
  dump_field(pid, f, clUnknown179);
  dump_field(pid, f, clUnknown180);
  dump_field(pid, f, clUnknown181);
  dump_field(pid, f, clUnknown182);
}
#endif

#pragma GCC visibility pop

