#include <config.h>

#include "../lstrings.h"

#include <iostream>


using namespace lyx::support;
using namespace lyx;

using namespace std;

void test_lowercase()
{
	cout << to_ascii(docstring(1, lowercase(char_type('A')))) << endl;
	cout << to_ascii(lowercase(from_ascii("AlLe"))) << endl;
	cout << lowercase('A') << endl;
	cout << ascii_lowercase("AlLe") << endl;
}

void test_uppercase()
{
	cout << to_ascii(docstring(1, uppercase(char_type('a')))) << endl;
	cout << to_ascii(uppercase(from_ascii("AlLe"))) << endl;
	cout << uppercase('a') << endl;
}

void test_formatFPNumber()
{
	double const numbers[] = {
		0,
		1,
		23.42,
		1.3754937356458394574047e-20,
		1.3754937356458394574047e-19,
		1.3754937356458394574047e-18,
		1.3754937356458394574047e-17,
		1.3754937356458394574047e-16,
		1.3754937356458394574047e-15,
		1.3754937356458394574047e-14,
		1.3754937356458394574047e-13,
		1.3754937356458394574047e-12,
		1.3754937356458394574047e-11,
		1.3754937356458394574047e-10,
		1.3754937356458394574047e-9,
		1.3754937356458394574047e-8,
		1.3754937356458394574047e-7,
		1.3754937356458394574047e-6,
		1.3754937356458394574047e-5,
		1.3754937356458394574047e-4,
		1.3754937356458394574047e-3,
		1.3754937356458394574047e-2,
		1.3754937356458394574047e-1,
		1.3754937356458394574047,
		1.3754937356458394574047e1,
		1.3754937356458394574047e2,
		1.3754937356458394574047e3,
		1.3754937356458394574047e4,
		1.3754937356458394574047e5,
		1.3754937356458394574047e6,
		1.3754937356458394574047e7,
		1.3754937356458394574047e8,
		1.3754937356458394574047e9,
		1.3754937356458394574047e10,
		1.3754937356458394574047e11,
		1.3754937356458394574047e12,
		1.3754937356458394574047e13,
		1.3754937356458394574047e14,
		1.3754937356458394574047e15,
		1.3754937356458394574047e16,
		1.3754937356458394574047e17,
		1.3754937356458394574047e18,
		1.3754937356458394574047e19,
		1.3754937356458394574047e20,
		1e-42,
		1e42
	};
	int const n = sizeof(numbers) / sizeof(numbers[0]);
	for (int i = 0; i < n; ++i)
		cout << formatFPNumber(numbers[i]) << endl;
	for (int i = 0; i < n; ++i)
		cout << formatFPNumber(-numbers[i]) << endl;
}

int main()
{
	test_lowercase();
	test_uppercase();
	test_formatFPNumber();
}
