; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=mips-mti-linux-gnu -mcpu=mips32r2 < %s -asm-show-inst | FileCheck %s --check-prefix=MIPS32
; RUN: llc -mtriple=mips-mti-linux-gnu -mcpu=mips32r2 -mattr=+micromips < %s -asm-show-inst | FileCheck %s --check-prefix=MMR3
; RUN: llc -mtriple=mips-img-linux-gnu -mcpu=mips32r6 < %s -asm-show-inst | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc -mtriple=mips-img-linux-gnu -mcpu=mips32r6 -mattr=+micromips < %s -asm-show-inst | FileCheck %s --check-prefix=MMR6
; RUN: llc -mtriple=mips64-mti-linux-gnu -mcpu=mips3 < %s -asm-show-inst | FileCheck %s --check-prefix=MIPS3
; RUN: llc -mtriple=mips64-mti-linux-gnu -mcpu=mips64 < %s -asm-show-inst | FileCheck %s --check-prefix=MIPS64
; RUN: llc -mtriple=mips64-img-linux-gnu -mcpu=mips64r6 < %s -asm-show-inst | FileCheck %s --check-prefix=MIPS64R6

; Test subword and word loads.

@a = common global i8 0, align 4
@b = common global i16 0, align 4
@c = common global i32 0, align 4
@d = common global i64 0, align 8

define i8 @f1() {
; MIPS32-LABEL: f1:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MMR3-LABEL: f1:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS32R6-LABEL: f1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MMR6-LABEL: f1:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MMR6-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(a))>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f1:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu
; MIPS3-NEXT:    # <MCOperand Reg:321>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS64-LABEL: f1:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu
; MIPS64-NEXT:    # <MCOperand Reg:321>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS64R6-LABEL: f1:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lbu $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LBu
; MIPS64R6-NEXT:    # <MCOperand Reg:321>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(a))>>
entry:
  %0 = load i8, i8 * @a
  ret i8 %0
}

define i32 @f2() {
; MIPS32-LABEL: f2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MMR3-LABEL: f2:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS32R6-LABEL: f2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MMR6-LABEL: f2:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(a) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MMR6-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(a))>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f2:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB
; MIPS3-NEXT:    # <MCOperand Reg:321>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS64-LABEL: f2:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB
; MIPS64-NEXT:    # <MCOperand Reg:321>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(a))>>
;
; MIPS64R6-LABEL: f2:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(a) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(a))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(a))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(a) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(a))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lb $2, %lo(a)($1) # <MCInst #{{[0-9]+}} LB
; MIPS64R6-NEXT:    # <MCOperand Reg:321>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(a))>>
entry:
  %0 = load i8, i8 * @a
  %1 = sext i8 %0 to i32
  ret i32 %1
}

define i16 @f3() {
; MIPS32-LABEL: f3:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MMR3-LABEL: f3:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS32R6-LABEL: f3:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MMR6-LABEL: f3:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MMR6-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(b))>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f3:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu
; MIPS3-NEXT:    # <MCOperand Reg:321>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS64-LABEL: f3:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu
; MIPS64-NEXT:    # <MCOperand Reg:321>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS64R6-LABEL: f3:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lhu $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LHu
; MIPS64R6-NEXT:    # <MCOperand Reg:321>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(b))>>
entry:
  %0 = load i16, i16 * @b
  ret i16 %0
}

define i32 @f4() {
; MIPS32-LABEL: f4:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MMR3-LABEL: f4:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS32R6-LABEL: f4:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MMR6-LABEL: f4:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(b) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MMR6-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(b))>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f4:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH
; MIPS3-NEXT:    # <MCOperand Reg:321>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS64-LABEL: f4:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH
; MIPS64-NEXT:    # <MCOperand Reg:321>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(b))>>
;
; MIPS64R6-LABEL: f4:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(b) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(b))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(b))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(b) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(b))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lh $2, %lo(b)($1) # <MCInst #{{[0-9]+}} LH
; MIPS64R6-NEXT:    # <MCOperand Reg:321>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(b))>>
entry:
  %0 = load i16, i16 * @b
  %1 = sext i16 %0 to i32
  ret i32 %1
}

define i32 @f5() {
; MIPS32-LABEL: f5:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MMR3-LABEL: f5:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS32R6-LABEL: f5:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MMR6-LABEL: f5:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR6-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f5:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS3-NEXT:    # <MCOperand Reg:321>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64-LABEL: f5:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS64-NEXT:    # <MCOperand Reg:321>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64R6-LABEL: f5:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS64R6-NEXT:    # <MCOperand Reg:321>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
entry:
  %0 = load i32, i32 * @c
  ret i32 %0
}

define i64 @f6() {
; MIPS32-LABEL: f6:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32-NEXT:    # <MCOperand Reg:322>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    addiu $2, $zero, 0 # <MCInst #{{[0-9]+}} ADDiu
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:21>
; MIPS32-NEXT:    # <MCOperand Imm:0>>
;
; MMR3-LABEL: f6:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR3-NEXT:    li16 $2, 0 # <MCInst #{{[0-9]+}} LI16_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Imm:0>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR3-NEXT:    # <MCOperand Reg:322>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS32R6-LABEL: f6:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32R6-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32R6-NEXT:    # <MCOperand Reg:322>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    addiu $2, $zero, 0 # <MCInst #{{[0-9]+}} ADDiu
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Imm:0>>
;
; MMR6-LABEL: f6:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR6-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR6-NEXT:    # <MCOperand Reg:322>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MMR6-NEXT:    li16 $2, 0 # <MCInst #{{[0-9]+}} LI16_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Imm:0>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f6:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lwu $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LWu
; MIPS3-NEXT:    # <MCOperand Reg:416>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64-LABEL: f6:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lwu $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LWu
; MIPS64-NEXT:    # <MCOperand Reg:416>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64R6-LABEL: f6:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lwu $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LWu
; MIPS64R6-NEXT:    # <MCOperand Reg:416>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
entry:
  %0 = load i32, i32 * @c
  %1 = zext i32 %0 to i64
  ret i64 %1
}

define i64 @f7() {
; MIPS32-LABEL: f7:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32-NEXT:    # <MCOperand Reg:322>
; MIPS32-NEXT:    # <MCOperand Reg:1>
; MIPS32-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MIPS32-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS32-NEXT:    # <MCOperand Reg:19>>
; MIPS32-NEXT:    sra $2, $3, 31 # <MCInst #{{[0-9]+}} SRA
; MIPS32-NEXT:    # <MCOperand Reg:321>
; MIPS32-NEXT:    # <MCOperand Reg:322>
; MIPS32-NEXT:    # <MCOperand Imm:31>>
;
; MMR3-LABEL: f7:
; MMR3:       # %bb.0: # %entry
; MMR3-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR3-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR3-NEXT:    # <MCOperand Reg:322>
; MMR3-NEXT:    # <MCOperand Reg:1>
; MMR3-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MMR3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR_MM
; MMR3-NEXT:    # <MCOperand Reg:19>>
; MMR3-NEXT:    sra $2, $3, 31 # <MCInst #{{[0-9]+}} SRA_MM
; MMR3-NEXT:    # <MCOperand Reg:321>
; MMR3-NEXT:    # <MCOperand Reg:322>
; MMR3-NEXT:    # <MCOperand Imm:31>>
;
; MIPS32R6-LABEL: f7:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS32R6-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW
; MIPS32R6-NEXT:    # <MCOperand Reg:322>
; MIPS32R6-NEXT:    # <MCOperand Reg:1>
; MIPS32R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MIPS32R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR
; MIPS32R6-NEXT:    # <MCOperand Reg:21>
; MIPS32R6-NEXT:    # <MCOperand Reg:19>>
; MIPS32R6-NEXT:    sra $2, $3, 31 # <MCInst #{{[0-9]+}} SRA
; MIPS32R6-NEXT:    # <MCOperand Reg:321>
; MIPS32R6-NEXT:    # <MCOperand Reg:322>
; MIPS32R6-NEXT:    # <MCOperand Imm:31>>
;
; MMR6-LABEL: f7:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    lui $1, %hi(c) # <MCInst #{{[0-9]+}} LUi
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MMR6-NEXT:    lw $3, %lo(c)($1) # <MCInst #{{[0-9]+}} LW_MM
; MMR6-NEXT:    # <MCOperand Reg:322>
; MMR6-NEXT:    # <MCOperand Reg:1>
; MMR6-NEXT:    # <MCOperand Expr:(%lo(c))>>
; MMR6-NEXT:    sra $2, $3, 31 # <MCInst #{{[0-9]+}} SRA_MM
; MMR6-NEXT:    # <MCOperand Reg:321>
; MMR6-NEXT:    # <MCOperand Reg:322>
; MMR6-NEXT:    # <MCOperand Imm:31>>
; MMR6-NEXT:    jrc $ra # <MCInst #{{[0-9]+}} JRC16_MM
; MMR6-NEXT:    # <MCOperand Reg:19>>
;
; MIPS3-LABEL: f7:
; MIPS3:       # %bb.0: # %entry
; MIPS3-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS3-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS3-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Imm:16>>
; MIPS3-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS3-NEXT:    # <MCOperand Reg:301>>
; MIPS3-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW64
; MIPS3-NEXT:    # <MCOperand Reg:416>
; MIPS3-NEXT:    # <MCOperand Reg:30>
; MIPS3-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64-LABEL: f7:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Imm:16>>
; MIPS64-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JR
; MIPS64-NEXT:    # <MCOperand Reg:301>>
; MIPS64-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW64
; MIPS64-NEXT:    # <MCOperand Reg:416>
; MIPS64-NEXT:    # <MCOperand Reg:30>
; MIPS64-NEXT:    # <MCOperand Expr:(%lo(c))>>
;
; MIPS64R6-LABEL: f7:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %highest(c) # <MCInst #{{[0-9]+}} LUi64
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%highest(c))>>
; MIPS64R6-NEXT:    daddiu $1, $1, %higher(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%higher(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    daddiu $1, $1, %hi(c) # <MCInst #{{[0-9]+}} DADDiu
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%hi(c))>>
; MIPS64R6-NEXT:    dsll $1, $1, 16 # <MCInst #{{[0-9]+}} DSLL
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Imm:16>>
; MIPS64R6-NEXT:    jr $ra # <MCInst #{{[0-9]+}} JALR64
; MIPS64R6-NEXT:    # <MCOperand Reg:355>
; MIPS64R6-NEXT:    # <MCOperand Reg:301>>
; MIPS64R6-NEXT:    lw $2, %lo(c)($1) # <MCInst #{{[0-9]+}} LW64
; MIPS64R6-NEXT:    # <MCOperand Reg:416>
; MIPS64R6-NEXT:    # <MCOperand Reg:30>
; MIPS64R6-NEXT:    # <MCOperand Expr:(%lo(c))>>
entry:
  %0 = load i32, i32 * @c
  %1 = sext i32 %0 to i64
  ret i64 %1
}
