; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 | FileCheck %s

declare void @sideeffect0()
declare void @sideeffect1()
declare void @sideeffect2()
declare void @use8(i8)
declare i1 @gen1()

define i1 @t0_or_binop(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t0_or_binop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp eq i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = or i1 [[C1]], [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp eq i8 %v2, 0 ; canonical predicate
  %computed = or i1 %c1, %c2 ; binary or
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t1_or_logical(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t1_or_logical(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp eq i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 true, i1 [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp eq i8 %v2, 0 ; canonical predicate
  %computed = select i1 %c1, i1 true, i1 %c2 ; logical or
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}

define i1 @t2_and_binop(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t2_and_binop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp eq i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = and i1 [[C1]], [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp eq i8 %v2, 0 ; canonical predicate
  %computed = and i1 %c1, %c2 ; binary and
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t3_and_logical(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t3_and_logical(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp eq i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 [[C2]], i1 false
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp eq i8 %v2, 0 ; canonical predicate
  %computed = select i1 %c1, i1 %c2, i1 false ; logical and
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}


define i1 @t4_nor_binop(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t4_nor_binop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp ne i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = and i1 [[C1]], [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp ne i8 %v1, 0 ; non-canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = and i1 %c1, %c2 ; binary and
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t5_nor_logical(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t5_nor_logical(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp ne i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 [[C2]], i1 false
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp ne i8 %v1, 0 ; non-canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = select i1 %c1, i1 %c2, i1 false ; logical and
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t6_nor_logical2(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t6_nor_logical2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 false, i1 [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = select i1 %c1, i1 false, i1 %c2 ; huh, what is this, logical nand?
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}

define i1 @t7_nand_binop(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t7_nand_binop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp ne i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = or i1 [[C1]], [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp ne i8 %v1, 0 ; non-canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = or i1 %c1, %c2 ; binary and
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t8_nand_logical(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t8_nand_logical(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp ne i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 true, i1 [[C2]]
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp ne i8 %v1, 0 ; non-canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = select i1 %c1, i1 true, i1 %c2 ; logical or
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
define i1 @t9_nand_logical2(i8 %v0, i8 %v1, i8 %v2, i1 %v3) {
; CHECK-LABEL: @t9_nand_logical2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C0:%.*]] = icmp eq i8 [[V0:%.*]], 0
; CHECK-NEXT:    br i1 [[C0]], label [[PRED0:%.*]], label [[END:%.*]]
; CHECK:       pred0:
; CHECK-NEXT:    [[C1:%.*]] = icmp eq i8 [[V1:%.*]], 0
; CHECK-NEXT:    [[C2:%.*]] = icmp ne i8 [[V2:%.*]], 0
; CHECK-NEXT:    [[COMPUTED:%.*]] = select i1 [[C1]], i1 [[C2]], i1 true
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[R:%.*]] = phi i1 [ [[COMPUTED]], [[PRED0]] ], [ [[V3:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i1 [[R]]
;
entry:
  %c0 = icmp eq i8 %v0, 0 ; canonical predicate
  br i1 %c0, label %pred0, label %pred1

pred0:
  %c1 = icmp eq i8 %v1, 0 ; canonical predicate
  %c2 = icmp ne i8 %v2, 0 ; non-canonical predicate
  %computed = select i1 %c1, i1 %c2, i1 true ; huh, what is this, logical nor?
  br label %end

pred1:
  br label %end

end:
  %r = phi i1 [ %computed, %pred0 ], [ %v3, %pred1 ]
  ret i1 %r
}
