; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+movrs,+avx10.2-512 -verify-machineinstrs --show-mc-encoding | FileCheck %s --check-prefixes=CHECK

declare <64 x i8> @llvm.x86.avx10.vmovrsb512(ptr)
declare <16 x i32> @llvm.x86.avx10.vmovrsd512(ptr)
declare <8 x i64> @llvm.x86.avx10.vmovrsq512(ptr)
declare <32 x i16> @llvm.x86.avx10.vmovrsw512(ptr)

define <8 x i64> @test_mm512_movrsb_epi8(ptr %__A) {
; CHECK-LABEL: test_mm512_movrsb_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsb (%rdi), %zmm0 # encoding: [0x62,0xf5,0x7f,0x48,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <64 x i8> @llvm.x86.avx10.vmovrsb512(ptr %__A)
  %1 = bitcast <64 x i8> %0 to <8 x i64>
  ret <8 x i64> %1
}

define <8 x i64> @test_mm512_mask_movrsb_epi8(<8 x i64> %__A, i64 %__B, ptr %__C) {
; CHECK-LABEL: test_mm512_mask_movrsb_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovq %rdi, %k1 # encoding: [0xc4,0xe1,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %zmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x49,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <64 x i8> @llvm.x86.avx10.vmovrsb512(ptr %__C)
  %1 = bitcast <8 x i64> %__A to <64 x i8>
  %2 = bitcast i64 %__B to <64 x i1>
  %3 = select <64 x i1> %2, <64 x i8> %0, <64 x i8> %1
  %4 = bitcast <64 x i8> %3 to <8 x i64>
  ret <8 x i64> %4
}

define dso_local <8 x i64> @test_mm512_maskz_movrsb_epi8(i64 %__A, ptr %__B) {
; CHECK-LABEL: test_mm512_maskz_movrsb_epi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovq %rdi, %k1 # encoding: [0xc4,0xe1,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xc9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <64 x i8> @llvm.x86.avx10.vmovrsb512(ptr %__B)
  %1 = bitcast i64 %__A to <64 x i1>
  %2 = select <64 x i1> %1, <64 x i8> %0, <64 x i8> zeroinitializer
  %3 = bitcast <64 x i8> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_movrsd_epi32(ptr %__A) {
; CHECK-LABEL: test_mm512_movrsd_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsd (%rdi), %zmm0 # encoding: [0x62,0xf5,0x7e,0x48,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.vmovrsd512(ptr %__A)
  %1 = bitcast <16 x i32> %0 to <8 x i64>
  ret <8 x i64> %1
}

define <8 x i64> @test_mm512_mask_movrsd_epi32(<8 x i64> %__A, i16 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm512_mask_movrsd_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %zmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x49,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.vmovrsd512(ptr %__C)
  %1 = bitcast <8 x i64> %__A to <16 x i32>
  %2 = bitcast i16 %__B to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i32> %0, <16 x i32> %1
  %4 = bitcast <16 x i32> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_maskz_movrsd_epi32(i16 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm512_maskz_movrsd_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xc9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i32> @llvm.x86.avx10.vmovrsd512(ptr %__B)
  %1 = bitcast i16 %__A to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i32> %0, <16 x i32> zeroinitializer
  %3 = bitcast <16 x i32> %2 to <8 x i64>
  ret <8 x i64> %3
}

define <8 x i64> @test_mm512_movrsq_epi64(ptr %__A) {
; CHECK-LABEL: test_mm512_movrsq_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsq (%rdi), %zmm0 # encoding: [0x62,0xf5,0xfe,0x48,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx10.vmovrsq512(ptr %__A)
  ret <8 x i64> %0
}

define <8 x i64> @test_mm512_mask_movrsq_epi64(<8 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm512_mask_movrsq_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %zmm0 {%k1} # encoding: [0x62,0xf5,0xfe,0x49,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx10.vmovrsq512(ptr %__C)
  %1 = bitcast i8 %__B to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> %__A
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_maskz_movrsq_epi64(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm512_maskz_movrsq_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfe,0xc9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i64> @llvm.x86.avx10.vmovrsq512(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i64> %0, <8 x i64> zeroinitializer
  ret <8 x i64> %2
}

define <8 x i64> @test_mm512_movrsw_epi16(ptr %__A) {
; CHECK-LABEL: test_mm512_movrsw_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsw (%rdi), %zmm0 # encoding: [0x62,0xf5,0xff,0x48,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vmovrsw512(ptr %__A)
  %1 = bitcast <32 x i16> %0 to <8 x i64>
  ret <8 x i64> %1
}

define <8 x i64> @test_mm512_mask_movrsw_epi16(<8 x i64> %__A, i32 %__B, ptr %__C) {
; CHECK-LABEL: test_mm512_mask_movrsw_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %zmm0 {%k1} # encoding: [0x62,0xf5,0xff,0x49,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vmovrsw512(ptr %__C)
  %1 = bitcast <8 x i64> %__A to <32 x i16>
  %2 = bitcast i32 %__B to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i16> %0, <32 x i16> %1
  %4 = bitcast <32 x i16> %3 to <8 x i64>
  ret <8 x i64> %4
}

define <8 x i64> @test_mm512_maskz_movrsw_epi16(i32 %__A, ptr %__B) {
; CHECK-LABEL: test_mm512_maskz_movrsw_epi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0xff,0xc9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i16> @llvm.x86.avx10.vmovrsw512(ptr %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i16> %0, <32 x i16> zeroinitializer
  %3 = bitcast <32 x i16> %2 to <8 x i64>
  ret <8 x i64> %3
}
