; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel=0 | FileCheck %s --check-prefixes=SDAG-X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -global-isel=0 | FileCheck %s --check-prefixes=SDAG-X64
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X86
; RUN: llc < %s -mtriple=x86_64-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X64

define float @use_atan2f32(float %a, float %b) nounwind {
; SDAG-X86-LABEL: use_atan2f32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $12, %esp
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstps {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstps (%esp)
; SDAG-X86-NEXT:    calll atan2f
; SDAG-X86-NEXT:    addl $12, %esp
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: use_atan2f32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp atan2f@PLT # TAILCALL
;
; GISEL-X86-LABEL: use_atan2f32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    calll atan2f
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: use_atan2f32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq atan2f
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %x = call float @llvm.atan2.f32(float %a, float %b)
  ret float %x
}

define double @use_atan2f64(double %a, double %b) nounwind {
; SDAG-X86-LABEL: use_atan2f64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $28, %esp
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpl (%esp)
; SDAG-X86-NEXT:    calll atan2
; SDAG-X86-NEXT:    addl $28, %esp
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: use_atan2f64:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp atan2@PLT # TAILCALL
;
; GISEL-X86-LABEL: use_atan2f64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    pushl %edi
; GISEL-X86-NEXT:    pushl %esi
; GISEL-X86-NEXT:    subl $20, %esp
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; GISEL-X86-NEXT:    movl 4(%edx), %edx
; GISEL-X86-NEXT:    xorl %edi, %edi
; GISEL-X86-NEXT:    addl %esp, %edi
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%edi)
; GISEL-X86-NEXT:    movl $8, %eax
; GISEL-X86-NEXT:    addl %esp, %eax
; GISEL-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movl %edx, 4(%eax)
; GISEL-X86-NEXT:    calll atan2
; GISEL-X86-NEXT:    addl $20, %esp
; GISEL-X86-NEXT:    popl %esi
; GISEL-X86-NEXT:    popl %edi
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: use_atan2f64:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq atan2
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %x = call double @llvm.atan2.f64(double %a, double %b)
  ret double %x
}

define x86_fp80 @use_atan2f80(x86_fp80 %a, x86_fp80 %b) nounwind {
; SDAG-X86-LABEL: use_atan2f80:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $28, %esp
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpt (%esp)
; SDAG-X86-NEXT:    calll atan2l
; SDAG-X86-NEXT:    addl $28, %esp
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: use_atan2f80:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    subq $40, %rsp
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fstpt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fstpt (%rsp)
; SDAG-X64-NEXT:    callq atan2l@PLT
; SDAG-X64-NEXT:    addq $40, %rsp
; SDAG-X64-NEXT:    retq
;
; GISEL-X86-LABEL: use_atan2f80:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $28, %esp
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fstpt (%esp)
; GISEL-X86-NEXT:    fstpt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    calll atan2l
; GISEL-X86-NEXT:    addl $28, %esp
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: use_atan2f80:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    subq $40, %rsp
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    fstpt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    callq atan2l
; GISEL-X64-NEXT:    addq $40, %rsp
; GISEL-X64-NEXT:    retq
  %x = call x86_fp80 @llvm.atan2.f80(x86_fp80 %a, x86_fp80 %b)
  ret x86_fp80 %x
}

declare float @llvm.atan2.f32(float, float)
declare double @llvm.atan2.f64(double, double)
declare x86_fp80 @llvm.atan2.f80(x86_fp80, x86_fp80)
