; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=x86_64 -mattr=+nf -verify-machineinstrs | FileCheck %s

define void @convertToThreeAddress(ptr %arg, ptr %arg1) {
; CHECK-LABEL: convertToThreeAddress:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movslq (%rdi), %rax
; CHECK-NEXT:    movslq (%rsi), %rcx
; CHECK-NEXT:    subq %rax, %rcx
; CHECK-NEXT:    leaq 1(%rcx), %rax
; CHECK-NEXT:    js .LBB0_1
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB0_6: # %bb
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    cmpq $1, %rax
; CHECK-NEXT:    jg .LBB0_6
; CHECK-NEXT:  .LBB0_5: # %bb16
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB0_1:
; CHECK-NEXT:    xorl %edx, %edx
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB0_2: # %bb10
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    testb %dl, %dl
; CHECK-NEXT:    je .LBB0_3
; CHECK-NEXT:  # %bb.7: # %bb11
; CHECK-NEXT:    # in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    testq %rcx, %rcx
; CHECK-NEXT:    jns .LBB0_2
; CHECK-NEXT:    jmp .LBB0_5
; CHECK-NEXT:  .LBB0_3: # %bb10
; CHECK-NEXT:    xorl %ecx, %ecx
; CHECK-NEXT:    testb %cl, %cl
; CHECK-NEXT:    jne .LBB0_5
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB0_4: # %bb12
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    cmpq $1, %rax
; CHECK-NEXT:    jg .LBB0_4
; CHECK-NEXT:    jmp .LBB0_5
entry:
  %i = load i32, ptr %arg, align 4
  %i2 = sext i32 %i to i64
  %i3 = load i32, ptr %arg1, align 4
  %i4 = sext i32 %i3 to i64
  %i5 = sub nsw i64 %i4, %i2
  %i6 = add nsw i64 %i5, 1
  %i7 = icmp sgt i64 %i5, -1
  br i1 %i7, label %bb, label %bb10

bb:                                               ; preds = %bb, %entry
  %i8 = phi i64 [ %i6, %entry ], [ poison, %bb ]
  %i9 = icmp sgt i64 %i8, 1
  br i1 %i9, label %bb, label %bb16

bb10:                                             ; preds = %bb11, %entry
  switch i32 poison, label %bb16 [
    i32 1, label %bb11
    i32 2, label %bb12
  ]

bb11:                                             ; preds = %bb10
  br i1 %i7, label %bb10, label %bb16

bb12:                                             ; preds = %bb14, %bb10
  %i13 = phi i64 [ poison, %bb14 ], [ %i6, %bb10 ]
  br label %bb14

bb14:                                             ; preds = %bb12
  %i15 = icmp sgt i64 %i13, 1
  br i1 %i15, label %bb12, label %bb16

bb16:                                             ; preds = %bb14, %bb11, %bb10, %bb
  ret void
}

; We must not try to replace CMP with AND_NF as it sets no flags
define void @cmp_peephole_and_nf(i64 %arg0, ptr %ptr1, ptr %ptr2) {
; CHECK-LABEL: cmp_peephole_and_nf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    negq %rdi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    {nf} andl $1, %eax
; CHECK-NEXT:    jb .LBB1_2
; CHECK-NEXT:  # %bb.1: # %true
; CHECK-NEXT:    testq %rax, %rax
; CHECK-NEXT:    sete (%rsi)
; CHECK-NEXT:    retq
; CHECK-NEXT:  .LBB1_2: # %false
; CHECK-NEXT:    movq %rdi, (%rsi)
; CHECK-NEXT:    movq %rax, (%rdx)
; CHECK-NEXT:    retq
entry:
  %sub_flag = sub i64 0, %arg0
  %and_nf = and i64 %sub_flag, 1
  %elim = icmp eq i64 0, %arg0
  br i1 %elim, label %true, label %false

true:
  %8 = icmp eq i64 %and_nf, 0
  store i1 %8, ptr %ptr1
  ret void

false:
  store i64 %sub_flag, ptr %ptr1
  store i64 %and_nf, ptr %ptr2
  ret void
}
