; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX7LESS,GFX7LESS_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX8,GFX8_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064,GFX1064_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032,GFX1032_ITERATIVE %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164-TRUE16,GFX1164_ITERATIVE,GFX1164_ITERATIVE-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164-FAKE16,GFX1164_ITERATIVE,GFX1164_ITERATIVE-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132-TRUE16,GFX1132_ITERATIVE,GFX1132_ITERATIVE-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132-FAKE16,GFX1132_ITERATIVE,GFX1132_ITERATIVE-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1264,GFX1264-TRUE16,GFX1264_ITERATIVE,GFX1264_ITERATIVE-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1264,GFX1264-FAKE16,GFX1264_ITERATIVE,GFX1264_ITERATIVE-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1232,GFX1232-TRUE16,GFX1232_ITERATIVE,GFX1232_ITERATIVE-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=Iterative -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1232,GFX1232-FAKE16,GFX1232_ITERATIVE,GFX1232_ITERATIVE-FAKE16 %s
; RUN: llc -mtriple=amdgcn -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX7LESS,GFX7LESS_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX8,GFX8_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1064,GFX1064_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1032,GFX1032_DPP %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164-TRUE16,GFX1164_DPP,GFX1164_DPP-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1164,GFX1164-FAKE16,GFX1164_DPP,GFX1164_DPP-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132-TRUE16,GFX1132_DPP,GFX1132_DPP-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1132,GFX1132-FAKE16,GFX1132_DPP,GFX1132_DPP-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1264,GFX1264-TRUE16,GFX1264_DPP,GFX1264_DPP-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -mattr=+wavefrontsize64 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1264,GFX1264-FAKE16,GFX1264_DPP,GFX1264_DPP-FAKE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1232,GFX1232-TRUE16,GFX1232_DPP,GFX1232_DPP-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 -mattr=+wavefrontsize32 -mattr=-flat-for-global -amdgpu-atomic-optimizer-strategy=DPP -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX1232,GFX1232-FAKE16,GFX1232_DPP,GFX1232_DPP-FAKE16 %s

declare i32 @llvm.amdgcn.workitem.id.x()

; Show what the atomic optimization pass will do for global pointers.

define amdgpu_kernel void @add_i32_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB0_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB0_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB0_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB0_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB0_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_mad_u32_u24 v0, v0, 5, s4
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB0_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB0_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB0_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB0_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB0_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB0_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB0_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB0_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i32_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB0_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB0_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i32_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB0_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB0_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    v_mad_u32_u24 v0, v0, 5, s2
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i32 5 syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i32 %additive) {
; GFX7LESS-LABEL: add_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s8, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB1_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s6, s8, s6
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s2
; GFX7LESS-NEXT:    s_mov_b32 s13, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB1_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB1_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s8, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB1_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB1_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s8, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB1_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_add_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB1_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s6, s8, s6
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_mov_b32 s12, s2
; GFX1064-NEXT:    s_mov_b32 s13, s3
; GFX1064-NEXT:    buffer_atomic_add v1, off, s[12:15], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB1_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s8, v0, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s7, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s7, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB1_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s7
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s5, s6, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB1_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, s6, v0, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB1_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s6, s8, s6
; GFX1164-NEXT:    s_mov_b32 s14, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_mov_b32 s12, s2
; GFX1164-NEXT:    s_mov_b32 s13, s3
; GFX1164-NEXT:    buffer_atomic_add_u32 v1, off, s[12:15], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB1_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[1:2], null, s8, v0, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v1, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB1_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s4, s6
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB1_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[1:2], null, s4, v0, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v1, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i32_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB1_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s8, s6
; GFX1264-NEXT:    s_mov_b32 s14, -1
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_mov_b32 s12, s2
; GFX1264-NEXT:    s_mov_b32 s13, s3
; GFX1264-NEXT:    buffer_atomic_add_u32 v1, off, s[12:15], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB1_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, s8, v0, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i32_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s5, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB1_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_mul_i32 s6, s4, s6
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB1_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, s4, v0, s[2:3]
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i32 %additive syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i32_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS_ITERATIVE-LABEL: add_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB2_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS_ITERATIVE-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_wbinvl1
; GFX7LESS_ITERATIVE-NEXT:  .LBB2_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    v_add_i32_e32 v0, vcc, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX8_ITERATIVE-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX8_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX8_ITERATIVE-NEXT:  .LBB2_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_add_u32_e32 v0, vcc, s4, v1
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX9_ITERATIVE-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX9_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX9_ITERATIVE-NEXT:  .LBB2_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_add_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s7, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s6, s6, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1064_ITERATIVE-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX1064_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB2_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s1
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s6, s6, s2
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1032_ITERATIVE-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX1032_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB2_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s7, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s7
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s7
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s6, s6, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1164_ITERATIVE-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1164_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB2_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s2, v1, s1
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s6, s6, s2
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1132_ITERATIVE-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], 0 glc
; GFX1132_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB2_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX1264_ITERATIVE-LABEL: add_i32_varying:
; GFX1264_ITERATIVE:       ; %bb.0: ; %entry
; GFX1264_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1264_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1264_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264_ITERATIVE-NEXT:    s_ctz_i32_b64 s7, s[0:1]
; GFX1264_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s7
; GFX1264_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s7
; GFX1264_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1264_ITERATIVE-NEXT:    s_add_co_i32 s6, s6, s8
; GFX1264_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1264_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1264_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1264_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1264_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1264_ITERATIVE-NEXT:  ; %bb.3:
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1264_ITERATIVE-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1264_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:  .LBB2_4:
; GFX1264_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1264_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264_ITERATIVE-NEXT:    s_endpgm
;
; GFX1232_ITERATIVE-LABEL: add_i32_varying:
; GFX1232_ITERATIVE:       ; %bb.0: ; %entry
; GFX1232_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1232_ITERATIVE-NEXT:  .LBB2_1: ; %ComputeLoop
; GFX1232_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s2, v1, s1
; GFX1232_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1232_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s3
; GFX1232_ITERATIVE-NEXT:    s_add_co_i32 s6, s6, s2
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1232_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX1232_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1232_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_cbranch_execz .LBB2_4
; GFX1232_ITERATIVE-NEXT:  ; %bb.3:
; GFX1232_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1232_ITERATIVE-NEXT:    buffer_atomic_add_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1232_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:  .LBB2_4:
; GFX1232_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_ITERATIVE-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1232_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s6, -1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s10, s6
; GFX7LESS_DPP-NEXT:    s_mov_b32 s11, s7
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_DPP-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_DPP-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX7LESS_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_DPP-NEXT:    buffer_wbinvl1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s4, s0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s5, s1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[4:5]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s10, -1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s8, s2
; GFX8_DPP-NEXT:    s_mov_b32 s9, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX8_DPP-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX8_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX8_DPP-NEXT:    buffer_wbinvl1_vol
; GFX8_DPP-NEXT:  .LBB2_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_add_u32_e32 v0, vcc, s4, v0
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[4:5]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s10, -1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s8, s2
; GFX9_DPP-NEXT:    s_mov_b32 s9, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX9_DPP-NEXT:    buffer_atomic_add v0, off, s[8:11], 0 glc
; GFX9_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9_DPP-NEXT:    buffer_wbinvl1_vol
; GFX9_DPP-NEXT:  .LBB2_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_add_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1064_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1064_DPP-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 glc
; GFX1064_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl1_inv
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB2_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1032_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1032_DPP-NEXT:    buffer_atomic_add v0, off, s[4:7], 0 glc
; GFX1032_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl1_inv
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB2_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1164_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1164_DPP-NEXT:    buffer_atomic_add_u32 v0, off, s[4:7], 0 glc
; GFX1164_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl1_inv
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB2_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1132_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1132_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1132_DPP-NEXT:    buffer_atomic_add_u32 v0, off, s[4:7], 0 glc
; GFX1132_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl1_inv
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB2_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
;
; GFX1264_DPP-LABEL: add_i32_varying:
; GFX1264_DPP:       ; %bb.0: ; %entry
; GFX1264_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1264_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1264_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1264_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1264_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1264_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1264_DPP-NEXT:  ; %bb.1:
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1264_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1264_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1264_DPP-NEXT:    buffer_atomic_add_u32 v0, off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1264_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_DPP-NEXT:  .LBB2_2:
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1264_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1264_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1264_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264_DPP-NEXT:    s_endpgm
;
; GFX1232_DPP-LABEL: add_i32_varying:
; GFX1232_DPP:       ; %bb.0: ; %entry
; GFX1232_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1232_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1232_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1232_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1232_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1232_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1232_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1232_DPP-NEXT:    s_cbranch_execz .LBB2_2
; GFX1232_DPP-NEXT:  ; %bb.1:
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1232_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1232_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1232_DPP-NEXT:    buffer_atomic_add_u32 v0, off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1232_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_DPP-NEXT:  .LBB2_2:
; GFX1232_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1232_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX1232_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1232_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw add ptr addrspace(1) %inout, i32 %lane  syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: add_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB3_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB3_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s5, v0
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB3_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB3_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    v_readfirstlane_b32 s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    s_nop 2
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB3_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB3_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_readfirstlane_b32 s3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, v[0:1]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB3_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB3_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], v2, 5, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB3_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB3_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, v2, 5, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB3_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB3_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB3_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB3_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i64_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB3_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    v_mov_b32_e32 v1, 0
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB3_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i64_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB3_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB3_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, v2, 5, s[2:3]
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i64 5  syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i64 %additive) {
; GFX7LESS-LABEL: add_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB4_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s2
; GFX7LESS-NEXT:    s_mov_b32 s13, s3
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s3, s5, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s4, v0
; GFX7LESS-NEXT:    s_mul_i32 s2, s4, s2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s3, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB4_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s6, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s7, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s5, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s4, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s4, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s6
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s7, v2
; GFX7LESS-NEXT:    v_addc_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: add_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB4_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[8:9], s4, v0, 0
; GFX8-NEXT:    s_mul_i32 s2, s5, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s3
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; GFX8-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB4_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_readfirstlane_b32 s2, v1
; GFX8-NEXT:    v_readfirstlane_b32 s3, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mul_lo_u32 v3, s5, v2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s4, v2, v[0:1]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v1
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: add_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    s_mul_i32 s3, s7, s2
; GFX9-NEXT:    s_mul_hi_u32 s8, s6, s2
; GFX9-NEXT:    s_add_i32 s8, s8, s3
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB4_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_readfirstlane_b32 s2, v1
; GFX9-NEXT:    v_readfirstlane_b32 s3, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s6, v2, v[0:1]
; GFX9-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s7, v2, v[1:2]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    s_nop 2
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: add_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB4_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s7, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s6, s8
; GFX1064-NEXT:    s_mul_i32 s8, s6, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v0, s8
; GFX1064-NEXT:    v_mov_b32_e32 v1, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB4_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mad_u64_u32 v[0:1], s[2:3], s6, v2, s[2:3]
; GFX1064-NEXT:    v_mad_u64_u32 v[1:2], s[2:3], s7, v2, v[1:2]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: add_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB4_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s7, s5
; GFX1032-NEXT:    s_mul_hi_u32 s9, s6, s5
; GFX1032-NEXT:    s_mul_i32 s5, s6, s5
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB4_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mad_u64_u32 v[0:1], s2, s6, v2, s[2:3]
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_mad_u64_u32 v[1:2], s2, s7, v2, v[1:2]
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: add_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB4_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s9, s5, s8
; GFX1164-NEXT:    s_mul_hi_u32 s10, s4, s8
; GFX1164-NEXT:    s_mul_i32 s8, s4, s8
; GFX1164-NEXT:    s_add_i32 s10, s10, s9
; GFX1164-NEXT:    v_mov_b32_e32 v0, s8
; GFX1164-NEXT:    v_mov_b32_e32 v1, s10
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB4_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mad_u64_u32 v[0:1], null, s4, v2, s[2:3]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s5, v2, v[1:2]
; GFX1164-NEXT:    v_mov_b32_e32 v1, v3
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: add_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s7, exec_lo
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB4_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s7, s7
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s8, s5, s7
; GFX1132-NEXT:    s_mul_hi_u32 s9, s4, s7
; GFX1132-NEXT:    s_mul_i32 s7, s4, s7
; GFX1132-NEXT:    s_add_i32 s9, s9, s8
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s7 :: v_dual_mov_b32 v1, s9
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB4_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_mad_u64_u32 v[0:1], null, s4, v2, s[2:3]
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s5, v2, v[1:2]
; GFX1132-NEXT:    v_mov_b32_e32 v1, v3
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: add_i64_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-NEXT:    s_mov_b32 s11, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB4_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s10, s[8:9]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_u64 s[8:9], s[4:5], s[10:11]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v0, s8
; GFX1264-NEXT:    v_mov_b32_e32 v1, s9
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB4_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[0:1], null, s4, v2, s[2:3]
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    v_mad_co_u64_u32 v[1:2], null, s5, v2, v[1:2]
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: add_i64_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s7, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1232-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB4_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_mul_u64 s[6:7], s[4:5], s[6:7]
; GFX1232-NEXT:    s_mov_b32 s14, -1
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX1232-NEXT:    s_mov_b32 s12, s2
; GFX1232-NEXT:    s_mov_b32 s13, s3
; GFX1232-NEXT:    buffer_atomic_add_u64 v[0:1], off, s[12:15], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB4_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[0:1], null, s4, v2, s[2:3]
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    v_mad_co_u64_u32 v[1:2], null, s5, v2, v[1:2]
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw add ptr addrspace(1) %inout, i64 %additive  syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @add_i64_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS_ITERATIVE-LABEL: add_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX7LESS_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX7LESS_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB5_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX7LESS_ITERATIVE-NEXT:    buffer_atomic_add_x2 v[3:4], off, s[8:11], 0 glc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_wbinvl1
; GFX7LESS_ITERATIVE-NEXT:  .LBB5_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS_ITERATIVE-NEXT:    v_add_i32_e32 v0, vcc, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    v_addc_u32_e32 v1, vcc, v3, v2, vcc
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: add_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX8_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX8_ITERATIVE-NEXT:    buffer_atomic_add_x2 v[3:4], off, s[8:11], 0 glc
; GFX8_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX8_ITERATIVE-NEXT:  .LBB5_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX8_ITERATIVE-NEXT:    v_add_u32_e32 v0, vcc, s5, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_addc_u32_e32 v1, vcc, v3, v2, vcc
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: add_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX9_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX9_ITERATIVE-NEXT:    buffer_atomic_add_x2 v[3:4], off, s[8:11], 0 glc
; GFX9_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX9_ITERATIVE-NEXT:  .LBB5_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX9_ITERATIVE-NEXT:    v_add_co_u32_e32 v0, vcc, s5, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_addc_co_u32_e32 v1, vcc, v3, v2, vcc
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: add_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s2
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s2
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, s2
; GFX1064_ITERATIVE-NEXT:    s_add_u32 s6, s6, s3
; GFX1064_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s8
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1064_ITERATIVE-NEXT:    buffer_atomic_add_x2 v[3:4], off, s[8:11], 0 glc
; GFX1064_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB5_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc, s2, v1
; GFX1064_ITERATIVE-NEXT:    v_add_co_ci_u32_e32 v1, vcc, s3, v2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: add_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, s1
; GFX1032_ITERATIVE-NEXT:    s_add_u32 s6, s6, s2
; GFX1032_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1032_ITERATIVE-NEXT:    buffer_atomic_add_x2 v[3:4], off, s[8:11], 0 glc
; GFX1032_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB5_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc_lo, s2, v1
; GFX1032_ITERATIVE-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, s3, v2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: add_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s3, v2, s2
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s2
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s2
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s2
; GFX1164_ITERATIVE-NEXT:    s_add_u32 s6, s6, s3
; GFX1164_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s8
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s6
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s7
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1164_ITERATIVE-NEXT:    buffer_atomic_add_u64 v[2:3], off, s[8:11], 0 glc
; GFX1164_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB5_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc, s2, v0
; GFX1164_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: add_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s1
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s1
; GFX1132_ITERATIVE-NEXT:    s_add_u32 s6, s6, s2
; GFX1132_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1132_ITERATIVE-NEXT:    buffer_atomic_add_u64 v[2:3], off, s[8:11], 0 glc
; GFX1132_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB5_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc_lo, s2, v0
; GFX1132_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX1264_ITERATIVE-LABEL: add_i64_varying:
; GFX1264_ITERATIVE:       ; %bb.0: ; %entry
; GFX1264_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1264_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[0:1]
; GFX1264_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s10
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s10
; GFX1264_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s10
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s10
; GFX1264_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[8:9]
; GFX1264_ITERATIVE-NEXT:    s_add_nc_u64 s[6:7], s[6:7], s[2:3]
; GFX1264_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1264_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1264_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1264_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1264_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1264_ITERATIVE-NEXT:  ; %bb.3:
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s6
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s7
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1264_ITERATIVE-NEXT:    buffer_atomic_add_u64 v[2:3], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1264_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:  .LBB5_4:
; GFX1264_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc, s2, v0
; GFX1264_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1264_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264_ITERATIVE-NEXT:    s_endpgm
;
; GFX1232_ITERATIVE-LABEL: add_i64_varying:
; GFX1232_ITERATIVE:       ; %bb.0: ; %entry
; GFX1232_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232_ITERATIVE-NEXT:  .LBB5_1: ; %ComputeLoop
; GFX1232_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s1
; GFX1232_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1232_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s8
; GFX1232_ITERATIVE-NEXT:    s_add_nc_u64 s[6:7], s[6:7], s[2:3]
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1232_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB5_1
; GFX1232_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1232_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_cbranch_execz .LBB5_4
; GFX1232_ITERATIVE-NEXT:  ; %bb.3:
; GFX1232_ITERATIVE-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1232_ITERATIVE-NEXT:    buffer_atomic_add_u64 v[2:3], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1232_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:  .LBB5_4:
; GFX1232_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_ITERATIVE-NEXT:    v_add_co_u32 v0, vcc_lo, s2, v0
; GFX1232_ITERATIVE-NEXT:    v_add_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1232_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: add_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s6, -1
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s10, s6
; GFX7LESS_DPP-NEXT:    s_mov_b32 s11, s7
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_DPP-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_DPP-NEXT:    buffer_atomic_add_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_DPP-NEXT:    buffer_wbinvl1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s4, s0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s5, s1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: add_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[4:5]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[4:5]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_addc_u32_e32 v4, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    v_readlane_b32 s7, v4, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s6, v3, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s6
; GFX8_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s10, -1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s8, s2
; GFX8_DPP-NEXT:    s_mov_b32 s9, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s7
; GFX8_DPP-NEXT:    buffer_atomic_add_x2 v[6:7], off, s[8:11], 0 glc
; GFX8_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX8_DPP-NEXT:    buffer_wbinvl1_vol
; GFX8_DPP-NEXT:  .LBB5_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    v_add_u32_e32 v6, vcc, s5, v6
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_addc_u32_e32 v7, vcc, v0, v7, vcc
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: add_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[4:5]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[4:5]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v4, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    v_readlane_b32 s7, v4, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s6, v3, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s6
; GFX9_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s10, -1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s8, s2
; GFX9_DPP-NEXT:    s_mov_b32 s9, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s7
; GFX9_DPP-NEXT:    buffer_atomic_add_x2 v[6:7], off, s[8:11], 0 glc
; GFX9_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9_DPP-NEXT:    buffer_wbinvl1_vol
; GFX9_DPP-NEXT:  .LBB5_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v6, vcc, s5, v6
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v7, vcc, v0, v7, vcc
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: add_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v2, v1
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v3, v4, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v4
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v3, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v7, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s10, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s6, 16
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s11, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s8, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s9, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s11, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s10, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, s5
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s4
; GFX1064_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1064_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1064_DPP-NEXT:    buffer_atomic_add_x2 v[8:9], off, s[4:7], 0 glc
; GFX1064_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl1_inv
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB5_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1064_DPP-NEXT:    v_add_co_u32 v8, vcc, s2, v10
; GFX1064_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v9, vcc, s3, v11, vcc
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: add_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v2, v1
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v4, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v4
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v3, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v3
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s8, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s5, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v8, s8, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v7, s7, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v10, s5
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, s4
; GFX1032_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1032_DPP-NEXT:    buffer_atomic_add_x2 v[9:10], off, s[4:7], 0 glc
; GFX1032_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl1_inv
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB5_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s2, v9
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v10
; GFX1032_DPP-NEXT:    v_add_co_u32 v9, vcc_lo, s2, v11
; GFX1032_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v10, vcc_lo, s3, v12, vcc_lo
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: add_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s7, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s10, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s11, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s8, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s9, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s10, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s11, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1164_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX1164_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s4
; GFX1164_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1164_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1164_DPP-NEXT:    buffer_atomic_add_u64 v[6:7], off, s[4:7], 0 glc
; GFX1164_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl1_inv
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB5_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s2, v6
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32 v6, vcc, s2, v8
; GFX1164_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v7, null, s3, v9, vcc
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    buffer_store_b64 v[6:7], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: add_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s0
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1132_DPP-NEXT:    v_readlane_b32 s4, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s7, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s8, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v7, s8, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1132_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1132_DPP-NEXT:    s_mov_b32 s8, exec_lo
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1132_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v9, s5 :: v_dual_mov_b32 v8, s4
; GFX1132_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1132_DPP-NEXT:    buffer_atomic_add_u64 v[8:9], off, s[4:7], 0 glc
; GFX1132_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl1_inv
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB5_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32 v8, vcc_lo, s2, v10
; GFX1132_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v9, null, s3, v11, vcc_lo
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
;
; GFX1264_DPP-LABEL: add_i64_varying:
; GFX1264_DPP:       ; %bb.0: ; %entry
; GFX1264_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1264_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1264_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1264_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s7, 16
; GFX1264_DPP-NEXT:    v_readlane_b32 s10, v2, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s11, v1, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s8, 32
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s9, 32
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1264_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s10, 48
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s11, 48
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1264_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1264_DPP-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX1264_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1264_DPP-NEXT:  ; %bb.1:
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v7, s5
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v6, s4
; GFX1264_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1264_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1264_DPP-NEXT:    buffer_atomic_add_u64 v[6:7], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1264_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_DPP-NEXT:  .LBB5_2:
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s2, v6
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_add_co_u32 v6, vcc, s2, v8
; GFX1264_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v7, null, s3, v9, vcc
; GFX1264_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_DPP-NEXT:    buffer_store_b64 v[6:7], off, s[0:3], null
; GFX1264_DPP-NEXT:    s_endpgm
;
; GFX1232_DPP-LABEL: add_i64_varying:
; GFX1232_DPP:       ; %bb.0: ; %entry
; GFX1232_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s0
; GFX1232_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1232_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1232_DPP-NEXT:    v_readlane_b32 s4, v2, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_readlane_b32 s7, v2, 15
; GFX1232_DPP-NEXT:    v_readlane_b32 s8, v1, 15
; GFX1232_DPP-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1232_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1232_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1232_DPP-NEXT:    v_writelane_b32 v7, s8, 16
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1232_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1232_DPP-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1232_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232_DPP-NEXT:    s_cbranch_execz .LBB5_2
; GFX1232_DPP-NEXT:  ; %bb.1:
; GFX1232_DPP-NEXT:    v_dual_mov_b32 v9, s5 :: v_dual_mov_b32 v8, s4
; GFX1232_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1232_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1232_DPP-NEXT:    buffer_atomic_add_u64 v[8:9], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1232_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_DPP-NEXT:  .LBB5_2:
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1232_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_add_co_u32 v8, vcc_lo, s2, v10
; GFX1232_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v9, null, s3, v11, vcc_lo
; GFX1232_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], null
; GFX1232_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw add ptr addrspace(1) %inout, i64 %zext syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i32_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB6_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB6_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB6_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB6_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB6_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB6_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB6_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB6_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB6_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB6_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB6_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB6_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB6_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i32_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB6_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB6_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i32_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB6_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_mov_b32_e32 v1, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB6_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    v_mul_u32_u24_e32 v0, 5, v0
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 5 syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i32 %subitive) {
; GFX7LESS-LABEL: sub_i32_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s8, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB7_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mul_i32 s6, s8, s6
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_mov_b32 s12, s2
; GFX7LESS-NEXT:    s_mov_b32 s13, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB7_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s4, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i32_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB7_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s8, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB7_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i32_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB7_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s8, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB7_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i32_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    ; implicit-def: $vgpr1
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB7_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s6, s8, s6
; GFX1064-NEXT:    s_mov_b32 s14, -1
; GFX1064-NEXT:    v_mov_b32_e32 v1, s6
; GFX1064-NEXT:    s_mov_b32 s12, s2
; GFX1064-NEXT:    s_mov_b32 s13, s3
; GFX1064-NEXT:    buffer_atomic_sub v1, off, s[12:15], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB7_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i32_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s7, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, s7, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB7_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s7
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s5, s6, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    v_mov_b32_e32 v1, s5
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub v1, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB7_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mul_lo_u32 v0, s6, v0
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i32_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    ; implicit-def: $vgpr1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164-NEXT:    s_cbranch_execz .LBB7_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s6, s8, s6
; GFX1164-NEXT:    s_mov_b32 s14, -1
; GFX1164-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164-NEXT:    s_mov_b32 s12, s2
; GFX1164-NEXT:    s_mov_b32 s13, s3
; GFX1164-NEXT:    buffer_atomic_sub_u32 v1, off, s[12:15], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB7_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i32_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s5, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132-NEXT:    s_cbranch_execz .LBB7_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s6, s4, s6
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB7_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mul_lo_u32 v0, s4, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i32_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    ; implicit-def: $vgpr1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v0, s7, v0
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264-NEXT:    s_cbranch_execz .LBB7_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s8, s6
; GFX1264-NEXT:    s_mov_b32 s14, -1
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264-NEXT:    s_mov_b32 s12, s2
; GFX1264-NEXT:    s_mov_b32 s13, s3
; GFX1264-NEXT:    buffer_atomic_sub_u32 v1, off, s[12:15], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB7_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mul_lo_u32 v0, s8, v0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i32_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s5, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232-NEXT:    s_cbranch_execz .LBB7_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_mul_i32 s6, s4, s6
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB7_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mul_lo_u32 v0, s4, v0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 %subitive syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i32_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS_ITERATIVE-LABEL: sub_i32_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX7LESS_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB8_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS_ITERATIVE-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_wbinvl1
; GFX7LESS_ITERATIVE-NEXT:  .LBB8_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    v_sub_i32_e32 v0, vcc, s4, v1
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: sub_i32_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX8_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX8_ITERATIVE-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX8_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX8_ITERATIVE-NEXT:  .LBB8_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_sub_u32_e32 v0, vcc, s4, v1
; GFX8_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: sub_i32_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX9_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s7, v0, s2
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9_ITERATIVE-NEXT:    s_add_i32 s6, s6, s7
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX9_ITERATIVE-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX9_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX9_ITERATIVE-NEXT:  .LBB8_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_sub_u32_e32 v0, s4, v1
; GFX9_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: sub_i32_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1064_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s7, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s7
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s7
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_add_i32 s6, s6, s8
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1064_ITERATIVE-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX1064_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB8_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: sub_i32_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1032_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s1
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s0, s0, s3
; GFX1032_ITERATIVE-NEXT:    s_add_i32 s6, s6, s2
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v0, s6
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1032_ITERATIVE-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX1032_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB8_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v1
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: sub_i32_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1164_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s7, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s7
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s7
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_add_i32 s6, s6, s8
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1164_ITERATIVE-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1164_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB8_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: sub_i32_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1132_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s2, v1, s1
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s3
; GFX1132_ITERATIVE-NEXT:    s_add_i32 s6, s6, s2
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1132_ITERATIVE-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], 0 glc
; GFX1132_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB8_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX1264_ITERATIVE-LABEL: sub_i32_varying:
; GFX1264_ITERATIVE:       ; %bb.0: ; %entry
; GFX1264_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1264_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1264_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264_ITERATIVE-NEXT:    s_ctz_i32_b64 s7, s[0:1]
; GFX1264_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s8, v1, s7
; GFX1264_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s7
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s7
; GFX1264_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1264_ITERATIVE-NEXT:    s_add_co_i32 s6, s6, s8
; GFX1264_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1264_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1264_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v1, exec_hi, v1
; GFX1264_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v1
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1264_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1264_ITERATIVE-NEXT:  ; %bb.3:
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1264_ITERATIVE-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1264_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:  .LBB8_4:
; GFX1264_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1264_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264_ITERATIVE-NEXT:    s_endpgm
;
; GFX1232_ITERATIVE-LABEL: sub_i32_varying:
; GFX1232_ITERATIVE:       ; %bb.0: ; %entry
; GFX1232_ITERATIVE-NEXT:    v_and_b32_e32 v1, 0x3ff, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s6, 0
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr0
; GFX1232_ITERATIVE-NEXT:  .LBB8_1: ; %ComputeLoop
; GFX1232_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s2, v1, s1
; GFX1232_ITERATIVE-NEXT:    s_lshl_b32 s3, 1, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1232_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s3
; GFX1232_ITERATIVE-NEXT:    s_add_co_i32 s6, s6, s2
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1232_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB8_1
; GFX1232_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v1, exec_lo, 0
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr1
; GFX1232_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_cbranch_execz .LBB8_4
; GFX1232_ITERATIVE-NEXT:  ; %bb.3:
; GFX1232_ITERATIVE-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1232_ITERATIVE-NEXT:    buffer_atomic_sub_u32 v1, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1232_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:  .LBB8_4:
; GFX1232_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v1
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_ITERATIVE-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1232_ITERATIVE-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: sub_i32_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s6, -1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s10, s6
; GFX7LESS_DPP-NEXT:    s_mov_b32 s11, s7
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_DPP-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_DPP-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX7LESS_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_DPP-NEXT:    buffer_wbinvl1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s4, s0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s5, s1
; GFX7LESS_DPP-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: sub_i32_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[4:5]
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    s_nop 1
; GFX8_DPP-NEXT:    v_add_u32_dpp v2, vcc, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX8_DPP-NEXT:    s_nop 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s10, -1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s8, s2
; GFX8_DPP-NEXT:    s_mov_b32 s9, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX8_DPP-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX8_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX8_DPP-NEXT:    buffer_wbinvl1_vol
; GFX8_DPP-NEXT:  .LBB8_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_sub_u32_e32 v0, vcc, s4, v0
; GFX8_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: sub_i32_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v3, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v3, exec_hi, v3
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[4:5]
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    s_nop 1
; GFX9_DPP-NEXT:    v_add_u32_dpp v2, v2, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX9_DPP-NEXT:    s_nop 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v2 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v3
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s10, -1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s8, s2
; GFX9_DPP-NEXT:    s_mov_b32 s9, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s6
; GFX9_DPP-NEXT:    buffer_atomic_sub v0, off, s[8:11], 0 glc
; GFX9_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9_DPP-NEXT:    buffer_wbinvl1_vol
; GFX9_DPP-NEXT:  .LBB8_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, v1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_sub_u32_e32 v0, s4, v0
; GFX9_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: sub_i32_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1064_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1064_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1064_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1064_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1064_DPP-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 glc
; GFX1064_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl1_inv
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB8_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1064_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: sub_i32_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1032_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1032_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1032_DPP-NEXT:    buffer_atomic_sub v0, off, s[4:7], 0 glc
; GFX1032_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl1_inv
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB8_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1032_DPP-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: sub_i32_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1164_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1164_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1164_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1164_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1164_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1164_DPP-NEXT:    buffer_atomic_sub_u32 v0, off, s[4:7], 0 glc
; GFX1164_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl1_inv
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB8_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1164_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1164_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: sub_i32_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1132_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1132_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1132_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1132_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1132_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1132_DPP-NEXT:    buffer_atomic_sub_u32 v0, off, s[4:7], 0 glc
; GFX1132_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl1_inv
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB8_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1132_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1132_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
;
; GFX1264_DPP-LABEL: sub_i32_varying:
; GFX1264_DPP:       ; %bb.0: ; %entry
; GFX1264_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, s2
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v1, 15
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1264_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 31
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s6, 16
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_readlane_b32 s8, v1, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s9, v1, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s7, 32
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s9
; GFX1264_DPP-NEXT:    v_writelane_b32 v3, s8, 48
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[6:7]
; GFX1264_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1264_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1264_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1264_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1264_DPP-NEXT:  ; %bb.1:
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1264_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1264_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1264_DPP-NEXT:    buffer_atomic_sub_u32 v0, off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1264_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_DPP-NEXT:  .LBB8_2:
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1264_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1264_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1264_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1264_DPP-NEXT:    s_endpgm
;
; GFX1232_DPP-LABEL: sub_i32_varying:
; GFX1232_DPP:       ; %bb.0: ; %entry
; GFX1232_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, v0, s0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v1, v1 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v2, v1, -1, -1
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1232_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1232_DPP-NEXT:    v_add_nc_u32_dpp v1, v2, v1 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_readlane_b32 s6, v1, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v3, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_readlane_b32 s5, v1, 15
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s4, -1
; GFX1232_DPP-NEXT:    v_writelane_b32 v3, s5, 16
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s4
; GFX1232_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s6
; GFX1232_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1232_DPP-NEXT:    ; implicit-def: $vgpr0
; GFX1232_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1232_DPP-NEXT:    s_cbranch_execz .LBB8_2
; GFX1232_DPP-NEXT:  ; %bb.1:
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX1232_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1232_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1232_DPP-NEXT:    buffer_atomic_sub_u32 v0, off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1232_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_DPP-NEXT:  .LBB8_2:
; GFX1232_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v0, v3
; GFX1232_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_sub_nc_u32_e32 v0, s2, v0
; GFX1232_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1232_DPP-NEXT:    buffer_store_b32 v0, off, s[0:3], null
; GFX1232_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %old = atomicrmw sub ptr addrspace(1) %inout, i32 %lane syncscope("agent") acq_rel
  store i32 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_constant(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS-LABEL: sub_i64_constant:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB9_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_mul_i32 s6, s6, 5
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s8, s2
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s6
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB9_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s5, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX7LESS-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s5, v0
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_constant:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB9_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX8-NEXT:    s_mul_i32 s2, s2, 5
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, 0
; GFX8-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB9_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_readfirstlane_b32 s5, v0
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX8-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s5, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v2, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_constant:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB9_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s8, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[6:7]
; GFX9-NEXT:    s_mul_i32 s2, s2, 5
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB9_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-NEXT:    v_readfirstlane_b32 s5, v0
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX9-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, s5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_constant:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB9_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064-NEXT:    s_mul_i32 s6, s6, 5
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    v_mov_b32_e32 v0, s6
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB9_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v1, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_constant:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB9_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1032-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032-NEXT:    s_mul_i32 s5, s5, 5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB9_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v1, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_constant:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    s_mov_b64 s[4:5], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB9_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-NEXT:    v_mov_b32_e32 v1, 0
; GFX1164-NEXT:    s_mul_i32 s6, s6, 5
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    v_mov_b32_e32 v0, s6
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB9_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_constant:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    s_mov_b32 s4, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB9_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_mul_i32 s5, s5, 5
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB9_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i64_constant:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_mov_b64 s[4:5], exec
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s7, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB9_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-NEXT:    v_mov_b32_e32 v1, 0
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_mul_i32 s6, s6, 5
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v0, s6
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB9_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1264-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i64_constant:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s4, exec_lo
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB9_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s5, s6
; GFX1232-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-NEXT:    s_mul_i32 s5, s5, 5
; GFX1232-NEXT:    s_mov_b32 s10, -1
; GFX1232-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, 0
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_mov_b32 s8, s2
; GFX1232-NEXT:    s_mov_b32 s9, s3
; GFX1232-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB9_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    v_mul_u32_u24_e32 v0, 5, v2
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    v_mul_hi_u32_u24_e32 v1, 5, v2
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1232-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 5 syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_uniform(ptr addrspace(1) %out, ptr addrspace(1) %inout, i64 %subitive) {
; GFX7LESS-LABEL: sub_i64_uniform:
; GFX7LESS:       ; %bb.0: ; %entry
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s8, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v2, s9, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB10_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_mov_b32 s15, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s14, -1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s12, s2
; GFX7LESS-NEXT:    s_mov_b32 s13, s3
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX7LESS-NEXT:    s_mul_i32 s3, s5, s2
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    v_mul_hi_u32 v0, s4, v0
; GFX7LESS-NEXT:    s_mul_i32 s2, s4, s2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, s3, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s2
; GFX7LESS-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    buffer_wbinvl1
; GFX7LESS-NEXT:  .LBB10_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s6, v1
; GFX7LESS-NEXT:    v_readfirstlane_b32 s7, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mul_lo_u32 v0, s5, v2
; GFX7LESS-NEXT:    v_mul_hi_u32 v1, s4, v2
; GFX7LESS-NEXT:    v_mul_lo_u32 v2, s4, v2
; GFX7LESS-NEXT:    v_add_i32_e32 v1, vcc, v1, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s6
; GFX7LESS-NEXT:    v_sub_i32_e32 v0, vcc, s7, v2
; GFX7LESS-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX7LESS-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: sub_i64_uniform:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX8-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX8-NEXT:    s_and_saveexec_b64 s[6:7], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB10_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s12, s2
; GFX8-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mad_u64_u32 v[0:1], s[8:9], s4, v0, 0
; GFX8-NEXT:    s_mul_i32 s2, s5, s2
; GFX8-NEXT:    s_mov_b32 s15, 0xf000
; GFX8-NEXT:    s_mov_b32 s14, -1
; GFX8-NEXT:    s_mov_b32 s13, s3
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s2, v1
; GFX8-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1_vol
; GFX8-NEXT:  .LBB10_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mul_lo_u32 v4, s5, v2
; GFX8-NEXT:    v_mad_u64_u32 v[2:3], s[4:5], s4, v2, 0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-NEXT:    v_readfirstlane_b32 s5, v0
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:    v_sub_u32_e32 v0, vcc, s5, v2
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_subb_u32_e32 v1, vcc, v3, v1, vcc
; GFX8-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: sub_i64_uniform:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s12, s2
; GFX9-NEXT:    s_bcnt1_i32_b64 s2, s[8:9]
; GFX9-NEXT:    s_mov_b32 s13, s3
; GFX9-NEXT:    s_mul_i32 s3, s7, s2
; GFX9-NEXT:    s_mul_hi_u32 s8, s6, s2
; GFX9-NEXT:    s_add_i32 s8, s8, s3
; GFX9-NEXT:    s_mul_i32 s2, s6, s2
; GFX9-NEXT:    s_mov_b32 s15, 0xf000
; GFX9-NEXT:    s_mov_b32 s14, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s8
; GFX9-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[12:15], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    buffer_wbinvl1_vol
; GFX9-NEXT:  .LBB10_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u64_u32 v[3:4], s[4:5], s6, v2, 0
; GFX9-NEXT:    v_readfirstlane_b32 s8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s6, v1
; GFX9-NEXT:    v_mov_b32_e32 v0, v4
; GFX9-NEXT:    v_mad_u64_u32 v[0:1], s[4:5], s7, v2, v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_sub_co_u32_e32 v1, vcc, s8, v3
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v0, vcc
; GFX9-NEXT:    buffer_store_dwordx2 v[1:2], off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: sub_i64_uniform:
; GFX1064:       ; %bb.0: ; %entry
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB10_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mul_i32 s9, s7, s8
; GFX1064-NEXT:    s_mul_hi_u32 s10, s6, s8
; GFX1064-NEXT:    s_mul_i32 s8, s6, s8
; GFX1064-NEXT:    s_add_i32 s10, s10, s9
; GFX1064-NEXT:    v_mov_b32_e32 v0, s8
; GFX1064-NEXT:    v_mov_b32_e32 v1, s10
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s8, s2
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    buffer_gl1_inv
; GFX1064-NEXT:    buffer_gl0_inv
; GFX1064-NEXT:  .LBB10_2:
; GFX1064-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mad_u64_u32 v[3:4], s[2:3], s6, v2, 0
; GFX1064-NEXT:    v_mad_u64_u32 v[4:5], s[2:3], s7, v2, v[4:5]
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1064-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1064-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v4, vcc
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: sub_i64_uniform:
; GFX1032:       ; %bb.0: ; %entry
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s8, exec_lo
; GFX1032-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v2, s8, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB10_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_bcnt1_i32_b32 s5, s8
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mul_i32 s8, s7, s5
; GFX1032-NEXT:    s_mul_hi_u32 s9, s6, s5
; GFX1032-NEXT:    s_mul_i32 s5, s6, s5
; GFX1032-NEXT:    s_add_i32 s9, s9, s8
; GFX1032-NEXT:    v_mov_b32_e32 v0, s5
; GFX1032-NEXT:    v_mov_b32_e32 v1, s9
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s8, s2
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    buffer_gl1_inv
; GFX1032-NEXT:    buffer_gl0_inv
; GFX1032-NEXT:  .LBB10_2:
; GFX1032-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mad_u64_u32 v[3:4], s2, s6, v2, 0
; GFX1032-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1032-NEXT:    v_mad_u64_u32 v[4:5], s2, s7, v2, v[4:5]
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1032-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v4, vcc_lo
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: sub_i64_uniform:
; GFX1164:       ; %bb.0: ; %entry
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1164-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1164-NEXT:    s_cbranch_execz .LBB10_2
; GFX1164-NEXT:  ; %bb.1:
; GFX1164-NEXT:    s_bcnt1_i32_b64 s8, s[8:9]
; GFX1164-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_mul_i32 s9, s5, s8
; GFX1164-NEXT:    s_mul_hi_u32 s10, s4, s8
; GFX1164-NEXT:    s_mul_i32 s8, s4, s8
; GFX1164-NEXT:    s_add_i32 s10, s10, s9
; GFX1164-NEXT:    v_mov_b32_e32 v0, s8
; GFX1164-NEXT:    v_mov_b32_e32 v1, s10
; GFX1164-NEXT:    s_mov_b32 s10, -1
; GFX1164-NEXT:    s_mov_b32 s8, s2
; GFX1164-NEXT:    s_mov_b32 s9, s3
; GFX1164-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    buffer_gl1_inv
; GFX1164-NEXT:    buffer_gl0_inv
; GFX1164-NEXT:  .LBB10_2:
; GFX1164-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mad_u64_u32 v[3:4], null, s4, v2, 0
; GFX1164-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1164-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-NEXT:    v_mad_u64_u32 v[5:6], null, s5, v2, v[4:5]
; GFX1164-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v5, vcc
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: sub_i64_uniform:
; GFX1132:       ; %bb.0: ; %entry
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s7, exec_lo
; GFX1132-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-NEXT:    v_mbcnt_lo_u32_b32 v2, s7, 0
; GFX1132-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1132-NEXT:    s_cbranch_execz .LBB10_2
; GFX1132-NEXT:  ; %bb.1:
; GFX1132-NEXT:    s_bcnt1_i32_b32 s7, s7
; GFX1132-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_mul_i32 s8, s5, s7
; GFX1132-NEXT:    s_mul_hi_u32 s9, s4, s7
; GFX1132-NEXT:    s_mul_i32 s7, s4, s7
; GFX1132-NEXT:    s_add_i32 s9, s9, s8
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    v_dual_mov_b32 v0, s7 :: v_dual_mov_b32 v1, s9
; GFX1132-NEXT:    s_mov_b32 s10, -1
; GFX1132-NEXT:    s_mov_b32 s8, s2
; GFX1132-NEXT:    s_mov_b32 s9, s3
; GFX1132-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    buffer_gl1_inv
; GFX1132-NEXT:    buffer_gl0_inv
; GFX1132-NEXT:  .LBB10_2:
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s6
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mad_u64_u32 v[3:4], null, s4, v2, 0
; GFX1132-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132-NEXT:    v_mad_u64_u32 v[5:6], null, s5, v2, v[4:5]
; GFX1132-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v5, vcc_lo
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: sub_i64_uniform:
; GFX1264:       ; %bb.0: ; %entry
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-NEXT:    s_mov_b32 s11, 0
; GFX1264-NEXT:    v_mbcnt_lo_u32_b32 v0, s8, 0
; GFX1264-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-NEXT:    v_mbcnt_hi_u32_b32 v2, s9, v0
; GFX1264-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1264-NEXT:    s_cbranch_execz .LBB10_2
; GFX1264-NEXT:  ; %bb.1:
; GFX1264-NEXT:    s_bcnt1_i32_b64 s10, s[8:9]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_mul_u64 s[8:9], s[4:5], s[10:11]
; GFX1264-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    v_mov_b32_e32 v0, s8
; GFX1264-NEXT:    v_mov_b32_e32 v1, s9
; GFX1264-NEXT:    s_mov_b32 s10, -1
; GFX1264-NEXT:    s_mov_b32 s8, s2
; GFX1264-NEXT:    s_mov_b32 s9, s3
; GFX1264-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264-NEXT:  .LBB10_2:
; GFX1264-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mad_co_u64_u32 v[3:4], null, s4, v2, 0
; GFX1264-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1264-NEXT:    v_mad_co_u64_u32 v[4:5], null, s5, v2, v[4:5]
; GFX1264-NEXT:    v_sub_co_u32 v0, vcc, s2, v3
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v4, vcc
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: sub_i64_uniform:
; GFX1232:       ; %bb.0: ; %entry
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-NEXT:    s_mov_b32 s7, 0
; GFX1232-NEXT:    v_mbcnt_lo_u32_b32 v2, s6, 0
; GFX1232-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-NEXT:    v_cmpx_eq_u32_e32 0, v2
; GFX1232-NEXT:    s_cbranch_execz .LBB10_2
; GFX1232-NEXT:  ; %bb.1:
; GFX1232-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-NEXT:    s_mov_b32 s15, 0x31016000
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_mul_u64 s[6:7], s[4:5], s[6:7]
; GFX1232-NEXT:    s_mov_b32 s14, -1
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    v_dual_mov_b32 v0, s6 :: v_dual_mov_b32 v1, s7
; GFX1232-NEXT:    s_mov_b32 s12, s2
; GFX1232-NEXT:    s_mov_b32 s13, s3
; GFX1232-NEXT:    buffer_atomic_sub_u64 v[0:1], off, s[12:15], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232-NEXT:  .LBB10_2:
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mad_co_u64_u32 v[3:4], null, s4, v2, 0
; GFX1232-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-NEXT:    v_readfirstlane_b32 s3, v1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1232-NEXT:    v_mad_co_u64_u32 v[4:5], null, s5, v2, v[4:5]
; GFX1232-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v3
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v4, vcc_lo
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
entry:
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 %subitive syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @sub_i64_varying(ptr addrspace(1) %out, ptr addrspace(1) %inout) {
; GFX7LESS_ITERATIVE-LABEL: sub_i64_varying:
; GFX7LESS_ITERATIVE:       ; %bb.0: ; %entry
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX7LESS_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX7LESS_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX7LESS_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX7LESS_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX7LESS_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX7LESS_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX7LESS_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX7LESS_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[0:1], 0
; GFX7LESS_ITERATIVE-NEXT:    s_and_b64 vcc, exec, s[2:3]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_vccnz .LBB11_1
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX7LESS_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX7LESS_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX7LESS_ITERATIVE-NEXT:  ; %bb.3:
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX7LESS_ITERATIVE-NEXT:    buffer_atomic_sub_x2 v[3:4], off, s[8:11], 0 glc
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    buffer_wbinvl1
; GFX7LESS_ITERATIVE-NEXT:  .LBB11_4:
; GFX7LESS_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX7LESS_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX7LESS_ITERATIVE-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX7LESS_ITERATIVE-NEXT:    v_sub_i32_e32 v0, vcc, s5, v1
; GFX7LESS_ITERATIVE-NEXT:    v_subb_u32_e32 v1, vcc, v3, v2, vcc
; GFX7LESS_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX7LESS_ITERATIVE-NEXT:    s_endpgm
;
; GFX8_ITERATIVE-LABEL: sub_i64_varying:
; GFX8_ITERATIVE:       ; %bb.0: ; %entry
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX8_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX8_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX8_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX8_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX8_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX8_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX8_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX8_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX8_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX8_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX8_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX8_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX8_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX8_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX8_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX8_ITERATIVE-NEXT:  ; %bb.3:
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX8_ITERATIVE-NEXT:    buffer_atomic_sub_x2 v[3:4], off, s[8:11], 0 glc
; GFX8_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX8_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX8_ITERATIVE-NEXT:  .LBB11_4:
; GFX8_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX8_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX8_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX8_ITERATIVE-NEXT:    v_sub_u32_e32 v0, vcc, s5, v1
; GFX8_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX8_ITERATIVE-NEXT:    v_subb_u32_e32 v1, vcc, v3, v2, vcc
; GFX8_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX8_ITERATIVE-NEXT:    s_endpgm
;
; GFX9_ITERATIVE-LABEL: sub_i64_varying:
; GFX9_ITERATIVE:       ; %bb.0: ; %entry
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX9_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX9_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX9_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX9_ITERATIVE-NEXT:    s_mov_b32 m0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s8, v0, s2
; GFX9_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s2
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, m0
; GFX9_ITERATIVE-NEXT:    s_add_u32 s6, s6, s8
; GFX9_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, m0
; GFX9_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX9_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX9_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX9_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX9_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX9_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX9_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX9_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX9_ITERATIVE-NEXT:  ; %bb.3:
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX9_ITERATIVE-NEXT:    buffer_atomic_sub_x2 v[3:4], off, s[8:11], 0 glc
; GFX9_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX9_ITERATIVE-NEXT:    buffer_wbinvl1_vol
; GFX9_ITERATIVE-NEXT:  .LBB11_4:
; GFX9_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9_ITERATIVE-NEXT:    v_readfirstlane_b32 s5, v3
; GFX9_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s4
; GFX9_ITERATIVE-NEXT:    v_sub_co_u32_e32 v0, vcc, s5, v1
; GFX9_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX9_ITERATIVE-NEXT:    v_subb_co_u32_e32 v1, vcc, v3, v2, vcc
; GFX9_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX9_ITERATIVE-NEXT:    s_endpgm
;
; GFX1064_ITERATIVE-LABEL: sub_i64_varying:
; GFX1064_ITERATIVE:       ; %bb.0: ; %entry
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1064_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1064_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1064_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064_ITERATIVE-NEXT:    s_ff1_i32_b64 s2, s[0:1]
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s3, v0, s2
; GFX1064_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s2
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s2
; GFX1064_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, s2
; GFX1064_ITERATIVE-NEXT:    s_add_u32 s6, s6, s3
; GFX1064_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s8
; GFX1064_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1064_ITERATIVE-NEXT:    s_andn2_b64 s[0:1], s[0:1], s[2:3]
; GFX1064_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1064_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1064_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1064_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1064_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1064_ITERATIVE-NEXT:  ; %bb.3:
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX1064_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1064_ITERATIVE-NEXT:    buffer_atomic_sub_x2 v[3:4], off, s[8:11], 0 glc
; GFX1064_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1064_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1064_ITERATIVE-NEXT:  .LBB11_4:
; GFX1064_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1064_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1064_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc, s2, v1
; GFX1064_ITERATIVE-NEXT:    v_sub_co_ci_u32_e32 v1, vcc, s3, v2, vcc
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1064_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1064_ITERATIVE-NEXT:    s_endpgm
;
; GFX1032_ITERATIVE-LABEL: sub_i64_varying:
; GFX1032_ITERATIVE:       ; %bb.0: ; %entry
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GFX1032_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1032_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032_ITERATIVE-NEXT:    s_ff1_i32_b32 s1, s0
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s2, v0, s1
; GFX1032_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v1, s6, s1
; GFX1032_ITERATIVE-NEXT:    v_writelane_b32 v2, s7, s1
; GFX1032_ITERATIVE-NEXT:    s_add_u32 s6, s6, s2
; GFX1032_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX1032_ITERATIVE-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1032_ITERATIVE-NEXT:    s_andn2_b32 s0, s0, s1
; GFX1032_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1032_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1032_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1032_ITERATIVE-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_ITERATIVE-NEXT:    ; implicit-def: $vgpr3_vgpr4
; GFX1032_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1032_ITERATIVE-NEXT:  ; %bb.3:
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s6
; GFX1032_ITERATIVE-NEXT:    v_mov_b32_e32 v4, s7
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1032_ITERATIVE-NEXT:    buffer_atomic_sub_x2 v[3:4], off, s[8:11], 0 glc
; GFX1032_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1032_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1032_ITERATIVE-NEXT:  .LBB11_4:
; GFX1032_ITERATIVE-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1032_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1032_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v1
; GFX1032_ITERATIVE-NEXT:    v_sub_co_ci_u32_e32 v1, vcc_lo, s3, v2, vcc_lo
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1032_ITERATIVE-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX1032_ITERATIVE-NEXT:    s_endpgm
;
; GFX1164_ITERATIVE-LABEL: sub_i64_varying:
; GFX1164_ITERATIVE:       ; %bb.0: ; %entry
; GFX1164_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1164_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1164_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1164_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164_ITERATIVE-NEXT:    s_ctz_i32_b64 s2, s[0:1]
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s3, v2, s2
; GFX1164_ITERATIVE-NEXT:    v_readlane_b32 s8, v3, s2
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s2
; GFX1164_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s2
; GFX1164_ITERATIVE-NEXT:    s_add_u32 s6, s6, s3
; GFX1164_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s8
; GFX1164_ITERATIVE-NEXT:    s_lshl_b64 s[2:3], 1, s2
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[2:3]
; GFX1164_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1164_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1164_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1164_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1164_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1164_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1164_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1164_ITERATIVE-NEXT:  ; %bb.3:
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s6
; GFX1164_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s7
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1164_ITERATIVE-NEXT:    buffer_atomic_sub_u64 v[2:3], off, s[8:11], 0 glc
; GFX1164_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1164_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1164_ITERATIVE-NEXT:  .LBB11_4:
; GFX1164_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1164_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1164_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1164_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1164_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1164_ITERATIVE-NEXT:    s_endpgm
;
; GFX1132_ITERATIVE-LABEL: sub_i64_varying:
; GFX1132_ITERATIVE:       ; %bb.0: ; %entry
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1132_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1132_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s1
; GFX1132_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1132_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s1
; GFX1132_ITERATIVE-NEXT:    s_add_u32 s6, s6, s2
; GFX1132_ITERATIVE-NEXT:    s_addc_u32 s7, s7, s3
; GFX1132_ITERATIVE-NEXT:    s_lshl_b32 s1, 1, s1
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s1
; GFX1132_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1132_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1132_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1132_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1132_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1132_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1132_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1132_ITERATIVE-NEXT:  ; %bb.3:
; GFX1132_ITERATIVE-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1132_ITERATIVE-NEXT:    buffer_atomic_sub_u64 v[2:3], off, s[8:11], 0 glc
; GFX1132_ITERATIVE-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_ITERATIVE-NEXT:    buffer_gl1_inv
; GFX1132_ITERATIVE-NEXT:    buffer_gl0_inv
; GFX1132_ITERATIVE-NEXT:  .LBB11_4:
; GFX1132_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1132_ITERATIVE-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1132_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1132_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1132_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1132_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], 0
; GFX1132_ITERATIVE-NEXT:    s_endpgm
;
; GFX1264_ITERATIVE-LABEL: sub_i64_varying:
; GFX1264_ITERATIVE:       ; %bb.0: ; %entry
; GFX1264_ITERATIVE-NEXT:    v_and_b32_e32 v2, 0x3ff, v0
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[0:1], exec
; GFX1264_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1264_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1264_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264_ITERATIVE-NEXT:    s_ctz_i32_b64 s10, s[0:1]
; GFX1264_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s10
; GFX1264_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s10
; GFX1264_ITERATIVE-NEXT:    s_lshl_b64 s[8:9], 1, s10
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s10
; GFX1264_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s10
; GFX1264_ITERATIVE-NEXT:    s_and_not1_b64 s[0:1], s[0:1], s[8:9]
; GFX1264_ITERATIVE-NEXT:    s_add_nc_u64 s[6:7], s[6:7], s[2:3]
; GFX1264_ITERATIVE-NEXT:    s_cmp_lg_u64 s[0:1], 0
; GFX1264_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1264_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1264_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_mbcnt_hi_u32_b32 v2, exec_hi, v2
; GFX1264_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v2
; GFX1264_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1264_ITERATIVE-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_ITERATIVE-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1264_ITERATIVE-NEXT:  ; %bb.3:
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v2, s6
; GFX1264_ITERATIVE-NEXT:    v_mov_b32_e32 v3, s7
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1264_ITERATIVE-NEXT:    buffer_atomic_sub_u64 v[2:3], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1264_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_ITERATIVE-NEXT:  .LBB11_4:
; GFX1264_ITERATIVE-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1264_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1264_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc, s2, v0
; GFX1264_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1264_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1264_ITERATIVE-NEXT:    s_endpgm
;
; GFX1232_ITERATIVE-LABEL: sub_i64_varying:
; GFX1232_ITERATIVE:       ; %bb.0: ; %entry
; GFX1232_ITERATIVE-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v2, 0x3ff, v0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s0, exec_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b64 s[6:7], 0
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GFX1232_ITERATIVE-NEXT:  .LBB11_1: ; %ComputeLoop
; GFX1232_ITERATIVE-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232_ITERATIVE-NEXT:    s_ctz_i32_b32 s1, s0
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s3, v3, s1
; GFX1232_ITERATIVE-NEXT:    v_readlane_b32 s2, v2, s1
; GFX1232_ITERATIVE-NEXT:    s_lshl_b32 s8, 1, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v1, s7, s1
; GFX1232_ITERATIVE-NEXT:    v_writelane_b32 v0, s6, s1
; GFX1232_ITERATIVE-NEXT:    s_and_not1_b32 s0, s0, s8
; GFX1232_ITERATIVE-NEXT:    s_add_nc_u64 s[6:7], s[6:7], s[2:3]
; GFX1232_ITERATIVE-NEXT:    s_wait_alu 0xfffe
; GFX1232_ITERATIVE-NEXT:    s_cmp_lg_u32 s0, 0
; GFX1232_ITERATIVE-NEXT:    s_cbranch_scc1 .LBB11_1
; GFX1232_ITERATIVE-NEXT:  ; %bb.2: ; %ComputeEnd
; GFX1232_ITERATIVE-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_ITERATIVE-NEXT:    v_mbcnt_lo_u32_b32 v2, exec_lo, 0
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(SALU_CYCLE_1)
; GFX1232_ITERATIVE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v2
; GFX1232_ITERATIVE-NEXT:    ; implicit-def: $vgpr2_vgpr3
; GFX1232_ITERATIVE-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_xor_b32 s4, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_cbranch_execz .LBB11_4
; GFX1232_ITERATIVE-NEXT:  ; %bb.3:
; GFX1232_ITERATIVE-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s10, -1
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s8, s2
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s9, s3
; GFX1232_ITERATIVE-NEXT:    buffer_atomic_sub_u64 v[2:3], off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:    s_wait_loadcnt 0x0
; GFX1232_ITERATIVE-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_ITERATIVE-NEXT:  .LBB11_4:
; GFX1232_ITERATIVE-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1232_ITERATIVE-NEXT:    s_wait_kmcnt 0x0
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1232_ITERATIVE-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1232_ITERATIVE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_ITERATIVE-NEXT:    v_sub_co_u32 v0, vcc_lo, s2, v0
; GFX1232_ITERATIVE-NEXT:    v_sub_co_ci_u32_e64 v1, null, s3, v1, vcc_lo
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_ITERATIVE-NEXT:    s_mov_b32 s2, -1
; GFX1232_ITERATIVE-NEXT:    buffer_store_b64 v[0:1], off, s[0:3], null
; GFX1232_ITERATIVE-NEXT:    s_endpgm
;
; GFX7LESS_DPP-LABEL: sub_i64_varying:
; GFX7LESS_DPP:       ; %bb.0: ; %entry
; GFX7LESS_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS_DPP-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS_DPP-NEXT:    s_mov_b32 s6, -1
; GFX7LESS_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s10, s6
; GFX7LESS_DPP-NEXT:    s_mov_b32 s11, s7
; GFX7LESS_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS_DPP-NEXT:    s_mov_b32 s8, s2
; GFX7LESS_DPP-NEXT:    s_mov_b32 s9, s3
; GFX7LESS_DPP-NEXT:    buffer_atomic_sub_x2 v[0:1], off, s[8:11], 0 glc
; GFX7LESS_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS_DPP-NEXT:    buffer_wbinvl1
; GFX7LESS_DPP-NEXT:    s_mov_b32 s4, s0
; GFX7LESS_DPP-NEXT:    s_mov_b32 s5, s1
; GFX7LESS_DPP-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX7LESS_DPP-NEXT:    s_endpgm
;
; GFX8_DPP-LABEL: sub_i64_varying:
; GFX8_DPP:       ; %bb.0: ; %entry
; GFX8_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX8_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX8_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[4:5]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[4:5]
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX8_DPP-NEXT:    v_addc_u32_e32 v2, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX8_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX8_DPP-NEXT:    v_addc_u32_e32 v4, vcc, v2, v4, vcc
; GFX8_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX8_DPP-NEXT:    v_readlane_b32 s7, v4, 63
; GFX8_DPP-NEXT:    v_readlane_b32 s6, v3, 63
; GFX8_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX8_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX8_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX8_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX8_DPP-NEXT:  ; %bb.1:
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, s6
; GFX8_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s10, -1
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s8, s2
; GFX8_DPP-NEXT:    s_mov_b32 s9, s3
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, s7
; GFX8_DPP-NEXT:    buffer_atomic_sub_x2 v[6:7], off, s[8:11], 0 glc
; GFX8_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX8_DPP-NEXT:    buffer_wbinvl1_vol
; GFX8_DPP-NEXT:  .LBB11_2:
; GFX8_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX8_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX8_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX8_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX8_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX8_DPP-NEXT:    v_sub_u32_e32 v6, vcc, s5, v6
; GFX8_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX8_DPP-NEXT:    s_mov_b32 s2, -1
; GFX8_DPP-NEXT:    v_subb_u32_e32 v7, vcc, v0, v7, vcc
; GFX8_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX8_DPP-NEXT:    s_endpgm
;
; GFX9_DPP-LABEL: sub_i64_varying:
; GFX9_DPP:       ; %bb.0: ; %entry
; GFX9_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_mbcnt_lo_u32_b32 v6, exec_lo, 0
; GFX9_DPP-NEXT:    v_mbcnt_hi_u32_b32 v6, exec_hi, v6
; GFX9_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[4:5]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, 0, s[4:5]
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:15 row_mask:0xa bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX9_DPP-NEXT:    v_mov_b32_dpp v5, v3 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_add_co_u32_e32 v3, vcc, v3, v5
; GFX9_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_bcast:31 row_mask:0xc bank_mask:0xf
; GFX9_DPP-NEXT:    v_addc_co_u32_e32 v4, vcc, v2, v4, vcc
; GFX9_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX9_DPP-NEXT:    v_readlane_b32 s7, v4, 63
; GFX9_DPP-NEXT:    v_readlane_b32 s6, v3, 63
; GFX9_DPP-NEXT:    v_mov_b32_dpp v2, v4 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    v_mov_b32_dpp v1, v3 wave_shr:1 row_mask:0xf bank_mask:0xf
; GFX9_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v6
; GFX9_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX9_DPP-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX9_DPP-NEXT:  ; %bb.1:
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, s6
; GFX9_DPP-NEXT:    s_mov_b32 s11, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s10, -1
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s8, s2
; GFX9_DPP-NEXT:    s_mov_b32 s9, s3
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, s7
; GFX9_DPP-NEXT:    buffer_atomic_sub_x2 v[6:7], off, s[8:11], 0 glc
; GFX9_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX9_DPP-NEXT:    buffer_wbinvl1_vol
; GFX9_DPP-NEXT:  .LBB11_2:
; GFX9_DPP-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s4, v7
; GFX9_DPP-NEXT:    v_readfirstlane_b32 s5, v6
; GFX9_DPP-NEXT:    v_mov_b32_e32 v6, v1
; GFX9_DPP-NEXT:    v_mov_b32_e32 v7, v2
; GFX9_DPP-NEXT:    v_mov_b32_e32 v0, s4
; GFX9_DPP-NEXT:    v_sub_co_u32_e32 v6, vcc, s5, v6
; GFX9_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9_DPP-NEXT:    s_mov_b32 s3, 0xf000
; GFX9_DPP-NEXT:    s_mov_b32 s2, -1
; GFX9_DPP-NEXT:    v_subb_co_u32_e32 v7, vcc, v0, v7, vcc
; GFX9_DPP-NEXT:    buffer_store_dwordx2 v[6:7], off, s[0:3], 0
; GFX9_DPP-NEXT:    s_endpgm
;
; GFX1064_DPP-LABEL: sub_i64_varying:
; GFX1064_DPP:       ; %bb.0: ; %entry
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s[0:1]
; GFX1064_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s[0:1]
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v2, v1
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v3, v4, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v4
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v3, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v6
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1064_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1064_DPP-NEXT:    v_readlane_b32 s3, v2, 31
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, s3
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1064_DPP-NEXT:    v_add_co_u32 v1, vcc, v1, v3
; GFX1064_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc, v2, v5, vcc
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1064_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_mov_b32_dpp v7, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1064_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1064_DPP-NEXT:    v_readlane_b32 s10, v1, 47
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s6, 16
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1064_DPP-NEXT:    v_readlane_b32 s6, v1, 63
; GFX1064_DPP-NEXT:    v_readlane_b32 s11, v2, 47
; GFX1064_DPP-NEXT:    v_readlane_b32 s7, v2, 63
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s8, 32
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s9, 32
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1064_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1064_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1064_DPP-NEXT:    v_writelane_b32 v7, s11, 48
; GFX1064_DPP-NEXT:    v_writelane_b32 v6, s10, 48
; GFX1064_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1064_DPP-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1064_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1064_DPP-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1064_DPP-NEXT:  ; %bb.1:
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v9, s5
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v8, s4
; GFX1064_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1064_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1064_DPP-NEXT:    buffer_atomic_sub_x2 v[8:9], off, s[4:7], 0 glc
; GFX1064_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1064_DPP-NEXT:    buffer_gl1_inv
; GFX1064_DPP-NEXT:    buffer_gl0_inv
; GFX1064_DPP-NEXT:  .LBB11_2:
; GFX1064_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1064_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1064_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1064_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1064_DPP-NEXT:    v_sub_co_u32 v8, vcc, s2, v10
; GFX1064_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1064_DPP-NEXT:    v_sub_co_ci_u32_e32 v9, vcc, s3, v11, vcc
; GFX1064_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064_DPP-NEXT:    buffer_store_dwordx2 v[8:9], off, s[0:3], 0
; GFX1064_DPP-NEXT:    s_endpgm
;
; GFX1032_DPP-LABEL: sub_i64_varying:
; GFX1032_DPP:       ; %bb.0: ; %entry
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v1, 0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v2, 0, v0, s0
; GFX1032_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, 0, s0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v8, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v3 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v7, 0
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v2, v1
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v3, v4, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v2 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v4
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v3, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v6, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v2 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v6
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1032_DPP-NEXT:    v_permlanex16_b32 v6, v2, -1, -1
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v5, v6 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1032_DPP-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1032_DPP-NEXT:    v_add_co_u32 v1, vcc_lo, v1, v3
; GFX1032_DPP-NEXT:    v_add_co_ci_u32_e32 v2, vcc_lo, v2, v5, vcc_lo
; GFX1032_DPP-NEXT:    v_readlane_b32 s4, v1, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s8, v2, 15
; GFX1032_DPP-NEXT:    v_readlane_b32 s5, v2, 31
; GFX1032_DPP-NEXT:    v_mov_b32_dpp v8, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1032_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1032_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1032_DPP-NEXT:    v_writelane_b32 v8, s8, 16
; GFX1032_DPP-NEXT:    v_writelane_b32 v7, s7, 16
; GFX1032_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1032_DPP-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1032_DPP-NEXT:    ; implicit-def: $vgpr9_vgpr10
; GFX1032_DPP-NEXT:    s_and_saveexec_b32 s8, vcc_lo
; GFX1032_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1032_DPP-NEXT:  ; %bb.1:
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v10, s5
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v9, s4
; GFX1032_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1032_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1032_DPP-NEXT:    buffer_atomic_sub_x2 v[9:10], off, s[4:7], 0 glc
; GFX1032_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1032_DPP-NEXT:    buffer_gl1_inv
; GFX1032_DPP-NEXT:    buffer_gl0_inv
; GFX1032_DPP-NEXT:  .LBB11_2:
; GFX1032_DPP-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1032_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1032_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s2, v9
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1032_DPP-NEXT:    v_mov_b32_e32 v12, v8
; GFX1032_DPP-NEXT:    v_readfirstlane_b32 s3, v10
; GFX1032_DPP-NEXT:    v_sub_co_u32 v9, vcc_lo, s2, v11
; GFX1032_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1032_DPP-NEXT:    v_sub_co_ci_u32_e32 v10, vcc_lo, s3, v12, vcc_lo
; GFX1032_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032_DPP-NEXT:    buffer_store_dwordx2 v[9:10], off, s[0:3], 0
; GFX1032_DPP-NEXT:    s_endpgm
;
; GFX1164_DPP-LABEL: sub_i64_varying:
; GFX1164_DPP:       ; %bb.0: ; %entry
; GFX1164_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1164_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1164_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1164_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1164_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1164_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1164_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s7, 16
; GFX1164_DPP-NEXT:    v_readlane_b32 s10, v2, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s11, v1, 47
; GFX1164_DPP-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s8, 32
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s9, 32
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1164_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1164_DPP-NEXT:    v_writelane_b32 v4, s10, 48
; GFX1164_DPP-NEXT:    v_writelane_b32 v5, s11, 48
; GFX1164_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1164_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1164_DPP-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX1164_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1164_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1164_DPP-NEXT:  ; %bb.1:
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v7, s5
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v6, s4
; GFX1164_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1164_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1164_DPP-NEXT:    buffer_atomic_sub_u64 v[6:7], off, s[4:7], 0 glc
; GFX1164_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1164_DPP-NEXT:    buffer_gl1_inv
; GFX1164_DPP-NEXT:    buffer_gl0_inv
; GFX1164_DPP-NEXT:  .LBB11_2:
; GFX1164_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s2, v6
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX1164_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1164_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1164_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1164_DPP-NEXT:    v_sub_co_u32 v6, vcc, s2, v8
; GFX1164_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1164_DPP-NEXT:    v_sub_co_ci_u32_e64 v7, null, s3, v9, vcc
; GFX1164_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164_DPP-NEXT:    buffer_store_b64 v[6:7], off, s[0:3], 0
; GFX1164_DPP-NEXT:    s_endpgm
;
; GFX1132_DPP-LABEL: sub_i64_varying:
; GFX1132_DPP:       ; %bb.0: ; %entry
; GFX1132_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s0
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1132_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1132_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX1132_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1132_DPP-NEXT:    v_readlane_b32 s4, v2, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    v_readlane_b32 s7, v2, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s8, v1, 15
; GFX1132_DPP-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1132_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1132_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1132_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1132_DPP-NEXT:    v_writelane_b32 v7, s8, 16
; GFX1132_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1132_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1132_DPP-NEXT:    s_mov_b32 s8, exec_lo
; GFX1132_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1132_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1132_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1132_DPP-NEXT:  ; %bb.1:
; GFX1132_DPP-NEXT:    v_dual_mov_b32 v9, s5 :: v_dual_mov_b32 v8, s4
; GFX1132_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1132_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1132_DPP-NEXT:    buffer_atomic_sub_u64 v[8:9], off, s[4:7], 0 glc
; GFX1132_DPP-NEXT:    s_waitcnt vmcnt(0)
; GFX1132_DPP-NEXT:    buffer_gl1_inv
; GFX1132_DPP-NEXT:    buffer_gl0_inv
; GFX1132_DPP-NEXT:  .LBB11_2:
; GFX1132_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1132_DPP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1132_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1132_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1132_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1132_DPP-NEXT:    v_sub_co_u32 v8, vcc_lo, s2, v10
; GFX1132_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1132_DPP-NEXT:    v_sub_co_ci_u32_e64 v9, null, s3, v11, vcc_lo
; GFX1132_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], 0
; GFX1132_DPP-NEXT:    s_endpgm
;
; GFX1264_DPP-LABEL: sub_i64_varying:
; GFX1264_DPP:       ; %bb.0: ; %entry
; GFX1264_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[0:1], -1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1264_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s[0:1]
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v5, 0
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v1, 31
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, s2
; GFX1264_DPP-NEXT:    v_readlane_b32 s2, v2, 31
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1264_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc, v2, s2 quad_perm:[0,1,2,3] row_mask:0xc bank_mask:0xf
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[0:1]
; GFX1264_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v4, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v2, 15
; GFX1264_DPP-NEXT:    v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 15
; GFX1264_DPP-NEXT:    v_readlane_b32 s8, v2, 31
; GFX1264_DPP-NEXT:    v_readlane_b32 s9, v1, 31
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s6, 16
; GFX1264_DPP-NEXT:    v_readlane_b32 s6, v2, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s7, 16
; GFX1264_DPP-NEXT:    v_readlane_b32 s10, v2, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s11, v1, 47
; GFX1264_DPP-NEXT:    v_readlane_b32 s7, v1, 63
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s8, 32
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s9, 32
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[4:5]
; GFX1264_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264_DPP-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264_DPP-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GFX1264_DPP-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX1264_DPP-NEXT:    v_writelane_b32 v4, s10, 48
; GFX1264_DPP-NEXT:    v_writelane_b32 v5, s11, 48
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_mov_b64 exec, s[8:9]
; GFX1264_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1264_DPP-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264_DPP-NEXT:    ; implicit-def: $vgpr6_vgpr7
; GFX1264_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1264_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1264_DPP-NEXT:  ; %bb.1:
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v7, s5
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v6, s4
; GFX1264_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1264_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1264_DPP-NEXT:    buffer_atomic_sub_u64 v[6:7], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1264_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1264_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1264_DPP-NEXT:  .LBB11_2:
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1264_DPP-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s2, v6
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v8, v4
; GFX1264_DPP-NEXT:    v_mov_b32_e32 v9, v5
; GFX1264_DPP-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1264_DPP-NEXT:    s_wait_alu 0xf1ff
; GFX1264_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1264_DPP-NEXT:    v_sub_co_u32 v6, vcc, s2, v8
; GFX1264_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1264_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1264_DPP-NEXT:    v_sub_co_ci_u32_e64 v7, null, s3, v9, vcc
; GFX1264_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264_DPP-NEXT:    buffer_store_b64 v[6:7], off, s[0:3], null
; GFX1264_DPP-NEXT:    s_endpgm
;
; GFX1232_DPP-LABEL: sub_i64_varying:
; GFX1232_DPP:       ; %bb.0: ; %entry
; GFX1232_DPP-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s0, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v1, 0, 0, s0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1232_DPP-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s0
; GFX1232_DPP-NEXT:    v_dual_mov_b32 v4, 0 :: v_dual_mov_b32 v7, 0
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v6, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:1 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:2 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v2, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:2 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v3, vcc_lo, v3, v3 row_shr:4 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v4, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v2, v1 row_shr:4 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v2, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v3, v3 row_shr:8 row_mask:0xf bank_mask:0xf bound_ctrl:1
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v3, 0
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v4, v1 row_shr:8 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v5, v2, -1, -1
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v4, vcc_lo
; GFX1232_DPP-NEXT:    v_add_co_u32_e64_dpp v2, vcc_lo, v5, v2 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232_DPP-NEXT:    v_permlanex16_b32 v4, v1, -1, -1
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v3, v4 quad_perm:[0,1,2,3] row_mask:0xa bank_mask:0xf
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s0
; GFX1232_DPP-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX1232_DPP-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX1232_DPP-NEXT:    v_readlane_b32 s4, v2, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v6, v2 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    v_readlane_b32 s7, v2, 15
; GFX1232_DPP-NEXT:    v_readlane_b32 s8, v1, 15
; GFX1232_DPP-NEXT:    v_readlane_b32 s5, v1, 31
; GFX1232_DPP-NEXT:    v_mov_b32_dpp v7, v1 row_shr:1 row_mask:0xf bank_mask:0xf
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1232_DPP-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1232_DPP-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232_DPP-NEXT:    s_or_saveexec_b32 s6, -1
; GFX1232_DPP-NEXT:    v_writelane_b32 v6, s7, 16
; GFX1232_DPP-NEXT:    v_writelane_b32 v7, s8, 16
; GFX1232_DPP-NEXT:    s_mov_b32 exec_lo, s6
; GFX1232_DPP-NEXT:    s_mov_b32 s6, -1
; GFX1232_DPP-NEXT:    s_mov_b32 s8, exec_lo
; GFX1232_DPP-NEXT:    ; implicit-def: $vgpr8_vgpr9
; GFX1232_DPP-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX1232_DPP-NEXT:    s_cbranch_execz .LBB11_2
; GFX1232_DPP-NEXT:  ; %bb.1:
; GFX1232_DPP-NEXT:    v_dual_mov_b32 v9, s5 :: v_dual_mov_b32 v8, s4
; GFX1232_DPP-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    s_mov_b32 s4, s2
; GFX1232_DPP-NEXT:    s_mov_b32 s5, s3
; GFX1232_DPP-NEXT:    buffer_atomic_sub_u64 v[8:9], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX1232_DPP-NEXT:    s_wait_loadcnt 0x0
; GFX1232_DPP-NEXT:    global_inv scope:SCOPE_DEV
; GFX1232_DPP-NEXT:  .LBB11_2:
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffe
; GFX1232_DPP-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232_DPP-NEXT:    s_wait_kmcnt 0x0
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v10, v6
; GFX1232_DPP-NEXT:    v_mov_b32_e32 v11, v7
; GFX1232_DPP-NEXT:    v_readfirstlane_b32 s3, v9
; GFX1232_DPP-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1232_DPP-NEXT:    v_sub_co_u32 v8, vcc_lo, s2, v10
; GFX1232_DPP-NEXT:    s_mov_b32 s2, s6
; GFX1232_DPP-NEXT:    s_wait_alu 0xfffd
; GFX1232_DPP-NEXT:    v_sub_co_ci_u32_e64 v9, null, s3, v11, vcc_lo
; GFX1232_DPP-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232_DPP-NEXT:    buffer_store_b64 v[8:9], off, s[0:3], null
; GFX1232_DPP-NEXT:    s_endpgm
entry:
  %lane = call i32 @llvm.amdgcn.workitem.id.x()
  %zext = zext i32 %lane to i64
  %old = atomicrmw sub ptr addrspace(1) %inout, i64 %zext syncscope("agent") acq_rel
  store i64 %old, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @uniform_or_i8(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i8 %val) {
; GFX7LESS-LABEL: uniform_or_i8:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB12_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s8, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_and_b32 s7, s6, 0xff
; GFX7LESS-NEXT:    s_lshl_b32 s7, s7, s2
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s7
; GFX7LESS-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s2, v0
; GFX7LESS-NEXT:  .LBB12_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; GFX7LESS-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX7LESS-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_or_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB12_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s8, s2, -4
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    s_lshl_b32 s2, s2, 3
; GFX8-NEXT:    s_and_b32 s3, s6, 0xff
; GFX8-NEXT:    s_lshl_b32 s3, s3, s2
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s2, v0
; GFX8-NEXT:  .LBB12_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_or_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s8, s2, -4
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    s_and_b32 s3, s6, 0xff
; GFX9-NEXT:    s_lshl_b32 s3, s3, s2
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s2, v0
; GFX9-NEXT:  .LBB12_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_or_i8:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB12_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s7, s2, 3
; GFX1064-NEXT:    s_and_b32 s8, s6, 0xff
; GFX1064-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1064-NEXT:    s_and_b32 s8, s2, -4
; GFX1064-NEXT:    v_mov_b32_e32 v0, s9
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1064-NEXT:  .LBB12_2:
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1064-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_or_i8:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB12_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s5, s2, 3
; GFX1032-NEXT:    s_and_b32 s7, s6, 0xff
; GFX1032-NEXT:    s_lshl_b32 s5, s5, 3
; GFX1032-NEXT:    s_and_b32 s8, s2, -4
; GFX1032-NEXT:    s_lshl_b32 s7, s7, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s7
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s5, v0
; GFX1032-NEXT:  .LBB12_2:
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc_lo
; GFX1032-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_or_i8:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1164-TRUE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-TRUE16-NEXT:  ; %bb.1:
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1164-TRUE16-NEXT:    s_and_b32 s8, s6, 0xff
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1164-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1164-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1164-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1164-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1164-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1164-TRUE16-NEXT:  .LBB12_2:
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-TRUE16-NEXT:    v_cndmask_b16 v0.l, s6, 0, vcc
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_or_i8:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1164-FAKE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1164-FAKE16-NEXT:  ; %bb.1:
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1164-FAKE16-NEXT:    s_and_b32 s8, s6, 0xff
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1164-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1164-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1164-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1164-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1164-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1164-FAKE16-NEXT:  .LBB12_2:
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_or_i8:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1132-TRUE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-TRUE16-NEXT:  ; %bb.1:
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1132-TRUE16-NEXT:    s_and_b32 s7, s4, 0xff
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1132-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1132-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1132-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1132-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1132-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1132-TRUE16-NEXT:  .LBB12_2:
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-TRUE16-NEXT:    v_cndmask_b16 v0.l, s4, 0, vcc_lo
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_or_i8:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1132-FAKE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1132-FAKE16-NEXT:  ; %bb.1:
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1132-FAKE16-NEXT:    s_and_b32 s7, s4, 0xff
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1132-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1132-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1132-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1132-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1132-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1132-FAKE16-NEXT:  .LBB12_2:
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s4, 0, vcc_lo
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_or_i8:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1264-TRUE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1264-TRUE16-NEXT:  ; %bb.1:
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1264-TRUE16-NEXT:    s_and_b32 s8, s6, 0xff
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1264-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1264-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1264-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1264-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1264-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1264-TRUE16-NEXT:  .LBB12_2:
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-TRUE16-NEXT:    v_cndmask_b16 v0.l, s6, 0, vcc
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_or_i8:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1264-FAKE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1264-FAKE16-NEXT:  ; %bb.1:
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1264-FAKE16-NEXT:    s_and_b32 s8, s6, 0xff
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1264-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1264-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1264-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1264-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1264-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1264-FAKE16-NEXT:  .LBB12_2:
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_or_i8:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1232-TRUE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1232-TRUE16-NEXT:  ; %bb.1:
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1232-TRUE16-NEXT:    s_and_b32 s7, s4, 0xff
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1232-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1232-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1232-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1232-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1232-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1232-TRUE16-NEXT:  .LBB12_2:
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-TRUE16-NEXT:    v_cndmask_b16 v0.l, s4, 0, vcc_lo
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_or_i8:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1232-FAKE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX1232-FAKE16-NEXT:  ; %bb.1:
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1232-FAKE16-NEXT:    s_and_b32 s7, s4, 0xff
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1232-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1232-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1232-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1232-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1232-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1232-FAKE16-NEXT:  .LBB12_2:
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s4, 0, vcc_lo
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw or ptr addrspace(1) %uniform.ptr, i8 %val monotonic, align 1
  store i8 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_add_i8(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i8 %val) {
; GFX7LESS-LABEL: uniform_add_i8:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s10, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v4, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB13_4
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s11, s2, 3
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mul_i32 s6, s10, s6
; GFX7LESS-NEXT:    s_lshl_b32 s11, s11, 3
; GFX7LESS-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX7LESS-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX7LESS-NEXT:    s_and_b32 s6, s6, 0xff
; GFX7LESS-NEXT:    s_not_b32 s13, s12
; GFX7LESS-NEXT:    s_lshl_b32 s14, s6, s11
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s15
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s14, v1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_and_b32_e32 v2, s13, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB13_2
; GFX7LESS-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX7LESS-NEXT:  .LBB13_4: ; %Flow
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    s_and_b32 s5, s10, 0xff
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, s5, v4, v0
; GFX7LESS-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_add_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB13_4
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s4, s[6:7]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s6, s10, s4
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s11, s2, 3
; GFX8-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX8-NEXT:    s_and_b32 s2, s6, 0xff
; GFX8-NEXT:    s_not_b32 s13, s12
; GFX8-NEXT:    s_lshl_b32 s14, s2, s11
; GFX8-NEXT:    s_mov_b64 s[2:3], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s14, v1
; GFX8-NEXT:    v_and_b32_e32 v2, s13, v1
; GFX8-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_cbranch_execnz .LBB13_2
; GFX8-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX8-NEXT:  .LBB13_4: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_mad_u16 v0, s10, v4, v0
; GFX8-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_add_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB13_4
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s4, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s6, s10, s4
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s11, s2, 3
; GFX9-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX9-NEXT:    s_and_b32 s2, s6, 0xff
; GFX9-NEXT:    s_not_b32 s13, s12
; GFX9-NEXT:    s_lshl_b32 s14, s2, s11
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_u32_e32 v0, s14, v1
; GFX9-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX9-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB13_2
; GFX9-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX9-NEXT:  .LBB13_4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_mad_legacy_u16 v0, s10, v4, v0
; GFX9-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_add_i8:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX1064-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB13_4
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1064-NEXT:    s_mul_i32 s2, s10, s6
; GFX1064-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX1064-NEXT:    s_and_b32 s2, s2, 0xff
; GFX1064-NEXT:    s_not_b32 s13, s12
; GFX1064-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1064-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1064-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1064-NEXT:  .LBB13_4: ; %Flow
; GFX1064-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_add_i8:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    s_mov_b32 s10, 0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v4
; GFX1032-NEXT:    s_and_saveexec_b32 s9, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB13_4
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1032-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_mul_i32 s6, s8, s6
; GFX1032-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1032-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1032-NEXT:    s_not_b32 s11, s3
; GFX1032-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1032-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s10
; GFX1032-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1032-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:  .LBB13_4: ; %Flow
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_add_i8:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1164-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1164-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-TRUE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1164-TRUE16-NEXT:  ; %bb.1:
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-TRUE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1164-TRUE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX1164-TRUE16-NEXT:    s_not_b32 s13, s12
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1164-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-TRUE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1164-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-TRUE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1164-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1164-TRUE16-NEXT:  .LBB13_4: ; %Flow
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mad_u16 v0.l, s10, v4.l, s2
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_add_i8:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1164-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1164-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-FAKE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1164-FAKE16-NEXT:  ; %bb.1:
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-FAKE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1164-FAKE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX1164-FAKE16-NEXT:    s_not_b32 s13, s12
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1164-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-FAKE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1164-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-FAKE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1164-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1164-FAKE16-NEXT:  .LBB13_4: ; %Flow
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_add_i8:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-TRUE16-NEXT:    s_mov_b32 s10, 0
; GFX1132-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1132-TRUE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1132-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-TRUE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1132-TRUE16-NEXT:  ; %bb.1:
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-TRUE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1132-TRUE16-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1132-TRUE16-NEXT:    s_not_b32 s11, s3
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-TRUE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1132-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1132-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-TRUE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1132-TRUE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1132-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-TRUE16-NEXT:  .LBB13_4: ; %Flow
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_mad_u16 v0.l, s8, v4.l, s2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_add_i8:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-FAKE16-NEXT:    s_mov_b32 s10, 0
; GFX1132-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1132-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-FAKE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1132-FAKE16-NEXT:  ; %bb.1:
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-FAKE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1132-FAKE16-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1132-FAKE16-NEXT:    s_not_b32 s11, s3
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-FAKE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1132-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1132-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-FAKE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1132-FAKE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1132-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-FAKE16-NEXT:  .LBB13_4: ; %Flow
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_add_i8:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1264-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1264-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1264-TRUE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1264-TRUE16-NEXT:  ; %bb.1:
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-TRUE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-TRUE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX1264-TRUE16-NEXT:    s_not_b32 s13, s12
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1264-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-TRUE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1264-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1264-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1264-TRUE16-NEXT:  .LBB13_4: ; %Flow
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mad_u16 v0.l, s10, v4.l, s2
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_add_i8:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1264-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1264-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1264-FAKE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1264-FAKE16-NEXT:  ; %bb.1:
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-FAKE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-FAKE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s12, 0xff, s11
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 0xff
; GFX1264-FAKE16-NEXT:    s_not_b32 s13, s12
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1264-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-FAKE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1264-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1264-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1264-FAKE16-NEXT:  .LBB13_4: ; %Flow
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_add_i8:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-TRUE16-NEXT:    s_mov_b32 s10, 0
; GFX1232-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1232-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1232-TRUE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1232-TRUE16-NEXT:  ; %bb.1:
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-TRUE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1232-TRUE16-NEXT:    s_not_b32 s11, s3
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-TRUE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1232-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1232-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-TRUE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1232-TRUE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1232-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-TRUE16-NEXT:  .LBB13_4: ; %Flow
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_mad_u16 v0.l, s8, v4.l, s2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_add_i8:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-FAKE16-NEXT:    s_mov_b32 s10, 0
; GFX1232-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1232-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1232-FAKE16-NEXT:    s_cbranch_execz .LBB13_4
; GFX1232-FAKE16-NEXT:  ; %bb.1:
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-FAKE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1232-FAKE16-NEXT:    s_not_b32 s11, s3
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-FAKE16-NEXT:  .LBB13_2: ; %atomicrmw.start
; GFX1232-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1232-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-FAKE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1232-FAKE16-NEXT:    s_cbranch_execnz .LBB13_2
; GFX1232-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-FAKE16-NEXT:  .LBB13_4: ; %Flow
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw add ptr addrspace(1) %uniform.ptr, i8 %val monotonic, align 1
  store i8 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_xchg_i8(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i8 %val) {
; GFX7LESS-LABEL: uniform_xchg_i8:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_and_b32 s3, s6, 0xff
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7LESS-NEXT:    s_lshl_b32 s10, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s11, 0xff, s10
; GFX7LESS-NEXT:    s_lshl_b32 s2, s3, s10
; GFX7LESS-NEXT:    s_not_b32 s3, s11
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, s3, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX7LESS-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_xchg_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s8, s2, 3
; GFX8-NEXT:    s_lshl_b32 s2, 0xff, s8
; GFX8-NEXT:    s_not_b32 s9, s2
; GFX8-NEXT:    s_and_b32 s2, s6, 0xff
; GFX8-NEXT:    s_lshl_b32 s10, s2, s8
; GFX8-NEXT:    s_mov_b64 s[2:3], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_and_b32_e32 v0, s9, v1
; GFX8-NEXT:    v_or_b32_e32 v0, s10, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX8-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_xchg_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s8, s2, 3
; GFX9-NEXT:    s_lshl_b32 s2, 0xff, s8
; GFX9-NEXT:    s_not_b32 s9, s2
; GFX9-NEXT:    s_and_b32 s2, s6, 0xff
; GFX9-NEXT:    s_lshl_b32 s10, s2, s8
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_and_b32_e32 v0, s9, v1
; GFX9-NEXT:    v_or_b32_e32 v0, s10, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB14_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX9-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_xchg_i8:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX1064-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1064-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1064-NEXT:    s_lshl_b32 s2, 0xff, s8
; GFX1064-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1064-NEXT:    s_not_b32 s9, s2
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_xchg_i8:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s9, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1032-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1032-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1032-NEXT:    s_not_b32 s3, s3
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: uniform_xchg_i8:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-NEXT:    s_mov_b32 s5, s3
; GFX1164-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1164-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1164-NEXT:    s_lshl_b32 s2, 0xff, s8
; GFX1164-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1164-NEXT:    s_not_b32 s9, s2
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1164-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: uniform_xchg_i8:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s9, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-NEXT:    s_mov_b32 s5, s3
; GFX1132-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1132-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1132-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1132-NEXT:    s_not_b32 s3, s3
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1132-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b8 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: uniform_xchg_i8:
; GFX1264:       ; %bb.0:
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-NEXT:    s_mov_b32 s5, s3
; GFX1264-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1264-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1264-NEXT:    s_lshl_b32 s2, 0xff, s8
; GFX1264-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1264-NEXT:    s_not_b32 s9, s2
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1264-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1264-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1264-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: uniform_xchg_i8:
; GFX1232:       ; %bb.0:
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s9, 0
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-NEXT:    s_mov_b32 s5, s3
; GFX1232-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-NEXT:    s_and_b32 s6, s6, 0xff
; GFX1232-NEXT:    s_lshl_b32 s3, 0xff, s2
; GFX1232-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1232-NEXT:    s_not_b32 s3, s3
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX1232-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1232-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    s_cbranch_execnz .LBB14_1
; GFX1232-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b8 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
  %rmw = atomicrmw xchg ptr addrspace(1) %uniform.ptr, i8 %val monotonic, align 1
  store i8 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_or_i16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i16 %val) {
; GFX7LESS-LABEL: uniform_or_i16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, exec_lo, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, exec_hi, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB15_2
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s8, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s11, 0xf000
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_and_b32 s7, s6, 0xffff
; GFX7LESS-NEXT:    s_lshl_b32 s7, s7, s2
; GFX7LESS-NEXT:    s_mov_b32 s10, -1
; GFX7LESS-NEXT:    s_mov_b32 s9, s3
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s7
; GFX7LESS-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX7LESS-NEXT:    v_bfe_u32 v0, v0, s2, 16
; GFX7LESS-NEXT:  .LBB15_2:
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    v_cndmask_b32_e64 v0, v1, 0, vcc
; GFX7LESS-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX7LESS-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_or_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB15_2
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s8, s2, -4
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    s_lshl_b32 s2, s2, 3
; GFX8-NEXT:    s_and_b32 s3, 0xffff, s6
; GFX8-NEXT:    s_lshl_b32 s3, s3, s2
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    v_mov_b32_e32 v0, s3
; GFX8-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s2, v0
; GFX8-NEXT:  .LBB15_2:
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_or_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB15_2
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s8, s2, -4
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_mov_b32 s9, s3
; GFX9-NEXT:    s_lshl_b32 s2, s2, 3
; GFX9-NEXT:    s_and_b32 s3, 0xffff, s6
; GFX9-NEXT:    s_lshl_b32 s3, s3, s2
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s2, v0
; GFX9-NEXT:  .LBB15_2:
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_or_i16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB15_2
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s7, s2, 3
; GFX1064-NEXT:    s_and_b32 s8, 0xffff, s6
; GFX1064-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1064-NEXT:    s_and_b32 s8, s2, -4
; GFX1064-NEXT:    v_mov_b32_e32 v0, s9
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    s_mov_b32 s9, s3
; GFX1064-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1064-NEXT:  .LBB15_2:
; GFX1064-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1064-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1064-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_or_i16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB15_2
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s5, s2, 3
; GFX1032-NEXT:    s_and_b32 s7, 0xffff, s6
; GFX1032-NEXT:    s_lshl_b32 s5, s5, 3
; GFX1032-NEXT:    s_and_b32 s8, s2, -4
; GFX1032-NEXT:    s_lshl_b32 s7, s7, s5
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    v_mov_b32_e32 v0, s7
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    s_mov_b32 s9, s3
; GFX1032-NEXT:    buffer_atomic_or v0, off, s[8:11], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s5, v0
; GFX1032-NEXT:  .LBB15_2:
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX1032-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc_lo
; GFX1032-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_or_i16:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1164-TRUE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-TRUE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1164-TRUE16-NEXT:  ; %bb.1:
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1164-TRUE16-NEXT:    s_and_b32 s8, 0xffff, s6
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1164-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1164-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1164-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1164-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1164-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1164-TRUE16-NEXT:  .LBB15_2:
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-TRUE16-NEXT:    v_cndmask_b16 v0.l, s6, 0, vcc
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_or_i16:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1164-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1164-FAKE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1164-FAKE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1164-FAKE16-NEXT:  ; %bb.1:
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1164-FAKE16-NEXT:    s_and_b32 s8, 0xffff, s6
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1164-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1164-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1164-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1164-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1164-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1164-FAKE16-NEXT:  .LBB15_2:
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_or_i16:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1132-TRUE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-TRUE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1132-TRUE16-NEXT:  ; %bb.1:
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1132-TRUE16-NEXT:    s_and_b32 s7, 0xffff, s4
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1132-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1132-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1132-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1132-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1132-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1132-TRUE16-NEXT:  .LBB15_2:
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-TRUE16-NEXT:    v_cndmask_b16 v0.l, s4, 0, vcc_lo
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_or_i16:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1132-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1132-FAKE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1132-FAKE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1132-FAKE16-NEXT:  ; %bb.1:
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1132-FAKE16-NEXT:    s_and_b32 s7, 0xffff, s4
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1132-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1132-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1132-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1132-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1132-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1132-FAKE16-NEXT:  .LBB15_2:
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s4, 0, vcc_lo
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_or_i16:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1264-TRUE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-TRUE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1264-TRUE16-NEXT:  ; %bb.1:
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1264-TRUE16-NEXT:    s_and_b32 s8, 0xffff, s6
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1264-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1264-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1264-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1264-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1264-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1264-TRUE16-NEXT:  .LBB15_2:
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-TRUE16-NEXT:    v_cndmask_b16 v0.l, s6, 0, vcc
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_or_i16:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v0, exec_hi, v0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX1264-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1264-FAKE16-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX1264-FAKE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1264-FAKE16-NEXT:  ; %bb.1:
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s7, s2, 3
; GFX1264-FAKE16-NEXT:    s_and_b32 s8, 0xffff, s6
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s7, s7, 3
; GFX1264-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s9, s8, s7
; GFX1264-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v0, s9
; GFX1264-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1264-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1264-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s7, v0
; GFX1264-FAKE16-NEXT:  .LBB15_2:
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s6, 0, vcc
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_or_i16:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1232-TRUE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-TRUE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1232-TRUE16-NEXT:  ; %bb.1:
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1232-TRUE16-NEXT:    s_and_b32 s7, 0xffff, s4
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1232-TRUE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1232-TRUE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1232-TRUE16-NEXT:    s_mov_b32 s10, -1
; GFX1232-TRUE16-NEXT:    s_mov_b32 s9, s3
; GFX1232-TRUE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1232-TRUE16-NEXT:  .LBB15_2:
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-TRUE16-NEXT:    v_cndmask_b16 v0.l, s4, 0, vcc_lo
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_or_b16 v0.l, s2, v0.l
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_or_i16:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, exec_lo, 0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX1232-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1232-FAKE16-NEXT:    s_and_saveexec_b32 s5, vcc_lo
; GFX1232-FAKE16-NEXT:    s_cbranch_execz .LBB15_2
; GFX1232-FAKE16-NEXT:  ; %bb.1:
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s6, s2, 3
; GFX1232-FAKE16-NEXT:    s_and_b32 s7, 0xffff, s4
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s6, s6, 3
; GFX1232-FAKE16-NEXT:    s_and_b32 s8, s2, -4
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s7, s7, s6
; GFX1232-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v0, s7
; GFX1232-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1232-FAKE16-NEXT:    s_mov_b32 s9, s3
; GFX1232-FAKE16-NEXT:    buffer_atomic_or_b32 v0, off, s[8:11], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s6, v0
; GFX1232-FAKE16-NEXT:  .LBB15_2:
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-FAKE16-NEXT:    v_cndmask_b32_e64 v0, s4, 0, vcc_lo
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw or ptr addrspace(1) %uniform.ptr, i16 %val monotonic, align 2
  store i16 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_add_i16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i16 %val) {
; GFX7LESS-LABEL: uniform_add_i16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_mov_b64 s[6:7], exec
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s10, s[4:5], 0xd
; GFX7LESS-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s6, 0
; GFX7LESS-NEXT:    v_mbcnt_hi_u32_b32_e32 v4, s7, v0
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX7LESS-NEXT:    ; implicit-def: $vgpr0
; GFX7LESS-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX7LESS-NEXT:    s_cbranch_execz .LBB16_4
; GFX7LESS-NEXT:  ; %bb.1:
; GFX7LESS-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s11, s2, 3
; GFX7LESS-NEXT:    s_mov_b64 s[2:3], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_mul_i32 s6, s10, s6
; GFX7LESS-NEXT:    s_lshl_b32 s11, s11, 3
; GFX7LESS-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX7LESS-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX7LESS-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX7LESS-NEXT:    s_not_b32 s13, s12
; GFX7LESS-NEXT:    s_lshl_b32 s14, s6, s11
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s15
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_add_i32_e32 v0, vcc, s14, v1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_and_b32_e32 v2, s13, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB16_2
; GFX7LESS-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7LESS-NEXT:    v_bfe_u32 v0, v2, s11, 16
; GFX7LESS-NEXT:  .LBB16_4: ; %Flow
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7LESS-NEXT:    v_readfirstlane_b32 s4, v0
; GFX7LESS-NEXT:    s_and_b32 s5, s10, 0xffff
; GFX7LESS-NEXT:    v_mov_b32_e32 v0, s4
; GFX7LESS-NEXT:    v_mad_u32_u24 v0, s5, v4, v0
; GFX7LESS-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_add_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[6:7], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX8-NEXT:    ; implicit-def: $vgpr0
; GFX8-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB16_4
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_bcnt1_i32_b64 s4, s[6:7]
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mul_i32 s6, s10, s4
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s11, s2, 3
; GFX8-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX8-NEXT:    s_and_b32 s2, s6, 0xffff
; GFX8-NEXT:    s_not_b32 s13, s12
; GFX8-NEXT:    s_lshl_b32 s14, s2, s11
; GFX8-NEXT:    s_mov_b64 s[2:3], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s14, v1
; GFX8-NEXT:    v_and_b32_e32 v2, s13, v1
; GFX8-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_cbranch_execnz .LBB16_2
; GFX8-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX8-NEXT:  .LBB16_4: ; %Flow
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_mad_u16 v0, s10, v4, v0
; GFX8-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_add_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX9-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX9-NEXT:    ; implicit-def: $vgpr0
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX9-NEXT:    s_cbranch_execz .LBB16_4
; GFX9-NEXT:  ; %bb.1:
; GFX9-NEXT:    s_bcnt1_i32_b64 s4, s[6:7]
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mul_i32 s6, s10, s4
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s11, s2, 3
; GFX9-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX9-NEXT:    s_and_b32 s2, s6, 0xffff
; GFX9-NEXT:    s_not_b32 s13, s12
; GFX9-NEXT:    s_lshl_b32 s14, s2, s11
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_add_u32_e32 v0, s14, v1
; GFX9-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX9-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB16_2
; GFX9-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX9-NEXT:  .LBB16_4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_mad_legacy_u16 v0, s10, v4, v0
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_add_i16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[6:7], exec
; GFX1064-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1064-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1064-NEXT:    ; implicit-def: $vgpr0
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GFX1064-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GFX1064-NEXT:    s_cbranch_execz .LBB16_4
; GFX1064-NEXT:  ; %bb.1:
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX1064-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1064-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1064-NEXT:    s_mul_i32 s2, s10, s6
; GFX1064-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX1064-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX1064-NEXT:    s_not_b32 s13, s12
; GFX1064-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1064-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1064-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1064-NEXT:  .LBB16_4: ; %Flow
; GFX1064-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1064-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_add_i16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s6, exec_lo
; GFX1032-NEXT:    s_mov_b32 s10, 0
; GFX1032-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1032-NEXT:    ; implicit-def: $vgpr0
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v4
; GFX1032-NEXT:    s_and_saveexec_b32 s9, vcc_lo
; GFX1032-NEXT:    s_cbranch_execz .LBB16_4
; GFX1032-NEXT:  ; %bb.1:
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1032-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_mul_i32 s6, s8, s6
; GFX1032-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1032-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1032-NEXT:    s_not_b32 s11, s3
; GFX1032-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1032-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s10
; GFX1032-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1032-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:  .LBB16_4: ; %Flow
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1032-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_add_i16:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1164-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1164-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-TRUE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1164-TRUE16-NEXT:  ; %bb.1:
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-TRUE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1164-TRUE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX1164-TRUE16-NEXT:    s_not_b32 s13, s12
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1164-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-TRUE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1164-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-TRUE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1164-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1164-TRUE16-NEXT:  .LBB16_4: ; %Flow
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mad_u16 v0.l, s10, v4.l, s2
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_add_i16:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1164-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1164-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1164-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1164-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1164-FAKE16-NEXT:  ; %bb.1:
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-FAKE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1164-FAKE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX1164-FAKE16-NEXT:    s_not_b32 s13, s12
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1164-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-FAKE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1164-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX1164-FAKE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1164-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1164-FAKE16-NEXT:  .LBB16_4: ; %Flow
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_add_i16:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-TRUE16-NEXT:    s_mov_b32 s10, 0
; GFX1132-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1132-TRUE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1132-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-TRUE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1132-TRUE16-NEXT:  ; %bb.1:
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-TRUE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-TRUE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1132-TRUE16-NEXT:    s_not_b32 s11, s3
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-TRUE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1132-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1132-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-TRUE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1132-TRUE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1132-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-TRUE16-NEXT:  .LBB16_4: ; %Flow
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_mad_u16 v0.l, s8, v4.l, s2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_add_i16:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1132-FAKE16-NEXT:    s_mov_b32 s10, 0
; GFX1132-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1132-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1132-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1132-FAKE16-NEXT:  ; %bb.1:
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-FAKE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-FAKE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1132-FAKE16-NEXT:    s_not_b32 s11, s3
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-FAKE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1132-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1132-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-FAKE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1132-FAKE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1132-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-FAKE16-NEXT:  .LBB16_4: ; %Flow
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_add_i16:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1264-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1264-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1264-TRUE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1264-TRUE16-NEXT:  ; %bb.1:
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-TRUE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-TRUE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX1264-TRUE16-NEXT:    s_not_b32 s13, s12
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1264-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-TRUE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1264-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1264-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1264-TRUE16-NEXT:  .LBB16_4: ; %Flow
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mad_u16 v0.l, s10, v4.l, s2
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_add_i16:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[6:7], exec
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[8:9], exec
; GFX1264-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v0, s6, 0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mbcnt_hi_u32_b32 v4, s7, v0
; GFX1264-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1264-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1264-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1264-FAKE16-NEXT:  ; %bb.1:
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-FAKE16-NEXT:    s_bcnt1_i32_b64 s6, s[6:7]
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s11, s2, 3
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-FAKE16-NEXT:    s_mul_i32 s2, s10, s6
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s12, 0xffff, s11
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX1264-FAKE16-NEXT:    s_not_b32 s13, s12
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s14, s2, s11
; GFX1264-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-FAKE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1264-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s14, v1
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, s12, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_and_or_b32 v0, v1, s13, v0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1264-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s11, v2
; GFX1264-FAKE16-NEXT:  .LBB16_4: ; %Flow
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_mad_u16 v0, s10, v4, s2
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_add_i16:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-TRUE16-NEXT:    s_mov_b32 s10, 0
; GFX1232-TRUE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1232-TRUE16-NEXT:    ; implicit-def: $vgpr0_lo16
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1232-TRUE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1232-TRUE16-NEXT:  ; %bb.1:
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-TRUE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1232-TRUE16-NEXT:    s_not_b32 s11, s3
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-TRUE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1232-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1232-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-TRUE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1232-TRUE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1232-TRUE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-TRUE16-NEXT:  .LBB16_4: ; %Flow
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_mad_u16 v0.l, s8, v4.l, s2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_add_i16:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, exec_lo
; GFX1232-FAKE16-NEXT:    s_mov_b32 s10, 0
; GFX1232-FAKE16-NEXT:    v_mbcnt_lo_u32_b32 v4, s6, 0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s9, exec_lo
; GFX1232-FAKE16-NEXT:    ; implicit-def: $vgpr0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_cmpx_eq_u32_e32 0, v4
; GFX1232-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX1232-FAKE16-NEXT:  ; %bb.1:
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-FAKE16-NEXT:    s_bcnt1_i32_b32 s6, s6
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_mul_i32 s6, s8, s6
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1232-FAKE16-NEXT:    s_not_b32 s11, s3
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s12, s6, s2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-FAKE16-NEXT:  .LBB16_2: ; %atomicrmw.start
; GFX1232-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_add_nc_u32_e32 v0, s12, v1
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, s3, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_or_b32 v0, v1, s11, v0
; GFX1232-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-FAKE16-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s10
; GFX1232-FAKE16-NEXT:    s_cbranch_execnz .LBB16_2
; GFX1232-FAKE16-NEXT:  ; %bb.3: ; %atomicrmw.end
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-FAKE16-NEXT:  .LBB16_4: ; %Flow
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_mad_u16 v0, s8, v4, s2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw add ptr addrspace(1) %uniform.ptr, i16 %val monotonic, align 2
  store i16 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_xchg_i16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, i16 %val) {
; GFX7LESS-LABEL: uniform_xchg_i16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX7LESS-NEXT:    s_lshl_b32 s10, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s11, 0xffff, s10
; GFX7LESS-NEXT:    s_lshl_b32 s2, s3, s10
; GFX7LESS-NEXT:    s_not_b32 s3, s11
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s6
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_and_b32_e32 v0, s3, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, s2, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX7LESS-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_xchg_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s8, s2, 3
; GFX8-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX8-NEXT:    s_not_b32 s9, s2
; GFX8-NEXT:    s_and_b32 s2, s6, 0xffff
; GFX8-NEXT:    s_lshl_b32 s10, s2, s8
; GFX8-NEXT:    s_mov_b64 s[2:3], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_and_b32_e32 v0, s9, v1
; GFX8-NEXT:    v_or_b32_e32 v0, s10, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX8-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_xchg_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s8, s2, 3
; GFX9-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX9-NEXT:    s_not_b32 s9, s2
; GFX9-NEXT:    s_and_b32 s2, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s10, s2, s8
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_and_b32_e32 v0, s9, v1
; GFX9-NEXT:    v_or_b32_e32 v0, s10, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB17_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_xchg_i16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX1064-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1064-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1064-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1064-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1064-NEXT:    s_not_b32 s9, s2
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_xchg_i16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s9, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1032-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1032-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1032-NEXT:    s_not_b32 s3, s3
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: uniform_xchg_i16:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-NEXT:    s_mov_b32 s5, s3
; GFX1164-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1164-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1164-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1164-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1164-NEXT:    s_not_b32 s9, s2
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1164-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: uniform_xchg_i16:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s9, 0
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-NEXT:    s_mov_b32 s5, s3
; GFX1132-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1132-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1132-NEXT:    s_not_b32 s3, s3
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1132-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: uniform_xchg_i16:
; GFX1264:       ; %bb.0:
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-NEXT:    s_mov_b32 s5, s3
; GFX1264-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1264-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1264-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1264-NEXT:    s_lshl_b32 s10, s6, s8
; GFX1264-NEXT:    s_not_b32 s9, s2
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1264-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_and_or_b32 v0, v1, s9, s10
; GFX1264-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-NEXT:    s_wait_alu 0xfffe
; GFX1264-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1264-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: uniform_xchg_i16:
; GFX1232:       ; %bb.0:
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s9, 0
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-NEXT:    s_mov_b32 s5, s3
; GFX1232-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX1232-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-NEXT:    s_lshl_b32 s8, s6, s2
; GFX1232-NEXT:    s_not_b32 s3, s3
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX1232-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_and_or_b32 v0, v1, s3, s8
; GFX1232-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    s_cbranch_execnz .LBB17_1
; GFX1232-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
  %rmw = atomicrmw xchg ptr addrspace(1) %uniform.ptr, i16 %val monotonic, align 2
  store i16 %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_fadd_f16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, half %val) {
; GFX7LESS-LABEL: uniform_fadd_f16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v0, s6
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s10, s2, 3
; GFX7LESS-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7LESS-NEXT:    s_lshl_b32 s2, 0xffff, s10
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v4, v0
; GFX7LESS-NEXT:    s_not_b32 s2, s2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s3
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v1
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v0, s10, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_and_b32_e32 v2, s2, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB18_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX7LESS-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_fadd_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s11, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], 0
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s2, s2, 3
; GFX8-NEXT:    s_lshl_b32 s10, s2, 3
; GFX8-NEXT:    s_lshl_b32 s2, 0xffff, s10
; GFX8-NEXT:    s_not_b32 s2, s2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s10, v1
; GFX8-NEXT:    v_add_f16_e32 v0, s11, v0
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, s10, v0
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_cbranch_execnz .LBB18_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX8-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_fadd_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s11, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], 0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_lshl_b32 s10, s2, 3
; GFX9-NEXT:    s_lshl_b32 s2, 0xffff, s10
; GFX9-NEXT:    s_not_b32 s2, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s10, v1
; GFX9-NEXT:    v_add_f16_e32 v0, s11, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, s10, v0
; GFX9-NEXT:    v_and_or_b32 v0, v1, s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_cbranch_execnz .LBB18_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_fadd_f16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX1064-NEXT:    s_lshl_b32 s9, s2, 3
; GFX1064-NEXT:    s_lshl_b32 s2, 0xffff, s9
; GFX1064-NEXT:    s_not_b32 s10, s2
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s3
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s9, v1
; GFX1064-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1064-NEXT:    v_lshlrev_b32_sdwa v0, s9, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s10, v0
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s9, v2
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_fadd_f16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s9, 0
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1032-NEXT:    s_not_b32 s3, s3
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s6
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1032-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1032-NEXT:    v_lshlrev_b32_sdwa v0, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_fadd_f16:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s9, s2, 3
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s2, 0xffff, s9
; GFX1164-TRUE16-NEXT:    s_not_b32 s10, s2
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-TRUE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1164-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v1
; GFX1164-TRUE16-NEXT:    v_add_f16_e32 v0.l, s8, v0.l
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s9, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_and_or_b32 v0, v1, s10, v0
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1164-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v2
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_fadd_f16:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s9, s2, 3
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s2, 0xffff, s9
; GFX1164-FAKE16-NEXT:    s_not_b32 s10, s2
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-FAKE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1164-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v1
; GFX1164-FAKE16-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1164-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s9, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_and_or_b32 v0, v1, s10, v0
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1164-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v2
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_fadd_f16:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    s_mov_b32 s9, 0
; GFX1132-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-TRUE16-NEXT:    s_not_b32 s3, s3
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-TRUE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1132-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1132-TRUE16-NEXT:    v_add_f16_e32 v0.l, s8, v0.l
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX1132-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-TRUE16-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1132-TRUE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1132-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_fadd_f16:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    s_mov_b32 s9, 0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-FAKE16-NEXT:    s_not_b32 s3, s3
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, s6
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-FAKE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1132-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1132-FAKE16-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1132-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX1132-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-FAKE16-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1132-FAKE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1132-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_fadd_f16:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-TRUE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s9, s2, 3
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s2, 0xffff, s9
; GFX1264-TRUE16-NEXT:    s_not_b32 s10, s2
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-TRUE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1264-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v1
; GFX1264-TRUE16-NEXT:    v_add_f16_e32 v0.l, s8, v0.l
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s9, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_and_or_b32 v0, v1, s10, v0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1264-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v2
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_fadd_f16:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-FAKE16-NEXT:    s_load_b32 s3, s[4:5], 0x0
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s9, s2, 3
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s2, 0xffff, s9
; GFX1264-FAKE16-NEXT:    s_not_b32 s10, s2
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, s3
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-FAKE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1264-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v1
; GFX1264-FAKE16-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1264-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s9, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_and_or_b32 v0, v1, s10, v0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1264-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1264-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s9, v2
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_fadd_f16:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    s_mov_b32 s9, 0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-TRUE16-NEXT:    s_not_b32 s3, s3
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-TRUE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1232-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1232-TRUE16-NEXT:    v_add_f16_e32 v0.l, s8, v0.l
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX1232-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-TRUE16-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1232-TRUE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1232-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_fadd_f16:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    s_mov_b32 s9, 0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-FAKE16-NEXT:    s_not_b32 s3, s3
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, s6
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-FAKE16-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX1232-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1232-FAKE16-NEXT:    v_add_f16_e32 v0, s8, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX1232-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX1232-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-FAKE16-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1232-FAKE16-NEXT:    s_cbranch_execnz .LBB18_1
; GFX1232-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw fadd ptr addrspace(1) %uniform.ptr, half %val monotonic, align 2
  store half %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_fadd_bf16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, bfloat %val) {
; GFX7LESS-LABEL: uniform_fadd_bf16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_lshl_b32 s6, s6, 16
; GFX7LESS-NEXT:    s_and_b32 s4, s2, -4
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:    s_and_b32 s2, s2, 3
; GFX7LESS-NEXT:    s_lshl_b32 s10, s2, 3
; GFX7LESS-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX7LESS-NEXT:    v_mul_f32_e64 v0, 1.0, s6
; GFX7LESS-NEXT:    s_lshl_b32 s2, 0xffff, s10
; GFX7LESS-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX7LESS-NEXT:    s_not_b32 s2, s2
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, s3
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v1
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7LESS-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v0, s10, v0
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_and_b32_e32 v2, s2, v1
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, v0
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_mov_b32_e32 v1, v2
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB19_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX7LESS-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_fadd_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_and_b32 s4, s2, -4
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX8-NEXT:    s_and_b32 s3, s2, 3
; GFX8-NEXT:    s_lshl_b32 s10, s3, 3
; GFX8-NEXT:    s_lshl_b32 s3, 0xffff, s10
; GFX8-NEXT:    s_lshl_b32 s2, s6, 16
; GFX8-NEXT:    s_not_b32 s3, s3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_mov_b32_e32 v0, s10
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, s2, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; GFX8-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX8-NEXT:    v_and_b32_e32 v2, s3, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_cbranch_execnz .LBB19_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX8-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_fadd_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], 0
; GFX9-NEXT:    s_movk_i32 s11, 0x7fff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_and_b32 s4, s2, -4
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX9-NEXT:    s_and_b32 s3, s2, 3
; GFX9-NEXT:    s_lshl_b32 s10, s3, 3
; GFX9-NEXT:    s_lshl_b32 s3, 0xffff, s10
; GFX9-NEXT:    s_lshl_b32 s2, s6, 16
; GFX9-NEXT:    s_not_b32 s3, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshrrev_b32_sdwa v0, s10, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX9-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX9-NEXT:    v_add3_u32 v2, v2, v0, s11
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_lshlrev_b32_sdwa v0, s10, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_and_or_b32 v0, v1, s3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_cbranch_execnz .LBB19_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s10, v2
; GFX9-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_fadd_bf16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_and_b32 s4, s2, -4
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_and_b32 s2, s2, 3
; GFX1064-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1064-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1064-NEXT:    s_lshl_b32 s10, s6, 16
; GFX1064-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_not_b32 s9, s2
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s7
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_lshrrev_b32_sdwa v0, s8, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX1064-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1064-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1064-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1064-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1064-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1064-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX1064-NEXT:    v_lshlrev_b32_sdwa v0, s8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX1064-NEXT:    v_and_or_b32 v0, v1, s9, v0
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_fadd_bf16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s6, s[4:5], 0x34
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_and_b32 s4, s2, -4
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_and_b32 s2, s2, 3
; GFX1032-NEXT:    s_load_dword s7, s[4:5], 0x0
; GFX1032-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1032-NEXT:    s_lshl_b32 s9, s6, 16
; GFX1032-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_not_b32 s8, s3
; GFX1032-NEXT:    s_mov_b32 s3, 0
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s7
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_lshrrev_b32_sdwa v0, s2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX1032-NEXT:    v_add_f32_e32 v0, s9, v0
; GFX1032-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1032-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1032-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1032-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1032-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX1032-NEXT:    v_lshlrev_b32_sdwa v0, s2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX1032-NEXT:    v_and_or_b32 v0, v1, s8, v0
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s3, vcc_lo, s3
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1032-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_fadd_bf16:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s10, s6, 16
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1164-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-TRUE16-NEXT:    s_not_b32 s9, s2
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1164-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-TRUE16-NEXT:    .p2align 6
; GFX1164-TRUE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1164-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v1
; GFX1164-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1164-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1164-TRUE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1164-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1164-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX1164-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX1164-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s8, v2
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_and_or_b32 v0, v1, s9, v0
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1164-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_fadd_bf16:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1164-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1164-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s10, s6, 16
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1164-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-FAKE16-NEXT:    s_not_b32 s9, s2
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1164-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-FAKE16-NEXT:    .p2align 6
; GFX1164-FAKE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1164-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v1
; GFX1164-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1164-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1164-FAKE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1164-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1164-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX1164-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s8, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_and_or_b32 v0, v1, s9, v0
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1164-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1164-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_fadd_bf16:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s9, s6, 16
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-TRUE16-NEXT:    s_not_b32 s8, s3
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-TRUE16-NEXT:    .p2align 6
; GFX1132-TRUE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1132-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1132-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_add_f32_e32 v0, s9, v0
; GFX1132-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1132-TRUE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1132-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1132-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX1132-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX1132-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v2
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_and_or_b32 v0, v1, s8, v0
; GFX1132-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-TRUE16-NEXT:    s_or_b32 s3, vcc_lo, s3
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s3
; GFX1132-TRUE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1132-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_fadd_bf16:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1132-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s9, s6, 16
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-FAKE16-NEXT:    s_not_b32 s8, s3
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1132-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-FAKE16-NEXT:    .p2align 6
; GFX1132-FAKE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1132-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1132-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_add_f32_e32 v0, s9, v0
; GFX1132-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1132-FAKE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1132-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1132-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX1132-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_and_or_b32 v0, v1, s8, v0
; GFX1132-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-FAKE16-NEXT:    s_or_b32 s3, vcc_lo, s3
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s3
; GFX1132-FAKE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1132-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1132-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1132-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_fadd_bf16:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s10, s6, 16
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1264-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-TRUE16-NEXT:    s_not_b32 s9, s2
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1264-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-TRUE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1264-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v1
; GFX1264-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1264-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1264-TRUE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1264-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1264-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX1264-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX1264-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s8, v2
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_and_or_b32 v0, v1, s9, v0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-TRUE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1264-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_fadd_bf16:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1264-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1264-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s8, s2, 3
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s10, s6, 16
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s2, 0xffff, s8
; GFX1264-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-FAKE16-NEXT:    s_not_b32 s9, s2
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1264-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-FAKE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1264-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v1
; GFX1264-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1264-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1264-FAKE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1264-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX1264-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX1264-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s8, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_and_or_b32 v0, v1, s9, v0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1264-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s8, v2
; GFX1264-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_fadd_bf16:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-TRUE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s9, s6, 16
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-TRUE16-NEXT:    s_not_b32 s8, s3
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-TRUE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1232-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1232-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_add_f32_e32 v0, s9, v0
; GFX1232-TRUE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1232-TRUE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1232-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1232-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX1232-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX1232-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v2
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_and_or_b32 v0, v1, s8, v0
; GFX1232-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-TRUE16-NEXT:    s_or_b32 s3, vcc_lo, s3
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s3
; GFX1232-TRUE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1232-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1232-TRUE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_fadd_bf16:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s6, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_and_b32 s4, s2, -4
; GFX1232-FAKE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-FAKE16-NEXT:    s_and_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_load_b32 s7, s[4:5], 0x0
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s2, s2, 3
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s9, s6, 16
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s3, 0xffff, s2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-FAKE16-NEXT:    s_not_b32 s8, s3
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, s7
; GFX1232-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-FAKE16-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX1232-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v1
; GFX1232-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_add_f32_e32 v0, s9, v0
; GFX1232-FAKE16-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX1232-FAKE16-NEXT:    v_or_b32_e32 v3, 0x400000, v0
; GFX1232-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_add3_u32 v2, v2, v0, 0x7fff
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX1232-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX1232-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, s2, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_and_or_b32 v0, v1, s8, v0
; GFX1232-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-FAKE16-NEXT:    s_or_b32 s3, vcc_lo, s3
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s3
; GFX1232-FAKE16-NEXT:    s_cbranch_execnz .LBB19_1
; GFX1232-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX1232-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, s2, v2
; GFX1232-FAKE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-FAKE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b16 v0, off, s[0:3], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw fadd ptr addrspace(1) %uniform.ptr, bfloat %val monotonic, align 2
  store bfloat %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_fadd_v2f16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, <2 x half> %val) {
; GFX7LESS-LABEL: uniform_fadd_v2f16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_lshr_b32 s4, s6, 16
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v0, s6
; GFX7LESS-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v1, s4
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v2, s5
; GFX7LESS-NEXT:    s_lshr_b32 s4, s5, 16
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v3, s4
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s4, s2
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7LESS-NEXT:    v_add_f32_e32 v4, v4, v1
; GFX7LESS-NEXT:    v_add_f32_e32 v5, v5, v0
; GFX7LESS-NEXT:    v_or_b32_e32 v3, v2, v3
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v2, v4
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v4, v5
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7LESS-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[4:5], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v3, 16, v4
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v2, v4
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB20_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7LESS-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX7LESS-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_fadd_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[8:9], 0
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX8-NEXT:    s_lshr_b32 s11, s10, 16
; GFX8-NEXT:    s_mov_b32 s4, s2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_mov_b32 s5, s3
; GFX8-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_mov_b32_e32 v0, s11
; GFX8-NEXT:    v_add_f16_e32 v2, s10, v1
; GFX8-NEXT:    v_add_f16_sdwa v0, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_cbranch_execnz .LBB20_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX8-NEXT:    s_mov_b32 s3, 0xf000
; GFX8-NEXT:    s_mov_b32 s2, -1
; GFX8-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_fadd_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[8:9], 0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s5, s[2:3], 0x0
; GFX9-NEXT:    s_mov_b32 s4, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    s_mov_b32 s5, s3
; GFX9-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_pk_add_f16 v0, v1, s10
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_cbranch_execnz .LBB20_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-NEXT:    s_mov_b32 s2, -1
; GFX9-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_fadd_v2f16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s10, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[8:9], 0
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX1064-NEXT:    s_mov_b32 s5, s3
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s4
; GFX1064-NEXT:    s_mov_b32 s4, s2
; GFX1064-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_pk_add_f16 v0, v1, s10
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1064-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s2, -1
; GFX1064-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_fadd_v2f16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s8, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s9, 0
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX1032-NEXT:    s_mov_b32 s5, s3
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-NEXT:    s_mov_b32 s4, s2
; GFX1032-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_pk_add_f16 v0, v1, s8
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1032-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s2, -1
; GFX1032-NEXT:    buffer_store_dword v2, off, s[0:3], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-LABEL: uniform_fadd_v2f16:
; GFX1164:       ; %bb.0:
; GFX1164-NEXT:    s_clause 0x1
; GFX1164-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1164-NEXT:    s_mov_b64 s[8:9], 0
; GFX1164-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s6, -1
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    s_load_b32 s4, s[2:3], 0x0
; GFX1164-NEXT:    s_mov_b32 s5, s3
; GFX1164-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-NEXT:    v_mov_b32_e32 v1, s4
; GFX1164-NEXT:    s_mov_b32 s4, s2
; GFX1164-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1164-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-NEXT:    v_pk_add_f16 v0, v1, s10
; GFX1164-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX1164-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-NEXT:    s_and_not1_b64 exec, exec, s[8:9]
; GFX1164-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1164-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-NEXT:    s_mov_b32 s2, -1
; GFX1164-NEXT:    buffer_store_b32 v2, off, s[0:3], 0
; GFX1164-NEXT:    s_endpgm
;
; GFX1132-LABEL: uniform_fadd_v2f16:
; GFX1132:       ; %bb.0:
; GFX1132-NEXT:    s_clause 0x1
; GFX1132-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1132-NEXT:    s_mov_b32 s9, 0
; GFX1132-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s6, -1
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    s_load_b32 s4, s[2:3], 0x0
; GFX1132-NEXT:    s_mov_b32 s5, s3
; GFX1132-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-NEXT:    v_mov_b32_e32 v1, s4
; GFX1132-NEXT:    s_mov_b32 s4, s2
; GFX1132-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1132-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-NEXT:    v_pk_add_f16 v0, v1, s8
; GFX1132-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1132-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1132-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1132-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-NEXT:    s_mov_b32 s2, -1
; GFX1132-NEXT:    buffer_store_b32 v2, off, s[0:3], 0
; GFX1132-NEXT:    s_endpgm
;
; GFX1264-LABEL: uniform_fadd_v2f16:
; GFX1264:       ; %bb.0:
; GFX1264-NEXT:    s_clause 0x1
; GFX1264-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-NEXT:    s_load_b32 s10, s[4:5], 0x34
; GFX1264-NEXT:    s_mov_b64 s[8:9], 0
; GFX1264-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s6, -1
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    s_load_b32 s4, s[2:3], 0x0
; GFX1264-NEXT:    s_mov_b32 s5, s3
; GFX1264-NEXT:    s_wait_kmcnt 0x0
; GFX1264-NEXT:    v_mov_b32_e32 v1, s4
; GFX1264-NEXT:    s_mov_b32 s4, s2
; GFX1264-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1264-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-NEXT:    v_pk_add_f16 v0, v1, s10
; GFX1264-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-NEXT:    s_wait_loadcnt 0x0
; GFX1264-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX1264-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-NEXT:    s_and_not1_b64 exec, exec, s[8:9]
; GFX1264-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1264-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-NEXT:    s_mov_b32 s2, -1
; GFX1264-NEXT:    buffer_store_b32 v2, off, s[0:3], null
; GFX1264-NEXT:    s_endpgm
;
; GFX1232-LABEL: uniform_fadd_v2f16:
; GFX1232:       ; %bb.0:
; GFX1232-NEXT:    s_clause 0x1
; GFX1232-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-NEXT:    s_load_b32 s8, s[4:5], 0x34
; GFX1232-NEXT:    s_mov_b32 s9, 0
; GFX1232-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s6, -1
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    s_load_b32 s4, s[2:3], 0x0
; GFX1232-NEXT:    s_mov_b32 s5, s3
; GFX1232-NEXT:    s_wait_kmcnt 0x0
; GFX1232-NEXT:    v_mov_b32_e32 v1, s4
; GFX1232-NEXT:    s_mov_b32 s4, s2
; GFX1232-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX1232-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-NEXT:    v_pk_add_f16 v0, v1, s8
; GFX1232-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-NEXT:    s_wait_loadcnt 0x0
; GFX1232-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-NEXT:    s_or_b32 s9, vcc_lo, s9
; GFX1232-NEXT:    s_wait_alu 0xfffe
; GFX1232-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    s_cbranch_execnz .LBB20_1
; GFX1232-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-NEXT:    s_or_b32 exec_lo, exec_lo, s9
; GFX1232-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-NEXT:    s_mov_b32 s2, -1
; GFX1232-NEXT:    buffer_store_b32 v2, off, s[0:3], null
; GFX1232-NEXT:    s_endpgm
  %rmw = atomicrmw fadd ptr addrspace(1) %uniform.ptr, <2 x half> %val monotonic, align 4
  store <2 x half> %rmw, ptr addrspace(1) %result
  ret void
}

define amdgpu_kernel void @uniform_fadd_v2bf16(ptr addrspace(1) %result, ptr addrspace(1) %uniform.ptr, <2 x bfloat> %val) {
; GFX7LESS-LABEL: uniform_fadd_v2bf16:
; GFX7LESS:       ; %bb.0:
; GFX7LESS-NEXT:    s_load_dword s6, s[4:5], 0xd
; GFX7LESS-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7LESS-NEXT:    s_mov_b64 s[8:9], 0
; GFX7LESS-NEXT:    s_mov_b32 s7, 0xf000
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s6, 0xffff0000
; GFX7LESS-NEXT:    s_lshl_b32 s5, s6, 16
; GFX7LESS-NEXT:    s_load_dword s6, s[2:3], 0x0
; GFX7LESS-NEXT:    v_mul_f32_e64 v0, 1.0, s5
; GFX7LESS-NEXT:    v_mul_f32_e64 v1, 1.0, s4
; GFX7LESS-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7LESS-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7LESS-NEXT:    s_and_b32 s4, s6, 0xffff0000
; GFX7LESS-NEXT:    s_lshl_b32 s5, s6, 16
; GFX7LESS-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7LESS-NEXT:    v_mov_b32_e32 v3, s5
; GFX7LESS-NEXT:    v_mov_b32_e32 v2, s4
; GFX7LESS-NEXT:    s_mov_b32 s6, -1
; GFX7LESS-NEXT:    s_mov_b32 s4, s2
; GFX7LESS-NEXT:    s_mov_b32 s5, s3
; GFX7LESS-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX7LESS-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7LESS-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7LESS-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7LESS-NEXT:    s_waitcnt expcnt(0)
; GFX7LESS-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX7LESS-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7LESS-NEXT:    v_add_f32_e32 v4, v4, v0
; GFX7LESS-NEXT:    v_add_f32_e32 v5, v5, v1
; GFX7LESS-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v2, 16, v5
; GFX7LESS-NEXT:    v_alignbit_b32 v2, v2, v4, 16
; GFX7LESS-NEXT:    v_mov_b32_e32 v5, v3
; GFX7LESS-NEXT:    v_mov_b32_e32 v4, v2
; GFX7LESS-NEXT:    buffer_atomic_cmpswap v[4:5], off, s[4:7], 0 glc
; GFX7LESS-NEXT:    s_waitcnt vmcnt(0)
; GFX7LESS-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7LESS-NEXT:    v_and_b32_e32 v2, 0xffff0000, v4
; GFX7LESS-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7LESS-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX7LESS-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_cbranch_execnz .LBB21_1
; GFX7LESS-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7LESS-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7LESS-NEXT:    s_mov_b32 s3, 0xf000
; GFX7LESS-NEXT:    s_mov_b32 s2, -1
; GFX7LESS-NEXT:    v_mul_f32_e32 v0, 1.0, v2
; GFX7LESS-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7LESS-NEXT:    v_mul_f32_e32 v1, 1.0, v3
; GFX7LESS-NEXT:    v_alignbit_b32 v0, v0, v1, 16
; GFX7LESS-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7LESS-NEXT:    s_endpgm
;
; GFX8-LABEL: uniform_fadd_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x34
; GFX8-NEXT:    s_mov_b64 s[2:3], 0
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s1, s[10:11], 0x0
; GFX8-NEXT:    s_lshl_b32 s12, s0, 16
; GFX8-NEXT:    s_and_b32 s13, s0, 0xffff0000
; GFX8-NEXT:    s_mov_b32 s4, s10
; GFX8-NEXT:    s_mov_b32 s5, s11
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX8-NEXT:    v_add_f32_e32 v0, s12, v0
; GFX8-NEXT:    v_add_f32_e32 v2, s13, v2
; GFX8-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v0
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v2
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[0:1], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v3, v4, s[0:1]
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; GFX8-NEXT:    v_mov_b32_e32 v3, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, v0
; GFX8-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX8-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_cbranch_execnz .LBB21_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_mov_b32 s11, 0xf000
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: uniform_fadd_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x34
; GFX9-NEXT:    s_mov_b64 s[2:3], 0
; GFX9-NEXT:    s_movk_i32 s12, 0x7fff
; GFX9-NEXT:    s_mov_b32 s13, 0x7060302
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s1, s[10:11], 0x0
; GFX9-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-NEXT:    s_mov_b32 s6, -1
; GFX9-NEXT:    s_lshl_b32 s14, s0, 16
; GFX9-NEXT:    s_and_b32 s15, s0, 0xffff0000
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_mov_b32 s4, s10
; GFX9-NEXT:    s_mov_b32 s5, s11
; GFX9-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX9-NEXT:    v_add_f32_e32 v0, s14, v0
; GFX9-NEXT:    v_add_f32_e32 v2, s15, v2
; GFX9-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX9-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v0
; GFX9-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX9-NEXT:    v_add3_u32 v3, v3, v0, s12
; GFX9-NEXT:    v_add3_u32 v5, v5, v2, s12
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cmp_u_f32_e64 s[0:1], v0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v4, s[0:1]
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX9-NEXT:    v_perm_b32 v0, v2, v0, s13
; GFX9-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX9-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_cbranch_execnz .LBB21_1
; GFX9-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX9-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX9-NEXT:    s_mov_b32 s11, 0xf000
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; GFX9-NEXT:    s_endpgm
;
; GFX1064-LABEL: uniform_fadd_v2bf16:
; GFX1064:       ; %bb.0:
; GFX1064-NEXT:    s_clause 0x1
; GFX1064-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX1064-NEXT:    s_load_dword s0, s[4:5], 0x34
; GFX1064-NEXT:    s_mov_b64 s[2:3], 0
; GFX1064-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s6, -1
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    s_load_dword s1, s[10:11], 0x0
; GFX1064-NEXT:    s_lshl_b32 s12, s0, 16
; GFX1064-NEXT:    s_and_b32 s13, s0, 0xffff0000
; GFX1064-NEXT:    s_mov_b32 s4, s10
; GFX1064-NEXT:    s_mov_b32 s5, s11
; GFX1064-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1064-NEXT:    v_mov_b32_e32 v1, s1
; GFX1064-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1064-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1064-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1064-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1064-NEXT:    v_add_f32_e32 v0, s12, v0
; GFX1064-NEXT:    v_add_f32_e32 v2, s13, v2
; GFX1064-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1064-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1064-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1064-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1064-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX1064-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1064-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1064-NEXT:    v_cmp_u_f32_e64 s[0:1], v0, v0
; GFX1064-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX1064-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s[0:1]
; GFX1064-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1064-NEXT:    v_mov_b32_e32 v3, v1
; GFX1064-NEXT:    v_mov_b32_e32 v2, v0
; GFX1064-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1064-NEXT:    s_waitcnt vmcnt(0)
; GFX1064-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1064-NEXT:    v_mov_b32_e32 v1, v2
; GFX1064-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1064-NEXT:    s_andn2_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1064-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1064-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1064-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1064-NEXT:    s_mov_b32 s10, -1
; GFX1064-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; GFX1064-NEXT:    s_endpgm
;
; GFX1032-LABEL: uniform_fadd_v2bf16:
; GFX1032:       ; %bb.0:
; GFX1032-NEXT:    s_clause 0x1
; GFX1032-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x24
; GFX1032-NEXT:    s_load_dword s0, s[4:5], 0x34
; GFX1032-NEXT:    s_mov_b32 s1, 0
; GFX1032-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s6, -1
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    s_load_dword s4, s[10:11], 0x0
; GFX1032-NEXT:    s_lshl_b32 s2, s0, 16
; GFX1032-NEXT:    s_and_b32 s3, s0, 0xffff0000
; GFX1032-NEXT:    s_mov_b32 s5, s11
; GFX1032-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1032-NEXT:    v_mov_b32_e32 v1, s4
; GFX1032-NEXT:    s_mov_b32 s4, s10
; GFX1032-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1032-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1032-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1032-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1032-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX1032-NEXT:    v_add_f32_e32 v2, s3, v2
; GFX1032-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1032-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1032-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1032-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1032-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX1032-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1032-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1032-NEXT:    v_cmp_u_f32_e64 s0, v0, v0
; GFX1032-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc_lo
; GFX1032-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s0
; GFX1032-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1032-NEXT:    v_mov_b32_e32 v3, v1
; GFX1032-NEXT:    v_mov_b32_e32 v2, v0
; GFX1032-NEXT:    buffer_atomic_cmpswap v[2:3], off, s[4:7], 0 glc
; GFX1032-NEXT:    s_waitcnt vmcnt(0)
; GFX1032-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1032-NEXT:    v_mov_b32_e32 v1, v2
; GFX1032-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX1032-NEXT:    s_andn2_b32 exec_lo, exec_lo, s1
; GFX1032-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1032-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1032-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1032-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1032-NEXT:    s_mov_b32 s10, -1
; GFX1032-NEXT:    buffer_store_dword v2, off, s[8:11], 0
; GFX1032-NEXT:    s_endpgm
;
; GFX1164-TRUE16-LABEL: uniform_fadd_v2bf16:
; GFX1164-TRUE16:       ; %bb.0:
; GFX1164-TRUE16-NEXT:    s_clause 0x1
; GFX1164-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1164-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1164-TRUE16-NEXT:    s_mov_b64 s[8:9], 0
; GFX1164-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    s_load_b32 s5, s[2:3], 0x0
; GFX1164-TRUE16-NEXT:    s_and_b32 s10, s4, 0xffff0000
; GFX1164-TRUE16-NEXT:    s_lshl_b32 s11, s4, 16
; GFX1164-TRUE16-NEXT:    s_mov_b32 s4, s2
; GFX1164-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, s5
; GFX1164-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1164-TRUE16-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-TRUE16-NEXT:    .p2align 6
; GFX1164-TRUE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1164-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1164-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1164-TRUE16-NEXT:    v_add_f32_e32 v0, s11, v0
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_add_f32_e32 v2, s10, v2
; GFX1164-TRUE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1164-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1164-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1164-TRUE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1164-TRUE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1164-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc
; GFX1164-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX1164-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1164-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX1164-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-TRUE16-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX1164-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[8:9]
; GFX1164-TRUE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1164-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-TRUE16-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1164-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1164-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1164-TRUE16-NEXT:    buffer_store_b32 v2, off, s[0:3], 0
; GFX1164-TRUE16-NEXT:    s_endpgm
;
; GFX1164-FAKE16-LABEL: uniform_fadd_v2bf16:
; GFX1164-FAKE16:       ; %bb.0:
; GFX1164-FAKE16-NEXT:    s_clause 0x1
; GFX1164-FAKE16-NEXT:    s_load_b128 s[8:11], s[4:5], 0x24
; GFX1164-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x34
; GFX1164-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1164-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    s_load_b32 s1, s[10:11], 0x0
; GFX1164-FAKE16-NEXT:    s_lshl_b32 s12, s0, 16
; GFX1164-FAKE16-NEXT:    s_and_b32 s13, s0, 0xffff0000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s4, s10
; GFX1164-FAKE16-NEXT:    s_mov_b32 s5, s11
; GFX1164-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, s1
; GFX1164-FAKE16-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1164-FAKE16-NEXT:    .p2align 6
; GFX1164-FAKE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1164-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1164-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1164-FAKE16-NEXT:    v_add_f32_e32 v0, s12, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_add_f32_e32 v2, s13, v2
; GFX1164-FAKE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1164-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1164-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1164-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX1164-FAKE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1164-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1164-FAKE16-NEXT:    v_cmp_u_f32_e64 s[0:1], v0, v0
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX1164-FAKE16-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s[0:1]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1164-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1164-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1164-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1164-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1164-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1164-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1164-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1164-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1164-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1164-FAKE16-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1164-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1164-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1164-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1164-FAKE16-NEXT:    buffer_store_b32 v2, off, s[8:11], 0
; GFX1164-FAKE16-NEXT:    s_endpgm
;
; GFX1132-TRUE16-LABEL: uniform_fadd_v2bf16:
; GFX1132-TRUE16:       ; %bb.0:
; GFX1132-TRUE16-NEXT:    s_clause 0x1
; GFX1132-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1132-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1132-TRUE16-NEXT:    s_mov_b32 s8, 0
; GFX1132-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    s_load_b32 s5, s[2:3], 0x0
; GFX1132-TRUE16-NEXT:    s_and_b32 s9, s4, 0xffff0000
; GFX1132-TRUE16-NEXT:    s_lshl_b32 s10, s4, 16
; GFX1132-TRUE16-NEXT:    s_mov_b32 s4, s2
; GFX1132-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, s5
; GFX1132-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1132-TRUE16-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-TRUE16-NEXT:    .p2align 6
; GFX1132-TRUE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1132-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1132-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1132-TRUE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-TRUE16-NEXT:    v_add_f32_e32 v2, s9, v2
; GFX1132-TRUE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1132-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1132-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1132-TRUE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1132-TRUE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1132-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc_lo
; GFX1132-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX1132-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc_lo
; GFX1132-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1132-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-TRUE16-NEXT:    s_or_b32 s8, vcc_lo, s8
; GFX1132-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s8
; GFX1132-TRUE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1132-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-TRUE16-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1132-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1132-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1132-TRUE16-NEXT:    buffer_store_b32 v2, off, s[0:3], 0
; GFX1132-TRUE16-NEXT:    s_endpgm
;
; GFX1132-FAKE16-LABEL: uniform_fadd_v2bf16:
; GFX1132-FAKE16:       ; %bb.0:
; GFX1132-FAKE16-NEXT:    s_clause 0x1
; GFX1132-FAKE16-NEXT:    s_load_b128 s[8:11], s[4:5], 0x24
; GFX1132-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x34
; GFX1132-FAKE16-NEXT:    s_mov_b32 s1, 0
; GFX1132-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1132-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    s_load_b32 s4, s[10:11], 0x0
; GFX1132-FAKE16-NEXT:    s_lshl_b32 s2, s0, 16
; GFX1132-FAKE16-NEXT:    s_and_b32 s3, s0, 0xffff0000
; GFX1132-FAKE16-NEXT:    s_mov_b32 s5, s11
; GFX1132-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, s4
; GFX1132-FAKE16-NEXT:    s_mov_b32 s4, s10
; GFX1132-FAKE16-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX1132-FAKE16-NEXT:    .p2align 6
; GFX1132-FAKE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1132-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1132-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1132-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1132-FAKE16-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-FAKE16-NEXT:    v_add_f32_e32 v2, s3, v2
; GFX1132-FAKE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1132-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1132-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1132-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1132-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX1132-FAKE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1132-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1132-FAKE16-NEXT:    v_cmp_u_f32_e64 s0, v0, v0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1132-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc_lo
; GFX1132-FAKE16-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s0
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1132-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1132-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1132-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], 0 glc
; GFX1132-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX1132-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1132-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1132-FAKE16-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX1132-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1132-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX1132-FAKE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1132-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1132-FAKE16-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX1132-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1132-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1132-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1132-FAKE16-NEXT:    buffer_store_b32 v2, off, s[8:11], 0
; GFX1132-FAKE16-NEXT:    s_endpgm
;
; GFX1264-TRUE16-LABEL: uniform_fadd_v2bf16:
; GFX1264-TRUE16:       ; %bb.0:
; GFX1264-TRUE16-NEXT:    s_clause 0x1
; GFX1264-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1264-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1264-TRUE16-NEXT:    s_mov_b64 s[8:9], 0
; GFX1264-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    s_load_b32 s5, s[2:3], 0x0
; GFX1264-TRUE16-NEXT:    s_and_b32 s10, s4, 0xffff0000
; GFX1264-TRUE16-NEXT:    s_lshl_b32 s11, s4, 16
; GFX1264-TRUE16-NEXT:    s_mov_b32 s4, s2
; GFX1264-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, s5
; GFX1264-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1264-TRUE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1264-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1264-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1264-TRUE16-NEXT:    v_add_f32_e32 v0, s11, v0
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_add_f32_e32 v2, s10, v2
; GFX1264-TRUE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1264-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1264-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX1264-TRUE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1264-TRUE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1264-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc
; GFX1264-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX1264-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX1264-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1264-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-TRUE16-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX1264-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-TRUE16-NEXT:    s_and_not1_b64 exec, exec, s[8:9]
; GFX1264-TRUE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1264-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-TRUE16-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX1264-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1264-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1264-TRUE16-NEXT:    buffer_store_b32 v2, off, s[0:3], null
; GFX1264-TRUE16-NEXT:    s_endpgm
;
; GFX1264-FAKE16-LABEL: uniform_fadd_v2bf16:
; GFX1264-FAKE16:       ; %bb.0:
; GFX1264-FAKE16-NEXT:    s_clause 0x1
; GFX1264-FAKE16-NEXT:    s_load_b128 s[8:11], s[4:5], 0x24
; GFX1264-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x34
; GFX1264-FAKE16-NEXT:    s_mov_b64 s[2:3], 0
; GFX1264-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    s_load_b32 s1, s[10:11], 0x0
; GFX1264-FAKE16-NEXT:    s_lshl_b32 s12, s0, 16
; GFX1264-FAKE16-NEXT:    s_and_b32 s13, s0, 0xffff0000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s4, s10
; GFX1264-FAKE16-NEXT:    s_mov_b32 s5, s11
; GFX1264-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, s1
; GFX1264-FAKE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1264-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1264-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1264-FAKE16-NEXT:    v_add_f32_e32 v0, s12, v0
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_add_f32_e32 v2, s13, v2
; GFX1264-FAKE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1264-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1264-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1264-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX1264-FAKE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1264-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1264-FAKE16-NEXT:    v_cmp_u_f32_e64 s[0:1], v0, v0
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc
; GFX1264-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1264-FAKE16-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s[0:1]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1264-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v3, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v2, v0
; GFX1264-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1264-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1264-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v1
; GFX1264-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1264-FAKE16-NEXT:    s_or_b64 s[2:3], vcc, s[2:3]
; GFX1264-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1264-FAKE16-NEXT:    s_and_not1_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1264-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1264-FAKE16-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX1264-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1264-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1264-FAKE16-NEXT:    buffer_store_b32 v2, off, s[8:11], null
; GFX1264-FAKE16-NEXT:    s_endpgm
;
; GFX1232-TRUE16-LABEL: uniform_fadd_v2bf16:
; GFX1232-TRUE16:       ; %bb.0:
; GFX1232-TRUE16-NEXT:    s_clause 0x1
; GFX1232-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX1232-TRUE16-NEXT:    s_load_b32 s4, s[4:5], 0x34
; GFX1232-TRUE16-NEXT:    s_mov_b32 s8, 0
; GFX1232-TRUE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-TRUE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    s_load_b32 s5, s[2:3], 0x0
; GFX1232-TRUE16-NEXT:    s_and_b32 s9, s4, 0xffff0000
; GFX1232-TRUE16-NEXT:    s_lshl_b32 s10, s4, 16
; GFX1232-TRUE16-NEXT:    s_mov_b32 s4, s2
; GFX1232-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, s5
; GFX1232-TRUE16-NEXT:    s_mov_b32 s5, s3
; GFX1232-TRUE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1232-TRUE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1232-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1232-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1232-TRUE16-NEXT:    v_add_f32_e32 v0, s10, v0
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232-TRUE16-NEXT:    v_add_f32_e32 v2, s9, v2
; GFX1232-TRUE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1232-TRUE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1232-TRUE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1232-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX1232-TRUE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1232-TRUE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1232-TRUE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1232-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc_lo
; GFX1232-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX1232-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v0.h
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX1232-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc_lo
; GFX1232-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v0, v2
; GFX1232-TRUE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-TRUE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-TRUE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-TRUE16-NEXT:    s_or_b32 s8, vcc_lo, s8
; GFX1232-TRUE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-TRUE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s8
; GFX1232-TRUE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1232-TRUE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX1232-TRUE16-NEXT:    s_mov_b32 s3, 0x31016000
; GFX1232-TRUE16-NEXT:    s_mov_b32 s2, -1
; GFX1232-TRUE16-NEXT:    buffer_store_b32 v2, off, s[0:3], null
; GFX1232-TRUE16-NEXT:    s_endpgm
;
; GFX1232-FAKE16-LABEL: uniform_fadd_v2bf16:
; GFX1232-FAKE16:       ; %bb.0:
; GFX1232-FAKE16-NEXT:    s_clause 0x1
; GFX1232-FAKE16-NEXT:    s_load_b128 s[8:11], s[4:5], 0x24
; GFX1232-FAKE16-NEXT:    s_load_b32 s0, s[4:5], 0x34
; GFX1232-FAKE16-NEXT:    s_mov_b32 s1, 0
; GFX1232-FAKE16-NEXT:    s_mov_b32 s7, 0x31016000
; GFX1232-FAKE16-NEXT:    s_mov_b32 s6, -1
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    s_load_b32 s4, s[10:11], 0x0
; GFX1232-FAKE16-NEXT:    s_lshl_b32 s2, s0, 16
; GFX1232-FAKE16-NEXT:    s_and_b32 s3, s0, 0xffff0000
; GFX1232-FAKE16-NEXT:    s_mov_b32 s5, s11
; GFX1232-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, s4
; GFX1232-FAKE16-NEXT:    s_mov_b32 s4, s10
; GFX1232-FAKE16-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX1232-FAKE16-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1232-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 16, v1
; GFX1232-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v1
; GFX1232-FAKE16-NEXT:    v_add_f32_e32 v0, s2, v0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1232-FAKE16-NEXT:    v_add_f32_e32 v2, s3, v2
; GFX1232-FAKE16-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1232-FAKE16-NEXT:    v_bfe_u32 v4, v2, 16, 1
; GFX1232-FAKE16-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX1232-FAKE16-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX1232-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX1232-FAKE16-NEXT:    v_add3_u32 v3, v3, v0, 0x7fff
; GFX1232-FAKE16-NEXT:    v_add3_u32 v4, v4, v2, 0x7fff
; GFX1232-FAKE16-NEXT:    v_cmp_u_f32_e64 s0, v0, v0
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX1232-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v4, v6, vcc_lo
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX1232-FAKE16-NEXT:    v_cndmask_b32_e64 v0, v3, v5, s0
; GFX1232-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX1232-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x7060302
; GFX1232-FAKE16-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX1232-FAKE16-NEXT:    buffer_atomic_cmpswap_b32 v[2:3], off, s[4:7], null th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX1232-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX1232-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v1
; GFX1232-FAKE16-NEXT:    v_mov_b32_e32 v1, v2
; GFX1232-FAKE16-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX1232-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX1232-FAKE16-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX1232-FAKE16-NEXT:    s_cbranch_execnz .LBB21_1
; GFX1232-FAKE16-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX1232-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX1232-FAKE16-NEXT:    s_mov_b32 s11, 0x31016000
; GFX1232-FAKE16-NEXT:    s_mov_b32 s10, -1
; GFX1232-FAKE16-NEXT:    buffer_store_b32 v2, off, s[8:11], null
; GFX1232-FAKE16-NEXT:    s_endpgm
  %rmw = atomicrmw fadd ptr addrspace(1) %uniform.ptr, <2 x bfloat> %val monotonic, align 4
  store <2 x bfloat> %rmw, ptr addrspace(1) %result
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX1132_DPP-FAKE16: {{.*}}
; GFX1132_DPP-TRUE16: {{.*}}
; GFX1132_ITERATIVE-FAKE16: {{.*}}
; GFX1132_ITERATIVE-TRUE16: {{.*}}
; GFX1164_DPP-FAKE16: {{.*}}
; GFX1164_DPP-TRUE16: {{.*}}
; GFX1164_ITERATIVE-FAKE16: {{.*}}
; GFX1164_ITERATIVE-TRUE16: {{.*}}
; GFX1232_DPP-FAKE16: {{.*}}
; GFX1232_DPP-TRUE16: {{.*}}
; GFX1232_ITERATIVE-FAKE16: {{.*}}
; GFX1232_ITERATIVE-TRUE16: {{.*}}
; GFX1264_DPP-FAKE16: {{.*}}
; GFX1264_DPP-TRUE16: {{.*}}
; GFX1264_ITERATIVE-FAKE16: {{.*}}
; GFX1264_ITERATIVE-TRUE16: {{.*}}
