; RUN: opt < %s -S -passes=loop-unroll -unroll-count=2 | FileCheck %s
; Checks that "llvm.loop.unroll.disable" is set when
; unroll with count set by user has been applied.
;
; CHECK-LABEL: @foo(
; CHECK: llvm.loop.unroll.disable

define void @foo(ptr nocapture %a) {
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %indvars.iv = phi i64 [ 0, %entry ], [ %indvars.iv.next, %for.body ]
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %indvars.iv
  %0 = load i32, ptr %arrayidx, align 4
  %inc = add nsw i32 %0, 1
  store i32 %inc, ptr %arrayidx, align 4
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv.next, 64
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

