; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals none --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=VF2 %s
; RUN: opt -p loop-vectorize -force-vector-width=4 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=VF4 %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "arm64-apple-macosx"

define void @load_store_interleave_group_tc_2(ptr noalias %data) {
; VF2-LABEL: define void @load_store_interleave_group_tc_2(
; VF2-SAME: ptr noalias [[DATA:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[WIDE_VEC:%.*]] = load <4 x i64>, ptr [[DATA]], align 8
; VF2-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <4 x i64> [[WIDE_VEC]], <4 x i64> poison, <2 x i32> <i32 0, i32 2>
; VF2-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <4 x i64> [[WIDE_VEC]], <4 x i64> poison, <2 x i32> <i32 1, i32 3>
; VF2-NEXT:    [[TMP2:%.*]] = shufflevector <2 x i64> [[STRIDED_VEC]], <2 x i64> [[STRIDED_VEC1]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; VF2-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <4 x i64> [[TMP2]], <4 x i64> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; VF2-NEXT:    store <4 x i64> [[INTERLEAVED_VEC]], ptr [[DATA]], align 8
; VF2-NEXT:    br label %[[MIDDLE_BLOCK:.*]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 2, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[MUL_2:%.*]] = shl nsw i64 [[IV]], 1
; VF2-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[MUL_2]]
; VF2-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF2-NEXT:    store i64 [[L_0]], ptr [[DATA_0]], align 8
; VF2-NEXT:    [[ADD_1:%.*]] = or disjoint i64 [[MUL_2]], 1
; VF2-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[ADD_1]]
; VF2-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF2-NEXT:    store i64 [[L_1]], ptr [[DATA_1]], align 8
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 2
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @load_store_interleave_group_tc_2(
; VF4-SAME: ptr noalias [[DATA:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[PRED_STORE_CONTINUE6:.*]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i8> [ <i8 0, i8 1, i8 2, i8 3>, %[[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], %[[PRED_STORE_CONTINUE6]] ]
; VF4-NEXT:    [[TMP0:%.*]] = icmp ule <4 x i8> [[VEC_IND]], splat (i8 1)
; VF4-NEXT:    [[TMP1:%.*]] = extractelement <4 x i1> [[TMP0]], i32 0
; VF4-NEXT:    br i1 [[TMP1]], label %[[PRED_STORE_IF:.*]], label %[[PRED_STORE_CONTINUE:.*]]
; VF4:       [[PRED_STORE_IF]]:
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP3:%.*]] = shl nsw i64 [[TMP2]], 1
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; VF4-NEXT:    store i64 [[TMP5]], ptr [[TMP4]], align 8
; VF4-NEXT:    [[TMP6:%.*]] = or disjoint i64 [[TMP3]], 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    store i64 [[TMP8]], ptr [[TMP7]], align 8
; VF4-NEXT:    br label %[[PRED_STORE_CONTINUE]]
; VF4:       [[PRED_STORE_CONTINUE]]:
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i1> [[TMP0]], i32 1
; VF4-NEXT:    br i1 [[TMP9]], label %[[PRED_STORE_IF1:.*]], label %[[PRED_STORE_CONTINUE2:.*]]
; VF4:       [[PRED_STORE_IF1]]:
; VF4-NEXT:    [[TMP10:%.*]] = add i64 [[INDEX]], 1
; VF4-NEXT:    [[TMP11:%.*]] = shl nsw i64 [[TMP10]], 1
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    store i64 [[TMP13]], ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = or disjoint i64 [[TMP11]], 1
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    store i64 [[TMP16]], ptr [[TMP15]], align 8
; VF4-NEXT:    br label %[[PRED_STORE_CONTINUE2]]
; VF4:       [[PRED_STORE_CONTINUE2]]:
; VF4-NEXT:    [[TMP17:%.*]] = extractelement <4 x i1> [[TMP0]], i32 2
; VF4-NEXT:    br i1 [[TMP17]], label %[[PRED_STORE_IF3:.*]], label %[[PRED_STORE_CONTINUE4:.*]]
; VF4:       [[PRED_STORE_IF3]]:
; VF4-NEXT:    [[TMP18:%.*]] = add i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP19:%.*]] = shl nsw i64 [[TMP18]], 1
; VF4-NEXT:    [[TMP20:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP19]]
; VF4-NEXT:    [[TMP21:%.*]] = load i64, ptr [[TMP20]], align 8
; VF4-NEXT:    store i64 [[TMP21]], ptr [[TMP20]], align 8
; VF4-NEXT:    [[TMP22:%.*]] = or disjoint i64 [[TMP19]], 1
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP22]]
; VF4-NEXT:    [[TMP24:%.*]] = load i64, ptr [[TMP23]], align 8
; VF4-NEXT:    store i64 [[TMP24]], ptr [[TMP23]], align 8
; VF4-NEXT:    br label %[[PRED_STORE_CONTINUE4]]
; VF4:       [[PRED_STORE_CONTINUE4]]:
; VF4-NEXT:    [[TMP25:%.*]] = extractelement <4 x i1> [[TMP0]], i32 3
; VF4-NEXT:    br i1 [[TMP25]], label %[[PRED_STORE_IF5:.*]], label %[[PRED_STORE_CONTINUE6]]
; VF4:       [[PRED_STORE_IF5]]:
; VF4-NEXT:    [[TMP26:%.*]] = add i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP27:%.*]] = shl nsw i64 [[TMP26]], 1
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP27]]
; VF4-NEXT:    [[TMP29:%.*]] = load i64, ptr [[TMP28]], align 8
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = or disjoint i64 [[TMP27]], 1
; VF4-NEXT:    [[TMP31:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[TMP30]]
; VF4-NEXT:    [[TMP32:%.*]] = load i64, ptr [[TMP31]], align 8
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP31]], align 8
; VF4-NEXT:    br label %[[PRED_STORE_CONTINUE6]]
; VF4:       [[PRED_STORE_CONTINUE6]]:
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i8> [[VEC_IND]], splat (i8 4)
; VF4-NEXT:    br i1 true, label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    br label %[[EXIT:.*]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[MUL_2:%.*]] = shl nsw i64 [[IV]], 1
; VF4-NEXT:    [[DATA_0:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[MUL_2]]
; VF4-NEXT:    [[L_0:%.*]] = load i64, ptr [[DATA_0]], align 8
; VF4-NEXT:    store i64 [[L_0]], ptr [[DATA_0]], align 8
; VF4-NEXT:    [[ADD_1:%.*]] = or disjoint i64 [[MUL_2]], 1
; VF4-NEXT:    [[DATA_1:%.*]] = getelementptr inbounds i64, ptr [[DATA]], i64 [[ADD_1]]
; VF4-NEXT:    [[L_1:%.*]] = load i64, ptr [[DATA_1]], align 8
; VF4-NEXT:    store i64 [[L_1]], ptr [[DATA_1]], align 8
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 2
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %mul.2 = shl nsw i64 %iv, 1
  %data.0 = getelementptr inbounds i64, ptr %data, i64 %mul.2
  %l.0 = load i64, ptr %data.0, align 8
  store i64 %l.0, ptr %data.0, align 8
  %add.1 = or disjoint i64 %mul.2, 1
  %data.1 = getelementptr inbounds i64, ptr %data, i64 %add.1
  %l.1 = load i64, ptr %data.1, align 8
  store i64 %l.1, ptr %data.1, align 8
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, 2
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_complex_add_float_tc_4(ptr %res, ptr noalias %A, ptr noalias %B) {
; CHECK-LABEL: define void @test_complex_add_float(
; CHECK-SAME: ptr [[RES:%.*]], ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], i64 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[N]], 8
; CHECK-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; CHECK:       [[VECTOR_PH]]:
; CHECK-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[N]], 8
; CHECK-NEXT:    [[N_VEC:%.*]] = sub i64 [[N]], [[N_MOD_VF]]
; CHECK-NEXT:    br label %[[VECTOR_BODY:.*]]
; CHECK:       [[VECTOR_BODY]]:
; CHECK-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; CHECK-NEXT:    [[IV:%.*]] = add i64 [[INDEX]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 4
; CHECK-NEXT:    [[GEP_A_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[IV]]
; CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[TMP1]]
; CHECK-NEXT:    [[GEP_B_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[IV]]
; CHECK-NEXT:    [[TMP5:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[TMP1]]
; CHECK-NEXT:    [[WIDE_VEC:%.*]] = load <8 x float>, ptr [[GEP_A_0]], align 4
; CHECK-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <8 x float> [[WIDE_VEC]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; CHECK-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <8 x float> [[WIDE_VEC]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; CHECK-NEXT:    [[WIDE_VEC2:%.*]] = load <8 x float>, ptr [[TMP3]], align 4
; CHECK-NEXT:    [[STRIDED_VEC3:%.*]] = shufflevector <8 x float> [[WIDE_VEC2]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; CHECK-NEXT:    [[STRIDED_VEC4:%.*]] = shufflevector <8 x float> [[WIDE_VEC2]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; CHECK-NEXT:    [[WIDE_VEC5:%.*]] = load <8 x float>, ptr [[GEP_B_0]], align 4
; CHECK-NEXT:    [[STRIDED_VEC6:%.*]] = shufflevector <8 x float> [[WIDE_VEC5]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; CHECK-NEXT:    [[STRIDED_VEC7:%.*]] = shufflevector <8 x float> [[WIDE_VEC5]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; CHECK-NEXT:    [[WIDE_VEC8:%.*]] = load <8 x float>, ptr [[TMP5]], align 4
; CHECK-NEXT:    [[STRIDED_VEC9:%.*]] = shufflevector <8 x float> [[WIDE_VEC8]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; CHECK-NEXT:    [[STRIDED_VEC10:%.*]] = shufflevector <8 x float> [[WIDE_VEC8]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; CHECK-NEXT:    [[TMP6:%.*]] = fadd <4 x float> [[STRIDED_VEC]], [[STRIDED_VEC6]]
; CHECK-NEXT:    [[TMP7:%.*]] = fadd <4 x float> [[STRIDED_VEC3]], [[STRIDED_VEC9]]
; CHECK-NEXT:    [[TMP8:%.*]] = fadd <4 x float> [[STRIDED_VEC1]], [[STRIDED_VEC7]]
; CHECK-NEXT:    [[TMP9:%.*]] = fadd <4 x float> [[STRIDED_VEC4]], [[STRIDED_VEC10]]
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[IV]]
; CHECK-NEXT:    [[TMP11:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[TMP1]]
; CHECK-NEXT:    [[TMP12:%.*]] = shufflevector <4 x float> [[TMP6]], <4 x float> [[TMP8]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <8 x float> [[TMP12]], <8 x float> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; CHECK-NEXT:    store <8 x float> [[INTERLEAVED_VEC]], ptr [[TMP10]], align 4
; CHECK-NEXT:    [[TMP13:%.*]] = shufflevector <4 x float> [[TMP7]], <4 x float> [[TMP9]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; CHECK-NEXT:    [[INTERLEAVED_VEC11:%.*]] = shufflevector <8 x float> [[TMP13]], <8 x float> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; CHECK-NEXT:    store <8 x float> [[INTERLEAVED_VEC11]], ptr [[TMP11]], align 4
; CHECK-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 8
; CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[TMP14]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       [[MIDDLE_BLOCK]]:
; CHECK-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[N]], [[N_VEC]]
; CHECK-NEXT:    br i1 [[CMP_N]], label %[[EXIT:.*]], label %[[SCALAR_PH]]
; CHECK:       [[SCALAR_PH]]:
; CHECK-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ [[N_VEC]], %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV1:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[GEP_A_2:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[IV1]]
; CHECK-NEXT:    [[GEP_B_2:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[IV1]]
; CHECK-NEXT:    [[L_A_0:%.*]] = load float, ptr [[GEP_A_2]], align 4
; CHECK-NEXT:    [[GEP_A_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_A_2]], i64 4
; CHECK-NEXT:    [[L_A_1:%.*]] = load float, ptr [[GEP_A_1]], align 4
; CHECK-NEXT:    [[L_B_0:%.*]] = load float, ptr [[GEP_B_2]], align 4
; CHECK-NEXT:    [[ADD_0:%.*]] = fadd float [[L_A_0]], [[L_B_0]]
; CHECK-NEXT:    [[GEP_B_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_B_2]], i64 4
; CHECK-NEXT:    [[L_B_1:%.*]] = load float, ptr [[GEP_B_1]], align 4
; CHECK-NEXT:    [[ADD_1:%.*]] = fadd float [[L_A_1]], [[L_B_1]]
; CHECK-NEXT:    [[GEP_RES_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[IV1]]
; CHECK-NEXT:    store float [[ADD_0]], ptr [[GEP_RES_0]], align 4
; CHECK-NEXT:    [[GEP_RES_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_RES_0]], i64 4
; CHECK-NEXT:    store float [[ADD_1]], ptr [[GEP_RES_1]], align 4
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV1]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], [[N]]
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
; VF2-LABEL: define void @test_complex_add_float_tc_4(
; VF2-SAME: ptr [[RES:%.*]], ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*]]:
; VF2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[INDEX]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[INDEX]]
; VF2-NEXT:    [[WIDE_VEC:%.*]] = load <4 x float>, ptr [[TMP1]], align 4
; VF2-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <4 x float> [[WIDE_VEC]], <4 x float> poison, <2 x i32> <i32 0, i32 2>
; VF2-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <4 x float> [[WIDE_VEC]], <4 x float> poison, <2 x i32> <i32 1, i32 3>
; VF2-NEXT:    [[WIDE_VEC2:%.*]] = load <4 x float>, ptr [[TMP2]], align 4
; VF2-NEXT:    [[STRIDED_VEC3:%.*]] = shufflevector <4 x float> [[WIDE_VEC2]], <4 x float> poison, <2 x i32> <i32 0, i32 2>
; VF2-NEXT:    [[STRIDED_VEC4:%.*]] = shufflevector <4 x float> [[WIDE_VEC2]], <4 x float> poison, <2 x i32> <i32 1, i32 3>
; VF2-NEXT:    [[TMP3:%.*]] = fadd <2 x float> [[STRIDED_VEC]], [[STRIDED_VEC3]]
; VF2-NEXT:    [[TMP4:%.*]] = fadd <2 x float> [[STRIDED_VEC1]], [[STRIDED_VEC4]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[INDEX]]
; VF2-NEXT:    [[TMP6:%.*]] = shufflevector <2 x float> [[TMP3]], <2 x float> [[TMP4]], <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; VF2-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <4 x float> [[TMP6]], <4 x float> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
; VF2-NEXT:    store <4 x float> [[INTERLEAVED_VEC]], ptr [[TMP5]], align 4
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[INDEX_NEXT]], 4
; VF2-NEXT:    br i1 [[TMP7]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP3:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 4, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF2-NEXT:    br label %[[LOOP:.*]]
; VF2:       [[LOOP]]:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF2-NEXT:    [[GEP_A_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[IV]]
; VF2-NEXT:    [[GEP_B_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    [[L_A_0:%.*]] = load float, ptr [[GEP_A_0]], align 4
; VF2-NEXT:    [[GEP_A_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_A_0]], i64 4
; VF2-NEXT:    [[L_A_1:%.*]] = load float, ptr [[GEP_A_1]], align 4
; VF2-NEXT:    [[L_B_0:%.*]] = load float, ptr [[GEP_B_0]], align 4
; VF2-NEXT:    [[ADD_0:%.*]] = fadd float [[L_A_0]], [[L_B_0]]
; VF2-NEXT:    [[GEP_B_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_B_0]], i64 4
; VF2-NEXT:    [[L_B_1:%.*]] = load float, ptr [[GEP_B_1]], align 4
; VF2-NEXT:    [[ADD_1:%.*]] = fadd float [[L_A_1]], [[L_B_1]]
; VF2-NEXT:    [[GEP_RES_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[IV]]
; VF2-NEXT:    store float [[ADD_0]], ptr [[GEP_RES_0]], align 4
; VF2-NEXT:    [[GEP_RES_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_RES_0]], i64 4
; VF2-NEXT:    store float [[ADD_1]], ptr [[GEP_RES_1]], align 4
; VF2-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF2-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 4
; VF2-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2:       [[EXIT]]:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @test_complex_add_float_tc_4(
; VF4-SAME: ptr [[RES:%.*]], ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*]]:
; VF4-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[WIDE_VEC:%.*]] = load <8 x float>, ptr [[A]], align 4
; VF4-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <8 x float> [[WIDE_VEC]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; VF4-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <8 x float> [[WIDE_VEC]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; VF4-NEXT:    [[WIDE_VEC2:%.*]] = load <8 x float>, ptr [[B]], align 4
; VF4-NEXT:    [[STRIDED_VEC3:%.*]] = shufflevector <8 x float> [[WIDE_VEC2]], <8 x float> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; VF4-NEXT:    [[STRIDED_VEC4:%.*]] = shufflevector <8 x float> [[WIDE_VEC2]], <8 x float> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; VF4-NEXT:    [[TMP2:%.*]] = fadd <4 x float> [[STRIDED_VEC]], [[STRIDED_VEC3]]
; VF4-NEXT:    [[TMP3:%.*]] = fadd <4 x float> [[STRIDED_VEC1]], [[STRIDED_VEC4]]
; VF4-NEXT:    [[TMP5:%.*]] = shufflevector <4 x float> [[TMP2]], <4 x float> [[TMP3]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; VF4-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <8 x float> [[TMP5]], <8 x float> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; VF4-NEXT:    store <8 x float> [[INTERLEAVED_VEC]], ptr [[RES]], align 4
; VF4-NEXT:    br label %[[MIDDLE_BLOCK:.*]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    br i1 true, label %[[EXIT:.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 4, %[[MIDDLE_BLOCK]] ], [ 0, %[[ENTRY]] ]
; VF4-NEXT:    br label %[[LOOP:.*]]
; VF4:       [[LOOP]]:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], %[[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; VF4-NEXT:    [[GEP_A_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[A]], i64 [[IV]]
; VF4-NEXT:    [[GEP_B_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    [[L_A_0:%.*]] = load float, ptr [[GEP_A_0]], align 4
; VF4-NEXT:    [[GEP_A_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_A_0]], i64 4
; VF4-NEXT:    [[L_A_1:%.*]] = load float, ptr [[GEP_A_1]], align 4
; VF4-NEXT:    [[L_B_0:%.*]] = load float, ptr [[GEP_B_0]], align 4
; VF4-NEXT:    [[ADD_0:%.*]] = fadd float [[L_A_0]], [[L_B_0]]
; VF4-NEXT:    [[GEP_B_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_B_0]], i64 4
; VF4-NEXT:    [[L_B_1:%.*]] = load float, ptr [[GEP_B_1]], align 4
; VF4-NEXT:    [[ADD_1:%.*]] = fadd float [[L_A_1]], [[L_B_1]]
; VF4-NEXT:    [[GEP_RES_0:%.*]] = getelementptr inbounds nuw { float, float }, ptr [[RES]], i64 [[IV]]
; VF4-NEXT:    store float [[ADD_0]], ptr [[GEP_RES_0]], align 4
; VF4-NEXT:    [[GEP_RES_1:%.*]] = getelementptr inbounds nuw i8, ptr [[GEP_RES_0]], i64 4
; VF4-NEXT:    store float [[ADD_1]], ptr [[GEP_RES_1]], align 4
; VF4-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; VF4-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 4
; VF4-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP]], !llvm.loop [[LOOP4:![0-9]+]]
; VF4:       [[EXIT]]:
; VF4-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %gep.A.0 = getelementptr inbounds nuw { float, float }, ptr %A, i64 %iv
  %gep.B.0 = getelementptr inbounds nuw { float, float }, ptr %B, i64 %iv
  %l.A.0 = load float, ptr %gep.A.0, align 4
  %gep.A.1 = getelementptr inbounds nuw i8, ptr %gep.A.0, i64 4
  %l.A.1 = load float, ptr %gep.A.1, align 4
  %l.B.0 = load float, ptr %gep.B.0, align 4
  %add.0 = fadd float %l.A.0, %l.B.0
  %gep.B.1 = getelementptr inbounds nuw i8, ptr %gep.B.0, i64 4
  %l.B.1 = load float, ptr %gep.B.1, align 4
  %add.1 = fadd float %l.A.1, %l.B.1
  %gep.res.0 = getelementptr inbounds nuw { float, float }, ptr %res, i64 %iv
  store float %add.0, ptr %gep.res.0, align 4
  %gep.res.1 = getelementptr inbounds nuw i8, ptr %gep.res.0, i64 4
  store float %add.1, ptr %gep.res.1, align 4
  %iv.next = add nuw nsw i64 %iv, 1
  %ec = icmp eq i64 %iv.next, 4
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
