; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=sparc-unknown-linux < %s | FileCheck -check-prefix=SPARC32 %s
; RUN: llc -mtriple=sparc-unknown-solaris < %s | FileCheck -check-prefix=SPARC32 %s
; RUN: llc -mtriple=sparc64-unknown-solaris < %s | FileCheck -check-prefix=SPARC64 %s
; RUN: llc -mtriple=sparc64-unknown-linux < %s | FileCheck -check-prefix=SPARC64 %s
; RUN: llc -mtriple=sparc-unknown-linux-gnu < %s | FileCheck -check-prefix=GNU32 %s
; RUN: llc -mtriple=sparc64-unknown-linux-gnu < %s | FileCheck -check-prefix=GNU64 %s

define { half, half } @test_sincos_f16(half %a) #0 {
; SPARC32-LABEL: test_sincos_f16:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -104, %sp
; SPARC32-NEXT:    call __truncsfhf2
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call __extendhfsf2
; SPARC32-NEXT:    nop
; SPARC32-NEXT:    st %f0, [%fp+-4]
; SPARC32-NEXT:    ld [%fp+-4], %i0
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-8] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    fmovs %f0, %f1
; SPARC32-NEXT:    ld [%fp+-8], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_f16:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    st %f0, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2039], %f1
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    ld [%fp+2043], %f0 ! 4-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f16:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -104, %sp
; GNU32-NEXT:    call __truncsfhf2
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    call __extendhfsf2
; GNU32-NEXT:    nop
; GNU32-NEXT:    st %f0, [%fp+-12]
; GNU32-NEXT:    ld [%fp+-12], %o0
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    ld [%fp+-4], %f0
; GNU32-NEXT:    ld [%fp+-8], %f1
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_f16:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -192, %sp
; GNU64-NEXT:    call __truncsfhf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    call __extendhfsf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    fmovs %f0, %f1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    nop
; GNU64-NEXT:    ld [%fp+2043], %f0
; GNU64-NEXT:    ld [%fp+2039], %f1
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) #0 {
; SPARC32-LABEL: test_sincos_f16_only_use_sin:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -96, %sp
; SPARC32-NEXT:    call __truncsfhf2
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call __extendhfsf2
; SPARC32-NEXT:    nop
; SPARC32-NEXT:    st %f0, [%fp+-4]
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    ld [%fp+-4], %o0
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_f16_only_use_sin:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f16_only_use_sin:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -104, %sp
; GNU32-NEXT:    call __truncsfhf2
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    call __extendhfsf2
; GNU32-NEXT:    nop
; GNU32-NEXT:    st %f0, [%fp+-12]
; GNU32-NEXT:    ld [%fp+-12], %o0
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    ld [%fp+-4], %f0
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_f16_only_use_sin:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -192, %sp
; GNU64-NEXT:    call __truncsfhf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    call __extendhfsf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    fmovs %f0, %f1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    nop
; GNU64-NEXT:    ld [%fp+2043], %f0
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) #0 {
; SPARC32-LABEL: test_sincos_f16_only_use_cos:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -96, %sp
; SPARC32-NEXT:    call __truncsfhf2
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call __extendhfsf2
; SPARC32-NEXT:    nop
; SPARC32-NEXT:    st %f0, [%fp+-4]
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    ld [%fp+-4], %o0
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_f16_only_use_cos:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -176, %sp
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f16_only_use_cos:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -104, %sp
; GNU32-NEXT:    call __truncsfhf2
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    call __extendhfsf2
; GNU32-NEXT:    nop
; GNU32-NEXT:    st %f0, [%fp+-12]
; GNU32-NEXT:    ld [%fp+-12], %o0
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    ld [%fp+-8], %f0
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_f16_only_use_cos:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -192, %sp
; GNU64-NEXT:    call __truncsfhf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    call __extendhfsf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    fmovs %f0, %f1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    nop
; GNU64-NEXT:    ld [%fp+2039], %f0
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) #0 {
; SPARC32-LABEL: test_sincos_v2f16:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -112, %sp
; SPARC32-NEXT:    call __truncsfhf2
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    call __extendhfsf2
; SPARC32-NEXT:    nop
; SPARC32-NEXT:    st %f0, [%fp+-12] ! 4-byte Folded Spill
; SPARC32-NEXT:    call __truncsfhf2
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call __extendhfsf2
; SPARC32-NEXT:    nop
; SPARC32-NEXT:    st %f0, [%fp+-8]
; SPARC32-NEXT:    ld [%fp+-12], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%fp+-4]
; SPARC32-NEXT:    ld [%fp+-8], %i0
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-12] ! 4-byte Folded Spill
; SPARC32-NEXT:    ld [%fp+-4], %i1
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    st %f0, [%fp+-16] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-20] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    fmovs %f0, %f3
; SPARC32-NEXT:    ld [%fp+-12], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    ld [%fp+-16], %f1 ! 4-byte Folded Reload
; SPARC32-NEXT:    ld [%fp+-20], %f2 ! 4-byte Folded Reload
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_v2f16:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    st %f1, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    fmovs %f3, %f1
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call __truncsfhf2
; SPARC64-NEXT:    ld [%fp+2039], %f1
; SPARC64-NEXT:    call __extendhfsf2
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    st %f0, [%fp+2031] ! 4-byte Folded Spill
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    nop
; SPARC64-NEXT:    st %f0, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    st %f0, [%fp+2035] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2031], %f1
; SPARC64-NEXT:    st %f0, [%fp+2031] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    fmovs %f0, %f3
; SPARC64-NEXT:    ld [%fp+2039], %f0 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2035], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2031], %f2 ! 4-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_v2f16:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -120, %sp
; GNU32-NEXT:    call __truncsfhf2
; GNU32-NEXT:    mov %i1, %o0
; GNU32-NEXT:    call __extendhfsf2
; GNU32-NEXT:    nop
; GNU32-NEXT:    st %f0, [%fp+-28] ! 4-byte Folded Spill
; GNU32-NEXT:    call __truncsfhf2
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    call __extendhfsf2
; GNU32-NEXT:    nop
; GNU32-NEXT:    st %f0, [%fp+-20]
; GNU32-NEXT:    ld [%fp+-20], %o0
; GNU32-NEXT:    add %fp, -12, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -16, %o2
; GNU32-NEXT:    ld [%fp+-28], %f0 ! 4-byte Folded Reload
; GNU32-NEXT:    st %f0, [%fp+-24]
; GNU32-NEXT:    ld [%fp+-24], %o0
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    ld [%fp+-12], %f0
; GNU32-NEXT:    ld [%fp+-4], %f1
; GNU32-NEXT:    ld [%fp+-16], %f2
; GNU32-NEXT:    ld [%fp+-8], %f3
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_v2f16:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -208, %sp
; GNU64-NEXT:    st %f1, [%fp+2023] ! 4-byte Folded Spill
; GNU64-NEXT:    fmovs %f3, %f1
; GNU64-NEXT:    call __truncsfhf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    call __extendhfsf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    st %f0, [%fp+2027] ! 4-byte Folded Spill
; GNU64-NEXT:    call __truncsfhf2
; GNU64-NEXT:    ld [%fp+2023], %f1
; GNU64-NEXT:    call __extendhfsf2
; GNU64-NEXT:    nop
; GNU64-NEXT:    add %fp, 2035, %o1
; GNU64-NEXT:    add %fp, 2031, %o2
; GNU64-NEXT:    fmovs %f0, %f1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    nop
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    ld [%fp+2027], %f1
; GNU64-NEXT:    ld [%fp+2035], %f0
; GNU64-NEXT:    ld [%fp+2043], %f1
; GNU64-NEXT:    ld [%fp+2031], %f2
; GNU64-NEXT:    ld [%fp+2039], %f3
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) #0 {
; SPARC32-LABEL: test_sincos_f32:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -104, %sp
; SPARC32-NEXT:    st %i0, [%fp+-4]
; SPARC32-NEXT:    ld [%fp+-4], %f0
; SPARC32-NEXT:    st %f0, [%fp+-8]
; SPARC32-NEXT:    ld [%fp+-8], %i0
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-12] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    fmovs %f0, %f1
; SPARC32-NEXT:    ld [%fp+-12], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_f32:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    st %f1, [%fp+2039]
; SPARC64-NEXT:    st %f0, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2039], %f1
; SPARC64-NEXT:    fmovs %f0, %f1
; SPARC64-NEXT:    ld [%fp+2043], %f0 ! 4-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f32:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -104, %sp
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    ld [%fp+-4], %f0
; GNU32-NEXT:    ld [%fp+-8], %f1
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_f32:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -192, %sp
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    ld [%fp+2043], %f0
; GNU64-NEXT:    ld [%fp+2039], %f1
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) #0 {
; SPARC32-LABEL: test_sincos_v2f32:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -120, %sp
; SPARC32-NEXT:    st %i1, [%fp+-4]
; SPARC32-NEXT:    st %i0, [%fp+-8]
; SPARC32-NEXT:    ld [%fp+-8], %f0
; SPARC32-NEXT:    ld [%fp+-4], %f1
; SPARC32-NEXT:    st %f0, [%fp+-16]
; SPARC32-NEXT:    st %f1, [%fp+-12]
; SPARC32-NEXT:    ld [%fp+-16], %i0
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-20] ! 4-byte Folded Spill
; SPARC32-NEXT:    ld [%fp+-12], %i1
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    st %f0, [%fp+-24] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-28] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    fmovs %f0, %f3
; SPARC32-NEXT:    ld [%fp+-20], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    ld [%fp+-24], %f1 ! 4-byte Folded Reload
; SPARC32-NEXT:    ld [%fp+-28], %f2 ! 4-byte Folded Reload
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_v2f32:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    st %f3, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    st %f1, [%fp+2031]
; SPARC64-NEXT:    st %f0, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    st %f0, [%fp+2035] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2031], %f1
; SPARC64-NEXT:    st %f0, [%fp+2031] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    fmovs %f0, %f3
; SPARC64-NEXT:    ld [%fp+2039], %f0 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2035], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2031], %f2 ! 4-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_v2f32:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -112, %sp
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    add %fp, -12, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %fp, -16, %o2
; GNU32-NEXT:    add %fp, -4, %o1
; GNU32-NEXT:    add %fp, -8, %o2
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    mov %i1, %o0
; GNU32-NEXT:    ld [%fp+-12], %f0
; GNU32-NEXT:    ld [%fp+-4], %f1
; GNU32-NEXT:    ld [%fp+-16], %f2
; GNU32-NEXT:    ld [%fp+-8], %f3
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_v2f32:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -208, %sp
; GNU64-NEXT:    st %f3, [%fp+2027] ! 4-byte Folded Spill
; GNU64-NEXT:    add %fp, 2035, %o1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    add %fp, 2031, %o2
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    ld [%fp+2027], %f1
; GNU64-NEXT:    ld [%fp+2035], %f0
; GNU64-NEXT:    ld [%fp+2043], %f1
; GNU64-NEXT:    ld [%fp+2031], %f2
; GNU64-NEXT:    ld [%fp+2039], %f3
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
; CHECKR2-LABEL: test_sincos_v2f32:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    daddiu $sp, $sp, -32
; CHECKR2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    move $16, $4
; CHECKR2-NEXT:    dsrl $1, $4, 32
; CHECKR2-NEXT:    sll $1, $1, 0
; CHECKR2-NEXT:    mtc1 $1, $f12
; CHECKR2-NEXT:    daddiu $5, $sp, 12
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 8
; CHECKR2-NEXT:    sll $1, $16, 0
; CHECKR2-NEXT:    mtc1 $1, $f12
; CHECKR2-NEXT:    daddiu $5, $sp, 4
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 0
; CHECKR2-NEXT:    lwc1 $f0, 12($sp)
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 4($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    lwc1 $f0, 8($sp)
; CHECKR2-NEXT:    or $2, $2, $1
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 0($sp)
; CHECKR2-NEXT:    mfc1 $3, $f0
; CHECKR2-NEXT:    dext $3, $3, 0, 32
; CHECKR2-NEXT:    or $3, $3, $1
; CHECKR2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    daddiu $sp, $sp, 32
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { <3 x float>, <3 x float> } @test_sincos_v3f32(<3 x float> %a) #0 {
; SPARC32-LABEL: test_sincos_v3f32:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -136, %sp
; SPARC32-NEXT:    st %i2, [%fp+-4]
; SPARC32-NEXT:    st %i1, [%fp+-8]
; SPARC32-NEXT:    st %i0, [%fp+-12]
; SPARC32-NEXT:    ld [%fp+-12], %f0
; SPARC32-NEXT:    ld [%fp+-8], %f1
; SPARC32-NEXT:    ld [%fp+-4], %f2
; SPARC32-NEXT:    ld [%fp+64], %i3
; SPARC32-NEXT:    st %f0, [%fp+-24]
; SPARC32-NEXT:    st %f1, [%fp+-20]
; SPARC32-NEXT:    st %f2, [%fp+-16]
; SPARC32-NEXT:    ld [%fp+-24], %i0
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-28] ! 4-byte Folded Spill
; SPARC32-NEXT:    ld [%fp+-20], %i1
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    st %f0, [%fp+-32] ! 4-byte Folded Spill
; SPARC32-NEXT:    ld [%fp+-16], %i2
; SPARC32-NEXT:    call sinf
; SPARC32-NEXT:    mov %i2, %o0
; SPARC32-NEXT:    st %f0, [%fp+-36] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    st %f0, [%fp+-40] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i1, %o0
; SPARC32-NEXT:    st %f0, [%fp+-44] ! 4-byte Folded Spill
; SPARC32-NEXT:    call cosf
; SPARC32-NEXT:    mov %i2, %o0
; SPARC32-NEXT:    st %f0, [%i3+24]
; SPARC32-NEXT:    ld [%fp+-44], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%i3+20]
; SPARC32-NEXT:    ld [%fp+-40], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%i3+16]
; SPARC32-NEXT:    ld [%fp+-36], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%i3+8]
; SPARC32-NEXT:    ld [%fp+-32], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%i3+4]
; SPARC32-NEXT:    ld [%fp+-28], %f0 ! 4-byte Folded Reload
; SPARC32-NEXT:    st %f0, [%i3]
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_v3f32:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -208, %sp
; SPARC64-NEXT:    st %f5, [%fp+2043] ! 4-byte Folded Spill
; SPARC64-NEXT:    st %f3, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    st %f1, [%fp+2023]
; SPARC64-NEXT:    st %f0, [%fp+2035] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    ld [%fp+2039], %f1
; SPARC64-NEXT:    st %f0, [%fp+2031] ! 4-byte Folded Spill
; SPARC64-NEXT:    call sinf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    st %f0, [%fp+2027] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2023], %f1
; SPARC64-NEXT:    st %f0, [%fp+2023] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2039], %f1
; SPARC64-NEXT:    st %f0, [%fp+2039] ! 4-byte Folded Spill
; SPARC64-NEXT:    call cosf
; SPARC64-NEXT:    ld [%fp+2043], %f1
; SPARC64-NEXT:    fmovs %f0, %f5
; SPARC64-NEXT:    ld [%fp+2035], %f0 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2031], %f1 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2027], %f2 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2023], %f3 ! 4-byte Folded Reload
; SPARC64-NEXT:    ld [%fp+2039], %f4 ! 4-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_v3f32:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -96, %sp
; GNU32-NEXT:    ld [%fp+64], %i3
; GNU32-NEXT:    mov %i2, %o0
; GNU32-NEXT:    add %i3, 8, %o1
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    add %i3, 24, %o2
; GNU32-NEXT:    add %i3, 4, %o1
; GNU32-NEXT:    add %i3, 20, %o2
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    mov %i1, %o0
; GNU32-NEXT:    add %i3, 16, %o2
; GNU32-NEXT:    mov %i0, %o0
; GNU32-NEXT:    call sincosf
; GNU32-NEXT:    mov %i3, %o1
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_v3f32:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -208, %sp
; GNU64-NEXT:    st %f5, [%fp+2019] ! 4-byte Folded Spill
; GNU64-NEXT:    st %f3, [%fp+2015] ! 4-byte Folded Spill
; GNU64-NEXT:    add %fp, 2027, %o1
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    add %fp, 2023, %o2
; GNU64-NEXT:    add %fp, 2035, %o1
; GNU64-NEXT:    add %fp, 2031, %o2
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    ld [%fp+2015], %f1
; GNU64-NEXT:    add %fp, 2043, %o1
; GNU64-NEXT:    add %fp, 2039, %o2
; GNU64-NEXT:    call sincosf
; GNU64-NEXT:    ld [%fp+2019], %f1
; GNU64-NEXT:    ld [%fp+2027], %f0
; GNU64-NEXT:    ld [%fp+2035], %f1
; GNU64-NEXT:    ld [%fp+2043], %f2
; GNU64-NEXT:    ld [%fp+2023], %f3
; GNU64-NEXT:    ld [%fp+2031], %f4
; GNU64-NEXT:    ld [%fp+2039], %f5
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
; CHECKR2-LABEL: test_sincos_v3f32:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    daddiu $sp, $sp, -48
; CHECKR2-NEXT:    sdc1 $f25, 40($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sdc1 $f24, 32($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    mov.s $f24, $f15
; CHECKR2-NEXT:    mov.s $f25, $f14
; CHECKR2-NEXT:    mov.s $f12, $f13
; CHECKR2-NEXT:    move $16, $4
; CHECKR2-NEXT:    daddiu $5, $sp, 4
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 0
; CHECKR2-NEXT:    daddiu $5, $sp, 12
; CHECKR2-NEXT:    daddiu $6, $sp, 8
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    mov.s $f12, $f25
; CHECKR2-NEXT:    daddiu $5, $16, 8
; CHECKR2-NEXT:    daddiu $6, $16, 24
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    mov.s $f12, $f24
; CHECKR2-NEXT:    lwc1 $f0, 0($sp)
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 8($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    or $1, $2, $1
; CHECKR2-NEXT:    lwc1 $f0, 4($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    sd $1, 16($16)
; CHECKR2-NEXT:    dsll $1, $2, 32
; CHECKR2-NEXT:    lwc1 $f0, 12($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    or $1, $2, $1
; CHECKR2-NEXT:    sd $1, 0($16)
; CHECKR2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ldc1 $f24, 32($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ldc1 $f25, 40($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    daddiu $sp, $sp, 48
  %result = call { <3 x float>, <3 x float> } @llvm.sincos.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { double, double } @test_sincos_f64(double %a) #0 {
; SPARC32-LABEL: test_sincos_f64:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -120, %sp
; SPARC32-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; SPARC32-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; SPARC32-NEXT:    std %i0, [%fp+-8]
; SPARC32-NEXT:    ldd [%fp+-8], %f0
; SPARC32-NEXT:    std %f0, [%fp+-16]
; SPARC32-NEXT:    ldd [%fp+-16], %i0
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call sin
; SPARC32-NEXT:    mov %i1, %o1
; SPARC32-NEXT:    std %f0, [%fp+-24] ! 8-byte Folded Spill
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call cos
; SPARC32-NEXT:    mov %i1, %o1
; SPARC32-NEXT:    fmovs %f0, %f2
; SPARC32-NEXT:    fmovs %f1, %f3
; SPARC32-NEXT:    ldd [%fp+-24], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_f64:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -192, %sp
; SPARC64-NEXT:    call sin
; SPARC64-NEXT:    std %f0, [%fp+2031]
; SPARC64-NEXT:    std %f0, [%fp+2039] ! 8-byte Folded Spill
; SPARC64-NEXT:    call cos
; SPARC64-NEXT:    ldd [%fp+2031], %f0
; SPARC64-NEXT:    fmovd %f0, %f2
; SPARC64-NEXT:    ldd [%fp+2039], %f0 ! 8-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f64:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -128, %sp
; GNU32-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; GNU32-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; GNU32-NEXT:    std %i0, [%fp+-8]
; GNU32-NEXT:    ldd [%fp+-8], %f0
; GNU32-NEXT:    std %f0, [%fp+-32]
; GNU32-NEXT:    ldd [%fp+-32], %o0
; GNU32-NEXT:    add %fp, -16, %o2
; GNU32-NEXT:    call sincos
; GNU32-NEXT:    add %fp, -24, %o3
; GNU32-NEXT:    ldd [%fp+-16], %f0
; GNU32-NEXT:    ldd [%fp+-24], %f2
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_f64:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -192, %sp
; GNU64-NEXT:    add %fp, 2039, %o1
; GNU64-NEXT:    call sincos
; GNU64-NEXT:    add %fp, 2031, %o2
; GNU64-NEXT:    ldd [%fp+2039], %f0
; GNU64-NEXT:    ldd [%fp+2031], %f2
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %result = call { double, double } @llvm.sincos.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) #0 {
; SPARC32-LABEL: test_sincos_v2f64:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -152, %sp
; SPARC32-NEXT:    ! kill: def $i3 killed $i3 killed $i2_i3 def $i2_i3
; SPARC32-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; SPARC32-NEXT:    ! kill: def $i2 killed $i2 killed $i2_i3 def $i2_i3
; SPARC32-NEXT:    std %i2, [%fp+-16]
; SPARC32-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; SPARC32-NEXT:    std %i0, [%fp+-8]
; SPARC32-NEXT:    ldd [%fp+-8], %f0
; SPARC32-NEXT:    ldd [%fp+-16], %f2
; SPARC32-NEXT:    ld [%fp+64], %i4
; SPARC32-NEXT:    std %f0, [%fp+-32]
; SPARC32-NEXT:    std %f2, [%fp+-24]
; SPARC32-NEXT:    ldd [%fp+-32], %i0
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call sin
; SPARC32-NEXT:    mov %i1, %o1
; SPARC32-NEXT:    std %f0, [%fp+-40] ! 8-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-24], %i2
; SPARC32-NEXT:    mov %i2, %o0
; SPARC32-NEXT:    call sin
; SPARC32-NEXT:    mov %i3, %o1
; SPARC32-NEXT:    std %f0, [%fp+-48] ! 8-byte Folded Spill
; SPARC32-NEXT:    mov %i0, %o0
; SPARC32-NEXT:    call cos
; SPARC32-NEXT:    mov %i1, %o1
; SPARC32-NEXT:    std %f0, [%fp+-56] ! 8-byte Folded Spill
; SPARC32-NEXT:    mov %i2, %o0
; SPARC32-NEXT:    call cos
; SPARC32-NEXT:    mov %i3, %o1
; SPARC32-NEXT:    std %f0, [%i4+24]
; SPARC32-NEXT:    ldd [%fp+-56], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i4+16]
; SPARC32-NEXT:    ldd [%fp+-48], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i4+8]
; SPARC32-NEXT:    ldd [%fp+-40], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i4]
; SPARC32-NEXT:    ret
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_v2f64:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -208, %sp
; SPARC64-NEXT:    std %f2, [%fp+2039] ! 8-byte Folded Spill
; SPARC64-NEXT:    call sin
; SPARC64-NEXT:    std %f0, [%fp+2015]
; SPARC64-NEXT:    std %f0, [%fp+2031] ! 8-byte Folded Spill
; SPARC64-NEXT:    call sin
; SPARC64-NEXT:    ldd [%fp+2039], %f0
; SPARC64-NEXT:    std %f0, [%fp+2023] ! 8-byte Folded Spill
; SPARC64-NEXT:    call cos
; SPARC64-NEXT:    ldd [%fp+2015], %f0
; SPARC64-NEXT:    std %f0, [%fp+2015] ! 8-byte Folded Spill
; SPARC64-NEXT:    call cos
; SPARC64-NEXT:    ldd [%fp+2039], %f0
; SPARC64-NEXT:    fmovd %f0, %f6
; SPARC64-NEXT:    ldd [%fp+2031], %f0 ! 8-byte Folded Reload
; SPARC64-NEXT:    ldd [%fp+2023], %f2 ! 8-byte Folded Reload
; SPARC64-NEXT:    ldd [%fp+2015], %f4 ! 8-byte Folded Reload
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_v2f64:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -136, %sp
; GNU32-NEXT:    ! kill: def $i1 killed $i1 killed $i0_i1 def $i0_i1
; GNU32-NEXT:    ! kill: def $i3 killed $i3 killed $i2_i3 def $i2_i3
; GNU32-NEXT:    ! kill: def $i0 killed $i0 killed $i0_i1 def $i0_i1
; GNU32-NEXT:    std %i0, [%fp+-8]
; GNU32-NEXT:    ! kill: def $i2 killed $i2 killed $i2_i3 def $i2_i3
; GNU32-NEXT:    std %i2, [%fp+-16]
; GNU32-NEXT:    ld [%fp+64], %i0
; GNU32-NEXT:    ldd [%fp+-16], %f0
; GNU32-NEXT:    ldd [%fp+-8], %f2
; GNU32-NEXT:    std %f2, [%fp+-40] ! 8-byte Folded Spill
; GNU32-NEXT:    std %f0, [%fp+-32]
; GNU32-NEXT:    ldd [%fp+-32], %o0
; GNU32-NEXT:    add %i0, 8, %o2
; GNU32-NEXT:    call sincos
; GNU32-NEXT:    add %i0, 24, %o3
; GNU32-NEXT:    ldd [%fp+-40], %f0 ! 8-byte Folded Reload
; GNU32-NEXT:    std %f0, [%fp+-24]
; GNU32-NEXT:    ldd [%fp+-24], %o0
; GNU32-NEXT:    add %i0, 16, %o3
; GNU32-NEXT:    call sincos
; GNU32-NEXT:    mov %i0, %o2
; GNU32-NEXT:    ret
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_v2f64:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -224, %sp
; GNU64-NEXT:    std %f2, [%fp+2007] ! 8-byte Folded Spill
; GNU64-NEXT:    add %fp, 2023, %o1
; GNU64-NEXT:    call sincos
; GNU64-NEXT:    add %fp, 2015, %o2
; GNU64-NEXT:    add %fp, 2039, %o1
; GNU64-NEXT:    add %fp, 2031, %o2
; GNU64-NEXT:    call sincos
; GNU64-NEXT:    ldd [%fp+2007], %f0
; GNU64-NEXT:    ldd [%fp+2023], %f0
; GNU64-NEXT:    ldd [%fp+2039], %f2
; GNU64-NEXT:    ldd [%fp+2015], %f4
; GNU64-NEXT:    ldd [%fp+2031], %f6
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
; CHECKR2-LABEL: test_sincos_v2f64:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    addiu $sp, $sp, -32
; CHECKR2-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    move $16, $7
; CHECKR2-NEXT:    move $17, $6
; CHECKR2-NEXT:    move $18, $4
; CHECKR2-NEXT:    lw $1, 48($sp)
; CHECKR2-NEXT:    lw $2, 52($sp)
; CHECKR2-NEXT:    mtc1 $2, $f12
; CHECKR2-NEXT:    mthc1 $1, $f12
; CHECKR2-NEXT:    addiu $6, $4, 8
; CHECKR2-NEXT:    jal sincos
; CHECKR2-NEXT:    addiu $7, $4, 24
; CHECKR2-NEXT:    mtc1 $16, $f12
; CHECKR2-NEXT:    mthc1 $17, $f12
; CHECKR2-NEXT:    addiu $7, $18, 16
; CHECKR2-NEXT:    jal sincos
; CHECKR2-NEXT:    move $6, $18
; CHECKR2-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    addiu $sp, $sp, 32
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

define void @test_sincos_f128(ptr sret({ fp128, fp128 }) %ret, ptr %in) #0 {
; SPARC32-LABEL: test_sincos_f128:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -168, %sp
; SPARC32-NEXT:    ld [%fp+64], %i1
; SPARC32-NEXT:    ldd [%i0], %f0
; SPARC32-NEXT:    std %f0, [%fp+-64]
; SPARC32-NEXT:    std %f2, [%fp+-56] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%i0+8], %f4
; SPARC32-NEXT:    std %f4, [%fp+-48] ! 8-byte Folded Spill
; SPARC32-NEXT:    add %fp, -32, %i0
; SPARC32-NEXT:    st %i0, [%sp+64]
; SPARC32-NEXT:    std %f4, [%sp+100]
; SPARC32-NEXT:    call sinl
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    add %fp, -16, %i0
; SPARC32-NEXT:    st %i0, [%sp+64]
; SPARC32-NEXT:    ldd [%fp+-48], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+100]
; SPARC32-NEXT:    ldd [%fp+-64], %f0
; SPARC32-NEXT:    ldd [%fp+-56], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    ldd [%fp+-32], %f0
; SPARC32-NEXT:    std %f0, [%fp+-48]
; SPARC32-NEXT:    std %f2, [%fp+-40] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-24], %f0
; SPARC32-NEXT:    call cosl
; SPARC32-NEXT:    std %f0, [%fp+-64]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    ldd [%fp+-8], %f0
; SPARC32-NEXT:    ldd [%fp+-16], %f4
; SPARC32-NEXT:    std %f0, [%i1+24]
; SPARC32-NEXT:    std %f4, [%i1+16]
; SPARC32-NEXT:    ldd [%fp+-64], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i1+8]
; SPARC32-NEXT:    ldd [%fp+-48], %f0
; SPARC32-NEXT:    ldd [%fp+-40], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i1]
; SPARC32-NEXT:    jmp %i7+12
; SPARC32-NEXT:    restore %g0, %i1, %o0
;
; SPARC64-LABEL: test_sincos_f128:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -208, %sp
; SPARC64-NEXT:    ldd [%i1], %f0
; SPARC64-NEXT:    ldd [%i1+8], %f2
; SPARC64-NEXT:    std %f0, [%fp+2015]
; SPARC64-NEXT:    call sinl
; SPARC64-NEXT:    std %f2, [%fp+2023]
; SPARC64-NEXT:    std %f0, [%fp+2031]
; SPARC64-NEXT:    std %f2, [%fp+2039] ! 16-byte Folded Spill
; SPARC64-NEXT:    ldd [%fp+2015], %f0
; SPARC64-NEXT:    call cosl
; SPARC64-NEXT:    ldd [%fp+2023], %f2
; SPARC64-NEXT:    std %f2, [%i0+24]
; SPARC64-NEXT:    std %f0, [%i0+16]
; SPARC64-NEXT:    ldd [%fp+2031], %f0
; SPARC64-NEXT:    ldd [%fp+2039], %f2 ! 16-byte Folded Reload
; SPARC64-NEXT:    std %f2, [%i0+8]
; SPARC64-NEXT:    std %f0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_f128:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -136, %sp
; GNU32-NEXT:    ld [%fp+64], %i1
; GNU32-NEXT:    ldd [%i0], %f0
; GNU32-NEXT:    ldd [%i0+8], %f4
; GNU32-NEXT:    std %f4, [%sp+100]
; GNU32-NEXT:    add %fp, -16, %o0
; GNU32-NEXT:    add %fp, -32, %o1
; GNU32-NEXT:    call sincosl
; GNU32-NEXT:    std %f0, [%sp+92]
; GNU32-NEXT:    ldd [%fp+-24], %f0
; GNU32-NEXT:    ldd [%fp+-32], %f4
; GNU32-NEXT:    ldd [%fp+-8], %f2
; GNU32-NEXT:    ldd [%fp+-16], %f8
; GNU32-NEXT:    std %f0, [%i1+24]
; GNU32-NEXT:    std %f4, [%i1+16]
; GNU32-NEXT:    std %f2, [%i1+8]
; GNU32-NEXT:    std %f8, [%i1]
; GNU32-NEXT:    jmp %i7+12
; GNU32-NEXT:    restore %g0, %i1, %o0
;
; GNU64-LABEL: test_sincos_f128:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -208, %sp
; GNU64-NEXT:    ldd [%i1], %f0
; GNU64-NEXT:    ldd [%i1+8], %f2
; GNU64-NEXT:    add %fp, 2031, %i1
; GNU64-NEXT:    add %fp, 2015, %i2
; GNU64-NEXT:    mov %i1, %o2
; GNU64-NEXT:    call sincosl
; GNU64-NEXT:    mov %i2, %o3
; GNU64-NEXT:    or %i1, 8, %i1
; GNU64-NEXT:    or %i2, 8, %i2
; GNU64-NEXT:    ldd [%i2], %f0
; GNU64-NEXT:    ldd [%fp+2015], %f4
; GNU64-NEXT:    ldd [%i1], %f2
; GNU64-NEXT:    ldd [%fp+2031], %f8
; GNU64-NEXT:    std %f0, [%i0+24]
; GNU64-NEXT:    std %f4, [%i0+16]
; GNU64-NEXT:    std %f2, [%i0+8]
; GNU64-NEXT:    std %f8, [%i0]
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %a = load fp128, ptr %in
  %result = call { fp128, fp128 } @llvm.sincos.f128(fp128 %a)
  store { fp128, fp128 } %result, ptr %ret
  ret void
}

define void @test_sincos_v2f128(ptr sret({ <2 x fp128>, <2 x fp128> }) %ret, ptr %in) #0 {
; SPARC32-LABEL: test_sincos_v2f128:
; SPARC32:       ! %bb.0:
; SPARC32-NEXT:    save %sp, -248, %sp
; SPARC32-NEXT:    mov %i0, %i1
; SPARC32-NEXT:    ld [%fp+64], %i0
; SPARC32-NEXT:    ldd [%i1], %f0
; SPARC32-NEXT:    std %f0, [%fp+-80]
; SPARC32-NEXT:    std %f2, [%fp+-72] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%i1+8], %f0
; SPARC32-NEXT:    std %f0, [%fp+-88] ! 8-byte Folded Spill
; SPARC32-NEXT:    ldd [%i1+16], %f0
; SPARC32-NEXT:    std %f0, [%fp+-120]
; SPARC32-NEXT:    std %f2, [%fp+-112] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%i1+24], %f4
; SPARC32-NEXT:    std %f4, [%fp+-104] ! 8-byte Folded Spill
; SPARC32-NEXT:    add %fp, -64, %i1
; SPARC32-NEXT:    st %i1, [%sp+64]
; SPARC32-NEXT:    std %f4, [%sp+100]
; SPARC32-NEXT:    call sinl
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    add %fp, -16, %i1
; SPARC32-NEXT:    st %i1, [%sp+64]
; SPARC32-NEXT:    ldd [%fp+-88], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+100]
; SPARC32-NEXT:    ldd [%fp+-80], %f0
; SPARC32-NEXT:    ldd [%fp+-72], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    call cosl
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    add %fp, -32, %i1
; SPARC32-NEXT:    st %i1, [%sp+64]
; SPARC32-NEXT:    ldd [%fp+-88], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+100]
; SPARC32-NEXT:    ldd [%fp+-80], %f0
; SPARC32-NEXT:    ldd [%fp+-72], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    call sinl
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    add %fp, -48, %i1
; SPARC32-NEXT:    st %i1, [%sp+64]
; SPARC32-NEXT:    ldd [%fp+-104], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+100]
; SPARC32-NEXT:    ldd [%fp+-120], %f0
; SPARC32-NEXT:    ldd [%fp+-112], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%sp+92]
; SPARC32-NEXT:    ldd [%fp+-32], %f0
; SPARC32-NEXT:    std %f0, [%fp+-80]
; SPARC32-NEXT:    std %f2, [%fp+-72] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-24], %f0
; SPARC32-NEXT:    std %f0, [%fp+-88] ! 8-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-64], %f0
; SPARC32-NEXT:    std %f0, [%fp+-104]
; SPARC32-NEXT:    std %f2, [%fp+-96] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-56], %f0
; SPARC32-NEXT:    std %f0, [%fp+-120] ! 8-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-16], %f0
; SPARC32-NEXT:    std %f0, [%fp+-136]
; SPARC32-NEXT:    std %f2, [%fp+-128] ! 16-byte Folded Spill
; SPARC32-NEXT:    ldd [%fp+-8], %f0
; SPARC32-NEXT:    call cosl
; SPARC32-NEXT:    std %f0, [%fp+-144]
; SPARC32-NEXT:    unimp 16
; SPARC32-NEXT:    ldd [%fp+-40], %f0
; SPARC32-NEXT:    ldd [%fp+-48], %f4
; SPARC32-NEXT:    std %f0, [%i0+56]
; SPARC32-NEXT:    std %f4, [%i0+48]
; SPARC32-NEXT:    ldd [%fp+-144], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0+40]
; SPARC32-NEXT:    ldd [%fp+-136], %f0
; SPARC32-NEXT:    ldd [%fp+-128], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0+32]
; SPARC32-NEXT:    ldd [%fp+-120], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0+24]
; SPARC32-NEXT:    ldd [%fp+-104], %f0
; SPARC32-NEXT:    ldd [%fp+-96], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0+16]
; SPARC32-NEXT:    ldd [%fp+-88], %f0 ! 8-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0+8]
; SPARC32-NEXT:    ldd [%fp+-80], %f0
; SPARC32-NEXT:    ldd [%fp+-72], %f2 ! 16-byte Folded Reload
; SPARC32-NEXT:    std %f0, [%i0]
; SPARC32-NEXT:    jmp %i7+12
; SPARC32-NEXT:    restore
;
; SPARC64-LABEL: test_sincos_v2f128:
; SPARC64:       ! %bb.0:
; SPARC64-NEXT:    save %sp, -240, %sp
; SPARC64-NEXT:    ldd [%i1+16], %f0
; SPARC64-NEXT:    ldd [%i1+24], %f2
; SPARC64-NEXT:    std %f0, [%fp+2031]
; SPARC64-NEXT:    std %f2, [%fp+2039] ! 16-byte Folded Spill
; SPARC64-NEXT:    ldd [%i1], %f0
; SPARC64-NEXT:    ldd [%i1+8], %f2
; SPARC64-NEXT:    std %f0, [%fp+1983]
; SPARC64-NEXT:    call sinl
; SPARC64-NEXT:    std %f2, [%fp+1991]
; SPARC64-NEXT:    std %f0, [%fp+2015]
; SPARC64-NEXT:    std %f2, [%fp+2023] ! 16-byte Folded Spill
; SPARC64-NEXT:    ldd [%fp+2031], %f0
; SPARC64-NEXT:    call sinl
; SPARC64-NEXT:    ldd [%fp+2039], %f2
; SPARC64-NEXT:    std %f0, [%fp+1999]
; SPARC64-NEXT:    std %f2, [%fp+2007] ! 16-byte Folded Spill
; SPARC64-NEXT:    ldd [%fp+1983], %f0
; SPARC64-NEXT:    call cosl
; SPARC64-NEXT:    ldd [%fp+1991], %f2
; SPARC64-NEXT:    std %f0, [%fp+1983]
; SPARC64-NEXT:    std %f2, [%fp+1991] ! 16-byte Folded Spill
; SPARC64-NEXT:    ldd [%fp+2031], %f0
; SPARC64-NEXT:    call cosl
; SPARC64-NEXT:    ldd [%fp+2039], %f2
; SPARC64-NEXT:    std %f2, [%i0+56]
; SPARC64-NEXT:    std %f0, [%i0+48]
; SPARC64-NEXT:    ldd [%fp+1983], %f0
; SPARC64-NEXT:    ldd [%fp+1991], %f2 ! 16-byte Folded Reload
; SPARC64-NEXT:    std %f2, [%i0+40]
; SPARC64-NEXT:    std %f0, [%i0+32]
; SPARC64-NEXT:    ldd [%fp+1999], %f0
; SPARC64-NEXT:    ldd [%fp+2007], %f2 ! 16-byte Folded Reload
; SPARC64-NEXT:    std %f2, [%i0+24]
; SPARC64-NEXT:    std %f0, [%i0+16]
; SPARC64-NEXT:    ldd [%fp+2015], %f0
; SPARC64-NEXT:    ldd [%fp+2023], %f2 ! 16-byte Folded Reload
; SPARC64-NEXT:    std %f2, [%i0+8]
; SPARC64-NEXT:    std %f0, [%i0]
; SPARC64-NEXT:    ret
; SPARC64-NEXT:    restore
;
; GNU32-LABEL: test_sincos_v2f128:
; GNU32:       ! %bb.0:
; GNU32-NEXT:    save %sp, -192, %sp
; GNU32-NEXT:    mov %i0, %i1
; GNU32-NEXT:    ld [%fp+64], %i0
; GNU32-NEXT:    ldd [%i1+16], %f0
; GNU32-NEXT:    std %f0, [%fp+-80]
; GNU32-NEXT:    std %f2, [%fp+-72] ! 16-byte Folded Spill
; GNU32-NEXT:    ldd [%i1+24], %f0
; GNU32-NEXT:    std %f0, [%fp+-88] ! 8-byte Folded Spill
; GNU32-NEXT:    ldd [%i1], %f0
; GNU32-NEXT:    ldd [%i1+8], %f4
; GNU32-NEXT:    std %f4, [%sp+100]
; GNU32-NEXT:    add %fp, -48, %o0
; GNU32-NEXT:    add %fp, -64, %o1
; GNU32-NEXT:    call sincosl
; GNU32-NEXT:    std %f0, [%sp+92]
; GNU32-NEXT:    ldd [%fp+-88], %f0 ! 8-byte Folded Reload
; GNU32-NEXT:    std %f0, [%sp+100]
; GNU32-NEXT:    add %fp, -16, %o0
; GNU32-NEXT:    add %fp, -32, %o1
; GNU32-NEXT:    ldd [%fp+-80], %f0
; GNU32-NEXT:    ldd [%fp+-72], %f2 ! 16-byte Folded Reload
; GNU32-NEXT:    call sincosl
; GNU32-NEXT:    std %f0, [%sp+92]
; GNU32-NEXT:    ldd [%fp+-48], %f0
; GNU32-NEXT:    ldd [%fp+-40], %f8
; GNU32-NEXT:    ldd [%fp+-16], %f4
; GNU32-NEXT:    ldd [%fp+-8], %f10
; GNU32-NEXT:    ldd [%fp+-24], %f12
; GNU32-NEXT:    ldd [%fp+-32], %f16
; GNU32-NEXT:    ldd [%fp+-56], %f14
; GNU32-NEXT:    ldd [%fp+-64], %f20
; GNU32-NEXT:    std %f12, [%i0+56]
; GNU32-NEXT:    std %f16, [%i0+48]
; GNU32-NEXT:    std %f14, [%i0+40]
; GNU32-NEXT:    std %f20, [%i0+32]
; GNU32-NEXT:    std %f10, [%i0+24]
; GNU32-NEXT:    std %f4, [%i0+16]
; GNU32-NEXT:    std %f8, [%i0+8]
; GNU32-NEXT:    std %f0, [%i0]
; GNU32-NEXT:    jmp %i7+12
; GNU32-NEXT:    restore
;
; GNU64-LABEL: test_sincos_v2f128:
; GNU64:       ! %bb.0:
; GNU64-NEXT:    save %sp, -256, %sp
; GNU64-NEXT:    ldd [%i1+16], %f0
; GNU64-NEXT:    ldd [%i1+24], %f2
; GNU64-NEXT:    std %f0, [%fp+1967]
; GNU64-NEXT:    std %f2, [%fp+1975] ! 16-byte Folded Spill
; GNU64-NEXT:    ldd [%i1], %f0
; GNU64-NEXT:    ldd [%i1+8], %f2
; GNU64-NEXT:    add %fp, 1999, %i1
; GNU64-NEXT:    add %fp, 1983, %i2
; GNU64-NEXT:    mov %i1, %o2
; GNU64-NEXT:    call sincosl
; GNU64-NEXT:    mov %i2, %o3
; GNU64-NEXT:    add %fp, 2031, %i3
; GNU64-NEXT:    add %fp, 2015, %i4
; GNU64-NEXT:    ldd [%fp+1967], %f0
; GNU64-NEXT:    ldd [%fp+1975], %f2 ! 16-byte Folded Reload
; GNU64-NEXT:    mov %i3, %o2
; GNU64-NEXT:    call sincosl
; GNU64-NEXT:    mov %i4, %o3
; GNU64-NEXT:    ldd [%fp+1999], %f0
; GNU64-NEXT:    or %i1, 8, %i1
; GNU64-NEXT:    ldd [%i1], %f4
; GNU64-NEXT:    ldd [%fp+2031], %f8
; GNU64-NEXT:    or %i3, 8, %i1
; GNU64-NEXT:    ldd [%i1], %f6
; GNU64-NEXT:    or %i2, 8, %i1
; GNU64-NEXT:    or %i4, 8, %i2
; GNU64-NEXT:    ldd [%i2], %f12
; GNU64-NEXT:    ldd [%fp+2015], %f16
; GNU64-NEXT:    ldd [%i1], %f14
; GNU64-NEXT:    ldd [%fp+1983], %f20
; GNU64-NEXT:    std %f12, [%i0+56]
; GNU64-NEXT:    std %f16, [%i0+48]
; GNU64-NEXT:    std %f14, [%i0+40]
; GNU64-NEXT:    std %f20, [%i0+32]
; GNU64-NEXT:    std %f6, [%i0+24]
; GNU64-NEXT:    std %f8, [%i0+16]
; GNU64-NEXT:    std %f4, [%i0+8]
; GNU64-NEXT:    std %f0, [%i0]
; GNU64-NEXT:    ret
; GNU64-NEXT:    restore
  %a = load <2 x fp128>, ptr %in
  %result = call { <2 x fp128>, <2 x fp128> } @llvm.sincos.v2f128(<2 x fp128> %a)
  store { <2 x fp128>, <2 x fp128> } %result, ptr %ret
  ret void
}

attributes #0 = { nounwind }
