; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @ctpop_v16i8(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpcnt.b $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <16 x i8>, ptr %src
  %res = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %v)
  store <16 x i8> %res, ptr %dst
  ret void
}

define void @ctpop_v8i16(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpcnt.h $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <8 x i16>, ptr %src
  %res = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %v)
  store <8 x i16> %res, ptr %dst
  ret void
}

define void @ctpop_v4i32(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpcnt.w $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <4 x i32>, ptr %src
  %res = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %v)
  store <4 x i32> %res, ptr %dst
  ret void
}

define void @ctpop_v2i64(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctpop_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpcnt.d $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <2 x i64>, ptr %src
  %res = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %v)
  store <2 x i64> %res, ptr %dst
  ret void
}

define void @ctlz_v16i8(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vclz.b $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <16 x i8>, ptr %src
  %res = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %v, i1 false)
  store <16 x i8> %res, ptr %dst
  ret void
}

define void @ctlz_v8i16(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vclz.h $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <8 x i16>, ptr %src
  %res = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %v, i1 false)
  store <8 x i16> %res, ptr %dst
  ret void
}

define void @ctlz_v4i32(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vclz.w $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <4 x i32>, ptr %src
  %res = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %v, i1 false)
  store <4 x i32> %res, ptr %dst
  ret void
}

define void @ctlz_v2i64(ptr %src, ptr %dst) nounwind {
; CHECK-LABEL: ctlz_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vclz.d $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load <2 x i64>, ptr %src
  %res = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %v, i1 false)
  store <2 x i64> %res, ptr %dst
  ret void
}

declare <16 x i8> @llvm.ctpop.v16i8(<16 x i8>)
declare <8 x i16> @llvm.ctpop.v8i16(<8 x i16>)
declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>)
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)
declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>, i1)
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>, i1)
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)
declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)
