; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; PR3021

; When inst combining an FCMP with the LHS coming from a uitofp instruction, we
; can't lower it to signed ICMP instructions.

define i1 @test1(i32 %val) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[VAL:%.*]], 0
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %1 = uitofp i32 %val to double
  %2 = fcmp ole double %1, 0.000000e+00
  ret i1 %2
}

define i1 @test2(i32 %val) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i1 false
;
  %1 = uitofp i32 %val to double
  %2 = fcmp olt double %1, 0.000000e+00
  ret i1 %2
}

define i1 @test3(i32 %val) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 true
;
  %1 = uitofp i32 %val to double
  %2 = fcmp oge double %1, 0.000000e+00
  ret i1 %2
}

define i1 @test4(i32 %val) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[VAL:%.*]], 0
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %1 = uitofp i32 %val to double
  %2 = fcmp ogt double %1, 0.000000e+00
  ret i1 %2
}

define i1 @test5(i32 %val) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i1 true
;
  %1 = uitofp i32 %val to double
  %2 = fcmp ogt double %1, -4.400000e+00
  ret i1 %2
}

define i1 @test6(i32 %val) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    ret i1 false
;
  %1 = uitofp i32 %val to double
  %2 = fcmp olt double %1, -4.400000e+00
  ret i1 %2
}

; Check that optimizing unsigned >= comparisons correctly distinguishes
; positive and negative constants.  <rdar://problem/12029145>
define i1 @test7(i32 %val) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i32 [[VAL:%.*]], 3
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %1 = uitofp i32 %val to double
  %2 = fcmp oge double %1, 3.200000e+00
  ret i1 %2
}
