; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

declare void @def(ptr)

define void @alloc_v4i8(ptr %st_ptr) nounwind {
; CHECK-LABEL: alloc_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    add x20, sp, #12
; CHECK-NEXT:    bl def
; CHECK-NEXT:    ptrue p0.b, vl2
; CHECK-NEXT:    ld2b { z0.b, z1.b }, p0/z, [x20]
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    mov z2.b, z0.b[1]
; CHECK-NEXT:    zip1 z0.s, z0.s, z2.s
; CHECK-NEXT:    st1b { z0.s }, p0, [x19]
; CHECK-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp], #32 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: alloc_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    mov x19, x0
; NONEON-NOSVE-NEXT:    add x0, sp, #28
; NONEON-NOSVE-NEXT:    bl def
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [x19, #1]
; NONEON-NOSVE-NEXT:    strb w9, [x19]
; NONEON-NOSVE-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %alloc = alloca [4 x i8]
  call void @def(ptr %alloc)
  %load = load <4 x i8>, ptr %alloc
  %strided.vec = shufflevector <4 x i8> %load, <4 x i8> poison, <2 x i32> <i32 0, i32 2>
  store <2 x i8> %strided.vec, ptr %st_ptr
  ret void
}

define void @alloc_v6i8(ptr %st_ptr) nounwind {
; CHECK-LABEL: alloc_v6i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    stp x30, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    add x0, sp, #8
; CHECK-NEXT:    bl def
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    add x8, sp, #4
; CHECK-NEXT:    ptrue p1.s, vl2
; CHECK-NEXT:    mov z1.b, z0.b[3]
; CHECK-NEXT:    mov z2.b, z0.b[1]
; CHECK-NEXT:    mov z0.b, z0.b[5]
; CHECK-NEXT:    zip1 z1.h, z2.h, z1.h
; CHECK-NEXT:    zip1 z1.s, z1.s, z0.s
; CHECK-NEXT:    st1b { z1.h }, p0, [x8]
; CHECK-NEXT:    ld1h { z1.s }, p1/z, [x8]
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    strb w8, [x19, #2]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strh w8, [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: alloc_v6i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    mov x19, x0
; NONEON-NOSVE-NEXT:    add x0, sp, #24
; NONEON-NOSVE-NEXT:    bl def
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    str x8, [sp]
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strb w8, [x19, #2]
; NONEON-NOSVE-NEXT:    strh w9, [x19]
; NONEON-NOSVE-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %alloc = alloca [6 x i8]
  call void @def(ptr %alloc)
  %load = load <6 x i8>, ptr %alloc
  %strided.vec = shufflevector <6 x i8> %load, <6 x i8> poison, <3 x i32> <i32 1, i32 3, i32 5>
  store <3 x i8> %strided.vec, ptr %st_ptr
  ret void
}

define void @alloc_v32i8(ptr %st_ptr) nounwind {
; CHECK-LABEL: alloc_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    bl def
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    ldr q0, [sp]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    tbl z0.b, { z0.b }, z1.b
; CHECK-NEXT:    ldr q1, [sp, #16]
; CHECK-NEXT:    fmov w8, s1
; CHECK-NEXT:    strb w8, [x19, #8]
; CHECK-NEXT:    fmov x8, d0
; CHECK-NEXT:    str x8, [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: alloc_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #112
; NONEON-NOSVE-NEXT:    stp x30, x19, [sp, #96] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    mov x19, x0
; NONEON-NOSVE-NEXT:    add x0, sp, #64
; NONEON-NOSVE-NEXT:    bl def
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    str q1, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [x19, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    str x8, [x19]
; NONEON-NOSVE-NEXT:    ldp x30, x19, [sp, #96] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #112
; NONEON-NOSVE-NEXT:    ret
  %alloc = alloca [32 x i8]
  call void @def(ptr %alloc)
  %load = load <32 x i8>, ptr %alloc
  %strided.vec = shufflevector <32 x i8> %load, <32 x i8> poison, <9 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16>
  store <9 x i8> %strided.vec, ptr %st_ptr
  ret void
}


define void @alloc_v8f64(ptr %st_ptr) nounwind {
; CHECK-LABEL: alloc_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #96
; CHECK-NEXT:    stp x20, x19, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-NEXT:    mov x20, sp
; CHECK-NEXT:    bl def
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    mov x8, #4 // =0x4
; CHECK-NEXT:    ld2d { z0.d, z1.d }, p0/z, [x20]
; CHECK-NEXT:    ld2d { z2.d, z3.d }, p0/z, [x20, x8, lsl #3]
; CHECK-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-NEXT:    stp q0, q2, [x19]
; CHECK-NEXT:    ldp x20, x19, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #96
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: alloc_v8f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #176
; NONEON-NOSVE-NEXT:    stp x30, x19, [sp, #160] // 16-byte Folded Spill
; NONEON-NOSVE-NEXT:    mov x19, x0
; NONEON-NOSVE-NEXT:    add x0, sp, #96
; NONEON-NOSVE-NEXT:    bl def
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #96]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [sp, #128]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp]
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q1, q0, [x19]
; NONEON-NOSVE-NEXT:    ldp x30, x19, [sp, #160] // 16-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #176
; NONEON-NOSVE-NEXT:    ret
  %alloc = alloca [8 x double]
  call void @def(ptr %alloc)
  %load = load <8 x double>, ptr %alloc
  %strided.vec = shufflevector <8 x double> %load, <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  store <4 x double> %strided.vec, ptr %st_ptr
  ret void
}
