! /*
! 
! Copyright (C) 2008-2022 Michele Martone
! 
! This file is part of librsb.
! 
! librsb is free software; you can redistribute it and/or modify it
! under the terms of the GNU Lesser General Public License as published
! by the Free Software Foundation; either version 3 of the License, or
! (at your option) any later version.
! 
! librsb is distributed in the hope that it will be useful, but WITHOUT
! ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
! FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
! License for more details.
! 
! You should have received a copy of the GNU Lesser General Public
! License along with librsb; see the file COPYING.
! If not, see <http://www.gnu.org/licenses/>.
! 
! */
!
!> @cond INNERDOC
!> @file
!> @author Michele Martone 
!> @brief This file is part of the Octave based test suite for librsb
!
! Sparse BLAS fortran interface testing code
!
! FIXME: missing library initialization!
! FIXME: using zero based indices is only partially supprted!
!
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 3
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/15, 12/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/9, 12/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/15, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 2
! 4 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 4/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/12, 15/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/6, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 2
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 4/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 2
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 5/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/4, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/4, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/4, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 3
! 1 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 3, 1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/5, 8/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 2
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 2, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/5, 6/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 2
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/7, 0, 4, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 2 4

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 4/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/6, 0, 7, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL susmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/2, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 3
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/-1, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 2/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 1
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*4 :: VA(4)=&
          &(/1, 1, 5, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, 1/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/2, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*4 :: VA(1)=(/1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/2, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 2, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-1, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 5
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 5/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/-15, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, -6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/0, -3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-9, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 6 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*4 :: VA(2)=(/1, 6/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-18, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-9, 3/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(2)=(/-3, 0/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 3
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/-9, 0, 3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 2/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -3, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 4
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 4, 3/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/0, 0, -18, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 1
! 1 4

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 1, 1, 4/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 18/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 2
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/6, 9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 6, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 4 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 4/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/18, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 3
! 2 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 3, 2, 3/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/15, 18/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 0
! 1 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/6, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 2
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/12, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 7/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/4, 4/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 3/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 7, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 3 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/7, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/5, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/6, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 3
! 0 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/4, 9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 5, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 1
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/4, 0, 4, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, 1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 1
! 3 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 1, 3, 3/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 5
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 5, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/2, -3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 3
! 1 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 3, 1, 3/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-1, 0, -1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 1
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 1, 2, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 1
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/1, 2/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 2
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/2, 1/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 2
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 2, 3, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, -1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 1
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 4
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/2, 0, -2, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 1
! 4 3

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 1, 4, 3/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-3, -18/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, 3/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 3
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      REAL*8 :: VA(4)=&
          &(/1, 3, 3, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/-9, -9/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1 4
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 4/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-12, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1 0
! 1 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-3, 0, -3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1 0
! 2 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 2/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(4)=&
          &(/-6, 0, 3, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1 0
! 3 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 2/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/0, -12/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1 0
! 0 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=1
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(1)=(/1/)
      REAL*8 :: VA(1)=(/1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/0, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1 0
! 1 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(2)=(/-3, 3/)! reference cy after 
      REAL*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 4 0

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      REAL*8 :: VA(2)=(/1, 4/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, -9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 2
! 0 2

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, -9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/0, 0, 0, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 1+0i
! 2+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (2,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(9.e0,6.e0), (9,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 2+0i
! 1+0i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (1.e0,0.e0), (0,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(9.e0,6.e0), (9,12)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 0+6i
! 0+6i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,6.e0), (0.e0,6.e0), (1,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,-24.e0), (6,-24)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 1+0i
! 1+0i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1.e0,0.e0), (0,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(9.e0,6.e0), (0.e0,0.e0), (6.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 2+0i
! 4+0i 5+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (4.e0,0.e0), (5,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(18.e0,6.e0), (0.e0,0.e0), (24.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,-12.e0), (0.e0,0.e0), (3.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 3+0i
! 3+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (3.e0,0.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(15.e0,6.e0), (12,6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 0+3i
! 0+3i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (2,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(6.e0,15.e0), (9,9)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 0+6i
! 1+6i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,6.e0), (1.e0,6.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(9.e0,-24.e0), (3,-24)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 0+0i
! 2+0i 1+8i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (1,8)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,6.e0), (0.e0,0.e0), (12.e0,24.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 1+7i
! 1+7i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,7.e0), (1.e0,7.e0), (1,4)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(9.e0,27.e0), (0.e0,0.e0), (9.e0,33.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 5+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (5.e0,3.e0), (0,3)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(6.e0,-15.e0), (0.e0,0.e0), (18.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 0+3i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(4.e0,5.e0), (4,3)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 0+4i
! 2+4i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,4.e0), (2.e0,4.e0), (0,2)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(6.e0,6.e0), (3,6)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 0+2i
! 0+2i 1+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (1,6)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,-4.e0), (4,-8)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 0+3i
! 1+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (1,3)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,5.e0), (0.e0,0.e0), (4.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 0+3i
! 0+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0,3)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,5.e0), (0.e0,0.e0), (3.e0,3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 2+0i
! 1+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(5.e0,-2.e0), (0.e0,0.e0), (5.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,4.e0), (3,2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 0+0i
! 0+0i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(4.e0,2.e0), (3,2)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 1+3i
! 3+3i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (3.e0,3.e0), (1,4)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(7.e0,-5.e0), (5,-7)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 0+6i
! 5+6i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,6.e0), (5.e0,6.e0), (3,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,8.e0), (0.e0,0.e0), (11.e0,6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 2+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,2.e0), (0,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,4.e0), (0.e0,0.e0), (5.e0,2.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(4.e0,-2.e0), (0.e0,0.e0), (4.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 1+1i
! 1+1i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (1.e0,1.e0), (2,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(1.e0,-3.e0), (0,-1)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 1+3i
! 3+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (3.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(-1.e0,-5.e0), (1,-3)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 4+7i
! 0+7i 1+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (4.e0,7.e0), (0.e0,7.e0), (1,6)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(2.e0,9.e0), (-2,13)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 0+3i
! 3+3i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (3.e0,3.e0), (1,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-5.e0), (0.e0,0.e0), (-1.e0,-5.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 1+3i
! 0+3i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (0.e0,3.e0), (3,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(2.e0,-5.e0), (0.e0,0.e0), (-1.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 0+0i
! 2+0i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (3,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,2.e0), (0.e0,0.e0), (0.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+1i
! 4+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (4,1)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,-3.e0), (-1,-1)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 4+4i
! 0+4i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (4.e0,4.e0), (0.e0,4.e0), (0,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(2.e0,-6.e0), (-1,-8)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 2+3i
! 2+3i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,3.e0), (2.e0,3.e0), (2,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,5.e0), (-1,3)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 1+0i
! 3+0i 4+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (3.e0,0.e0), (4,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,-2.e0), (0.e0,0.e0), (-4.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 0+2i
! 1+2i 2+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (1.e0,2.e0), (2,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,-4.e0), (0.e0,0.e0), (1.e0,-4.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+2i
! 1+2i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (1.e0,2.e0), (0,6)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(1.e0,4.e0), (0.e0,0.e0), (3.e0,8.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 3+2i
! 1+2i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,2.e0), (1.e0,2.e0), (2,0)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-9.e0,-12.e0), (-6,-6)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 1+1i
! 1+1i 3+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (1.e0,1.e0), (3,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(-3.e0,-9.e0), (-9,-15)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 2+2i
! 3+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,2.e0), (3.e0,2.e0), (0,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-9.e0,12.e0), (-3,18)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 3+3i
! 1+3i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,3.e0), (1.e0,3.e0), (2,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(-9.e0,-15.e0), (0.e0,0.e0), (-6.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 0+4i
! 0+4i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,4.e0), (0.e0,4.e0), (0,2)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-18.e0), (0.e0,0.e0), (3.e0,-18.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 2+0i
! 0+0i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (0,4)/)
      COMPLEX*8 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,6.e0), (0.e0,0.e0), (-3.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+0i
! 1+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      COMPLEX*8 :: VA(2)=(/(1.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 1+0i
! 1+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(-3.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 1+7i
! 0+7i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,7.e0), (0.e0,7.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(2)=(/(0.e0,27.e0), (-3,21)/)! reference cy after 
      COMPLEX*8 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 0+6i
! 0+6i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,6.e0), (0.e0,6.e0), (1,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-24.e0), (0.e0,0.e0), (0.e0,-30.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 0+2i
! 0+2i 3+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (3,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,-12.e0), (0.e0,0.e0), (-6.e0,-12.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+1i
! 0+1i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*8 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (0,2)/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/(0.e0,9.e0), (0.e0,0.e0), (3.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 1+3i
! 0+3i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (0.e0,3.e0), (0,6)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(9.e0,15.e0), (3,27)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 4+1i
! 0+1i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (4.e0,1.e0), (0.e0,1.e0), (2,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,9.e0), (21,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 1+0i
! 0+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,-6.e0), (6,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 1+0i
! 0+0i 3+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (3,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(9.e0,6.e0), (0.e0,0.e0), (12.e0,6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 1+2i
! 0+2i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,12.e0), (0.e0,0.e0), (6.e0,12.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 4+1i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (4.e0,1.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,-9.e0), (0.e0,0.e0), (18.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+2i
! 1+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (1,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,12.e0), (6,6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 0+1i
! 0+1i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0,1)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,9.e0), (3,3)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 1+9i
! 0+9i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,9.e0), (0,9)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,-33.e0), (6,-27)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 3+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(15.e0,6.e0), (0.e0,0.e0), (6.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 0+0i
! 0+0i 0+8i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (0,8)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(6.e0,6.e0), (0.e0,0.e0), (3.e0,24.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+1i
! 6+1i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (6.e0,1.e0), (1,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(24.e0,-9.e0), (0.e0,0.e0), (6.e0,-15.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 2+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,2.e0), (0,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,4.e0), (3,2)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 0+2i
! 2+2i 1+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (2.e0,2.e0), (1,2)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,4.e0), (4,4)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 3+1i
! 2+1i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,1.e0), (2.e0,1.e0), (0,6)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(6.e0,-3.e0), (6,-7)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 3+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,2.e0), (0,2)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(7.e0,4.e0), (0.e0,0.e0), (3.e0,2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 1+3i
! 0+3i 1+8i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,3.e0), (0.e0,3.e0), (1,8)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,5.e0), (0.e0,0.e0), (5.e0,11.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 3+0i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,-2.e0), (0.e0,0.e0), (7.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+3i
! 1+3i 3+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (1.e0,3.e0), (3,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,5.e0), (7,5)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 0+5i
! 0+5i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,5.e0), (0.e0,5.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,7.e0), (4,5)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 0+2i
! 0+2i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (0,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(4.e0,-4.e0), (3,-8)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 3+1i
! 0+1i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (3.e0,1.e0), (0.e0,1.e0), (3,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(7.e0,3.e0), (0.e0,0.e0), (6.e0,1.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 0+0i
! 3+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (3,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(7.e0,2.e0), (0.e0,0.e0), (3.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+1i
! 0+1i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (3,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(4.e0,-3.e0), (0.e0,0.e0), (6.e0,-1.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 0+2i
! 4+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (4.e0,2.e0), (0,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-4.e0), (-1,-6)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(4:),pone,pone,IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 1+1i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,1.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,-3.e0), (1,-1)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 1+4i
! 0+4i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,4.e0), (0.e0,4.e0), (0,2)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,6.e0), (2,6)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zusmm(blas_colmajor,transT,pone,alpha,A,x,nr,y,nc,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 0+2i
! 0+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-4.e0), (0.e0,0.e0), (3.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 2+1i
! 0+1i 2+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,1.e0), (0.e0,1.e0), (2,6)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-3.e0), (0.e0,0.e0), (-1.e0,-7.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 0+5i
! 3+5i 2+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,5.e0), (3.e0,5.e0), (2,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-1.e0,7.e0), (0.e0,0.e0), (1.e0,5.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+0i
! 3+0i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 1/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (3,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-2.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 2+0i
! 0+0i 3+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (2.e0,0.e0), (3,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(2.e0,-2.e0), (-2,-4)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 2+5i
! 1+5i 0+2i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,5.e0), (1.e0,5.e0), (0,2)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(1.e0,7.e0), (1,7)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 0+0i
! 0+0i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (3,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-2.e0), (0.e0,0.e0), (0.e0,0.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 0+2i
! 0+2i 0+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,2.e0), (0.e0,2.e0), (0,4)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(2.e0,-4.e0), (0.e0,0.e0), (3.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 1+2i
! 2+2i 1+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,2.e0), (2.e0,2.e0), (1,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,4.e0), (0.e0,0.e0), (1.e0,8.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+2i 0+3i
! 3+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (3,3)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,-15.e0), (-6,-9)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+2i 1+0i
! 3+0i 4+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (3.e0,0.e0), (4,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-9.e0,-6.e0), (-12,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+2i 1+0i
! 1+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (1.e0,0.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-3.e0,6.e0), (-3,0)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=n"
! A =
! 1+2i 0+3i
! 1+3i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (1,3)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-15.e0), (0.e0,0.e0), (0.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=t"
! A =
! 1+2i 0+1i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,1.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,-9.e0), (0.e0,0.e0), (0.e0,-3.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(4),IA(4),JA(4),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=1 incy=2 trans=c"
! A =
! 1+2i 2+3i
! 1+3i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,3.e0), (1.e0,3.e0), (3,0)/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-3.e0,15.e0), (0.e0,0.e0), (-12.e0,9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(4:),pone,pone,IA(4:),JA(4:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix1_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=n"
! A =
! 1+2i 0+0i
! 0+0i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/(1.e0,2.e0), (0,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(0.e0,-6.e0), (3,-18)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=t"
! A =
! 1+2i 0+0i
! 3+0i 1+4i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (3.e0,0.e0), (1,4)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-9.e0,-6.e0), (0,-12)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=1 trans=c"
! A =
! 1+2i 1+0i
! 3+0i 0+6i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (1.e0,0.e0), (3.e0,0.e0), (0,6)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(2)=(/(-9.e0,6.e0), (0,18)/)! reference cy after 
      COMPLEX*16 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy1 
! 
      SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+2i 1+2i
! 6+2i 0+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,2.e0), (1.e0,2.e0), (6,2)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-3.e0,-12.e0), (0.e0,0.e0), (-15.e0,-6.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+2i 2+3i
! 2+3i 3+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (2.e0,3.e0), (2.e0,3.e0), (3,0)/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(-6.e0,-15.e0), (0.e0,0.e0), (-12.e0,-9.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      INTEGER(KIND=RSB_IDX_KIND) :: incy=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=g diag=e blocks=&
          &1x1 usmv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+2i 0+3i
! 0+3i 2+10i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=4
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(4)=&
          &(/1, 1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(4)=&
          &(/1, 2, 1, 2/)
      COMPLEX*16 :: VA(4)=&
          &(/(1.e0,2.e0), (0.e0,3.e0), (0.e0,3.e0), (2,10)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/(0.e0,15.e0), (0.e0,0.e0), (-3.e0,39.e0), (0,0)/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/3, 0, 3, 0/)! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sg_de_usmv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2,1)=(reshape((/9, 3/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/3, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/3, 3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/6, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/3, 0, 9, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2,1)=(reshape((/4, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/3, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/-1, -2/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/-9, -3/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 5
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(2,1)=(reshape((/-3, -18/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-3, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -12, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_su_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/4, 7/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/4, 7/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/2, -1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/2, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_su_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, -6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_su_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/3, 3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2)=(/3, 12/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/3, 3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 2/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 5
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 5, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/6, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/-1, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/-1, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/-1, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -4, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2,1)=(reshape((/-9, -3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/-3, -3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/-3, -6/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_su_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/15, 6/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/2, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/2, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/-3, 0/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_su_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, -3/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_su_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 5
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 5, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/18, 3/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/3, 3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 1+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/(3.e0,0.e0), (6,-9)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(3.e0,3.e0), (0.e0,0.e0), (3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(3.e0,0.e0), (0.e0,0.e0), (3.e0,-12.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 2+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/(3.e0,2.e0), (1,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 3/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(1.e0,0.e0), (1,-1)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 2, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,-2.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/(-1.e0,-1.e0), (-1,0)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-1.e0,0.e0), (-1,-4)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-1, -1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+0i 2+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-3.e0,-4.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-2.e0,-1.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 3+5i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,5.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-4.e0,5.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-3.e0,-3.e0), (-3,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/-3, -3/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-6.e0,-3.e0), (0.e0,0.e0), (-3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(-3.e0,0.e0), (0.e0,0.e0), (-3.e0,-3.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(-3.e0,0.e0), (0.e0,0.e0), (-6.e0,3.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_su_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 2+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(12.e0,3.e0), (6,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 4+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (4.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(6.e0,0.e0), (18,6)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 3+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(6.e0,0.e0), (15,-9)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 1+6i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,6.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(5.e0,6.e0), (4,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 1+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,4.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(4.e0,0.e0), (5,4)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(4.e0,0.e0), (4,-2)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 5+5i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (5.e0,5.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(-3.e0,-5.e0), (2,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+6i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,6.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(0.e0,-18.e0), (0,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(0.e0,0.e0), (0,-12)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_su_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 3+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(0.e0,0.e0), (-9,9)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_su_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/6, 3/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/3, 3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/(3.e0,0.e0), (3,-3)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 1+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(3.e0,0.e0), (0.e0,0.e0), (6.e0,9.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(3.e0,0.e0), (0.e0,0.e0), (3.e0,-12.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 3+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/(4.e0,2.e0), (1,0)/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,1.e0), (0.e0,0.e0), (1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 5+3i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (5.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (6.e0,3.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,0.e0), (0.e0,0.e0), (1.e0,-1.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-2.e0,-1.e0), (-1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 3
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/-1, -4/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/-1, -1/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-2.e0,-1.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-1, 0, -2, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,0.e0), (0.e0,0.e0), (-1.e0,1.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 3+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/(-12.e0,-6.e0), (-3,0)/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 3+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,4.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-3.e0,0.e0), (-12,-12)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 2
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2)=(/-3, -9/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_upper_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_su_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 1+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,0.e0), (9,3)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+7i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,7.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,0.e0), (6,-21)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 5
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 5, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/9, 4/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+4i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(4.e0,0.e0), (4,4)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(4.e0,0.e0), (4,-1)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,-1.e0), (2,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 5+6i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (5.e0,6.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,0.e0), (-3,-6)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 1+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,0.e0), (1,2)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 2+1i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(-6.e0,-3.e0), (0,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+2i
! 0+0i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(0.e0,0.e0), (0,-6)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_su_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=u diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 1
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 2, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/0, -3/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_su_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/3, 6/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/3, 3/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/18, 3/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(4)=&
          &(/18, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/9, 0, 3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/4, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 2, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2,1)=(reshape((/-4, -1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/-1, -1/)! reference x 
      REAL*4 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(4)=&
          &(/-2, 0, -1, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_sussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/-3, -12/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL sussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2)=(/-3, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2)=(/-3, -3/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -6, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*4 :: x(4)=&
          &(/-15, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*4 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*4 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE ts_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/6, 9/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/18, 6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 6/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 3, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/4, 7/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 5 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 5, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/9, 4/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/1, 2/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, 2/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_suscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_suscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_susmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*4 :: VA(2)=(/1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*4 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*4 :: cy(2,1)=(reshape((/-3, 0/),(/2,1/)))! reference cy after 
      REAL*4 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL suscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL suscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_sl_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/3, 6/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/6, 3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/3, 3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 2/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2)=(/1, 1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/2, 0, 1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      REAL*8 :: x(2)=(/-5, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-1, -1/)! reference x 
      REAL*8 :: cy(2)=(/1, 1/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/-4, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2)=(/-3, -3/)! reference x 
      REAL*8 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/-9, -3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/-3, -3/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(4)=&
          &(/-6, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 4, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(4)=&
          &(/-15, 0, -3, 0/)! reference x 
      REAL*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      REAL*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE td_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/6, 9/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/9, 6/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/6, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/4, 4/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/2, 1/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/2, 2/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 2, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, 2/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_duscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_dusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, -3/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      REAL*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE td_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      REAL*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=d dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      REAL*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      REAL*8 :: cy(2,1)=(reshape((/-3, 0/),(/2,1/)))! reference cy after 
      REAL*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL duscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL duscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE td_sl_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/(3.e0,0.e0), (3,6)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(3.e0,9.e0), (3,0)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/(3.e0,-6.e0), (3,0)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 0+0i
! 3+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(12.e0,3.e0), (0.e0,0.e0), (3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+0i
! 2+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(9.e0,-6.e0), (0.e0,0.e0), (3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/(1.e0,0.e0), (2,1)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 4, 1/)
      COMPLEX*8 :: x(2)=(/5, 1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/(3.e0,-1.e0), (1,0)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 1+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/(-1.e0,0.e0), (-2,-3)/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2)=(/-2, -1/)! reference x 
      COMPLEX*8 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/-4, -1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-1, 0, -4, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,-1.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(4)=&
          &(/(-1.e0,2.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2)=(/(-3.e0,0.e0), (-3,-3)/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2)=(/-3, -3/)! reference x 
      COMPLEX*8 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*8 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/(-3.e0,6.e0), (-3,0)/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 0+0i
! 1+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(4)=&
          &(/(-6.e0,-3.e0), (0.e0,0.e0), (-3.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      COMPLEX*8 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*8 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tc_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(6.e0,0.e0), (6,9)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL cuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/6, 6/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/9, 6/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/4, 5/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 1+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(5.e0,2.e0), (4,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(4.e0,-1.e0), (4,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_cuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_cusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(2.e0,0.e0), (2,-3)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(2.e0,-3.e0), (2,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(2.e0,1.e0), (2,0)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/(0.e0,0.e0), (0,-6)/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*8 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/-9, 0/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tc_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*8 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=c dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*8 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*8 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*8 :: cy(2,1)=(reshape((/0, 0/),(/2,1/)))! reference cy after 
      COMPLEX*8 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL cuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL cuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tc_sl_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/3, 3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 1+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (1.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(6.e0,6.e0), (3,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2)=(/6, 3/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 4 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 4, 1/)
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 15, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/3, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*16 :: x(4)=&
          &(/12, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 2+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,3.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/(1.e0,0.e0), (3,3)/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2)=(/1, 1/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 3+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2)=(/(4.e0,-2.e0), (1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/1, 0, 1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha= 1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(1.e0,-2.e0), (0.e0,0.e0), (1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_ap1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 3+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (3.e0,2.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/(-1.e0,0.e0), (-4,-2)/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/-1, -1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/1, 1/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-1.e0,2.e0), (-1,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/1, 1/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-1, 0, -1, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,-3.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-1 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(4)=&
          &(/(-1.e0,1.e0), (0.e0,0.e0), (-1.e0,0.e0), (0,0)/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/1, 0, 1, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr1_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/-3, -3/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/(-3.e0,-9.e0), (-3,0)/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/9, 9/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/0, 0/),(/2,1/)))! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zussm(blas_colmajor,transT,pone,alpha,A,y,nr,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2)=(/(-3.e0,9.e0), (-3,0)/)! reference x 
      COMPLEX*16 :: cy(2)=(/9, 9/)! reference cy after 
      COMPLEX*16 :: y(2)=(/0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=n"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_n_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=t"
! A =
! 1 0
! 3 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 3, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-12, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL ussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_t_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix2_iy2(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 ussv alpha=-3 beta= 1 incx=2 incy=2 trans=c"
! A =
! 1 0
! 0 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=2
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(2)=(/1, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(2)=(/1, 2/)
      COMPLEX*16 :: VA(2)=(/1, 1/)
      COMPLEX*16 :: x(4)=&
          &(/-3, 0, -3, 0/)! reference x 
      COMPLEX*16 :: cy(4)=&
          &(/9, 0, 9, 0/)! reference cy after 
      COMPLEX*16 :: y(4)=&
          &(/0, 0, 0, 0/)! y 

      y=x
      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_triangular,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zussv(transT,alpha,A,y,incx,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_ussv_2_c_anr3_bp1_ix2_iy2 
! 
      SUBROUTINE tz_sl_de_usmm_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 2+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (2.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,0.e0), (12,3)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_t_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 0+1i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,1.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,3.e0), (6,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_t_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_c_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+4i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,4.e0), (1,0)/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(6.e0,-12.e0), (6,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_c_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_n_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      INTEGER(KIND=RSB_IDX_KIND) :: K(2)=(/1, 1/)! K
      INTEGER(KIND=RSB_IDX_KIND) :: L(2)=(/1, 1/)! L
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/4, 6/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_variable_block_begin(nr,nc,K,L,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL zuscr_insert_block(A,VA(1:),pone,pone,IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(2:),pone,pone,IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_insert_block(A,VA(3:),pone,pone,IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_n_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_t_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/6, 4/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_t_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_c_ap1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha= 1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 1, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/5, 4/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_c_ap1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_n_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/2, 0/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_n_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_t_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1 0
! 2 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/1, 2, 1/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/0, 2/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_t_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_c_anr1_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-1
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-1 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(2.e0,2.e0), (2,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_col(A,mone,nnz,VA,IA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_c_anr1_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_n_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1+0i 0+0i
! 0+2i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,2.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(0.e0,0.e0), (0,-6)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL zuscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entries(A,nnz,VA,IA,JA,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_n_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_t_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=t"
! A =
! 1+0i 0+0i
! 0+6i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,6.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(0.e0,-18.e0), (0,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_t_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE tz_sl_de_usmm_2_c_anr3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_conj_trans 
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      INTEGER(KIND=RSB_IDX_KIND) :: ldX=2
      INTEGER(KIND=RSB_IDX_KIND) :: ldY=2
      COMPLEX*16 :: alpha=-3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=z dims=2x2 sym=l diag=e blocks=&
          &1x1 usmm alpha=-3 beta= 1 incx=1 incy=1 trans=c"
! A =
! 1+0i 0+0i
! 0+3i 1+0i

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      COMPLEX*16 :: VA(3)=&
          &(/(1.e0,0.e0), (0.e0,3.e0), (1,0)/)
      COMPLEX*16 :: x(2,1)=(reshape((/1, 1/),(/2,1/)))! reference x 
      COMPLEX*16 :: cy(2,1)=(reshape((/(0.e0,9.e0), (0,0)/),(/2,1/)))! reference cy after 
      COMPLEX*16 :: y(2,1)=(reshape((/3, 3/),(/2,1/)))! y will be overwritten

      errval=0
      CALL BLAS_zuscr_block_begin(pone,pone,nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(1:),pone,pone,IA(1:),JA(1:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(2:),pone,pone,IA(2:),JA(2:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zuscr_insert_clique(A,pone,pone,VA(3:),pone,pone,IA(3:),JA(3:),istat)
      IF(istat.NE.0)GOTO 9997
      CALL zuscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL BLAS_zusmm(blas_colmajor,transT,1,alpha,A,x,ldX,y,ldY,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i,1).NE.cy(i,1))PRINT*,LCS," is not ok"
        IF(y(i,1).NE.cy(i,1))errval=-1
        IF(y(i,1).NE.cy(i,1))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE tz_sl_de_usmm_2_c_anr3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy1(errval)
      USE blas_sparse
      USE rsb ! for RSB_IDX_KIND
      IMPLICIT NONE
      INTEGER::errval,istat=0,i
      INTEGER(KIND=RSB_IDX_KIND)::mone=-1,pone=+1
      INTEGER::A
      INTEGER::transT=blas_no_trans
      INTEGER(KIND=RSB_IDX_KIND) :: incx=1
      INTEGER(KIND=RSB_IDX_KIND) :: incy=1
      REAL*4 :: alpha=3
      CHARACTER(LEN=*),PARAMETER :: LCS = "&
       &type=s dims=2x2 sym=s diag=e blocks=&
          &1x1 usmv alpha= 3 beta= 1 incx=1 incy=1 trans=n"
! A =
! 1 0
! 1 1

      ! declaration of VA,IA,JA 
      INTEGER(KIND=RSB_IDX_KIND) :: nnz=3
      INTEGER(KIND=RSB_IDX_KIND) :: nr=2
      INTEGER(KIND=RSB_IDX_KIND) :: nc=2
      INTEGER(KIND=RSB_IDX_KIND) :: IA(3)=&
          &(/1, 2, 2/)
      INTEGER(KIND=RSB_IDX_KIND) :: JA(3)=&
          &(/1, 1, 2/)
      REAL*4 :: VA(3)=&
          &(/1, 1, 1/)
      REAL*4 :: x(2)=(/1, 1/)! reference x 
      REAL*4 :: cy(2)=(/9, 9/)! reference cy after 
      REAL*4 :: y(2)=(/3, 3/)! y will be overwritten

      errval=0
      CALL suscr_begin(nr,nc,A,errval)
      IF(errval.NE.0)GOTO 9999
      CALL ussp(A,blas_lower_symmetric,istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_row(A,mone,nnz,VA,JA,istat)
      IF(istat.EQ.0)THEN
        istat=-1;GOTO 9997;
      ELSE
        istat=0;
      ENDIF
      CALL uscr_insert_entry(A,VA(1),IA(1),JA(1),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(2),IA(2),JA(2),istat)
      IF(istat.NE.0)GOTO 9997
      CALL uscr_insert_entry(A,VA(3),IA(3),JA(3),istat)
      IF(istat.NE.0)GOTO 9997
      CALL suscr_end(A,istat)
      IF(istat.NE.0)GOTO 9997
      CALL usmv(transT,alpha,A,x,incx,y,incy,istat)
      IF(istat.NE.0)GOTO 9997
      DO i=1,2
        IF(y(i).NE.cy(i))PRINT*,LCS," is not ok"
        IF(y(i).NE.cy(i))errval=-1
        IF(y(i).NE.cy(i))GOTO 9997
      ENDDO
      PRINT*,LCS," is ok"
9997      IF(istat.NE.0)errval=-1
      CALL usds(A,istat)
      IF(istat.NE.0)errval=-1
9999      CONTINUE
      end SUBROUTINE ts_ss_de_usmv_2_n_ap3_bp1_ix1_iy1 
! 
      SUBROUTINE ts_ss_de_usmv_2_t_ap3_bp1_ix1_iy1(errval)
   