/* state.c generated by valac 0.38.8, the Vala compiler
 * generated from state.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define KKC_TYPE_STATE (kkc_state_get_type ())
#define KKC_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE, KkcState))
#define KKC_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE, KkcStateClass))
#define KKC_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE))
#define KKC_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE))
#define KKC_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE, KkcStateClass))

typedef struct _KkcState KkcState;
typedef struct _KkcStateClass KkcStateClass;
typedef struct _KkcStatePrivate KkcStatePrivate;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;

#define KKC_TYPE_SEGMENT_LIST (kkc_segment_list_get_type ())
#define KKC_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentList))
#define KKC_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))
#define KKC_IS_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_LIST))
#define KKC_IS_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT_LIST))
#define KKC_SEGMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))

typedef struct _KkcSegmentList KkcSegmentList;
typedef struct _KkcSegmentListClass KkcSegmentListClass;

#define KKC_TYPE_CANDIDATE_LIST (kkc_candidate_list_get_type ())
#define KKC_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateList))
#define KKC_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))
#define KKC_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE_LIST))
#define KKC_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE_LIST))
#define KKC_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))

typedef struct _KkcCandidateList KkcCandidateList;
typedef struct _KkcCandidateListClass KkcCandidateListClass;

#define KKC_TYPE_DICTIONARY_LIST (kkc_dictionary_list_get_type ())
#define KKC_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryList))
#define KKC_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))
#define KKC_IS_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY_LIST))
#define KKC_IS_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DICTIONARY_LIST))
#define KKC_DICTIONARY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))

typedef struct _KkcDictionaryList KkcDictionaryList;
typedef struct _KkcDictionaryListClass KkcDictionaryListClass;

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_INPUT_MODE (kkc_input_mode_get_type ())

#define KKC_TYPE_RULE (kkc_rule_get_type ())
#define KKC_RULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE, KkcRule))
#define KKC_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE, KkcRuleClass))
#define KKC_IS_RULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE))
#define KKC_IS_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE))
#define KKC_RULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE, KkcRuleClass))

typedef struct _KkcRule KkcRule;
typedef struct _KkcRuleClass KkcRuleClass;
enum  {
	KKC_STATE_0_PROPERTY,
	KKC_STATE_INPUT_MODE_PROPERTY,
	KKC_STATE_INPUT_CURSOR_POS_PROPERTY,
	KKC_STATE_INPUT_CURSOR_WIDTH_PROPERTY,
	KKC_STATE_PUNCTUATION_STYLE_PROPERTY,
	KKC_STATE_AUTO_CORRECT_PROPERTY,
	KKC_STATE_TYPING_RULE_PROPERTY,
	KKC_STATE_NUM_PROPERTIES
};
static GParamSpec* kkc_state_properties[KKC_STATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;

#define KKC_TYPE_ROM_KANA_CHARACTER (kkc_rom_kana_character_get_type ())
typedef struct _KkcRomKanaCharacter KkcRomKanaCharacter;

#define KKC_TYPE_KEYMAP (kkc_keymap_get_type ())
#define KKC_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEYMAP, KkcKeymap))
#define KKC_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEYMAP, KkcKeymapClass))
#define KKC_IS_KEYMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEYMAP))
#define KKC_IS_KEYMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEYMAP))
#define KKC_KEYMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEYMAP, KkcKeymapClass))

typedef struct _KkcKeymap KkcKeymap;
typedef struct _KkcKeymapClass KkcKeymapClass;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_RULE_METADATA (kkc_rule_metadata_get_type ())
#define KKC_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadata))
#define KKC_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))
#define KKC_IS_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE_METADATA))
#define KKC_IS_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE_METADATA))
#define KKC_RULE_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))

typedef struct _KkcRuleMetadata KkcRuleMetadata;
typedef struct _KkcRuleMetadataClass KkcRuleMetadataClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;

#define KKC_TYPE_DICTIONARY_CALLBACK_RETURN (kkc_dictionary_callback_return_get_type ())

#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SEGMENT_DICTIONARY (kkc_segment_dictionary_get_type ())
#define KKC_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionary))
#define KKC_IS_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_DICTIONARY))
#define KKC_SEGMENT_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionaryIface))

typedef struct _KkcSegmentDictionary KkcSegmentDictionary;
typedef struct _KkcSegmentDictionaryIface KkcSegmentDictionaryIface;

#define KKC_TYPE_PREFIX_ENTRY (kkc_prefix_entry_get_type ())
typedef struct _KkcPrefixEntry KkcPrefixEntry;

#define KKC_TYPE_SENTENCE_DICTIONARY (kkc_sentence_dictionary_get_type ())
#define KKC_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionary))
#define KKC_IS_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SENTENCE_DICTIONARY))
#define KKC_SENTENCE_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionaryIface))

typedef struct _KkcSentenceDictionary KkcSentenceDictionary;
typedef struct _KkcSentenceDictionaryIface KkcSentenceDictionaryIface;
#define _kkc_prefix_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_prefix_entry_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define KKC_TYPE_STATE_HANDLER (kkc_state_handler_get_type ())
#define KKC_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandler))
#define KKC_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))
#define KKC_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE_HANDLER))
#define KKC_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE_HANDLER))
#define KKC_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))

typedef struct _KkcStateHandler KkcStateHandler;
typedef struct _KkcStateHandlerClass KkcStateHandlerClass;

#define KKC_TYPE_INITIAL_STATE_HANDLER (kkc_initial_state_handler_get_type ())
#define KKC_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandler))
#define KKC_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))
#define KKC_IS_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_IS_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))

typedef struct _KkcInitialStateHandler KkcInitialStateHandler;
typedef struct _KkcInitialStateHandlerClass KkcInitialStateHandlerClass;

#define KKC_TYPE_KEY_EVENT_FILTER (kkc_key_event_filter_get_type ())
#define KKC_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilter))
#define KKC_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))
#define KKC_IS_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_IS_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_KEY_EVENT_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))

typedef struct _KkcKeyEventFilter KkcKeyEventFilter;
typedef struct _KkcKeyEventFilterClass KkcKeyEventFilterClass;

#define KKC_TYPE_TEMPLATE (kkc_template_get_type ())
#define KKC_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TEMPLATE, KkcTemplate))
#define KKC_IS_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TEMPLATE))
#define KKC_TEMPLATE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_TEMPLATE, KkcTemplateIface))

typedef struct _KkcTemplate KkcTemplate;
typedef struct _KkcTemplateIface KkcTemplateIface;

#define KKC_TYPE_SIMPLE_TEMPLATE (kkc_simple_template_get_type ())
#define KKC_SIMPLE_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SIMPLE_TEMPLATE, KkcSimpleTemplate))
#define KKC_SIMPLE_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SIMPLE_TEMPLATE, KkcSimpleTemplateClass))
#define KKC_IS_SIMPLE_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SIMPLE_TEMPLATE))
#define KKC_IS_SIMPLE_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SIMPLE_TEMPLATE))
#define KKC_SIMPLE_TEMPLATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SIMPLE_TEMPLATE, KkcSimpleTemplateClass))

typedef struct _KkcSimpleTemplate KkcSimpleTemplate;
typedef struct _KkcSimpleTemplateClass KkcSimpleTemplateClass;

#define KKC_TYPE_OKURIGANA_TEMPLATE (kkc_okurigana_template_get_type ())
#define KKC_OKURIGANA_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_OKURIGANA_TEMPLATE, KkcOkuriganaTemplate))
#define KKC_OKURIGANA_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_OKURIGANA_TEMPLATE, KkcOkuriganaTemplateClass))
#define KKC_IS_OKURIGANA_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_OKURIGANA_TEMPLATE))
#define KKC_IS_OKURIGANA_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_OKURIGANA_TEMPLATE))
#define KKC_OKURIGANA_TEMPLATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_OKURIGANA_TEMPLATE, KkcOkuriganaTemplateClass))

typedef struct _KkcOkuriganaTemplate KkcOkuriganaTemplate;
typedef struct _KkcOkuriganaTemplateClass KkcOkuriganaTemplateClass;
typedef struct _Block6Data Block6Data;

#define KKC_TYPE_USER_DICTIONARY (kkc_user_dictionary_get_type ())
#define KKC_USER_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_USER_DICTIONARY, KkcUserDictionary))
#define KKC_USER_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_USER_DICTIONARY, KkcUserDictionaryClass))
#define KKC_IS_USER_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_USER_DICTIONARY))
#define KKC_IS_USER_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_USER_DICTIONARY))
#define KKC_USER_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_USER_DICTIONARY, KkcUserDictionaryClass))

typedef struct _KkcUserDictionary KkcUserDictionary;
typedef struct _KkcUserDictionaryClass KkcUserDictionaryClass;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;
#define _kkc_language_model_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_language_model_entry_free (var), NULL)))

#define KKC_TYPE_NUMERIC_TEMPLATE (kkc_numeric_template_get_type ())
#define KKC_NUMERIC_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_NUMERIC_TEMPLATE, KkcNumericTemplate))
#define KKC_NUMERIC_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_NUMERIC_TEMPLATE, KkcNumericTemplateClass))
#define KKC_IS_NUMERIC_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_NUMERIC_TEMPLATE))
#define KKC_IS_NUMERIC_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_NUMERIC_TEMPLATE))
#define KKC_NUMERIC_TEMPLATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_NUMERIC_TEMPLATE, KkcNumericTemplateClass))

typedef struct _KkcNumericTemplate KkcNumericTemplate;
typedef struct _KkcNumericTemplateClass KkcNumericTemplateClass;
typedef struct _KkcSegmentPrivate KkcSegmentPrivate;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

#define KKC_TYPE_PUNCTUATION_STYLE (kkc_punctuation_style_get_type ())
typedef struct _KkcRulePrivate KkcRulePrivate;

#define KKC_TYPE_MAP_FILE (kkc_map_file_get_type ())
#define KKC_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAP_FILE, KkcMapFile))
#define KKC_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAP_FILE, KkcMapFileClass))
#define KKC_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAP_FILE))
#define KKC_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAP_FILE))
#define KKC_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAP_FILE, KkcMapFileClass))

typedef struct _KkcMapFile KkcMapFile;
typedef struct _KkcMapFileClass KkcMapFileClass;

#define KKC_TYPE_ROM_KANA_MAP_FILE (kkc_rom_kana_map_file_get_type ())
#define KKC_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFile))
#define KKC_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))
#define KKC_IS_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_IS_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_ROM_KANA_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))

typedef struct _KkcRomKanaMapFile KkcRomKanaMapFile;
typedef struct _KkcRomKanaMapFileClass KkcRomKanaMapFileClass;
enum  {
	KKC_STATE_REQUEST_SELECTION_TEXT_SIGNAL,
	KKC_STATE_NUM_SIGNALS
};
static guint kkc_state_signals[KKC_STATE_NUM_SIGNALS] = {0};

#define KKC_TYPE_COMMAND_HANDLER (kkc_command_handler_get_type ())
#define KKC_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_COMMAND_HANDLER, KkcCommandHandler))
#define KKC_IS_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_COMMAND_HANDLER))
#define KKC_COMMAND_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_COMMAND_HANDLER, KkcCommandHandlerIface))

typedef struct _KkcCommandHandler KkcCommandHandler;
typedef struct _KkcCommandHandlerIface KkcCommandHandlerIface;

#define KKC_TYPE_CALLBACK_COMMAND_HANDLER (kkc_callback_command_handler_get_type ())
#define KKC_CALLBACK_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CALLBACK_COMMAND_HANDLER, KkcCallbackCommandHandler))
#define KKC_CALLBACK_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CALLBACK_COMMAND_HANDLER, KkcCallbackCommandHandlerClass))
#define KKC_IS_CALLBACK_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CALLBACK_COMMAND_HANDLER))
#define KKC_IS_CALLBACK_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CALLBACK_COMMAND_HANDLER))
#define KKC_CALLBACK_COMMAND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CALLBACK_COMMAND_HANDLER, KkcCallbackCommandHandlerClass))

typedef struct _KkcCallbackCommandHandler KkcCallbackCommandHandler;
typedef struct _KkcCallbackCommandHandlerClass KkcCallbackCommandHandlerClass;
typedef struct _KkcCallbackCommandHandlerPrivate KkcCallbackCommandHandlerPrivate;
enum  {
	KKC_CALLBACK_COMMAND_HANDLER_0_PROPERTY,
	KKC_CALLBACK_COMMAND_HANDLER_NUM_PROPERTIES
};
static GParamSpec* kkc_callback_command_handler_properties[KKC_CALLBACK_COMMAND_HANDLER_NUM_PROPERTIES];
typedef struct _KkcStateHandlerPrivate KkcStateHandlerPrivate;
enum  {
	KKC_STATE_HANDLER_0_PROPERTY,
	KKC_STATE_HANDLER_NUM_PROPERTIES
};
static GParamSpec* kkc_state_handler_properties[KKC_STATE_HANDLER_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcState {
	GObject parent_instance;
	KkcStatePrivate * priv;
	GType handler_type;
	KkcLanguageModel* model;
	KkcDecoder* decoder;
	KkcSegmentList* segments;
	KkcCandidateList* candidates;
	KkcDictionaryList* dictionaries;
	KkcRomKanaConverter* rom_kana_converter;
	KkcRomKanaCharacterList* input_characters;
	gint input_characters_cursor_pos;
	GString* selection;
	GString* output;
	gboolean quoted;
	KkcKeyEvent* this_command_key;
	KkcKeyEvent* last_command_key;
	gchar* overriding_input;
	GeeIterator* completion_iterator;
};

struct _KkcStateClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

typedef enum  {
	KKC_INPUT_MODE_HIRAGANA = KKC_KANA_MODE_HIRAGANA,
	KKC_INPUT_MODE_KATAKANA = KKC_KANA_MODE_KATAKANA,
	KKC_INPUT_MODE_HANKAKU_KATAKANA = KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_INPUT_MODE_LATIN = KKC_KANA_MODE_LATIN,
	KKC_INPUT_MODE_WIDE_LATIN = KKC_KANA_MODE_WIDE_LATIN,
	KKC_INPUT_MODE_DIRECT
} KkcInputMode;

struct _KkcStatePrivate {
	KkcInputMode _input_mode;
	gboolean segments_changed;
	gboolean latin_conversion_upper;
	GeeArrayList* completion;
	KkcRule* _typing_rule;
};

struct _KkcRomKanaCharacter {
	gchar* output;
	gchar* input;
};

struct _Block4Data {
	int _ref_count_;
	KkcState* self;
	KkcCandidate* candidate;
};

typedef enum  {
	KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE,
	KKC_DICTIONARY_CALLBACK_RETURN_REMOVE
} KkcDictionaryCallbackReturn;

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

typedef KkcDictionaryCallbackReturn (*KkcDictionaryListDictionaryCallback) (KkcDictionary* dictionary, void* user_data);
struct _KkcSegmentDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_candidates) (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
	gchar** (*complete) (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
	gboolean (*purge_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
};

struct _KkcPrefixEntry {
	gint offset;
	gchar** sequence;
	gint sequence_length1;
	gint _sequence_size_;
};

struct _KkcSentenceDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_constraint) (KkcSentenceDictionary* self, const gchar* input, gint** constraint, int* constraint_length1);
	gboolean (*lookup_phrase) (KkcSentenceDictionary* self, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
	gboolean (*select_segments) (KkcSentenceDictionary* self, KkcSegment** input, int input_length1);
};

struct _Block5Data {
	int _ref_count_;
	KkcState* self;
	GeeList* prefixes;
};

struct _KkcTemplateIface {
	GTypeInterface parent_iface;
	gchar* (*expand) (KkcTemplate* self, const gchar* text);
	const gchar* (*get_source) (KkcTemplate* self);
	void (*set_source) (KkcTemplate* self, const gchar* value);
	gboolean (*get_okuri) (KkcTemplate* self);
	void (*set_okuri) (KkcTemplate* self, gboolean value);
};

struct _Block6Data {
	int _ref_count_;
	KkcState* self;
	gchar* normalized_input;
	gchar* _result_;
};

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcSegment {
	GObject parent_instance;
	KkcSegmentPrivate * priv;
	KkcSegment* next;
};

struct _KkcSegmentClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	KkcState* self;
	KkcTemplate* template;
	gboolean user;
};

struct _Block8Data {
	int _ref_count_;
	KkcState* self;
	gchar* input;
};

struct _Block9Data {
	int _ref_count_;
	KkcState* self;
	KkcCandidate* candidate;
};

struct _Block10Data {
	int _ref_count_;
	KkcState* self;
	gchar* input;
};

typedef enum  {
	KKC_PUNCTUATION_STYLE_JA_JA,
	KKC_PUNCTUATION_STYLE_EN_EN,
	KKC_PUNCTUATION_STYLE_JA_EN,
	KKC_PUNCTUATION_STYLE_EN_JA
} KkcPunctuationStyle;

struct _KkcRule {
	GObject parent_instance;
	KkcRulePrivate * priv;
	KkcRomKanaMapFile* rom_kana;
};

struct _KkcRuleClass {
	GObjectClass parent_class;
};

struct _KkcCommandHandlerIface {
	GTypeInterface parent_iface;
	gboolean (*call) (KkcCommandHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
};

typedef gboolean (*KkcCommandCallback) (const gchar* command, KkcState* state, KkcKeyEvent* key, void* user_data);
struct _KkcCallbackCommandHandler {
	GObject parent_instance;
	KkcCallbackCommandHandlerPrivate * priv;
};

struct _KkcCallbackCommandHandlerClass {
	GObjectClass parent_class;
};

struct _KkcCallbackCommandHandlerPrivate {
	KkcCommandCallback cb;
	gpointer cb_target;
};

struct _KkcStateHandler {
	GObject parent_instance;
	KkcStateHandlerPrivate * priv;
};

struct _KkcStateHandlerClass {
	GObjectClass parent_class;
	gboolean (*default_command_callback) (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
	gboolean (*process_key_event) (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
};

struct _KkcStateHandlerPrivate {
	GeeMap* command_handlers;
	KkcCommandHandler* default_command_handler;
};


static gpointer kkc_state_parent_class = NULL;
static gpointer kkc_callback_command_handler_parent_class = NULL;
static KkcCommandHandlerIface * kkc_callback_command_handler_kkc_command_handler_parent_iface = NULL;
static gpointer kkc_state_handler_parent_class = NULL;

#define KKC_MIN_UNIGRAM_COST (-5.0)
#define KKC_DECODER_MAX_DISTANCE 2.0
#define KKC_DECODER_MIN_PATH_COST (-3.0)
#define KKC_DECODER_NBEST 20
GType kkc_state_get_type (void) G_GNUC_CONST;
GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_list_get_type (void) G_GNUC_CONST;
GType kkc_dictionary_list_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
GType kkc_key_event_get_type (void) G_GNUC_CONST;
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
GType kkc_input_mode_get_type (void) G_GNUC_CONST;
GType kkc_rule_get_type (void) G_GNUC_CONST;
#define KKC_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_STATE, KkcStatePrivate))
void kkc_state_reset (KkcState* self);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_new (void);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_construct (GType object_type);
void kkc_state_finish_input_editing (KkcState* self);
gboolean kkc_rom_kana_converter_flush_partial (KkcRomKanaConverter* self);
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other);
KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self);
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other);
void kkc_rom_kana_converter_reset (KkcRomKanaConverter* self);
void kkc_state_convert_segment_by_kana_mode (KkcState* self, KkcKanaMode mode);
gint kkc_segment_list_get_offset (KkcSegmentList* self, gint index);
gint kkc_segment_list_get_cursor_pos (KkcSegmentList* self);
GType kkc_segment_get_type (void) G_GNUC_CONST;
KkcSegment* kkc_segment_list_get (KkcSegmentList* self, gint index);
const gchar* kkc_segment_get_input (KkcSegment* self);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_slice (KkcRomKanaCharacterList* self, gint start_char_pos, gint stop_char_pos);
gchar* kkc_state_convert_rom_kana_characters_by_kana_mode (KkcState* self, KkcRomKanaCharacterList* characters, KkcKanaMode mode);
void kkc_segment_set_output (KkcSegment* self, const gchar* value);
static void kkc_state_update_latin_conversion_case (KkcState* self, KkcKanaMode mode);
gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode);
gchar* kkc_rom_kana_character_list_get_output (KkcRomKanaCharacterList* self);
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self);
gchar* kkc_state_lookup_key (KkcState* self, KkcKeyEvent* key);
gchar* kkc_state_get_input (KkcState* self);
gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self);
GType kkc_rom_kana_character_get_type (void) G_GNUC_CONST;
KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self);
void kkc_rom_kana_character_free (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest);
void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result);
const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self);
GType kkc_keymap_get_type (void) G_GNUC_CONST;
KkcKeymap* kkc_rule_get_keymap (KkcRule* self, KkcInputMode mode);
KkcInputMode kkc_state_get_input_mode (KkcState* self);
gchar* kkc_keymap_lookup_key (KkcKeymap* self, KkcKeyEvent* key);
KkcState* kkc_state_new (KkcLanguageModel* model, KkcDictionaryList* dictionaries);
KkcState* kkc_state_construct (GType object_type, KkcLanguageModel* model, KkcDictionaryList* dictionaries);
KkcDecoder* kkc_decoder_create (KkcLanguageModel* model);
KkcSegmentList* kkc_segment_list_new (void);
KkcSegmentList* kkc_segment_list_construct (GType object_type);
KkcCandidateList* kkc_candidate_list_new (guint page_start, guint page_size, gboolean round);
KkcCandidateList* kkc_candidate_list_construct (GType object_type, guint page_start, guint page_size, gboolean round);
void kkc_candidate_list_set_round (KkcCandidateList* self, gboolean value);
static void kkc_state_candidates_cursor_pos_changed (KkcState* self, GObject* s, GParamSpec* p);
static void _kkc_state_candidates_cursor_pos_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType kkc_candidate_get_type (void) G_GNUC_CONST;
static void kkc_state_candidates_selected (KkcState* self, KkcCandidate* candidate);
static void _kkc_state_candidates_selected_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
KkcRomKanaConverter* kkc_rom_kana_converter_new (void);
KkcRomKanaConverter* kkc_rom_kana_converter_construct (GType object_type);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_rule_metadata_get_type (void) G_GNUC_CONST;
KkcRuleMetadata* kkc_rule_metadata_find (const gchar* name);
KkcRule* kkc_rule_new (KkcRuleMetadata* metadata, GError** error);
KkcRule* kkc_rule_construct (GType object_type, KkcRuleMetadata* metadata, GError** error);
gint kkc_candidate_list_get_cursor_pos (KkcCandidateList* self);
KkcCandidate* kkc_candidate_list_get (KkcCandidateList* self, gint index);
const gchar* kkc_segment_get_output (KkcSegment* self);
const gchar* kkc_candidate_get_output (KkcCandidate* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GType kkc_dictionary_callback_return_get_type (void) G_GNUC_CONST;
GType kkc_dictionary_get_type (void) G_GNUC_CONST;
void kkc_dictionary_list_call (KkcDictionaryList* self, GType* type, KkcDictionaryListDictionaryCallback callback, void* callback_target);
GType kkc_segment_dictionary_get_type (void) G_GNUC_CONST;
static KkcDictionaryCallbackReturn __lambda10_ (Block4Data* _data4_, KkcDictionary* dictionary);
gboolean kkc_segment_dictionary_select_candidate (KkcSegmentDictionary* self, KkcCandidate* candidate);
static KkcDictionaryCallbackReturn ___lambda10__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
GType kkc_prefix_entry_get_type (void) G_GNUC_CONST;
KkcPrefixEntry* kkc_prefix_entry_dup (const KkcPrefixEntry* self);
void kkc_prefix_entry_free (KkcPrefixEntry* self);
void kkc_prefix_entry_copy (const KkcPrefixEntry* self, KkcPrefixEntry* dest);
void kkc_prefix_entry_destroy (KkcPrefixEntry* self);
static void kkc_state_select_sentence_for_dictionary (KkcState* self, KkcDictionary* dictionary, GeeList* prefixes);
GType kkc_sentence_dictionary_get_type (void) G_GNUC_CONST;
KkcSegment** kkc_segment_list_to_array (KkcSegmentList* self, int* result_length1);
static KkcSegment** _vala_array_dup1 (KkcSegment** self, int length);
gboolean kkc_sentence_dictionary_select_segments (KkcSentenceDictionary* self, KkcSegment** input, int input_length1);
void kkc_state_select_sentence (KkcState* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
gint kkc_segment_list_get_size (KkcSegmentList* self);
GeeList* kkc_sequence_utils_enumerate_prefixes (gchar** sequence, int sequence_length1, gint min, gint max);
static KkcDictionaryCallbackReturn __lambda16_ (Block5Data* _data5_, KkcDictionary* dictionary);
static KkcDictionaryCallbackReturn ___lambda16__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
GType kkc_state_handler_get_type (void) G_GNUC_CONST;
GType kkc_initial_state_handler_get_type (void) G_GNUC_CONST;
GType kkc_key_event_filter_get_type (void) G_GNUC_CONST;
KkcKeyEventFilter* kkc_rule_get_filter (KkcRule* self);
void kkc_key_event_filter_reset (KkcKeyEventFilter* self);
void kkc_segment_list_clear (KkcSegmentList* self);
void kkc_candidate_list_clear (KkcCandidateList* self);
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self);
static gchar* kkc_state_lookup_single_for_dictionary (KkcState* self, KkcDictionary* dictionary, const gchar* input);
GType kkc_template_get_type (void) G_GNUC_CONST;
KkcSimpleTemplate* kkc_simple_template_new (const gchar* source);
KkcSimpleTemplate* kkc_simple_template_construct (GType object_type, const gchar* source);
GType kkc_simple_template_get_type (void) G_GNUC_CONST;
gboolean kkc_segment_dictionary_lookup_candidates (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
const gchar* kkc_template_get_source (KkcTemplate* self);
gboolean kkc_template_get_okuri (KkcTemplate* self);
gchar* kkc_template_expand (KkcTemplate* self, const gchar* text);
const gchar* kkc_candidate_get_text (KkcCandidate* self);
KkcOkuriganaTemplate* kkc_okurigana_template_new (const gchar* source, gint pos);
KkcOkuriganaTemplate* kkc_okurigana_template_construct (GType object_type, const gchar* source, gint pos);
GType kkc_okurigana_template_get_type (void) G_GNUC_CONST;
gchar* kkc_state_lookup_single (KkcState* self, const gchar* input);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
gchar* kkc_rom_kana_utils_normalize (const gchar* input);
static KkcDictionaryCallbackReturn __lambda17_ (Block6Data* _data6_, KkcDictionary* dictionary);
GType kkc_user_dictionary_get_type (void) G_GNUC_CONST;
static KkcDictionaryCallbackReturn ___lambda17__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GeeCollection* kkc_language_model_unigram_entries (KkcLanguageModel* self, const gchar* input);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
gdouble kkc_unigram_language_model_unigram_cost (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
static KkcDictionaryCallbackReturn __lambda18_ (Block6Data* _data6_, KkcDictionary* dictionary);
static KkcDictionaryCallbackReturn ___lambda18__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
void kkc_state_lookup (KkcState* self, KkcSegment* segment);
KkcCandidate* kkc_candidate_new (const gchar* midasi, gboolean okuri, const gchar* text, const gchar* annotation, const gchar* output);
KkcCandidate* kkc_candidate_construct (GType object_type, const gchar* midasi, gboolean okuri, const gchar* text, const gchar* annotation, const gchar* output);
gboolean kkc_candidate_list_add (KkcCandidateList* self, KkcCandidate* candidate);
static void kkc_state_lookup_template (KkcState* self, KkcTemplate* template, gboolean user);
KkcNumericTemplate* kkc_numeric_template_new (const gchar* source);
KkcNumericTemplate* kkc_numeric_template_construct (GType object_type, const gchar* source);
GType kkc_numeric_template_get_type (void) G_GNUC_CONST;
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
KkcSegment** kkc_decoder_decode_with_costs (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, gdouble max_distance, gdouble min_path_cost, int* result_length1);
gboolean kkc_candidate_list_contains (KkcCandidateList* self, KkcCandidate* candidate);
gboolean kkc_candidate_list_add_all (KkcCandidateList* self, KkcCandidateList* other);
static void kkc_state_lookup_template_for_dictionary (KkcState* self, KkcDictionary* dictionary, KkcTemplate* template);
gchar* kkc_expression_eval (const gchar* text);
void kkc_candidate_set_output (KkcCandidate* self, const gchar* value);
const gchar* kkc_candidate_get_annotation (KkcCandidate* self);
void kkc_candidate_set_annotation (KkcCandidate* self, const gchar* value);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static KkcDictionaryCallbackReturn __lambda12_ (Block7Data* _data7_, KkcDictionary* dictionary);
static KkcDictionaryCallbackReturn ___lambda12__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
static void kkc_state_merge_possible_okurigana_segments (KkcState* self, gint start);
void kkc_segment_list_add (KkcSegmentList* self, KkcSegment* segment);
gboolean kkc_rom_kana_utils_is_hiragana (const gchar* str);
void kkc_segment_set_input (KkcSegment* self, const gchar* value);
void kkc_state_convert_sentence (KkcState* self, const gchar* input, gint* constraint, int constraint_length1);
static gint* _vala_array_dup2 (gint* self, int length);
KkcSegment** kkc_decoder_decode (KkcDecoder* self, const gchar* input, gint nbest, gint* constraint, int constraint_length1, int* result_length1);
void kkc_segment_list_set_segments (KkcSegmentList* self, KkcSegment* segment);
static void kkc_state_apply_constraint (KkcState* self, const gchar* input);
static void kkc_state_apply_phrase (KkcState* self);
static void kkc_state_apply_constraint_for_dictionary (KkcState* self, KkcDictionary* dictionary, const gchar* input);
gchar** kkc_utils_split_utf8 (const gchar* str, int* result_length1);
gboolean kkc_sentence_dictionary_lookup_constraint (KkcSentenceDictionary* self, const gchar* input, gint** constraint, int* constraint_length1);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static KkcDictionaryCallbackReturn __lambda14_ (Block8Data* _data8_, KkcDictionary* dictionary);
static KkcDictionaryCallbackReturn ___lambda14__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
static void kkc_state_apply_phrase_for_dictionary (KkcState* self, KkcDictionary* dictionary);
gboolean kkc_sentence_dictionary_lookup_phrase (KkcSentenceDictionary* self, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
static KkcDictionaryCallbackReturn __lambda15_ (KkcState* self, KkcDictionary* dictionary);
static KkcDictionaryCallbackReturn ___lambda15__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
void kkc_state_resize_segment (KkcState* self, gint amount);
static void _vala_array_add6 (gint* * array, int* length, int* size, gint value);
static void _vala_array_add7 (gint* * array, int* length, int* size, gint value);
gchar* kkc_segment_list_get_input (KkcSegmentList* self);
void kkc_segment_list_set_cursor_pos (KkcSegmentList* self, gint value);
void kkc_state_purge_candidate (KkcState* self, KkcCandidate* candidate);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static KkcDictionaryCallbackReturn __lambda13_ (Block9Data* _data9_, KkcDictionary* dictionary);
gboolean kkc_segment_dictionary_purge_candidate (KkcSegmentDictionary* self, KkcCandidate* candidate);
static KkcDictionaryCallbackReturn ___lambda13__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
void kkc_state_completion_start (KkcState* self, const gchar* input);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static KkcDictionaryCallbackReturn __lambda11_ (Block10Data* _data10_, KkcDictionary* dictionary);
gchar** kkc_segment_dictionary_complete (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
static KkcDictionaryCallbackReturn ___lambda11__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self);
void kkc_state_set_input_mode (KkcState* self, KkcInputMode value);
void kkc_rom_kana_converter_set_kana_mode (KkcRomKanaConverter* self, KkcKanaMode value);
gint kkc_state_get_input_cursor_pos (KkcState* self);
guint kkc_state_get_input_cursor_width (KkcState* self);
GType kkc_punctuation_style_get_type (void) G_GNUC_CONST;
KkcPunctuationStyle kkc_state_get_punctuation_style (KkcState* self);
KkcPunctuationStyle kkc_rom_kana_converter_get_punctuation_style (KkcRomKanaConverter* self);
void kkc_state_set_punctuation_style (KkcState* self, KkcPunctuationStyle value);
void kkc_rom_kana_converter_set_punctuation_style (KkcRomKanaConverter* self, KkcPunctuationStyle value);
gboolean kkc_state_get_auto_correct (KkcState* self);
gboolean kkc_rom_kana_converter_get_auto_correct (KkcRomKanaConverter* self);
void kkc_state_set_auto_correct (KkcState* self, gboolean value);
void kkc_rom_kana_converter_set_auto_correct (KkcRomKanaConverter* self, gboolean value);
KkcRule* kkc_state_get_typing_rule (KkcState* self);
void kkc_state_set_typing_rule (KkcState* self, KkcRule* value);
GType kkc_map_file_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_map_file_get_type (void) G_GNUC_CONST;
void kkc_rom_kana_converter_set_rule (KkcRomKanaConverter* self, KkcRomKanaMapFile* value);
static void kkc_state_finalize (GObject * obj);
static void _vala_kkc_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_state_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType kkc_command_handler_get_type (void) G_GNUC_CONST;
gboolean kkc_command_handler_call (KkcCommandHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
GType kkc_callback_command_handler_get_type (void) G_GNUC_CONST;
#define KKC_CALLBACK_COMMAND_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_CALLBACK_COMMAND_HANDLER, KkcCallbackCommandHandlerPrivate))
KkcCallbackCommandHandler* kkc_callback_command_handler_new (KkcCommandCallback cb, void* cb_target);
KkcCallbackCommandHandler* kkc_callback_command_handler_construct (GType object_type, KkcCommandCallback cb, void* cb_target);
static gboolean kkc_callback_command_handler_real_call (KkcCommandHandler* base, const gchar* command, KkcState* state, KkcKeyEvent* key);
static void kkc_callback_command_handler_finalize (GObject * obj);
#define KKC_STATE_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_STATE_HANDLER, KkcStateHandlerPrivate))
void kkc_state_handler_register_command_handler (KkcStateHandler* self, const gchar* command, KkcCommandHandler* handler);
void kkc_state_handler_register_command_callback (KkcStateHandler* self, const gchar* command, KkcCommandCallback cb, void* cb_target);
gboolean kkc_state_handler_default_command_callback (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_state_handler_real_default_command_callback (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
gboolean kkc_state_handler_dispatch_command (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
gboolean kkc_state_handler_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_state_handler_real_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
KkcStateHandler* kkc_state_handler_construct (GType object_type);
static void kkc_state_handler_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void kkc_state_finish_input_editing (KkcState* self) {
	KkcRomKanaConverter* _tmp0_;
	gint _tmp1_;
	KkcRomKanaConverter* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	kkc_rom_kana_converter_flush_partial (_tmp0_);
	_tmp1_ = self->input_characters_cursor_pos;
	if (_tmp1_ >= 0) {
		KkcRomKanaCharacterList* _tmp2_;
		gint _tmp3_;
		KkcRomKanaConverter* _tmp4_;
		KkcRomKanaCharacterList* _tmp5_;
		KkcRomKanaCharacterList* _tmp6_;
		_tmp2_ = self->input_characters;
		_tmp3_ = self->input_characters_cursor_pos;
		_tmp4_ = self->rom_kana_converter;
		_tmp5_ = kkc_rom_kana_converter_get_produced (_tmp4_);
		_tmp6_ = _tmp5_;
		kkc_rom_kana_character_list_insert_all (_tmp2_, _tmp3_, _tmp6_);
	} else {
		KkcRomKanaCharacterList* _tmp7_;
		KkcRomKanaConverter* _tmp8_;
		KkcRomKanaCharacterList* _tmp9_;
		KkcRomKanaCharacterList* _tmp10_;
		_tmp7_ = self->input_characters;
		_tmp8_ = self->rom_kana_converter;
		_tmp9_ = kkc_rom_kana_converter_get_produced (_tmp8_);
		_tmp10_ = _tmp9_;
		kkc_rom_kana_character_list_add_all (_tmp7_, _tmp10_);
	}
	_tmp11_ = self->rom_kana_converter;
	kkc_rom_kana_converter_reset (_tmp11_);
}


void kkc_state_convert_segment_by_kana_mode (KkcState* self, KkcKanaMode mode) {
	gint start_char_pos = 0;
	KkcSegmentList* _tmp0_;
	KkcSegmentList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint stop_char_pos = 0;
	KkcSegmentList* _tmp5_;
	KkcSegmentList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	KkcSegment* _tmp9_;
	KkcSegment* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	KkcRomKanaCharacterList* characters = NULL;
	KkcRomKanaCharacterList* _tmp15_;
	KkcRomKanaCharacterList* _tmp16_;
	KkcSegmentList* _tmp17_;
	KkcSegmentList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	KkcSegment* _tmp21_;
	KkcSegment* _tmp22_;
	KkcKanaMode _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->segments;
	_tmp1_ = self->segments;
	_tmp2_ = kkc_segment_list_get_cursor_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = kkc_segment_list_get_offset (_tmp0_, _tmp3_);
	start_char_pos = _tmp4_;
	_tmp5_ = self->segments;
	_tmp6_ = self->segments;
	_tmp7_ = kkc_segment_list_get_cursor_pos (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = kkc_segment_list_get (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_segment_get_input (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_utf8_strlen (_tmp12_, (gssize) -1);
	_tmp14_ = start_char_pos + _tmp13_;
	_g_object_unref0 (_tmp10_);
	stop_char_pos = _tmp14_;
	_tmp15_ = self->input_characters;
	_tmp16_ = kkc_rom_kana_character_list_slice (_tmp15_, start_char_pos, stop_char_pos);
	characters = _tmp16_;
	_tmp17_ = self->segments;
	_tmp18_ = self->segments;
	_tmp19_ = kkc_segment_list_get_cursor_pos (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = kkc_segment_list_get (_tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = mode;
	_tmp24_ = kkc_state_convert_rom_kana_characters_by_kana_mode (self, characters, _tmp23_);
	_tmp25_ = _tmp24_;
	kkc_segment_set_output (_tmp22_, _tmp25_);
	_g_free0 (_tmp25_);
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (characters);
}


gchar* kkc_state_convert_rom_kana_characters_by_kana_mode (KkcState* self, KkcRomKanaCharacterList* characters, KkcKanaMode mode) {
	gchar* result = NULL;
	KkcKanaMode _tmp0_;
	KkcKanaMode _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (characters != NULL, NULL);
	_tmp0_ = mode;
	kkc_state_update_latin_conversion_case (self, _tmp0_);
	_tmp1_ = mode;
	switch (_tmp1_) {
		case KKC_KANA_MODE_HIRAGANA:
		case KKC_KANA_MODE_KATAKANA:
		case KKC_KANA_MODE_HANKAKU_KATAKANA:
		{
			KkcRomKanaCharacterList* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			KkcKanaMode _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp2_ = characters;
			_tmp3_ = kkc_rom_kana_character_list_get_output (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = mode;
			_tmp6_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp4_, _tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp4_);
			result = _tmp7_;
			return result;
		}
		case KKC_KANA_MODE_LATIN:
		case KKC_KANA_MODE_WIDE_LATIN:
		{
			gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			KkcKanaMode _tmp16_;
			gchar* _tmp17_;
			_tmp9_ = self->priv->latin_conversion_upper;
			if (_tmp9_) {
				KkcRomKanaCharacterList* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = characters;
				_tmp11_ = kkc_rom_kana_character_list_get_input (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_utf8_strup (_tmp12_, (gssize) -1);
				_g_free0 (_tmp8_);
				_tmp8_ = _tmp13_;
				_g_free0 (_tmp12_);
			} else {
				KkcRomKanaCharacterList* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = characters;
				_tmp15_ = kkc_rom_kana_character_list_get_input (_tmp14_);
				_g_free0 (_tmp8_);
				_tmp8_ = _tmp15_;
			}
			_tmp16_ = mode;
			_tmp17_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp8_, _tmp16_);
			result = _tmp17_;
			_g_free0 (_tmp8_);
			return result;
		}
		default:
		break;
	}
	g_return_val_if_reached (NULL);
}


static void kkc_state_update_latin_conversion_case (KkcState* self, KkcKanaMode mode) {
	gboolean _tmp0_ = FALSE;
	KkcKanaMode _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = mode;
	if (_tmp1_ == KKC_KANA_MODE_LATIN) {
		_tmp0_ = TRUE;
	} else {
		KkcKanaMode _tmp2_;
		_tmp2_ = mode;
		_tmp0_ = _tmp2_ == KKC_KANA_MODE_WIDE_LATIN;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		KkcKeyEvent* _tmp4_;
		_tmp4_ = self->last_command_key;
		if (_tmp4_ != NULL) {
			KkcKeyEvent* _tmp5_;
			_tmp5_ = self->this_command_key;
			_tmp3_ = _tmp5_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gchar* last_command = NULL;
			KkcKeyEvent* _tmp6_;
			gchar* _tmp7_;
			gchar* this_command = NULL;
			KkcKeyEvent* _tmp8_;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp6_ = self->last_command_key;
			_tmp7_ = kkc_state_lookup_key (self, _tmp6_);
			last_command = _tmp7_;
			_tmp8_ = self->this_command_key;
			_tmp9_ = kkc_state_lookup_key (self, _tmp8_);
			this_command = _tmp9_;
			_tmp10_ = last_command;
			_tmp11_ = this_command;
			if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
				gboolean _tmp12_;
				_tmp12_ = self->priv->latin_conversion_upper;
				self->priv->latin_conversion_upper = !_tmp12_;
			} else {
				self->priv->latin_conversion_upper = FALSE;
			}
			_g_free0 (this_command);
			_g_free0 (last_command);
		} else {
			self->priv->latin_conversion_upper = FALSE;
		}
	}
}


gchar* kkc_state_get_input (KkcState* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	GString* builder = NULL;
	GString* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint stop = 0;
	GString* _tmp20_;
	KkcRomKanaConverter* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->overriding_input;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->overriding_input;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	_tmp5_ = self->input_characters_cursor_pos;
	if (_tmp5_ >= 0) {
		gint _tmp6_;
		_tmp6_ = self->input_characters_cursor_pos;
		_tmp4_ = _tmp6_;
	} else {
		KkcRomKanaCharacterList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->input_characters;
		_tmp8_ = kkc_rom_kana_character_list_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	}
	stop = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gint _tmp13_;
				GString* _tmp14_;
				KkcRomKanaCharacterList* _tmp15_;
				gint _tmp16_;
				KkcRomKanaCharacter _tmp17_ = {0};
				KkcRomKanaCharacter _tmp18_;
				const gchar* _tmp19_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = stop;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = builder;
				_tmp15_ = self->input_characters;
				_tmp16_ = i;
				kkc_rom_kana_character_list_get (_tmp15_, _tmp16_, &_tmp17_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_.output;
				g_string_append (_tmp14_, _tmp19_);
				kkc_rom_kana_character_destroy (&_tmp18_);
			}
		}
	}
	_tmp20_ = builder;
	_tmp21_ = self->rom_kana_converter;
	_tmp22_ = kkc_rom_kana_converter_get_pending_output (_tmp21_);
	_tmp23_ = _tmp22_;
	g_string_append (_tmp20_, _tmp23_);
	{
		gboolean _tmp24_ = FALSE;
		_tmp24_ = TRUE;
		while (TRUE) {
			gint _tmp26_;
			KkcRomKanaCharacterList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			GString* _tmp30_;
			KkcRomKanaCharacterList* _tmp31_;
			gint _tmp32_;
			KkcRomKanaCharacter _tmp33_ = {0};
			KkcRomKanaCharacter _tmp34_;
			const gchar* _tmp35_;
			if (!_tmp24_) {
				gint _tmp25_;
				_tmp25_ = stop;
				stop = _tmp25_ + 1;
			}
			_tmp24_ = FALSE;
			_tmp26_ = stop;
			_tmp27_ = self->input_characters;
			_tmp28_ = kkc_rom_kana_character_list_get_size (_tmp27_);
			_tmp29_ = _tmp28_;
			if (!(_tmp26_ < _tmp29_)) {
				break;
			}
			_tmp30_ = builder;
			_tmp31_ = self->input_characters;
			_tmp32_ = stop;
			kkc_rom_kana_character_list_get (_tmp31_, _tmp32_, &_tmp33_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_.output;
			g_string_append (_tmp30_, _tmp35_);
			kkc_rom_kana_character_destroy (&_tmp34_);
		}
	}
	_tmp36_ = builder;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (builder);
	return result;
}


gchar* kkc_state_lookup_key (KkcState* self, KkcKeyEvent* key) {
	gchar* result = NULL;
	KkcKeymap* keymap = NULL;
	KkcRule* _tmp0_;
	KkcInputMode _tmp1_;
	KkcInputMode _tmp2_;
	KkcKeymap* _tmp3_;
	KkcKeyEvent* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	_tmp1_ = kkc_state_get_input_mode (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rule_get_keymap (_tmp0_, _tmp2_);
	keymap = _tmp3_;
	g_return_val_if_fail (keymap != NULL, NULL);
	_tmp4_ = key;
	_tmp5_ = kkc_keymap_lookup_key (keymap, _tmp4_);
	result = _tmp5_;
	_g_object_unref0 (keymap);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _kkc_state_candidates_cursor_pos_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	kkc_state_candidates_cursor_pos_changed ((KkcState*) self, _sender, pspec);
}


static void _kkc_state_candidates_selected_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	kkc_state_candidates_selected ((KkcState*) self, candidate);
}


KkcState* kkc_state_construct (GType object_type, KkcLanguageModel* model, KkcDictionaryList* dictionaries) {
	KkcState * self = NULL;
	KkcLanguageModel* _tmp0_;
	KkcLanguageModel* _tmp1_;
	KkcLanguageModel* _tmp2_;
	KkcDecoder* _tmp3_;
	KkcDictionaryList* _tmp4_;
	KkcDictionaryList* _tmp5_;
	KkcSegmentList* _tmp6_;
	KkcCandidateList* _tmp7_;
	KkcCandidateList* _tmp8_;
	KkcCandidateList* _tmp9_;
	KkcCandidateList* _tmp10_;
	KkcRomKanaConverter* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (dictionaries != NULL, NULL);
	self = (KkcState*) g_object_new (object_type, NULL);
	_tmp0_ = model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->model);
	self->model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = kkc_decoder_create (_tmp2_);
	_g_object_unref0 (self->decoder);
	self->decoder = _tmp3_;
	_tmp4_ = dictionaries;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->dictionaries);
	self->dictionaries = _tmp5_;
	_tmp6_ = kkc_segment_list_new ();
	_g_object_unref0 (self->segments);
	self->segments = _tmp6_;
	_tmp7_ = kkc_candidate_list_new ((guint) 4, (guint) 7, FALSE);
	_g_object_unref0 (self->candidates);
	self->candidates = _tmp7_;
	_tmp8_ = self->candidates;
	kkc_candidate_list_set_round (_tmp8_, TRUE);
	_tmp9_ = self->candidates;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::cursor-pos", (GCallback) _kkc_state_candidates_cursor_pos_changed_g_object_notify, self, 0);
	_tmp10_ = self->candidates;
	g_signal_connect_object (_tmp10_, "selected", (GCallback) _kkc_state_candidates_selected_kkc_candidate_list_selected, self, 0);
	_tmp11_ = kkc_rom_kana_converter_new ();
	_g_object_unref0 (self->rom_kana_converter);
	self->rom_kana_converter = _tmp11_;
	{
		KkcRuleMetadata* metadata = NULL;
		KkcRuleMetadata* _tmp12_;
		KkcRule* _tmp13_ = NULL;
		KkcRule* _tmp14_;
		KkcRule* _tmp15_;
		_tmp12_ = kkc_rule_metadata_find ("default");
		metadata = _tmp12_;
		_vala_assert (metadata != NULL, "metadata != null");
		_tmp14_ = kkc_rule_new (metadata, &_inner_error_);
		_tmp13_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (metadata);
			goto __catch10_g_error;
		}
		_tmp15_ = _tmp13_;
		_tmp13_ = NULL;
		_g_object_unref0 (self->priv->_typing_rule);
		self->priv->_typing_rule = _tmp15_;
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (metadata);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_warning ("state.vala:233: cannot load default rule: %s", _tmp16_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	kkc_state_reset (self);
	return self;
}


KkcState* kkc_state_new (KkcLanguageModel* model, KkcDictionaryList* dictionaries) {
	return kkc_state_construct (KKC_TYPE_STATE, model, dictionaries);
}


static void kkc_state_candidates_cursor_pos_changed (KkcState* self, GObject* s, GParamSpec* p) {
	gboolean _tmp0_ = FALSE;
	KkcSegmentList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp1_ = self->segments;
	_tmp2_ = kkc_segment_list_get_cursor_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 0) {
		KkcCandidateList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->candidates;
		_tmp5_ = kkc_candidate_list_get_cursor_pos (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		KkcCandidate* candidate = NULL;
		KkcCandidateList* _tmp7_;
		KkcCandidateList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		KkcCandidate* _tmp11_;
		KkcSegmentList* _tmp12_;
		KkcSegmentList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		KkcSegment* _tmp16_;
		KkcSegment* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		KkcCandidate* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_;
		_tmp7_ = self->candidates;
		_tmp8_ = self->candidates;
		_tmp9_ = kkc_candidate_list_get_cursor_pos (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = kkc_candidate_list_get (_tmp7_, _tmp10_);
		candidate = _tmp11_;
		_tmp12_ = self->segments;
		_tmp13_ = self->segments;
		_tmp14_ = kkc_segment_list_get_cursor_pos (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = kkc_segment_list_get (_tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = kkc_segment_get_output (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = candidate;
		_tmp21_ = kkc_candidate_get_output (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strcmp0 (_tmp19_, _tmp22_) != 0;
		_g_object_unref0 (_tmp17_);
		if (_tmp23_) {
			KkcSegmentList* _tmp24_;
			KkcSegmentList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			KkcSegment* _tmp28_;
			KkcSegment* _tmp29_;
			KkcCandidate* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp24_ = self->segments;
			_tmp25_ = self->segments;
			_tmp26_ = kkc_segment_list_get_cursor_pos (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = kkc_segment_list_get (_tmp24_, _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = candidate;
			_tmp31_ = kkc_candidate_get_output (_tmp30_);
			_tmp32_ = _tmp31_;
			kkc_segment_set_output (_tmp29_, _tmp32_);
			_g_object_unref0 (_tmp29_);
			self->priv->segments_changed = TRUE;
		}
		_g_object_unref0 (candidate);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		KkcState* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->candidate);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static KkcDictionaryCallbackReturn __lambda10_ (Block4Data* _data4_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcSegmentDictionary* segment_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSegmentDictionary* _tmp1_;
	KkcCandidate* _tmp2_;
	self = _data4_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SEGMENT_DICTIONARY) ? ((KkcSegmentDictionary*) _tmp0_) : NULL);
	segment_dict = _tmp1_;
	_tmp2_ = _data4_->candidate;
	kkc_segment_dictionary_select_candidate (segment_dict, _tmp2_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	_g_object_unref0 (segment_dict);
	return result;
}


static KkcDictionaryCallbackReturn ___lambda10__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda10_ (self, dictionary);
	return result;
}


static void kkc_state_candidates_selected (KkcState* self, KkcCandidate* candidate) {
	Block4Data* _data4_;
	KkcCandidate* _tmp0_;
	KkcCandidate* _tmp1_;
	KkcDictionaryList* _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidate != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = candidate;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->candidate);
	_data4_->candidate = _tmp1_;
	_tmp2_ = self->dictionaries;
	_tmp3_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp2_, &_tmp3_, ___lambda10__kkc_dictionary_list_dictionary_callback, _data4_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static KkcSegment** _vala_array_dup1 (KkcSegment** self, int length) {
	KkcSegment** result;
	int i;
	result = g_new0 (KkcSegment*, length + 1);
	for (i = 0; i < length; i++) {
		KkcSegment* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void kkc_state_select_sentence_for_dictionary (KkcState* self, KkcDictionary* dictionary, GeeList* prefixes) {
	KkcSentenceDictionary* sentence_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSentenceDictionary* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dictionary != NULL);
	g_return_if_fail (prefixes != NULL);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SENTENCE_DICTIONARY) ? ((KkcSentenceDictionary*) _tmp0_) : NULL);
	sentence_dict = _tmp1_;
	{
		GeeList* _prefix_list = NULL;
		GeeList* _tmp2_;
		GeeList* _tmp3_;
		gint _prefix_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _prefix_index = 0;
		_tmp2_ = prefixes;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_prefix_list = _tmp3_;
		_tmp4_ = _prefix_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_prefix_size = _tmp6_;
		_prefix_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			KkcPrefixEntry* prefix = NULL;
			GeeList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			KkcSegment** _segments = NULL;
			KkcSegmentList* _tmp13_;
			gint _tmp14_;
			KkcSegment** _tmp15_;
			gint _segments_length1;
			gint __segments_size_;
			gint stop = 0;
			KkcPrefixEntry* _tmp16_;
			gint _tmp17_;
			KkcPrefixEntry* _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			KkcSegment** _tmp20_;
			gint _tmp20__length1;
			KkcPrefixEntry* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			KkcSegment** _tmp24_;
			gint _tmp24__length1;
			KkcSentenceDictionary* _tmp25_;
			KkcSegment** _tmp26_;
			gint _tmp26__length1;
			_tmp7_ = _prefix_index;
			_prefix_index = _tmp7_ + 1;
			_tmp8_ = _prefix_index;
			_tmp9_ = _prefix_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _prefix_list;
			_tmp11_ = _prefix_index;
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
			prefix = (KkcPrefixEntry*) _tmp12_;
			_tmp13_ = self->segments;
			_tmp15_ = kkc_segment_list_to_array (_tmp13_, &_tmp14_);
			_segments = _tmp15_;
			_segments_length1 = _tmp14_;
			__segments_size_ = _segments_length1;
			_tmp16_ = prefix;
			_tmp17_ = (*_tmp16_).offset;
			_tmp18_ = prefix;
			_tmp19_ = (*_tmp18_).sequence;
			_tmp19__length1 = (*_tmp18_).sequence_length1;
			stop = _tmp17_ + _tmp19__length1;
			_tmp20_ = _segments;
			_tmp20__length1 = _segments_length1;
			_tmp21_ = prefix;
			_tmp22_ = (*_tmp21_).offset;
			_tmp23_ = stop;
			_tmp24_ = ((_tmp20_ + _tmp22_) != NULL) ? _vala_array_dup1 (_tmp20_ + _tmp22_, _tmp23_ - _tmp22_) : ((gpointer) (_tmp20_ + _tmp22_));
			_tmp24__length1 = _tmp23_ - _tmp22_;
			_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_object_unref), NULL);
			_segments = _tmp24_;
			_segments_length1 = _tmp24__length1;
			__segments_size_ = _segments_length1;
			_tmp25_ = sentence_dict;
			_tmp26_ = _segments;
			_tmp26__length1 = _segments_length1;
			kkc_sentence_dictionary_select_segments (_tmp25_, _tmp26_, _tmp26__length1);
			_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_object_unref), NULL);
			_kkc_prefix_entry_free0 (prefix);
		}
		_g_object_unref0 (_prefix_list);
	}
	_g_object_unref0 (sentence_dict);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		KkcState* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->prefixes);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static KkcDictionaryCallbackReturn __lambda16_ (Block5Data* _data5_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcDictionary* _tmp0_;
	GeeList* _tmp1_;
	self = _data5_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _data5_->prefixes;
	kkc_state_select_sentence_for_dictionary (self, _tmp0_, _tmp1_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda16__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda16_ (self, dictionary);
	return result;
}


void kkc_state_select_sentence (KkcState* self) {
	Block5Data* _data5_;
	gboolean _tmp0_;
	gchar** sequence = NULL;
	KkcSegmentList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint sequence_length1;
	gint _sequence_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	KkcSegmentList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	KkcSegmentList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeList* _tmp28_;
	KkcDictionaryList* _tmp29_;
	GType _tmp30_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->segments_changed;
	if (!_tmp0_) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp1_ = self->segments;
	_tmp2_ = kkc_segment_list_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_new0 (gchar*, _tmp3_ + 1);
	sequence = _tmp4_;
	sequence_length1 = _tmp3_;
	_sequence_size_ = sequence_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				KkcSegmentList* _tmp11_;
				gint _tmp12_;
				KkcSegment* _tmp13_;
				KkcSegment* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = sequence;
				_tmp8__length1 = sequence_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = sequence;
				_tmp9__length1 = sequence_length1;
				_tmp10_ = i;
				_tmp11_ = self->segments;
				_tmp12_ = i;
				_tmp13_ = kkc_segment_list_get (_tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = kkc_segment_get_input (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (_tmp9_[_tmp10_]);
				_tmp9_[_tmp10_] = _tmp17_;
				_tmp18_ = _tmp9_[_tmp10_];
				_g_object_unref0 (_tmp14_);
			}
		}
	}
	_tmp19_ = sequence;
	_tmp19__length1 = sequence_length1;
	_tmp20_ = self->segments;
	_tmp21_ = kkc_segment_list_get_size (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = MIN (2, _tmp22_);
	_tmp24_ = self->segments;
	_tmp25_ = kkc_segment_list_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = MIN (5, _tmp26_);
	_tmp28_ = kkc_sequence_utils_enumerate_prefixes (_tmp19_, _tmp19__length1, _tmp23_, _tmp27_);
	_data5_->prefixes = _tmp28_;
	_tmp29_ = self->dictionaries;
	_tmp30_ = KKC_TYPE_SENTENCE_DICTIONARY;
	kkc_dictionary_list_call (_tmp29_, &_tmp30_, ___lambda16__kkc_dictionary_list_dictionary_callback, _data5_);
	sequence = (_vala_array_free (sequence, sequence_length1, (GDestroyNotify) g_free), NULL);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


void kkc_state_reset (KkcState* self) {
	KkcRomKanaConverter* _tmp0_;
	KkcRule* _tmp1_;
	KkcKeyEventFilter* _tmp2_;
	KkcKeyEventFilter* _tmp3_;
	KkcSegmentList* _tmp4_;
	KkcCandidateList* _tmp5_;
	KkcRomKanaCharacterList* _tmp6_;
	GeeArrayList* _tmp7_;
	g_return_if_fail (self != NULL);
	self->handler_type = KKC_TYPE_INITIAL_STATE_HANDLER;
	_tmp0_ = self->rom_kana_converter;
	kkc_rom_kana_converter_reset (_tmp0_);
	_tmp1_ = self->priv->_typing_rule;
	_tmp2_ = kkc_rule_get_filter (_tmp1_);
	_tmp3_ = _tmp2_;
	kkc_key_event_filter_reset (_tmp3_);
	_tmp4_ = self->segments;
	kkc_segment_list_clear (_tmp4_);
	self->priv->segments_changed = FALSE;
	_tmp5_ = self->candidates;
	kkc_candidate_list_clear (_tmp5_);
	_tmp6_ = self->input_characters;
	kkc_rom_kana_character_list_clear (_tmp6_);
	self->input_characters_cursor_pos = -1;
	_g_free0 (self->overriding_input);
	self->overriding_input = NULL;
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = NULL;
	_tmp7_ = self->priv->completion;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
	self->quoted = FALSE;
	self->priv->latin_conversion_upper = FALSE;
}


static gchar* kkc_state_lookup_single_for_dictionary (KkcState* self, KkcDictionary* dictionary, const gchar* input) {
	gchar* result = NULL;
	KkcSegmentDictionary* segment_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSegmentDictionary* _tmp1_;
	KkcCandidate** _candidates = NULL;
	gint _candidates_length1 = 0;
	gint __candidates_size_ = 0;
	KkcTemplate* template = NULL;
	const gchar* _tmp2_;
	KkcSimpleTemplate* _tmp3_;
	KkcSegmentDictionary* _tmp4_;
	KkcTemplate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	KkcTemplate* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	KkcCandidate** _tmp11_ = NULL;
	gint _tmp12_;
	gboolean _tmp13_;
	gint count = 0;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dictionary != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SEGMENT_DICTIONARY) ? ((KkcSegmentDictionary*) _tmp0_) : NULL);
	segment_dict = _tmp1_;
	_tmp2_ = input;
	_tmp3_ = kkc_simple_template_new (_tmp2_);
	_g_object_unref0 (template);
	template = (KkcTemplate*) _tmp3_;
	_tmp4_ = segment_dict;
	_tmp5_ = template;
	_tmp6_ = kkc_template_get_source (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = template;
	_tmp9_ = kkc_template_get_okuri (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp13_ = kkc_segment_dictionary_lookup_candidates (_tmp4_, _tmp7_, _tmp10_, &_tmp11_, &_tmp12_);
	_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_candidates = _tmp11_;
	_candidates_length1 = _tmp12_;
	__candidates_size_ = _candidates_length1;
	if (_tmp13_) {
		KkcTemplate* _tmp14_;
		KkcCandidate** _tmp15_;
		gint _tmp15__length1;
		KkcCandidate* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp14_ = template;
		_tmp15_ = _candidates;
		_tmp15__length1 = _candidates_length1;
		_tmp16_ = _tmp15_[0];
		_tmp17_ = kkc_candidate_get_text (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = kkc_template_expand (_tmp14_, _tmp18_);
		result = _tmp19_;
		_g_object_unref0 (template);
		_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (segment_dict);
		return result;
	}
	_tmp20_ = input;
	_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
	count = _tmp21_;
	_tmp22_ = count;
	if (_tmp22_ > 1) {
		const gchar* _tmp23_;
		gint _tmp24_;
		KkcOkuriganaTemplate* _tmp25_;
		KkcSegmentDictionary* _tmp26_;
		KkcTemplate* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		KkcTemplate* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		KkcCandidate** _tmp33_ = NULL;
		gint _tmp34_;
		gboolean _tmp35_;
		_tmp23_ = input;
		_tmp24_ = count;
		_tmp25_ = kkc_okurigana_template_new (_tmp23_, _tmp24_ - 1);
		_g_object_unref0 (template);
		template = (KkcTemplate*) _tmp25_;
		_tmp26_ = segment_dict;
		_tmp27_ = template;
		_tmp28_ = kkc_template_get_source (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = template;
		_tmp31_ = kkc_template_get_okuri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp35_ = kkc_segment_dictionary_lookup_candidates (_tmp26_, _tmp29_, _tmp32_, &_tmp33_, &_tmp34_);
		_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_candidates = _tmp33_;
		_candidates_length1 = _tmp34_;
		__candidates_size_ = _candidates_length1;
		if (_tmp35_) {
			KkcTemplate* _tmp36_;
			KkcCandidate** _tmp37_;
			gint _tmp37__length1;
			KkcCandidate* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp36_ = template;
			_tmp37_ = _candidates;
			_tmp37__length1 = _candidates_length1;
			_tmp38_ = _tmp37_[0];
			_tmp39_ = kkc_candidate_get_text (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = kkc_template_expand (_tmp36_, _tmp40_);
			result = _tmp41_;
			_g_object_unref0 (template);
			_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (segment_dict);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (template);
	_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (segment_dict);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		KkcState* self;
		self = _data6_->self;
		_g_free0 (_data6_->_result_);
		_g_free0 (_data6_->normalized_input);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static KkcDictionaryCallbackReturn __lambda17_ (Block6Data* _data6_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcDictionary* _tmp0_;
	KkcDictionary* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data6_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_USER_DICTIONARY)) {
		result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
		return result;
	}
	_tmp1_ = dictionary;
	_tmp2_ = _data6_->normalized_input;
	_tmp3_ = kkc_state_lookup_single_for_dictionary (self, _tmp1_, _tmp2_);
	_g_free0 (_data6_->_result_);
	_data6_->_result_ = _tmp3_;
	_tmp4_ = _data6_->_result_;
	if (_tmp4_ != NULL) {
		result = KKC_DICTIONARY_CALLBACK_RETURN_REMOVE;
		return result;
	}
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda17__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda17_ (self, dictionary);
	return result;
}


static KkcDictionaryCallbackReturn __lambda18_ (Block6Data* _data6_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcDictionary* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data6_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _data6_->normalized_input;
	_tmp2_ = kkc_state_lookup_single_for_dictionary (self, _tmp0_, _tmp1_);
	_g_free0 (_data6_->_result_);
	_data6_->_result_ = _tmp2_;
	_tmp3_ = _data6_->_result_;
	if (_tmp3_ != NULL) {
		result = KKC_DICTIONARY_CALLBACK_RETURN_REMOVE;
		return result;
	}
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda18__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda18_ (self, dictionary);
	return result;
}


gchar* kkc_state_lookup_single (KkcState* self, const gchar* input) {
	gchar* result = NULL;
	Block6Data* _data6_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	KkcDictionaryList* _tmp2_;
	GType _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	gint _tmp8_;
	KkcDictionaryList* _tmp29_;
	GType _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = input;
	_tmp1_ = kkc_rom_kana_utils_normalize (_tmp0_);
	_data6_->normalized_input = _tmp1_;
	_data6_->_result_ = NULL;
	_tmp2_ = self->dictionaries;
	_tmp3_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp2_, &_tmp3_, ___lambda17__kkc_dictionary_list_dictionary_callback, _data6_);
	_tmp4_ = _data6_->_result_;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = _data6_->_result_;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return result;
	}
	_tmp7_ = _data6_->normalized_input;
	_tmp8_ = g_utf8_strlen (_tmp7_, (gssize) -1);
	if (_tmp8_ > 1) {
		GeeCollection* entries = NULL;
		KkcLanguageModel* _tmp9_;
		const gchar* _tmp10_;
		GeeCollection* _tmp11_;
		_tmp9_ = self->model;
		_tmp10_ = _data6_->normalized_input;
		_tmp11_ = kkc_language_model_unigram_entries (_tmp9_, _tmp10_);
		entries = _tmp11_;
		{
			GeeIterator* _entry_it = NULL;
			GeeCollection* _tmp12_;
			GeeIterator* _tmp13_;
			_tmp12_ = entries;
			_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
			_entry_it = _tmp13_;
			while (TRUE) {
				GeeIterator* _tmp14_;
				gboolean _tmp15_;
				KkcLanguageModelEntry* entry = NULL;
				GeeIterator* _tmp16_;
				gpointer _tmp17_;
				gboolean _tmp18_ = FALSE;
				KkcLanguageModelEntry* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp14_ = _entry_it;
				_tmp15_ = gee_iterator_next (_tmp14_);
				if (!_tmp15_) {
					break;
				}
				_tmp16_ = _entry_it;
				_tmp17_ = gee_iterator_get (_tmp16_);
				entry = (KkcLanguageModelEntry*) _tmp17_;
				_tmp19_ = entry;
				_tmp20_ = (*_tmp19_).output;
				_tmp21_ = _data6_->normalized_input;
				if (g_strcmp0 (_tmp20_, _tmp21_) != 0) {
					KkcLanguageModel* _tmp22_;
					KkcLanguageModelEntry* _tmp23_;
					KkcLanguageModelEntry _tmp24_;
					gdouble _tmp25_;
					_tmp22_ = self->model;
					_tmp23_ = entry;
					_tmp24_ = *_tmp23_;
					_tmp25_ = kkc_unigram_language_model_unigram_cost (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel), &_tmp24_);
					_tmp18_ = _tmp25_ > KKC_MIN_UNIGRAM_COST;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					KkcLanguageModelEntry* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp26_ = entry;
					_tmp27_ = (*_tmp26_).output;
					_tmp28_ = g_strdup (_tmp27_);
					result = _tmp28_;
					_kkc_language_model_entry_free0 (entry);
					_g_object_unref0 (_entry_it);
					_g_object_unref0 (entries);
					block6_data_unref (_data6_);
					_data6_ = NULL;
					return result;
				}
				_kkc_language_model_entry_free0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		_g_object_unref0 (entries);
	}
	_tmp29_ = self->dictionaries;
	_tmp30_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp29_, &_tmp30_, ___lambda18__kkc_dictionary_list_dictionary_callback, _data6_);
	_tmp31_ = _data6_->_result_;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static GEnumValue* _g_enum_value_dup (GEnumValue* self) {
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer __g_enum_value_dup0 (gpointer self) {
	return self ? _g_enum_value_dup (self) : NULL;
}


void kkc_state_lookup (KkcState* self, KkcSegment* segment) {
	KkcCandidateList* _tmp0_;
	gchar* normalized_input = NULL;
	KkcSegment* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	KkcCandidate* original = NULL;
	const gchar* _tmp5_;
	KkcSegment* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	KkcCandidate* _tmp9_;
	KkcCandidateList* _tmp10_;
	KkcCandidate* _tmp11_;
	const gchar* _tmp12_;
	KkcNumericTemplate* _tmp13_;
	KkcNumericTemplate* _tmp14_;
	const gchar* _tmp15_;
	KkcSimpleTemplate* _tmp16_;
	KkcSimpleTemplate* _tmp17_;
	const gchar* _tmp27_;
	gint _tmp28_;
	const gchar* _tmp48_;
	KkcNumericTemplate* _tmp49_;
	KkcNumericTemplate* _tmp50_;
	const gchar* _tmp51_;
	KkcSimpleTemplate* _tmp52_;
	KkcSimpleTemplate* _tmp53_;
	KkcCandidateList* kana_candidates = NULL;
	KkcCandidateList* _tmp54_;
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp55_;
	KkcSegment** _segments = NULL;
	KkcDecoder* _tmp81_;
	const gchar* _tmp82_;
	gint* _tmp83_;
	gint* _tmp84_;
	gint _tmp84__length1;
	gint _tmp85_;
	KkcSegment** _tmp86_;
	KkcSegment** _tmp87_;
	gint _tmp87__length1;
	gint _segments_length1;
	gint __segments_size_;
	KkcSegment** _tmp88_;
	gint _tmp88__length1;
	KkcCandidateList* _tmp117_;
	KkcCandidateList* _tmp118_;
	KkcCandidateList* _tmp119_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (segment != NULL);
	_tmp0_ = self->candidates;
	kkc_candidate_list_clear (_tmp0_);
	_tmp1_ = segment;
	_tmp2_ = kkc_segment_get_input (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = kkc_rom_kana_utils_normalize (_tmp3_);
	normalized_input = _tmp4_;
	_tmp5_ = normalized_input;
	_tmp6_ = segment;
	_tmp7_ = kkc_segment_get_output (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = kkc_candidate_new (_tmp5_, FALSE, _tmp8_, NULL, NULL);
	original = _tmp9_;
	_tmp10_ = self->candidates;
	_tmp11_ = original;
	kkc_candidate_list_add (_tmp10_, _tmp11_);
	_tmp12_ = normalized_input;
	_tmp13_ = kkc_numeric_template_new (_tmp12_);
	_tmp14_ = _tmp13_;
	kkc_state_lookup_template (self, (KkcTemplate*) _tmp14_, TRUE);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = normalized_input;
	_tmp16_ = kkc_simple_template_new (_tmp15_);
	_tmp17_ = _tmp16_;
	kkc_state_lookup_template (self, (KkcTemplate*) _tmp17_, TRUE);
	_g_object_unref0 (_tmp17_);
	{
		gint i = 0;
		const gchar* _tmp18_;
		gint _tmp19_;
		_tmp18_ = normalized_input;
		_tmp19_ = g_utf8_strlen (_tmp18_, (gssize) -1);
		i = _tmp19_;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_;
				KkcOkuriganaTemplate* _tmp25_;
				KkcOkuriganaTemplate* _tmp26_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ - 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				if (!(_tmp22_ > 1)) {
					break;
				}
				_tmp23_ = normalized_input;
				_tmp24_ = i;
				_tmp25_ = kkc_okurigana_template_new (_tmp23_, _tmp24_ - 1);
				_tmp26_ = _tmp25_;
				kkc_state_lookup_template (self, (KkcTemplate*) _tmp26_, TRUE);
				_g_object_unref0 (_tmp26_);
			}
		}
	}
	_tmp27_ = normalized_input;
	_tmp28_ = g_utf8_strlen (_tmp27_, (gssize) -1);
	if (_tmp28_ > 1) {
		GeeCollection* entries = NULL;
		KkcLanguageModel* _tmp29_;
		const gchar* _tmp30_;
		GeeCollection* _tmp31_;
		_tmp29_ = self->model;
		_tmp30_ = normalized_input;
		_tmp31_ = kkc_language_model_unigram_entries (_tmp29_, _tmp30_);
		entries = _tmp31_;
		{
			GeeIterator* _entry_it = NULL;
			GeeCollection* _tmp32_;
			GeeIterator* _tmp33_;
			_tmp32_ = entries;
			_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
			_entry_it = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_;
				gboolean _tmp35_;
				KkcLanguageModelEntry* entry = NULL;
				GeeIterator* _tmp36_;
				gpointer _tmp37_;
				KkcLanguageModel* _tmp38_;
				KkcLanguageModelEntry* _tmp39_;
				KkcLanguageModelEntry _tmp40_;
				gdouble _tmp41_;
				_tmp34_ = _entry_it;
				_tmp35_ = gee_iterator_next (_tmp34_);
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = _entry_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				entry = (KkcLanguageModelEntry*) _tmp37_;
				_tmp38_ = self->model;
				_tmp39_ = entry;
				_tmp40_ = *_tmp39_;
				_tmp41_ = kkc_unigram_language_model_unigram_cost (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel), &_tmp40_);
				if (_tmp41_ > KKC_MIN_UNIGRAM_COST) {
					KkcCandidate* unigram = NULL;
					const gchar* _tmp42_;
					KkcLanguageModelEntry* _tmp43_;
					const gchar* _tmp44_;
					KkcCandidate* _tmp45_;
					KkcCandidateList* _tmp46_;
					KkcCandidate* _tmp47_;
					_tmp42_ = normalized_input;
					_tmp43_ = entry;
					_tmp44_ = (*_tmp43_).output;
					_tmp45_ = kkc_candidate_new (_tmp42_, FALSE, _tmp44_, NULL, NULL);
					unigram = _tmp45_;
					_tmp46_ = self->candidates;
					_tmp47_ = unigram;
					kkc_candidate_list_add (_tmp46_, _tmp47_);
					_g_object_unref0 (unigram);
					_kkc_language_model_entry_free0 (entry);
					break;
				}
				_kkc_language_model_entry_free0 (entry);
			}
			_g_object_unref0 (_entry_it);
		}
		_g_object_unref0 (entries);
	}
	_tmp48_ = normalized_input;
	_tmp49_ = kkc_numeric_template_new (_tmp48_);
	_tmp50_ = _tmp49_;
	kkc_state_lookup_template (self, (KkcTemplate*) _tmp50_, FALSE);
	_g_object_unref0 (_tmp50_);
	_tmp51_ = normalized_input;
	_tmp52_ = kkc_simple_template_new (_tmp51_);
	_tmp53_ = _tmp52_;
	kkc_state_lookup_template (self, (KkcTemplate*) _tmp53_, FALSE);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = kkc_candidate_list_new ((guint) 4, (guint) 7, FALSE);
	kana_candidates = _tmp54_;
	_tmp55_ = g_type_class_ref (KKC_TYPE_KANA_MODE);
	enum_class = (GEnumClass*) _tmp55_;
	{
		gint i = 0;
		GEnumClass* _tmp56_;
		gint _tmp57_;
		_tmp56_ = enum_class;
		_tmp57_ = _tmp56_->minimum;
		i = _tmp57_;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				gint _tmp60_;
				GEnumClass* _tmp61_;
				gint _tmp62_;
				GEnumValue* enum_value = NULL;
				GEnumClass* _tmp63_;
				gint _tmp64_;
				GEnumValue* _tmp65_;
				GEnumValue* _tmp66_;
				GEnumValue* _tmp67_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = i;
					i = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = i;
				_tmp61_ = enum_class;
				_tmp62_ = _tmp61_->maximum;
				if (!(_tmp60_ <= _tmp62_)) {
					break;
				}
				_tmp63_ = enum_class;
				_tmp64_ = i;
				_tmp65_ = g_enum_get_value (_tmp63_, _tmp64_);
				_tmp66_ = __g_enum_value_dup0 (_tmp65_);
				enum_value = _tmp66_;
				_tmp67_ = enum_value;
				if (_tmp67_ != NULL) {
					gchar* output = NULL;
					const gchar* _tmp68_;
					GEnumValue* _tmp69_;
					gint _tmp70_;
					gchar* _tmp71_;
					const gchar* _tmp72_;
					KkcCandidate* _tmp73_;
					const gchar* _tmp74_;
					const gchar* _tmp75_;
					_tmp68_ = normalized_input;
					_tmp69_ = enum_value;
					_tmp70_ = (*_tmp69_).value;
					_tmp71_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp68_, (KkcKanaMode) _tmp70_);
					output = _tmp71_;
					_tmp72_ = output;
					_tmp73_ = original;
					_tmp74_ = kkc_candidate_get_output (_tmp73_);
					_tmp75_ = _tmp74_;
					if (g_strcmp0 (_tmp72_, _tmp75_) != 0) {
						KkcCandidate* candidate = NULL;
						const gchar* _tmp76_;
						const gchar* _tmp77_;
						KkcCandidate* _tmp78_;
						KkcCandidateList* _tmp79_;
						KkcCandidate* _tmp80_;
						_tmp76_ = normalized_input;
						_tmp77_ = output;
						_tmp78_ = kkc_candidate_new (_tmp76_, FALSE, _tmp77_, NULL, NULL);
						candidate = _tmp78_;
						_tmp79_ = kana_candidates;
						_tmp80_ = candidate;
						kkc_candidate_list_add (_tmp79_, _tmp80_);
						_g_object_unref0 (candidate);
					}
					_g_free0 (output);
				}
				_g_free0 (enum_value);
			}
		}
	}
	_tmp81_ = self->decoder;
	_tmp82_ = normalized_input;
	_tmp83_ = g_new0 (gint, 0);
	_tmp84_ = _tmp83_;
	_tmp84__length1 = 0;
	_tmp86_ = kkc_decoder_decode_with_costs (_tmp81_, _tmp82_, KKC_DECODER_NBEST, _tmp84_, 0, KKC_DECODER_MAX_DISTANCE, KKC_DECODER_MIN_PATH_COST, &_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp87__length1 = _tmp85_;
	_tmp84_ = (g_free (_tmp84_), NULL);
	_segments = _tmp87_;
	_segments_length1 = _tmp87__length1;
	__segments_size_ = _segments_length1;
	_tmp88_ = _segments;
	_tmp88__length1 = _segments_length1;
	{
		KkcSegment** _segment_collection = NULL;
		gint _segment_collection_length1 = 0;
		gint __segment_collection_size_ = 0;
		gint _segment_it = 0;
		_segment_collection = _tmp88_;
		_segment_collection_length1 = _tmp88__length1;
		for (_segment_it = 0; _segment_it < _tmp88__length1; _segment_it = _segment_it + 1) {
			KkcSegment* _tmp89_;
			KkcSegment* _segment = NULL;
			_tmp89_ = _g_object_ref0 (_segment_collection[_segment_it]);
			_segment = _tmp89_;
			{
				GString* builder = NULL;
				GString* _tmp90_;
				KkcCandidate* sentence = NULL;
				const gchar* _tmp99_;
				GString* _tmp100_;
				const gchar* _tmp101_;
				KkcCandidate* _tmp102_;
				KkcCandidateList* _tmp103_;
				KkcCandidate* _tmp104_;
				gboolean _tmp105_;
				_tmp90_ = g_string_new ("");
				builder = _tmp90_;
				while (TRUE) {
					KkcSegment* _tmp91_;
					GString* _tmp92_;
					KkcSegment* _tmp93_;
					const gchar* _tmp94_;
					const gchar* _tmp95_;
					KkcSegment* _tmp96_;
					KkcSegment* _tmp97_;
					KkcSegment* _tmp98_;
					_tmp91_ = _segment;
					if (!(_tmp91_ != NULL)) {
						break;
					}
					_tmp92_ = builder;
					_tmp93_ = _segment;
					_tmp94_ = kkc_segment_get_output (_tmp93_);
					_tmp95_ = _tmp94_;
					g_string_append (_tmp92_, _tmp95_);
					_tmp96_ = _segment;
					_tmp97_ = _tmp96_->next;
					_tmp98_ = _g_object_ref0 (_tmp97_);
					_g_object_unref0 (_segment);
					_segment = _tmp98_;
				}
				_tmp99_ = normalized_input;
				_tmp100_ = builder;
				_tmp101_ = _tmp100_->str;
				_tmp102_ = kkc_candidate_new (_tmp99_, FALSE, _tmp101_, NULL, NULL);
				sentence = _tmp102_;
				_tmp103_ = kana_candidates;
				_tmp104_ = sentence;
				_tmp105_ = kkc_candidate_list_contains (_tmp103_, _tmp104_);
				if (!_tmp105_) {
					KkcCandidateList* _tmp106_;
					KkcCandidate* _tmp107_;
					_tmp106_ = self->candidates;
					_tmp107_ = sentence;
					kkc_candidate_list_add (_tmp106_, _tmp107_);
				}
				_g_object_unref0 (sentence);
				_g_string_free0 (builder);
				_g_object_unref0 (_segment);
			}
		}
	}
	{
		gint i = 0;
		const gchar* _tmp108_;
		gint _tmp109_;
		_tmp108_ = normalized_input;
		_tmp109_ = g_utf8_strlen (_tmp108_, (gssize) -1);
		i = _tmp109_;
		{
			gboolean _tmp110_ = FALSE;
			_tmp110_ = TRUE;
			while (TRUE) {
				gint _tmp112_;
				const gchar* _tmp113_;
				gint _tmp114_;
				KkcOkuriganaTemplate* _tmp115_;
				KkcOkuriganaTemplate* _tmp116_;
				if (!_tmp110_) {
					gint _tmp111_;
					_tmp111_ = i;
					i = _tmp111_ - 1;
				}
				_tmp110_ = FALSE;
				_tmp112_ = i;
				if (!(_tmp112_ > 1)) {
					break;
				}
				_tmp113_ = normalized_input;
				_tmp114_ = i;
				_tmp115_ = kkc_okurigana_template_new (_tmp113_, _tmp114_ - 1);
				_tmp116_ = _tmp115_;
				kkc_state_lookup_template (self, (KkcTemplate*) _tmp116_, FALSE);
				_g_object_unref0 (_tmp116_);
			}
		}
	}
	_tmp117_ = self->candidates;
	_tmp118_ = kana_candidates;
	kkc_candidate_list_add_all (_tmp117_, _tmp118_);
	_tmp119_ = self->candidates;
	g_signal_emit_by_name (_tmp119_, "populated");
	_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_type_class_unref0 (enum_class);
	_g_object_unref0 (kana_candidates);
	_g_object_unref0 (original);
	_g_free0 (normalized_input);
}


static void kkc_state_lookup_template_for_dictionary (KkcState* self, KkcDictionary* dictionary, KkcTemplate* template) {
	KkcSegmentDictionary* segment_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSegmentDictionary* _tmp1_;
	KkcCandidate** _candidates = NULL;
	gint _candidates_length1 = 0;
	gint __candidates_size_ = 0;
	KkcSegmentDictionary* _tmp2_;
	KkcTemplate* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	KkcTemplate* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	KkcCandidate** _tmp9_ = NULL;
	gint _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dictionary != NULL);
	g_return_if_fail (template != NULL);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SEGMENT_DICTIONARY) ? ((KkcSegmentDictionary*) _tmp0_) : NULL);
	segment_dict = _tmp1_;
	_tmp2_ = segment_dict;
	_tmp3_ = template;
	_tmp4_ = kkc_template_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = template;
	_tmp7_ = kkc_template_get_okuri (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp11_ = kkc_segment_dictionary_lookup_candidates (_tmp2_, _tmp5_, _tmp8_, &_tmp9_, &_tmp10_);
	_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_candidates = _tmp9_;
	_candidates_length1 = _tmp10_;
	__candidates_size_ = _candidates_length1;
	if (_tmp11_) {
		KkcCandidate** _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = _candidates;
		_tmp12__length1 = _candidates_length1;
		{
			KkcCandidate** candidate_collection = NULL;
			gint candidate_collection_length1 = 0;
			gint _candidate_collection_size_ = 0;
			gint candidate_it = 0;
			candidate_collection = _tmp12_;
			candidate_collection_length1 = _tmp12__length1;
			for (candidate_it = 0; candidate_it < _tmp12__length1; candidate_it = candidate_it + 1) {
				KkcCandidate* _tmp13_;
				KkcCandidate* candidate = NULL;
				_tmp13_ = _g_object_ref0 (candidate_collection[candidate_it]);
				candidate = _tmp13_;
				{
					gchar* text = NULL;
					KkcCandidate* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					KkcCandidate* _tmp18_;
					KkcTemplate* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					KkcCandidate* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					KkcCandidateList* _tmp32_;
					KkcCandidate* _tmp33_;
					_tmp14_ = candidate;
					_tmp15_ = kkc_candidate_get_text (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = kkc_expression_eval (_tmp16_);
					text = _tmp17_;
					_tmp18_ = candidate;
					_tmp19_ = template;
					_tmp20_ = text;
					_tmp21_ = kkc_template_expand (_tmp19_, _tmp20_);
					_tmp22_ = _tmp21_;
					kkc_candidate_set_output (_tmp18_, _tmp22_);
					_g_free0 (_tmp22_);
					_tmp23_ = candidate;
					_tmp24_ = kkc_candidate_get_annotation (_tmp23_);
					_tmp25_ = _tmp24_;
					if (_tmp25_ != NULL) {
						KkcCandidate* _tmp26_;
						KkcCandidate* _tmp27_;
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						_tmp26_ = candidate;
						_tmp27_ = candidate;
						_tmp28_ = kkc_candidate_get_annotation (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = kkc_expression_eval (_tmp29_);
						_tmp31_ = _tmp30_;
						kkc_candidate_set_annotation (_tmp26_, _tmp31_);
						_g_free0 (_tmp31_);
					}
					_tmp32_ = self->candidates;
					_tmp33_ = candidate;
					kkc_candidate_list_add (_tmp32_, _tmp33_);
					_g_free0 (text);
					_g_object_unref0 (candidate);
				}
			}
		}
	}
	_candidates = (_vala_array_free (_candidates, _candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (segment_dict);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		KkcState* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->template);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static KkcDictionaryCallbackReturn __lambda12_ (Block7Data* _data7_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	KkcDictionary* _tmp3_;
	KkcTemplate* _tmp4_;
	self = _data7_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp1_ = _data7_->user;
	if (_tmp1_) {
		KkcDictionary* _tmp2_;
		_tmp2_ = dictionary;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, KKC_TYPE_USER_DICTIONARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
		return result;
	}
	_tmp3_ = dictionary;
	_tmp4_ = _data7_->template;
	kkc_state_lookup_template_for_dictionary (self, _tmp3_, _tmp4_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda12__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda12_ (self, dictionary);
	return result;
}


static void kkc_state_lookup_template (KkcState* self, KkcTemplate* template, gboolean user) {
	Block7Data* _data7_;
	KkcTemplate* _tmp0_;
	KkcTemplate* _tmp1_;
	gboolean _tmp2_;
	KkcDictionaryList* _tmp3_;
	GType _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (template != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = template;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->template);
	_data7_->template = _tmp1_;
	_tmp2_ = user;
	_data7_->user = _tmp2_;
	_tmp3_ = self->dictionaries;
	_tmp4_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp3_, &_tmp4_, ___lambda12__kkc_dictionary_list_dictionary_callback, _data7_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void kkc_state_merge_possible_okurigana_segments (KkcState* self, gint start) {
	GeeArrayList* _segments = NULL;
	GeeArrayList* _tmp0_;
	KkcSegmentList* _tmp14_;
	gint index = 0;
	gint offset = 0;
	KkcSegment* previous = NULL;
	KkcSegment* _tmp84_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_SEGMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_segments = _tmp0_;
	{
		KkcSegmentList* _segment_list = NULL;
		KkcSegmentList* _tmp1_;
		KkcSegmentList* _tmp2_;
		gint _segment_size = 0;
		KkcSegmentList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _segment_index = 0;
		_tmp1_ = self->segments;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_segment_list = _tmp2_;
		_tmp3_ = _segment_list;
		_tmp4_ = kkc_segment_list_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		_segment_size = _tmp5_;
		_segment_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			KkcSegment* segment = NULL;
			KkcSegmentList* _tmp9_;
			gint _tmp10_;
			KkcSegment* _tmp11_;
			GeeArrayList* _tmp12_;
			KkcSegment* _tmp13_;
			_tmp6_ = _segment_index;
			_segment_index = _tmp6_ + 1;
			_tmp7_ = _segment_index;
			_tmp8_ = _segment_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _segment_list;
			_tmp10_ = _segment_index;
			_tmp11_ = kkc_segment_list_get (_tmp9_, _tmp10_);
			segment = _tmp11_;
			_tmp12_ = _segments;
			_tmp13_ = segment;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			_g_object_unref0 (segment);
		}
		_g_object_unref0 (_segment_list);
	}
	_tmp14_ = self->segments;
	kkc_segment_list_clear (_tmp14_);
	index = 0;
	offset = 0;
	{
		gboolean _tmp15_ = FALSE;
		_tmp15_ = TRUE;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gint _tmp18_;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp24_;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			KkcSegment* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			KkcSegmentList* _tmp32_;
			GeeArrayList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			KkcSegment* _tmp36_;
			if (!_tmp15_) {
				gint _tmp16_;
				_tmp16_ = index;
				index = _tmp16_ + 1;
			}
			_tmp15_ = FALSE;
			_tmp18_ = index;
			_tmp19_ = _segments;
			_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp18_ < _tmp21_) {
				gint _tmp22_;
				gint _tmp23_;
				_tmp22_ = offset;
				_tmp23_ = start;
				_tmp17_ = _tmp22_ < _tmp23_;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp24_ = offset;
			_tmp25_ = _segments;
			_tmp26_ = index;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
			_tmp28_ = (KkcSegment*) _tmp27_;
			_tmp29_ = kkc_segment_get_output (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_utf8_strlen (_tmp30_, (gssize) -1);
			offset = _tmp24_ + _tmp31_;
			_g_object_unref0 (_tmp28_);
			_tmp32_ = self->segments;
			_tmp33_ = _segments;
			_tmp34_ = index;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
			_tmp36_ = (KkcSegment*) _tmp35_;
			kkc_segment_list_add (_tmp32_, _tmp36_);
			_g_object_unref0 (_tmp36_);
		}
	}
	previous = NULL;
	{
		gboolean _tmp37_ = FALSE;
		_tmp37_ = TRUE;
		while (TRUE) {
			gint _tmp39_;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			KkcSegment* _tmp43_;
			if (!_tmp37_) {
				gint _tmp38_;
				_tmp38_ = index;
				index = _tmp38_ + 1;
			}
			_tmp37_ = FALSE;
			_tmp39_ = index;
			_tmp40_ = _segments;
			_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			if (!(_tmp39_ < _tmp42_)) {
				break;
			}
			_tmp43_ = previous;
			if (_tmp43_ != NULL) {
				GeeArrayList* _tmp44_;
				gint _tmp45_;
				gpointer _tmp46_;
				KkcSegment* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp50_;
				gboolean _tmp51_;
				_tmp44_ = _segments;
				_tmp45_ = index;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
				_tmp47_ = (KkcSegment*) _tmp46_;
				_tmp48_ = kkc_segment_get_output (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = kkc_rom_kana_utils_is_hiragana (_tmp49_);
				_tmp51_ = _tmp50_;
				_g_object_unref0 (_tmp47_);
				if (_tmp51_) {
					KkcSegment* _tmp52_;
					KkcSegment* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					GeeArrayList* _tmp56_;
					gint _tmp57_;
					gpointer _tmp58_;
					KkcSegment* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					KkcSegment* _tmp64_;
					KkcSegment* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					GeeArrayList* _tmp68_;
					gint _tmp69_;
					gpointer _tmp70_;
					KkcSegment* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					_tmp52_ = previous;
					_tmp53_ = previous;
					_tmp54_ = kkc_segment_get_input (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = _segments;
					_tmp57_ = index;
					_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp57_);
					_tmp59_ = (KkcSegment*) _tmp58_;
					_tmp60_ = kkc_segment_get_input (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = g_strconcat (_tmp55_, _tmp61_, NULL);
					_tmp63_ = _tmp62_;
					kkc_segment_set_input (_tmp53_, _tmp63_);
					_g_free0 (_tmp63_);
					_g_object_unref0 (_tmp59_);
					_tmp64_ = previous;
					_tmp65_ = previous;
					_tmp66_ = kkc_segment_get_output (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = _segments;
					_tmp69_ = index;
					_tmp70_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _tmp69_);
					_tmp71_ = (KkcSegment*) _tmp70_;
					_tmp72_ = kkc_segment_get_output (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strconcat (_tmp67_, _tmp73_, NULL);
					_tmp75_ = _tmp74_;
					kkc_segment_set_output (_tmp65_, _tmp75_);
					_g_free0 (_tmp75_);
					_g_object_unref0 (_tmp71_);
				} else {
					KkcSegmentList* _tmp76_;
					KkcSegment* _tmp77_;
					GeeArrayList* _tmp78_;
					gint _tmp79_;
					gpointer _tmp80_;
					_tmp76_ = self->segments;
					_tmp77_ = previous;
					kkc_segment_list_add (_tmp76_, _tmp77_);
					_tmp78_ = _segments;
					_tmp79_ = index;
					_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp78_, _tmp79_);
					_g_object_unref0 (previous);
					previous = (KkcSegment*) _tmp80_;
				}
			} else {
				GeeArrayList* _tmp81_;
				gint _tmp82_;
				gpointer _tmp83_;
				_tmp81_ = _segments;
				_tmp82_ = index;
				_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp81_, _tmp82_);
				_g_object_unref0 (previous);
				previous = (KkcSegment*) _tmp83_;
			}
		}
	}
	_tmp84_ = previous;
	if (_tmp84_ != NULL) {
		KkcSegmentList* _tmp85_;
		KkcSegment* _tmp86_;
		_tmp85_ = self->segments;
		_tmp86_ = previous;
		kkc_segment_list_add (_tmp85_, _tmp86_);
	}
	_g_object_unref0 (previous);
	_g_object_unref0 (_segments);
}


static gint* _vala_array_dup2 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


void kkc_state_convert_sentence (KkcState* self, const gchar* input, gint* constraint, int constraint_length1) {
	gchar* normalized_input = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint* _tmp2_ = NULL;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp2__length1;
	gint __tmp2__size_;
	KkcSegment** _segments = NULL;
	KkcDecoder* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	KkcSegment** _tmp9_;
	gint _segments_length1;
	gint __segments_size_;
	KkcSegmentList* _tmp10_;
	KkcSegment** _tmp11_;
	gint _tmp11__length1;
	KkcSegment* _tmp12_;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint _tmp15_ = 0;
	gint* _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_tmp0_ = input;
	_tmp1_ = kkc_rom_kana_utils_normalize (_tmp0_);
	normalized_input = _tmp1_;
	_tmp3_ = constraint;
	_tmp3__length1 = constraint_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp4__length1;
	__tmp2__size_ = _tmp2__length1;
	if (_tmp2_ == NULL) {
		gint* _tmp5_;
		_tmp5_ = g_new0 (gint, 0);
		_tmp2_ = (g_free (_tmp2_), NULL);
		_tmp2_ = _tmp5_;
		_tmp2__length1 = 0;
		__tmp2__size_ = _tmp2__length1;
	}
	_tmp6_ = self->decoder;
	_tmp7_ = normalized_input;
	_tmp9_ = kkc_decoder_decode (_tmp6_, _tmp7_, 1, _tmp2_, _tmp2__length1, &_tmp8_);
	_segments = _tmp9_;
	_segments_length1 = _tmp8_;
	__segments_size_ = _segments_length1;
	_tmp10_ = self->segments;
	_tmp11_ = _segments;
	_tmp11__length1 = _segments_length1;
	_tmp12_ = _tmp11_[0];
	kkc_segment_list_set_segments (_tmp10_, _tmp12_);
	_tmp13_ = constraint;
	_tmp13__length1 = constraint_length1;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_;
		_tmp14_ = input;
		kkc_state_apply_constraint (self, _tmp14_);
	}
	kkc_state_apply_phrase (self);
	_tmp16_ = constraint;
	_tmp16__length1 = constraint_length1;
	if (_tmp16_ == NULL) {
		_tmp15_ = 0;
	} else {
		gint* _tmp17_;
		gint _tmp17__length1;
		gint* _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_;
		_tmp17_ = constraint;
		_tmp17__length1 = constraint_length1;
		_tmp18_ = constraint;
		_tmp18__length1 = constraint_length1;
		_tmp19_ = _tmp17_[_tmp18__length1 - 1];
		_tmp15_ = _tmp19_;
	}
	kkc_state_merge_possible_okurigana_segments (self, _tmp15_);
	_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_g_free0 (normalized_input);
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void kkc_state_apply_constraint_for_dictionary (KkcState* self, KkcDictionary* dictionary, const gchar* input) {
	KkcSentenceDictionary* sentence_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSentenceDictionary* _tmp1_;
	gchar** sequence = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	gchar** _tmp4_;
	gint sequence_length1;
	gint _sequence_size_;
	GeeList* prefixes = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GeeList* _tmp9_;
	gint next_offset = 0;
	gint next_constraint_index = 0;
	GeeArrayList* constraint = NULL;
	GeeArrayList* _tmp10_;
	KkcSegment** _segments = NULL;
	KkcDecoder* _tmp134_;
	const gchar* _tmp135_;
	GeeArrayList* _tmp136_;
	gint _tmp137_;
	gpointer* _tmp138_;
	gint* _tmp139_;
	gint _tmp139__length1;
	gint _tmp140_;
	KkcSegment** _tmp141_;
	KkcSegment** _tmp142_;
	gint _tmp142__length1;
	gint _segments_length1;
	gint __segments_size_;
	KkcSegmentList* _tmp143_;
	KkcSegment* _tmp144_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dictionary != NULL);
	g_return_if_fail (input != NULL);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SENTENCE_DICTIONARY) ? ((KkcSentenceDictionary*) _tmp0_) : NULL);
	sentence_dict = _tmp1_;
	_tmp2_ = input;
	_tmp4_ = kkc_utils_split_utf8 (_tmp2_, &_tmp3_);
	sequence = _tmp4_;
	sequence_length1 = _tmp3_;
	_sequence_size_ = sequence_length1;
	_tmp5_ = sequence;
	_tmp5__length1 = sequence_length1;
	_tmp6_ = sequence;
	_tmp6__length1 = sequence_length1;
	_tmp7_ = MIN (4, _tmp6__length1);
	_tmp8_ = sequence;
	_tmp8__length1 = sequence_length1;
	_tmp9_ = kkc_sequence_utils_enumerate_prefixes (_tmp5_, _tmp5__length1, _tmp7_, _tmp8__length1);
	prefixes = _tmp9_;
	next_offset = 0;
	next_constraint_index = 0;
	_tmp10_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	constraint = _tmp10_;
	{
		GeeList* _prefix_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _prefix_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _prefix_index = 0;
		_tmp11_ = prefixes;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_prefix_list = _tmp12_;
		_tmp13_ = _prefix_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_prefix_size = _tmp15_;
		_prefix_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			KkcPrefixEntry* prefix = NULL;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			KkcPrefixEntry* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint* _constraint = NULL;
			gint _constraint_length1 = 0;
			gint __constraint_size_ = 0;
			gchar* _input = NULL;
			KkcPrefixEntry* _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gchar* _tmp27_;
			KkcSentenceDictionary* _tmp28_;
			const gchar* _tmp29_;
			gint* _tmp30_ = NULL;
			gint _tmp31_;
			gboolean _tmp32_;
			_tmp16_ = _prefix_index;
			_prefix_index = _tmp16_ + 1;
			_tmp17_ = _prefix_index;
			_tmp18_ = _prefix_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _prefix_list;
			_tmp20_ = _prefix_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			prefix = (KkcPrefixEntry*) _tmp21_;
			_tmp22_ = prefix;
			_tmp23_ = (*_tmp22_).offset;
			_tmp24_ = next_offset;
			if (_tmp23_ < _tmp24_) {
				_kkc_prefix_entry_free0 (prefix);
				continue;
			}
			_tmp25_ = prefix;
			_tmp26_ = (*_tmp25_).sequence;
			_tmp26__length1 = (*_tmp25_).sequence_length1;
			_tmp27_ = _vala_g_strjoinv ("", _tmp26_, _tmp26__length1);
			_input = _tmp27_;
			_tmp28_ = sentence_dict;
			_tmp29_ = _input;
			_tmp32_ = kkc_sentence_dictionary_lookup_constraint (_tmp28_, _tmp29_, &_tmp30_, &_tmp31_);
			_constraint = (g_free (_constraint), NULL);
			_constraint = _tmp30_;
			_constraint_length1 = _tmp31_;
			__constraint_size_ = _constraint_length1;
			if (_tmp32_) {
				gint* _tmp33_;
				gint _tmp33__length1;
				gint constraint_index = 0;
				GeeArrayList* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint* _tmp130_;
				gint _tmp130__length1;
				gint _tmp131_;
				KkcPrefixEntry* _tmp132_;
				gint _tmp133_;
				_tmp33_ = _constraint;
				_tmp33__length1 = _constraint_length1;
				_vala_assert (_tmp33__length1 > 0, "_constraint.length > 0");
				constraint_index = 0;
				_tmp34_ = constraint;
				_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
				_tmp36_ = _tmp35_;
				if (_tmp36_ > 0) {
					gint last_offset = 0;
					GeeArrayList* _tmp37_;
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_;
					gint _tmp42_;
					gint* _tmp43_;
					gint _tmp43__length1;
					gint _tmp44_;
					KkcPrefixEntry* _tmp45_;
					gint _tmp46_;
					_tmp37_ = constraint;
					_tmp38_ = constraint;
					_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _tmp40_ - 1);
					last_offset = (gint) ((gintptr) _tmp41_);
					_tmp42_ = last_offset;
					_tmp43_ = _constraint;
					_tmp43__length1 = _constraint_length1;
					_tmp44_ = _tmp43_[0];
					_tmp45_ = prefix;
					_tmp46_ = (*_tmp45_).offset;
					if (_tmp42_ < (_tmp44_ + _tmp46_)) {
						gint _offset = 0;
						GeeArrayList* _tmp71_;
						gint _tmp72_;
						gint _tmp73_;
						_offset = 0;
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp47_ = FALSE;
								_tmp47_ = TRUE;
								while (TRUE) {
									gint _tmp49_;
									KkcSegmentList* _tmp50_;
									gint _tmp51_;
									gint _tmp52_;
									gint _tmp53_;
									KkcSegmentList* _tmp54_;
									gint _tmp55_;
									KkcSegment* _tmp56_;
									KkcSegment* _tmp57_;
									const gchar* _tmp58_;
									const gchar* _tmp59_;
									gint _tmp60_;
									gboolean _tmp61_ = FALSE;
									gint _tmp62_;
									gint _tmp63_;
									if (!_tmp47_) {
										gint _tmp48_;
										_tmp48_ = i;
										i = _tmp48_ + 1;
									}
									_tmp47_ = FALSE;
									_tmp49_ = i;
									_tmp50_ = self->segments;
									_tmp51_ = kkc_segment_list_get_size (_tmp50_);
									_tmp52_ = _tmp51_;
									if (!(_tmp49_ < _tmp52_)) {
										break;
									}
									_tmp53_ = _offset;
									_tmp54_ = self->segments;
									_tmp55_ = i;
									_tmp56_ = kkc_segment_list_get (_tmp54_, _tmp55_);
									_tmp57_ = _tmp56_;
									_tmp58_ = kkc_segment_get_input (_tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = g_utf8_strlen (_tmp59_, (gssize) -1);
									_offset = _tmp53_ + _tmp60_;
									_g_object_unref0 (_tmp57_);
									_tmp62_ = last_offset;
									_tmp63_ = _offset;
									if (_tmp62_ < _tmp63_) {
										gint _tmp64_;
										gint* _tmp65_;
										gint _tmp65__length1;
										gint _tmp66_;
										KkcPrefixEntry* _tmp67_;
										gint _tmp68_;
										_tmp64_ = _offset;
										_tmp65_ = _constraint;
										_tmp65__length1 = _constraint_length1;
										_tmp66_ = _tmp65_[0];
										_tmp67_ = prefix;
										_tmp68_ = (*_tmp67_).offset;
										_tmp61_ = _tmp64_ < (_tmp66_ + _tmp68_);
									} else {
										_tmp61_ = FALSE;
									}
									if (_tmp61_) {
										GeeArrayList* _tmp69_;
										gint _tmp70_;
										_tmp69_ = constraint;
										_tmp70_ = _offset;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, (gpointer) ((gintptr) _tmp70_));
									}
								}
							}
						}
						_tmp71_ = constraint;
						_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
						_tmp73_ = _tmp72_;
						next_constraint_index = _tmp73_;
					} else {
						gboolean found_overlap = FALSE;
						gboolean _tmp91_;
						gint _tmp92_;
						found_overlap = FALSE;
						{
							gint i = 0;
							gint _tmp74_;
							_tmp74_ = next_constraint_index;
							i = _tmp74_;
							{
								gboolean _tmp75_ = FALSE;
								_tmp75_ = TRUE;
								while (TRUE) {
									gint _tmp77_;
									GeeArrayList* _tmp78_;
									gint _tmp79_;
									gint _tmp80_;
									GeeArrayList* _tmp81_;
									gint _tmp82_;
									gpointer _tmp83_;
									gint* _tmp84_;
									gint _tmp84__length1;
									gint _tmp85_;
									gint _tmp86_;
									gint _tmp87_;
									KkcPrefixEntry* _tmp88_;
									gint _tmp89_;
									gint _tmp90_;
									if (!_tmp75_) {
										gint _tmp76_;
										_tmp76_ = i;
										i = _tmp76_ + 1;
									}
									_tmp75_ = FALSE;
									_tmp77_ = i;
									_tmp78_ = constraint;
									_tmp79_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp78_);
									_tmp80_ = _tmp79_;
									if (!(_tmp77_ < _tmp80_)) {
										break;
									}
									_tmp81_ = constraint;
									_tmp82_ = i;
									_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp81_, _tmp82_);
									_tmp84_ = _constraint;
									_tmp84__length1 = _constraint_length1;
									_tmp85_ = i;
									_tmp86_ = next_constraint_index;
									_tmp87_ = _tmp84_[_tmp85_ - _tmp86_];
									_tmp88_ = prefix;
									_tmp89_ = (*_tmp88_).offset;
									if (((gint) ((gintptr) _tmp83_)) != (_tmp87_ + _tmp89_)) {
										found_overlap = TRUE;
										break;
									}
									_tmp90_ = constraint_index;
									constraint_index = _tmp90_ + 1;
								}
							}
						}
						_tmp91_ = found_overlap;
						if (_tmp91_) {
							_g_free0 (_input);
							_constraint = (g_free (_constraint), NULL);
							_kkc_prefix_entry_free0 (prefix);
							continue;
						}
						_tmp92_ = next_constraint_index;
						next_constraint_index = _tmp92_ + 1;
					}
				} else {
					KkcPrefixEntry* _tmp93_;
					gint _tmp94_;
					_tmp93_ = prefix;
					_tmp94_ = (*_tmp93_).offset;
					if (_tmp94_ > 0) {
						gint _offset = 0;
						GeeArrayList* _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						_offset = 0;
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp95_ = FALSE;
								_tmp95_ = TRUE;
								while (TRUE) {
									gint _tmp97_;
									KkcSegmentList* _tmp98_;
									gint _tmp99_;
									gint _tmp100_;
									gint _tmp101_;
									KkcSegmentList* _tmp102_;
									gint _tmp103_;
									KkcSegment* _tmp104_;
									KkcSegment* _tmp105_;
									const gchar* _tmp106_;
									const gchar* _tmp107_;
									gint _tmp108_;
									gint _tmp109_;
									gint* _tmp110_;
									gint _tmp110__length1;
									gint _tmp111_;
									KkcPrefixEntry* _tmp112_;
									gint _tmp113_;
									if (!_tmp95_) {
										gint _tmp96_;
										_tmp96_ = i;
										i = _tmp96_ + 1;
									}
									_tmp95_ = FALSE;
									_tmp97_ = i;
									_tmp98_ = self->segments;
									_tmp99_ = kkc_segment_list_get_size (_tmp98_);
									_tmp100_ = _tmp99_;
									if (!(_tmp97_ < _tmp100_)) {
										break;
									}
									_tmp101_ = _offset;
									_tmp102_ = self->segments;
									_tmp103_ = i;
									_tmp104_ = kkc_segment_list_get (_tmp102_, _tmp103_);
									_tmp105_ = _tmp104_;
									_tmp106_ = kkc_segment_get_input (_tmp105_);
									_tmp107_ = _tmp106_;
									_tmp108_ = g_utf8_strlen (_tmp107_, (gssize) -1);
									_offset = _tmp101_ + _tmp108_;
									_g_object_unref0 (_tmp105_);
									_tmp109_ = _offset;
									_tmp110_ = _constraint;
									_tmp110__length1 = _constraint_length1;
									_tmp111_ = _tmp110_[0];
									_tmp112_ = prefix;
									_tmp113_ = (*_tmp112_).offset;
									if (_tmp109_ < (_tmp111_ + _tmp113_)) {
										GeeArrayList* _tmp114_;
										gint _tmp115_;
										_tmp114_ = constraint;
										_tmp115_ = _offset;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, (gpointer) ((gintptr) _tmp115_));
									}
								}
							}
						}
						_tmp116_ = constraint;
						_tmp117_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp116_);
						_tmp118_ = _tmp117_;
						next_constraint_index = _tmp118_;
					}
				}
				{
					gint i = 0;
					gint _tmp119_;
					_tmp119_ = constraint_index;
					i = _tmp119_;
					{
						gboolean _tmp120_ = FALSE;
						_tmp120_ = TRUE;
						while (TRUE) {
							gint _tmp122_;
							gint* _tmp123_;
							gint _tmp123__length1;
							GeeArrayList* _tmp124_;
							gint* _tmp125_;
							gint _tmp125__length1;
							gint _tmp126_;
							gint _tmp127_;
							KkcPrefixEntry* _tmp128_;
							gint _tmp129_;
							if (!_tmp120_) {
								gint _tmp121_;
								_tmp121_ = i;
								i = _tmp121_ + 1;
							}
							_tmp120_ = FALSE;
							_tmp122_ = i;
							_tmp123_ = _constraint;
							_tmp123__length1 = _constraint_length1;
							if (!(_tmp122_ < _tmp123__length1)) {
								break;
							}
							_tmp124_ = constraint;
							_tmp125_ = _constraint;
							_tmp125__length1 = _constraint_length1;
							_tmp126_ = i;
							_tmp127_ = _tmp125_[_tmp126_];
							_tmp128_ = prefix;
							_tmp129_ = (*_tmp128_).offset;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp124_, (gpointer) ((gintptr) (_tmp127_ + _tmp129_)));
						}
					}
				}
				_tmp130_ = _constraint;
				_tmp130__length1 = _constraint_length1;
				_tmp131_ = _tmp130_[0];
				_tmp132_ = prefix;
				_tmp133_ = (*_tmp132_).offset;
				next_offset = _tmp131_ + _tmp133_;
			}
			_g_free0 (_input);
			_constraint = (g_free (_constraint), NULL);
			_kkc_prefix_entry_free0 (prefix);
		}
		_g_object_unref0 (_prefix_list);
	}
	_tmp134_ = self->decoder;
	_tmp135_ = input;
	_tmp136_ = constraint;
	_tmp138_ = gee_collection_to_array ((GeeCollection*) _tmp136_, &_tmp137_);
	_tmp139_ = _tmp138_;
	_tmp139__length1 = _tmp137_;
	_tmp141_ = kkc_decoder_decode (_tmp134_, _tmp135_, 1, _tmp139_, _tmp137_, &_tmp140_);
	_tmp142_ = _tmp141_;
	_tmp142__length1 = _tmp140_;
	_tmp139_ = (g_free (_tmp139_), NULL);
	_segments = _tmp142_;
	_segments_length1 = _tmp142__length1;
	__segments_size_ = _segments_length1;
	_tmp143_ = self->segments;
	_tmp144_ = _segments[0];
	kkc_segment_list_set_segments (_tmp143_, _tmp144_);
	_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (constraint);
	_g_object_unref0 (prefixes);
	sequence = (_vala_array_free (sequence, sequence_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (sentence_dict);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		KkcState* self;
		self = _data8_->self;
		_g_free0 (_data8_->input);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static KkcDictionaryCallbackReturn __lambda14_ (Block8Data* _data8_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcDictionary* _tmp0_;
	const gchar* _tmp1_;
	self = _data8_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _data8_->input;
	kkc_state_apply_constraint_for_dictionary (self, _tmp0_, _tmp1_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda14__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda14_ (self, dictionary);
	return result;
}


static void kkc_state_apply_constraint (KkcState* self, const gchar* input) {
	Block8Data* _data8_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	KkcDictionaryList* _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = input;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data8_->input);
	_data8_->input = _tmp1_;
	_tmp2_ = self->dictionaries;
	_tmp3_ = KKC_TYPE_SENTENCE_DICTIONARY;
	kkc_dictionary_list_call (_tmp2_, &_tmp3_, ___lambda14__kkc_dictionary_list_dictionary_callback, _data8_);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static void kkc_state_apply_phrase_for_dictionary (KkcState* self, KkcDictionary* dictionary) {
	KkcSentenceDictionary* sentence_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSentenceDictionary* _tmp1_;
	gchar** sequence = NULL;
	KkcSegmentList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint sequence_length1;
	gint _sequence_size_;
	GeeList* prefixes = NULL;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gint _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_;
	GeeList* _tmp27_;
	gint offset = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dictionary != NULL);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SENTENCE_DICTIONARY) ? ((KkcSentenceDictionary*) _tmp0_) : NULL);
	sentence_dict = _tmp1_;
	_tmp2_ = self->segments;
	_tmp3_ = kkc_segment_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_new0 (gchar*, _tmp4_ + 1);
	sequence = _tmp5_;
	sequence_length1 = _tmp4_;
	_sequence_size_ = sequence_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				KkcSegmentList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				KkcSegmentList* _tmp14_;
				gint _tmp15_;
				KkcSegment* _tmp16_;
				KkcSegment* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->segments;
				_tmp10_ = kkc_segment_list_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < _tmp11_)) {
					break;
				}
				_tmp12_ = sequence;
				_tmp12__length1 = sequence_length1;
				_tmp13_ = i;
				_tmp14_ = self->segments;
				_tmp15_ = i;
				_tmp16_ = kkc_segment_list_get (_tmp14_, _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = kkc_segment_get_input (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (_tmp12_[_tmp13_]);
				_tmp12_[_tmp13_] = _tmp20_;
				_tmp21_ = _tmp12_[_tmp13_];
				_g_object_unref0 (_tmp17_);
			}
		}
	}
	_tmp22_ = sequence;
	_tmp22__length1 = sequence_length1;
	_tmp23_ = sequence;
	_tmp23__length1 = sequence_length1;
	_tmp24_ = MIN (2, _tmp23__length1);
	_tmp25_ = sequence;
	_tmp25__length1 = sequence_length1;
	_tmp26_ = MIN (5, _tmp25__length1);
	_tmp27_ = kkc_sequence_utils_enumerate_prefixes (_tmp22_, _tmp22__length1, _tmp24_, _tmp26_);
	prefixes = _tmp27_;
	offset = 0;
	{
		GeeList* _prefix_list = NULL;
		GeeList* _tmp28_;
		GeeList* _tmp29_;
		gint _prefix_size = 0;
		GeeList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _prefix_index = 0;
		_tmp28_ = prefixes;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_prefix_list = _tmp29_;
		_tmp30_ = _prefix_list;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_prefix_size = _tmp32_;
		_prefix_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			KkcPrefixEntry* prefix = NULL;
			GeeList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_;
			KkcPrefixEntry* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gchar** _value = NULL;
			gint _value_length1 = 0;
			gint __value_size_ = 0;
			KkcSentenceDictionary* _tmp42_;
			KkcPrefixEntry* _tmp43_;
			gchar** _tmp44_;
			gint _tmp44__length1;
			gchar** _tmp45_ = NULL;
			gint _tmp46_;
			gboolean _tmp47_;
			_tmp33_ = _prefix_index;
			_prefix_index = _tmp33_ + 1;
			_tmp34_ = _prefix_index;
			_tmp35_ = _prefix_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _prefix_list;
			_tmp37_ = _prefix_index;
			_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
			prefix = (KkcPrefixEntry*) _tmp38_;
			_tmp39_ = prefix;
			_tmp40_ = (*_tmp39_).offset;
			_tmp41_ = offset;
			if (_tmp40_ < _tmp41_) {
				_kkc_prefix_entry_free0 (prefix);
				continue;
			}
			_tmp42_ = sentence_dict;
			_tmp43_ = prefix;
			_tmp44_ = (*_tmp43_).sequence;
			_tmp44__length1 = (*_tmp43_).sequence_length1;
			_tmp47_ = kkc_sentence_dictionary_lookup_phrase (_tmp42_, _tmp44_, _tmp44__length1, &_tmp45_, &_tmp46_);
			_value = (_vala_array_free (_value, _value_length1, (GDestroyNotify) g_free), NULL);
			_value = _tmp45_;
			_value_length1 = _tmp46_;
			__value_size_ = _value_length1;
			if (_tmp47_) {
				gint _tmp61_;
				gchar** _tmp62_;
				gint _tmp62__length1;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp48_ = FALSE;
						_tmp48_ = TRUE;
						while (TRUE) {
							gint _tmp50_;
							gchar** _tmp51_;
							gint _tmp51__length1;
							KkcSegmentList* _tmp52_;
							KkcPrefixEntry* _tmp53_;
							gint _tmp54_;
							gint _tmp55_;
							KkcSegment* _tmp56_;
							KkcSegment* _tmp57_;
							gchar** _tmp58_;
							gint _tmp58__length1;
							gint _tmp59_;
							const gchar* _tmp60_;
							if (!_tmp48_) {
								gint _tmp49_;
								_tmp49_ = i;
								i = _tmp49_ + 1;
							}
							_tmp48_ = FALSE;
							_tmp50_ = i;
							_tmp51_ = _value;
							_tmp51__length1 = _value_length1;
							if (!(_tmp50_ < _tmp51__length1)) {
								break;
							}
							_tmp52_ = self->segments;
							_tmp53_ = prefix;
							_tmp54_ = (*_tmp53_).offset;
							_tmp55_ = i;
							_tmp56_ = kkc_segment_list_get (_tmp52_, _tmp54_ + _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = _value;
							_tmp58__length1 = _value_length1;
							_tmp59_ = i;
							_tmp60_ = _tmp58_[_tmp59_];
							kkc_segment_set_output (_tmp57_, _tmp60_);
							_g_object_unref0 (_tmp57_);
						}
					}
				}
				_tmp61_ = offset;
				_tmp62_ = _value;
				_tmp62__length1 = _value_length1;
				offset = _tmp61_ + _tmp62__length1;
			}
			_value = (_vala_array_free (_value, _value_length1, (GDestroyNotify) g_free), NULL);
			_kkc_prefix_entry_free0 (prefix);
		}
		_g_object_unref0 (_prefix_list);
	}
	_g_object_unref0 (prefixes);
	sequence = (_vala_array_free (sequence, sequence_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (sentence_dict);
}


static KkcDictionaryCallbackReturn __lambda15_ (KkcState* self, KkcDictionary* dictionary) {
	KkcDictionaryCallbackReturn result = 0;
	KkcDictionary* _tmp0_;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	kkc_state_apply_phrase_for_dictionary (self, _tmp0_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	return result;
}


static KkcDictionaryCallbackReturn ___lambda15__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda15_ ((KkcState*) self, dictionary);
	return result;
}


static void kkc_state_apply_phrase (KkcState* self) {
	KkcDictionaryList* _tmp0_;
	GType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->dictionaries;
	_tmp1_ = KKC_TYPE_SENTENCE_DICTIONARY;
	kkc_dictionary_list_call (_tmp0_, &_tmp1_, ___lambda15__kkc_dictionary_list_dictionary_callback, self);
}


static void _vala_array_add6 (gint* * array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add7 (gint* * array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


void kkc_state_resize_segment (KkcState* self, gint amount) {
	gboolean _tmp0_ = FALSE;
	KkcSegmentList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->segments;
	_tmp2_ = kkc_segment_list_get_cursor_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 0) {
		KkcSegmentList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		KkcSegmentList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp4_ = self->segments;
		_tmp5_ = kkc_segment_list_get_cursor_pos (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->segments;
		_tmp8_ = kkc_segment_list_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp6_ < _tmp9_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint segment_size = 0;
		KkcSegmentList* _tmp18_;
		KkcSegmentList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		KkcSegment* _tmp22_;
		KkcSegment* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint* constraint = NULL;
		gint* _tmp30_;
		gint constraint_length1;
		gint _constraint_size_;
		gint offset = 0;
		gint _tmp47_;
		gint _tmp48_;
		gint* _tmp49_;
		gint _tmp49__length1;
		gint _tmp50_;
		gchar** output = NULL;
		KkcSegmentList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gchar** _tmp54_;
		gint output_length1;
		gint _output_size_;
		gint cursor_pos = 0;
		KkcSegmentList* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		KkcSegmentList* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gint* _tmp75_;
		gint _tmp75__length1;
		KkcSegmentList* _tmp76_;
		gint _tmp77_;
		_tmp11_ = amount;
		if (_tmp11_ > 0) {
			KkcSegmentList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			KkcSegmentList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp12_ = self->segments;
			_tmp13_ = kkc_segment_list_get_cursor_pos (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->segments;
			_tmp16_ = kkc_segment_list_get_size (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp10_ = _tmp14_ > (_tmp17_ - 1);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			return;
		}
		_tmp18_ = self->segments;
		_tmp19_ = self->segments;
		_tmp20_ = kkc_segment_list_get_cursor_pos (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = kkc_segment_list_get (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = kkc_segment_get_input (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_utf8_strlen (_tmp25_, (gssize) -1);
		_tmp27_ = amount;
		_tmp28_ = _tmp26_ + _tmp27_;
		_g_object_unref0 (_tmp23_);
		segment_size = _tmp28_;
		_tmp29_ = segment_size;
		if (_tmp29_ <= 0) {
			return;
		}
		_tmp30_ = g_new0 (gint, 0);
		constraint = _tmp30_;
		constraint_length1 = 0;
		_constraint_size_ = constraint_length1;
		offset = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp31_ = FALSE;
				_tmp31_ = TRUE;
				while (TRUE) {
					gint _tmp33_;
					KkcSegmentList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					KkcSegmentList* _tmp38_;
					gint _tmp39_;
					KkcSegment* _tmp40_;
					KkcSegment* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gint _tmp44_;
					gint* _tmp45_;
					gint _tmp45__length1;
					gint _tmp46_;
					if (!_tmp31_) {
						gint _tmp32_;
						_tmp32_ = i;
						i = _tmp32_ + 1;
					}
					_tmp31_ = FALSE;
					_tmp33_ = i;
					_tmp34_ = self->segments;
					_tmp35_ = kkc_segment_list_get_cursor_pos (_tmp34_);
					_tmp36_ = _tmp35_;
					if (!(_tmp33_ < _tmp36_)) {
						break;
					}
					_tmp37_ = offset;
					_tmp38_ = self->segments;
					_tmp39_ = i;
					_tmp40_ = kkc_segment_list_get (_tmp38_, _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = kkc_segment_get_input (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_utf8_strlen (_tmp43_, (gssize) -1);
					offset = _tmp37_ + _tmp44_;
					_g_object_unref0 (_tmp41_);
					_tmp45_ = constraint;
					_tmp45__length1 = constraint_length1;
					_tmp46_ = offset;
					_vala_array_add6 (&constraint, &constraint_length1, &_constraint_size_, _tmp46_);
				}
			}
		}
		_tmp47_ = offset;
		_tmp48_ = segment_size;
		offset = _tmp47_ + _tmp48_;
		_tmp49_ = constraint;
		_tmp49__length1 = constraint_length1;
		_tmp50_ = offset;
		_vala_array_add7 (&constraint, &constraint_length1, &_constraint_size_, _tmp50_);
		_tmp51_ = self->segments;
		_tmp52_ = kkc_segment_list_get_cursor_pos (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_new0 (gchar*, _tmp53_ + 1);
		output = _tmp54_;
		output_length1 = _tmp53_;
		_output_size_ = output_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp55_ = FALSE;
				_tmp55_ = TRUE;
				while (TRUE) {
					gint _tmp57_;
					gchar** _tmp58_;
					gint _tmp58__length1;
					gchar** _tmp59_;
					gint _tmp59__length1;
					gint _tmp60_;
					KkcSegmentList* _tmp61_;
					gint _tmp62_;
					KkcSegment* _tmp63_;
					KkcSegment* _tmp64_;
					const gchar* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					if (!_tmp55_) {
						gint _tmp56_;
						_tmp56_ = i;
						i = _tmp56_ + 1;
					}
					_tmp55_ = FALSE;
					_tmp57_ = i;
					_tmp58_ = output;
					_tmp58__length1 = output_length1;
					if (!(_tmp57_ < _tmp58__length1)) {
						break;
					}
					_tmp59_ = output;
					_tmp59__length1 = output_length1;
					_tmp60_ = i;
					_tmp61_ = self->segments;
					_tmp62_ = i;
					_tmp63_ = kkc_segment_list_get (_tmp61_, _tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = kkc_segment_get_output (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = g_strdup (_tmp66_);
					_g_free0 (_tmp59_[_tmp60_]);
					_tmp59_[_tmp60_] = _tmp67_;
					_tmp68_ = _tmp59_[_tmp60_];
					_g_object_unref0 (_tmp64_);
				}
			}
		}
		_tmp69_ = self->segments;
		_tmp70_ = kkc_segment_list_get_cursor_pos (_tmp69_);
		_tmp71_ = _tmp70_;
		cursor_pos = _tmp71_;
		_tmp72_ = self->segments;
		_tmp73_ = kkc_segment_list_get_input (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = constraint;
		_tmp75__length1 = constraint_length1;
		kkc_state_convert_sentence (self, _tmp74_, _tmp75_, _tmp75__length1);
		_g_free0 (_tmp74_);
		kkc_state_apply_phrase (self);
		_tmp76_ = self->segments;
		_tmp77_ = cursor_pos;
		kkc_segment_list_set_cursor_pos (_tmp76_, _tmp77_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp78_ = FALSE;
				_tmp78_ = TRUE;
				while (TRUE) {
					gint _tmp80_;
					gchar** _tmp81_;
					gint _tmp81__length1;
					KkcSegmentList* _tmp82_;
					gint _tmp83_;
					KkcSegment* _tmp84_;
					KkcSegment* _tmp85_;
					gchar** _tmp86_;
					gint _tmp86__length1;
					gint _tmp87_;
					const gchar* _tmp88_;
					if (!_tmp78_) {
						gint _tmp79_;
						_tmp79_ = i;
						i = _tmp79_ + 1;
					}
					_tmp78_ = FALSE;
					_tmp80_ = i;
					_tmp81_ = output;
					_tmp81__length1 = output_length1;
					if (!(_tmp80_ < _tmp81__length1)) {
						break;
					}
					_tmp82_ = self->segments;
					_tmp83_ = i;
					_tmp84_ = kkc_segment_list_get (_tmp82_, _tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = output;
					_tmp86__length1 = output_length1;
					_tmp87_ = i;
					_tmp88_ = _tmp86_[_tmp87_];
					kkc_segment_set_output (_tmp85_, _tmp88_);
					_g_object_unref0 (_tmp85_);
				}
			}
		}
		self->priv->segments_changed = TRUE;
		output = (_vala_array_free (output, output_length1, (GDestroyNotify) g_free), NULL);
		constraint = (g_free (constraint), NULL);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		KkcState* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->candidate);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static KkcDictionaryCallbackReturn __lambda13_ (Block9Data* _data9_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcSegmentDictionary* segment_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSegmentDictionary* _tmp1_;
	KkcCandidate* _tmp2_;
	self = _data9_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SEGMENT_DICTIONARY) ? ((KkcSegmentDictionary*) _tmp0_) : NULL);
	segment_dict = _tmp1_;
	_tmp2_ = _data9_->candidate;
	kkc_segment_dictionary_purge_candidate (segment_dict, _tmp2_);
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	_g_object_unref0 (segment_dict);
	return result;
}


static KkcDictionaryCallbackReturn ___lambda13__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda13_ (self, dictionary);
	return result;
}


void kkc_state_purge_candidate (KkcState* self, KkcCandidate* candidate) {
	Block9Data* _data9_;
	KkcCandidate* _tmp0_;
	KkcCandidate* _tmp1_;
	KkcDictionaryList* _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidate != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = candidate;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data9_->candidate);
	_data9_->candidate = _tmp1_;
	_tmp2_ = self->dictionaries;
	_tmp3_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp2_, &_tmp3_, ___lambda13__kkc_dictionary_list_dictionary_callback, _data9_);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		KkcState* self;
		self = _data10_->self;
		_g_free0 (_data10_->input);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static KkcDictionaryCallbackReturn __lambda11_ (Block10Data* _data10_, KkcDictionary* dictionary) {
	KkcState* self;
	KkcDictionaryCallbackReturn result = 0;
	KkcSegmentDictionary* segment_dict = NULL;
	KkcDictionary* _tmp0_;
	KkcSegmentDictionary* _tmp1_;
	gchar** _completion = NULL;
	KkcSegmentDictionary* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint _completion_length1;
	gint __completion_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	self = _data10_->self;
	g_return_val_if_fail (dictionary != NULL, 0);
	_tmp0_ = dictionary;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, KKC_TYPE_SEGMENT_DICTIONARY) ? ((KkcSegmentDictionary*) _tmp0_) : NULL);
	segment_dict = _tmp1_;
	_tmp2_ = segment_dict;
	_tmp3_ = _data10_->input;
	_tmp5_ = kkc_segment_dictionary_complete (_tmp2_, _tmp3_, &_tmp4_);
	_completion = _tmp5_;
	_completion_length1 = _tmp4_;
	__completion_size_ = _completion_length1;
	_tmp6_ = _completion;
	_tmp6__length1 = _completion_length1;
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp6_;
		word_collection_length1 = _tmp6__length1;
		for (word_it = 0; word_it < _tmp6__length1; word_it = word_it + 1) {
			gchar* _tmp7_;
			gchar* word = NULL;
			_tmp7_ = g_strdup (word_collection[word_it]);
			word = _tmp7_;
			{
				GeeArrayList* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = self->priv->completion;
				_tmp9_ = word;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_g_free0 (word);
			}
		}
	}
	result = KKC_DICTIONARY_CALLBACK_RETURN_CONTINUE;
	_completion = (_vala_array_free (_completion, _completion_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (segment_dict);
	return result;
}


static KkcDictionaryCallbackReturn ___lambda11__kkc_dictionary_list_dictionary_callback (KkcDictionary* dictionary, gpointer self) {
	KkcDictionaryCallbackReturn result;
	result = __lambda11_ (self, dictionary);
	return result;
}


void kkc_state_completion_start (KkcState* self, const gchar* input) {
	Block10Data* _data10_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	KkcDictionaryList* _tmp3_;
	GType _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = input;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data10_->input);
	_data10_->input = _tmp1_;
	_tmp2_ = self->priv->completion;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = self->dictionaries;
	_tmp4_ = KKC_TYPE_SEGMENT_DICTIONARY;
	kkc_dictionary_list_call (_tmp3_, &_tmp4_, ___lambda11__kkc_dictionary_list_dictionary_callback, _data10_);
	_tmp5_ = self->priv->completion;
	gee_list_sort ((GeeList*) _tmp5_, NULL, NULL, NULL);
	_tmp6_ = self->priv->completion;
	_tmp7_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp6_);
	_g_object_unref0 (self->completion_iterator);
	self->completion_iterator = _tmp7_;
	_tmp8_ = self->completion_iterator;
	_tmp9_ = gee_iterator_next (_tmp8_);
	if (!_tmp9_) {
		_g_object_unref0 (self->completion_iterator);
		self->completion_iterator = NULL;
	}
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


KkcInputMode kkc_state_get_input_mode (KkcState* self) {
	KkcInputMode result;
	KkcInputMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_input_mode;
	result = _tmp0_;
	return result;
}


void kkc_state_set_input_mode (KkcState* self, KkcInputMode value) {
	KkcInputMode _last_input_mode = 0;
	KkcInputMode _tmp0_;
	KkcInputMode _tmp1_;
	gboolean _tmp2_ = FALSE;
	KkcInputMode _tmp3_;
	KkcInputMode _tmp7_;
	KkcInputMode _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_input_mode;
	_last_input_mode = _tmp0_;
	_tmp1_ = value;
	self->priv->_input_mode = _tmp1_;
	_tmp3_ = self->priv->_input_mode;
	if (_tmp3_ >= KKC_KANA_MODE_HIRAGANA) {
		KkcInputMode _tmp4_;
		_tmp4_ = self->priv->_input_mode;
		_tmp2_ = _tmp4_ <= KKC_KANA_MODE_WIDE_LATIN;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		KkcRomKanaConverter* _tmp5_;
		KkcInputMode _tmp6_;
		_tmp5_ = self->rom_kana_converter;
		_tmp6_ = self->priv->_input_mode;
		kkc_rom_kana_converter_set_kana_mode (_tmp5_, (KkcKanaMode) _tmp6_);
	}
	_tmp7_ = _last_input_mode;
	_tmp8_ = self->priv->_input_mode;
	if (_tmp7_ != _tmp8_) {
		g_object_notify ((GObject*) self, "input-mode");
	}
}


gint kkc_state_get_input_cursor_pos (KkcState* self) {
	gint result;
	gint _tmp0_;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->input_characters_cursor_pos;
	if (_tmp0_ >= 0) {
		gint index = 0;
		gint offset = 0;
		gint _tmp12_;
		KkcRomKanaConverter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		index = 0;
		offset = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				KkcRomKanaCharacterList* _tmp6_;
				gint _tmp7_;
				KkcRomKanaCharacter _tmp8_ = {0};
				KkcRomKanaCharacter _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = index;
				_tmp4_ = self->input_characters_cursor_pos;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = offset;
				_tmp6_ = self->input_characters;
				_tmp7_ = index;
				kkc_rom_kana_character_list_get (_tmp6_, _tmp7_, &_tmp8_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_.output;
				_tmp11_ = g_utf8_strlen (_tmp10_, (gssize) -1);
				offset = _tmp5_ + _tmp11_;
				kkc_rom_kana_character_destroy (&_tmp9_);
			}
		}
		_tmp12_ = offset;
		_tmp13_ = self->rom_kana_converter;
		_tmp14_ = kkc_rom_kana_converter_get_pending_output (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_utf8_strlen (_tmp15_, (gssize) -1);
		offset = _tmp12_ + _tmp16_;
		_tmp17_ = offset;
		result = _tmp17_;
		return result;
	}
	_tmp18_ = self->input_characters_cursor_pos;
	result = _tmp18_;
	return result;
}


guint kkc_state_get_input_cursor_width (KkcState* self) {
	guint result;
	gint _tmp0_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->input_characters_cursor_pos;
	if (_tmp0_ >= 0) {
		KkcRomKanaCharacterList* _tmp1_;
		gint _tmp2_;
		KkcRomKanaCharacter _tmp3_ = {0};
		KkcRomKanaCharacter _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		guint _tmp7_;
		_tmp1_ = self->input_characters;
		_tmp2_ = self->input_characters_cursor_pos;
		kkc_rom_kana_character_list_get (_tmp1_, _tmp2_, &_tmp3_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_.output;
		_tmp6_ = g_utf8_strlen (_tmp5_, (gssize) -1);
		_tmp7_ = (guint) _tmp6_;
		kkc_rom_kana_character_destroy (&_tmp4_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->input_characters_cursor_pos;
	result = (guint) _tmp8_;
	return result;
}


KkcPunctuationStyle kkc_state_get_punctuation_style (KkcState* self) {
	KkcPunctuationStyle result;
	KkcRomKanaConverter* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	KkcPunctuationStyle _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = kkc_rom_kana_converter_get_punctuation_style (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_state_set_punctuation_style (KkcState* self, KkcPunctuationStyle value) {
	KkcRomKanaConverter* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = value;
	kkc_rom_kana_converter_set_punctuation_style (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, kkc_state_properties[KKC_STATE_PUNCTUATION_STYLE_PROPERTY]);
}


gboolean kkc_state_get_auto_correct (KkcState* self) {
	gboolean result;
	KkcRomKanaConverter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = kkc_rom_kana_converter_get_auto_correct (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_state_set_auto_correct (KkcState* self, gboolean value) {
	KkcRomKanaConverter* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->rom_kana_converter;
	_tmp1_ = value;
	kkc_rom_kana_converter_set_auto_correct (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, kkc_state_properties[KKC_STATE_AUTO_CORRECT_PROPERTY]);
}


KkcRule* kkc_state_get_typing_rule (KkcState* self) {
	KkcRule* result;
	KkcRule* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_typing_rule;
	result = _tmp0_;
	return result;
}


void kkc_state_set_typing_rule (KkcState* self, KkcRule* value) {
	KkcRule* _tmp0_;
	KkcRule* _tmp1_;
	KkcRomKanaConverter* _tmp2_;
	KkcRule* _tmp3_;
	KkcRomKanaMapFile* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_typing_rule);
	self->priv->_typing_rule = _tmp1_;
	_tmp2_ = self->rom_kana_converter;
	_tmp3_ = self->priv->_typing_rule;
	_tmp4_ = _tmp3_->rom_kana;
	kkc_rom_kana_converter_set_rule (_tmp2_, _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, kkc_state_properties[KKC_STATE_TYPING_RULE_PROPERTY]);
}


static void kkc_state_class_init (KkcStateClass * klass) {
	kkc_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcStatePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_state_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_state_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_state_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_INPUT_MODE_PROPERTY, kkc_state_properties[KKC_STATE_INPUT_MODE_PROPERTY] = g_param_spec_enum ("input-mode", "input-mode", "input-mode", KKC_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_INPUT_CURSOR_POS_PROPERTY, kkc_state_properties[KKC_STATE_INPUT_CURSOR_POS_PROPERTY] = g_param_spec_int ("input-cursor-pos", "input-cursor-pos", "input-cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_INPUT_CURSOR_WIDTH_PROPERTY, kkc_state_properties[KKC_STATE_INPUT_CURSOR_WIDTH_PROPERTY] = g_param_spec_uint ("input-cursor-width", "input-cursor-width", "input-cursor-width", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_PUNCTUATION_STYLE_PROPERTY, kkc_state_properties[KKC_STATE_PUNCTUATION_STYLE_PROPERTY] = g_param_spec_enum ("punctuation-style", "punctuation-style", "punctuation-style", KKC_TYPE_PUNCTUATION_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_AUTO_CORRECT_PROPERTY, kkc_state_properties[KKC_STATE_AUTO_CORRECT_PROPERTY] = g_param_spec_boolean ("auto-correct", "auto-correct", "auto-correct", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_STATE_TYPING_RULE_PROPERTY, kkc_state_properties[KKC_STATE_TYPING_RULE_PROPERTY] = g_param_spec_object ("typing-rule", "typing-rule", "typing-rule", KKC_TYPE_RULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	kkc_state_signals[KKC_STATE_REQUEST_SELECTION_TEXT_SIGNAL] = g_signal_new ("request-selection-text", KKC_TYPE_STATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void kkc_state_instance_init (KkcState * self) {
	KkcRomKanaCharacterList* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GeeArrayList* _tmp3_;
	self->priv = KKC_STATE_GET_PRIVATE (self);
	self->priv->segments_changed = FALSE;
	_tmp0_ = kkc_rom_kana_character_list_new ();
	self->input_characters = _tmp0_;
	self->input_characters_cursor_pos = -1;
	_tmp1_ = g_string_new ("");
	self->selection = _tmp1_;
	_tmp2_ = g_string_new ("");
	self->output = _tmp2_;
	self->quoted = FALSE;
	self->this_command_key = NULL;
	self->last_command_key = NULL;
	self->priv->latin_conversion_upper = FALSE;
	self->overriding_input = NULL;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->completion = _tmp3_;
}


static void kkc_state_finalize (GObject * obj) {
	KkcState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_STATE, KkcState);
	kkc_state_reset (self);
	_g_object_unref0 (self->model);
	_g_object_unref0 (self->decoder);
	_g_object_unref0 (self->segments);
	_g_object_unref0 (self->candidates);
	_g_object_unref0 (self->dictionaries);
	_g_object_unref0 (self->rom_kana_converter);
	_g_object_unref0 (self->input_characters);
	_g_string_free0 (self->selection);
	_g_string_free0 (self->output);
	_g_object_unref0 (self->this_command_key);
	_g_object_unref0 (self->last_command_key);
	_g_free0 (self->overriding_input);
	_g_object_unref0 (self->priv->completion);
	_g_object_unref0 (self->completion_iterator);
	_g_object_unref0 (self->priv->_typing_rule);
	G_OBJECT_CLASS (kkc_state_parent_class)->finalize (obj);
}


GType kkc_state_get_type (void) {
	static volatile gsize kkc_state_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcState), 0, (GInstanceInitFunc) kkc_state_instance_init, NULL };
		GType kkc_state_type_id;
		kkc_state_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcState", &g_define_type_info, 0);
		g_once_init_leave (&kkc_state_type_id__volatile, kkc_state_type_id);
	}
	return kkc_state_type_id__volatile;
}


static void _vala_kkc_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_STATE, KkcState);
	switch (property_id) {
		case KKC_STATE_INPUT_MODE_PROPERTY:
		g_value_set_enum (value, kkc_state_get_input_mode (self));
		break;
		case KKC_STATE_INPUT_CURSOR_POS_PROPERTY:
		g_value_set_int (value, kkc_state_get_input_cursor_pos (self));
		break;
		case KKC_STATE_INPUT_CURSOR_WIDTH_PROPERTY:
		g_value_set_uint (value, kkc_state_get_input_cursor_width (self));
		break;
		case KKC_STATE_PUNCTUATION_STYLE_PROPERTY:
		g_value_set_enum (value, kkc_state_get_punctuation_style (self));
		break;
		case KKC_STATE_AUTO_CORRECT_PROPERTY:
		g_value_set_boolean (value, kkc_state_get_auto_correct (self));
		break;
		case KKC_STATE_TYPING_RULE_PROPERTY:
		g_value_set_object (value, kkc_state_get_typing_rule (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_state_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_STATE, KkcState);
	switch (property_id) {
		case KKC_STATE_INPUT_MODE_PROPERTY:
		kkc_state_set_input_mode (self, g_value_get_enum (value));
		break;
		case KKC_STATE_PUNCTUATION_STYLE_PROPERTY:
		kkc_state_set_punctuation_style (self, g_value_get_enum (value));
		break;
		case KKC_STATE_AUTO_CORRECT_PROPERTY:
		kkc_state_set_auto_correct (self, g_value_get_boolean (value));
		break;
		case KKC_STATE_TYPING_RULE_PROPERTY:
		kkc_state_set_typing_rule (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gboolean kkc_command_handler_call (KkcCommandHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_COMMAND_HANDLER_GET_INTERFACE (self)->call (self, command, state, key);
}


static void kkc_command_handler_base_init (KkcCommandHandlerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType kkc_command_handler_get_type (void) {
	static volatile gsize kkc_command_handler_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_command_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcCommandHandlerIface), (GBaseInitFunc) kkc_command_handler_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType kkc_command_handler_type_id;
		kkc_command_handler_type_id = g_type_register_static (G_TYPE_INTERFACE, "KkcCommandHandler", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (kkc_command_handler_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&kkc_command_handler_type_id__volatile, kkc_command_handler_type_id);
	}
	return kkc_command_handler_type_id__volatile;
}


KkcCallbackCommandHandler* kkc_callback_command_handler_construct (GType object_type, KkcCommandCallback cb, void* cb_target) {
	KkcCallbackCommandHandler * self = NULL;
	KkcCommandCallback _tmp0_;
	void* _tmp0__target;
	self = (KkcCallbackCommandHandler*) g_object_new (object_type, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	self->priv->cb = _tmp0_;
	self->priv->cb_target = _tmp0__target;
	return self;
}


KkcCallbackCommandHandler* kkc_callback_command_handler_new (KkcCommandCallback cb, void* cb_target) {
	return kkc_callback_command_handler_construct (KKC_TYPE_CALLBACK_COMMAND_HANDLER, cb, cb_target);
}


static gboolean kkc_callback_command_handler_real_call (KkcCommandHandler* base, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	KkcCallbackCommandHandler * self;
	gboolean result = FALSE;
	KkcCommandCallback _tmp0_;
	void* _tmp0__target;
	const gchar* _tmp1_;
	KkcState* _tmp2_;
	KkcKeyEvent* _tmp3_;
	gboolean _tmp4_;
	self = (KkcCallbackCommandHandler*) base;
	g_return_val_if_fail (command != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->cb;
	_tmp0__target = self->priv->cb_target;
	_tmp1_ = command;
	_tmp2_ = state;
	_tmp3_ = key;
	_tmp4_ = _tmp0_ (_tmp1_, _tmp2_, _tmp3_, _tmp0__target);
	result = _tmp4_;
	return result;
}


static void kkc_callback_command_handler_class_init (KkcCallbackCommandHandlerClass * klass) {
	kkc_callback_command_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcCallbackCommandHandlerPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_callback_command_handler_finalize;
}


static void kkc_callback_command_handler_kkc_command_handler_interface_init (KkcCommandHandlerIface * iface) {
	kkc_callback_command_handler_kkc_command_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->call = (gboolean (*) (KkcCommandHandler *, const gchar*, KkcState*, KkcKeyEvent*)) kkc_callback_command_handler_real_call;
}


static void kkc_callback_command_handler_instance_init (KkcCallbackCommandHandler * self) {
	self->priv = KKC_CALLBACK_COMMAND_HANDLER_GET_PRIVATE (self);
}


static void kkc_callback_command_handler_finalize (GObject * obj) {
	KkcCallbackCommandHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_CALLBACK_COMMAND_HANDLER, KkcCallbackCommandHandler);
	G_OBJECT_CLASS (kkc_callback_command_handler_parent_class)->finalize (obj);
}


GType kkc_callback_command_handler_get_type (void) {
	static volatile gsize kkc_callback_command_handler_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_callback_command_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcCallbackCommandHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_callback_command_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcCallbackCommandHandler), 0, (GInstanceInitFunc) kkc_callback_command_handler_instance_init, NULL };
		static const GInterfaceInfo kkc_command_handler_info = { (GInterfaceInitFunc) kkc_callback_command_handler_kkc_command_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_callback_command_handler_type_id;
		kkc_callback_command_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcCallbackCommandHandler", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_callback_command_handler_type_id, KKC_TYPE_COMMAND_HANDLER, &kkc_command_handler_info);
		g_once_init_leave (&kkc_callback_command_handler_type_id__volatile, kkc_callback_command_handler_type_id);
	}
	return kkc_callback_command_handler_type_id__volatile;
}


void kkc_state_handler_register_command_handler (KkcStateHandler* self, const gchar* command, KkcCommandHandler* handler) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handler != NULL);
	_tmp0_ = command;
	if (_tmp0_ != NULL) {
		GeeMap* _tmp1_;
		const gchar* _tmp2_;
		KkcCommandHandler* _tmp3_;
		_tmp1_ = self->priv->command_handlers;
		_tmp2_ = command;
		_tmp3_ = handler;
		gee_map_set (_tmp1_, _tmp2_, _tmp3_);
	} else {
		KkcCommandHandler* _tmp4_;
		KkcCommandHandler* _tmp5_;
		_tmp4_ = handler;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (self->priv->default_command_handler);
		self->priv->default_command_handler = _tmp5_;
	}
}


void kkc_state_handler_register_command_callback (KkcStateHandler* self, const gchar* command, KkcCommandCallback cb, void* cb_target) {
	const gchar* _tmp0_;
	KkcCommandCallback _tmp1_;
	void* _tmp1__target;
	KkcCallbackCommandHandler* _tmp2_;
	KkcCallbackCommandHandler* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = command;
	_tmp1_ = cb;
	_tmp1__target = cb_target;
	_tmp2_ = kkc_callback_command_handler_new (_tmp1_, _tmp1__target);
	_tmp3_ = _tmp2_;
	kkc_state_handler_register_command_handler (self, _tmp0_, (KkcCommandHandler*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}


static gboolean kkc_state_handler_real_default_command_callback (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `kkc_state_handler_default_command_callback'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean kkc_state_handler_default_command_callback (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_STATE_HANDLER_GET_CLASS (self)->default_command_callback (self, command, state, key);
}


gboolean kkc_state_handler_dispatch_command (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp14_;
	KkcState* _tmp15_;
	KkcKeyEvent* _tmp16_;
	gboolean _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = command;
	if (_tmp1_ != NULL) {
		GeeMap* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->command_handlers;
		_tmp3_ = command;
		_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_;
		KkcCommandHandler* _tmp8_;
		const gchar* _tmp9_;
		KkcState* _tmp10_;
		KkcKeyEvent* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp5_ = self->priv->command_handlers;
		_tmp6_ = command;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_tmp8_ = (KkcCommandHandler*) _tmp7_;
		_tmp9_ = command;
		_tmp10_ = state;
		_tmp11_ = key;
		_tmp12_ = kkc_command_handler_call (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp8_);
		result = _tmp13_;
		return result;
	}
	_tmp14_ = command;
	_tmp15_ = state;
	_tmp16_ = key;
	_tmp17_ = kkc_state_handler_default_command_callback (self, _tmp14_, _tmp15_, _tmp16_);
	result = _tmp17_;
	return result;
}


static gboolean kkc_state_handler_real_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `kkc_state_handler_process_key_event'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean kkc_state_handler_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_STATE_HANDLER_GET_CLASS (self)->process_key_event (self, state, key);
}


KkcStateHandler* kkc_state_handler_construct (GType object_type) {
	KkcStateHandler * self = NULL;
	self = (KkcStateHandler*) g_object_new (object_type, NULL);
	return self;
}


static void kkc_state_handler_class_init (KkcStateHandlerClass * klass) {
	kkc_state_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcStateHandlerPrivate));
	((KkcStateHandlerClass *) klass)->default_command_callback = (gboolean (*) (KkcStateHandler *, const gchar*, KkcState*, KkcKeyEvent*)) kkc_state_handler_real_default_command_callback;
	((KkcStateHandlerClass *) klass)->process_key_event = (gboolean (*) (KkcStateHandler *, KkcState*, KkcKeyEvent*)) kkc_state_handler_real_process_key_event;
	G_OBJECT_CLASS (klass)->finalize = kkc_state_handler_finalize;
}


static void kkc_state_handler_instance_init (KkcStateHandler * self) {
	GeeHashMap* _tmp0_;
	self->priv = KKC_STATE_HANDLER_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, KKC_TYPE_COMMAND_HANDLER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->command_handlers = (GeeMap*) _tmp0_;
	self->priv->default_command_handler = NULL;
}


static void kkc_state_handler_finalize (GObject * obj) {
	KkcStateHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_STATE_HANDLER, KkcStateHandler);
	_g_object_unref0 (self->priv->command_handlers);
	_g_object_unref0 (self->priv->default_command_handler);
	G_OBJECT_CLASS (kkc_state_handler_parent_class)->finalize (obj);
}


GType kkc_state_handler_get_type (void) {
	static volatile gsize kkc_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcStateHandler), 0, (GInstanceInitFunc) kkc_state_handler_instance_init, NULL };
		GType kkc_state_handler_type_id;
		kkc_state_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcStateHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&kkc_state_handler_type_id__volatile, kkc_state_handler_type_id);
	}
	return kkc_state_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



