/* $Id: texts.c,v 1.5 2005/05/21 19:55:45 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff. Texts, titles and stuff.

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "xwmh.h"


int GGIwmh_x_settitle(ggi_visual *vis,const char *title)
{
	ggi_x_priv *priv = GGIX_PRIV(vis);

	ggLock(priv->xliblock);
	XStoreName(priv->disp, priv->parentwin, title);
        XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}

int GGIwmh_x_seticontitle(ggi_visual *vis,const char *title)
{
	ggi_x_priv *priv = GGIX_PRIV(vis);

	ggLock(priv->xliblock);
	XSetIconName(priv->disp, priv->parentwin, title);
        XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}

int GGIwmh_x_iconify(ggi_visual *vis,int newstate)
{
	ggi_x_priv *priv = GGIX_PRIV(vis);

	ggLock(priv->xliblock);
	switch(newstate) {
	case GGI_WMH_MAPSTATE_NORMAL:
		XMapWindow(priv->disp, priv->parentwin);
		break;
	case GGI_WMH_MAPSTATE_ICON:
		XIconifyWindow(priv->disp, priv->parentwin, 
			priv->vilist[priv->viidx].vi->screen);
		break;
	case GGI_WMH_MAPSTATE_WITHDRAWN:
		XWithdrawWindow(priv->disp, priv->parentwin, 
		       priv->vilist[priv->viidx].vi->screen);
		break;
	}
	XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}
