; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64 -mattr=+faminmax -mattr=+sve2 -verify-machineinstrs %s -o - | FileCheck %s
; RUN: llc -mtriple=aarch64 -mattr=+faminmax -mattr=+sme2 -force-streaming -verify-machineinstrs %s -o - | FileCheck %s
; RUN: llc -mtriple=aarch64 -mattr=+sve2 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK-NO-FAMINMAX

; Replace pattern max(abs(a), abs(b)) by famax(a,b)
; Replace pattern min(abs(a), abs(b)) by famin(a,b)

; When the fastmath flag 'nnan' (no nan) is enabled, we may also replace:
; minnm(abs(a), abs(b)) with famin(a, b)
; maxnm(abs(a), abs(b)) with famax(a, b)

define <vscale x 4 x half> @famax_max_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famax_max_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_max_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call <vscale x 4 x half> @llvm.maximum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @famax_maxnm_nnan_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famax_maxnm_nnan_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_nnan_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call nnan <vscale x 4 x half> @llvm.maxnum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @famax_maxnm_noflag_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famax_maxnm_noflag_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_noflag_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call <vscale x 4 x half> @llvm.maxnum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @famin_min_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famin_min_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_min_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call <vscale x 4 x half> @llvm.minimum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @famin_minnm_nnan_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famin_minnm_nnan_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_nnan_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call nnan <vscale x 4 x half> @llvm.minnum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @famin_minnm_noflag_nx4f16(<vscale x 4 x half> %a, <vscale x 4 x half> %b) {
; CHECK-LABEL: famin_minnm_noflag_nx4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_noflag_nx4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %a)
    %bb = call <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half> %b)
    %r = call <vscale x 4 x half> @llvm.minnum.nxv4f16(<vscale x 4 x half> %aa, <vscale x 4 x half> %bb)
    ret <vscale x 4 x half> %r
}

define <vscale x 8 x half> @famax_max_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famax_max_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    famax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_max_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call <vscale x 8 x half> @llvm.maximum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @famax_maxnm_nnan_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famax_maxnm_nnan_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    famax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_nnan_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call nnan <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @famax_maxnm_noflag_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famax_maxnm_noflag_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_noflag_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @famin_min_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famin_min_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    famin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_min_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @famin_minnm_nnan_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famin_minnm_nnan_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    famin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_nnan_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call nnan <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @famin_minnm_noflag_nx8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: famin_minnm_noflag_nx8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_noflag_nx8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.h, p0/m, z0.h
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.h, p0/m, z1.h
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %a)
    %bb = call <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half> %b)
    %r = call  <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half> %aa, <vscale x 8 x half> %bb)
    ret <vscale x 8 x half> %r
}

define <vscale x 2 x float> @famax_max_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famax_max_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_max_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call <vscale x 2 x float> @llvm.maximum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @famax_maxnm_nnan_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famax_maxnm_nnan_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_nnan_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call nnan <vscale x 2 x float> @llvm.maxnum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @famax_maxnm_noflag_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famax_maxnm_noflag_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_noflag_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call <vscale x 2 x float> @llvm.maxnum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @famin_min_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famin_min_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_min_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call <vscale x 2 x float> @llvm.minimum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @famin_minnm_nnan_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famin_minnm_nnan_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_nnan_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call nnan <vscale x 2 x float> @llvm.minnum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @famin_minnm_noflag_nx2f32(<vscale x 2 x float> %a, <vscale x 2 x float> %b) {
; CHECK-LABEL: famin_minnm_noflag_nx2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_noflag_nx2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %a)
    %bb = call <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float> %b)
    %r = call <vscale x 2 x float> @llvm.minnum.nx2f32(<vscale x 2 x float> %aa, <vscale x  2 x float> %bb)
    ret <vscale x 2 x float> %r
}

define <vscale x 4 x float> @famax_max_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famax_max_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_max_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call <vscale x 4 x float> @llvm.maximum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @famax_maxnm_nnan_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famax_maxnm_nnan_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_nnan_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call nnan <vscale x 4 x float> @llvm.maxnum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @famax_maxnm_noflag_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famax_maxnm_noflag_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_noflag_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call <vscale x 4 x float> @llvm.maxnum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @famin_min_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famin_min_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_min_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call <vscale x 4 x float> @llvm.minimum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @famin_minnm_nnan_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famin_minnm_nnan_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    famin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_nnan_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call nnan <vscale x 4 x float> @llvm.minnum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @famin_minnm_noflag_nx4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: famin_minnm_noflag_nx4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_noflag_nx4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.s, p0/m, z0.s
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.s, p0/m, z1.s
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %a)
    %bb = call <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float> %b)
    %r = call <vscale x 4 x float> @llvm.minnum.nx4f32(<vscale x 4 x float> %aa, <vscale x  4 x float> %bb)
    ret <vscale x 4 x float> %r
}

define <vscale x 2 x double> @famax_max_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famax_max_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_max_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fmax z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call <vscale x 2 x double> @llvm.maximum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @famax_maxnm_nnan_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famax_maxnm_nnan_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_nnan_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call nnan <vscale x 2 x double> @llvm.maxnum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @famax_maxnm_noflag_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famax_maxnm_noflag_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famax_maxnm_noflag_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call <vscale x 2 x double> @llvm.maxnum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @famin_min_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famin_min_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_min_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fmin z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call <vscale x 2 x double> @llvm.minimum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @famin_minnm_nnan_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famin_minnm_nnan_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    famin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_nnan_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call nnan <vscale x 2 x double> @llvm.minnum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @famin_minnm_noflag_nx2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: famin_minnm_noflag_nx2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: famin_minnm_noflag_nx2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    ptrue p0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z0.d, p0/m, z0.d
; CHECK-NO-FAMINMAX-NEXT:    fabs z1.d, p0/m, z1.d
; CHECK-NO-FAMINMAX-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NO-FAMINMAX-NEXT:    ret
    %aa = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %a)
    %bb = call <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double> %b)
    %r = call <vscale x 2 x double> @llvm.minnum.nx2f64(<vscale x 2 x double> %aa, <vscale x 2 x double> %bb)
    ret <vscale x 2 x double> %r
}

declare <vscale x 4 x half> @llvm.fabs.nxv4f16(<vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.fabs.nxv8f16(<vscale x 8 x half>)
declare <vscale x 2 x float> @llvm.fabs.nx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.fabs.nx4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.fabs.nx2f64(<vscale x 2 x double>)

declare <vscale x 4 x half> @llvm.maximum.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.maximum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x float> @llvm.maximum.nx2f32(<vscale x 2 x float>, <vscale x  2 x float>)
declare <vscale x 4 x float> @llvm.maximum.nx4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.maximum.nx2f64(<vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 4 x half> @llvm.minimum.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.minimum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x float> @llvm.minimum.nx2f32(<vscale x 2 x float>, <vscale x  2 x float>)
declare <vscale x 4 x float> @llvm.minimum.nx4f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.minimum.nx2f64(<vscale x 2 x double>, <vscale x 2 x double>)

declare <vscale x 4 x half> @llvm.maxnum.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.maxnum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half> )
declare <vscale x 2 x float> @llvm.maxnum.nx2f32(<vscale x 2 x float>, <vscale x  2 x float>)
declare <vscale x 2 x double> @llvm.maxnum.nx2f64(<vscale x 2 x double>, <vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.maxnum.nx4f32(<vscale x 4 x float>, <vscale x  4 x float>)

declare <vscale x 4 x half> @llvm.minnum.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.minnum.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 2 x float> @llvm.minnum.nx2f32(<vscale x 2 x float>, <vscale x  2 x float>)
declare <vscale x 4 x float> @llvm.minnum.nx4f32(<vscale x 4 x float>, <vscale x  4 x float>)
declare <vscale x 2 x double> @llvm.minnum.nx2f64(<vscale x 2 x double>, <vscale x 2 x double>)
