/* panel.c generated by valac 0.20.1, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus-xkb - IBus XKB
 *
 * Copyright(c) 2012 Takao Fujiwara <takao.fujiwara1@gmail.com>
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <ibusxkbtypes.h>
#include <ibusxkbxml.h>
#include <signal.h>
#include <sys/types.h>
#include <glib/gi18n-lib.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define TYPE_GKBD_LAYOUT (gkbd_layout_get_type ())
#define GKBD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GKBD_LAYOUT, GkbdLayout))
#define GKBD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GKBD_LAYOUT, GkbdLayoutClass))
#define IS_GKBD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GKBD_LAYOUT))
#define IS_GKBD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GKBD_LAYOUT))
#define GKBD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GKBD_LAYOUT, GkbdLayoutClass))

typedef struct _GkbdLayout GkbdLayout;
typedef struct _GkbdLayoutClass GkbdLayoutClass;

#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gkbd_layout_unref0(var) ((var == NULL) ? NULL : (var = (gkbd_layout_unref (var), NULL)))
#define _xkb_layout_unref0(var) ((var == NULL) ? NULL : (var = (xkb_layout_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _Block4Data Block4Data;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelPrivate {
	IBusBus* m_bus;
	IBusConfig* m_config;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	PropertyManager* m_property_manager;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	GkbdLayout* m_gkbdlayout;
	XKBLayout* m_xkblayout;
	gchar** m_layouts;
	gint m_layouts_length1;
	gint _m_layouts_size_;
	gchar** m_variants;
	gint m_variants_length1;
	gint _m_variants_size_;
	gint m_fallback_lock_id;
	gboolean m_changed_xkb_option;
	GTimer* m_changed_layout_timer;
	GList* m_keybindings;
	gchar** ACCELERATOR_IME_HOTKEYS;
	gint ACCELERATOR_IME_HOTKEYS_length1;
	gint _ACCELERATOR_IME_HOTKEYS_size_;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _Block4Data {
	int _ref_count_;
	Panel * self;
	IBusEngineDesc* e;
};


static gpointer panel_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_manager (GValue* value, gpointer v_object);
void value_take_property_manager (GValue* value, gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
gpointer gkbd_layout_ref (gpointer instance);
void gkbd_layout_unref (gpointer instance);
GParamSpec* param_spec_gkbd_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gkbd_layout (GValue* value, gpointer v_object);
void value_take_gkbd_layout (GValue* value, gpointer v_object);
gpointer value_get_gkbd_layout (const GValue* value);
GType gkbd_layout_get_type (void) G_GNUC_CONST;
gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_xkb_layout (GValue* value, gpointer v_object);
void value_take_xkb_layout (GValue* value, gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
enum  {
	PANEL_DUMMY_PROPERTY
};
GType keybinding_manager_get_type (void) G_GNUC_CONST;
KeybindingManager* keybinding_manager_get_instance (void);
void keybinding_manager_unbind (KeybindingManager* self, const gchar* accelerator);
#define PANEL_ACCELERATOR_SWITCH_IME_FOREWARD "<Control>space"
#define PANEL_ACCELERATOR_SWITCH_IME_BACKWARD "<Control><Shift>space"
static void panel_gkbdlayout_changed_cb (Panel* self);
static void _panel_gkbdlayout_changed_cb_gkbd_layout_changed (GkbdLayout* _sender, gpointer self);
void gkbd_layout_stop_listen (GkbdLayout* self);
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type, IBusBus* bus);
static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon);
static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda23_ (Panel* self, CandidatePanel* w);
static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self);
static void __lambda24_ (Panel* self, CandidatePanel* w);
static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda25_ (Panel* self, const gchar* k, gint s);
static void ___lambda25__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self);
static void panel_set_keybinding (Panel* self);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value);
gboolean keybinding_manager_bind (KeybindingManager* self, const gchar* accelerator, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static void ____lambda26_ (Panel* self, GdkEvent* e);
static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert);
static void _____lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void _____lambda27_ (Panel* self, GdkEvent* e);
static void ______lambda27__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
GList* keybinding_manager_get_keybindings (KeybindingManager* self);
static void panel_set_custom_font (Panel* self);
void panel_set_config (Panel* self, IBusConfig* config);
static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant);
static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self);
static void panel_init_engines_order (Panel* self);
static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order);
void gkbd_layout_lock_group (GkbdLayout* self, gint id);
void xkb_layout_reset_layout (XKBLayout* self);
static void panel_update_xkb_engines (Panel* self);
static void panel_init_gkbd (Panel* self);
GkbdLayout* gkbd_layout_new (void);
GkbdLayout* gkbd_layout_construct (GType object_type);
void gkbd_layout_start_listen (GkbdLayout* self);
XKBLayout* xkb_layout_new (IBusConfig* config);
XKBLayout* xkb_layout_construct (GType object_type, IBusConfig* config);
static void panel_update_im_engines (Panel* self);
static gboolean panel_set_lang_relative_preload_engines (Panel* self);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
gchar* xkb_layout_get_layout (XKBLayout* self);
gchar* xkb_layout_get_variant (XKBLayout* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value);
static void panel_set_xkb_group_layout (Panel* self, const gchar* layout);
gint* xkb_layout_set_layout (XKBLayout* self, const gchar* _layout, const gchar* _variant, const gchar* _option, int* result_length1);
static gboolean panel_set_gkbd_layout (Panel* self, const gchar* layout);
gchar** gkbd_layout_get_group_names (GkbdLayout* self, int* result_length1);
static void panel_set_layout (Panel* self, const gchar* layout);
static void panel_switch_engine (Panel* self, gint i, gboolean force);
static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value);
guint keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
gint switcher_run (Switcher* self, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, GList* keybindings);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value);
static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length);
static IBusEngineDesc** _vala_array_dup6 (IBusEngineDesc** self, int length);
static void panel_show_setup_dialog (Panel* self);
static void __lambda18_ (Panel* self, GPid pid, gint state);
static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda17_ (Panel* self, GtkMenuItem* i);
static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda19_ (Panel* self, GtkMenuItem* i);
static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda20_ (Panel* self, GtkMenuItem* i);
static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda21_ (Panel* self, GtkMenuItem* i);
static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
gint property_manager_create_menu_items (PropertyManager* self, GtkMenu* menu);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
IconWidget* icon_widget_new (const gchar* icon, gint size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon, gint size);
GType icon_widget_get_type (void) G_GNUC_CONST;
static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item);
static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props);
void property_manager_set_properties (PropertyManager* self, IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop);
void property_manager_update_property (PropertyManager* self, IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_state_changed (IBusPanelService* base);
static void panel_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _panel_gkbdlayout_changed_cb_gkbd_layout_changed (GkbdLayout* _sender, gpointer self) {
	panel_gkbdlayout_changed_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	panel_status_icon_popup_menu_cb (self, _sender, button, activate_time);
}


static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	panel_status_icon_activate_cb (self, _sender);
}


static void __lambda23_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self) {
	__lambda23_ (self, _sender);
}


static void __lambda24_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self) {
	__lambda24_ (self, _sender);
}


static void __lambda25_ (Panel* self, const gchar* k, gint s) {
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda25__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self) {
	__lambda25_ (self, key, state);
}


Panel* panel_construct (GType object_type, IBusBus* bus) {
	Panel * self = NULL;
	IBusBus* _tmp0_;
	gboolean _tmp1_ = FALSE;
	IBusBus* _tmp2_;
	GDBusConnection* _tmp3_ = NULL;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	GtkStatusIcon* _tmp6_;
	GtkStatusIcon* _tmp7_;
	GtkStatusIcon* _tmp8_;
	GtkStatusIcon* _tmp9_;
	GtkStatusIcon* _tmp10_;
	GtkStatusIcon* _tmp11_;
	CandidatePanel* _tmp12_;
	CandidatePanel* _tmp13_;
	CandidatePanel* _tmp14_;
	Switcher* _tmp15_;
	PropertyManager* _tmp16_;
	PropertyManager* _tmp17_;
	g_return_val_if_fail (bus != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (Panel*) g_object_new (object_type, "connection", _tmp3_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	_tmp6_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp6_;
	_tmp7_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp7_, "ibus-ui-gtk");
	_tmp8_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp8_, "IBus Panel");
	_tmp9_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp9_, "popup-menu", (GCallback) _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu, self, 0);
	_tmp10_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _panel_status_icon_activate_cb_gtk_status_icon_activate, self, 0);
	_tmp11_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp11_, "ibus-keyboard");
	_tmp12_ = candidate_panel_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp12_;
	_tmp13_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp13_, "page-up", (GCallback) ___lambda23__candidate_panel_page_up, self, 0);
	_tmp14_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp14_, "page-down", (GCallback) ___lambda24__candidate_panel_page_down, self, 0);
	_tmp15_ = switcher_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp15_;
	_tmp16_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp16_;
	_tmp17_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp17_, "property-activate", (GCallback) ___lambda25__property_manager_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel* panel_new (IBusBus* bus) {
	return panel_construct (TYPE_PANEL, bus);
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ____lambda26_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, FALSE);
}


static void _____lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	____lambda26_ (self, event);
}


static void _____lambda27_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, TRUE);
}


static void ______lambda27__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	_____lambda27_ (self, event);
}


static void panel_set_keybinding (Panel* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* locale;
	const gchar* _tmp2_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	IBusConfig* _tmp6_;
	gboolean _tmp23_ = FALSE;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gboolean _tmp27_;
	KeybindingManager* _tmp36_ = NULL;
	KeybindingManager* keybinding_manager;
	gchar** _tmp37_;
	gint _tmp37__length1;
	KeybindingManager* _tmp43_;
	GList* _tmp44_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = setlocale (LC_ALL, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("C");
		_g_free0 (locale);
		locale = _tmp3_;
	}
	_tmp4_ = self->priv->ACCELERATOR_IME_HOTKEYS;
	_tmp4__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
	_tmp5_ = g_strdup (PANEL_ACCELERATOR_SWITCH_IME_FOREWARD);
	_vala_array_add10 (&self->priv->ACCELERATOR_IME_HOTKEYS, &self->priv->ACCELERATOR_IME_HOTKEYS_length1, &self->priv->_ACCELERATOR_IME_HOTKEYS_size_, _tmp5_);
	_tmp6_ = self->priv->m_config;
	if (_tmp6_ != NULL) {
		IBusConfig* _tmp7_;
		GVariant* _tmp8_ = NULL;
		GVariant* variant;
		GVariant* _tmp9_;
		_tmp7_ = self->priv->m_config;
		_tmp8_ = ibus_config_get_value (_tmp7_, "general/hotkey", "trigger_accel");
		variant = _tmp8_;
		_tmp9_ = variant;
		if (_tmp9_ != NULL) {
			gchar** _tmp10_ = NULL;
			_tmp10_ = g_new0 (gchar*, 0 + 1);
			self->priv->ACCELERATOR_IME_HOTKEYS = (_vala_array_free (self->priv->ACCELERATOR_IME_HOTKEYS, self->priv->ACCELERATOR_IME_HOTKEYS_length1, (GDestroyNotify) g_free), NULL);
			self->priv->ACCELERATOR_IME_HOTKEYS = _tmp10_;
			self->priv->ACCELERATOR_IME_HOTKEYS_length1 = 0;
			self->priv->_ACCELERATOR_IME_HOTKEYS_size_ = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp11_;
					_tmp11_ = TRUE;
					while (TRUE) {
						gboolean _tmp12_;
						gint _tmp14_;
						GVariant* _tmp15_;
						gsize _tmp16_ = 0UL;
						gchar** _tmp17_;
						gint _tmp17__length1;
						GVariant* _tmp18_;
						gint _tmp19_;
						GVariant* _tmp20_ = NULL;
						GVariant* _tmp21_;
						gchar* _tmp22_ = NULL;
						_tmp12_ = _tmp11_;
						if (!_tmp12_) {
							gint _tmp13_;
							_tmp13_ = i;
							i = _tmp13_ + 1;
						}
						_tmp11_ = FALSE;
						_tmp14_ = i;
						_tmp15_ = variant;
						_tmp16_ = g_variant_n_children (_tmp15_);
						if (!(((gsize) _tmp14_) < _tmp16_)) {
							break;
						}
						_tmp17_ = self->priv->ACCELERATOR_IME_HOTKEYS;
						_tmp17__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
						_tmp18_ = variant;
						_tmp19_ = i;
						_tmp20_ = g_variant_get_child_value (_tmp18_, (gsize) _tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
						_vala_array_add11 (&self->priv->ACCELERATOR_IME_HOTKEYS, &self->priv->ACCELERATOR_IME_HOTKEYS_length1, &self->priv->_ACCELERATOR_IME_HOTKEYS_size_, _tmp22_);
						_g_variant_unref0 (_tmp21_);
					}
				}
			}
		}
		_g_variant_unref0 (variant);
	}
	_tmp24_ = self->priv->ACCELERATOR_IME_HOTKEYS;
	_tmp24__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
	if (_tmp24__length1 == 1) {
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->ACCELERATOR_IME_HOTKEYS;
		_tmp25__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
		_tmp26_ = _tmp25_[0];
		_tmp23_ = g_strcmp0 (_tmp26_, PANEL_ACCELERATOR_SWITCH_IME_FOREWARD) == 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp27_ = _tmp23_;
	if (_tmp27_) {
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gboolean _tmp31_;
		_tmp28_ = locale;
		_tmp29_ = string_slice (_tmp28_, (glong) 0, (glong) 2);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strcmp0 (_tmp30_, "ko") == 0;
		_g_free0 (_tmp30_);
		if (_tmp31_) {
			gchar** _tmp32_;
			gint _tmp32__length1;
			gchar* _tmp33_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			gchar* _tmp35_;
			_tmp32_ = self->priv->ACCELERATOR_IME_HOTKEYS;
			_tmp32__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
			_tmp33_ = g_strdup ("Hangul");
			_vala_array_add12 (&self->priv->ACCELERATOR_IME_HOTKEYS, &self->priv->ACCELERATOR_IME_HOTKEYS_length1, &self->priv->_ACCELERATOR_IME_HOTKEYS_size_, _tmp33_);
			_tmp34_ = self->priv->ACCELERATOR_IME_HOTKEYS;
			_tmp34__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
			_tmp35_ = g_strdup ("Alt_R");
			_vala_array_add13 (&self->priv->ACCELERATOR_IME_HOTKEYS, &self->priv->ACCELERATOR_IME_HOTKEYS_length1, &self->priv->_ACCELERATOR_IME_HOTKEYS_size_, _tmp35_);
		}
	}
	_tmp36_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp36_;
	_tmp37_ = self->priv->ACCELERATOR_IME_HOTKEYS;
	_tmp37__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
	{
		gchar** keybinding_collection = NULL;
		gint keybinding_collection_length1 = 0;
		gint _keybinding_collection_size_ = 0;
		gint keybinding_it = 0;
		keybinding_collection = _tmp37_;
		keybinding_collection_length1 = _tmp37__length1;
		for (keybinding_it = 0; keybinding_it < _tmp37__length1; keybinding_it = keybinding_it + 1) {
			gchar* _tmp38_;
			gchar* keybinding = NULL;
			_tmp38_ = g_strdup (keybinding_collection[keybinding_it]);
			keybinding = _tmp38_;
			{
				KeybindingManager* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp39_ = keybinding_manager;
				_tmp40_ = keybinding;
				keybinding_manager_bind (_tmp39_, _tmp40_, _____lambda26__keybinding_manager_keybinding_handler_func, self);
				_tmp41_ = keybinding;
				if (g_strcmp0 (_tmp41_, PANEL_ACCELERATOR_SWITCH_IME_FOREWARD) == 0) {
					KeybindingManager* _tmp42_;
					_tmp42_ = keybinding_manager;
					keybinding_manager_bind (_tmp42_, PANEL_ACCELERATOR_SWITCH_IME_BACKWARD, ______lambda27__keybinding_manager_keybinding_handler_func, self);
				}
				_g_free0 (keybinding);
			}
		}
	}
	_tmp43_ = keybinding_manager;
	_tmp44_ = keybinding_manager_get_keybindings (_tmp43_);
	_g_list_free0 (self->priv->m_keybindings);
	self->priv->m_keybindings = _tmp44_;
	_g_object_unref0 (keybinding_manager);
	_g_free0 (locale);
}


static void panel_set_custom_font (Panel* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_;
	GdkDisplay* display;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	GdkScreen* screen;
	GdkScreen* _tmp8_;
	gboolean use_custom_font;
	IBusConfig* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* var_use_custom_font;
	GVariant* _tmp11_;
	GtkCssProvider* _tmp14_;
	gboolean _tmp17_;
	gchar* font_name;
	IBusConfig* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* var_custom_font;
	GVariant* _tmp20_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* data_format;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* data;
	GtkCssProvider* _tmp28_;
	GdkScreen* _tmp34_;
	GtkCssProvider* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _tmp2_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = screen;
	if (_tmp8_ == NULL) {
		g_warning ("panel.vala:159: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	use_custom_font = FALSE;
	_tmp9_ = self->priv->m_config;
	_tmp10_ = ibus_config_get_value (_tmp9_, "panel", "use_custom_font");
	var_use_custom_font = _tmp10_;
	_tmp11_ = var_use_custom_font;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = var_use_custom_font;
		_tmp13_ = g_variant_get_boolean (_tmp12_);
		use_custom_font = _tmp13_;
	}
	_tmp14_ = self->priv->m_css_provider;
	if (_tmp14_ != NULL) {
		GdkScreen* _tmp15_;
		GtkCssProvider* _tmp16_;
		_tmp15_ = screen;
		_tmp16_ = self->priv->m_css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp15_, (GtkStyleProvider*) _tmp16_);
		_g_object_unref0 (self->priv->m_css_provider);
		self->priv->m_css_provider = NULL;
	}
	_tmp17_ = use_custom_font;
	if (_tmp17_ == FALSE) {
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	font_name = NULL;
	_tmp18_ = self->priv->m_config;
	_tmp19_ = ibus_config_get_value (_tmp18_, "panel", "custom_font");
	var_custom_font = _tmp19_;
	_tmp20_ = var_custom_font;
	if (_tmp20_ != NULL) {
		GVariant* _tmp21_;
		gchar* _tmp22_ = NULL;
		_tmp21_ = var_custom_font;
		_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
		_g_free0 (font_name);
		font_name = _tmp22_;
	}
	_tmp23_ = font_name;
	if (_tmp23_ == NULL) {
		g_warning ("panel.vala:189: No config panel:custom_font.");
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp24_ = g_strdup ("GtkLabel { font: %s; }");
	data_format = _tmp24_;
	_tmp25_ = data_format;
	_tmp26_ = font_name;
	_tmp27_ = g_strdup_printf (_tmp25_, _tmp26_);
	data = _tmp27_;
	_tmp28_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->m_css_provider);
	self->priv->m_css_provider = _tmp28_;
	{
		GtkCssProvider* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = self->priv->m_css_provider;
		_tmp30_ = data;
		gtk_css_provider_load_from_data (_tmp29_, _tmp30_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = font_name;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("panel.vala:200: Failed css_provider_from_data: %s: %s", _tmp31_, _tmp33_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = screen;
	_tmp35_ = self->priv->m_css_provider;
	gtk_style_context_add_provider_for_screen (_tmp34_, (GtkStyleProvider*) _tmp35_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (data_format);
	_g_variant_unref0 (var_custom_font);
	_g_free0 (font_name);
	_g_variant_unref0 (var_use_custom_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self) {
	panel_config_value_changed_cb (self, _sender, section, name, value);
}


void panel_set_config (Panel* self, IBusConfig* config) {
	IBusConfig* _tmp0_;
	IBusConfig* _tmp4_;
	IBusConfig* _tmp5_;
	IBusConfig* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	_tmp0_ = self->priv->m_config;
	if (_tmp0_ != NULL) {
		IBusConfig* _tmp1_;
		guint _tmp2_ = 0U;
		IBusConfig* _tmp3_;
		_tmp1_ = self->priv->m_config;
		g_signal_parse_name ("value-changed", ibus_config_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self);
		_tmp3_ = self->priv->m_config;
		ibus_config_watch (_tmp3_, NULL, NULL);
		_g_object_unref0 (self->priv->m_config);
		self->priv->m_config = NULL;
	}
	_tmp4_ = config;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_config);
	self->priv->m_config = _tmp5_;
	panel_set_keybinding (self);
	_tmp6_ = self->priv->m_config;
	if (_tmp6_ != NULL) {
		IBusConfig* _tmp7_;
		IBusConfig* _tmp8_;
		IBusConfig* _tmp9_;
		IBusConfig* _tmp10_;
		IBusConfig* _tmp11_;
		IBusConfig* _tmp12_;
		IBusConfig* _tmp13_;
		IBusConfig* _tmp14_;
		GVariant* _tmp15_ = NULL;
		GVariant* _tmp16_;
		IBusConfig* _tmp17_;
		GVariant* _tmp18_ = NULL;
		GVariant* _tmp19_;
		_tmp7_ = self->priv->m_config;
		g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self, 0);
		_tmp8_ = self->priv->m_config;
		ibus_config_watch (_tmp8_, "general", "preload_engines");
		_tmp9_ = self->priv->m_config;
		ibus_config_watch (_tmp9_, "general", "preload_engines_inited");
		_tmp10_ = self->priv->m_config;
		ibus_config_watch (_tmp10_, "general", "preload_engine_mode");
		_tmp11_ = self->priv->m_config;
		ibus_config_watch (_tmp11_, "general", "engines_order");
		_tmp12_ = self->priv->m_config;
		ibus_config_watch (_tmp12_, "panel", "custom_font");
		_tmp13_ = self->priv->m_config;
		ibus_config_watch (_tmp13_, "panel", "use_custom_font");
		panel_init_engines_order (self);
		_tmp14_ = self->priv->m_config;
		_tmp15_ = ibus_config_get_value (_tmp14_, "general", "preload_engines");
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->m_config;
		_tmp18_ = ibus_config_get_value (_tmp17_, "general", "engines_order");
		_tmp19_ = _tmp18_;
		panel_update_engines (self, _tmp16_, _tmp19_);
		_g_variant_unref0 (_tmp19_);
		_g_variant_unref0 (_tmp16_);
	} else {
		panel_update_engines (self, NULL, NULL);
	}
	panel_set_custom_font (self);
}


static void panel_gkbdlayout_changed_cb (Panel* self) {
	GTimer* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble elapsed;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_;
	gboolean _tmp5_;
	gint _tmp6_;
	GTimer* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_changed_layout_timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	elapsed = _tmp1_;
	_tmp3_ = elapsed;
	if (_tmp3_ < 1.0) {
		gdouble _tmp4_;
		_tmp4_ = elapsed;
		_tmp2_ = _tmp4_ > 0.0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->m_fallback_lock_id;
	if (_tmp6_ != (-1)) {
		GkbdLayout* _tmp7_;
		gint _tmp8_;
		_tmp7_ = self->priv->m_gkbdlayout;
		_tmp8_ = self->priv->m_fallback_lock_id;
		gkbd_layout_lock_group (_tmp7_, _tmp8_);
		self->priv->m_fallback_lock_id = -1;
	} else {
		XKBLayout* _tmp9_;
		_tmp9_ = self->priv->m_xkblayout;
		xkb_layout_reset_layout (_tmp9_);
	}
	panel_update_xkb_engines (self);
	_tmp10_ = self->priv->m_changed_layout_timer;
	g_timer_reset (_tmp10_);
}


static void panel_init_gkbd (Panel* self) {
	GkbdLayout* _tmp0_;
	GkbdLayout* _tmp1_;
	GTimer* _tmp2_;
	GTimer* _tmp3_;
	GkbdLayout* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gkbd_layout_new ();
	_gkbd_layout_unref0 (self->priv->m_gkbdlayout);
	self->priv->m_gkbdlayout = _tmp0_;
	_tmp1_ = self->priv->m_gkbdlayout;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _panel_gkbdlayout_changed_cb_gkbd_layout_changed, self, 0);
	_tmp2_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->m_changed_layout_timer);
	self->priv->m_changed_layout_timer = _tmp2_;
	_tmp3_ = self->priv->m_changed_layout_timer;
	g_timer_start (_tmp3_);
	_tmp4_ = self->priv->m_gkbdlayout;
	gkbd_layout_start_listen (_tmp4_);
}


static void panel_init_engines_order (Panel* self) {
	IBusConfig* _tmp0_;
	IBusConfig* _tmp1_;
	XKBLayout* _tmp2_;
	IBusConfig* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* var_engines;
	gchar** _tmp5_ = NULL;
	gchar** preload_engines;
	gint preload_engines_length1;
	gint _preload_engines_size_;
	GVariant* _tmp6_;
	gboolean preload_engines_inited;
	IBusConfig* _tmp10_;
	GVariant* _tmp11_ = NULL;
	GVariant* var_preload_engines_inited;
	GVariant* _tmp12_;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gboolean _tmp18_;
	gboolean _tmp22_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_config;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_config;
	_tmp2_ = xkb_layout_new (_tmp1_);
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	self->priv->m_xkblayout = _tmp2_;
	if (HAVE_IBUS_GKBD) {
		panel_init_gkbd (self);
	}
	_tmp3_ = self->priv->m_config;
	_tmp4_ = ibus_config_get_value (_tmp3_, "general", "preload_engines");
	var_engines = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	preload_engines = _tmp5_;
	preload_engines_length1 = 0;
	_preload_engines_size_ = preload_engines_length1;
	_tmp6_ = var_engines;
	if (_tmp6_ != NULL) {
		GVariant* _tmp7_;
		size_t _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp7_ = var_engines;
		_tmp9_ = g_variant_dup_strv (_tmp7_, &_tmp8_);
		preload_engines = (_vala_array_free (preload_engines, preload_engines_length1, (GDestroyNotify) g_free), NULL);
		preload_engines = _tmp9_;
		preload_engines_length1 = _tmp8_;
		_preload_engines_size_ = preload_engines_length1;
	}
	preload_engines_inited = FALSE;
	_tmp10_ = self->priv->m_config;
	_tmp11_ = ibus_config_get_value (_tmp10_, "general", "preload_engines_inited");
	var_preload_engines_inited = _tmp11_;
	_tmp12_ = var_preload_engines_inited;
	if (_tmp12_ != NULL) {
		GVariant* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = var_preload_engines_inited;
		_tmp14_ = g_variant_get_boolean (_tmp13_);
		preload_engines_inited = _tmp14_;
	}
	_tmp16_ = preload_engines;
	_tmp16__length1 = preload_engines_length1;
	if (_tmp16__length1 != 0) {
		gboolean _tmp17_;
		_tmp17_ = preload_engines_inited;
		_tmp15_ = !_tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp18_ = _tmp15_;
	if (_tmp18_) {
		IBusConfig* _tmp19_;
		GVariant* _tmp20_;
		GVariant* _tmp21_;
		preload_engines_inited = TRUE;
		_tmp19_ = self->priv->m_config;
		_tmp20_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp20_);
		_tmp21_ = _tmp20_;
		ibus_config_set_value (_tmp19_, "general", "preload_engines_inited", _tmp21_);
		_g_variant_unref0 (_tmp21_);
	}
	panel_update_xkb_engines (self);
	_tmp22_ = preload_engines_inited;
	if (!_tmp22_) {
		GVariant* _tmp23_;
		GVariant* variant;
		IBusConfig* _tmp24_;
		GVariant* _tmp25_;
		_tmp23_ = g_variant_new_int32 ((gint32) IBUS_XKB_PRELOAD_ENGINE_MODE_LANG_RELATIVE);
		g_variant_ref_sink (_tmp23_);
		variant = _tmp23_;
		_tmp24_ = self->priv->m_config;
		_tmp25_ = variant;
		ibus_config_set_value (_tmp24_, "general", "preload_engine_mode", _tmp25_);
		_g_variant_unref0 (variant);
	}
	panel_update_im_engines (self);
	_tmp26_ = preload_engines_inited;
	if (!_tmp26_) {
		IBusConfig* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		_tmp27_ = self->priv->m_config;
		_tmp28_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp28_);
		_tmp29_ = _tmp28_;
		ibus_config_set_value (_tmp27_, "general", "preload_engines_inited", _tmp29_);
		_g_variant_unref0 (_tmp29_);
	}
	_g_variant_unref0 (var_preload_engines_inited);
	preload_engines = (_vala_array_free (preload_engines, preload_engines_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (var_engines);
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean panel_set_lang_relative_preload_engines (Panel* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* locale;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* lang;
	IBusBus* _tmp11_;
	GList* _tmp12_ = NULL;
	GList* engines;
	gchar** _tmp13_ = NULL;
	gchar** im_engines;
	gint im_engines_length1;
	gint _im_engines_size_;
	const gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_ = NULL;
	gchar** _tmp36_;
	gint _tmp36__length1;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar** _tmp59_;
	gint _tmp59__length1;
	IBusConfig* _tmp60_;
	GVariant* _tmp61_ = NULL;
	GVariant* var_engines;
	gchar** _tmp62_ = NULL;
	gchar** orig_preload_engines;
	gint orig_preload_engines_length1;
	gint _orig_preload_engines_size_;
	gchar** _tmp63_ = NULL;
	gchar** preload_engines;
	gint preload_engines_length1;
	gint _preload_engines_size_;
	GVariant* _tmp64_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	gchar** _tmp75_;
	gint _tmp75__length1;
	gchar** _tmp82_;
	gint _tmp82__length1;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_;
	gchar** _tmp85_;
	gint _tmp85__length1;
	gchar* _tmp86_ = NULL;
	gchar* _tmp87_;
	gboolean _tmp88_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = setlocale (LC_CTYPE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("C");
		_g_free0 (locale);
		locale = _tmp3_;
	}
	_tmp4_ = locale;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ".", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	lang = _tmp10_;
	_tmp11_ = self->priv->m_bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	_tmp13_ = g_new0 (gchar*, 0 + 1);
	im_engines = _tmp13_;
	im_engines_length1 = 0;
	_im_engines_size_ = im_engines_length1;
	{
		GList* _tmp14_;
		GList* p;
		_tmp14_ = engines;
		p = _tmp14_;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				GList* _tmp19_;
				GList* _tmp20_;
				gconstpointer _tmp21_;
				IBusEngineDesc* engine;
				gboolean _tmp22_ = FALSE;
				IBusEngineDesc* _tmp23_;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_;
				gboolean _tmp28_;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					GList* _tmp17_;
					GList* _tmp18_;
					_tmp17_ = p;
					_tmp18_ = _tmp17_->next;
					p = _tmp18_;
				}
				_tmp15_ = FALSE;
				_tmp19_ = p;
				if (!(_tmp19_ != NULL)) {
					break;
				}
				_tmp20_ = p;
				_tmp21_ = _tmp20_->data;
				engine = (IBusEngineDesc*) _tmp21_;
				_tmp23_ = engine;
				_tmp24_ = ibus_engine_desc_get_language (_tmp23_);
				_tmp25_ = lang;
				if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
					IBusEngineDesc* _tmp26_;
					guint _tmp27_ = 0U;
					_tmp26_ = engine;
					_tmp27_ = ibus_engine_desc_get_rank (_tmp26_);
					_tmp22_ = _tmp27_ > ((guint) 0);
				} else {
					_tmp22_ = FALSE;
				}
				_tmp28_ = _tmp22_;
				if (_tmp28_) {
					gchar** _tmp29_;
					gint _tmp29__length1;
					IBusEngineDesc* _tmp30_;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_;
					_tmp29_ = im_engines;
					_tmp29__length1 = im_engines_length1;
					_tmp30_ = engine;
					_tmp31_ = ibus_engine_desc_get_name (_tmp30_);
					_tmp32_ = g_strdup (_tmp31_);
					_vala_array_add14 (&im_engines, &im_engines_length1, &_im_engines_size_, _tmp32_);
				}
			}
		}
	}
	_tmp33_ = lang;
	_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, "_", 0);
	_tmp36_ = _tmp35_;
	_tmp36__length1 = _vala_array_length (_tmp34_);
	_tmp37_ = _tmp36_[0];
	_tmp38_ = g_strdup (_tmp37_);
	_g_free0 (lang);
	lang = _tmp38_;
	_tmp36_ = (_vala_array_free (_tmp36_, _tmp36__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = im_engines;
	_tmp39__length1 = im_engines_length1;
	if (_tmp39__length1 == 0) {
		{
			GList* _tmp40_;
			GList* p;
			_tmp40_ = engines;
			p = _tmp40_;
			{
				gboolean _tmp41_;
				_tmp41_ = TRUE;
				while (TRUE) {
					gboolean _tmp42_;
					GList* _tmp45_;
					GList* _tmp46_;
					gconstpointer _tmp47_;
					IBusEngineDesc* engine;
					gboolean _tmp48_ = FALSE;
					IBusEngineDesc* _tmp49_;
					const gchar* _tmp50_ = NULL;
					const gchar* _tmp51_;
					gboolean _tmp54_;
					_tmp42_ = _tmp41_;
					if (!_tmp42_) {
						GList* _tmp43_;
						GList* _tmp44_;
						_tmp43_ = p;
						_tmp44_ = _tmp43_->next;
						p = _tmp44_;
					}
					_tmp41_ = FALSE;
					_tmp45_ = p;
					if (!(_tmp45_ != NULL)) {
						break;
					}
					_tmp46_ = p;
					_tmp47_ = _tmp46_->data;
					engine = (IBusEngineDesc*) _tmp47_;
					_tmp49_ = engine;
					_tmp50_ = ibus_engine_desc_get_language (_tmp49_);
					_tmp51_ = lang;
					if (g_strcmp0 (_tmp50_, _tmp51_) == 0) {
						IBusEngineDesc* _tmp52_;
						guint _tmp53_ = 0U;
						_tmp52_ = engine;
						_tmp53_ = ibus_engine_desc_get_rank (_tmp52_);
						_tmp48_ = _tmp53_ > ((guint) 0);
					} else {
						_tmp48_ = FALSE;
					}
					_tmp54_ = _tmp48_;
					if (_tmp54_) {
						gchar** _tmp55_;
						gint _tmp55__length1;
						IBusEngineDesc* _tmp56_;
						const gchar* _tmp57_ = NULL;
						gchar* _tmp58_;
						_tmp55_ = im_engines;
						_tmp55__length1 = im_engines_length1;
						_tmp56_ = engine;
						_tmp57_ = ibus_engine_desc_get_name (_tmp56_);
						_tmp58_ = g_strdup (_tmp57_);
						_vala_array_add15 (&im_engines, &im_engines_length1, &_im_engines_size_, _tmp58_);
					}
				}
			}
		}
	}
	_tmp59_ = im_engines;
	_tmp59__length1 = im_engines_length1;
	if (_tmp59__length1 == 0) {
		result = FALSE;
		im_engines = (_vala_array_free (im_engines, im_engines_length1, (GDestroyNotify) g_free), NULL);
		__g_list_free__g_object_unref0_0 (engines);
		_g_free0 (lang);
		_g_free0 (locale);
		return result;
	}
	_tmp60_ = self->priv->m_config;
	_tmp61_ = ibus_config_get_value (_tmp60_, "general", "preload_engines");
	var_engines = _tmp61_;
	_tmp62_ = g_new0 (gchar*, 0 + 1);
	orig_preload_engines = _tmp62_;
	orig_preload_engines_length1 = 0;
	_orig_preload_engines_size_ = orig_preload_engines_length1;
	_tmp63_ = g_new0 (gchar*, 0 + 1);
	preload_engines = _tmp63_;
	preload_engines_length1 = 0;
	_preload_engines_size_ = preload_engines_length1;
	_tmp64_ = var_engines;
	if (_tmp64_ != NULL) {
		GVariant* _tmp65_;
		size_t _tmp66_;
		gchar** _tmp67_ = NULL;
		_tmp65_ = var_engines;
		_tmp67_ = g_variant_dup_strv (_tmp65_, &_tmp66_);
		orig_preload_engines = (_vala_array_free (orig_preload_engines, orig_preload_engines_length1, (GDestroyNotify) g_free), NULL);
		orig_preload_engines = _tmp67_;
		orig_preload_engines_length1 = _tmp66_;
		_orig_preload_engines_size_ = orig_preload_engines_length1;
	}
	_tmp68_ = orig_preload_engines;
	_tmp68__length1 = orig_preload_engines_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp68_;
		name_collection_length1 = _tmp68__length1;
		for (name_it = 0; name_it < _tmp68__length1; name_it = name_it + 1) {
			gchar* _tmp69_;
			gchar* name = NULL;
			_tmp69_ = g_strdup (name_collection[name_it]);
			name = _tmp69_;
			{
				const gchar* _tmp70_;
				gint _tmp71_ = 0;
				gchar** _tmp72_;
				gint _tmp72__length1;
				const gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp70_ = name;
				_tmp71_ = g_ascii_strncasecmp (_tmp70_, "xkb:", (gsize) 4);
				if (_tmp71_ != 0) {
					_g_free0 (name);
					continue;
				}
				_tmp72_ = preload_engines;
				_tmp72__length1 = preload_engines_length1;
				_tmp73_ = name;
				_tmp74_ = g_strdup (_tmp73_);
				_vala_array_add16 (&preload_engines, &preload_engines_length1, &_preload_engines_size_, _tmp74_);
				_g_free0 (name);
			}
		}
	}
	_tmp75_ = im_engines;
	_tmp75__length1 = im_engines_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp75_;
		name_collection_length1 = _tmp75__length1;
		for (name_it = 0; name_it < _tmp75__length1; name_it = name_it + 1) {
			gchar* _tmp76_;
			gchar* name = NULL;
			_tmp76_ = g_strdup (name_collection[name_it]);
			name = _tmp76_;
			{
				const gchar* _tmp77_;
				gchar** _tmp78_;
				gint _tmp78__length1;
				_tmp77_ = name;
				_tmp78_ = preload_engines;
				_tmp78__length1 = preload_engines_length1;
				if (!_vala_string_array_contains (_tmp78_, _tmp78__length1, _tmp77_)) {
					gchar** _tmp79_;
					gint _tmp79__length1;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					_tmp79_ = preload_engines;
					_tmp79__length1 = preload_engines_length1;
					_tmp80_ = name;
					_tmp81_ = g_strdup (_tmp80_);
					_vala_array_add17 (&preload_engines, &preload_engines_length1, &_preload_engines_size_, _tmp81_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp82_ = orig_preload_engines;
	_tmp82__length1 = orig_preload_engines_length1;
	_tmp83_ = g_strjoinv (",", _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = preload_engines;
	_tmp85__length1 = preload_engines_length1;
	_tmp86_ = g_strjoinv (",", _tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = g_strcmp0 (_tmp84_, _tmp87_) != 0;
	_g_free0 (_tmp87_);
	_g_free0 (_tmp84_);
	if (_tmp88_) {
		IBusConfig* _tmp89_;
		gchar** _tmp90_;
		gint _tmp90__length1;
		GVariant* _tmp91_;
		GVariant* _tmp92_;
		_tmp89_ = self->priv->m_config;
		_tmp90_ = preload_engines;
		_tmp90__length1 = preload_engines_length1;
		_tmp91_ = g_variant_new_strv (_tmp90_, _tmp90__length1);
		g_variant_ref_sink (_tmp91_);
		_tmp92_ = _tmp91_;
		ibus_config_set_value (_tmp89_, "general", "preload_engines", _tmp92_);
		_g_variant_unref0 (_tmp92_);
	}
	result = TRUE;
	preload_engines = (_vala_array_free (preload_engines, preload_engines_length1, (GDestroyNotify) g_free), NULL);
	orig_preload_engines = (_vala_array_free (orig_preload_engines, orig_preload_engines_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (var_engines);
	im_engines = (_vala_array_free (im_engines, im_engines_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free__g_object_unref0_0 (engines);
	_g_free0 (lang);
	_g_free0 (locale);
	return result;
}


static void panel_update_im_engines (Panel* self) {
	gint preload_engine_mode;
	IBusConfig* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* var_preload_engine_mode;
	GVariant* _tmp2_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	preload_engine_mode = (gint) IBUS_XKB_PRELOAD_ENGINE_MODE_USER;
	_tmp0_ = self->priv->m_config;
	_tmp1_ = ibus_config_get_value (_tmp0_, "general", "preload_engine_mode");
	var_preload_engine_mode = _tmp1_;
	_tmp2_ = var_preload_engine_mode;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		gint32 _tmp4_ = 0;
		_tmp3_ = var_preload_engine_mode;
		_tmp4_ = g_variant_get_int32 (_tmp3_);
		preload_engine_mode = (gint) _tmp4_;
	}
	_tmp5_ = preload_engine_mode;
	if (_tmp5_ == ((gint) IBUS_XKB_PRELOAD_ENGINE_MODE_USER)) {
		_g_variant_unref0 (var_preload_engine_mode);
		return;
	}
	panel_set_lang_relative_preload_engines (self);
	_g_variant_unref0 (var_preload_engine_mode);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_update_xkb_engines (Panel* self) {
	XKBLayout* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* var_layout;
	XKBLayout* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* var_variant;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	IBusXKBConfigRegistry* _tmp11_;
	IBusXKBConfigRegistry* registry;
	gchar** _tmp12_ = NULL;
	gchar** var_xkb_engine_names;
	gint var_xkb_engine_names_length1;
	gint _var_xkb_engine_names_size_;
	IBusConfig* _tmp64_;
	GVariant* _tmp65_ = NULL;
	GVariant* var_engines;
	gchar** _tmp66_ = NULL;
	gchar** engine_names;
	gint engine_names_length1;
	gint _engine_names_size_;
	gboolean updated_engine_names;
	GVariant* _tmp67_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	gboolean _tmp78_;
	IBusConfig* _tmp83_;
	GVariant* _tmp84_ = NULL;
	GVariant* var_order;
	gchar** _tmp85_ = NULL;
	gchar** order_names;
	gint order_names_length1;
	gint _order_names_size_;
	gboolean updated_order_names;
	GVariant* _tmp86_;
	gchar** _tmp90_;
	gint _tmp90__length1;
	gboolean _tmp97_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = xkb_layout_get_layout (_tmp0_);
	var_layout = _tmp1_;
	_tmp2_ = self->priv->m_xkblayout;
	_tmp3_ = xkb_layout_get_variant (_tmp2_);
	var_variant = _tmp3_;
	_tmp4_ = var_layout;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_g_free0 (var_variant);
		_g_free0 (var_layout);
		return;
	}
	_tmp5_ = var_layout;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ",", 0);
	self->priv->m_layouts = (_vala_array_free (self->priv->m_layouts, self->priv->m_layouts_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_layouts = _tmp7_;
	self->priv->m_layouts_length1 = _vala_array_length (_tmp6_);
	self->priv->_m_layouts_size_ = self->priv->m_layouts_length1;
	_tmp8_ = var_variant;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ",", 0);
	self->priv->m_variants = (_vala_array_free (self->priv->m_variants, self->priv->m_variants_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_variants = _tmp10_;
	self->priv->m_variants_length1 = _vala_array_length (_tmp9_);
	self->priv->_m_variants_size_ = self->priv->m_variants_length1;
	_tmp11_ = ibus_xkb_config_registry_new ();
	g_object_ref_sink (_tmp11_);
	registry = _tmp11_;
	_tmp12_ = g_new0 (gchar*, 0 + 1);
	var_xkb_engine_names = _tmp12_;
	var_xkb_engine_names_length1 = 0;
	_var_xkb_engine_names_size_ = var_xkb_engine_names_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* name;
				gchar* lang;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				gboolean _tmp28_;
				const gchar* _tmp49_;
				gchar** _tmp60_;
				gint _tmp60__length1;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_ = NULL;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = self->priv->m_layouts;
				_tmp17__length1 = self->priv->m_layouts_length1;
				if (!(_tmp16_ < _tmp17__length1)) {
					break;
				}
				_tmp18_ = self->priv->m_layouts;
				_tmp18__length1 = self->priv->m_layouts_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = g_strdup (_tmp20_);
				name = _tmp21_;
				lang = NULL;
				_tmp23_ = i;
				_tmp24_ = self->priv->m_variants;
				_tmp24__length1 = self->priv->m_variants_length1;
				if (_tmp23_ < _tmp24__length1) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					_tmp25_ = self->priv->m_variants;
					_tmp25__length1 = self->priv->m_variants_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp22_ = g_strcmp0 (_tmp27_, "") != 0;
				} else {
					_tmp22_ = FALSE;
				}
				_tmp28_ = _tmp22_;
				if (_tmp28_) {
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					gint _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_ = NULL;
					const gchar* _tmp34_;
					gchar** _tmp35_;
					gint _tmp35__length1;
					gint _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_ = NULL;
					gchar* layout;
					IBusXKBConfigRegistry* _tmp39_;
					const gchar* _tmp40_;
					GList* _tmp41_ = NULL;
					GList* langs;
					GList* _tmp42_;
					guint _tmp43_ = 0U;
					_tmp29_ = name;
					_tmp30_ = self->priv->m_variants;
					_tmp30__length1 = self->priv->m_variants_length1;
					_tmp31_ = i;
					_tmp32_ = _tmp30_[_tmp31_];
					_tmp33_ = g_strdup_printf ("%s:%s", _tmp29_, _tmp32_);
					_g_free0 (name);
					name = _tmp33_;
					_tmp34_ = name;
					_tmp35_ = self->priv->m_variants;
					_tmp35__length1 = self->priv->m_variants_length1;
					_tmp36_ = i;
					_tmp37_ = _tmp35_[_tmp36_];
					_tmp38_ = g_strdup_printf ("%s(%s)", _tmp34_, _tmp37_);
					layout = _tmp38_;
					_tmp39_ = registry;
					_tmp40_ = layout;
					_tmp41_ = ibus_xkb_config_registry_layout_lang_get_langs (_tmp39_, _tmp40_);
					langs = _tmp41_;
					_tmp42_ = langs;
					_tmp43_ = g_list_length (_tmp42_);
					if (_tmp43_ != ((guint) 0)) {
						GList* _tmp44_;
						gconstpointer _tmp45_;
						gchar* _tmp46_;
						_tmp44_ = langs;
						_tmp45_ = _tmp44_->data;
						_tmp46_ = g_strdup ((const gchar*) _tmp45_);
						_g_free0 (lang);
						lang = _tmp46_;
					}
					__g_list_free__g_free0_0 (langs);
					_g_free0 (layout);
				} else {
					const gchar* _tmp47_;
					gchar* _tmp48_ = NULL;
					_tmp47_ = name;
					_tmp48_ = g_strdup_printf ("%s:", _tmp47_);
					_g_free0 (name);
					name = _tmp48_;
				}
				_tmp49_ = lang;
				if (_tmp49_ == NULL) {
					IBusXKBConfigRegistry* _tmp50_;
					gchar** _tmp51_;
					gint _tmp51__length1;
					gint _tmp52_;
					const gchar* _tmp53_;
					GList* _tmp54_ = NULL;
					GList* langs;
					GList* _tmp55_;
					guint _tmp56_ = 0U;
					_tmp50_ = registry;
					_tmp51_ = self->priv->m_layouts;
					_tmp51__length1 = self->priv->m_layouts_length1;
					_tmp52_ = i;
					_tmp53_ = _tmp51_[_tmp52_];
					_tmp54_ = ibus_xkb_config_registry_layout_lang_get_langs (_tmp50_, _tmp53_);
					langs = _tmp54_;
					_tmp55_ = langs;
					_tmp56_ = g_list_length (_tmp55_);
					if (_tmp56_ != ((guint) 0)) {
						GList* _tmp57_;
						gconstpointer _tmp58_;
						gchar* _tmp59_;
						_tmp57_ = langs;
						_tmp58_ = _tmp57_->data;
						_tmp59_ = g_strdup ((const gchar*) _tmp58_);
						_g_free0 (lang);
						lang = _tmp59_;
					}
					__g_list_free__g_free0_0 (langs);
				}
				_tmp60_ = var_xkb_engine_names;
				_tmp60__length1 = var_xkb_engine_names_length1;
				_tmp61_ = name;
				_tmp62_ = lang;
				_tmp63_ = g_strdup_printf ("%s:%s:%s", "xkb", _tmp61_, _tmp62_);
				_vala_array_add18 (&var_xkb_engine_names, &var_xkb_engine_names_length1, &_var_xkb_engine_names_size_, _tmp63_);
				_g_free0 (lang);
				_g_free0 (name);
			}
		}
	}
	_tmp64_ = self->priv->m_config;
	_tmp65_ = ibus_config_get_value (_tmp64_, "general", "preload_engines");
	var_engines = _tmp65_;
	_tmp66_ = g_new0 (gchar*, 0 + 1);
	engine_names = _tmp66_;
	engine_names_length1 = 0;
	_engine_names_size_ = engine_names_length1;
	updated_engine_names = FALSE;
	_tmp67_ = var_engines;
	if (_tmp67_ != NULL) {
		GVariant* _tmp68_;
		size_t _tmp69_;
		gchar** _tmp70_ = NULL;
		_tmp68_ = var_engines;
		_tmp70_ = g_variant_dup_strv (_tmp68_, &_tmp69_);
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp70_;
		engine_names_length1 = _tmp69_;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp71_ = var_xkb_engine_names;
	_tmp71__length1 = var_xkb_engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp71_;
		name_collection_length1 = _tmp71__length1;
		for (name_it = 0; name_it < _tmp71__length1; name_it = name_it + 1) {
			gchar* _tmp72_;
			gchar* name = NULL;
			_tmp72_ = g_strdup (name_collection[name_it]);
			name = _tmp72_;
			{
				const gchar* _tmp73_;
				gchar** _tmp74_;
				gint _tmp74__length1;
				gchar** _tmp75_;
				gint _tmp75__length1;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				_tmp73_ = name;
				_tmp74_ = engine_names;
				_tmp74__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp74_, _tmp74__length1, _tmp73_)) {
					_g_free0 (name);
					continue;
				}
				updated_engine_names = TRUE;
				_tmp75_ = engine_names;
				_tmp75__length1 = engine_names_length1;
				_tmp76_ = name;
				_tmp77_ = g_strdup (_tmp76_);
				_vala_array_add19 (&engine_names, &engine_names_length1, &_engine_names_size_, _tmp77_);
				_g_free0 (name);
			}
		}
	}
	_tmp78_ = updated_engine_names;
	if (_tmp78_) {
		IBusConfig* _tmp79_;
		gchar** _tmp80_;
		gint _tmp80__length1;
		GVariant* _tmp81_;
		GVariant* _tmp82_;
		_tmp79_ = self->priv->m_config;
		_tmp80_ = engine_names;
		_tmp80__length1 = engine_names_length1;
		_tmp81_ = g_variant_new_strv (_tmp80_, _tmp80__length1);
		g_variant_ref_sink (_tmp81_);
		_tmp82_ = _tmp81_;
		ibus_config_set_value (_tmp79_, "general", "preload_engines", _tmp82_);
		_g_variant_unref0 (_tmp82_);
	}
	_tmp83_ = self->priv->m_config;
	_tmp84_ = ibus_config_get_value (_tmp83_, "general", "engines_order");
	var_order = _tmp84_;
	_tmp85_ = g_new0 (gchar*, 0 + 1);
	order_names = _tmp85_;
	order_names_length1 = 0;
	_order_names_size_ = order_names_length1;
	updated_order_names = FALSE;
	_tmp86_ = var_order;
	if (_tmp86_ != NULL) {
		GVariant* _tmp87_;
		size_t _tmp88_;
		gchar** _tmp89_ = NULL;
		_tmp87_ = var_order;
		_tmp89_ = g_variant_dup_strv (_tmp87_, &_tmp88_);
		order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
		order_names = _tmp89_;
		order_names_length1 = _tmp88_;
		_order_names_size_ = order_names_length1;
	}
	_tmp90_ = var_xkb_engine_names;
	_tmp90__length1 = var_xkb_engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp90_;
		name_collection_length1 = _tmp90__length1;
		for (name_it = 0; name_it < _tmp90__length1; name_it = name_it + 1) {
			gchar* _tmp91_;
			gchar* name = NULL;
			_tmp91_ = g_strdup (name_collection[name_it]);
			name = _tmp91_;
			{
				const gchar* _tmp92_;
				gchar** _tmp93_;
				gint _tmp93__length1;
				gchar** _tmp94_;
				gint _tmp94__length1;
				const gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp92_ = name;
				_tmp93_ = order_names;
				_tmp93__length1 = order_names_length1;
				if (_vala_string_array_contains (_tmp93_, _tmp93__length1, _tmp92_)) {
					_g_free0 (name);
					continue;
				}
				_tmp94_ = order_names;
				_tmp94__length1 = order_names_length1;
				_tmp95_ = name;
				_tmp96_ = g_strdup (_tmp95_);
				_vala_array_add20 (&order_names, &order_names_length1, &_order_names_size_, _tmp96_);
				updated_order_names = TRUE;
				_g_free0 (name);
			}
		}
	}
	_tmp97_ = updated_order_names;
	if (_tmp97_) {
		IBusConfig* _tmp98_;
		gchar** _tmp99_;
		gint _tmp99__length1;
		GVariant* _tmp100_;
		GVariant* _tmp101_;
		_tmp98_ = self->priv->m_config;
		_tmp99_ = order_names;
		_tmp99__length1 = order_names_length1;
		_tmp100_ = g_variant_new_strv (_tmp99_, _tmp99__length1);
		g_variant_ref_sink (_tmp100_);
		_tmp101_ = _tmp100_;
		ibus_config_set_value (_tmp98_, "general", "engines_order", _tmp101_);
		_g_variant_unref0 (_tmp101_);
	}
	order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (var_order);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (var_engines);
	var_xkb_engine_names = (_vala_array_free (var_xkb_engine_names, var_xkb_engine_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (registry);
	_g_free0 (var_variant);
	_g_free0 (var_layout);
}


static void panel_set_xkb_group_layout (Panel* self, const gchar* layout) {
	XKBLayout* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* retval;
	gint retval_length1;
	gint _retval_size_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = layout;
	_tmp3_ = xkb_layout_set_layout (_tmp0_, _tmp1_, "default", "default", &_tmp2_);
	retval = _tmp3_;
	retval_length1 = _tmp2_;
	_retval_size_ = retval_length1;
	_tmp4_ = retval;
	_tmp4__length1 = retval_length1;
	_tmp5_ = _tmp4_[0];
	if (_tmp5_ >= 0) {
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		gint* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = retval;
		_tmp6__length1 = retval_length1;
		_tmp7_ = _tmp6_[0];
		self->priv->m_fallback_lock_id = _tmp7_;
		_tmp9_ = retval;
		_tmp9__length1 = retval_length1;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != 0) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp11_ = _tmp8_;
		self->priv->m_changed_xkb_option = _tmp11_;
	}
	retval = (g_free (retval), NULL);
}


static gboolean panel_set_gkbd_layout (Panel* self, const gchar* layout) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GkbdLayout* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint gkbd_len;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (layout != NULL, FALSE);
	_tmp0_ = self->priv->m_changed_xkb_option;
	if (_tmp0_ == TRUE) {
		self->priv->m_changed_xkb_option = FALSE;
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->m_gkbdlayout;
	_tmp3_ = gkbd_layout_get_group_names (_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	gkbd_len = _tmp5_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				gboolean _tmp9_ = FALSE;
				gint _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gboolean _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* sys_layout;
				gboolean _tmp19_ = FALSE;
				gint _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gboolean _tmp25_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = self->priv->m_layouts;
				_tmp11__length1 = self->priv->m_layouts_length1;
				if (_tmp10_ < _tmp11__length1) {
					gint _tmp12_;
					gint _tmp13_;
					_tmp12_ = i;
					_tmp13_ = gkbd_len;
					_tmp9_ = _tmp12_ < _tmp13_;
				} else {
					_tmp9_ = FALSE;
				}
				_tmp14_ = _tmp9_;
				if (!_tmp14_) {
					break;
				}
				_tmp15_ = self->priv->m_layouts;
				_tmp15__length1 = self->priv->m_layouts_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp18_ = g_strdup (_tmp17_);
				sys_layout = _tmp18_;
				_tmp20_ = i;
				_tmp21_ = self->priv->m_variants;
				_tmp21__length1 = self->priv->m_variants_length1;
				if (_tmp20_ < _tmp21__length1) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					const gchar* _tmp24_;
					_tmp22_ = self->priv->m_variants;
					_tmp22__length1 = self->priv->m_variants_length1;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp19_ = g_strcmp0 (_tmp24_, "") != 0;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp25_ = _tmp19_;
				if (_tmp25_) {
					const gchar* _tmp26_;
					gchar** _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					_tmp26_ = sys_layout;
					_tmp27_ = self->priv->m_variants;
					_tmp27__length1 = self->priv->m_variants_length1;
					_tmp28_ = i;
					_tmp29_ = _tmp27_[_tmp28_];
					_tmp30_ = g_strdup_printf ("%s(%s)", _tmp26_, _tmp29_);
					_g_free0 (sys_layout);
					sys_layout = _tmp30_;
				}
				_tmp31_ = sys_layout;
				_tmp32_ = layout;
				if (g_strcmp0 (_tmp31_, _tmp32_) == 0) {
					GkbdLayout* _tmp33_;
					gint _tmp34_;
					_tmp33_ = self->priv->m_gkbdlayout;
					_tmp34_ = i;
					gkbd_layout_lock_group (_tmp33_, _tmp34_);
					result = TRUE;
					_g_free0 (sys_layout);
					return result;
				}
				_g_free0 (sys_layout);
			}
		}
	}
	result = FALSE;
	return result;
}


static void panel_set_layout (Panel* self, const gchar* layout) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	XKBLayout* _tmp4_;
	XKBLayout* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gint* _tmp11_ = NULL;
	gint* _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (layout != NULL);
	_tmp1_ = layout;
	if (g_strcmp0 (_tmp1_, "default") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = layout;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->m_xkblayout;
	if (_tmp4_ == NULL) {
		panel_init_engines_order (self);
	}
	if (HAVE_IBUS_GKBD) {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp5_ = layout;
		_tmp6_ = panel_set_gkbd_layout (self, _tmp5_);
		if (_tmp6_) {
			return;
		}
		_tmp7_ = layout;
		panel_set_xkb_group_layout (self, _tmp7_);
		return;
	}
	_tmp8_ = self->priv->m_xkblayout;
	_tmp9_ = layout;
	_tmp11_ = xkb_layout_set_layout (_tmp8_, _tmp9_, "default", "default", &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp10_;
	_tmp12_ = (g_free (_tmp12_), NULL);
}


static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_switch_engine (Panel* self, gint i, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_;
	IBusEngineDesc** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	IBusEngineDesc* _tmp11_;
	IBusEngineDesc* _tmp12_;
	IBusEngineDesc* engine;
	IBusEngineDesc** _tmp25_;
	gint _tmp25__length1;
	IBusEngineDesc* _tmp26_;
	IBusEngineDesc* _tmp27_;
	IBusEngineDesc* _tmp28_;
	IBusBus* _tmp29_;
	IBusEngineDesc* _tmp30_;
	const gchar* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	IBusEngineDesc* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp38_;
	gint _tmp38__length1;
	IBusConfig* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp1_ = i;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		IBusEngineDesc** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = i;
		_tmp3_ = self->priv->m_engines;
		_tmp3__length1 = self->priv->m_engines_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	_vala_assert (_tmp4_, "i >= 0 && i < m_engines.length");
	_tmp6_ = i;
	if (_tmp6_ == 0) {
		gboolean _tmp7_;
		_tmp7_ = force;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		return;
	}
	_tmp9_ = self->priv->m_engines;
	_tmp9__length1 = self->priv->m_engines_length1;
	_tmp10_ = i;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	engine = _tmp12_;
	{
		gint _tmp13_;
		gint j;
		_tmp13_ = i;
		j = _tmp13_;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				IBusEngineDesc** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				IBusEngineDesc** _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				IBusEngineDesc* _tmp22_;
				IBusEngineDesc* _tmp23_;
				IBusEngineDesc* _tmp24_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = j;
					j = _tmp16_ - 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = j;
				if (!(_tmp17_ > 0)) {
					break;
				}
				_tmp18_ = self->priv->m_engines;
				_tmp18__length1 = self->priv->m_engines_length1;
				_tmp19_ = j;
				_tmp20_ = self->priv->m_engines;
				_tmp20__length1 = self->priv->m_engines_length1;
				_tmp21_ = j;
				_tmp22_ = _tmp20_[_tmp21_ - 1];
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (_tmp18_[_tmp19_]);
				_tmp18_[_tmp19_] = _tmp23_;
				_tmp24_ = _tmp18_[_tmp19_];
			}
		}
	}
	_tmp25_ = self->priv->m_engines;
	_tmp25__length1 = self->priv->m_engines_length1;
	_tmp26_ = engine;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (_tmp25_[0]);
	_tmp25_[0] = _tmp27_;
	_tmp28_ = _tmp25_[0];
	_tmp29_ = self->priv->m_bus;
	_tmp30_ = engine;
	_tmp31_ = ibus_engine_desc_get_name (_tmp30_);
	_tmp32_ = ibus_bus_set_global_engine (_tmp29_, _tmp31_);
	if (!_tmp32_) {
		IBusEngineDesc* _tmp33_;
		const gchar* _tmp34_ = NULL;
		_tmp33_ = engine;
		_tmp34_ = ibus_engine_desc_get_name (_tmp33_);
		g_warning ("panel.vala:567: Switch engine to %s failed.", _tmp34_);
		_g_object_unref0 (engine);
		return;
	}
	_tmp35_ = engine;
	_tmp36_ = ibus_engine_desc_get_layout (_tmp35_);
	panel_set_layout (self, _tmp36_);
	_tmp37_ = g_new0 (gchar*, 0 + 1);
	names = _tmp37_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp38_ = self->priv->m_engines;
	_tmp38__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp38_;
		desc_collection_length1 = _tmp38__length1;
		for (desc_it = 0; desc_it < _tmp38__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp39_;
			IBusEngineDesc* desc = NULL;
			_tmp39_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp39_;
			{
				gchar** _tmp40_;
				gint _tmp40__length1;
				IBusEngineDesc* _tmp41_;
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_;
				_tmp40_ = names;
				_tmp40__length1 = names_length1;
				_tmp41_ = desc;
				_tmp42_ = ibus_engine_desc_get_name (_tmp41_);
				_tmp43_ = g_strdup (_tmp42_);
				_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp43_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp44_ = self->priv->m_config;
	if (_tmp44_ != NULL) {
		IBusConfig* _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		GVariant* _tmp47_;
		GVariant* _tmp48_;
		_tmp45_ = self->priv->m_config;
		_tmp46_ = names;
		_tmp46__length1 = names_length1;
		_tmp47_ = g_variant_new_strv (_tmp46_, _tmp46__length1);
		g_variant_ref_sink (_tmp47_);
		_tmp48_ = _tmp47_;
		ibus_config_set_value (_tmp45_, "general", "engines_order", _tmp48_);
		_g_variant_unref0 (_tmp48_);
	}
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
}


static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (variant != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, "general") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = name;
		_tmp0_ = g_strcmp0 (_tmp2_, "preload_engine_mode") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		panel_update_im_engines (self);
		return;
	}
	_tmp5_ = section;
	if (g_strcmp0 (_tmp5_, "general") == 0) {
		const gchar* _tmp6_;
		_tmp6_ = name;
		_tmp4_ = g_strcmp0 (_tmp6_, "preload_engines") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		GVariant* _tmp8_;
		_tmp8_ = variant;
		panel_update_engines (self, _tmp8_, NULL);
		return;
	}
	_tmp10_ = section;
	if (g_strcmp0 (_tmp10_, "panel") == 0) {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gboolean _tmp14_;
		_tmp12_ = name;
		if (g_strcmp0 (_tmp12_, "custom_font") == 0) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp13_;
			_tmp13_ = name;
			_tmp11_ = g_strcmp0 (_tmp13_, "use_custom_font") == 0;
		}
		_tmp14_ = _tmp11_;
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp15_ = _tmp9_;
	if (_tmp15_) {
		panel_set_custom_font (self);
		return;
	}
}


static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert) {
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	GdkEvent* _tmp1_;
	GdkEventKey _tmp2_;
	GdkModifierType _tmp3_;
	guint _tmp4_ = 0U;
	guint primary_modifiers;
	GdkEvent* _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean pressed;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->key;
	_tmp3_ = _tmp2_.state;
	_tmp4_ = keybinding_manager_get_primary_modifier ((guint) _tmp3_);
	primary_modifiers = _tmp4_;
	_tmp5_ = event;
	_tmp6_ = primary_modifiers;
	_tmp7_ = keybinding_manager_primary_modifier_still_pressed (_tmp5_, _tmp6_);
	pressed = _tmp7_;
	_tmp8_ = pressed;
	if (_tmp8_) {
		gint _tmp9_ = 0;
		gboolean _tmp10_;
		gint _tmp12_;
		gint i;
		Switcher* _tmp13_;
		GdkEvent* _tmp14_;
		IBusEngineDesc** _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		GList* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_;
		_tmp10_ = revert;
		if (_tmp10_) {
			IBusEngineDesc** _tmp11_;
			gint _tmp11__length1;
			_tmp11_ = self->priv->m_engines;
			_tmp11__length1 = self->priv->m_engines_length1;
			_tmp9_ = _tmp11__length1 - 1;
		} else {
			_tmp9_ = 1;
		}
		_tmp12_ = _tmp9_;
		i = _tmp12_;
		_tmp13_ = self->priv->m_switcher;
		_tmp14_ = event;
		_tmp15_ = self->priv->m_engines;
		_tmp15__length1 = self->priv->m_engines_length1;
		_tmp16_ = i;
		_tmp17_ = self->priv->m_keybindings;
		_tmp18_ = switcher_run (_tmp13_, _tmp14_, _tmp15_, _tmp15__length1, _tmp16_, _tmp17_);
		i = _tmp18_;
		_tmp19_ = i;
		if (_tmp19_ < 0) {
			g_debug ("panel.vala:618: switch cancelled");
		} else {
			gint _tmp20_;
			IBusEngineDesc** _tmp21_;
			gint _tmp21__length1;
			gint _tmp22_;
			_tmp20_ = i;
			_tmp21_ = self->priv->m_engines;
			_tmp21__length1 = self->priv->m_engines_length1;
			_vala_assert (_tmp20_ < _tmp21__length1, "i < m_engines.length");
			_tmp22_ = i;
			panel_switch_engine (self, _tmp22_, FALSE);
		}
	} else {
		gint _tmp23_ = 0;
		gboolean _tmp24_;
		gint _tmp26_;
		gint i;
		gint _tmp27_;
		_tmp24_ = revert;
		if (_tmp24_) {
			IBusEngineDesc** _tmp25_;
			gint _tmp25__length1;
			_tmp25_ = self->priv->m_engines;
			_tmp25__length1 = self->priv->m_engines_length1;
			_tmp23_ = _tmp25__length1 - 1;
		} else {
			_tmp23_ = 1;
		}
		_tmp26_ = _tmp23_;
		i = _tmp26_;
		_tmp27_ = i;
		panel_switch_engine (self, _tmp27_, FALSE);
	}
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc** _vala_array_dup6 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order) {
	gchar** engine_names;
	gint engine_names_length1;
	gint _engine_names_size_;
	GVariant* _tmp0_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp7_;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint __tmp10__size_ = 0;
	GVariant* _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** order_names;
	gint order_names_length1;
	gint _order_names_size_;
	gchar** _tmp17_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	IBusBus* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	IBusEngineDesc** _tmp34_;
	IBusEngineDesc** _tmp35_ = NULL;
	IBusEngineDesc** engines;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp36_;
	gint _tmp36__length1;
	g_return_if_fail (self != NULL);
	engine_names = NULL;
	engine_names_length1 = 0;
	_engine_names_size_ = engine_names_length1;
	_tmp0_ = var_engines;
	if (_tmp0_ != NULL) {
		GVariant* _tmp1_;
		size_t _tmp2_;
		gchar** _tmp3_ = NULL;
		_tmp1_ = var_engines;
		_tmp3_ = g_variant_dup_strv (_tmp1_, &_tmp2_);
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp3_;
		engine_names_length1 = _tmp2_;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp5_ = engine_names;
	_tmp5__length1 = engine_names_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = engine_names;
		_tmp6__length1 = engine_names_length1;
		_tmp4_ = _tmp6__length1 == 0;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp8_ = g_strdup ("xkb:us::eng");
		_tmp9_ = g_new0 (gchar*, 1 + 1);
		_tmp9_[0] = _tmp8_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp9_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp11_ = var_order;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		size_t _tmp13_;
		gchar** _tmp14_ = NULL;
		_tmp12_ = var_order;
		_tmp14_ = g_variant_dup_strv (_tmp12_, &_tmp13_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = _tmp14_;
		_tmp10__length1 = _tmp13_;
		__tmp10__size_ = _tmp10__length1;
	} else {
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = NULL;
		_tmp10__length1 = 0;
		__tmp10__size_ = _tmp10__length1;
	}
	_tmp15_ = _tmp10_;
	_tmp15__length1 = _tmp10__length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup4 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	order_names = _tmp16_;
	order_names_length1 = _tmp16__length1;
	_order_names_size_ = order_names_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	names = _tmp17_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp18_ = order_names;
	_tmp18__length1 = order_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp18_;
		name_collection_length1 = _tmp18__length1;
		for (name_it = 0; name_it < _tmp18__length1; name_it = name_it + 1) {
			gchar* _tmp19_;
			gchar* name = NULL;
			_tmp19_ = g_strdup (name_collection[name_it]);
			name = _tmp19_;
			{
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp20_ = name;
				_tmp21_ = engine_names;
				_tmp21__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = names;
					_tmp22__length1 = names_length1;
					_tmp23_ = name;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add22 (&names, &names_length1, &_names_size_, _tmp24_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp25_ = engine_names;
	_tmp25__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp25_;
		name_collection_length1 = _tmp25__length1;
		for (name_it = 0; name_it < _tmp25__length1; name_it = name_it + 1) {
			gchar* _tmp26_;
			gchar* name = NULL;
			_tmp26_ = g_strdup (name_collection[name_it]);
			name = _tmp26_;
			{
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp27_ = name;
				_tmp28_ = names;
				_tmp28__length1 = names_length1;
				if (_vala_string_array_contains (_tmp28_, _tmp28__length1, _tmp27_)) {
					_g_free0 (name);
					continue;
				}
				_tmp29_ = names;
				_tmp29__length1 = names_length1;
				_tmp30_ = name;
				_tmp31_ = g_strdup (_tmp30_);
				_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp31_);
				_g_free0 (name);
			}
		}
	}
	_tmp32_ = self->priv->m_bus;
	_tmp33_ = names;
	_tmp33__length1 = names_length1;
	_tmp35_ = _tmp34_ = ibus_bus_get_engines_by_names (_tmp32_, _tmp33_);
	engines = _tmp35_;
	engines_length1 = _vala_array_length (_tmp34_);
	_engines_size_ = engines_length1;
	_tmp36_ = self->priv->m_engines;
	_tmp36__length1 = self->priv->m_engines_length1;
	if (_tmp36__length1 == 0) {
		IBusEngineDesc** _tmp37_;
		gint _tmp37__length1;
		IBusEngineDesc** _tmp38_;
		gint _tmp38__length1;
		_tmp37_ = engines;
		_tmp37__length1 = engines_length1;
		_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup5 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
		_tmp38__length1 = _tmp37__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp38_;
		self->priv->m_engines_length1 = _tmp38__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
	} else {
		IBusEngineDesc** _tmp39_;
		gint _tmp39__length1;
		IBusEngineDesc* _tmp40_;
		IBusEngineDesc* _tmp41_;
		IBusEngineDesc* current_engine;
		IBusEngineDesc** _tmp42_;
		gint _tmp42__length1;
		IBusEngineDesc** _tmp43_;
		gint _tmp43__length1;
		gint i = 0;
		_tmp39_ = self->priv->m_engines;
		_tmp39__length1 = self->priv->m_engines_length1;
		_tmp40_ = _tmp39_[0];
		_tmp41_ = _g_object_ref0 (_tmp40_);
		current_engine = _tmp41_;
		_tmp42_ = engines;
		_tmp42__length1 = engines_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup6 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp43_;
		self->priv->m_engines_length1 = _tmp43__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp44_;
			i = 0;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				IBusEngineDesc* _tmp49_;
				const gchar* _tmp50_ = NULL;
				IBusEngineDesc** _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				IBusEngineDesc* _tmp53_;
				const gchar* _tmp54_ = NULL;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->m_engines;
				_tmp48__length1 = self->priv->m_engines_length1;
				if (!(_tmp47_ < _tmp48__length1)) {
					break;
				}
				_tmp49_ = current_engine;
				_tmp50_ = ibus_engine_desc_get_name (_tmp49_);
				_tmp51_ = engines;
				_tmp51__length1 = engines_length1;
				_tmp52_ = i;
				_tmp53_ = _tmp51_[_tmp52_];
				_tmp54_ = ibus_engine_desc_get_name (_tmp53_);
				if (g_strcmp0 (_tmp50_, _tmp54_) == 0) {
					gint _tmp55_;
					_tmp55_ = i;
					panel_switch_engine (self, _tmp55_, FALSE);
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
					_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void __lambda18_ (Panel* self, GPid pid, gint state) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	_tmp0_ = pid;
	_tmp1_ = self->priv->m_setup_pid;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
}


static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda18_ (self, pid, status);
}


static void panel_show_setup_dialog (Panel* self) {
	GPid _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* binary;
	GPid _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->m_setup_pid;
		_tmp2_ = kill ((pid_t) _tmp1_, SIGUSR1);
		if (_tmp2_ == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp3_ = g_build_filename (BINDIR, "ibus-setup-xkb", NULL);
	binary = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GPid _tmp9_ = 0;
		_tmp4_ = binary;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_strdup ("ibus-setup");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp9_, &_inner_error_);
		self->priv->m_setup_pid = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = binary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("panel.vala:690: Execute %s failed! %s", _tmp10_, _tmp12_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, ___lambda18__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void panel_show_about_dialog (Panel* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp25_;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* copyright;
		GtkAboutDialog* _tmp6_;
		const gchar* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GtkAboutDialog* _tmp11_;
		GtkAboutDialog* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar** _tmp15_ = NULL;
		gchar** _tmp16_;
		gint _tmp16__length1;
		GtkAboutDialog* _tmp17_;
		gchar* _tmp18_;
		gchar** _tmp19_ = NULL;
		gchar** _tmp20_;
		gint _tmp20__length1;
		GtkAboutDialog* _tmp21_;
		const gchar* _tmp22_ = NULL;
		GtkAboutDialog* _tmp23_;
		GtkAboutDialog* _tmp24_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus XKB");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, IBUS_VERSION);
		_tmp4_ = _ ("Copyright (c) 2012 Takao Fujiwara\n" "Copyright (c) 2007-2012 Peng Huang\n" "Copyright (c) 2007-2012 Red Hat, Inc.\n");
		_tmp5_ = g_strdup (_tmp4_);
		copyright = _tmp5_;
		_tmp6_ = self->priv->m_about_dialog;
		_tmp7_ = copyright;
		gtk_about_dialog_set_copyright (_tmp6_, _tmp7_);
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp8_, "LGPL");
		_tmp9_ = self->priv->m_about_dialog;
		_tmp10_ = _ ("IBus is an intelligent input bus for Linux/Unix.");
		gtk_about_dialog_set_comments (_tmp9_, _tmp10_);
		_tmp11_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp11_, "http://code.google.com/p/ibus");
		_tmp12_ = self->priv->m_about_dialog;
		_tmp13_ = g_strdup ("Takao Fujiwara <takao.fujiwara1@gmail.com>");
		_tmp14_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp15_ = g_new0 (gchar*, 2 + 1);
		_tmp15_[0] = _tmp13_;
		_tmp15_[1] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 2;
		gtk_about_dialog_set_authors (_tmp12_, _tmp16_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		_tmp17_ = self->priv->m_about_dialog;
		_tmp18_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp19_ = g_new0 (gchar*, 1 + 1);
		_tmp19_[0] = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp20__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp17_, _tmp20_);
		_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
		_tmp21_ = self->priv->m_about_dialog;
		_tmp22_ = _ ("translator-credits");
		gtk_about_dialog_set_translator_credits (_tmp21_, _tmp22_);
		_tmp23_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp23_, "ibus");
		_tmp24_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp24_, "ibus");
		_g_free0 (copyright);
	}
	_tmp25_ = self->priv->m_about_dialog;
	_tmp26_ = gtk_widget_get_visible ((GtkWidget*) _tmp25_);
	if (!_tmp26_) {
		GtkAboutDialog* _tmp27_;
		GtkAboutDialog* _tmp28_;
		_tmp27_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp27_);
		_tmp28_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp28_);
	} else {
		GtkAboutDialog* _tmp29_;
		_tmp29_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp29_);
	}
}


static void ___lambda17_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda17_ (self, _sender);
}


static void ___lambda19_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda19_ (self, _sender);
}


static void ___lambda20_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda20_ (self, _sender);
}


static void ___lambda21_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda21_ (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* _tmp0_;
	GtkMenu* _tmp24_;
	GtkStatusIcon* _tmp25_;
	guint32 _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkImageMenuItem* item = NULL;
		GtkMenu* _tmp1_;
		GtkImageMenuItem* _tmp2_;
		GtkImageMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkImageMenuItem* _tmp5_;
		GtkImageMenuItem* _tmp6_;
		GtkImageMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkImageMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkSeparatorMenuItem* _tmp11_;
		GtkSeparatorMenuItem* _tmp12_;
		GtkImageMenuItem* _tmp13_;
		GtkImageMenuItem* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GtkImageMenuItem* _tmp16_;
		GtkMenu* _tmp17_;
		GtkImageMenuItem* _tmp18_;
		GtkImageMenuItem* _tmp19_;
		GtkImageMenuItem* _tmp20_;
		GtkMenu* _tmp21_;
		GtkImageMenuItem* _tmp22_;
		GtkMenu* _tmp23_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp3_, "activate", (GCallback) ____lambda17__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
		_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp7_, "activate", (GCallback) ____lambda19__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) ((GtkMenuItem*) _tmp9_));
		_tmp10_ = self->priv->m_sys_menu;
		_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) ((GtkMenuItem*) _tmp12_));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REFRESH, NULL);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (item);
		item = _tmp13_;
		_tmp14_ = item;
		_tmp15_ = _ ("Restart");
		gtk_menu_item_set_label ((GtkMenuItem*) _tmp14_, _tmp15_);
		_tmp16_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp16_, "activate", (GCallback) ____lambda20__gtk_menu_item_activate, self, 0);
		_tmp17_ = self->priv->m_sys_menu;
		_tmp18_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp17_, (GtkWidget*) ((GtkMenuItem*) _tmp18_));
		_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (item);
		item = _tmp19_;
		_tmp20_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp20_, "activate", (GCallback) ____lambda21__gtk_menu_item_activate, self, 0);
		_tmp21_ = self->priv->m_sys_menu;
		_tmp22_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp21_, (GtkWidget*) ((GtkMenuItem*) _tmp22_));
		_tmp23_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp23_);
		_g_object_unref0 (item);
	}
	_tmp24_ = self->priv->m_sys_menu;
	_tmp25_ = self->priv->m_status_icon;
	_tmp26_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp24_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp25_, (guint) 0, _tmp26_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Panel * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->e);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item) {
	Panel * self;
	self = _data4_->self;
	g_return_if_fail (item != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				IBusEngineDesc** _tmp4_;
				gint _tmp4__length1;
				IBusEngineDesc* _tmp5_;
				IBusEngineDesc** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				IBusEngineDesc* _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->m_engines;
				_tmp4__length1 = self->priv->m_engines_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = _data4_->e;
				_tmp6_ = self->priv->m_engines;
				_tmp6__length1 = self->priv->m_engines_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp5_ == _tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					panel_switch_engine (self, _tmp9_, FALSE);
					break;
				}
			}
		}
	}
}


static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda22_ (self, _sender);
}


static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon) {
	GtkMenu* _tmp0_;
	PropertyManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	gint width = 0;
	gint height = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	IBusEngineDesc** _tmp8_;
	gint _tmp8__length1;
	GtkMenu* _tmp36_;
	GtkMenu* _tmp37_;
	GtkMenu* _tmp38_;
	GtkStatusIcon* _tmp39_;
	guint32 _tmp40_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
	_g_object_unref0 (_tmp5_);
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp6_, &_tmp7_);
	width = _tmp6_;
	height = _tmp7_;
	_tmp8_ = self->priv->m_engines;
	_tmp8__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp8_;
		engine_collection_length1 = _tmp8__length1;
		for (engine_it = 0; engine_it < _tmp8__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp9_;
			IBusEngineDesc* engine = NULL;
			_tmp9_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp9_;
			{
				Block4Data* _data4_;
				IBusEngineDesc* _tmp10_;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* language;
				IBusEngineDesc* _tmp13_;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* longname;
				const gchar* _tmp16_;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GtkImageMenuItem* _tmp21_;
				GtkImageMenuItem* _tmp22_;
				GtkImageMenuItem* item;
				IBusEngineDesc* _tmp23_;
				const gchar* _tmp24_ = NULL;
				IBusEngineDesc* _tmp31_;
				IBusEngineDesc* _tmp32_;
				GtkImageMenuItem* _tmp33_;
				GtkMenu* _tmp34_;
				GtkImageMenuItem* _tmp35_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				_tmp10_ = engine;
				_tmp11_ = ibus_engine_desc_get_language (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				language = _tmp12_;
				_tmp13_ = engine;
				_tmp14_ = ibus_engine_desc_get_longname (_tmp13_);
				_tmp15_ = g_strdup (_tmp14_);
				longname = _tmp15_;
				_tmp16_ = language;
				_tmp17_ = ibus_get_language_name (_tmp16_);
				_tmp18_ = longname;
				_tmp19_ = g_strdup_printf ("%s - %s", _tmp17_, _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp20_);
				g_object_ref_sink (_tmp21_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				item = _tmp22_;
				_tmp23_ = engine;
				_tmp24_ = ibus_engine_desc_get_icon (_tmp23_);
				if (g_strcmp0 (_tmp24_, "") != 0) {
					IBusEngineDesc* _tmp25_;
					const gchar* _tmp26_ = NULL;
					gint _tmp27_;
					IconWidget* _tmp28_;
					IconWidget* icon;
					GtkImageMenuItem* _tmp29_;
					IconWidget* _tmp30_;
					_tmp25_ = engine;
					_tmp26_ = ibus_engine_desc_get_icon (_tmp25_);
					_tmp27_ = width;
					_tmp28_ = icon_widget_new (_tmp26_, _tmp27_);
					g_object_ref_sink (_tmp28_);
					icon = _tmp28_;
					_tmp29_ = item;
					_tmp30_ = icon;
					gtk_image_menu_item_set_image (_tmp29_, (GtkWidget*) _tmp30_);
					_g_object_unref0 (icon);
				}
				_tmp31_ = engine;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				_data4_->e = _tmp32_;
				_tmp33_ = item;
				g_signal_connect_data ((GtkMenuItem*) _tmp33_, "activate", (GCallback) _____lambda22__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp34_ = self->priv->m_ime_menu;
				_tmp35_ = item;
				gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
				_g_object_unref0 (item);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp36_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp37_, FALSE);
	_tmp38_ = self->priv->m_ime_menu;
	_tmp39_ = self->priv->m_status_icon;
	_tmp40_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp38_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp39_, (guint) 0, _tmp40_);
}


static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height) {
	Panel * self;
	CandidatePanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = width;
	_tmp4_ = height;
	candidate_panel_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusPropList* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = props;
	property_manager_set_properties (_tmp0_, _tmp1_);
}


static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusProperty* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = prop;
	property_manager_update_property (_tmp0_, _tmp1_);
}


static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible) {
	Panel * self;
	gboolean _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		CandidatePanel* _tmp1_;
		IBusText* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->m_candidate_panel;
		_tmp2_ = text;
		_tmp3_ = cursor_pos;
		candidate_panel_set_preedit_text (_tmp1_, _tmp2_, _tmp3_);
	} else {
		CandidatePanel* _tmp4_;
		_tmp4_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp4_, NULL, (guint) 0);
	}
}


static void panel_real_hide_preedit_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible) {
	Panel * self;
	IBusText* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusText* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusText* _tmp2_;
		_tmp2_ = text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_auxiliary_text (_tmp3_, _tmp4_);
}


static void panel_real_hide_auxiliary_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible) {
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusLookupTable* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusLookupTable* _tmp2_;
		_tmp2_ = table;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_lookup_table (_tmp3_, _tmp4_);
}


static void panel_real_hide_lookup_table (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void panel_real_state_changed (IBusPanelService* base) {
	Panel * self;
	gchar* _tmp0_;
	gchar* icon_name;
	IBusBus* _tmp1_;
	IBusEngineDesc* _tmp2_ = NULL;
	IBusEngineDesc* _tmp3_;
	IBusEngineDesc* engine;
	IBusEngineDesc* _tmp4_;
	const gchar* _tmp8_;
	gchar _tmp9_ = '\0';
	self = (Panel*) base;
	_tmp0_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp0_;
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = ibus_bus_get_global_engine (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	engine = _tmp3_;
	_tmp4_ = engine;
	if (_tmp4_ != NULL) {
		IBusEngineDesc* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = engine;
		_tmp6_ = ibus_engine_desc_get_icon (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (icon_name);
		icon_name = _tmp7_;
	}
	_tmp8_ = icon_name;
	_tmp9_ = string_get (_tmp8_, (glong) 0);
	if (_tmp9_ == '/') {
		GtkStatusIcon* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->m_status_icon;
		_tmp11_ = icon_name;
		gtk_status_icon_set_from_file (_tmp10_, _tmp11_);
	} else {
		GtkStatusIcon* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = self->priv->m_status_icon;
		_tmp13_ = icon_name;
		gtk_status_icon_set_from_icon_name (_tmp12_, _tmp13_);
	}
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static void panel_class_init (PanelClass * klass) {
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	IBUS_PANEL_SERVICE_CLASS (klass)->set_cursor_location = panel_real_set_cursor_location;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_in = panel_real_focus_in;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_out = panel_real_focus_out;
	IBUS_PANEL_SERVICE_CLASS (klass)->register_properties = panel_real_register_properties;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_property = panel_real_update_property;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_preedit_text = panel_real_update_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_preedit_text = panel_real_hide_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_auxiliary_text = panel_real_update_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_auxiliary_text = panel_real_hide_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_lookup_table = panel_real_update_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_lookup_table = panel_real_hide_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->state_changed = panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void panel_instance_init (Panel * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	self->priv = PANEL_GET_PRIVATE (self);
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_gkbdlayout = NULL;
	self->priv->m_xkblayout = NULL;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_layouts = _tmp1_;
	self->priv->m_layouts_length1 = 0;
	self->priv->_m_layouts_size_ = self->priv->m_layouts_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_variants = _tmp2_;
	self->priv->m_variants_length1 = 0;
	self->priv->_m_variants_size_ = self->priv->m_variants_length1;
	self->priv->m_fallback_lock_id = -1;
	self->priv->m_changed_xkb_option = FALSE;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->ACCELERATOR_IME_HOTKEYS = _tmp3_;
	self->priv->ACCELERATOR_IME_HOTKEYS_length1 = 0;
	self->priv->_ACCELERATOR_IME_HOTKEYS_size_ = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
}


static void panel_finalize (GObject* obj) {
	Panel * self;
	KeybindingManager* _tmp0_ = NULL;
	KeybindingManager* keybinding_manager;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp1_ = self->priv->ACCELERATOR_IME_HOTKEYS;
	_tmp1__length1 = self->priv->ACCELERATOR_IME_HOTKEYS_length1;
	{
		gchar** keybinding_collection = NULL;
		gint keybinding_collection_length1 = 0;
		gint _keybinding_collection_size_ = 0;
		gint keybinding_it = 0;
		keybinding_collection = _tmp1_;
		keybinding_collection_length1 = _tmp1__length1;
		for (keybinding_it = 0; keybinding_it < _tmp1__length1; keybinding_it = keybinding_it + 1) {
			gchar* _tmp2_;
			gchar* keybinding = NULL;
			_tmp2_ = g_strdup (keybinding_collection[keybinding_it]);
			keybinding = _tmp2_;
			{
				KeybindingManager* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = keybinding_manager;
				_tmp4_ = keybinding;
				keybinding_manager_unbind (_tmp3_, _tmp4_);
				_tmp5_ = keybinding;
				if (g_strcmp0 (_tmp5_, PANEL_ACCELERATOR_SWITCH_IME_FOREWARD) == 0) {
					KeybindingManager* _tmp6_;
					_tmp6_ = keybinding_manager;
					keybinding_manager_unbind (_tmp6_, PANEL_ACCELERATOR_SWITCH_IME_BACKWARD);
				}
				_g_free0 (keybinding);
			}
		}
	}
	if (HAVE_IBUS_GKBD) {
		GkbdLayout* _tmp8_;
		_tmp8_ = self->priv->m_gkbdlayout;
		_tmp7_ = _tmp8_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp9_ = _tmp7_;
	if (_tmp9_) {
		GkbdLayout* _tmp10_;
		guint _tmp11_ = 0U;
		GkbdLayout* _tmp12_;
		_tmp10_ = self->priv->m_gkbdlayout;
		g_signal_parse_name ("changed", TYPE_GKBD_LAYOUT, &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _panel_gkbdlayout_changed_cb_gkbd_layout_changed, self);
		_tmp12_ = self->priv->m_gkbdlayout;
		gkbd_layout_stop_listen (_tmp12_);
		_gkbd_layout_unref0 (self->priv->m_gkbdlayout);
		self->priv->m_gkbdlayout = NULL;
	}
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	self->priv->m_xkblayout = NULL;
	_g_object_unref0 (keybinding_manager);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_config);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	_gkbd_layout_unref0 (self->priv->m_gkbdlayout);
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	self->priv->m_layouts = (_vala_array_free (self->priv->m_layouts, self->priv->m_layouts_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_variants = (_vala_array_free (self->priv->m_variants, self->priv->m_variants_length1, (GDestroyNotify) g_free), NULL);
	_g_timer_destroy0 (self->priv->m_changed_layout_timer);
	_g_list_free0 (self->priv->m_keybindings);
	self->priv->ACCELERATOR_IME_HOTKEYS = (_vala_array_free (self->priv->ACCELERATOR_IME_HOTKEYS, self->priv->ACCELERATOR_IME_HOTKEYS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType panel_get_type (void) {
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



