.TH grodvi @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grodvi \-
.I groff
output driver for TeX DVI format
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020, 2022 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grodvi_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el .ds tx TeX
.
.\" This macro definition is poor style from a portability standpoint,
.\" but it's a good test and demonstration of the standard font
.\" repertoire for the devices where it has any effect at all, and so
.\" should be retained.
.de FT
.  if '\\*(.T'dvi' .ft \\$1
..
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grodvi
.RB [ \-dl ]
.RB [ \-F\~\c
.IR dir ]
.RB [ \-p\~\c
.IR paper-format ]
.RB [ \-w\~\c
.IR n ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY grodvi
.B \-\-help
.YS
.
.
.SY grodvi
.B \-v
.
.SY grodvi
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
DVI output driver translates the output of
.MR @g@troff @MAN1EXT@
into \*[tx] DVI format.
.
Normally,
.I grodvi
is invoked by
.MR groff @MAN1EXT@
when the latter is given the
.RB \[lq] \-T\~dvi \[rq]
option.
.
(In this installation,
.B @DEVICE@
is the default output device.)
.
Use
.IR groff 's
.B \-P
option to pass any options shown above to
.IR grodvi .
.
If no
.I file
arguments are given,
or if
.I file
is \[lq]\-\[rq],
.I grodvi
reads the standard input stream.
.
Output is written to the standard output stream.
.
.
.P
The DVI file generated by
.I grodvi
can interpreted by any correctly written DVI driver.
.
.I troff \" generic
drawing primitives are implemented using
.I tpic
version\~2 specials.
.
If the driver does not support these,
.B \[rs]D
escape sequences will not produce any output.
.
.
.P
Encapsulated PostScript (EPS) files can be easily included;
use the
.B PSPIC
macro.
.
.I pspic.tmac
is loaded automatically by
.IR dvi.tmac .
.
See
.MR groff_tmac @MAN5EXT@ .
.
.
.P
The default color used by the
.B \[rs]m
and
.B \[rs]M
escape sequences is black.
.
Currently,
the stroke color for
.B \[rs]D
drawing escape sequences is black;
fill color values are translated to gray.
.
.
.P
In
.IR groff ,
as in AT&T
.IR troff , \" AT&T
the
.B \[rs]N
escape sequence can be used to access any glyph in the current font by
its position in the corresponding TFM file.
.
.
.P
By design,
the DVI format doesn't care about the physical dimensions of the output
medium.
.
Instead,
.I grodvi
emits the equivalent to \*[tx]'s
.BI \%\[rs]special{\:\%papersize= width , length }
on the first page;
.I dvips
(or another DVI driver)
then sets the page size accordingly.
.
If either the page width or length is not positive,
no
.B \%papersize
special is output.
.
.
.P
A device control escape sequence
.BI \[rs]X\[aq] anything \[aq]
is translated to the same DVI file instructions as would be produced by
.BI \%\[rs]special{ anything }
in \*[tx];
.I anything
cannot contain a newline.
.
.
.\" ====================================================================
.SS Typefaces
.\" ====================================================================
.
.I grodvi
supports the standard four styles:
.B R
(roman),
.B I
.RI ( italic ),
.B B
.RB ( bold ),
and
.B BI
(\f[BI]bold-italic\f[]).
.
Fonts are grouped into families
.B T
and
.B H
having members in each style.
.
\[lq]CM\[rq] abbreviates \[lq]Computer Modern\[rq].
.
.
.RS
.TP
.B TR
.FT TR
CM Roman (cmr10)
.FT
.
.TQ
.B TI
.FT TI
CM Text Italic (cmti10)
.FT
.
.TQ
.B TB
.FT TB
CM Bold Extended Roman (cmbx10)
.FT
.
.TQ
.B TBI
.FT TBI
CM Bold Extended Text Italic (cmbxti10)
.FT
.
.TQ
.B HR
.FT HR
CM Sans Serif (cmss10)
.FT
.
.TQ
.B HI
.FT HI
CM Slanted Sans Serif (cmssi10)
.FT
.
.TQ
.B HB
.FT HB
CM Sans Serif Bold Extended (cmssbx10)
.FT
.
.TQ
.B HBI
.FT HBI
CM Slanted Sans Serif Bold Extended (cmssbxo10)
.FT
.RE
.
.
.LP
The following fonts are not members of a family.
.
.
.RS
.TP
.B CW
.FT CW
CM Typewriter Text (cmtt10)
.FT
.
.TQ
.B CWI
.FT CWI
CM Italic Typewriter Text (cmitt10)
.FT
.RE
.
.
.P
Special fonts include
.B MI
(cmmi10),
.B S
(cmsy10),
.B EX
(cmex10),
.B SC
(cmtex10,
only for
.BR CW ),
and,
perhaps surprisingly,
.BR TR ,
.BR TI ,
and
.BR CW ,
.\" See font/devdvi/generate/Makefile for details.
because \*[tx] places some glyphs in text fonts that
.I troff \" generic
generally does not.
.
For italic fonts,
.B CWI
is used instead of
.BR CW .
.
.
.P
Finally,
the symbol fonts of the American Mathematical Society are available as
special fonts
.B SA
(msam10) and
.B SB
(msbm10).
.
They are are not mounted by default.
.
.
.br
.ne 2v
.P
The
.I @g@troff
option
.B \-mec
loads the
.I ec.tmac
macro file,
employing the EC and TC fonts instead of CM.
.
These are designed similarly to the Computer Modern fonts;
further,
they provide Euro
.B \[rs][Eu]
and per mille
.B \[rs][%0]
glyphs.
.
.I ec.tmac
must be loaded before any language-specific macro files because it does
not set up the codes necessary for automatic hyphenation.
.
.
.\" ====================================================================
.SS "Font description files"
.\" ====================================================================
.
Use
.MR tfmtodit @MAN1EXT@
to create
.I groff
font description files from TFM
(\*[tx] font metrics)
files.
.
The font description file should contain the following additional
directives,
which
.I tfmtodit
generates automatically.
.
.
.TP
.BI internalname\~ name
The name of the TFM file
(without the
.I .tfm
extension) is
.IR name .
.
.
.TP
.BI checksum\~ n
The checksum in the TFM file is
.IR n .
.
.
.TP
.BI designsize\~ n
The design size in the TFM file is
.IR n .
.
.
.\" ====================================================================
.SS "Drawing commands"
.\" ====================================================================
.
.I grodvi
supports an additional drawing command.
.
.
.TP
.BI \[rs]D\[aq]R\~ "dh dv" \[aq]
Draw a rule
(solid black rectangle)
with one corner at the drawing position,
and the diagonally opposite corner at the drawing position
.RI +( dh , dv ),
which becomes the new drawing position afterward.
.
This command produces a rule in the DVI file and so can be printed even
with a driver that does not support
.I tpic
specials,
unlike the other
.B \[rs]D
commands.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-d
Do not use
.I tpic
specials to implement drawing commands.
.
Horizontal and vertical lines are implemented by rules.
.
Other drawing commands are ignored.
.
.
.TP
.BI \-F\~ dir
Prepend directory
.RI dir /dev name
to the search path for font and device description files;
.I name
is the name of the device,
usually
.BR dvi .
.
.
.TP
.B \-l
Use landscape orientation rather than portrait.
.
.
.TP
.BI \-p\~ paper-format
Set physical dimensions of output medium,
overriding the
.BR \%papersize ,
.BR \%paperlength ,
and
.B \%paperwidth
directives in the
.I DESC
file.
.
.I paper-format
can be any argument accepted by the
.B \%papersize
directive;
see
.MR groff_font @MAN5EXT@ .
.
.
.TP
.BI \-w\~ n
Draw rules (lines) with a thickness of
.IR n \~thousandths
of an em.
.
The default thickness is
.B 40
(0.04\~em).
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
lists directories in which to search for
.IR devdvi ,
.IR grodvi 's
directory of device and font description files.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devdvi/\:DESC
describes the
.B dvi
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devdvi/ F
describes the font known
.RI as\~ F
on device
.BR dvi .
.
.
.TP
.I @MACRODIR@/\:dvi\:.tmac
defines font mappings,
special characters,
and colors for use with the
.B dvi
output device.
.
It is automatically loaded by
.I \%troffrc
when the
.B dvi
output device is selected.
.
.
.TP
.I @MACRODIR@/\:ec\:.tmac
configures the
.B dvi
output device to use
the EC and TC font families instead of CM
(Computer Modern).
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
DVI files produced by
.I grodvi
use a different resolution
(57,816 units per inch)
from those produced by \*[tx].
.
Incorrectly written drivers which assume the resolution used by \*[tx],
rather than using the resolution specified in the DVI file,
will not work with
.IR grodvi .
.
.
.LP
When using the
.B \-d
option with boxed tables,
vertical and horizontal lines can sometimes protrude by one pixel.
.
This is a consequence of the way \*[tx] requires that the heights
and widths of rules be rounded.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.UR https://\:texfaq\:.org/\:FAQ\-\:ECfonts
\[lq]What are the EC fonts?\[rq]
.UE ;
\*[tx] FAQ: Frequently Asked Question List for \*[tx]
.
.
.P
.MR tfmtodit @MAN1EXT@ ,
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR groff_out @MAN5EXT@ ,
.MR groff_font @MAN5EXT@ ,
.MR groff_char @MAN7EXT@ ,
.MR groff_tmac @MAN5EXT@
.
.
.\" Clean up.
.rm FT
.rm tx
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grodvi_1_man_C]
.do rr *groff_grodvi_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
