/* world.c generated by valac 0.38.7, the Vala compiler
 * generated from world.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgweather/gweather.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gio/gio.h>


#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;
typedef struct _ClocksWorldItemPrivate ClocksWorldItemPrivate;
enum  {
	CLOCKS_WORLD_ITEM_0_PROPERTY,
	CLOCKS_WORLD_ITEM_LOCATION_PROPERTY,
	CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY,
	CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY,
	CLOCKS_WORLD_ITEM_SELECTED_PROPERTY,
	CLOCKS_WORLD_ITEM_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY,
	CLOCKS_WORLD_ITEM_IS_DAYTIME_PROPERTY,
	CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY,
	CLOCKS_WORLD_ITEM_NUM_PROPERTIES
};
static GParamSpec* clocks_world_item_properties[CLOCKS_WORLD_ITEM_NUM_PROPERTIES];
#define _gweather_location_unref0(var) ((var == NULL) ? NULL : (var = (gweather_location_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gweather_timezone_unref0(var) ((var == NULL) ? NULL : (var = (gweather_timezone_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
enum  {
	CLOCKS_WORLD_ITEM_TICK_SIGNAL,
	CLOCKS_WORLD_ITEM_NUM_SIGNALS
};
static guint clocks_world_item_signals[CLOCKS_WORLD_ITEM_NUM_SIGNALS] = {0};

#define CLOCKS_WORLD_TYPE_TILE (clocks_world_tile_get_type ())
#define CLOCKS_WORLD_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_TILE, ClocksWorldTile))
#define CLOCKS_WORLD_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_TILE, ClocksWorldTileClass))
#define CLOCKS_WORLD_IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_TILE))
#define CLOCKS_WORLD_IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_TILE))
#define CLOCKS_WORLD_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_TILE, ClocksWorldTileClass))

typedef struct _ClocksWorldTile ClocksWorldTile;
typedef struct _ClocksWorldTileClass ClocksWorldTileClass;
typedef struct _ClocksWorldTilePrivate ClocksWorldTilePrivate;
enum  {
	CLOCKS_WORLD_TILE_0_PROPERTY,
	CLOCKS_WORLD_TILE_LOCATION_PROPERTY,
	CLOCKS_WORLD_TILE_NUM_PROPERTIES
};
static GParamSpec* clocks_world_tile_properties[CLOCKS_WORLD_TILE_NUM_PROPERTIES];

#define CLOCKS_WORLD_TYPE_LOCATION_DIALOG (clocks_world_location_dialog_get_type ())
#define CLOCKS_WORLD_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog))
#define CLOCKS_WORLD_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_IS_LOCATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_LOCATION_DIALOG))
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogClass))

typedef struct _ClocksWorldLocationDialog ClocksWorldLocationDialog;
typedef struct _ClocksWorldLocationDialogClass ClocksWorldLocationDialogClass;
typedef struct _ClocksWorldLocationDialogPrivate ClocksWorldLocationDialogPrivate;

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;
enum  {
	CLOCKS_WORLD_LOCATION_DIALOG_0_PROPERTY,
	CLOCKS_WORLD_LOCATION_DIALOG_NUM_PROPERTIES
};
static GParamSpec* clocks_world_location_dialog_properties[CLOCKS_WORLD_LOCATION_DIALOG_NUM_PROPERTIES];

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef struct _ClocksWorldFacePrivate ClocksWorldFacePrivate;

#define CLOCKS_TYPE_CONTENT_STORE (clocks_content_store_get_type ())
#define CLOCKS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStore))
#define CLOCKS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))
#define CLOCKS_IS_CONTENT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_IS_CONTENT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_STORE))
#define CLOCKS_CONTENT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_STORE, ClocksContentStoreClass))

typedef struct _ClocksContentStore ClocksContentStore;
typedef struct _ClocksContentStoreClass ClocksContentStoreClass;

#define CLOCKS_TYPE_CONTENT_VIEW (clocks_content_view_get_type ())
#define CLOCKS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentView))
#define CLOCKS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))
#define CLOCKS_IS_CONTENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_IS_CONTENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_CONTENT_VIEW))
#define CLOCKS_CONTENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_CONTENT_VIEW, ClocksContentViewClass))

typedef struct _ClocksContentView ClocksContentView;
typedef struct _ClocksContentViewClass ClocksContentViewClass;
enum  {
	CLOCKS_WORLD_FACE_0_PROPERTY,
	CLOCKS_WORLD_FACE_LABEL_PROPERTY,
	CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY,
	CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY,
	CLOCKS_WORLD_FACE_NUM_PROPERTIES
};
static GParamSpec* clocks_world_face_properties[CLOCKS_WORLD_FACE_NUM_PROPERTIES];

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
	gboolean (*get_selectable) (ClocksContentItem* self);
	void (*set_selectable) (ClocksContentItem* self, gboolean value);
	gboolean (*get_selected) (ClocksContentItem* self);
	void (*set_selected) (ClocksContentItem* self, gboolean value);
};

struct _ClocksWorldItem {
	GObject parent_instance;
	ClocksWorldItemPrivate * priv;
};

struct _ClocksWorldItemClass {
	GObjectClass parent_class;
	void (*tick) (ClocksWorldItem* self);
};

struct _ClocksWorldItemPrivate {
	GWeatherLocation* _location;
	gboolean _automatic;
	gboolean _selectable;
	gboolean _selected;
	gchar* _name;
	GTimeZone* time_zone;
	GDateTime* local_time;
	GDateTime* date_time;
	GWeatherInfo* weather_info;
};

struct _ClocksWorldTile {
	GtkGrid parent_instance;
	ClocksWorldTilePrivate * priv;
};

struct _ClocksWorldTileClass {
	GtkGridClass parent_class;
};

struct _ClocksWorldTilePrivate {
	ClocksWorldItem* _location;
	GtkImage* image;
	GtkLabel* time_label;
	GtkWidget* name_icon;
	GtkWidget* name_label;
};

struct _ClocksWorldLocationDialog {
	GtkDialog parent_instance;
	ClocksWorldLocationDialogPrivate * priv;
};

struct _ClocksWorldLocationDialogClass {
	GtkDialogClass parent_class;
};

struct _ClocksWorldLocationDialogPrivate {
	GWeatherLocationEntry* location_entry;
	ClocksWorldFace* world;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*back) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksWorldFace {
	GtkStack parent_instance;
	ClocksWorldFacePrivate * priv;
};

struct _ClocksWorldFaceClass {
	GtkStackClass parent_class;
};

struct _ClocksWorldFacePrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	ClocksContentStore* locations;
	GSettings* settings;
	GtkButton* new_button;
	GtkButton* back_button;
	ClocksWorldItem* standalone_location;
	GtkWidget* empty_view;
	ClocksContentView* content_view;
	GtkWidget* standalone;
	GtkLabel* standalone_time_label;
	GtkLabel* standalone_day_label;
	GtkLabel* standalone_sunrise_label;
	GtkLabel* standalone_sunset_label;
};

typedef GtkWidget* (*ClocksContentViewContentViewCreateWidgetFunc) (ClocksContentItem* item, void* user_data);
typedef void (*ClocksContentStoreForeachFunc) (ClocksContentItem* item, void* user_data);
typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;

typedef ClocksContentItem* (*ClocksContentStoreDeserializeItemFunc) (GVariant* v, void* user_data);

static gpointer clocks_world_item_parent_class = NULL;
static ClocksContentItemIface * clocks_world_item_clocks_content_item_parent_iface = NULL;
static gpointer clocks_world_tile_parent_class = NULL;
static GdkPixbuf* clocks_world_tile_day_pixbuf;
static GdkPixbuf* clocks_world_tile_day_pixbuf = NULL;
static GdkPixbuf* clocks_world_tile_night_pixbuf;
static GdkPixbuf* clocks_world_tile_night_pixbuf = NULL;
static gpointer clocks_world_location_dialog_parent_class = NULL;
static gpointer clocks_world_face_parent_class = NULL;
static ClocksClockIface * clocks_world_face_clocks_clock_parent_iface = NULL;

GType clocks_content_item_get_type (void) G_GNUC_CONST;
GType clocks_world_item_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemPrivate))
ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location);
static void clocks_world_item_real_serialize (ClocksContentItem* base, GVariantBuilder* builder);
gboolean clocks_world_item_get_automatic (ClocksWorldItem* self);
GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self);
ClocksContentItem* clocks_world_item_deserialize (GVariant* location_variant);
void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value);
void clocks_world_item_set_automatic (ClocksWorldItem* self, gboolean value);
gchar* clocks_world_item_get_country_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_state_name (ClocksWorldItem* self);
gchar* clocks_world_item_get_city_name (ClocksWorldItem* self);
gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self);
gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self);
gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
static void clocks_world_item_real_tick (ClocksWorldItem* self);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
static void clocks_world_item_finalize (GObject * obj);
gboolean clocks_content_item_get_selectable (ClocksContentItem* self);
gboolean clocks_content_item_get_selected (ClocksContentItem* self);
const gchar* clocks_content_item_get_name (ClocksContentItem* self);
static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_content_item_set_selectable (ClocksContentItem* self, gboolean value);
void clocks_content_item_set_selected (ClocksContentItem* self, gboolean value);
void clocks_content_item_set_name (ClocksContentItem* self, const gchar* value);
static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_world_tile_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_TILE, ClocksWorldTilePrivate))
GdkPixbuf* clocks_utils_load_image (const gchar* image);
ClocksWorldTile* clocks_world_tile_new (ClocksWorldItem* location);
ClocksWorldTile* clocks_world_tile_construct (GType object_type, ClocksWorldItem* location);
static void clocks_world_tile_update (ClocksWorldTile* self);
static void _clocks_world_tile_update_clocks_world_item_tick (ClocksWorldItem* _sender, gpointer self);
ClocksWorldItem* clocks_world_tile_get_location (ClocksWorldTile* self);
void clocks_world_tile_set_location (ClocksWorldTile* self, ClocksWorldItem* value);
static void clocks_world_tile_finalize (GObject * obj);
static void _vala_clocks_world_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_world_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_world_location_dialog_get_type (void) G_GNUC_CONST;
GType clocks_world_face_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialogPrivate))
ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent, ClocksWorldFace* world_face);
ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent, ClocksWorldFace* world_face);
static void clocks_world_location_dialog_icon_released (ClocksWorldLocationDialog* self);
static void _clocks_world_location_dialog_icon_released_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self);
gboolean clocks_world_face_location_exists (ClocksWorldFace* self, GWeatherLocation* location);
static void _clocks_world_location_dialog_location_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self);
static void clocks_world_location_dialog_finalize (GObject * obj);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_content_store_get_type (void) G_GNUC_CONST;
GType clocks_content_view_get_type (void) G_GNUC_CONST;
#define CLOCKS_WORLD_FACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFacePrivate))
ClocksWorldFace* clocks_world_face_new (ClocksHeaderBar* header_bar);
ClocksWorldFace* clocks_world_face_construct (GType object_type, ClocksHeaderBar* header_bar);
ClocksContentStore* clocks_content_store_new (void);
ClocksContentStore* clocks_content_store_construct (GType object_type);
void clocks_content_store_set_sorting (ClocksContentStore* self, GCompareDataFunc sort, void* sort_target, GDestroyNotify sort_target_destroy_notify);
static gint __lambda22_ (ClocksWorldFace* self, gconstpointer item1, gconstpointer item2);
static gint ___lambda22__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void __lambda23_ (ClocksWorldFace* self);
void clocks_world_face_reset_view (ClocksWorldFace* self);
static void ___lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
void clocks_content_view_bind_model (ClocksContentView* self, ClocksContentStore* store, ClocksContentViewContentViewCreateWidgetFunc create_func, void* create_func_target, GDestroyNotify create_func_target_destroy_notify);
static GtkWidget* __lambda24_ (ClocksWorldFace* self, ClocksContentItem* item);
static GtkWidget* ___lambda24__clocks_content_view_content_view_create_widget_func (ClocksContentItem* item, gpointer self);
void clocks_content_view_set_header_bar (ClocksContentView* self, ClocksHeaderBar* bar);
static void clocks_world_face_load (ClocksWorldFace* self);
static void __lambda25_ (ClocksWorldFace* self, guint position, guint removed, guint added);
static void clocks_world_face_save (ClocksWorldFace* self);
static void ___lambda25__g_list_model_items_changed (GListModel* _sender, guint position, guint removed, guint added, gpointer self);
static void __lambda26_ (ClocksWorldFace* self);
void clocks_content_store_foreach (ClocksContentStore* self, ClocksContentStoreForeachFunc func, void* func_target);
static void __lambda27_ (ClocksWorldFace* self, ClocksContentItem* l);
static void ___lambda27__clocks_content_store_foreach_func (ClocksContentItem* item, gpointer self);
static void clocks_world_face_update_standalone (ClocksWorldFace* self);
static void ___lambda26__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self);
static void clocks_world_face_item_activated (ClocksWorldFace* self, ClocksContentItem* item);
static void clocks_world_face_show_standalone (ClocksWorldFace* self, ClocksWorldItem* location);
static void _clocks_world_face_item_activated_clocks_content_view_item_activated (ClocksContentView* _sender, ClocksContentItem* item, gpointer self);
static void clocks_world_face_visible_child_changed (ClocksWorldFace* self);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
void clocks_header_bar_set_mode (ClocksHeaderBar* self, ClocksHeaderBarMode value);
static void _clocks_world_face_visible_child_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void clocks_content_store_deserialize (ClocksContentStore* self, GVariant* variant, ClocksContentStoreDeserializeItemFunc deserialize_item, void* deserialize_item_target);
static ClocksContentItem* _clocks_world_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v, gpointer self);
GVariant* clocks_content_store_serialize (ClocksContentStore* self);
static void clocks_world_face_add_location_item (ClocksWorldFace* self, ClocksWorldItem* item);
void clocks_content_store_add (ClocksContentStore* self, ClocksContentItem* item);
void clocks_world_face_add_location (ClocksWorldFace* self, GWeatherLocation* location);
static void clocks_world_face_real_activate_new (ClocksClock* base);
static void __lambda28_ (ClocksWorldFace* self, GtkDialog* dialog, gint response);
static void ___lambda28__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void clocks_world_face_real_activate_select_all (ClocksClock* base);
void clocks_content_view_select_all (ClocksContentView* self);
static void clocks_world_face_real_activate_select_none (ClocksClock* base);
void clocks_content_view_unselect_all (ClocksContentView* self);
static gboolean clocks_world_face_real_escape_pressed (ClocksClock* base);
gboolean clocks_content_view_escape_pressed (ClocksContentView* self);
static void clocks_world_face_real_back (ClocksClock* base);
static void clocks_world_face_real_update_header_bar (ClocksClock* base);
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
void clocks_content_view_update_header_bar (ClocksContentView* self);
static void clocks_world_face_finalize (GObject * obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_world_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_world_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _gweather_timezone_ref0 (gpointer self) {
	return self ? gweather_timezone_ref (self) : NULL;
}


ClocksWorldItem* clocks_world_item_construct (GType object_type, GWeatherLocation* location) {
	ClocksWorldItem * self = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherTimezone* weather_time_zone = NULL;
	GWeatherLocation* _tmp1_;
	GWeatherTimezone* _tmp2_;
	GWeatherTimezone* _tmp3_;
	const gchar* _tmp4_;
	GTimeZone* _tmp5_;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	self = (ClocksWorldItem*) g_object_new (object_type, "location", _tmp0_, NULL);
	_tmp1_ = location;
	_tmp2_ = gweather_location_get_timezone (_tmp1_);
	_tmp3_ = _gweather_timezone_ref0 (_tmp2_);
	weather_time_zone = _tmp3_;
	_tmp4_ = gweather_timezone_get_tzid (weather_time_zone);
	_tmp5_ = g_time_zone_new (_tmp4_);
	_g_time_zone_unref0 (self->priv->time_zone);
	self->priv->time_zone = _tmp5_;
	g_signal_emit (self, clocks_world_item_signals[CLOCKS_WORLD_ITEM_TICK_SIGNAL], 0);
	_gweather_timezone_unref0 (weather_time_zone);
	return self;
}


ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location) {
	return clocks_world_item_construct (CLOCKS_WORLD_TYPE_ITEM, location);
}


static void clocks_world_item_real_serialize (ClocksContentItem* base, GVariantBuilder* builder) {
	ClocksWorldItem * self;
	gboolean _tmp0_;
	self = (ClocksWorldItem*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = self->priv->_automatic;
	if (!_tmp0_) {
		GVariantBuilder* _tmp1_;
		GVariantType* _tmp2_;
		GVariantType* _tmp3_;
		GVariantBuilder* _tmp4_;
		GWeatherLocation* _tmp5_;
		GVariant* _tmp6_;
		GVariantBuilder* _tmp7_;
		_tmp1_ = builder;
		_tmp2_ = g_variant_type_new ("a{sv}");
		_tmp3_ = _tmp2_;
		g_variant_builder_open (_tmp1_, _tmp3_);
		_g_variant_type_free0 (_tmp3_);
		_tmp4_ = builder;
		_tmp5_ = self->priv->_location;
		_tmp6_ = gweather_location_serialize (_tmp5_);
		g_variant_builder_add (_tmp4_, "{sv}", "location", _tmp6_, NULL);
		_tmp7_ = builder;
		g_variant_builder_close (_tmp7_);
	}
}


static gpointer _gweather_location_ref0 (gpointer self) {
	return self ? gweather_location_ref (self) : NULL;
}


ClocksContentItem* clocks_world_item_deserialize (GVariant* location_variant) {
	ClocksContentItem* result = NULL;
	GWeatherLocation* location = NULL;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	ClocksWorldItem* _tmp21_ = NULL;
	GWeatherLocation* _tmp22_;
	g_return_val_if_fail (location_variant != NULL, NULL);
	location = NULL;
	_tmp0_ = gweather_location_get_world ();
	_tmp1_ = _gweather_location_ref0 (_tmp0_);
	world = _tmp1_;
	{
		GVariantIter* _v_it = NULL;
		GVariant* _tmp2_;
		GVariantIter* _tmp3_;
		GVariant* v = NULL;
		_tmp2_ = location_variant;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		_v_it = _tmp3_;
		while (TRUE) {
			GVariantIter* _tmp4_;
			GVariant* _tmp5_;
			GVariant* _tmp6_;
			gchar* key = NULL;
			GVariant* _tmp7_;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp4_ = _v_it;
			_tmp5_ = g_variant_iter_next_value (_tmp4_);
			_g_variant_unref0 (v);
			v = _tmp5_;
			_tmp6_ = v;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = v;
			_tmp8_ = g_variant_get_child_value (_tmp7_, (gsize) 0);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_variant_get_string (_tmp9_, NULL);
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_variant_unref0 (_tmp9_);
			key = _tmp12_;
			_tmp13_ = key;
			if (g_strcmp0 (_tmp13_, "location") == 0) {
				GWeatherLocation* _tmp14_;
				GVariant* _tmp15_;
				GVariant* _tmp16_;
				GVariant* _tmp17_;
				GVariant* _tmp18_;
				GVariant* _tmp19_;
				GWeatherLocation* _tmp20_;
				_tmp14_ = world;
				_tmp15_ = v;
				_tmp16_ = g_variant_get_child_value (_tmp15_, (gsize) 1);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_variant_get_child_value (_tmp17_, (gsize) 0);
				_tmp19_ = _tmp18_;
				_tmp20_ = gweather_location_deserialize (_tmp14_, _tmp19_);
				_gweather_location_unref0 (location);
				location = _tmp20_;
				_g_variant_unref0 (_tmp19_);
				_g_variant_unref0 (_tmp17_);
			}
			_g_free0 (key);
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	_tmp22_ = location;
	if (_tmp22_ != NULL) {
		GWeatherLocation* _tmp23_;
		ClocksWorldItem* _tmp24_;
		_tmp23_ = location;
		_tmp24_ = clocks_world_item_new (_tmp23_);
		_g_object_unref0 (_tmp21_);
		_tmp21_ = _tmp24_;
	} else {
		_g_object_unref0 (_tmp21_);
		_tmp21_ = NULL;
	}
	result = (ClocksContentItem*) _tmp21_;
	_gweather_location_unref0 (world);
	_gweather_location_unref0 (location);
	return result;
}


GWeatherLocation* clocks_world_item_get_location (ClocksWorldItem* self) {
	GWeatherLocation* result;
	GWeatherLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void clocks_world_item_set_location (ClocksWorldItem* self, GWeatherLocation* value) {
	g_return_if_fail (self != NULL);
	if (clocks_world_item_get_location (self) != value) {
		GWeatherLocation* _tmp0_;
		GWeatherLocation* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _gweather_location_ref0 (_tmp0_);
		_gweather_location_unref0 (self->priv->_location);
		self->priv->_location = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_LOCATION_PROPERTY]);
	}
}


gboolean clocks_world_item_get_automatic (ClocksWorldItem* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic;
	result = _tmp0_;
	return result;
}


void clocks_world_item_set_automatic (ClocksWorldItem* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (clocks_world_item_get_automatic (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_automatic = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY]);
	}
}


static gboolean clocks_world_item_real_get_selectable (ClocksContentItem* base) {
	gboolean result;
	ClocksWorldItem* self;
	gboolean _tmp0_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = self->priv->_selectable;
	result = _tmp0_;
	return result;
}


static void clocks_world_item_real_set_selectable (ClocksContentItem* base, gboolean value) {
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	if (clocks_world_item_real_get_selectable (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_selectable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY]);
	}
}


static gboolean clocks_world_item_real_get_selected (ClocksContentItem* base) {
	gboolean result;
	ClocksWorldItem* self;
	gboolean _tmp0_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


static void clocks_world_item_real_set_selected (ClocksContentItem* base, gboolean value) {
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	if (clocks_world_item_real_get_selected (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_selected = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SELECTED_PROPERTY]);
	}
}


static const gchar* clocks_world_item_real_get_name (ClocksContentItem* base) {
	const gchar* result;
	ClocksWorldItem* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp27_;
	self = (ClocksWorldItem*) base;
	_tmp0_ = clocks_world_item_get_country_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = clocks_world_item_get_state_name (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_ != NULL;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = clocks_world_item_get_city_name (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = clocks_world_item_get_state_name (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp14_ = clocks_world_item_get_country_name (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("%s, %s, %s", _tmp10_, _tmp13_, _tmp16_);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp17_;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
		} else {
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp18_ = clocks_world_item_get_city_name (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = clocks_world_item_get_country_name (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup_printf ("%s, %s", _tmp20_, _tmp23_);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp24_;
			_g_free0 (_tmp23_);
			_g_free0 (_tmp20_);
		}
	} else {
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = clocks_world_item_get_city_name (self);
		_tmp26_ = _tmp25_;
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp26_;
	}
	_tmp27_ = self->priv->_name;
	result = _tmp27_;
	return result;
}


static void clocks_world_item_real_set_name (ClocksContentItem* base, const gchar* value) {
	ClocksWorldItem* self;
	self = (ClocksWorldItem*) base;
	g_object_notify_by_pspec ((GObject *) self, clocks_world_item_properties[CLOCKS_WORLD_ITEM_NAME_PROPERTY]);
}


gchar* clocks_world_item_get_city_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_city_name (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_state_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* parent = NULL;
	GWeatherLocation* _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	GWeatherLocation* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_parent (_tmp0_);
	_tmp2_ = _gweather_location_ref0 (_tmp1_);
	parent = _tmp2_;
	_tmp3_ = parent;
	if (_tmp3_ != NULL) {
		GWeatherLocation* _tmp4_;
		GWeatherLocationLevel _tmp5_;
		_tmp4_ = parent;
		_tmp5_ = gweather_location_get_level (_tmp4_);
		if (_tmp5_ == GWEATHER_LOCATION_ADM1) {
			GWeatherLocation* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = parent;
			_tmp7_ = gweather_location_get_name (_tmp6_);
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			_gweather_location_unref0 (parent);
			return result;
		}
	}
	result = NULL;
	_gweather_location_unref0 (parent);
	return result;
}


gchar* clocks_world_item_get_country_name (ClocksWorldItem* self) {
	gchar* result;
	GWeatherLocation* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = gweather_location_get_country_name (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean clocks_world_item_get_is_daytime (ClocksWorldItem* self) {
	gboolean result;
	GWeatherInfo* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->weather_info;
	_tmp1_ = gweather_info_is_daytime (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* clocks_world_item_get_sunrise_label (ClocksWorldItem* self) {
	gchar* result;
	gulong sunrise = 0UL;
	GWeatherInfo* _tmp0_;
	gulong _tmp1_ = 0UL;
	gboolean _tmp2_;
	GDateTime* sunrise_time = NULL;
	gulong _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	ClocksUtilsWallClock* _tmp9_;
	ClocksUtilsWallClock* _tmp10_;
	GDateTime* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp2_ = gweather_info_get_value_sunrise (_tmp0_, &_tmp1_);
	sunrise = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("-");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sunrise;
	_tmp5_ = g_date_time_new_from_unix_local ((gint64) _tmp4_);
	sunrise_time = _tmp5_;
	_tmp6_ = sunrise_time;
	_tmp7_ = self->priv->time_zone;
	_tmp8_ = g_date_time_to_timezone (_tmp6_, _tmp7_);
	_g_date_time_unref0 (sunrise_time);
	sunrise_time = _tmp8_;
	_tmp9_ = clocks_utils_wall_clock_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = sunrise_time;
	_tmp12_ = clocks_utils_wall_clock_format_time (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	result = _tmp13_;
	_g_date_time_unref0 (sunrise_time);
	return result;
}


gchar* clocks_world_item_get_sunset_label (ClocksWorldItem* self) {
	gchar* result;
	gulong sunset = 0UL;
	GWeatherInfo* _tmp0_;
	gulong _tmp1_ = 0UL;
	gboolean _tmp2_;
	GDateTime* sunset_time = NULL;
	gulong _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GTimeZone* _tmp7_;
	GDateTime* _tmp8_;
	ClocksUtilsWallClock* _tmp9_;
	ClocksUtilsWallClock* _tmp10_;
	GDateTime* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->weather_info;
	_tmp2_ = gweather_info_get_value_sunset (_tmp0_, &_tmp1_);
	sunset = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("-");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sunset;
	_tmp5_ = g_date_time_new_from_unix_local ((gint64) _tmp4_);
	sunset_time = _tmp5_;
	_tmp6_ = sunset_time;
	_tmp7_ = self->priv->time_zone;
	_tmp8_ = g_date_time_to_timezone (_tmp6_, _tmp7_);
	_g_date_time_unref0 (sunset_time);
	sunset_time = _tmp8_;
	_tmp9_ = clocks_utils_wall_clock_get_default ();
	_tmp10_ = _tmp9_;
	_tmp11_ = sunset_time;
	_tmp12_ = clocks_utils_wall_clock_format_time (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp10_);
	result = _tmp13_;
	_g_date_time_unref0 (sunset_time);
	return result;
}


gchar* clocks_world_item_get_time_label (ClocksWorldItem* self) {
	gchar* result;
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->date_time;
	_tmp3_ = clocks_utils_wall_clock_format_time (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self) {
	const gchar* result;
	gint d = 0;
	GDateTime* _tmp0_;
	gint _tmp1_;
	gint t = 0;
	GDateTime* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->date_time;
	_tmp1_ = g_date_time_get_day_of_year (_tmp0_);
	d = _tmp1_;
	_tmp2_ = self->priv->local_time;
	_tmp3_ = g_date_time_get_day_of_year (_tmp2_);
	t = _tmp3_;
	_tmp4_ = d;
	_tmp5_ = t;
	if (_tmp4_ < _tmp5_) {
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_;
		_tmp8_ = d;
		if (_tmp8_ == 1) {
			gint _tmp9_;
			_tmp9_ = t;
			_tmp7_ = _tmp9_ != 2;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = _ ("Tomorrow");
		} else {
			_tmp6_ = _ ("Yesterday");
		}
		result = _tmp6_;
		return result;
	} else {
		gint _tmp10_;
		gint _tmp11_;
		_tmp10_ = d;
		_tmp11_ = t;
		if (_tmp10_ > _tmp11_) {
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gint _tmp14_;
			_tmp14_ = t;
			if (_tmp14_ == 1) {
				gint _tmp15_;
				_tmp15_ = d;
				_tmp13_ = _tmp15_ != 2;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_tmp12_ = _ ("Yesterday");
			} else {
				_tmp12_ = _ ("Tomorrow");
			}
			result = _tmp12_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void clocks_world_item_real_tick (ClocksWorldItem* self) {
	ClocksUtilsWallClock* wallclock = NULL;
	ClocksUtilsWallClock* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GTimeZone* _tmp5_;
	GDateTime* _tmp6_;
	GWeatherLocation* _tmp7_;
	GObject* _tmp8_;
	GObject* _tmp9_;
	_tmp0_ = clocks_utils_wall_clock_get_default ();
	wallclock = _tmp0_;
	_tmp1_ = clocks_utils_wall_clock_get_date_time (wallclock);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	_g_date_time_unref0 (self->priv->local_time);
	self->priv->local_time = _tmp3_;
	_tmp4_ = self->priv->local_time;
	_tmp5_ = self->priv->time_zone;
	_tmp6_ = g_date_time_to_timezone (_tmp4_, _tmp5_);
	_g_date_time_unref0 (self->priv->date_time);
	self->priv->date_time = _tmp6_;
	_tmp7_ = self->priv->_location;
	_tmp8_ = g_object_new (gweather_info_get_type (), "location", _tmp7_, "enabled-providers", GWEATHER_PROVIDER_NONE, NULL);
	_tmp9_ = G_IS_INITIALLY_UNOWNED (_tmp8_) ? g_object_ref_sink (_tmp8_) : _tmp8_;
	_g_object_unref0 (self->priv->weather_info);
	self->priv->weather_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gweather_info_get_type (), GWeatherInfo);
	_g_object_unref0 (wallclock);
}


static void clocks_world_item_class_init (ClocksWorldItemClass * klass) {
	clocks_world_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldItemPrivate));
	((ClocksWorldItemClass *) klass)->tick = clocks_world_item_real_tick;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_LOCATION_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_LOCATION_PROPERTY] = g_param_spec_boxed ("location", "location", "location", gweather_location_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY] = g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY] = g_param_spec_boolean ("selectable", "selectable", "selectable", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SELECTED_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY] = g_param_spec_string ("city-name", "city-name", "city-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY] = g_param_spec_string ("state-name", "state-name", "state-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY] = g_param_spec_string ("country-name", "country-name", "country-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_IS_DAYTIME_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_IS_DAYTIME_PROPERTY] = g_param_spec_boolean ("is-daytime", "is-daytime", "is-daytime", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY] = g_param_spec_string ("sunrise-label", "sunrise-label", "sunrise-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY] = g_param_spec_string ("sunset-label", "sunset-label", "sunset-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY] = g_param_spec_string ("time-label", "time-label", "time-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY, clocks_world_item_properties[CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY] = g_param_spec_string ("day-label", "day-label", "day-label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	clocks_world_item_signals[CLOCKS_WORLD_ITEM_TICK_SIGNAL] = g_signal_new ("tick", CLOCKS_WORLD_TYPE_ITEM, G_SIGNAL_RUN_FIRST, G_STRUCT_OFFSET (ClocksWorldItemClass, tick), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_world_item_clocks_content_item_interface_init (ClocksContentItemIface * iface) {
	clocks_world_item_clocks_content_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize = (void (*) (ClocksContentItem *, GVariantBuilder*)) clocks_world_item_real_serialize;
	iface->get_selectable = clocks_world_item_real_get_selectable;
	iface->set_selectable = clocks_world_item_real_set_selectable;
	iface->get_selected = clocks_world_item_real_get_selected;
	iface->set_selected = clocks_world_item_real_set_selected;
	iface->get_name = clocks_world_item_real_get_name;
	iface->set_name = clocks_world_item_real_set_name;
}


static void clocks_world_item_instance_init (ClocksWorldItem * self) {
	self->priv = CLOCKS_WORLD_ITEM_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->priv->_selectable = TRUE;
	self->priv->_selected = FALSE;
}


static void clocks_world_item_finalize (GObject * obj) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	_gweather_location_unref0 (self->priv->_location);
	_g_free0 (self->priv->_name);
	_g_time_zone_unref0 (self->priv->time_zone);
	_g_date_time_unref0 (self->priv->local_time);
	_g_date_time_unref0 (self->priv->date_time);
	_g_object_unref0 (self->priv->weather_info);
	G_OBJECT_CLASS (clocks_world_item_parent_class)->finalize (obj);
}


GType clocks_world_item_get_type (void) {
	static volatile gsize clocks_world_item_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldItem), 0, (GInstanceInitFunc) clocks_world_item_instance_init, NULL };
		static const GInterfaceInfo clocks_content_item_info = { (GInterfaceInitFunc) clocks_world_item_clocks_content_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_item_type_id;
		clocks_world_item_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksWorldItem", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_item_type_id, CLOCKS_TYPE_CONTENT_ITEM, &clocks_content_item_info);
		g_once_init_leave (&clocks_world_item_type_id__volatile, clocks_world_item_type_id);
	}
	return clocks_world_item_type_id__volatile;
}


static void _vala_clocks_world_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION_PROPERTY:
		g_value_set_boxed (value, clocks_world_item_get_location (self));
		break;
		case CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY:
		g_value_set_boolean (value, clocks_world_item_get_automatic (self));
		break;
		case CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY:
		g_value_set_boolean (value, clocks_content_item_get_selectable ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_SELECTED_PROPERTY:
		g_value_set_boolean (value, clocks_content_item_get_selected ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_NAME_PROPERTY:
		g_value_set_string (value, clocks_content_item_get_name ((ClocksContentItem*) self));
		break;
		case CLOCKS_WORLD_ITEM_CITY_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_city_name (self));
		break;
		case CLOCKS_WORLD_ITEM_STATE_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_state_name (self));
		break;
		case CLOCKS_WORLD_ITEM_COUNTRY_NAME_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_country_name (self));
		break;
		case CLOCKS_WORLD_ITEM_IS_DAYTIME_PROPERTY:
		g_value_set_boolean (value, clocks_world_item_get_is_daytime (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNRISE_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_sunrise_label (self));
		break;
		case CLOCKS_WORLD_ITEM_SUNSET_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_sunset_label (self));
		break;
		case CLOCKS_WORLD_ITEM_TIME_LABEL_PROPERTY:
		g_value_take_string (value, clocks_world_item_get_time_label (self));
		break;
		case CLOCKS_WORLD_ITEM_DAY_LABEL_PROPERTY:
		g_value_set_string (value, clocks_world_item_get_day_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem);
	switch (property_id) {
		case CLOCKS_WORLD_ITEM_LOCATION_PROPERTY:
		clocks_world_item_set_location (self, g_value_get_boxed (value));
		break;
		case CLOCKS_WORLD_ITEM_AUTOMATIC_PROPERTY:
		clocks_world_item_set_automatic (self, g_value_get_boolean (value));
		break;
		case CLOCKS_WORLD_ITEM_SELECTABLE_PROPERTY:
		clocks_content_item_set_selectable ((ClocksContentItem*) self, g_value_get_boolean (value));
		break;
		case CLOCKS_WORLD_ITEM_SELECTED_PROPERTY:
		clocks_content_item_set_selected ((ClocksContentItem*) self, g_value_get_boolean (value));
		break;
		case CLOCKS_WORLD_ITEM_NAME_PROPERTY:
		clocks_content_item_set_name ((ClocksContentItem*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _clocks_world_tile_update_clocks_world_item_tick (ClocksWorldItem* _sender, gpointer self) {
	clocks_world_tile_update ((ClocksWorldTile*) self);
}


ClocksWorldTile* clocks_world_tile_construct (GType object_type, ClocksWorldItem* location) {
	ClocksWorldTile * self = NULL;
	ClocksWorldItem* _tmp0_;
	ClocksWorldItem* _tmp1_;
	GtkWidget* _tmp2_;
	ClocksWorldItem* _tmp3_;
	GtkWidget* _tmp4_;
	ClocksWorldItem* _tmp5_;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	self = (ClocksWorldTile*) g_object_new (object_type, "location", _tmp0_, NULL);
	_tmp1_ = location;
	_tmp2_ = self->priv->name_icon;
	g_object_bind_property_with_closures ((GObject*) _tmp1_, "automatic", (GObject*) _tmp2_, "visible", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = location;
	_tmp4_ = self->priv->name_label;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "name", (GObject*) _tmp4_, "label", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = location;
	g_signal_connect_object (_tmp5_, "tick", (GCallback) _clocks_world_tile_update_clocks_world_item_tick, self, 0);
	clocks_world_tile_update (self);
	return self;
}


ClocksWorldTile* clocks_world_tile_new (ClocksWorldItem* location) {
	return clocks_world_tile_construct (CLOCKS_WORLD_TYPE_TILE, location);
}


static void clocks_world_tile_update (ClocksWorldTile* self) {
	ClocksWorldItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp9_ = FALSE;
	ClocksWorldItem* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	_tmp1_ = clocks_world_item_get_is_daytime (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStyleContext* _tmp3_;
		GtkImage* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp3_, "night");
		_tmp4_ = self->priv->image;
		_tmp5_ = clocks_world_tile_day_pixbuf;
		g_object_set (_tmp4_, "pixbuf", _tmp5_, NULL);
	} else {
		GtkStyleContext* _tmp6_;
		GtkImage* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp6_, "night");
		_tmp7_ = self->priv->image;
		_tmp8_ = clocks_world_tile_night_pixbuf;
		g_object_set (_tmp7_, "pixbuf", _tmp8_, NULL);
	}
	_tmp10_ = self->priv->_location;
	_tmp11_ = clocks_world_item_get_day_label (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ClocksWorldItem* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = self->priv->_location;
		_tmp14_ = clocks_world_item_get_day_label (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = g_strcmp0 (_tmp15_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkLabel* _tmp16_;
		ClocksWorldItem* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		ClocksWorldItem* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp16_ = self->priv->time_label;
		_tmp17_ = self->priv->_location;
		_tmp18_ = clocks_world_item_get_time_label (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_location;
		_tmp22_ = clocks_world_item_get_day_label (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("%s\n<span size='xx-small'>%s</span>", _tmp20_, _tmp23_);
		_tmp25_ = _tmp24_;
		gtk_label_set_label (_tmp16_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp20_);
	} else {
		GtkLabel* _tmp26_;
		ClocksWorldItem* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = self->priv->time_label;
		_tmp27_ = self->priv->_location;
		_tmp28_ = clocks_world_item_get_time_label (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		gtk_label_set_label (_tmp26_, _tmp30_);
		_g_free0 (_tmp30_);
	}
}


ClocksWorldItem* clocks_world_tile_get_location (ClocksWorldTile* self) {
	ClocksWorldItem* result;
	ClocksWorldItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void clocks_world_tile_set_location (ClocksWorldTile* self, ClocksWorldItem* value) {
	g_return_if_fail (self != NULL);
	if (clocks_world_tile_get_location (self) != value) {
		ClocksWorldItem* _tmp0_;
		ClocksWorldItem* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_tile_properties[CLOCKS_WORLD_TILE_LOCATION_PROPERTY]);
	}
}


static void clocks_world_tile_class_init (ClocksWorldTileClass * klass) {
	gint ClocksWorldTile_private_offset;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	clocks_world_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_tile_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_TILE_LOCATION_PROPERTY, clocks_world_tile_properties[CLOCKS_WORLD_TILE_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", CLOCKS_WORLD_TYPE_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	ClocksWorldTile_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/worldtile.ui");
	_tmp0_ = clocks_utils_load_image ("day.png");
	clocks_world_tile_day_pixbuf = _tmp0_;
	_tmp1_ = clocks_utils_load_image ("night.png");
	clocks_world_tile_night_pixbuf = _tmp1_;
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, ClocksWorldTile_private_offset + G_STRUCT_OFFSET (ClocksWorldTilePrivate, image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, ClocksWorldTile_private_offset + G_STRUCT_OFFSET (ClocksWorldTilePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_icon", FALSE, ClocksWorldTile_private_offset + G_STRUCT_OFFSET (ClocksWorldTilePrivate, name_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ClocksWorldTile_private_offset + G_STRUCT_OFFSET (ClocksWorldTilePrivate, name_label));
}


static void clocks_world_tile_instance_init (ClocksWorldTile * self) {
	self->priv = CLOCKS_WORLD_TILE_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_world_tile_finalize (GObject * obj) {
	ClocksWorldTile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_TILE, ClocksWorldTile);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->name_icon);
	_g_object_unref0 (self->priv->name_label);
	G_OBJECT_CLASS (clocks_world_tile_parent_class)->finalize (obj);
}


GType clocks_world_tile_get_type (void) {
	static volatile gsize clocks_world_tile_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_tile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldTile), 0, (GInstanceInitFunc) clocks_world_tile_instance_init, NULL };
		GType clocks_world_tile_type_id;
		clocks_world_tile_type_id = g_type_register_static (gtk_grid_get_type (), "ClocksWorldTile", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_tile_type_id__volatile, clocks_world_tile_type_id);
	}
	return clocks_world_tile_type_id__volatile;
}


static void _vala_clocks_world_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldTile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_TILE, ClocksWorldTile);
	switch (property_id) {
		case CLOCKS_WORLD_TILE_LOCATION_PROPERTY:
		g_value_set_object (value, clocks_world_tile_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldTile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_TILE, ClocksWorldTile);
	switch (property_id) {
		case CLOCKS_WORLD_TILE_LOCATION_PROPERTY:
		clocks_world_tile_set_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ClocksWorldLocationDialog* clocks_world_location_dialog_construct (GType object_type, GtkWindow* parent, ClocksWorldFace* world_face) {
	ClocksWorldLocationDialog * self = NULL;
	GtkWindow* _tmp0_;
	ClocksWorldFace* _tmp1_;
	ClocksWorldFace* _tmp2_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (world_face != NULL, NULL);
	_tmp0_ = parent;
	self = (ClocksWorldLocationDialog*) g_object_new (object_type, "transient-for", _tmp0_, "use-header-bar", 1, NULL);
	_tmp1_ = world_face;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->world);
	self->priv->world = _tmp2_;
	return self;
}


ClocksWorldLocationDialog* clocks_world_location_dialog_new (GtkWindow* parent, ClocksWorldFace* world_face) {
	return clocks_world_location_dialog_construct (CLOCKS_WORLD_TYPE_LOCATION_DIALOG, parent, world_face);
}


static void clocks_world_location_dialog_icon_released (ClocksWorldLocationDialog* self) {
	GWeatherLocationEntry* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_entry;
	g_object_get ((GtkEntry*) _tmp0_, "secondary-icon-name", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "edit-clear-symbolic") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GWeatherLocationEntry* _tmp5_;
		_tmp5_ = self->priv->location_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp5_, "");
	}
}


static void _clocks_world_location_dialog_icon_released_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	clocks_world_location_dialog_icon_released ((ClocksWorldLocationDialog*) self);
}


static void clocks_world_location_dialog_location_changed (ClocksWorldLocationDialog* self) {
	GWeatherLocation* l = NULL;
	GWeatherTimezone* t = NULL;
	GWeatherLocationEntry* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp16_ = FALSE;
	GWeatherLocation* _tmp17_;
	g_return_if_fail (self != NULL);
	l = NULL;
	t = NULL;
	_tmp0_ = self->priv->location_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GWeatherLocationEntry* _tmp2_;
		GWeatherLocation* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GWeatherLocation* _tmp5_;
		_tmp2_ = self->priv->location_entry;
		_tmp3_ = gweather_location_entry_get_location (_tmp2_);
		_gweather_location_unref0 (l);
		l = _tmp3_;
		_tmp5_ = l;
		if (_tmp5_ != NULL) {
			ClocksWorldFace* _tmp6_;
			GWeatherLocation* _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->world;
			_tmp7_ = l;
			_tmp8_ = clocks_world_face_location_exists (_tmp6_, _tmp7_);
			_tmp4_ = !_tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GWeatherLocation* _tmp9_;
			GWeatherTimezone* _tmp10_;
			GWeatherTimezone* _tmp11_;
			GWeatherTimezone* _tmp12_;
			_tmp9_ = l;
			_tmp10_ = gweather_location_get_timezone (_tmp9_);
			_tmp11_ = _gweather_timezone_ref0 (_tmp10_);
			_gweather_timezone_unref0 (t);
			t = _tmp11_;
			_tmp12_ = t;
			if (_tmp12_ == NULL) {
				GWeatherLocation* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = l;
				_tmp14_ = gweather_location_get_city_name (_tmp13_);
				_tmp15_ = _tmp14_;
				g_warning ("world.vala:258: Timezone not defined for %s. This is a bug in libgweat" \
"her database", _tmp15_);
				_g_free0 (_tmp15_);
			}
		}
	}
	_tmp17_ = l;
	if (_tmp17_ != NULL) {
		GWeatherTimezone* _tmp18_;
		_tmp18_ = t;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, 1, _tmp16_);
	_gweather_timezone_unref0 (t);
	_gweather_location_unref0 (l);
}


static void _clocks_world_location_dialog_location_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	clocks_world_location_dialog_location_changed ((ClocksWorldLocationDialog*) self);
}


ClocksWorldItem* clocks_world_location_dialog_get_location (ClocksWorldLocationDialog* self) {
	ClocksWorldItem* result = NULL;
	GWeatherLocation* location = NULL;
	GWeatherLocationEntry* _tmp0_;
	GWeatherLocation* _tmp1_;
	ClocksWorldItem* _tmp2_ = NULL;
	GWeatherLocation* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->location_entry;
	_tmp1_ = gweather_location_entry_get_location (_tmp0_);
	location = _tmp1_;
	_tmp3_ = location;
	if (_tmp3_ != NULL) {
		GWeatherLocation* _tmp4_;
		ClocksWorldItem* _tmp5_;
		_tmp4_ = location;
		_tmp5_ = clocks_world_item_new (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		_g_object_unref0 (_tmp2_);
		_tmp2_ = NULL;
	}
	result = _tmp2_;
	_gweather_location_unref0 (location);
	return result;
}


static void clocks_world_location_dialog_class_init (ClocksWorldLocationDialogClass * klass) {
	gint ClocksWorldLocationDialog_private_offset;
	clocks_world_location_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldLocationDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_world_location_dialog_finalize;
	ClocksWorldLocationDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/worldlocationdialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_entry", FALSE, ClocksWorldLocationDialog_private_offset + G_STRUCT_OFFSET (ClocksWorldLocationDialogPrivate, location_entry));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "icon_released", G_CALLBACK(_clocks_world_location_dialog_icon_released_gtk_entry_icon_release));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "location_changed", G_CALLBACK(_clocks_world_location_dialog_location_changed_gtk_editable_changed));
}


static void clocks_world_location_dialog_instance_init (ClocksWorldLocationDialog * self) {
	self->priv = CLOCKS_WORLD_LOCATION_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_world_location_dialog_finalize (GObject * obj) {
	ClocksWorldLocationDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog);
	_g_object_unref0 (self->priv->location_entry);
	_g_object_unref0 (self->priv->world);
	G_OBJECT_CLASS (clocks_world_location_dialog_parent_class)->finalize (obj);
}


GType clocks_world_location_dialog_get_type (void) {
	static volatile gsize clocks_world_location_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_location_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldLocationDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_location_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldLocationDialog), 0, (GInstanceInitFunc) clocks_world_location_dialog_instance_init, NULL };
		GType clocks_world_location_dialog_type_id;
		clocks_world_location_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ClocksWorldLocationDialog", &g_define_type_info, 0);
		g_once_init_leave (&clocks_world_location_dialog_type_id__volatile, clocks_world_location_dialog_type_id);
	}
	return clocks_world_location_dialog_type_id__volatile;
}


static gint __lambda22_ (ClocksWorldFace* self, gconstpointer item1, gconstpointer item2) {
	gint result = 0;
	gint offset1 = 0;
	gconstpointer _tmp0_;
	GWeatherLocation* _tmp1_;
	GWeatherLocation* _tmp2_;
	GWeatherTimezone* _tmp3_;
	gint _tmp4_;
	gint offset2 = 0;
	gconstpointer _tmp5_;
	GWeatherLocation* _tmp6_;
	GWeatherLocation* _tmp7_;
	GWeatherTimezone* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	_tmp0_ = item1;
	_tmp1_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp2_ = _tmp1_;
	_tmp3_ = gweather_location_get_timezone (_tmp2_);
	_tmp4_ = gweather_timezone_get_offset (_tmp3_);
	offset1 = _tmp4_;
	_tmp5_ = item2;
	_tmp6_ = clocks_world_item_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	_tmp7_ = _tmp6_;
	_tmp8_ = gweather_location_get_timezone (_tmp7_);
	_tmp9_ = gweather_timezone_get_offset (_tmp8_);
	offset2 = _tmp9_;
	_tmp10_ = offset1;
	_tmp11_ = offset2;
	if (_tmp10_ < _tmp11_) {
		result = -1;
		return result;
	}
	_tmp12_ = offset1;
	_tmp13_ = offset2;
	if (_tmp12_ > _tmp13_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


static gint ___lambda22__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda22_ ((ClocksWorldFace*) self, a, b);
	return result;
}


static void __lambda23_ (ClocksWorldFace* self) {
	clocks_world_face_reset_view (self);
}


static void ___lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda23_ ((ClocksWorldFace*) self);
}


static GtkWidget* __lambda24_ (ClocksWorldFace* self, ClocksContentItem* item) {
	GtkWidget* result = NULL;
	ClocksContentItem* _tmp0_;
	ClocksWorldTile* _tmp1_;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = clocks_world_tile_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
	g_object_ref_sink (_tmp1_);
	result = (GtkWidget*) _tmp1_;
	return result;
}


static GtkWidget* ___lambda24__clocks_content_view_content_view_create_widget_func (ClocksContentItem* item, gpointer self) {
	GtkWidget* result;
	result = __lambda24_ ((ClocksWorldFace*) self, item);
	return result;
}


static void __lambda25_ (ClocksWorldFace* self, guint position, guint removed, guint added) {
	clocks_world_face_save (self);
	clocks_world_face_reset_view (self);
}


static void ___lambda25__g_list_model_items_changed (GListModel* _sender, guint position, guint removed, guint added, gpointer self) {
	__lambda25_ ((ClocksWorldFace*) self, position, removed, added);
}


static void __lambda27_ (ClocksWorldFace* self, ClocksContentItem* l) {
	ClocksContentItem* _tmp0_;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem), clocks_world_item_signals[CLOCKS_WORLD_ITEM_TICK_SIGNAL], 0);
}


static void ___lambda27__clocks_content_store_foreach_func (ClocksContentItem* item, gpointer self) {
	__lambda27_ ((ClocksWorldFace*) self, item);
}


static void __lambda26_ (ClocksWorldFace* self) {
	ClocksContentStore* _tmp0_;
	ClocksContentView* _tmp1_;
	_tmp0_ = self->priv->locations;
	clocks_content_store_foreach (_tmp0_, ___lambda27__clocks_content_store_foreach_func, self);
	_tmp1_ = self->priv->content_view;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
	clocks_world_face_update_standalone (self);
}


static void ___lambda26__clocks_utils_wall_clock_tick (ClocksUtilsWallClock* _sender, gpointer self) {
	__lambda26_ ((ClocksWorldFace*) self);
}


ClocksWorldFace* clocks_world_face_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksWorldFace * self = NULL;
	ClocksHeaderBar* _tmp0_;
	ClocksContentStore* _tmp1_;
	GSettings* _tmp2_;
	ClocksContentStore* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	ClocksHeaderBar* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkImage* back_button_image = NULL;
	GtkImage* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	ClocksHeaderBar* _tmp16_;
	GtkButton* _tmp17_;
	ClocksContentView* _tmp18_;
	ClocksContentStore* _tmp19_;
	ClocksContentView* _tmp20_;
	ClocksHeaderBar* _tmp21_;
	ClocksContentStore* _tmp22_;
	ClocksUtilsWallClock* _tmp23_;
	ClocksUtilsWallClock* _tmp24_;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_tmp0_ = header_bar;
	self = (ClocksWorldFace*) g_object_new (object_type, "label", _ ("World"), "header-bar", _tmp0_, "panel-id", CLOCKS_PANEL_ID_WORLD, "transition-type", GTK_STACK_TRANSITION_TYPE_CROSSFADE, NULL);
	_tmp1_ = clocks_content_store_new ();
	_g_object_unref0 (self->priv->locations);
	self->priv->locations = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = self->priv->locations;
	clocks_content_store_set_sorting (_tmp3_, ___lambda22__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (C_ ("World clock", "New"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->new_button);
	self->priv->new_button = _tmp4_;
	_tmp5_ = self->priv->new_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->new_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->new_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp7_, "win.new");
	_tmp8_ = header_bar;
	_tmp9_ = self->priv->new_button;
	gtk_header_bar_pack_start ((GtkHeaderBar*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->back_button);
	self->priv->back_button = _tmp10_;
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("go-previous-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp11_);
	back_button_image = _tmp11_;
	_tmp12_ = self->priv->back_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	_tmp13_ = self->priv->back_button;
	gtk_button_set_image (_tmp13_, (GtkWidget*) back_button_image);
	_tmp14_ = self->priv->back_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->priv->back_button;
	g_signal_connect_object (_tmp15_, "clicked", (GCallback) ___lambda23__gtk_button_clicked, self, 0);
	_tmp16_ = header_bar;
	_tmp17_ = self->priv->back_button;
	gtk_header_bar_pack_start ((GtkHeaderBar*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->content_view;
	_tmp19_ = self->priv->locations;
	clocks_content_view_bind_model (_tmp18_, _tmp19_, ___lambda24__clocks_content_view_content_view_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp20_ = self->priv->content_view;
	_tmp21_ = header_bar;
	clocks_content_view_set_header_bar (_tmp20_, _tmp21_);
	clocks_world_face_load (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp22_ = self->priv->locations;
	g_signal_connect_object ((GListModel*) _tmp22_, "items-changed", (GCallback) ___lambda25__g_list_model_items_changed, self, 0);
	clocks_world_face_reset_view (self);
	_tmp23_ = clocks_utils_wall_clock_get_default ();
	_tmp24_ = _tmp23_;
	g_signal_connect_object (_tmp24_, "tick", (GCallback) ___lambda26__clocks_utils_wall_clock_tick, self, 0);
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (back_button_image);
	return self;
}


ClocksWorldFace* clocks_world_face_new (ClocksHeaderBar* header_bar) {
	return clocks_world_face_construct (CLOCKS_WORLD_TYPE_FACE, header_bar);
}


static void clocks_world_face_item_activated (ClocksWorldFace* self, ClocksContentItem* item) {
	ClocksContentItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	clocks_world_face_show_standalone (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem));
}


static void _clocks_world_face_item_activated_clocks_content_view_item_activated (ClocksContentView* _sender, ClocksContentItem* item, gpointer self) {
	clocks_world_face_item_activated ((ClocksWorldFace*) self, item);
}


static void clocks_world_face_visible_child_changed (ClocksWorldFace* self) {
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->empty_view;
	if (_tmp2_ == _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		ClocksContentView* _tmp6_;
		_tmp4_ = gtk_stack_get_visible_child ((GtkStack*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->content_view;
		_tmp0_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget);
	}
	if (_tmp0_) {
		ClocksHeaderBar* _tmp7_;
		ClocksHeaderBar* _tmp8_;
		_tmp7_ = clocks_clock_get_header_bar ((ClocksClock*) self);
		_tmp8_ = _tmp7_;
		clocks_header_bar_set_mode (_tmp8_, CLOCKS_HEADER_BAR_MODE_NORMAL);
	} else {
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		_tmp9_ = gtk_stack_get_visible_child ((GtkStack*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->standalone;
		if (_tmp10_ == _tmp11_) {
			ClocksHeaderBar* _tmp12_;
			ClocksHeaderBar* _tmp13_;
			_tmp12_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp13_ = _tmp12_;
			clocks_header_bar_set_mode (_tmp13_, CLOCKS_HEADER_BAR_MODE_STANDALONE);
		}
	}
}


static void _clocks_world_face_visible_child_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	clocks_world_face_visible_child_changed ((ClocksWorldFace*) self);
}


static void clocks_world_face_update_standalone (ClocksWorldFace* self) {
	ClocksWorldItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->standalone_location;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		ClocksWorldItem* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GtkLabel* _tmp6_;
		ClocksWorldItem* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GtkLabel* _tmp10_;
		ClocksWorldItem* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkLabel* _tmp15_;
		ClocksWorldItem* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp1_ = self->priv->standalone_time_label;
		_tmp2_ = self->priv->standalone_location;
		_tmp3_ = clocks_world_item_get_time_label (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = self->priv->standalone_day_label;
		_tmp7_ = self->priv->standalone_location;
		_tmp8_ = clocks_world_item_get_day_label (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp6_, _tmp9_);
		_tmp10_ = self->priv->standalone_sunrise_label;
		_tmp11_ = self->priv->standalone_location;
		_tmp12_ = clocks_world_item_get_sunrise_label (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		gtk_label_set_label (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = self->priv->standalone_sunset_label;
		_tmp16_ = self->priv->standalone_location;
		_tmp17_ = clocks_world_item_get_sunset_label (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		gtk_label_set_label (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
	}
}


static void clocks_world_face_show_standalone (ClocksWorldFace* self, ClocksWorldItem* location) {
	ClocksWorldItem* _tmp0_;
	ClocksWorldItem* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->standalone_location);
	self->priv->standalone_location = _tmp1_;
	clocks_world_face_update_standalone (self);
	_tmp2_ = self->priv->standalone;
	gtk_stack_set_visible_child ((GtkStack*) self, _tmp2_);
}


static ClocksContentItem* _clocks_world_item_deserialize_clocks_content_store_deserialize_item_func (GVariant* v, gpointer self) {
	ClocksContentItem* result;
	result = clocks_world_item_deserialize (v);
	return result;
}


static void clocks_world_face_load (ClocksWorldFace* self) {
	ClocksContentStore* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "world-clocks");
	_tmp3_ = _tmp2_;
	clocks_content_store_deserialize (_tmp0_, _tmp3_, _clocks_world_item_deserialize_clocks_content_store_deserialize_item_func, NULL);
	_g_variant_unref0 (_tmp3_);
}


static void clocks_world_face_save (ClocksWorldFace* self) {
	GSettings* _tmp0_;
	ClocksContentStore* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->locations;
	_tmp2_ = clocks_content_store_serialize (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_value (_tmp0_, "world-clocks", _tmp3_);
	_g_variant_unref0 (_tmp3_);
}


static void clocks_world_face_add_location_item (ClocksWorldFace* self, ClocksWorldItem* item) {
	ClocksContentStore* _tmp0_;
	ClocksWorldItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->locations;
	_tmp1_ = item;
	clocks_content_store_add (_tmp0_, (ClocksContentItem*) _tmp1_);
	clocks_world_face_save (self);
}


gboolean clocks_world_face_location_exists (ClocksWorldFace* self, GWeatherLocation* location) {
	gboolean result = FALSE;
	gboolean exists = FALSE;
	guint n = 0U;
	ClocksContentStore* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	exists = FALSE;
	_tmp0_ = self->priv->locations;
	_tmp1_ = g_list_model_get_n_items ((GListModel*) _tmp0_);
	n = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				guint _tmp5_;
				ClocksWorldItem* l = NULL;
				ClocksContentStore* _tmp6_;
				gint _tmp7_;
				GObject* _tmp8_;
				ClocksWorldItem* _tmp9_;
				ClocksWorldItem* _tmp10_;
				GWeatherLocation* _tmp11_;
				GWeatherLocation* _tmp12_;
				GWeatherLocation* _tmp13_;
				gboolean _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = n;
				if (!(((guint) _tmp4_) < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->locations;
				_tmp7_ = i;
				_tmp8_ = g_list_model_get_object ((GListModel*) _tmp6_, (guint) _tmp7_);
				_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, CLOCKS_WORLD_TYPE_ITEM) ? ((ClocksWorldItem*) _tmp8_) : NULL;
				if (_tmp9_ == NULL) {
					_g_object_unref0 (_tmp8_);
				}
				l = _tmp9_;
				_tmp10_ = l;
				_tmp11_ = clocks_world_item_get_location (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = location;
				_tmp14_ = gweather_location_equal (_tmp12_, _tmp13_);
				if (_tmp14_) {
					exists = TRUE;
					_g_object_unref0 (l);
					break;
				}
				_g_object_unref0 (l);
			}
		}
	}
	result = exists;
	return result;
}


void clocks_world_face_add_location (ClocksWorldFace* self, GWeatherLocation* location) {
	GWeatherLocation* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = clocks_world_face_location_exists (self, _tmp0_);
	if (!_tmp1_) {
		GWeatherLocation* _tmp2_;
		ClocksWorldItem* _tmp3_;
		ClocksWorldItem* _tmp4_;
		_tmp2_ = location;
		_tmp3_ = clocks_world_item_new (_tmp2_);
		_tmp4_ = _tmp3_;
		clocks_world_face_add_location_item (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
}


static void __lambda28_ (ClocksWorldFace* self, GtkDialog* dialog, gint response) {
	gint _tmp0_;
	GtkDialog* _tmp4_;
	g_return_if_fail (dialog != NULL);
	_tmp0_ = response;
	if (_tmp0_ == 1) {
		ClocksWorldItem* location = NULL;
		GtkDialog* _tmp1_;
		ClocksWorldItem* _tmp2_;
		ClocksWorldItem* _tmp3_;
		_tmp1_ = dialog;
		_tmp2_ = clocks_world_location_dialog_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_LOCATION_DIALOG, ClocksWorldLocationDialog));
		location = _tmp2_;
		_tmp3_ = location;
		clocks_world_face_add_location_item (self, _tmp3_);
		_g_object_unref0 (location);
	}
	_tmp4_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
}


static void ___lambda28__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda28_ ((ClocksWorldFace*) self, _sender, response_id);
}


static void clocks_world_face_real_activate_new (ClocksClock* base) {
	ClocksWorldFace * self;
	ClocksWorldLocationDialog* dialog = NULL;
	GtkWidget* _tmp0_;
	ClocksWorldLocationDialog* _tmp1_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = clocks_world_location_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), self);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) ___lambda28__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void clocks_world_face_real_activate_select_all (ClocksClock* base) {
	ClocksWorldFace * self;
	ClocksContentView* _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_select_all (_tmp0_);
}


static void clocks_world_face_real_activate_select_none (ClocksClock* base) {
	ClocksWorldFace * self;
	ClocksContentView* _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->content_view;
	clocks_content_view_unselect_all (_tmp0_);
}


static gboolean clocks_world_face_real_escape_pressed (ClocksClock* base) {
	ClocksWorldFace * self;
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	ClocksContentView* _tmp3_;
	gboolean _tmp4_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->standalone;
	if (_tmp1_ == _tmp2_) {
		clocks_world_face_reset_view (self);
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->content_view;
	_tmp4_ = clocks_content_view_escape_pressed (_tmp3_);
	result = _tmp4_;
	return result;
}


static void clocks_world_face_real_back (ClocksClock* base) {
	ClocksWorldFace * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->standalone;
	if (_tmp1_ == _tmp2_) {
		clocks_world_face_reset_view (self);
	}
}


void clocks_world_face_reset_view (ClocksWorldFace* self) {
	GtkWidget* _tmp0_ = NULL;
	ClocksContentStore* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->standalone_location);
	self->priv->standalone_location = NULL;
	_tmp1_ = self->priv->locations;
	_tmp2_ = g_list_model_get_n_items ((GListModel*) _tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		GtkWidget* _tmp3_;
		_tmp3_ = self->priv->empty_view;
		_tmp0_ = _tmp3_;
	} else {
		ClocksContentView* _tmp4_;
		_tmp4_ = self->priv->content_view;
		_tmp0_ = (GtkWidget*) _tmp4_;
	}
	gtk_stack_set_visible_child ((GtkStack*) self, _tmp0_);
	g_signal_emit_by_name ((ClocksClock*) self, "request-header-bar-update");
}


static void clocks_world_face_real_update_header_bar (ClocksClock* base) {
	ClocksWorldFace * self;
	ClocksHeaderBar* _tmp0_;
	ClocksHeaderBar* _tmp1_;
	ClocksHeaderBarMode _tmp2_;
	ClocksHeaderBarMode _tmp3_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = clocks_clock_get_header_bar ((ClocksClock*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = clocks_header_bar_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case CLOCKS_HEADER_BAR_MODE_NORMAL:
		{
			ClocksHeaderBar* _tmp4_;
			ClocksHeaderBar* _tmp5_;
			ClocksHeaderBar* _tmp6_;
			ClocksHeaderBar* _tmp7_;
			GtkButton* _tmp8_;
			ClocksContentView* _tmp9_;
			_tmp4_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp5_ = _tmp4_;
			gtk_header_bar_set_title ((GtkHeaderBar*) _tmp5_, _ ("Clocks"));
			_tmp6_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp7_ = _tmp6_;
			gtk_header_bar_set_subtitle ((GtkHeaderBar*) _tmp7_, NULL);
			_tmp8_ = self->priv->new_button;
			gtk_widget_show ((GtkWidget*) _tmp8_);
			_tmp9_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp9_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_SELECTION:
		{
			ClocksContentView* _tmp10_;
			_tmp10_ = self->priv->content_view;
			clocks_content_view_update_header_bar (_tmp10_);
			break;
		}
		case CLOCKS_HEADER_BAR_MODE_STANDALONE:
		{
			ClocksWorldItem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gboolean _tmp15_;
			ClocksHeaderBar* _tmp34_;
			ClocksHeaderBar* _tmp35_;
			ClocksWorldItem* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			GtkButton* _tmp40_;
			_tmp11_ = self->priv->standalone_location;
			_tmp12_ = clocks_world_item_get_state_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_ != NULL;
			_g_free0 (_tmp14_);
			if (_tmp15_) {
				ClocksHeaderBar* _tmp16_;
				ClocksHeaderBar* _tmp17_;
				ClocksWorldItem* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				ClocksWorldItem* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp16_ = clocks_clock_get_header_bar ((ClocksClock*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = self->priv->standalone_location;
				_tmp19_ = clocks_world_item_get_city_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = self->priv->standalone_location;
				_tmp23_ = clocks_world_item_get_state_name (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf ("%s, %s", _tmp21_, _tmp25_);
				_tmp27_ = _tmp26_;
				gtk_header_bar_set_title ((GtkHeaderBar*) _tmp17_, _tmp27_);
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp21_);
			} else {
				ClocksHeaderBar* _tmp28_;
				ClocksHeaderBar* _tmp29_;
				ClocksWorldItem* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp28_ = clocks_clock_get_header_bar ((ClocksClock*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = self->priv->standalone_location;
				_tmp31_ = clocks_world_item_get_city_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_;
				gtk_header_bar_set_title ((GtkHeaderBar*) _tmp29_, _tmp33_);
				_g_free0 (_tmp33_);
			}
			_tmp34_ = clocks_clock_get_header_bar ((ClocksClock*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = self->priv->standalone_location;
			_tmp37_ = clocks_world_item_get_country_name (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			gtk_header_bar_set_subtitle ((GtkHeaderBar*) _tmp35_, _tmp39_);
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->back_button;
			gtk_widget_show ((GtkWidget*) _tmp40_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static const gchar* clocks_world_face_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksWorldFace* self;
	const gchar* _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_world_face_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksWorldFace* self;
	self = (ClocksWorldFace*) base;
	if (g_strcmp0 (value, clocks_world_face_real_get_label (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_face_properties[CLOCKS_WORLD_FACE_LABEL_PROPERTY]);
	}
}


static ClocksHeaderBar* clocks_world_face_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksWorldFace* self;
	ClocksHeaderBar* _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_world_face_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksWorldFace* self;
	self = (ClocksWorldFace*) base;
	if (clocks_world_face_real_get_header_bar (base) != value) {
		ClocksHeaderBar* _tmp0_;
		ClocksHeaderBar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_header_bar);
		self->priv->_header_bar = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_face_properties[CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY]);
	}
}


static ClocksPanelId clocks_world_face_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksWorldFace* self;
	ClocksPanelId _tmp0_;
	self = (ClocksWorldFace*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_world_face_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksWorldFace* self;
	self = (ClocksWorldFace*) base;
	if (clocks_world_face_real_get_panel_id (base) != value) {
		ClocksPanelId _tmp0_;
		_tmp0_ = value;
		self->priv->_panel_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_world_face_properties[CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY]);
	}
}


static void clocks_world_face_class_init (ClocksWorldFaceClass * klass) {
	gint ClocksWorldFace_private_offset;
	clocks_world_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWorldFacePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_world_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_world_face_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_world_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_LABEL_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY] = g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY, clocks_world_face_properties[CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY] = g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	ClocksWorldFace_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/world.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_view", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, empty_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_view", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, content_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standalone", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, standalone));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standalone_time_label", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, standalone_time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standalone_day_label", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, standalone_day_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standalone_sunrise_label", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, standalone_sunrise_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standalone_sunset_label", FALSE, ClocksWorldFace_private_offset + G_STRUCT_OFFSET (ClocksWorldFacePrivate, standalone_sunset_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "item_activated", G_CALLBACK(_clocks_world_face_item_activated_clocks_content_view_item_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "visible_child_changed", G_CALLBACK(_clocks_world_face_visible_child_changed_g_object_notify));
}


static void clocks_world_face_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_world_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_new = (void (*) (ClocksClock *)) clocks_world_face_real_activate_new;
	iface->activate_select_all = (void (*) (ClocksClock *)) clocks_world_face_real_activate_select_all;
	iface->activate_select_none = (void (*) (ClocksClock *)) clocks_world_face_real_activate_select_none;
	iface->escape_pressed = (gboolean (*) (ClocksClock *)) clocks_world_face_real_escape_pressed;
	iface->back = (void (*) (ClocksClock *)) clocks_world_face_real_back;
	iface->update_header_bar = (void (*) (ClocksClock *)) clocks_world_face_real_update_header_bar;
	iface->get_label = clocks_world_face_real_get_label;
	iface->set_label = clocks_world_face_real_set_label;
	iface->get_header_bar = clocks_world_face_real_get_header_bar;
	iface->set_header_bar = clocks_world_face_real_set_header_bar;
	iface->get_panel_id = clocks_world_face_real_get_panel_id;
	iface->set_panel_id = clocks_world_face_real_set_panel_id;
}


static void clocks_world_face_instance_init (ClocksWorldFace * self) {
	self->priv = CLOCKS_WORLD_FACE_GET_PRIVATE (self);
	g_type_ensure (CLOCKS_TYPE_CONTENT_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_world_face_finalize (GObject * obj) {
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->locations);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->new_button);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->standalone_location);
	_g_object_unref0 (self->priv->empty_view);
	_g_object_unref0 (self->priv->content_view);
	_g_object_unref0 (self->priv->standalone);
	_g_object_unref0 (self->priv->standalone_time_label);
	_g_object_unref0 (self->priv->standalone_day_label);
	_g_object_unref0 (self->priv->standalone_sunrise_label);
	_g_object_unref0 (self->priv->standalone_sunset_label);
	G_OBJECT_CLASS (clocks_world_face_parent_class)->finalize (obj);
}


GType clocks_world_face_get_type (void) {
	static volatile gsize clocks_world_face_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_world_face_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWorldFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_world_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWorldFace), 0, (GInstanceInitFunc) clocks_world_face_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_world_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_world_face_type_id;
		clocks_world_face_type_id = g_type_register_static (gtk_stack_get_type (), "ClocksWorldFace", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_world_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_world_face_type_id__volatile, clocks_world_face_type_id);
	}
	return clocks_world_face_type_id__volatile;
}


static void _vala_clocks_world_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	switch (property_id) {
		case CLOCKS_WORLD_FACE_LABEL_PROPERTY:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_world_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksWorldFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace);
	switch (property_id) {
		case CLOCKS_WORLD_FACE_LABEL_PROPERTY:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_WORLD_FACE_HEADER_BAR_PROPERTY:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_WORLD_FACE_PANEL_ID_PROPERTY:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



