/* gmpc-url-fetching-gui.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-url-fetching-gui.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include "gmpc-extras.h"
#include <stdlib.h>
#include <string.h>
#include <plugin.h>
#include <float.h>
#include <math.h>


#define GMPC_URL_FETCHING_GUI_TYPE_STATE (gmpc_url_fetching_gui_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	GMPC_URL_FETCHING_GUI_STATE_NORMAL,
	GMPC_URL_FETCHING_GUI_STATE_PROCESSING,
	GMPC_URL_FETCHING_GUI_STATE_ERROR,
	GMPC_URL_FETCHING_GUI_STATE_DONE
} GmpcUrlFetchingGuiState;

struct _GmpcUrlFetchingGuiPrivate {
	GtkBuilder* builder;
	GmpcUrlFetchingGuiParseUrl parse_callback;
	gpointer parse_callback_target;
	GDestroyNotify parse_callback_target_destroy_notify;
	GmpcUrlFetchingGuiValidateUrl validate_callback;
	gpointer validate_callback_target;
	GDestroyNotify validate_callback_target_destroy_notify;
	GDestroyNotify destroy_cb;
	GmpcUrlFetchingGuiState state_counter;
};


static gpointer gmpc_url_fetching_gui_parent_class = NULL;

#define use_transition_ufg TRUE
static GType gmpc_url_fetching_gui_state_get_type (void) G_GNUC_UNUSED;
#define GMPC_URL_FETCHING_GUI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_URL_FETCHING_TYPE_GUI, GmpcUrlFetchingGuiPrivate))
enum  {
	GMPC_URL_FETCHING_GUI_DUMMY_PROPERTY
};
static void gmpc_url_fetching_gui_add_url_dialog_response (GmpcUrlFetchingGui* self, gint response_id);
static void gmpc_url_fetching_gui_url_entry_changed (GmpcUrlFetchingGui* self, GtkEditable* editable);
static void _gmpc_url_fetching_gui_add_url_dialog_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _gmpc_url_fetching_gui_url_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void gmpc_url_fetching_gui_sensitive (GmpcUrlFetchingGui* self, gboolean state);
static void gmpc_url_fetching_gui_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GType gmpc_url_fetching_gui_state_get_type (void) {
	static volatile gsize gmpc_url_fetching_gui_state_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_url_fetching_gui_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GMPC_URL_FETCHING_GUI_STATE_NORMAL, "GMPC_URL_FETCHING_GUI_STATE_NORMAL", "normal"}, {GMPC_URL_FETCHING_GUI_STATE_PROCESSING, "GMPC_URL_FETCHING_GUI_STATE_PROCESSING", "processing"}, {GMPC_URL_FETCHING_GUI_STATE_ERROR, "GMPC_URL_FETCHING_GUI_STATE_ERROR", "error"}, {GMPC_URL_FETCHING_GUI_STATE_DONE, "GMPC_URL_FETCHING_GUI_STATE_DONE", "done"}, {0, NULL, NULL}};
		GType gmpc_url_fetching_gui_state_type_id;
		gmpc_url_fetching_gui_state_type_id = g_enum_register_static ("GmpcUrlFetchingGuiState", values);
		g_once_init_leave (&gmpc_url_fetching_gui_state_type_id__volatile, gmpc_url_fetching_gui_state_type_id);
	}
	return gmpc_url_fetching_gui_state_type_id__volatile;
}


static void gmpc_url_fetching_gui_add_url_dialog_response (GmpcUrlFetchingGui* self, gint response_id) {
	g_return_if_fail (self != NULL);
	if (response_id == 1) {
		GObject* _tmp0_ = NULL;
		GtkEntry* entry;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* url;
		_tmp0_ = gtk_builder_get_object (self->priv->builder, "url_entry");
		entry = GTK_ENTRY (_tmp0_);
		_tmp1_ = gtk_entry_get_text (entry);
		_tmp2_ = g_strdup (_tmp1_);
		url = _tmp2_;
		self->priv->parse_callback (self, url, self->priv->parse_callback_target);
		_g_free0 (url);
		return;
	} else {
		self->priv->parse_callback (self, NULL, self->priv->parse_callback_target);
	}
	self->priv->destroy_cb (self);
}


static void gmpc_url_fetching_gui_url_entry_changed (GmpcUrlFetchingGui* self, GtkEditable* editable) {
	GObject* _tmp0_ = NULL;
	GtkButton* _tmp1_;
	GtkButton* add_button;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* text;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "add_button");
	_tmp1_ = _g_object_ref0 (GTK_BUTTON (_tmp0_));
	add_button = _tmp1_;
	_tmp2_ = gtk_entry_get_text (GTK_ENTRY (editable));
	_tmp3_ = g_strdup (_tmp2_);
	text = _tmp3_;
	if (text != NULL) {
		_tmp5_ = self->priv->validate_callback != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->validate_callback (self, text, self->priv->validate_callback_target);
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gtk_widget_set_sensitive ((GtkWidget*) add_button, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) add_button, FALSE);
	}
	_g_free0 (text);
	_g_object_unref0 (add_button);
}


static void _gmpc_url_fetching_gui_add_url_dialog_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	gmpc_url_fetching_gui_add_url_dialog_response (self, response_id);
}


static void _gmpc_url_fetching_gui_url_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	gmpc_url_fetching_gui_url_entry_changed (self, _sender);
}


GmpcUrlFetchingGui* gmpc_url_fetching_gui_construct (GType object_type, GmpcUrlFetchingGuiParseUrl parse_callback, void* parse_callback_target, GmpcUrlFetchingGuiValidateUrl validate_callback, void* validate_callback_target, GDestroyNotify destroy_cb) {
	GmpcUrlFetchingGui * self = NULL;
	GmpcUrlFetchingGuiParseUrl _tmp0_;
	GmpcUrlFetchingGuiValidateUrl _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_;
	GtkDialog* dialog;
	GtkWindow* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkEntry* _tmp8_;
	GtkEntry* entry;
	GError * _inner_error_ = NULL;
	self = (GmpcUrlFetchingGui*) g_object_new (object_type, NULL);
	_tmp0_ = parse_callback;
	(self->priv->parse_callback_target_destroy_notify == NULL) ? NULL : (self->priv->parse_callback_target_destroy_notify (self->priv->parse_callback_target), NULL);
	self->priv->parse_callback = NULL;
	self->priv->parse_callback_target = NULL;
	self->priv->parse_callback_target_destroy_notify = NULL;
	self->priv->parse_callback = _tmp0_;
	self->priv->parse_callback_target = parse_callback_target;
	self->priv->parse_callback_target_destroy_notify = NULL;
	_tmp1_ = validate_callback;
	(self->priv->validate_callback_target_destroy_notify == NULL) ? NULL : (self->priv->validate_callback_target_destroy_notify (self->priv->validate_callback_target), NULL);
	self->priv->validate_callback = NULL;
	self->priv->validate_callback_target = NULL;
	self->priv->validate_callback_target_destroy_notify = NULL;
	self->priv->validate_callback = _tmp1_;
	self->priv->validate_callback_target = validate_callback_target;
	self->priv->validate_callback_target_destroy_notify = NULL;
	self->priv->destroy_cb = destroy_cb;
	_tmp2_ = gmpc_get_full_glade_path ("gmpc-add-url.ui");
	_tmp3_ = _tmp2_;
	gtk_builder_add_from_file (self->priv->builder, _tmp3_, &_inner_error_);
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		goto __catch28_g_error;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("gmpc-url-fetching-gui.vala:96: Failed to load GtkBuilder file: %s", e->message);
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = gtk_builder_get_object (self->priv->builder, "add_url_dialog");
	_tmp5_ = _g_object_ref0 (GTK_DIALOG (_tmp4_));
	dialog = _tmp5_;
	_tmp6_ = (GtkWindow *)playlist3_get_window ();
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp6_);
	gtk_widget_show ((GtkWidget*) dialog);
	_tmp7_ = gtk_builder_get_object (self->priv->builder, "url_entry");
	_tmp8_ = _g_object_ref0 (GTK_ENTRY (_tmp7_));
	entry = _tmp8_;
	g_signal_connect_object (dialog, "response", (GCallback) _gmpc_url_fetching_gui_add_url_dialog_response_gtk_dialog_response, self, 0);
	g_signal_connect_object ((GtkEditable*) entry, "changed", (GCallback) _gmpc_url_fetching_gui_url_entry_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (entry);
	_g_object_unref0 (dialog);
	return self;
}


GmpcUrlFetchingGui* gmpc_url_fetching_gui_new (GmpcUrlFetchingGuiParseUrl parse_callback, void* parse_callback_target, GmpcUrlFetchingGuiValidateUrl validate_callback, void* validate_callback_target, GDestroyNotify destroy_cb) {
	return gmpc_url_fetching_gui_construct (GMPC_URL_FETCHING_TYPE_GUI, parse_callback, parse_callback_target, validate_callback, validate_callback_target, destroy_cb);
}


static void gmpc_url_fetching_gui_sensitive (GmpcUrlFetchingGui* self, gboolean state) {
	GObject* _tmp0_ = NULL;
	GtkEntry* _tmp1_;
	GtkEntry* entry;
	GObject* _tmp2_ = NULL;
	GtkButton* _tmp3_;
	GtkButton* add_button;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* close_button;
	GObject* _tmp6_ = NULL;
	GtkProgressBar* _tmp7_;
	GtkProgressBar* progress;
	g_return_if_fail (self != NULL);
	if (self->priv->builder == NULL) {
		return;
	}
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "url_entry");
	_tmp1_ = _g_object_ref0 (GTK_ENTRY (_tmp0_));
	entry = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) entry, state);
	_tmp2_ = gtk_builder_get_object (self->priv->builder, "add_button");
	_tmp3_ = _g_object_ref0 (GTK_BUTTON (_tmp2_));
	add_button = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) add_button, state);
	_tmp4_ = gtk_builder_get_object (self->priv->builder, "close_button");
	_tmp5_ = _g_object_ref0 (GTK_BUTTON (_tmp4_));
	close_button = _tmp5_;
	gtk_widget_set_sensitive ((GtkWidget*) close_button, state);
	_tmp6_ = gtk_builder_get_object (self->priv->builder, "url_progress");
	_tmp7_ = _g_object_ref0 (GTK_PROGRESS_BAR (_tmp6_));
	progress = _tmp7_;
	if (!state) {
		gtk_widget_show ((GtkWidget*) progress);
	} else {
		gtk_widget_hide ((GtkWidget*) progress);
	}
	_g_object_unref0 (progress);
	_g_object_unref0 (close_button);
	_g_object_unref0 (add_button);
	_g_object_unref0 (entry);
}


void gmpc_url_fetching_gui_set_processing (GmpcUrlFetchingGui* self) {
	g_return_if_fail (self != NULL);
	self->priv->state_counter = GMPC_URL_FETCHING_GUI_STATE_PROCESSING;
	gmpc_url_fetching_gui_sensitive (self, FALSE);
}


void gmpc_url_fetching_gui_set_progress (GmpcUrlFetchingGui* self, gdouble progress) {
	GObject* _tmp0_ = NULL;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* progressw;
	g_return_if_fail (self != NULL);
	g_log ("GUFG", G_LOG_LEVEL_DEBUG, "gmpc-url-fetching-gui.vala:146: Set progress: %f", progress);
	if (self->priv->state_counter != GMPC_URL_FETCHING_GUI_STATE_PROCESSING) {
		return;
	}
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "url_progress");
	_tmp1_ = _g_object_ref0 (GTK_PROGRESS_BAR (_tmp0_));
	progressw = _tmp1_;
	if (progress < 0) {
		gtk_progress_bar_pulse (progressw);
	} else {
		gtk_progress_bar_set_fraction (progressw, progress);
	}
	_g_object_unref0 (progressw);
}


void gmpc_url_fetching_gui_set_completed (GmpcUrlFetchingGui* self) {
	g_return_if_fail (self != NULL);
	g_log ("GUFG", G_LOG_LEVEL_DEBUG, "gmpc-url-fetching-gui.vala:159: Completed");
	self->priv->state_counter = GMPC_URL_FETCHING_GUI_STATE_DONE;
	gmpc_url_fetching_gui_sensitive (self, TRUE);
	self->priv->destroy_cb (self);
}


void gmpc_url_fetching_gui_set_error (GmpcUrlFetchingGui* self, const gchar* error_message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	g_log ("GUFG", G_LOG_LEVEL_DEBUG, "gmpc-url-fetching-gui.vala:169: Error: %s", error_message);
	self->priv->state_counter = GMPC_URL_FETCHING_GUI_STATE_ERROR;
	gmpc_url_fetching_gui_sensitive (self, TRUE);
}


static void gmpc_url_fetching_gui_class_init (GmpcUrlFetchingGuiClass * klass) {
	gmpc_url_fetching_gui_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcUrlFetchingGuiPrivate));
	G_OBJECT_CLASS (klass)->finalize = gmpc_url_fetching_gui_finalize;
}


static void gmpc_url_fetching_gui_instance_init (GmpcUrlFetchingGui * self) {
	GtkBuilder* _tmp0_ = NULL;
	self->priv = GMPC_URL_FETCHING_GUI_GET_PRIVATE (self);
	_tmp0_ = gtk_builder_new ();
	self->priv->builder = _tmp0_;
	self->priv->parse_callback = NULL;
	self->priv->validate_callback = NULL;
	self->priv->state_counter = GMPC_URL_FETCHING_GUI_STATE_NORMAL;
}


static void gmpc_url_fetching_gui_finalize (GObject* obj) {
	GmpcUrlFetchingGui * self;
	self = GMPC_URL_FETCHING_GUI (obj);
	if (self->priv->builder != NULL) {
		GObject* _tmp0_ = NULL;
		GtkDialog* _tmp1_;
		GtkDialog* dialog;
		_tmp0_ = gtk_builder_get_object (self->priv->builder, "add_url_dialog");
		_tmp1_ = _g_object_ref0 (GTK_DIALOG (_tmp0_));
		dialog = _tmp1_;
		if (dialog != NULL) {
			gtk_object_destroy ((GtkObject*) dialog);
		}
		_g_object_unref0 (dialog);
	}
	_g_object_unref0 (self->priv->builder);
	(self->priv->parse_callback_target_destroy_notify == NULL) ? NULL : (self->priv->parse_callback_target_destroy_notify (self->priv->parse_callback_target), NULL);
	self->priv->parse_callback = NULL;
	self->priv->parse_callback_target = NULL;
	self->priv->parse_callback_target_destroy_notify = NULL;
	(self->priv->validate_callback_target_destroy_notify == NULL) ? NULL : (self->priv->validate_callback_target_destroy_notify (self->priv->validate_callback_target), NULL);
	self->priv->validate_callback = NULL;
	self->priv->validate_callback_target = NULL;
	self->priv->validate_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gmpc_url_fetching_gui_parent_class)->finalize (obj);
}


GType gmpc_url_fetching_gui_get_type (void) {
	static volatile gsize gmpc_url_fetching_gui_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_url_fetching_gui_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcUrlFetchingGuiClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_url_fetching_gui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcUrlFetchingGui), 0, (GInstanceInitFunc) gmpc_url_fetching_gui_instance_init, NULL };
		GType gmpc_url_fetching_gui_type_id;
		gmpc_url_fetching_gui_type_id = g_type_register_static (G_TYPE_OBJECT, "GmpcUrlFetchingGui", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_url_fetching_gui_type_id__volatile, gmpc_url_fetching_gui_type_id);
	}
	return gmpc_url_fetching_gui_type_id__volatile;
}



