GeoIP Update Change Log
=======================

3.1.1 (2018-09-10)
------------------

* This version now allows parsing of license keys longer than 12
  characters.

3.1.0 (2018-08-16)
------------------

* This version restores the ability to use the `AccountID` / `UserId`
  999999 along with an all-zero license key when downloading free
  databases. However, the use of this combination is not recommended
  and may break in future versions.
* When printing verbose output, only the first four character of the
  `LicenseKey` will now be displayed.

3.0.1 (2018-08-14)
------------------

* When there were no updates available, 3.0.0 incorrectly returned an
  exit code of 1 instead of 0. This release reverts to the pre-3.0.0
  behavior, returning an exit code of 0 in this case.

3.0.0 (2018-08-13)
------------------

* BREAKING CHANGE: When downloading the free databases without a
  MaxMind account, you must either not have `AccountID`, `UserId`,
  or `LicenseKey` set in your configuration file or they must be set
  to the zero values previously recommended in our documentation. Any
  other value will cause an authorization error.
* BREAKING CHANGE: The configuration options `Protocol`,
  `SkipPeerVerification`, and `SkipHostnameVerification` are no longer
  supported. If they are present in the configuration file, they will
  be ignored. HTTPS with peer and hostname verification will be used
  on all requests.
* BREAKING CHANGE: The configuration file must have the `AccountID`
  or the deprecated `UserId` when downloading a paid database.
  Previously, when downloading the GeoIP Legacy Country database, you
  were able to only provide the `LicenseKey`.
* IMPORTANT: `geoipupdate-pureperl.pl` has been removed and will no
  longer be distributed with `geoipupdate`. This Perl script had known
  issues and did not have feature parity with the C implementation. If
  you were using the Perl version, we recommend that you switch to the
  C version. If you are not able to do this, you may continue using the
  Perl version distributed with 2.5.0.
* This program no longer uses the following endpoints:
  `/app/update_getipaddr`, `/app/update`, and `/app/update_secure`.
  `/geoip/databases/{edition_id}/update` is now used instead.
* Fixed issue in `gu_strnlen()` dereferencing a pointer before checking
  that it was in array bounds. Issue found by fcntl.
* We now update the default GeoIP.conf during installation so that
  directory paths match build parameters. Previously this config always
  said the data directory was under /usr/local/share which was not always
  accurate.
* Improve the error checking and display the underlying reason for the
  error when possible. Reported by Jonathan Kosgei. GitHub #82.
* Document that the `LockFile` is not removed from the filesystem after
  a successful exit from the program. GitHub issue #79.
* Make default configuration directory agree with default installation
  directory.

2.5.0 (2017-10-30)
------------------

* Replace use of strnlen() due to lack of universal availability. First
  reported by Bill Cole. GitHub issue #71.
* Document the `LockFile` option in the `GeoIP.conf` man page. GitHub
  issue #64.
* Remove unused base64 library. PR by Mikhail Teterin. GitHub PR #68.
* Add the new configuration option `PreserveFileTimes`. If set,
  the downloaded files will get the same modification times as
  their original on the server. Default is `0` (unset).
  PR by Rainer Jung. GitHub PR #63.
* Use the correct types when calling `curl_easy_setopt()`. This fixes
  warnings generated by libcurl's `typecheck-gcc.h`. PR by Michael
  Kaufmann. GitHub PR #61.
* In `GeoIP.conf`, the `UserId` option was renamed to `AccountID` and the
  `ProductIds` option was renamed to `EditionIDs`. The old options will
  continue to work, but upgrading to the new names is recommended for
  forward compatibility.

2.4.0 (2017-05-25)
------------------

* `geoipupdate` now checks that the database directory is writable. If it
  is not, it reports the problem and aborts.
* `geoipupdate` now acquires a lock when starting up to ensure only one
  instance may run at a time. A new option, `LockFile`, exists to set the
  file to use as a lock. By default, `LockFile` is the file
  `.geoipupdate.lock` in the database directory.
* `geoipupdate` now prints out additional information from the server when
  a download request results in something other than HTTP status 2xx. This
  provides more information when the API does not respond with a database
  file. In conjunction with changes to the download service itself, errors
  such as lacking a subscription no longer show up with the message "not a
  valid gzip file".
* ${datarootdir}/GeoIP is now created on `make install`. Reported by Antonios
  Karagiannis. GitHub #29.
* Previously, a variable named `ERROR` was used. This caused issues building
  on Windows. Reported by Gisle Vanem. GitHub #36.

2.3.1 (2017-01-05)
------------------

* 2.3.0 was missing `GeoIP.conf.default`. This was added to the dist.
* The directory creation of `$(sysconfdir)` added in 2.3.0 incorrectly ran if
  the directory already existed rather than if it did not exist.

2.3.0 (2017-01-04)
------------------

* `geoipupdate` now uses TCP keep-alive when compiled with cURL 7.25 or
  greater.
* Previously, on an invalid gzip file, `geoipupdate` would output binary data
  to stderr. It now displays an appropriate error message.
* Install README, ChangeLog, GeoIP.conf.default etc into docdir. PR by
  Philip Prindeville. GitHub #33.
* `$(sysconfdir)` is now created if it doesn't exist. PR by Philip
  Prindeville. GitHub #33.
* The sample config file is now usable. PR by Philip Prindeville. GitHub #33.

2.2.2 (2016-01-21)
------------------

* `geoipupdate` now calls `fsync` on the database directory after a `rename`
  to make it durable in the event of a crash.

2.2.1 (2015-02-25)
------------------

* Bump version number to correct PPA release issue. No other changes to the
  source distribution.

2.2.0 (2015-02-25)
------------------

* `geoipupdate` now verifies the MD5 of the new database before deploying it.
  If the database MD5 does not match the expected MD5, `geoipupdate` will
  exit with an error.
* The copy of `base64.c` and `base64.h` was switched to a version under GPL 2+
  to prevent a license conflict.
* The `LICENSE` file was added to the distribution.
* Several issues in the documentation were fixed.

2.1.0 (2014-11-06)
------------------

* Previously `geoipupdate` did not check the status code of an HTTP response.
  It will now check for an unexpected status code and exit with a warning if
  such a status is received.
* The client now checks the return value of gz_close to ensure that the gzip
  stream was correctly decoded. GitHub PR #18.
* The client now checks that the file was correctly opened. Previous versions
  used an incorrect check.

2.0.2 (2014-07-22)
------------------

* The client now uses a single TCP connection when possible. Previously the
  public IP address of a host could change across requests, causing the
  authentication to fail. Reported by Aman Gupta. GitHub issue #12 and #13.
* `geoipupdate-pureperl.pl` was updated to work with GeoIP2.

2.0.1 (2014-05-02)
------------------

* Error handling was generally improved. `geoipupdate` will now return a 1
  whenever an update fails.
* Previously if one database failed to be updated, `geoipupdate` would not
  attempt to download the remaining databases. It now continues to the next
  database when a download fails.
* Support for Mac OS X 10.6, which is missing the `getline` function, was
  added.
* Unknown directives in the configuration file will now be logged.
* The debugging output was improved and made more readable.
* Several documentation errors and typos were fixed.

2.0.0 (2013-10-31)
------------------

* First stand-alone release.
