/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu Dec 10 07:04:41 EST 2020 */

#include "dft/codelet-dft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_notw_c.native -fma -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name n1fv_64 -include dft/simd/n1f.h */

/*
 * This function contains 456 FP additions, 258 FP multiplications,
 * (or, 198 additions, 0 multiplications, 258 fused multiply/add),
 * 108 stack variables, 15 constants, and 128 memory accesses
 */
#include "dft/simd/n1f.h"

static void n1fv_64(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(128, is), MAKE_VOLATILE_STRIDE(128, os)) {
	       V T7, T26, T47, T69, T5k, T6A, T2V, T3z, Tm, T27, T5n, T6a, T2Y, T3M, T4e;
	       V T6B, TC, T2a, T6e, T6E, T3l, T3A, T4o, T5p, TR, T29, T6h, T6D, T3i, T3B;
	       V T4x, T5q, T1N, T2x, T6t, T71, T6w, T72, T1W, T2y, T39, T3H, T57, T5N, T5e;
	       V T5O, T3c, T3I, T1g, T2u, T6m, T6Y, T6p, T6Z, T1p, T2v, T32, T3E, T4M, T5K;
	       V T4T, T5L, T35, T3F;
	       {
		    V T3, T43, T25, T44, T6, T5i, T22, T45;
		    {
			 V T1, T2, T23, T24;
			 T1 = LD(&(xi[0]), ivs, &(xi[0]));
			 T2 = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
			 T3 = VADD(T1, T2);
			 T43 = VSUB(T1, T2);
			 T23 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			 T24 = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
			 T25 = VADD(T23, T24);
			 T44 = VSUB(T23, T24);
		    }
		    {
			 V T4, T5, T20, T21;
			 T4 = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
			 T5 = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
			 T6 = VADD(T4, T5);
			 T5i = VSUB(T4, T5);
			 T20 = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
			 T21 = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
			 T22 = VADD(T20, T21);
			 T45 = VSUB(T20, T21);
		    }
		    T7 = VSUB(T3, T6);
		    T26 = VSUB(T22, T25);
		    {
			 V T46, T5j, T2T, T2U;
			 T46 = VADD(T44, T45);
			 T47 = VFMA(LDK(KP707106781), T46, T43);
			 T69 = VFNMS(LDK(KP707106781), T46, T43);
			 T5j = VSUB(T45, T44);
			 T5k = VFNMS(LDK(KP707106781), T5j, T5i);
			 T6A = VFMA(LDK(KP707106781), T5j, T5i);
			 T2T = VADD(T3, T6);
			 T2U = VADD(T25, T22);
			 T2V = VADD(T2T, T2U);
			 T3z = VSUB(T2T, T2U);
		    }
	       }
	       {
		    V Ta, T48, Tk, T4c, Td, T49, Th, T4b;
		    {
			 V T8, T9, Ti, Tj;
			 T8 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 T9 = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
			 Ta = VADD(T8, T9);
			 T48 = VSUB(T8, T9);
			 Ti = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
			 Tj = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
			 Tk = VADD(Ti, Tj);
			 T4c = VSUB(Tj, Ti);
		    }
		    {
			 V Tb, Tc, Tf, Tg;
			 Tb = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
			 Tc = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
			 Td = VADD(Tb, Tc);
			 T49 = VSUB(Tb, Tc);
			 Tf = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
			 Tg = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
			 Th = VADD(Tf, Tg);
			 T4b = VSUB(Tf, Tg);
		    }
		    {
			 V Te, Tl, T5l, T5m;
			 Te = VSUB(Ta, Td);
			 Tl = VSUB(Th, Tk);
			 Tm = VADD(Te, Tl);
			 T27 = VSUB(Tl, Te);
			 T5l = VFMA(LDK(KP414213562), T48, T49);
			 T5m = VFMA(LDK(KP414213562), T4b, T4c);
			 T5n = VSUB(T5l, T5m);
			 T6a = VADD(T5l, T5m);
		    }
		    {
			 V T2W, T2X, T4a, T4d;
			 T2W = VADD(Ta, Td);
			 T2X = VADD(Th, Tk);
			 T2Y = VADD(T2W, T2X);
			 T3M = VSUB(T2X, T2W);
			 T4a = VFNMS(LDK(KP414213562), T49, T48);
			 T4d = VFNMS(LDK(KP414213562), T4c, T4b);
			 T4e = VADD(T4a, T4d);
			 T6B = VSUB(T4d, T4a);
		    }
	       }
	       {
		    V Tq, T4g, Tt, T4l, Tx, T4m, TA, T4j;
		    {
			 V To, Tp, Tr, Ts;
			 To = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 Tp = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
			 Tq = VADD(To, Tp);
			 T4g = VSUB(To, Tp);
			 Tr = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
			 Ts = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
			 Tt = VADD(Tr, Ts);
			 T4l = VSUB(Tr, Ts);
			 {
			      V Tv, Tw, T4h, Ty, Tz, T4i;
			      Tv = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
			      Tw = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
			      T4h = VSUB(Tv, Tw);
			      Ty = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
			      Tz = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
			      T4i = VSUB(Ty, Tz);
			      Tx = VADD(Tv, Tw);
			      T4m = VSUB(T4h, T4i);
			      TA = VADD(Ty, Tz);
			      T4j = VADD(T4h, T4i);
			 }
		    }
		    {
			 V Tu, TB, T6c, T6d;
			 Tu = VSUB(Tq, Tt);
			 TB = VSUB(Tx, TA);
			 TC = VFNMS(LDK(KP414213562), TB, Tu);
			 T2a = VFMA(LDK(KP414213562), Tu, TB);
			 T6c = VFNMS(LDK(KP707106781), T4m, T4l);
			 T6d = VFNMS(LDK(KP707106781), T4j, T4g);
			 T6e = VFNMS(LDK(KP668178637), T6d, T6c);
			 T6E = VFMA(LDK(KP668178637), T6c, T6d);
		    }
		    {
			 V T3j, T3k, T4k, T4n;
			 T3j = VADD(Tq, Tt);
			 T3k = VADD(Tx, TA);
			 T3l = VADD(T3j, T3k);
			 T3A = VSUB(T3j, T3k);
			 T4k = VFMA(LDK(KP707106781), T4j, T4g);
			 T4n = VFMA(LDK(KP707106781), T4m, T4l);
			 T4o = VFNMS(LDK(KP198912367), T4n, T4k);
			 T5p = VFMA(LDK(KP198912367), T4k, T4n);
		    }
	       }
	       {
		    V TF, T4p, TI, T4u, TM, T4v, TP, T4s;
		    {
			 V TD, TE, TG, TH;
			 TD = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
			 TE = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
			 TF = VADD(TD, TE);
			 T4p = VSUB(TD, TE);
			 TG = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 TH = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
			 TI = VADD(TG, TH);
			 T4u = VSUB(TH, TG);
			 {
			      V TK, TL, T4r, TN, TO, T4q;
			      TK = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
			      TL = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
			      T4r = VSUB(TK, TL);
			      TN = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
			      TO = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
			      T4q = VSUB(TN, TO);
			      TM = VADD(TK, TL);
			      T4v = VSUB(T4r, T4q);
			      TP = VADD(TN, TO);
			      T4s = VADD(T4q, T4r);
			 }
		    }
		    {
			 V TJ, TQ, T6f, T6g;
			 TJ = VSUB(TF, TI);
			 TQ = VSUB(TM, TP);
			 TR = VFNMS(LDK(KP414213562), TQ, TJ);
			 T29 = VFMA(LDK(KP414213562), TJ, TQ);
			 T6f = VFNMS(LDK(KP707106781), T4v, T4u);
			 T6g = VFNMS(LDK(KP707106781), T4s, T4p);
			 T6h = VFNMS(LDK(KP668178637), T6g, T6f);
			 T6D = VFMA(LDK(KP668178637), T6f, T6g);
		    }
		    {
			 V T3g, T3h, T4t, T4w;
			 T3g = VADD(TF, TI);
			 T3h = VADD(TP, TM);
			 T3i = VADD(T3g, T3h);
			 T3B = VSUB(T3g, T3h);
			 T4t = VFMA(LDK(KP707106781), T4s, T4p);
			 T4w = VFMA(LDK(KP707106781), T4v, T4u);
			 T4x = VFNMS(LDK(KP198912367), T4w, T4t);
			 T5q = VFMA(LDK(KP198912367), T4t, T4w);
		    }
	       }
	       {
		    V T1t, T4V, T1w, T58, T1Q, T59, T1T, T4Y, T1A, T1D, T1E, T5b, T52, T1H, T1K;
		    V T1L, T5c, T55;
		    {
			 V T1r, T1s, T1u, T1v;
			 T1r = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
			 T1s = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
			 T1t = VADD(T1r, T1s);
			 T4V = VSUB(T1r, T1s);
			 T1u = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
			 T1v = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
			 T1w = VADD(T1u, T1v);
			 T58 = VSUB(T1v, T1u);
		    }
		    {
			 V T1O, T1P, T4X, T1R, T1S, T4W;
			 T1O = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
			 T1P = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
			 T4X = VSUB(T1O, T1P);
			 T1R = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			 T1S = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
			 T4W = VSUB(T1R, T1S);
			 T1Q = VADD(T1O, T1P);
			 T59 = VSUB(T4X, T4W);
			 T1T = VADD(T1R, T1S);
			 T4Y = VADD(T4W, T4X);
		    }
		    {
			 V T50, T51, T53, T54;
			 {
			      V T1y, T1z, T1B, T1C;
			      T1y = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
			      T1z = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
			      T1A = VADD(T1y, T1z);
			      T50 = VSUB(T1y, T1z);
			      T1B = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
			      T1C = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
			      T1D = VADD(T1B, T1C);
			      T51 = VSUB(T1C, T1B);
			 }
			 T1E = VSUB(T1A, T1D);
			 T5b = VFNMS(LDK(KP414213562), T50, T51);
			 T52 = VFMA(LDK(KP414213562), T51, T50);
			 {
			      V T1F, T1G, T1I, T1J;
			      T1F = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
			      T1G = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
			      T1H = VADD(T1F, T1G);
			      T53 = VSUB(T1F, T1G);
			      T1I = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			      T1J = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
			      T1K = VADD(T1I, T1J);
			      T54 = VSUB(T1J, T1I);
			 }
			 T1L = VSUB(T1H, T1K);
			 T5c = VFMA(LDK(KP414213562), T53, T54);
			 T55 = VFNMS(LDK(KP414213562), T54, T53);
		    }
		    {
			 V T1x, T1M, T6r, T6s;
			 T1x = VSUB(T1t, T1w);
			 T1M = VADD(T1E, T1L);
			 T1N = VFMA(LDK(KP707106781), T1M, T1x);
			 T2x = VFNMS(LDK(KP707106781), T1M, T1x);
			 T6r = VFNMS(LDK(KP707106781), T4Y, T4V);
			 T6s = VSUB(T5c, T5b);
			 T6t = VFNMS(LDK(KP923879532), T6s, T6r);
			 T71 = VFMA(LDK(KP923879532), T6s, T6r);
		    }
		    {
			 V T6u, T6v, T1U, T1V;
			 T6u = VFNMS(LDK(KP707106781), T59, T58);
			 T6v = VSUB(T55, T52);
			 T6w = VFMA(LDK(KP923879532), T6v, T6u);
			 T72 = VFNMS(LDK(KP923879532), T6v, T6u);
			 T1U = VSUB(T1Q, T1T);
			 T1V = VSUB(T1L, T1E);
			 T1W = VFMA(LDK(KP707106781), T1V, T1U);
			 T2y = VFNMS(LDK(KP707106781), T1V, T1U);
		    }
		    {
			 V T37, T38, T4Z, T56;
			 T37 = VADD(T1t, T1w);
			 T38 = VADD(T1T, T1Q);
			 T39 = VADD(T37, T38);
			 T3H = VSUB(T37, T38);
			 T4Z = VFMA(LDK(KP707106781), T4Y, T4V);
			 T56 = VADD(T52, T55);
			 T57 = VFMA(LDK(KP923879532), T56, T4Z);
			 T5N = VFNMS(LDK(KP923879532), T56, T4Z);
		    }
		    {
			 V T5a, T5d, T3a, T3b;
			 T5a = VFMA(LDK(KP707106781), T59, T58);
			 T5d = VADD(T5b, T5c);
			 T5e = VFMA(LDK(KP923879532), T5d, T5a);
			 T5O = VFNMS(LDK(KP923879532), T5d, T5a);
			 T3a = VADD(T1A, T1D);
			 T3b = VADD(T1H, T1K);
			 T3c = VADD(T3a, T3b);
			 T3I = VSUB(T3b, T3a);
		    }
	       }
	       {
		    V TW, T4A, TZ, T4N, T1j, T4O, T1m, T4D, T13, T16, T17, T4Q, T4H, T1a, T1d;
		    V T1e, T4R, T4K;
		    {
			 V TU, TV, TX, TY;
			 TU = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 TV = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
			 TW = VADD(TU, TV);
			 T4A = VSUB(TU, TV);
			 TX = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
			 TY = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
			 TZ = VADD(TX, TY);
			 T4N = VSUB(TX, TY);
		    }
		    {
			 V T1h, T1i, T4B, T1k, T1l, T4C;
			 T1h = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
			 T1i = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
			 T4B = VSUB(T1h, T1i);
			 T1k = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
			 T1l = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
			 T4C = VSUB(T1k, T1l);
			 T1j = VADD(T1h, T1i);
			 T4O = VSUB(T4B, T4C);
			 T1m = VADD(T1k, T1l);
			 T4D = VADD(T4B, T4C);
		    }
		    {
			 V T4F, T4G, T4I, T4J;
			 {
			      V T11, T12, T14, T15;
			      T11 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
			      T12 = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
			      T13 = VADD(T11, T12);
			      T4F = VSUB(T11, T12);
			      T14 = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
			      T15 = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
			      T16 = VADD(T14, T15);
			      T4G = VSUB(T14, T15);
			 }
			 T17 = VSUB(T13, T16);
			 T4Q = VFMA(LDK(KP414213562), T4F, T4G);
			 T4H = VFNMS(LDK(KP414213562), T4G, T4F);
			 {
			      V T18, T19, T1b, T1c;
			      T18 = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
			      T19 = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
			      T1a = VADD(T18, T19);
			      T4I = VSUB(T18, T19);
			      T1b = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			      T1c = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
			      T1d = VADD(T1b, T1c);
			      T4J = VSUB(T1b, T1c);
			 }
			 T1e = VSUB(T1a, T1d);
			 T4R = VFNMS(LDK(KP414213562), T4I, T4J);
			 T4K = VFMA(LDK(KP414213562), T4J, T4I);
		    }
		    {
			 V T10, T1f, T6k, T6l;
			 T10 = VSUB(TW, TZ);
			 T1f = VADD(T17, T1e);
			 T1g = VFMA(LDK(KP707106781), T1f, T10);
			 T2u = VFNMS(LDK(KP707106781), T1f, T10);
			 T6k = VFNMS(LDK(KP707106781), T4D, T4A);
			 T6l = VSUB(T4Q, T4R);
			 T6m = VFNMS(LDK(KP923879532), T6l, T6k);
			 T6Y = VFMA(LDK(KP923879532), T6l, T6k);
		    }
		    {
			 V T6n, T6o, T1n, T1o;
			 T6n = VFNMS(LDK(KP707106781), T4O, T4N);
			 T6o = VSUB(T4H, T4K);
			 T6p = VFMA(LDK(KP923879532), T6o, T6n);
			 T6Z = VFNMS(LDK(KP923879532), T6o, T6n);
			 T1n = VSUB(T1j, T1m);
			 T1o = VSUB(T17, T1e);
			 T1p = VFMA(LDK(KP707106781), T1o, T1n);
			 T2v = VFNMS(LDK(KP707106781), T1o, T1n);
		    }
		    {
			 V T30, T31, T4E, T4L;
			 T30 = VADD(TW, TZ);
			 T31 = VADD(T1j, T1m);
			 T32 = VADD(T30, T31);
			 T3E = VSUB(T30, T31);
			 T4E = VFMA(LDK(KP707106781), T4D, T4A);
			 T4L = VADD(T4H, T4K);
			 T4M = VFMA(LDK(KP923879532), T4L, T4E);
			 T5K = VFNMS(LDK(KP923879532), T4L, T4E);
		    }
		    {
			 V T4P, T4S, T33, T34;
			 T4P = VFMA(LDK(KP707106781), T4O, T4N);
			 T4S = VADD(T4Q, T4R);
			 T4T = VFMA(LDK(KP923879532), T4S, T4P);
			 T5L = VFNMS(LDK(KP923879532), T4S, T4P);
			 T33 = VADD(T13, T16);
			 T34 = VADD(T1a, T1d);
			 T35 = VADD(T33, T34);
			 T3F = VSUB(T33, T34);
		    }
	       }
	       {
		    V T3t, T3x, T3w, T3y;
		    {
			 V T3r, T3s, T3u, T3v;
			 T3r = VADD(T2V, T2Y);
			 T3s = VADD(T3l, T3i);
			 T3t = VADD(T3r, T3s);
			 T3x = VSUB(T3r, T3s);
			 T3u = VADD(T32, T35);
			 T3v = VADD(T39, T3c);
			 T3w = VADD(T3u, T3v);
			 T3y = VSUB(T3v, T3u);
		    }
		    ST(&(xo[WS(os, 32)]), VSUB(T3t, T3w), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 16)]), VFMAI(T3y, T3x), ovs, &(xo[0]));
		    ST(&(xo[0]), VADD(T3t, T3w), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 48)]), VFNMSI(T3y, T3x), ovs, &(xo[0]));
	       }
	       {
		    V T2Z, T3m, T3e, T3n, T36, T3d;
		    T2Z = VSUB(T2V, T2Y);
		    T3m = VSUB(T3i, T3l);
		    T36 = VSUB(T32, T35);
		    T3d = VSUB(T39, T3c);
		    T3e = VADD(T36, T3d);
		    T3n = VSUB(T3d, T36);
		    {
			 V T3f, T3o, T3p, T3q;
			 T3f = VFNMS(LDK(KP707106781), T3e, T2Z);
			 T3o = VFNMS(LDK(KP707106781), T3n, T3m);
			 ST(&(xo[WS(os, 24)]), VFNMSI(T3o, T3f), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 40)]), VFMAI(T3o, T3f), ovs, &(xo[0]));
			 T3p = VFMA(LDK(KP707106781), T3e, T2Z);
			 T3q = VFMA(LDK(KP707106781), T3n, T3m);
			 ST(&(xo[WS(os, 56)]), VFNMSI(T3q, T3p), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 8)]), VFMAI(T3q, T3p), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T3D, T3V, T3O, T3Y, T3K, T3Z, T3R, T3W, T3C, T3N;
		    T3C = VADD(T3A, T3B);
		    T3D = VFMA(LDK(KP707106781), T3C, T3z);
		    T3V = VFNMS(LDK(KP707106781), T3C, T3z);
		    T3N = VSUB(T3B, T3A);
		    T3O = VFMA(LDK(KP707106781), T3N, T3M);
		    T3Y = VFNMS(LDK(KP707106781), T3N, T3M);
		    {
			 V T3G, T3J, T3P, T3Q;
			 T3G = VFNMS(LDK(KP414213562), T3F, T3E);
			 T3J = VFNMS(LDK(KP414213562), T3I, T3H);
			 T3K = VADD(T3G, T3J);
			 T3Z = VSUB(T3J, T3G);
			 T3P = VFMA(LDK(KP414213562), T3H, T3I);
			 T3Q = VFMA(LDK(KP414213562), T3E, T3F);
			 T3R = VSUB(T3P, T3Q);
			 T3W = VADD(T3Q, T3P);
		    }
		    {
			 V T3L, T3S, T41, T42;
			 T3L = VFNMS(LDK(KP923879532), T3K, T3D);
			 T3S = VFNMS(LDK(KP923879532), T3R, T3O);
			 ST(&(xo[WS(os, 28)]), VFNMSI(T3S, T3L), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 36)]), VFMAI(T3S, T3L), ovs, &(xo[0]));
			 T41 = VFMA(LDK(KP923879532), T3W, T3V);
			 T42 = VFNMS(LDK(KP923879532), T3Z, T3Y);
			 ST(&(xo[WS(os, 12)]), VFNMSI(T42, T41), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 52)]), VFMAI(T42, T41), ovs, &(xo[0]));
		    }
		    {
			 V T3T, T3U, T3X, T40;
			 T3T = VFMA(LDK(KP923879532), T3K, T3D);
			 T3U = VFMA(LDK(KP923879532), T3R, T3O);
			 ST(&(xo[WS(os, 60)]), VFNMSI(T3U, T3T), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 4)]), VFMAI(T3U, T3T), ovs, &(xo[0]));
			 T3X = VFNMS(LDK(KP923879532), T3W, T3V);
			 T40 = VFMA(LDK(KP923879532), T3Z, T3Y);
			 ST(&(xo[WS(os, 20)]), VFMAI(T40, T3X), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 44)]), VFNMSI(T40, T3X), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T6X, T7f, T7b, T7g, T74, T7j, T78, T7i;
		    {
			 V T6V, T6W, T79, T7a;
			 T6V = VFMA(LDK(KP923879532), T6a, T69);
			 T6W = VADD(T6E, T6D);
			 T6X = VFMA(LDK(KP831469612), T6W, T6V);
			 T7f = VFNMS(LDK(KP831469612), T6W, T6V);
			 T79 = VFNMS(LDK(KP303346683), T6Y, T6Z);
			 T7a = VFNMS(LDK(KP303346683), T71, T72);
			 T7b = VSUB(T79, T7a);
			 T7g = VADD(T79, T7a);
		    }
		    {
			 V T70, T73, T76, T77;
			 T70 = VFMA(LDK(KP303346683), T6Z, T6Y);
			 T73 = VFMA(LDK(KP303346683), T72, T71);
			 T74 = VADD(T70, T73);
			 T7j = VSUB(T73, T70);
			 T76 = VFMA(LDK(KP923879532), T6B, T6A);
			 T77 = VSUB(T6e, T6h);
			 T78 = VFMA(LDK(KP831469612), T77, T76);
			 T7i = VFNMS(LDK(KP831469612), T77, T76);
		    }
		    {
			 V T75, T7c, T7l, T7m;
			 T75 = VFNMS(LDK(KP956940335), T74, T6X);
			 T7c = VFNMS(LDK(KP956940335), T7b, T78);
			 ST(&(xo[WS(os, 29)]), VFNMSI(T7c, T75), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 35)]), VFMAI(T7c, T75), ovs, &(xo[WS(os, 1)]));
			 T7l = VFNMS(LDK(KP956940335), T7g, T7f);
			 T7m = VFNMS(LDK(KP956940335), T7j, T7i);
			 ST(&(xo[WS(os, 13)]), VFNMSI(T7m, T7l), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 51)]), VFMAI(T7m, T7l), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T7d, T7e, T7h, T7k;
			 T7d = VFMA(LDK(KP956940335), T74, T6X);
			 T7e = VFMA(LDK(KP956940335), T7b, T78);
			 ST(&(xo[WS(os, 61)]), VFNMSI(T7e, T7d), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 3)]), VFMAI(T7e, T7d), ovs, &(xo[WS(os, 1)]));
			 T7h = VFMA(LDK(KP956940335), T7g, T7f);
			 T7k = VFMA(LDK(KP956940335), T7j, T7i);
			 ST(&(xo[WS(os, 19)]), VFMAI(T7k, T7h), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 45)]), VFNMSI(T7k, T7h), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V TT, T2j, T2f, T2k, T1Y, T2n, T2c, T2m;
		    {
			 V Tn, TS, T2d, T2e;
			 Tn = VFMA(LDK(KP707106781), Tm, T7);
			 TS = VADD(TC, TR);
			 TT = VFMA(LDK(KP923879532), TS, Tn);
			 T2j = VFNMS(LDK(KP923879532), TS, Tn);
			 T2d = VFMA(LDK(KP198912367), T1N, T1W);
			 T2e = VFMA(LDK(KP198912367), T1g, T1p);
			 T2f = VSUB(T2d, T2e);
			 T2k = VADD(T2e, T2d);
		    }
		    {
			 V T1q, T1X, T28, T2b;
			 T1q = VFNMS(LDK(KP198912367), T1p, T1g);
			 T1X = VFNMS(LDK(KP198912367), T1W, T1N);
			 T1Y = VADD(T1q, T1X);
			 T2n = VSUB(T1X, T1q);
			 T28 = VFMA(LDK(KP707106781), T27, T26);
			 T2b = VSUB(T29, T2a);
			 T2c = VFMA(LDK(KP923879532), T2b, T28);
			 T2m = VFNMS(LDK(KP923879532), T2b, T28);
		    }
		    {
			 V T1Z, T2g, T2p, T2q;
			 T1Z = VFNMS(LDK(KP980785280), T1Y, TT);
			 T2g = VFNMS(LDK(KP980785280), T2f, T2c);
			 ST(&(xo[WS(os, 30)]), VFNMSI(T2g, T1Z), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 34)]), VFMAI(T2g, T1Z), ovs, &(xo[0]));
			 T2p = VFMA(LDK(KP980785280), T2k, T2j);
			 T2q = VFNMS(LDK(KP980785280), T2n, T2m);
			 ST(&(xo[WS(os, 14)]), VFNMSI(T2q, T2p), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 50)]), VFMAI(T2q, T2p), ovs, &(xo[0]));
		    }
		    {
			 V T2h, T2i, T2l, T2o;
			 T2h = VFMA(LDK(KP980785280), T1Y, TT);
			 T2i = VFMA(LDK(KP980785280), T2f, T2c);
			 ST(&(xo[WS(os, 62)]), VFNMSI(T2i, T2h), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 2)]), VFMAI(T2i, T2h), ovs, &(xo[0]));
			 T2l = VFNMS(LDK(KP980785280), T2k, T2j);
			 T2o = VFMA(LDK(KP980785280), T2n, T2m);
			 ST(&(xo[WS(os, 18)]), VFMAI(T2o, T2l), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 46)]), VFNMSI(T2o, T2l), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T4z, T5z, T5v, T5A, T5g, T5D, T5s, T5C;
		    {
			 V T4f, T4y, T5t, T5u;
			 T4f = VFMA(LDK(KP923879532), T4e, T47);
			 T4y = VADD(T4o, T4x);
			 T4z = VFMA(LDK(KP980785280), T4y, T4f);
			 T5z = VFNMS(LDK(KP980785280), T4y, T4f);
			 T5t = VFMA(LDK(KP098491403), T4M, T4T);
			 T5u = VFMA(LDK(KP098491403), T57, T5e);
			 T5v = VSUB(T5t, T5u);
			 T5A = VADD(T5t, T5u);
		    }
		    {
			 V T4U, T5f, T5o, T5r;
			 T4U = VFNMS(LDK(KP098491403), T4T, T4M);
			 T5f = VFNMS(LDK(KP098491403), T5e, T57);
			 T5g = VADD(T4U, T5f);
			 T5D = VSUB(T5f, T4U);
			 T5o = VFMA(LDK(KP923879532), T5n, T5k);
			 T5r = VSUB(T5p, T5q);
			 T5s = VFMA(LDK(KP980785280), T5r, T5o);
			 T5C = VFNMS(LDK(KP980785280), T5r, T5o);
		    }
		    {
			 V T5h, T5w, T5F, T5G;
			 T5h = VFNMS(LDK(KP995184726), T5g, T4z);
			 T5w = VFNMS(LDK(KP995184726), T5v, T5s);
			 ST(&(xo[WS(os, 33)]), VFNMSI(T5w, T5h), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 31)]), VFMAI(T5w, T5h), ovs, &(xo[WS(os, 1)]));
			 T5F = VFMA(LDK(KP995184726), T5A, T5z);
			 T5G = VFMA(LDK(KP995184726), T5D, T5C);
			 ST(&(xo[WS(os, 15)]), VFMAI(T5G, T5F), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 49)]), VFNMSI(T5G, T5F), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5x, T5y, T5B, T5E;
			 T5x = VFMA(LDK(KP995184726), T5g, T4z);
			 T5y = VFMA(LDK(KP995184726), T5v, T5s);
			 ST(&(xo[WS(os, 1)]), VFNMSI(T5y, T5x), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 63)]), VFMAI(T5y, T5x), ovs, &(xo[WS(os, 1)]));
			 T5B = VFNMS(LDK(KP995184726), T5A, T5z);
			 T5E = VFNMS(LDK(KP995184726), T5D, T5C);
			 ST(&(xo[WS(os, 17)]), VFNMSI(T5E, T5B), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 47)]), VFMAI(T5E, T5B), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T6j, T6N, T6J, T6O, T6y, T6R, T6G, T6Q;
		    {
			 V T6b, T6i, T6H, T6I;
			 T6b = VFNMS(LDK(KP923879532), T6a, T69);
			 T6i = VADD(T6e, T6h);
			 T6j = VFNMS(LDK(KP831469612), T6i, T6b);
			 T6N = VFMA(LDK(KP831469612), T6i, T6b);
			 T6H = VFMA(LDK(KP534511135), T6m, T6p);
			 T6I = VFMA(LDK(KP534511135), T6t, T6w);
			 T6J = VSUB(T6H, T6I);
			 T6O = VADD(T6H, T6I);
		    }
		    {
			 V T6q, T6x, T6C, T6F;
			 T6q = VFNMS(LDK(KP534511135), T6p, T6m);
			 T6x = VFNMS(LDK(KP534511135), T6w, T6t);
			 T6y = VADD(T6q, T6x);
			 T6R = VSUB(T6x, T6q);
			 T6C = VFNMS(LDK(KP923879532), T6B, T6A);
			 T6F = VSUB(T6D, T6E);
			 T6G = VFNMS(LDK(KP831469612), T6F, T6C);
			 T6Q = VFMA(LDK(KP831469612), T6F, T6C);
		    }
		    {
			 V T6z, T6K, T6T, T6U;
			 T6z = VFNMS(LDK(KP881921264), T6y, T6j);
			 T6K = VFNMS(LDK(KP881921264), T6J, T6G);
			 ST(&(xo[WS(os, 37)]), VFNMSI(T6K, T6z), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 27)]), VFMAI(T6K, T6z), ovs, &(xo[WS(os, 1)]));
			 T6T = VFMA(LDK(KP881921264), T6O, T6N);
			 T6U = VFMA(LDK(KP881921264), T6R, T6Q);
			 ST(&(xo[WS(os, 11)]), VFMAI(T6U, T6T), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 53)]), VFNMSI(T6U, T6T), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T6L, T6M, T6P, T6S;
			 T6L = VFMA(LDK(KP881921264), T6y, T6j);
			 T6M = VFMA(LDK(KP881921264), T6J, T6G);
			 ST(&(xo[WS(os, 5)]), VFNMSI(T6M, T6L), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 59)]), VFMAI(T6M, T6L), ovs, &(xo[WS(os, 1)]));
			 T6P = VFNMS(LDK(KP881921264), T6O, T6N);
			 T6S = VFNMS(LDK(KP881921264), T6R, T6Q);
			 ST(&(xo[WS(os, 21)]), VFNMSI(T6S, T6P), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 43)]), VFMAI(T6S, T6P), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T2t, T2L, T2H, T2M, T2A, T2P, T2E, T2O;
		    {
			 V T2r, T2s, T2F, T2G;
			 T2r = VFNMS(LDK(KP707106781), Tm, T7);
			 T2s = VADD(T2a, T29);
			 T2t = VFMA(LDK(KP923879532), T2s, T2r);
			 T2L = VFNMS(LDK(KP923879532), T2s, T2r);
			 T2F = VFNMS(LDK(KP668178637), T2x, T2y);
			 T2G = VFNMS(LDK(KP668178637), T2u, T2v);
			 T2H = VSUB(T2F, T2G);
			 T2M = VADD(T2G, T2F);
		    }
		    {
			 V T2w, T2z, T2C, T2D;
			 T2w = VFMA(LDK(KP668178637), T2v, T2u);
			 T2z = VFMA(LDK(KP668178637), T2y, T2x);
			 T2A = VADD(T2w, T2z);
			 T2P = VSUB(T2z, T2w);
			 T2C = VFNMS(LDK(KP707106781), T27, T26);
			 T2D = VSUB(TR, TC);
			 T2E = VFNMS(LDK(KP923879532), T2D, T2C);
			 T2O = VFMA(LDK(KP923879532), T2D, T2C);
		    }
		    {
			 V T2B, T2I, T2R, T2S;
			 T2B = VFNMS(LDK(KP831469612), T2A, T2t);
			 T2I = VFNMS(LDK(KP831469612), T2H, T2E);
			 ST(&(xo[WS(os, 38)]), VFNMSI(T2I, T2B), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 26)]), VFMAI(T2I, T2B), ovs, &(xo[0]));
			 T2R = VFNMS(LDK(KP831469612), T2M, T2L);
			 T2S = VFMA(LDK(KP831469612), T2P, T2O);
			 ST(&(xo[WS(os, 10)]), VFMAI(T2S, T2R), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 54)]), VFNMSI(T2S, T2R), ovs, &(xo[0]));
		    }
		    {
			 V T2J, T2K, T2N, T2Q;
			 T2J = VFMA(LDK(KP831469612), T2A, T2t);
			 T2K = VFMA(LDK(KP831469612), T2H, T2E);
			 ST(&(xo[WS(os, 6)]), VFNMSI(T2K, T2J), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 58)]), VFMAI(T2K, T2J), ovs, &(xo[0]));
			 T2N = VFMA(LDK(KP831469612), T2M, T2L);
			 T2Q = VFNMS(LDK(KP831469612), T2P, T2O);
			 ST(&(xo[WS(os, 22)]), VFNMSI(T2Q, T2N), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 42)]), VFMAI(T2Q, T2N), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T5J, T61, T5X, T62, T5Q, T65, T5U, T64;
		    {
			 V T5H, T5I, T5V, T5W;
			 T5H = VFNMS(LDK(KP923879532), T4e, T47);
			 T5I = VADD(T5p, T5q);
			 T5J = VFMA(LDK(KP980785280), T5I, T5H);
			 T61 = VFNMS(LDK(KP980785280), T5I, T5H);
			 T5V = VFNMS(LDK(KP820678790), T5K, T5L);
			 T5W = VFNMS(LDK(KP820678790), T5N, T5O);
			 T5X = VSUB(T5V, T5W);
			 T62 = VADD(T5V, T5W);
		    }
		    {
			 V T5M, T5P, T5S, T5T;
			 T5M = VFMA(LDK(KP820678790), T5L, T5K);
			 T5P = VFMA(LDK(KP820678790), T5O, T5N);
			 T5Q = VADD(T5M, T5P);
			 T65 = VSUB(T5P, T5M);
			 T5S = VFNMS(LDK(KP923879532), T5n, T5k);
			 T5T = VSUB(T4x, T4o);
			 T5U = VFMA(LDK(KP980785280), T5T, T5S);
			 T64 = VFNMS(LDK(KP980785280), T5T, T5S);
		    }
		    {
			 V T5R, T5Y, T67, T68;
			 T5R = VFNMS(LDK(KP773010453), T5Q, T5J);
			 T5Y = VFNMS(LDK(KP773010453), T5X, T5U);
			 ST(&(xo[WS(os, 25)]), VFNMSI(T5Y, T5R), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 39)]), VFMAI(T5Y, T5R), ovs, &(xo[WS(os, 1)]));
			 T67 = VFNMS(LDK(KP773010453), T62, T61);
			 T68 = VFNMS(LDK(KP773010453), T65, T64);
			 ST(&(xo[WS(os, 9)]), VFNMSI(T68, T67), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 55)]), VFMAI(T68, T67), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T5Z, T60, T63, T66;
			 T5Z = VFMA(LDK(KP773010453), T5Q, T5J);
			 T60 = VFMA(LDK(KP773010453), T5X, T5U);
			 ST(&(xo[WS(os, 57)]), VFNMSI(T60, T5Z), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 7)]), VFMAI(T60, T5Z), ovs, &(xo[WS(os, 1)]));
			 T63 = VFMA(LDK(KP773010453), T62, T61);
			 T66 = VFMA(LDK(KP773010453), T65, T64);
			 ST(&(xo[WS(os, 23)]), VFMAI(T66, T63), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 41)]), VFNMSI(T66, T63), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 64, XSIMD_STRING("n1fv_64"), { 198, 0, 258, 0 }, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1fv_64) (planner *p) { X(kdft_register) (p, n1fv_64, &desc);
}

#else

/* Generated by: ../../../genfft/gen_notw_c.native -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name n1fv_64 -include dft/simd/n1f.h */

/*
 * This function contains 456 FP additions, 124 FP multiplications,
 * (or, 404 additions, 72 multiplications, 52 fused multiply/add),
 * 108 stack variables, 15 constants, and 128 memory accesses
 */
#include "dft/simd/n1f.h"

static void n1fv_64(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  const R *xi;
	  R *xo;
	  xi = ri;
	  xo = ro;
	  for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs), MAKE_VOLATILE_STRIDE(128, is), MAKE_VOLATILE_STRIDE(128, os)) {
	       V T4p, T5q, Tb, T39, T2n, T3A, T6f, T6T, Tq, T3B, T6i, T76, T2i, T3a, T4w;
	       V T5r, TI, T2p, T6C, T6V, T3h, T3E, T4L, T5u, TZ, T2q, T6F, T6U, T3e, T3D;
	       V T4E, T5t, T23, T2N, T6t, T71, T6w, T72, T2c, T2O, T3t, T41, T5f, T5R, T5k;
	       V T5S, T3w, T42, T1s, T2K, T6m, T6Y, T6p, T6Z, T1B, T2L, T3m, T3Y, T4Y, T5O;
	       V T53, T5P, T3p, T3Z;
	       {
		    V T3, T4n, T2m, T4o, T6, T5p, T9, T5o;
		    {
			 V T1, T2, T2k, T2l;
			 T1 = LD(&(xi[0]), ivs, &(xi[0]));
			 T2 = LD(&(xi[WS(is, 32)]), ivs, &(xi[0]));
			 T3 = VSUB(T1, T2);
			 T4n = VADD(T1, T2);
			 T2k = LD(&(xi[WS(is, 16)]), ivs, &(xi[0]));
			 T2l = LD(&(xi[WS(is, 48)]), ivs, &(xi[0]));
			 T2m = VSUB(T2k, T2l);
			 T4o = VADD(T2k, T2l);
		    }
		    {
			 V T4, T5, T7, T8;
			 T4 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			 T5 = LD(&(xi[WS(is, 40)]), ivs, &(xi[0]));
			 T6 = VSUB(T4, T5);
			 T5p = VADD(T4, T5);
			 T7 = LD(&(xi[WS(is, 56)]), ivs, &(xi[0]));
			 T8 = LD(&(xi[WS(is, 24)]), ivs, &(xi[0]));
			 T9 = VSUB(T7, T8);
			 T5o = VADD(T7, T8);
		    }
		    T4p = VSUB(T4n, T4o);
		    T5q = VSUB(T5o, T5p);
		    {
			 V Ta, T2j, T6d, T6e;
			 Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
			 Tb = VADD(T3, Ta);
			 T39 = VSUB(T3, Ta);
			 T2j = VMUL(LDK(KP707106781), VSUB(T9, T6));
			 T2n = VSUB(T2j, T2m);
			 T3A = VADD(T2m, T2j);
			 T6d = VADD(T4n, T4o);
			 T6e = VADD(T5p, T5o);
			 T6f = VADD(T6d, T6e);
			 T6T = VSUB(T6d, T6e);
		    }
	       }
	       {
		    V Te, T4q, To, T4u, Th, T4r, Tl, T4t;
		    {
			 V Tc, Td, Tm, Tn;
			 Tc = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 Td = LD(&(xi[WS(is, 36)]), ivs, &(xi[0]));
			 Te = VSUB(Tc, Td);
			 T4q = VADD(Tc, Td);
			 Tm = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
			 Tn = LD(&(xi[WS(is, 44)]), ivs, &(xi[0]));
			 To = VSUB(Tm, Tn);
			 T4u = VADD(Tm, Tn);
		    }
		    {
			 V Tf, Tg, Tj, Tk;
			 Tf = LD(&(xi[WS(is, 20)]), ivs, &(xi[0]));
			 Tg = LD(&(xi[WS(is, 52)]), ivs, &(xi[0]));
			 Th = VSUB(Tf, Tg);
			 T4r = VADD(Tf, Tg);
			 Tj = LD(&(xi[WS(is, 60)]), ivs, &(xi[0]));
			 Tk = LD(&(xi[WS(is, 28)]), ivs, &(xi[0]));
			 Tl = VSUB(Tj, Tk);
			 T4t = VADD(Tj, Tk);
		    }
		    {
			 V Ti, Tp, T6g, T6h;
			 Ti = VFNMS(LDK(KP382683432), Th, VMUL(LDK(KP923879532), Te));
			 Tp = VFMA(LDK(KP923879532), Tl, VMUL(LDK(KP382683432), To));
			 Tq = VADD(Ti, Tp);
			 T3B = VSUB(Tp, Ti);
			 T6g = VADD(T4q, T4r);
			 T6h = VADD(T4t, T4u);
			 T6i = VADD(T6g, T6h);
			 T76 = VSUB(T6h, T6g);
		    }
		    {
			 V T2g, T2h, T4s, T4v;
			 T2g = VFNMS(LDK(KP923879532), To, VMUL(LDK(KP382683432), Tl));
			 T2h = VFMA(LDK(KP382683432), Te, VMUL(LDK(KP923879532), Th));
			 T2i = VSUB(T2g, T2h);
			 T3a = VADD(T2h, T2g);
			 T4s = VSUB(T4q, T4r);
			 T4v = VSUB(T4t, T4u);
			 T4w = VMUL(LDK(KP707106781), VADD(T4s, T4v));
			 T5r = VMUL(LDK(KP707106781), VSUB(T4v, T4s));
		    }
	       }
	       {
		    V Tu, T4F, TG, T4G, TB, T4J, TD, T4I;
		    {
			 V Ts, Tt, TE, TF;
			 Ts = LD(&(xi[WS(is, 62)]), ivs, &(xi[0]));
			 Tt = LD(&(xi[WS(is, 30)]), ivs, &(xi[0]));
			 Tu = VSUB(Ts, Tt);
			 T4F = VADD(Ts, Tt);
			 TE = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 TF = LD(&(xi[WS(is, 46)]), ivs, &(xi[0]));
			 TG = VSUB(TE, TF);
			 T4G = VADD(TE, TF);
			 {
			      V Tv, Tw, Tx, Ty, Tz, TA;
			      Tv = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
			      Tw = LD(&(xi[WS(is, 38)]), ivs, &(xi[0]));
			      Tx = VSUB(Tv, Tw);
			      Ty = LD(&(xi[WS(is, 54)]), ivs, &(xi[0]));
			      Tz = LD(&(xi[WS(is, 22)]), ivs, &(xi[0]));
			      TA = VSUB(Ty, Tz);
			      TB = VMUL(LDK(KP707106781), VADD(Tx, TA));
			      T4J = VADD(Tv, Tw);
			      TD = VMUL(LDK(KP707106781), VSUB(TA, Tx));
			      T4I = VADD(Ty, Tz);
			 }
		    }
		    {
			 V TC, TH, T6A, T6B;
			 TC = VADD(Tu, TB);
			 TH = VSUB(TD, TG);
			 TI = VFMA(LDK(KP195090322), TC, VMUL(LDK(KP980785280), TH));
			 T2p = VFNMS(LDK(KP195090322), TH, VMUL(LDK(KP980785280), TC));
			 T6A = VADD(T4F, T4G);
			 T6B = VADD(T4J, T4I);
			 T6C = VADD(T6A, T6B);
			 T6V = VSUB(T6A, T6B);
		    }
		    {
			 V T3f, T3g, T4H, T4K;
			 T3f = VSUB(Tu, TB);
			 T3g = VADD(TG, TD);
			 T3h = VFNMS(LDK(KP555570233), T3g, VMUL(LDK(KP831469612), T3f));
			 T3E = VFMA(LDK(KP555570233), T3f, VMUL(LDK(KP831469612), T3g));
			 T4H = VSUB(T4F, T4G);
			 T4K = VSUB(T4I, T4J);
			 T4L = VFNMS(LDK(KP382683432), T4K, VMUL(LDK(KP923879532), T4H));
			 T5u = VFMA(LDK(KP382683432), T4H, VMUL(LDK(KP923879532), T4K));
		    }
	       }
	       {
		    V TS, T4z, TW, T4y, TP, T4C, TX, T4B;
		    {
			 V TQ, TR, TU, TV;
			 TQ = LD(&(xi[WS(is, 18)]), ivs, &(xi[0]));
			 TR = LD(&(xi[WS(is, 50)]), ivs, &(xi[0]));
			 TS = VSUB(TQ, TR);
			 T4z = VADD(TQ, TR);
			 TU = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 TV = LD(&(xi[WS(is, 34)]), ivs, &(xi[0]));
			 TW = VSUB(TU, TV);
			 T4y = VADD(TU, TV);
			 {
			      V TJ, TK, TL, TM, TN, TO;
			      TJ = LD(&(xi[WS(is, 58)]), ivs, &(xi[0]));
			      TK = LD(&(xi[WS(is, 26)]), ivs, &(xi[0]));
			      TL = VSUB(TJ, TK);
			      TM = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
			      TN = LD(&(xi[WS(is, 42)]), ivs, &(xi[0]));
			      TO = VSUB(TM, TN);
			      TP = VMUL(LDK(KP707106781), VSUB(TL, TO));
			      T4C = VADD(TM, TN);
			      TX = VMUL(LDK(KP707106781), VADD(TO, TL));
			      T4B = VADD(TJ, TK);
			 }
		    }
		    {
			 V TT, TY, T6D, T6E;
			 TT = VSUB(TP, TS);
			 TY = VADD(TW, TX);
			 TZ = VFNMS(LDK(KP195090322), TY, VMUL(LDK(KP980785280), TT));
			 T2q = VFMA(LDK(KP980785280), TY, VMUL(LDK(KP195090322), TT));
			 T6D = VADD(T4y, T4z);
			 T6E = VADD(T4C, T4B);
			 T6F = VADD(T6D, T6E);
			 T6U = VSUB(T6D, T6E);
		    }
		    {
			 V T3c, T3d, T4A, T4D;
			 T3c = VSUB(TW, TX);
			 T3d = VADD(TS, TP);
			 T3e = VFMA(LDK(KP831469612), T3c, VMUL(LDK(KP555570233), T3d));
			 T3D = VFNMS(LDK(KP555570233), T3c, VMUL(LDK(KP831469612), T3d));
			 T4A = VSUB(T4y, T4z);
			 T4D = VSUB(T4B, T4C);
			 T4E = VFMA(LDK(KP923879532), T4A, VMUL(LDK(KP382683432), T4D));
			 T5t = VFNMS(LDK(KP382683432), T4A, VMUL(LDK(KP923879532), T4D));
		    }
	       }
	       {
		    V T1F, T55, T2a, T56, T1M, T5h, T27, T5g, T58, T59, T1U, T5a, T25, T5b, T5c;
		    V T21, T5d, T24;
		    {
			 V T1D, T1E, T28, T29;
			 T1D = LD(&(xi[WS(is, 63)]), ivs, &(xi[WS(is, 1)]));
			 T1E = LD(&(xi[WS(is, 31)]), ivs, &(xi[WS(is, 1)]));
			 T1F = VSUB(T1D, T1E);
			 T55 = VADD(T1D, T1E);
			 T28 = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
			 T29 = LD(&(xi[WS(is, 47)]), ivs, &(xi[WS(is, 1)]));
			 T2a = VSUB(T28, T29);
			 T56 = VADD(T28, T29);
		    }
		    {
			 V T1G, T1H, T1I, T1J, T1K, T1L;
			 T1G = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			 T1H = LD(&(xi[WS(is, 39)]), ivs, &(xi[WS(is, 1)]));
			 T1I = VSUB(T1G, T1H);
			 T1J = LD(&(xi[WS(is, 55)]), ivs, &(xi[WS(is, 1)]));
			 T1K = LD(&(xi[WS(is, 23)]), ivs, &(xi[WS(is, 1)]));
			 T1L = VSUB(T1J, T1K);
			 T1M = VMUL(LDK(KP707106781), VADD(T1I, T1L));
			 T5h = VADD(T1G, T1H);
			 T27 = VMUL(LDK(KP707106781), VSUB(T1L, T1I));
			 T5g = VADD(T1J, T1K);
		    }
		    {
			 V T1Q, T1T, T1X, T20;
			 {
			      V T1O, T1P, T1R, T1S;
			      T1O = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
			      T1P = LD(&(xi[WS(is, 35)]), ivs, &(xi[WS(is, 1)]));
			      T1Q = VSUB(T1O, T1P);
			      T58 = VADD(T1O, T1P);
			      T1R = LD(&(xi[WS(is, 19)]), ivs, &(xi[WS(is, 1)]));
			      T1S = LD(&(xi[WS(is, 51)]), ivs, &(xi[WS(is, 1)]));
			      T1T = VSUB(T1R, T1S);
			      T59 = VADD(T1R, T1S);
			 }
			 T1U = VFNMS(LDK(KP382683432), T1T, VMUL(LDK(KP923879532), T1Q));
			 T5a = VSUB(T58, T59);
			 T25 = VFMA(LDK(KP382683432), T1Q, VMUL(LDK(KP923879532), T1T));
			 {
			      V T1V, T1W, T1Y, T1Z;
			      T1V = LD(&(xi[WS(is, 59)]), ivs, &(xi[WS(is, 1)]));
			      T1W = LD(&(xi[WS(is, 27)]), ivs, &(xi[WS(is, 1)]));
			      T1X = VSUB(T1V, T1W);
			      T5b = VADD(T1V, T1W);
			      T1Y = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			      T1Z = LD(&(xi[WS(is, 43)]), ivs, &(xi[WS(is, 1)]));
			      T20 = VSUB(T1Y, T1Z);
			      T5c = VADD(T1Y, T1Z);
			 }
			 T21 = VFMA(LDK(KP923879532), T1X, VMUL(LDK(KP382683432), T20));
			 T5d = VSUB(T5b, T5c);
			 T24 = VFNMS(LDK(KP923879532), T20, VMUL(LDK(KP382683432), T1X));
		    }
		    {
			 V T1N, T22, T6r, T6s;
			 T1N = VADD(T1F, T1M);
			 T22 = VADD(T1U, T21);
			 T23 = VSUB(T1N, T22);
			 T2N = VADD(T1N, T22);
			 T6r = VADD(T55, T56);
			 T6s = VADD(T5h, T5g);
			 T6t = VADD(T6r, T6s);
			 T71 = VSUB(T6r, T6s);
		    }
		    {
			 V T6u, T6v, T26, T2b;
			 T6u = VADD(T58, T59);
			 T6v = VADD(T5b, T5c);
			 T6w = VADD(T6u, T6v);
			 T72 = VSUB(T6v, T6u);
			 T26 = VSUB(T24, T25);
			 T2b = VSUB(T27, T2a);
			 T2c = VSUB(T26, T2b);
			 T2O = VADD(T2b, T26);
		    }
		    {
			 V T3r, T3s, T57, T5e;
			 T3r = VSUB(T1F, T1M);
			 T3s = VADD(T25, T24);
			 T3t = VADD(T3r, T3s);
			 T41 = VSUB(T3r, T3s);
			 T57 = VSUB(T55, T56);
			 T5e = VMUL(LDK(KP707106781), VADD(T5a, T5d));
			 T5f = VADD(T57, T5e);
			 T5R = VSUB(T57, T5e);
		    }
		    {
			 V T5i, T5j, T3u, T3v;
			 T5i = VSUB(T5g, T5h);
			 T5j = VMUL(LDK(KP707106781), VSUB(T5d, T5a));
			 T5k = VADD(T5i, T5j);
			 T5S = VSUB(T5j, T5i);
			 T3u = VADD(T2a, T27);
			 T3v = VSUB(T21, T1U);
			 T3w = VADD(T3u, T3v);
			 T42 = VSUB(T3v, T3u);
		    }
	       }
	       {
		    V T1q, T4P, T1v, T4O, T1n, T50, T1w, T4Z, T4U, T4V, T18, T4W, T1z, T4R, T4S;
		    V T1f, T4T, T1y;
		    {
			 V T1o, T1p, T1t, T1u;
			 T1o = LD(&(xi[WS(is, 17)]), ivs, &(xi[WS(is, 1)]));
			 T1p = LD(&(xi[WS(is, 49)]), ivs, &(xi[WS(is, 1)]));
			 T1q = VSUB(T1o, T1p);
			 T4P = VADD(T1o, T1p);
			 T1t = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 T1u = LD(&(xi[WS(is, 33)]), ivs, &(xi[WS(is, 1)]));
			 T1v = VSUB(T1t, T1u);
			 T4O = VADD(T1t, T1u);
		    }
		    {
			 V T1h, T1i, T1j, T1k, T1l, T1m;
			 T1h = LD(&(xi[WS(is, 57)]), ivs, &(xi[WS(is, 1)]));
			 T1i = LD(&(xi[WS(is, 25)]), ivs, &(xi[WS(is, 1)]));
			 T1j = VSUB(T1h, T1i);
			 T1k = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
			 T1l = LD(&(xi[WS(is, 41)]), ivs, &(xi[WS(is, 1)]));
			 T1m = VSUB(T1k, T1l);
			 T1n = VMUL(LDK(KP707106781), VSUB(T1j, T1m));
			 T50 = VADD(T1k, T1l);
			 T1w = VMUL(LDK(KP707106781), VADD(T1m, T1j));
			 T4Z = VADD(T1h, T1i);
		    }
		    {
			 V T14, T17, T1b, T1e;
			 {
			      V T12, T13, T15, T16;
			      T12 = LD(&(xi[WS(is, 61)]), ivs, &(xi[WS(is, 1)]));
			      T13 = LD(&(xi[WS(is, 29)]), ivs, &(xi[WS(is, 1)]));
			      T14 = VSUB(T12, T13);
			      T4U = VADD(T12, T13);
			      T15 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			      T16 = LD(&(xi[WS(is, 45)]), ivs, &(xi[WS(is, 1)]));
			      T17 = VSUB(T15, T16);
			      T4V = VADD(T15, T16);
			 }
			 T18 = VFNMS(LDK(KP923879532), T17, VMUL(LDK(KP382683432), T14));
			 T4W = VSUB(T4U, T4V);
			 T1z = VFMA(LDK(KP923879532), T14, VMUL(LDK(KP382683432), T17));
			 {
			      V T19, T1a, T1c, T1d;
			      T19 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
			      T1a = LD(&(xi[WS(is, 37)]), ivs, &(xi[WS(is, 1)]));
			      T1b = VSUB(T19, T1a);
			      T4R = VADD(T19, T1a);
			      T1c = LD(&(xi[WS(is, 21)]), ivs, &(xi[WS(is, 1)]));
			      T1d = LD(&(xi[WS(is, 53)]), ivs, &(xi[WS(is, 1)]));
			      T1e = VSUB(T1c, T1d);
			      T4S = VADD(T1c, T1d);
			 }
			 T1f = VFMA(LDK(KP382683432), T1b, VMUL(LDK(KP923879532), T1e));
			 T4T = VSUB(T4R, T4S);
			 T1y = VFNMS(LDK(KP382683432), T1e, VMUL(LDK(KP923879532), T1b));
		    }
		    {
			 V T1g, T1r, T6k, T6l;
			 T1g = VSUB(T18, T1f);
			 T1r = VSUB(T1n, T1q);
			 T1s = VSUB(T1g, T1r);
			 T2K = VADD(T1r, T1g);
			 T6k = VADD(T4O, T4P);
			 T6l = VADD(T50, T4Z);
			 T6m = VADD(T6k, T6l);
			 T6Y = VSUB(T6k, T6l);
		    }
		    {
			 V T6n, T6o, T1x, T1A;
			 T6n = VADD(T4R, T4S);
			 T6o = VADD(T4U, T4V);
			 T6p = VADD(T6n, T6o);
			 T6Z = VSUB(T6o, T6n);
			 T1x = VADD(T1v, T1w);
			 T1A = VADD(T1y, T1z);
			 T1B = VSUB(T1x, T1A);
			 T2L = VADD(T1x, T1A);
		    }
		    {
			 V T3k, T3l, T4Q, T4X;
			 T3k = VSUB(T1v, T1w);
			 T3l = VADD(T1f, T18);
			 T3m = VADD(T3k, T3l);
			 T3Y = VSUB(T3k, T3l);
			 T4Q = VSUB(T4O, T4P);
			 T4X = VMUL(LDK(KP707106781), VADD(T4T, T4W));
			 T4Y = VADD(T4Q, T4X);
			 T5O = VSUB(T4Q, T4X);
		    }
		    {
			 V T51, T52, T3n, T3o;
			 T51 = VSUB(T4Z, T50);
			 T52 = VMUL(LDK(KP707106781), VSUB(T4W, T4T));
			 T53 = VADD(T51, T52);
			 T5P = VSUB(T52, T51);
			 T3n = VADD(T1q, T1n);
			 T3o = VSUB(T1z, T1y);
			 T3p = VADD(T3n, T3o);
			 T3Z = VSUB(T3o, T3n);
		    }
	       }
	       {
		    V T6N, T6R, T6Q, T6S;
		    {
			 V T6L, T6M, T6O, T6P;
			 T6L = VADD(T6f, T6i);
			 T6M = VADD(T6F, T6C);
			 T6N = VADD(T6L, T6M);
			 T6R = VSUB(T6L, T6M);
			 T6O = VADD(T6m, T6p);
			 T6P = VADD(T6t, T6w);
			 T6Q = VADD(T6O, T6P);
			 T6S = VBYI(VSUB(T6P, T6O));
		    }
		    ST(&(xo[WS(os, 32)]), VSUB(T6N, T6Q), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 16)]), VADD(T6R, T6S), ovs, &(xo[0]));
		    ST(&(xo[0]), VADD(T6N, T6Q), ovs, &(xo[0]));
		    ST(&(xo[WS(os, 48)]), VSUB(T6R, T6S), ovs, &(xo[0]));
	       }
	       {
		    V T6j, T6G, T6y, T6H, T6q, T6x;
		    T6j = VSUB(T6f, T6i);
		    T6G = VSUB(T6C, T6F);
		    T6q = VSUB(T6m, T6p);
		    T6x = VSUB(T6t, T6w);
		    T6y = VMUL(LDK(KP707106781), VADD(T6q, T6x));
		    T6H = VMUL(LDK(KP707106781), VSUB(T6x, T6q));
		    {
			 V T6z, T6I, T6J, T6K;
			 T6z = VADD(T6j, T6y);
			 T6I = VBYI(VADD(T6G, T6H));
			 ST(&(xo[WS(os, 56)]), VSUB(T6z, T6I), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 8)]), VADD(T6z, T6I), ovs, &(xo[0]));
			 T6J = VSUB(T6j, T6y);
			 T6K = VBYI(VSUB(T6H, T6G));
			 ST(&(xo[WS(os, 40)]), VSUB(T6J, T6K), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 24)]), VADD(T6J, T6K), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T6X, T7i, T78, T7g, T74, T7f, T7b, T7j, T6W, T77;
		    T6W = VMUL(LDK(KP707106781), VADD(T6U, T6V));
		    T6X = VADD(T6T, T6W);
		    T7i = VSUB(T6T, T6W);
		    T77 = VMUL(LDK(KP707106781), VSUB(T6V, T6U));
		    T78 = VADD(T76, T77);
		    T7g = VSUB(T77, T76);
		    {
			 V T70, T73, T79, T7a;
			 T70 = VFMA(LDK(KP923879532), T6Y, VMUL(LDK(KP382683432), T6Z));
			 T73 = VFNMS(LDK(KP382683432), T72, VMUL(LDK(KP923879532), T71));
			 T74 = VADD(T70, T73);
			 T7f = VSUB(T73, T70);
			 T79 = VFNMS(LDK(KP382683432), T6Y, VMUL(LDK(KP923879532), T6Z));
			 T7a = VFMA(LDK(KP382683432), T71, VMUL(LDK(KP923879532), T72));
			 T7b = VADD(T79, T7a);
			 T7j = VSUB(T7a, T79);
		    }
		    {
			 V T75, T7c, T7l, T7m;
			 T75 = VADD(T6X, T74);
			 T7c = VBYI(VADD(T78, T7b));
			 ST(&(xo[WS(os, 60)]), VSUB(T75, T7c), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 4)]), VADD(T75, T7c), ovs, &(xo[0]));
			 T7l = VBYI(VADD(T7g, T7f));
			 T7m = VADD(T7i, T7j);
			 ST(&(xo[WS(os, 12)]), VADD(T7l, T7m), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 52)]), VSUB(T7m, T7l), ovs, &(xo[0]));
		    }
		    {
			 V T7d, T7e, T7h, T7k;
			 T7d = VSUB(T6X, T74);
			 T7e = VBYI(VSUB(T7b, T78));
			 ST(&(xo[WS(os, 36)]), VSUB(T7d, T7e), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 28)]), VADD(T7d, T7e), ovs, &(xo[0]));
			 T7h = VBYI(VSUB(T7f, T7g));
			 T7k = VSUB(T7i, T7j);
			 ST(&(xo[WS(os, 20)]), VADD(T7h, T7k), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 44)]), VSUB(T7k, T7h), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T5N, T68, T61, T69, T5U, T65, T5Y, T66;
		    {
			 V T5L, T5M, T5Z, T60;
			 T5L = VSUB(T4p, T4w);
			 T5M = VSUB(T5u, T5t);
			 T5N = VADD(T5L, T5M);
			 T68 = VSUB(T5L, T5M);
			 T5Z = VFNMS(LDK(KP555570233), T5O, VMUL(LDK(KP831469612), T5P));
			 T60 = VFMA(LDK(KP555570233), T5R, VMUL(LDK(KP831469612), T5S));
			 T61 = VADD(T5Z, T60);
			 T69 = VSUB(T60, T5Z);
		    }
		    {
			 V T5Q, T5T, T5W, T5X;
			 T5Q = VFMA(LDK(KP831469612), T5O, VMUL(LDK(KP555570233), T5P));
			 T5T = VFNMS(LDK(KP555570233), T5S, VMUL(LDK(KP831469612), T5R));
			 T5U = VADD(T5Q, T5T);
			 T65 = VSUB(T5T, T5Q);
			 T5W = VSUB(T5r, T5q);
			 T5X = VSUB(T4L, T4E);
			 T5Y = VADD(T5W, T5X);
			 T66 = VSUB(T5X, T5W);
		    }
		    {
			 V T5V, T62, T6b, T6c;
			 T5V = VADD(T5N, T5U);
			 T62 = VBYI(VADD(T5Y, T61));
			 ST(&(xo[WS(os, 58)]), VSUB(T5V, T62), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 6)]), VADD(T5V, T62), ovs, &(xo[0]));
			 T6b = VBYI(VADD(T66, T65));
			 T6c = VADD(T68, T69);
			 ST(&(xo[WS(os, 10)]), VADD(T6b, T6c), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 54)]), VSUB(T6c, T6b), ovs, &(xo[0]));
		    }
		    {
			 V T63, T64, T67, T6a;
			 T63 = VSUB(T5N, T5U);
			 T64 = VBYI(VSUB(T61, T5Y));
			 ST(&(xo[WS(os, 38)]), VSUB(T63, T64), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 26)]), VADD(T63, T64), ovs, &(xo[0]));
			 T67 = VBYI(VSUB(T65, T66));
			 T6a = VSUB(T68, T69);
			 ST(&(xo[WS(os, 22)]), VADD(T67, T6a), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 42)]), VSUB(T6a, T67), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T11, T2C, T2v, T2D, T2e, T2z, T2s, T2A;
		    {
			 V Tr, T10, T2t, T2u;
			 Tr = VSUB(Tb, Tq);
			 T10 = VSUB(TI, TZ);
			 T11 = VADD(Tr, T10);
			 T2C = VSUB(Tr, T10);
			 T2t = VFNMS(LDK(KP634393284), T1B, VMUL(LDK(KP773010453), T1s));
			 T2u = VFMA(LDK(KP773010453), T2c, VMUL(LDK(KP634393284), T23));
			 T2v = VADD(T2t, T2u);
			 T2D = VSUB(T2u, T2t);
		    }
		    {
			 V T1C, T2d, T2o, T2r;
			 T1C = VFMA(LDK(KP634393284), T1s, VMUL(LDK(KP773010453), T1B));
			 T2d = VFNMS(LDK(KP634393284), T2c, VMUL(LDK(KP773010453), T23));
			 T2e = VADD(T1C, T2d);
			 T2z = VSUB(T2d, T1C);
			 T2o = VSUB(T2i, T2n);
			 T2r = VSUB(T2p, T2q);
			 T2s = VADD(T2o, T2r);
			 T2A = VSUB(T2r, T2o);
		    }
		    {
			 V T2f, T2w, T2F, T2G;
			 T2f = VADD(T11, T2e);
			 T2w = VBYI(VADD(T2s, T2v));
			 ST(&(xo[WS(os, 57)]), VSUB(T2f, T2w), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 7)]), VADD(T2f, T2w), ovs, &(xo[WS(os, 1)]));
			 T2F = VBYI(VADD(T2A, T2z));
			 T2G = VADD(T2C, T2D);
			 ST(&(xo[WS(os, 9)]), VADD(T2F, T2G), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 55)]), VSUB(T2G, T2F), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T2x, T2y, T2B, T2E;
			 T2x = VSUB(T11, T2e);
			 T2y = VBYI(VSUB(T2v, T2s));
			 ST(&(xo[WS(os, 39)]), VSUB(T2x, T2y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 25)]), VADD(T2x, T2y), ovs, &(xo[WS(os, 1)]));
			 T2B = VBYI(VSUB(T2z, T2A));
			 T2E = VSUB(T2C, T2D);
			 ST(&(xo[WS(os, 23)]), VADD(T2B, T2E), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 41)]), VSUB(T2E, T2B), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T3j, T3Q, T3J, T3R, T3y, T3N, T3G, T3O;
		    {
			 V T3b, T3i, T3H, T3I;
			 T3b = VADD(T39, T3a);
			 T3i = VADD(T3e, T3h);
			 T3j = VADD(T3b, T3i);
			 T3Q = VSUB(T3b, T3i);
			 T3H = VFNMS(LDK(KP290284677), T3m, VMUL(LDK(KP956940335), T3p));
			 T3I = VFMA(LDK(KP290284677), T3t, VMUL(LDK(KP956940335), T3w));
			 T3J = VADD(T3H, T3I);
			 T3R = VSUB(T3I, T3H);
		    }
		    {
			 V T3q, T3x, T3C, T3F;
			 T3q = VFMA(LDK(KP956940335), T3m, VMUL(LDK(KP290284677), T3p));
			 T3x = VFNMS(LDK(KP290284677), T3w, VMUL(LDK(KP956940335), T3t));
			 T3y = VADD(T3q, T3x);
			 T3N = VSUB(T3x, T3q);
			 T3C = VADD(T3A, T3B);
			 T3F = VADD(T3D, T3E);
			 T3G = VADD(T3C, T3F);
			 T3O = VSUB(T3F, T3C);
		    }
		    {
			 V T3z, T3K, T3T, T3U;
			 T3z = VADD(T3j, T3y);
			 T3K = VBYI(VADD(T3G, T3J));
			 ST(&(xo[WS(os, 61)]), VSUB(T3z, T3K), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 3)]), VADD(T3z, T3K), ovs, &(xo[WS(os, 1)]));
			 T3T = VBYI(VADD(T3O, T3N));
			 T3U = VADD(T3Q, T3R);
			 ST(&(xo[WS(os, 13)]), VADD(T3T, T3U), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 51)]), VSUB(T3U, T3T), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T3L, T3M, T3P, T3S;
			 T3L = VSUB(T3j, T3y);
			 T3M = VBYI(VSUB(T3J, T3G));
			 ST(&(xo[WS(os, 35)]), VSUB(T3L, T3M), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 29)]), VADD(T3L, T3M), ovs, &(xo[WS(os, 1)]));
			 T3P = VBYI(VSUB(T3N, T3O));
			 T3S = VSUB(T3Q, T3R);
			 ST(&(xo[WS(os, 19)]), VADD(T3P, T3S), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 45)]), VSUB(T3S, T3P), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T4N, T5G, T5z, T5H, T5m, T5D, T5w, T5E;
		    {
			 V T4x, T4M, T5x, T5y;
			 T4x = VADD(T4p, T4w);
			 T4M = VADD(T4E, T4L);
			 T4N = VADD(T4x, T4M);
			 T5G = VSUB(T4x, T4M);
			 T5x = VFNMS(LDK(KP195090322), T4Y, VMUL(LDK(KP980785280), T53));
			 T5y = VFMA(LDK(KP195090322), T5f, VMUL(LDK(KP980785280), T5k));
			 T5z = VADD(T5x, T5y);
			 T5H = VSUB(T5y, T5x);
		    }
		    {
			 V T54, T5l, T5s, T5v;
			 T54 = VFMA(LDK(KP980785280), T4Y, VMUL(LDK(KP195090322), T53));
			 T5l = VFNMS(LDK(KP195090322), T5k, VMUL(LDK(KP980785280), T5f));
			 T5m = VADD(T54, T5l);
			 T5D = VSUB(T5l, T54);
			 T5s = VADD(T5q, T5r);
			 T5v = VADD(T5t, T5u);
			 T5w = VADD(T5s, T5v);
			 T5E = VSUB(T5v, T5s);
		    }
		    {
			 V T5n, T5A, T5J, T5K;
			 T5n = VADD(T4N, T5m);
			 T5A = VBYI(VADD(T5w, T5z));
			 ST(&(xo[WS(os, 62)]), VSUB(T5n, T5A), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 2)]), VADD(T5n, T5A), ovs, &(xo[0]));
			 T5J = VBYI(VADD(T5E, T5D));
			 T5K = VADD(T5G, T5H);
			 ST(&(xo[WS(os, 14)]), VADD(T5J, T5K), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 50)]), VSUB(T5K, T5J), ovs, &(xo[0]));
		    }
		    {
			 V T5B, T5C, T5F, T5I;
			 T5B = VSUB(T4N, T5m);
			 T5C = VBYI(VSUB(T5z, T5w));
			 ST(&(xo[WS(os, 34)]), VSUB(T5B, T5C), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 30)]), VADD(T5B, T5C), ovs, &(xo[0]));
			 T5F = VBYI(VSUB(T5D, T5E));
			 T5I = VSUB(T5G, T5H);
			 ST(&(xo[WS(os, 18)]), VADD(T5F, T5I), ovs, &(xo[0]));
			 ST(&(xo[WS(os, 46)]), VSUB(T5I, T5F), ovs, &(xo[0]));
		    }
	       }
	       {
		    V T2J, T34, T2X, T35, T2Q, T31, T2U, T32;
		    {
			 V T2H, T2I, T2V, T2W;
			 T2H = VADD(Tb, Tq);
			 T2I = VADD(T2q, T2p);
			 T2J = VADD(T2H, T2I);
			 T34 = VSUB(T2H, T2I);
			 T2V = VFNMS(LDK(KP098017140), T2L, VMUL(LDK(KP995184726), T2K));
			 T2W = VFMA(LDK(KP995184726), T2O, VMUL(LDK(KP098017140), T2N));
			 T2X = VADD(T2V, T2W);
			 T35 = VSUB(T2W, T2V);
		    }
		    {
			 V T2M, T2P, T2S, T2T;
			 T2M = VFMA(LDK(KP098017140), T2K, VMUL(LDK(KP995184726), T2L));
			 T2P = VFNMS(LDK(KP098017140), T2O, VMUL(LDK(KP995184726), T2N));
			 T2Q = VADD(T2M, T2P);
			 T31 = VSUB(T2P, T2M);
			 T2S = VADD(T2n, T2i);
			 T2T = VADD(TZ, TI);
			 T2U = VADD(T2S, T2T);
			 T32 = VSUB(T2T, T2S);
		    }
		    {
			 V T2R, T2Y, T37, T38;
			 T2R = VADD(T2J, T2Q);
			 T2Y = VBYI(VADD(T2U, T2X));
			 ST(&(xo[WS(os, 63)]), VSUB(T2R, T2Y), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 1)]), VADD(T2R, T2Y), ovs, &(xo[WS(os, 1)]));
			 T37 = VBYI(VADD(T32, T31));
			 T38 = VADD(T34, T35);
			 ST(&(xo[WS(os, 15)]), VADD(T37, T38), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 49)]), VSUB(T38, T37), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T2Z, T30, T33, T36;
			 T2Z = VSUB(T2J, T2Q);
			 T30 = VBYI(VSUB(T2X, T2U));
			 ST(&(xo[WS(os, 33)]), VSUB(T2Z, T30), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 31)]), VADD(T2Z, T30), ovs, &(xo[WS(os, 1)]));
			 T33 = VBYI(VSUB(T31, T32));
			 T36 = VSUB(T34, T35);
			 ST(&(xo[WS(os, 17)]), VADD(T33, T36), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 47)]), VSUB(T36, T33), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	       {
		    V T3X, T4i, T4b, T4j, T44, T4f, T48, T4g;
		    {
			 V T3V, T3W, T49, T4a;
			 T3V = VSUB(T39, T3a);
			 T3W = VSUB(T3E, T3D);
			 T3X = VADD(T3V, T3W);
			 T4i = VSUB(T3V, T3W);
			 T49 = VFNMS(LDK(KP471396736), T3Y, VMUL(LDK(KP881921264), T3Z));
			 T4a = VFMA(LDK(KP471396736), T41, VMUL(LDK(KP881921264), T42));
			 T4b = VADD(T49, T4a);
			 T4j = VSUB(T4a, T49);
		    }
		    {
			 V T40, T43, T46, T47;
			 T40 = VFMA(LDK(KP881921264), T3Y, VMUL(LDK(KP471396736), T3Z));
			 T43 = VFNMS(LDK(KP471396736), T42, VMUL(LDK(KP881921264), T41));
			 T44 = VADD(T40, T43);
			 T4f = VSUB(T43, T40);
			 T46 = VSUB(T3B, T3A);
			 T47 = VSUB(T3h, T3e);
			 T48 = VADD(T46, T47);
			 T4g = VSUB(T47, T46);
		    }
		    {
			 V T45, T4c, T4l, T4m;
			 T45 = VADD(T3X, T44);
			 T4c = VBYI(VADD(T48, T4b));
			 ST(&(xo[WS(os, 59)]), VSUB(T45, T4c), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 5)]), VADD(T45, T4c), ovs, &(xo[WS(os, 1)]));
			 T4l = VBYI(VADD(T4g, T4f));
			 T4m = VADD(T4i, T4j);
			 ST(&(xo[WS(os, 11)]), VADD(T4l, T4m), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 53)]), VSUB(T4m, T4l), ovs, &(xo[WS(os, 1)]));
		    }
		    {
			 V T4d, T4e, T4h, T4k;
			 T4d = VSUB(T3X, T44);
			 T4e = VBYI(VSUB(T4b, T48));
			 ST(&(xo[WS(os, 37)]), VSUB(T4d, T4e), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 27)]), VADD(T4d, T4e), ovs, &(xo[WS(os, 1)]));
			 T4h = VBYI(VSUB(T4f, T4g));
			 T4k = VSUB(T4i, T4j);
			 ST(&(xo[WS(os, 21)]), VADD(T4h, T4k), ovs, &(xo[WS(os, 1)]));
			 ST(&(xo[WS(os, 43)]), VSUB(T4k, T4h), ovs, &(xo[WS(os, 1)]));
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 64, XSIMD_STRING("n1fv_64"), { 404, 72, 52, 0 }, &GENUS, 0, 0, 0, 0 };

void XSIMD(codelet_n1fv_64) (planner *p) { X(kdft_register) (p, n1fv_64, &desc);
}

#endif
