#!/bin/bash
usage() {
    echo "Usage: set-emacs-default-<toolkit>.sh"
    echo "       <toolkit> must be basic, w32, gtk, or lucid"
    exit 1
}

case $0 in
    *basic.sh) toolkit=basic ;;
      *w32.sh) toolkit=w32 ;;
      *gtk.sh) toolkit=gtk ;;
    *lucid.sh) toolkit=lucid ;;
            *) usage ;;
esac
for x in emacs emacsclient
do
    priority=0
    for t in basic w32 gtk lucid
    do
	priority=$(( priority + 10 ))
        [ -e /usr/bin/${x}-${t}.exe ] && /usr/sbin/alternatives --install \
             /usr/bin/${x} ${x} /usr/bin/${x}-${t}.exe ${priority}
    done
    /usr/sbin/alternatives --install /usr/bin/${x} ${x} \
        /usr/bin/${x}-${toolkit}.exe 100
    /usr/sbin/alternatives --auto ${x}
done
