/* BackendGDrive.c generated by valac 0.30.0, the Vala compiler
 * generated from BackendGDrive.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_GDRIVE (deja_dup_backend_gdrive_get_type ())
#define DEJA_DUP_BACKEND_GDRIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDrive))
#define DEJA_DUP_BACKEND_GDRIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDriveClass))
#define DEJA_DUP_IS_BACKEND_GDRIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE))
#define DEJA_DUP_IS_BACKEND_GDRIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_GDRIVE))
#define DEJA_DUP_BACKEND_GDRIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDriveClass))

typedef struct _DejaDupBackendGDrive DejaDupBackendGDrive;
typedef struct _DejaDupBackendGDriveClass DejaDupBackendGDriveClass;
typedef struct _DejaDupBackendGDrivePrivate DejaDupBackendGDrivePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendGdriveIsReadyData DejaDupBackendGdriveIsReadyData;

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendGdriveGetEnvpData DejaDupBackendGdriveGetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendGdriveGotPasswordReplyData DejaDupBackendGdriveGotPasswordReplyData;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendGDrive {
	DejaDupBackend parent_instance;
	DejaDupBackendGDrivePrivate * priv;
};

struct _DejaDupBackendGDriveClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendGDrivePrivate {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

struct _DejaDupBackendGdriveIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendGDrive* self;
	gchar* when;
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
};

struct _DejaDupBackendGdriveGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendGDrive* self;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	SecretSchema* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	GError * _inner_error_;
};

struct _DejaDupBackendGdriveGotPasswordReplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendGDrive* self;
	GMountOperation* mount_op;
	GMountOperationResult _result_;
	GMountOperationResult _tmp0_;
	GList* _tmp1_;
	const gchar* _tmp2_;
	GMountOperation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GMountOperation* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GPasswordSave remember;
	GMountOperation* _tmp11_;
	GPasswordSave _tmp12_;
	GPasswordSave _tmp13_;
	GPasswordSave _tmp14_;
	const gchar* _tmp15_;
	GPasswordSave _tmp16_;
	gchar* where;
	gchar* _tmp17_;
	SecretSchema* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_gdrive_parent_class = NULL;

#define DEJA_DUP_GDRIVE_ROOT "GDrive"
#define DEJA_DUP_GDRIVE_EMAIL "email"
#define DEJA_DUP_GDRIVE_FOLDER "folder"
#define DEJA_DUP_GDRIVE_HOST "drive.google.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_gdrive_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_GDRIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDrivePrivate))
enum  {
	DEJA_DUP_BACKEND_GDRIVE_DUMMY_PROPERTY
};
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
DejaDupChecker* deja_dup_backend_gdrive_get_checker (void);
DejaDupChecker* deja_dup_checker_new_with_available (gboolean available);
DejaDupChecker* deja_dup_checker_construct_with_available (GType object_type, gboolean available);
static DejaDupBackend* deja_dup_backend_gdrive_real_clone (DejaDupBackend* base);
DejaDupBackendGDrive* deja_dup_backend_gdrive_new (void);
DejaDupBackendGDrive* deja_dup_backend_gdrive_construct (GType object_type);
static gboolean deja_dup_backend_gdrive_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_gdrive_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_gdrive_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_gdrive_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_gdrive_real_is_ready_co (DejaDupBackendGdriveIsReadyData* _data_);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
void deja_dup_network_can_reach (DejaDupNetwork* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_network_can_reach_finish (DejaDupNetwork* self, GAsyncResult* _res_);
static void deja_dup_backend_gdrive_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* deja_dup_backend_gdrive_real_get_location (DejaDupBackend* base, gboolean* as_root);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
static gchar* deja_dup_backend_gdrive_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_gdrive_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_gdrive_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_gdrive_real_get_envp_co (DejaDupBackendGdriveGetEnvpData* _data_);
static void deja_dup_backend_gdrive_got_secret_key (DejaDupBackendGDrive* self);
static void deja_dup_backend_gdrive_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_gdrive_ask_password (DejaDupBackendGDrive* self);
static void deja_dup_backend_gdrive_got_password_reply_data_free (gpointer _data);
static void deja_dup_backend_gdrive_got_password_reply (DejaDupBackendGDrive* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_gdrive_got_password_reply_finish (DejaDupBackendGDrive* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_gdrive_got_password_reply_co (DejaDupBackendGdriveGotPasswordReplyData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_gdrive_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_gdrive_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_gdrive_finalize (GObject* obj);


DejaDupChecker* deja_dup_backend_gdrive_get_checker (void) {
	DejaDupChecker* result = NULL;
	DejaDupChecker* _tmp0_ = NULL;
	_tmp0_ = deja_dup_checker_new_with_available (FALSE);
	result = _tmp0_;
	return result;
}


static DejaDupBackend* deja_dup_backend_gdrive_real_clone (DejaDupBackend* base) {
	DejaDupBackendGDrive * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendGDrive* _tmp0_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_tmp0_ = deja_dup_backend_gdrive_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_gdrive_real_is_native (DejaDupBackend* base) {
	DejaDupBackendGDrive * self;
	gboolean result = FALSE;
	self = (DejaDupBackendGDrive*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_gdrive_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendGDrive * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static void deja_dup_backend_gdrive_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendGdriveIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendGdriveIsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_gdrive_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendGDrive * self;
	DejaDupBackendGdriveIsReadyData* _data_;
	DejaDupBackendGDrive* _tmp0_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_data_ = g_slice_new0 (DejaDupBackendGdriveIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_gdrive_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_gdrive_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_gdrive_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_gdrive_real_is_ready_finish (DejaDupBackend* base, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendGdriveIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void deja_dup_backend_gdrive_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendGdriveIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_gdrive_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_gdrive_real_is_ready_co (DejaDupBackendGdriveIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Backup will begin when a network connection becomes available.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = deja_dup_network_get ();
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup_printf ("https://%s/", DEJA_DUP_GDRIVE_HOST);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_network_can_reach (_data_->_tmp3_, _data_->_tmp5_, deja_dup_backend_gdrive_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = deja_dup_network_can_reach_finish (_data_->_tmp3_, _data_->_res_);
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->result = _data_->_tmp7_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * duplicity syntax:
   * gdocs://user[:password]@host/folder
   */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* deja_dup_backend_gdrive_real_get_location (DejaDupBackend* base, gboolean* as_root) {
	DejaDupBackendGDrive * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* folder = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* email = NULL;
	DejaDupFilteredSettings* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gchar* location = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_GDRIVE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_GDRIVE_FOLDER);
	folder = _tmp2_;
	_tmp3_ = folder;
	_tmp4_ = string_strip (_tmp3_);
	_g_free0 (folder);
	folder = _tmp4_;
	_tmp5_ = folder;
	_tmp6_ = string_replace (_tmp5_, "//", "/");
	_g_free0 (folder);
	folder = _tmp6_;
	while (TRUE) {
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		_tmp7_ = folder;
		_tmp8_ = g_str_has_prefix (_tmp7_, "/");
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = folder;
		_tmp10_ = folder;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_substring (_tmp9_, (glong) 1, (glong) (_tmp12_ - 1));
		_g_free0 (folder);
		folder = _tmp13_;
	}
	while (TRUE) {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		_tmp14_ = folder;
		_tmp15_ = g_str_has_suffix (_tmp14_, "/");
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = folder;
		_tmp17_ = folder;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp19_ - 1));
		_g_free0 (folder);
		folder = _tmp20_;
	}
	_tmp21_ = settings;
	_tmp22_ = g_settings_get_string ((GSettings*) _tmp21_, DEJA_DUP_GDRIVE_EMAIL);
	email = _tmp22_;
	_tmp23_ = email;
	_tmp24_ = string_contains (_tmp23_, "@");
	if (!_tmp24_) {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp25_ = email;
		_tmp26_ = g_strconcat (_tmp25_, "@gmail.com", NULL);
		_g_free0 (email);
		email = _tmp26_;
	}
	_tmp27_ = email;
	_tmp28_ = folder;
	_tmp29_ = g_strdup_printf ("gdocs://%s/%s", _tmp27_, _tmp28_);
	location = _tmp29_;
	result = location;
	_g_free0 (email);
	_g_free0 (folder);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_gdrive_real_get_location_pretty (DejaDupBackend* base) {
	DejaDupBackendGDrive * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_GDRIVE_ROOT);
	settings = _tmp0_;
	_tmp1_ = _ ("%s at Google Drive");
	_tmp2_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_GDRIVE_FOLDER);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	_g_object_unref0 (settings);
	return result;
}


static void deja_dup_backend_gdrive_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendGdriveGetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendGdriveGetEnvpData, _data_);
}


static void deja_dup_backend_gdrive_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendGDrive * self;
	DejaDupBackendGdriveGetEnvpData* _data_;
	DejaDupBackendGDrive* _tmp0_ = NULL;
	self = (DejaDupBackendGDrive*) base;
	_data_ = g_slice_new0 (DejaDupBackendGdriveGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_gdrive_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_gdrive_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_gdrive_real_get_envp_co (_data_);
}


static void deja_dup_backend_gdrive_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendGdriveGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_gdrive_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendGdriveGetEnvpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_gdrive_real_get_envp_co (_data_);
}


static gboolean deja_dup_backend_gdrive_real_get_envp_co (DejaDupBackendGdriveGetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_GDRIVE_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_GDRIVE_EMAIL);
	_g_free0 (_data_->self->priv->settings_id);
	_data_->self->priv->settings_id = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->settings_id;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp3_ = "";
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->settings_id;
		_data_->_tmp3_ = _data_->_tmp5_;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp3_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp8_, "") != 0) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->secret_key;
		_data_->_tmp7_ = _data_->_tmp9_ != NULL;
	} else {
		_data_->_tmp7_ = FALSE;
	}
	if (_data_->_tmp7_) {
		deja_dup_backend_gdrive_got_secret_key (_data_->self);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp10_, "") != 0) {
		{
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_lookup (_data_->_tmp12_, NULL, deja_dup_backend_gdrive_get_envp_ready, _data_, "user", _data_->_tmp13_, "server", DEJA_DUP_GDRIVE_HOST, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch11_g_error;
			}
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp11_;
			_data_->_tmp11_ = NULL;
			_g_free0 (_data_->self->priv->secret_key);
			_data_->self->priv->secret_key = _data_->_tmp15_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->priv->secret_key;
			if (_data_->_tmp16_ != NULL) {
				deja_dup_backend_gdrive_got_secret_key (_data_->self);
				_g_free0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->settings);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp11_);
		}
		goto __finally11;
		__catch11_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->e);
		}
		__finally11:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	deja_dup_backend_gdrive_ask_password (_data_->self);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_gdrive_got_password_reply_data_free (gpointer _data) {
	DejaDupBackendGdriveGotPasswordReplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mount_op);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendGdriveGotPasswordReplyData, _data_);
}


static void deja_dup_backend_gdrive_got_password_reply (DejaDupBackendGDrive* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendGdriveGotPasswordReplyData* _data_;
	DejaDupBackendGDrive* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperationResult _tmp3_ = 0;
	_data_ = g_slice_new0 (DejaDupBackendGdriveGotPasswordReplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_gdrive_got_password_reply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_gdrive_got_password_reply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mount_op;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->mount_op);
	_data_->mount_op = _tmp2_;
	_tmp3_ = _result_;
	_data_->_result_ = _tmp3_;
	deja_dup_backend_gdrive_got_password_reply_co (_data_);
}


static void deja_dup_backend_gdrive_got_password_reply_finish (DejaDupBackendGDrive* self, GAsyncResult* _res_) {
	DejaDupBackendGdriveGotPasswordReplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_backend_gdrive_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendGdriveGotPasswordReplyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_gdrive_got_password_reply_co (_data_);
}


static gboolean deja_dup_backend_gdrive_got_password_reply_co (DejaDupBackendGdriveGotPasswordReplyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->_result_;
	if (_data_->_tmp0_ != G_MOUNT_OPERATION_HANDLED) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", FALSE, _data_->_tmp1_, _data_->_tmp2_);
		__g_list_free__g_free0_0 (_data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->mount_op;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_mount_operation_get_username (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->mount_op;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_mount_operation_get_password (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->self->priv->secret_key);
	_data_->self->priv->secret_key = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->mount_op;
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = g_mount_operation_get_password_save (_data_->_tmp11_);
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->remember = _data_->_tmp13_;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->remember;
	if (_data_->_tmp14_ != G_PASSWORD_SAVE_NEVER) {
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = _data_->remember;
		if (_data_->_tmp16_ == G_PASSWORD_SAVE_FOR_SESSION) {
			_data_->_tmp15_ = SECRET_COLLECTION_SESSION;
		} else {
			_data_->_tmp15_ = SECRET_COLLECTION_DEFAULT;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp15_);
		_data_->where = _data_->_tmp17_;
		{
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->where;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->self->priv->id;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strdup_printf ("%s@%s", _data_->_tmp20_, DEJA_DUP_GDRIVE_HOST);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->self->priv->secret_key;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_store (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp23_, NULL, deja_dup_backend_gdrive_got_password_reply_ready, _data_, "user", _data_->_tmp24_, "server", DEJA_DUP_GDRIVE_HOST, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			secret_password_store_finish (_data_->_res_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp22_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch12_g_error;
			}
		}
		goto __finally12;
		__catch12_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->e;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_tmp25_->message;
			g_warning ("BackendGDrive.vala:149: %s\n", _data_->_tmp26_);
			_g_error_free0 (_data_->e);
		}
		__finally12:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_free0 (_data_->where);
	}
	deja_dup_backend_gdrive_got_secret_key (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _deja_dup_backend_gdrive_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_gdrive_got_password_reply ((DejaDupBackendGDrive*) self, _sender, _result_, NULL, NULL);
}


static void deja_dup_backend_gdrive_ask_password (DejaDupBackendGDrive* self) {
	GMountOperation* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GMountOperation* _tmp5_ = NULL;
	GMountOperation* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMountOperation* _tmp8_ = NULL;
	GMountOperation* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GMountOperation* _tmp11_ = NULL;
	GMountOperation* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GMountOperation* _tmp14_ = NULL;
	GMountOperation* _tmp15_ = NULL;
	GMountOperation* _tmp16_ = NULL;
	GMountOperation* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("You can sign up for a Google account <a href=\"%s\">online</a>.");
	_tmp3_ = g_strdup_printf (_tmp2_, "https://accounts.google.com/SignUp");
	_tmp4_ = _tmp3_;
	g_object_set ((GObject*) _tmp1_, "label_help", _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_tmp5_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _ ("Connect to Google Drive");
	g_object_set ((GObject*) _tmp6_, "label_title", _tmp7_, NULL);
	_tmp8_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _ ("_Email");
	g_object_set ((GObject*) _tmp9_, "label_username", _tmp10_, NULL);
	_tmp11_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _ ("_Password");
	g_object_set ((GObject*) _tmp12_, "label_password", _tmp13_, NULL);
	_tmp14_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "reply", (GCallback) _deja_dup_backend_gdrive_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp16_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->id;
	g_signal_emit_by_name (_tmp17_, "ask-password", "", _tmp18_, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_gdrive_got_secret_key (DejaDupBackendGDrive* self) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GList* envp = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_GDRIVE_ROOT);
	settings = _tmp0_;
	_tmp1_ = self->priv->id;
	_tmp2_ = self->priv->settings_id;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		DejaDupFilteredSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = settings;
		_tmp4_ = self->priv->id;
		deja_dup_filtered_settings_set_string (_tmp3_, DEJA_DUP_GDRIVE_EMAIL, _tmp4_);
	}
	envp = NULL;
	_tmp5_ = self->priv->secret_key;
	_tmp6_ = g_strdup_printf ("FTP_PASSWORD=%s", _tmp5_);
	envp = g_list_append (envp, _tmp6_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_object_unref0 (settings);
}


DejaDupBackendGDrive* deja_dup_backend_gdrive_construct (GType object_type) {
	DejaDupBackendGDrive * self = NULL;
	self = (DejaDupBackendGDrive*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendGDrive* deja_dup_backend_gdrive_new (void) {
	return deja_dup_backend_gdrive_construct (DEJA_DUP_TYPE_BACKEND_GDRIVE);
}


static void deja_dup_backend_gdrive_class_init (DejaDupBackendGDriveClass * klass) {
	deja_dup_backend_gdrive_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendGDrivePrivate));
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_gdrive_real_clone;
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_gdrive_real_is_native;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_gdrive_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_gdrive_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_gdrive_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_gdrive_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_gdrive_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_gdrive_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_gdrive_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_gdrive_finalize;
}


static void deja_dup_backend_gdrive_instance_init (DejaDupBackendGDrive * self) {
	self->priv = DEJA_DUP_BACKEND_GDRIVE_GET_PRIVATE (self);
}


static void deja_dup_backend_gdrive_finalize (GObject* obj) {
	DejaDupBackendGDrive * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDrive);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_gdrive_parent_class)->finalize (obj);
}


GType deja_dup_backend_gdrive_get_type (void) {
	static volatile gsize deja_dup_backend_gdrive_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_gdrive_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendGDriveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_gdrive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendGDrive), 0, (GInstanceInitFunc) deja_dup_backend_gdrive_instance_init, NULL };
		GType deja_dup_backend_gdrive_type_id;
		deja_dup_backend_gdrive_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendGDrive", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_gdrive_type_id__volatile, deja_dup_backend_gdrive_type_id);
	}
	return deja_dup_backend_gdrive_type_id__volatile;
}



