/* TweetListBox.c generated by valac 0.38.7, the Vala compiler
 * generated from TweetListBox.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbTweet.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbUtils.h"


#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
enum  {
	TWEET_LIST_BOX_0_PROPERTY,
	TWEET_LIST_BOX_ACTION_ENTRY_PROPERTY,
	TWEET_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* tweet_list_box_properties[TWEET_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define __vala_GdkEventButton_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventButton_free (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
enum  {
	TWEET_LIST_BOX_RETRY_BUTTON_CLICKED_SIGNAL,
	TWEET_LIST_BOX_NUM_SIGNALS
};
static guint tweet_list_box_signals[TWEET_LIST_BOX_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetListBoxPrivate {
	GtkStack* placeholder;
	GtkLabel* no_entries_label;
	GtkBox* error_box;
	GtkLabel* error_label;
	GtkButton* retry_button;
	TweetListEntry* _action_entry;
	GtkGestureMultiPress* press_gesture;
};


static gpointer tweet_list_box_parent_class = NULL;

GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_BOX, TweetListBoxPrivate))
TweetListBox* tweet_list_box_new (void);
TweetListBox* tweet_list_box_construct (GType object_type);
static GtkWidget* tweet_list_box_widget_create_func (TweetListBox* self, GObject* obj);
GType main_window_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void tweet_list_entry_fade_in (TweetListEntry* self);
static void tweet_list_box_gesture_pressed_cb (TweetListBox* self, gint n_press, gdouble x, gdouble y);
static GdkEventButton* _vala_GdkEventButton_copy (GdkEventButton* self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void tweet_list_box_set_action_entry (TweetListBox* self, TweetListEntry* entry);
static void _vala_GdkEventButton_free (GdkEventButton* self);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static void tweet_list_box_action_entry_destroyed_cb (TweetListBox* self);
static void _tweet_list_box_action_entry_destroyed_cb_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void tweet_list_box_add_placeholder (TweetListBox* self);
static void __lambda19_ (TweetListBox* self);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_list_box_set_unempty (TweetListBox* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
void tweet_list_box_remove_all (TweetListBox* self);
static void __lambda20_ (TweetListBox* self, GtkWidget* w);
static void ___lambda20__gtk_callback (GtkWidget* widget, gpointer self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _tweet_list_box_gesture_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
GSettings* settings_get (void);
static GtkWidget* _tweet_list_box_widget_create_func_gtk_list_box_create_widget_func (GObject* item, gpointer self);
static void tweet_list_box_finalize (GObject * obj);
static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


TweetListBox* tweet_list_box_construct (GType object_type) {
	TweetListBox * self = NULL;
	self = (TweetListBox*) g_object_new (object_type, NULL);
	return self;
}


TweetListBox* tweet_list_box_new (void) {
	return tweet_list_box_construct (TYPE_TWEET_LIST_BOX);
}


static GtkWidget* tweet_list_box_widget_create_func (TweetListBox* self, GObject* obj) {
	GtkWidget* result = NULL;
	GObject* _tmp0_;
	TweetListEntry* row = NULL;
	GObject* _tmp1_;
	GtkWidget* _tmp2_;
	Account* _tmp3_;
	TweetListEntry* _tmp4_;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	g_return_val_if_fail (G_IS_OBJECT (obj), NULL);
	_tmp0_ = obj;
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CB_TYPE_TWEET), "obj is Cb.Tweet");
	_tmp1_ = obj;
	_tmp2_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->account;
	_tmp4_ = tweet_list_entry_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CB_TYPE_TWEET, CbTweet), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MAIN_WINDOW, MainWindow), _tmp3_, FALSE);
	g_object_ref_sink (_tmp4_);
	row = _tmp4_;
	tweet_list_entry_fade_in (row);
	result = G_TYPE_CHECK_INSTANCE_CAST (row, gtk_widget_get_type (), GtkWidget);
	return result;
}


static GdkEventButton* _vala_GdkEventButton_copy (GdkEventButton* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventButton_copy0 (gpointer self) {
	return self ? _vala_GdkEventButton_copy (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GdkEventButton_free (GdkEventButton* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static void _vala_GdkEventSequence_free (GdkEventSequence* self) {
	g_boxed_free (gdk_event_sequence_get_type (), self);
}


static void tweet_list_box_gesture_pressed_cb (TweetListBox* self, gint n_press, gdouble x, gdouble y) {
	GdkEventSequence* sequence = NULL;
	GtkGestureMultiPress* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEventButton* event = NULL;
	GtkGestureMultiPress* _tmp2_;
	GdkEventSequence* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEventButton* _tmp5_;
	GdkEventButton* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->press_gesture;
	_tmp1_ = gtk_gesture_single_get_current_sequence (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle));
	sequence = _tmp1_;
	_tmp2_ = self->priv->press_gesture;
	_tmp3_ = sequence;
	_tmp4_ = gtk_gesture_get_last_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_gesture_get_type (), GtkGesture), _tmp3_);
	_tmp5_ = __vala_GdkEventButton_copy0 ((GdkEventButton*) _tmp4_);
	event = _tmp5_;
	_tmp6_ = event;
	_tmp7_ = gdk_event_triggers_context_menu ((GdkEvent*) _tmp6_);
	if (_tmp7_) {
		GdkWindow* event_window = NULL;
		GdkEventButton* _tmp8_;
		GdkWindow* _tmp9_;
		GdkWindow* _tmp10_;
		GdkWindow* window = NULL;
		GdkWindow* _tmp11_;
		GdkWindow* _tmp12_;
		gdouble relative_y = 0.0;
		GdkEventButton* _tmp13_;
		gdouble _tmp14_;
		gdouble parent_y = 0.0;
		GtkWidget* row = NULL;
		gdouble _tmp26_;
		GtkListBoxRow* _tmp27_;
		GtkWidget* _tmp28_;
		gboolean _tmp29_ = FALSE;
		GtkWidget* _tmp30_;
		_tmp8_ = event;
		_tmp9_ = _tmp8_->window;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		event_window = _tmp10_;
		_tmp11_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = _g_object_ref0 (_tmp11_);
		window = _tmp12_;
		_tmp13_ = event;
		_tmp14_ = _tmp13_->y;
		relative_y = _tmp14_;
		while (TRUE) {
			gboolean _tmp15_ = FALSE;
			GdkWindow* _tmp16_;
			GdkWindow* _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_ = 0.0;
			gdouble _tmp22_;
			GdkWindow* _tmp23_;
			GdkWindow* _tmp24_;
			GdkWindow* _tmp25_;
			_tmp16_ = event_window;
			if (_tmp16_ != NULL) {
				GdkWindow* _tmp17_;
				GdkWindow* _tmp18_;
				_tmp17_ = event_window;
				_tmp18_ = window;
				_tmp15_ = _tmp17_ != _tmp18_;
			} else {
				_tmp15_ = FALSE;
			}
			if (!_tmp15_) {
				break;
			}
			_tmp19_ = event_window;
			_tmp20_ = relative_y;
			gdk_window_coords_to_parent (_tmp19_, (gdouble) 0, _tmp20_, NULL, &_tmp21_);
			parent_y = _tmp21_;
			_tmp22_ = parent_y;
			relative_y = _tmp22_;
			_tmp23_ = event_window;
			_tmp24_ = gdk_window_get_effective_parent (_tmp23_);
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (event_window);
			event_window = _tmp25_;
		}
		_tmp26_ = relative_y;
		_tmp27_ = gtk_list_box_get_row_at_y (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), (gint) _tmp26_);
		_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
		row = _tmp28_;
		_tmp30_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, TYPE_TWEET_LIST_ENTRY)) {
			GtkWidget* _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp33_;
			_tmp31_ = row;
			_tmp32_ = gtk_widget_get_sensitive (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp29_ = _tmp33_;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			TweetListEntry* tle = NULL;
			GtkWidget* _tmp34_;
			TweetListEntry* _tmp35_;
			gboolean _tmp36_ = FALSE;
			gboolean _tmp37_ = FALSE;
			TweetListEntry* _tmp38_;
			TweetListEntry* _tmp39_;
			TweetListEntry* _tmp45_;
			TweetListEntry* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			GtkGestureMultiPress* _tmp50_;
			_tmp34_ = row;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
			tle = _tmp35_;
			_tmp38_ = tle;
			_tmp39_ = self->priv->_action_entry;
			if (_tmp38_ != _tmp39_) {
				TweetListEntry* _tmp40_;
				_tmp40_ = self->priv->_action_entry;
				_tmp37_ = _tmp40_ != NULL;
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				TweetListEntry* _tmp41_;
				gboolean _tmp42_;
				gboolean _tmp43_;
				_tmp41_ = self->priv->_action_entry;
				_tmp42_ = tweet_list_entry_get_shows_actions (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp36_ = _tmp43_;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				TweetListEntry* _tmp44_;
				_tmp44_ = self->priv->_action_entry;
				tweet_list_entry_toggle_mode (_tmp44_);
			}
			_tmp45_ = tle;
			tweet_list_entry_toggle_mode (_tmp45_);
			_tmp46_ = tle;
			_tmp47_ = tweet_list_entry_get_shows_actions (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_) {
				TweetListEntry* _tmp49_;
				_tmp49_ = tle;
				tweet_list_box_set_action_entry (self, _tmp49_);
			} else {
				tweet_list_box_set_action_entry (self, NULL);
			}
			_tmp50_ = self->priv->press_gesture;
			gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
			_g_object_unref0 (tle);
		}
		_g_object_unref0 (row);
		_g_object_unref0 (window);
		_g_object_unref0 (event_window);
	}
	__vala_GdkEventButton_free0 (event);
	__vala_GdkEventSequence_free0 (sequence);
}


static void _tweet_list_box_action_entry_destroyed_cb_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	tweet_list_box_action_entry_destroyed_cb ((TweetListBox*) self);
}


static void tweet_list_box_set_action_entry (TweetListBox* self, TweetListEntry* entry) {
	TweetListEntry* _tmp0_;
	TweetListEntry* _tmp3_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail ((entry == NULL) || IS_TWEET_LIST_ENTRY (entry));
	_tmp0_ = self->priv->_action_entry;
	if (_tmp0_ != NULL) {
		TweetListEntry* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_action_entry;
		g_signal_parse_name ("destroy", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _tweet_list_box_action_entry_destroyed_cb_gtk_widget_destroy, self);
		_g_object_unref0 (self->priv->_action_entry);
		self->priv->_action_entry = NULL;
	}
	_tmp3_ = entry;
	if (_tmp3_ != NULL) {
		TweetListEntry* _tmp4_;
		TweetListEntry* _tmp5_;
		TweetListEntry* _tmp6_;
		_tmp4_ = entry;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (self->priv->_action_entry);
		self->priv->_action_entry = _tmp5_;
		_tmp6_ = self->priv->_action_entry;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) _tweet_list_box_action_entry_destroyed_cb_gtk_widget_destroy, self, 0);
	}
}


static void tweet_list_box_action_entry_destroyed_cb (TweetListBox* self) {
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_g_object_unref0 (self->priv->_action_entry);
	self->priv->_action_entry = NULL;
}


static void __lambda19_ (TweetListBox* self) {
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
	g_signal_emit (self, tweet_list_box_signals[TWEET_LIST_BOX_RETRY_BUTTON_CLICKED_SIGNAL], 0);
}


static void ___lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda19_ ((TweetListBox*) self);
}


static void tweet_list_box_add_placeholder (TweetListBox* self) {
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkLabel* loading_label = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStack* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkLabel* _tmp8_;
	GtkStack* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkButton* _tmp24_;
	GtkStack* _tmp25_;
	GtkBox* _tmp26_;
	GtkStack* _tmp27_;
	GtkStack* _tmp28_;
	GtkStack* _tmp29_;
	GtkStack* _tmp30_;
	GtkStack* _tmp31_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp0_;
	_tmp1_ = self->priv->placeholder;
	gtk_stack_set_transition_type (_tmp1_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Loading…"));
	g_object_ref_sink (_tmp2_);
	loading_label = _tmp2_;
	_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (loading_label, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp3_, "dim-label");
	_tmp4_ = self->priv->placeholder;
	gtk_stack_add_named (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (loading_label, gtk_widget_get_type (), GtkWidget), "spinner");
	_tmp5_ = (GtkLabel*) gtk_label_new (_ ("No entries found"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->no_entries_label);
	self->priv->no_entries_label = _tmp5_;
	_tmp6_ = self->priv->no_entries_label;
	_tmp7_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp7_, "dim-label");
	_tmp8_ = self->priv->no_entries_label;
	g_object_set (_tmp8_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp9_ = self->priv->placeholder;
	_tmp10_ = self->priv->no_entries_label;
	gtk_stack_add_named (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "no-entries");
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->error_box);
	self->priv->error_box = _tmp11_;
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->error_label);
	self->priv->error_label = _tmp12_;
	_tmp13_ = self->priv->error_label;
	_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp14_, "dim-label");
	_tmp15_ = self->priv->error_label;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), "margin", 12, NULL);
	_tmp16_ = self->priv->error_label;
	gtk_label_set_selectable (_tmp16_, TRUE);
	_tmp17_ = self->priv->error_label;
	g_object_set (_tmp17_, "wrap", TRUE, NULL);
	_tmp18_ = (GtkButton*) gtk_button_new_with_label (_ ("Retry"));
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->retry_button);
	self->priv->retry_button = _tmp18_;
	_tmp19_ = self->priv->retry_button;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp20_ = self->priv->retry_button;
	g_signal_connect_object (_tmp20_, "clicked", (GCallback) ___lambda19__gtk_button_clicked, self, 0);
	_tmp21_ = self->priv->error_box;
	_tmp22_ = self->priv->error_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
	_tmp23_ = self->priv->error_box;
	_tmp24_ = self->priv->retry_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	_tmp25_ = self->priv->placeholder;
	_tmp26_ = self->priv->error_box;
	gtk_stack_add_named (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget), "error");
	_tmp27_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp27_, "spinner");
	_tmp28_ = self->priv->placeholder;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
	_tmp29_ = self->priv->placeholder;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp30_ = self->priv->placeholder;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp31_ = self->priv->placeholder;
	gtk_list_box_set_placeholder (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (loading_label);
}


void tweet_list_box_set_empty (TweetListBox* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "no-entries");
}


void tweet_list_box_set_unempty (TweetListBox* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
}


void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	GtkStack* _tmp2_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (err_msg != NULL);
	_tmp0_ = self->priv->error_label;
	_tmp1_ = err_msg;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp2_, "error");
}


GtkStack* tweet_list_box_get_placeholder (TweetListBox* self) {
	GtkStack* result = NULL;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->placeholder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->no_entries_label;
	_tmp1_ = text;
	gtk_label_set_label (_tmp0_, _tmp1_);
}


void tweet_list_box_reset_placeholder_text (TweetListBox* self) {
	GtkLabel* _tmp0_;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->no_entries_label;
	gtk_label_set_label (_tmp0_, _ ("No entries found"));
}


static void __lambda20_ (TweetListBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp0_);
}


static void ___lambda20__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda20_ ((TweetListBox*) self, widget);
}


void tweet_list_box_remove_all (TweetListBox* self) {
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), ___lambda20__gtk_callback, self);
}


GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self) {
	GtkWidget* result = NULL;
	gint i = 0;
	GtkWidget* row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	i = 0;
	_tmp0_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), 0);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	row = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GtkWidget* _tmp3_;
		gint _tmp7_;
		gint _tmp8_;
		GtkListBoxRow* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp3_ = row;
		if (_tmp3_ != NULL) {
			GtkWidget* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp4_ = row;
			_tmp5_ = gtk_widget_get_visible (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = i;
		_tmp9_ = gtk_list_box_get_row_at_index (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), _tmp8_);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (row);
		row = _tmp10_;
	}
	result = row;
	return result;
}


TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self) {
	TweetListEntry* result;
	TweetListEntry* _tmp0_;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->_action_entry;
	result = _tmp0_;
	return result;
}


static void _tweet_list_box_gesture_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	tweet_list_box_gesture_pressed_cb ((TweetListBox*) self, p0, p1, p2);
}


static GtkWidget* _tweet_list_box_widget_create_func_gtk_list_box_create_widget_func (GObject* item, gpointer self) {
	GtkWidget* result;
	result = tweet_list_box_widget_create_func ((TweetListBox*) self, item);
	return result;
}


static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TweetListBox * self;
	GtkGestureMultiPress* _tmp0_;
	GtkGestureMultiPress* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	GtkGestureMultiPress* _tmp3_;
	CbDeltaUpdater* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	CbTweetModel* _tmp7_;
	parent_class = G_OBJECT_CLASS (tweet_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	tweet_list_box_add_placeholder (self);
	gtk_list_box_set_selection_mode (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), GTK_SELECTION_NONE);
	_tmp0_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->press_gesture);
	self->priv->press_gesture = _tmp0_;
	_tmp1_ = self->priv->press_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp2_ = self->priv->press_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_BUBBLE);
	_tmp3_ = self->priv->press_gesture;
	g_signal_connect_object (_tmp3_, "pressed", (GCallback) _tweet_list_box_gesture_pressed_cb_gtk_gesture_multi_press_pressed, self, 0);
	_tmp4_ = cb_delta_updater_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->delta_updater);
	self->delta_updater = _tmp4_;
	_tmp5_ = settings_get ();
	_tmp6_ = _tmp5_;
	g_settings_bind (_tmp6_, "double-click-activation", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "activate-on-single-click", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->model;
	cb_utils_bind_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_list_model_get_type (), GListModel), _tweet_list_box_widget_create_func_gtk_list_box_create_widget_func, self);
	return obj;
}


static void tweet_list_box_class_init (TweetListBoxClass * klass) {
	tweet_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_box_get_property;
	G_OBJECT_CLASS (klass)->constructor = tweet_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_BOX_ACTION_ENTRY_PROPERTY, tweet_list_box_properties[TWEET_LIST_BOX_ACTION_ENTRY_PROPERTY] = g_param_spec_object ("action-entry", "action-entry", "action-entry", TYPE_TWEET_LIST_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	tweet_list_box_signals[TWEET_LIST_BOX_RETRY_BUTTON_CLICKED_SIGNAL] = g_signal_new ("retry-button-clicked", TYPE_TWEET_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tweet_list_box_instance_init (TweetListBox * self) {
	CbTweetModel* _tmp0_;
	self->priv = TWEET_LIST_BOX_GET_PRIVATE (self);
	self->priv->placeholder = NULL;
	_tmp0_ = cb_tweet_model_new ();
	self->model = _tmp0_;
}


static void tweet_list_box_finalize (GObject * obj) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->no_entries_label);
	_g_object_unref0 (self->priv->error_box);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->retry_button);
	_g_object_unref0 (self->priv->_action_entry);
	_g_object_unref0 (self->delta_updater);
	_g_object_unref0 (self->model);
	_g_object_unref0 (self->priv->press_gesture);
	G_OBJECT_CLASS (tweet_list_box_parent_class)->finalize (obj);
}


GType tweet_list_box_get_type (void) {
	static volatile gsize tweet_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListBox), 0, (GInstanceInitFunc) tweet_list_box_instance_init, NULL };
		GType tweet_list_box_type_id;
		tweet_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "TweetListBox", &g_define_type_info, 0);
		g_once_init_leave (&tweet_list_box_type_id__volatile, tweet_list_box_type_id);
	}
	return tweet_list_box_type_id__volatile;
}


static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_BOX, TweetListBox);
	switch (property_id) {
		case TWEET_LIST_BOX_ACTION_ENTRY_PROPERTY:
		g_value_set_object (value, tweet_list_box_get_action_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



