/* AddImageButton.c generated by valac 0.38.7, the Vala compiler
 * generated from AddImageButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_ADD_IMAGE_BUTTON (add_image_button_get_type ())
#define ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButton))
#define ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))
#define IS_ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IMAGE_BUTTON))
#define IS_ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IMAGE_BUTTON))
#define ADD_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))

typedef struct _AddImageButton AddImageButton;
typedef struct _AddImageButtonClass AddImageButtonClass;
typedef struct _AddImageButtonPrivate AddImageButtonPrivate;
enum  {
	ADD_IMAGE_BUTTON_0_PROPERTY,
	ADD_IMAGE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* add_image_button_properties[ADD_IMAGE_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ADD_IMAGE_BUTTON_DELETED_SIGNAL,
	ADD_IMAGE_BUTTON_NUM_SIGNALS
};
static guint add_image_button_signals[ADD_IMAGE_BUTTON_NUM_SIGNALS] = {0};

struct _AddImageButton {
	GtkWidget parent_instance;
	AddImageButtonPrivate * priv;
	gchar* image_path;
	cairo_surface_t* surface;
};

struct _AddImageButtonClass {
	GtkWidgetClass parent_class;
};

struct _AddImageButtonPrivate {
	gdouble delete_factor;
	guint64 delete_transition_start;
};


static gpointer add_image_button_parent_class = NULL;

GType add_image_button_get_type (void) G_GNUC_CONST;
#define ADD_IMAGE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADD_IMAGE_BUTTON, AddImageButtonPrivate))
#define ADD_IMAGE_BUTTON_MIN_WIDTH 40
#define ADD_IMAGE_BUTTON_MAX_HEIGHT 150
#define ADD_IMAGE_BUTTON_MIN_HEIGHT 100
#define ADD_IMAGE_BUTTON_ICON_SIZE 32
void add_image_button_get_draw_size (AddImageButton* self, gint* width, gint* height, gdouble* scale);
static gboolean add_image_button_real_draw (GtkWidget* base, cairo_t* ct);
static GtkSizeRequestMode add_image_button_real_get_request_mode (GtkWidget* base);
static void add_image_button_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural);
static void add_image_button_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum, gint* natural);
static void add_image_button_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void add_image_button_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static gboolean add_image_button_delete_tick_cb (AddImageButton* self, GtkWidget* widget, GdkFrameClock* frame_clock);
#define TRANSITION_DURATION (200 * 1000)
gdouble ease_out_cubic (gdouble t);
void add_image_button_start_remove (AddImageButton* self);
static gboolean _add_image_button_delete_tick_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
AddImageButton* add_image_button_new (void);
AddImageButton* add_image_button_construct (GType object_type);
static GObject * add_image_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void add_image_button_finalize (GObject * obj);


void add_image_button_get_draw_size (AddImageButton* self, gint* width, gint* height, gdouble* scale) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gdouble _vala_scale = 0.0;
	cairo_surface_t* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble scale_x = 0.0;
	gint _tmp3_;
	cairo_surface_t* _tmp4_;
	gint _tmp5_;
	gdouble scale_y = 0.0;
	gint _tmp6_;
	cairo_surface_t* _tmp7_;
	gint _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_surface_t* _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	cairo_surface_t* _tmp17_;
	gint _tmp18_;
	gdouble _tmp19_;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	_tmp0_ = self->surface;
	if (_tmp0_ == NULL) {
		_vala_width = 0;
		_vala_height = 0;
		_vala_scale = 0.0;
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		if (scale) {
			*scale = _vala_scale;
		}
		return;
	}
	_tmp1_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_vala_width = _tmp1_;
	_tmp2_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_vala_height = _tmp2_;
	_tmp3_ = _vala_width;
	_tmp4_ = self->surface;
	_tmp5_ = cairo_image_surface_get_width (_tmp4_);
	scale_x = ((gdouble) _tmp3_) / _tmp5_;
	_tmp6_ = _vala_height;
	_tmp7_ = self->surface;
	_tmp8_ = cairo_image_surface_get_height (_tmp7_);
	scale_y = ((gdouble) _tmp6_) / _tmp8_;
	_tmp9_ = scale_x;
	_tmp10_ = scale_y;
	_tmp11_ = MIN (_tmp9_, _tmp10_);
	_tmp12_ = MIN (_tmp11_, 1.0);
	_tmp13_ = self->priv->delete_factor;
	_vala_scale = _tmp12_ * _tmp13_;
	_tmp14_ = self->surface;
	_tmp15_ = cairo_image_surface_get_width (_tmp14_);
	_tmp16_ = _vala_scale;
	_vala_width = (gint) (_tmp15_ * _tmp16_);
	_tmp17_ = self->surface;
	_tmp18_ = cairo_image_surface_get_height (_tmp17_);
	_tmp19_ = _vala_scale;
	_vala_height = (gint) (_tmp18_ * _tmp19_);
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	if (scale) {
		*scale = _vala_scale;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean add_image_button_real_draw (GtkWidget* base, cairo_t* ct) {
	AddImageButton * self;
	gboolean result = FALSE;
	gint widget_width = 0;
	gint _tmp0_;
	gint widget_height = 0;
	gint _tmp1_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	cairo_surface_t* _tmp4_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style_context = _tmp3_;
	_tmp4_ = self->surface;
	if (_tmp4_ != NULL) {
		cairo_t* _tmp5_;
		cairo_t* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint draw_width = 0;
		gint draw_height = 0;
		gdouble scale = 0.0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gdouble _tmp11_ = 0.0;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		cairo_t* _tmp21_;
		GtkStyleContext* _tmp22_;
		cairo_t* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp5_ = ct;
		cairo_save (_tmp5_);
		_tmp6_ = ct;
		_tmp7_ = widget_width;
		_tmp8_ = widget_height;
		cairo_rectangle (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp7_, (gdouble) _tmp8_);
		add_image_button_get_draw_size (self, &_tmp9_, &_tmp10_, &_tmp11_);
		draw_width = _tmp9_;
		draw_height = _tmp10_;
		scale = _tmp11_;
		_tmp13_ = draw_width;
		if (_tmp13_ > 0) {
			gint _tmp14_;
			_tmp14_ = draw_height;
			_tmp12_ = _tmp14_ > 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			cairo_t* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			cairo_t* _tmp18_;
			cairo_surface_t* _tmp19_;
			cairo_t* _tmp20_;
			_tmp15_ = ct;
			_tmp16_ = scale;
			_tmp17_ = scale;
			cairo_scale (_tmp15_, _tmp16_, _tmp17_);
			_tmp18_ = ct;
			_tmp19_ = self->surface;
			cairo_set_source_surface (_tmp18_, _tmp19_, (gdouble) 0, (gdouble) 0);
			_tmp20_ = ct;
			cairo_fill (_tmp20_);
		}
		_tmp21_ = ct;
		cairo_restore (_tmp21_);
		_tmp22_ = style_context;
		_tmp23_ = ct;
		_tmp24_ = draw_width;
		_tmp25_ = draw_height;
		gtk_render_check (_tmp22_, _tmp23_, (_tmp24_ / 2.0) - (ADD_IMAGE_BUTTON_ICON_SIZE / 2.0), (_tmp25_ / 2.0) - (ADD_IMAGE_BUTTON_ICON_SIZE / 2.0), (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE, (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE);
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (style_context);
	return result;
}


static GtkSizeRequestMode add_image_button_real_get_request_mode (GtkWidget* base) {
	AddImageButton * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void add_image_button_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural) {
	AddImageButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	gint media_height = 0;
	cairo_surface_t* _tmp0_;
	gdouble width_ratio = 0.0;
	gint _tmp5_;
	gint _tmp6_;
	gint height = 0;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gdouble _tmp13_;
	gint _tmp14_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_tmp0_ = self->surface;
	if (_tmp0_ == NULL) {
		media_width = ADD_IMAGE_BUTTON_MIN_WIDTH;
		media_height = ADD_IMAGE_BUTTON_MAX_HEIGHT;
	} else {
		cairo_surface_t* _tmp1_;
		gint _tmp2_;
		cairo_surface_t* _tmp3_;
		gint _tmp4_;
		_tmp1_ = self->surface;
		_tmp2_ = cairo_image_surface_get_width (_tmp1_);
		media_width = _tmp2_;
		_tmp3_ = self->surface;
		_tmp4_ = cairo_image_surface_get_height (_tmp3_);
		media_height = _tmp4_;
	}
	_tmp5_ = width;
	_tmp6_ = media_width;
	width_ratio = ((gdouble) _tmp5_) / ((gdouble) _tmp6_);
	_tmp7_ = media_height;
	_tmp8_ = media_height;
	_tmp9_ = MIN (_tmp7_, (gint) (_tmp8_ * width_ratio));
	height = _tmp9_;
	_tmp10_ = height;
	_tmp11_ = MIN (ADD_IMAGE_BUTTON_MAX_HEIGHT, _tmp10_);
	height = _tmp11_;
	_vala_minimum = ADD_IMAGE_BUTTON_MIN_HEIGHT;
	_tmp12_ = height;
	_tmp13_ = self->priv->delete_factor;
	_tmp14_ = MAX (_vala_minimum, (gint) (_tmp12_ * _tmp13_));
	_vala_natural = _tmp14_;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void add_image_button_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum, gint* natural) {
	AddImageButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	gint media_height = 0;
	cairo_surface_t* _tmp0_;
	gdouble height_ratio = 0.0;
	gint _tmp5_;
	gint _tmp6_;
	gint width = 0;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gdouble _tmp13_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_tmp0_ = self->surface;
	if (_tmp0_ == NULL) {
		media_width = ADD_IMAGE_BUTTON_MIN_WIDTH;
		media_height = ADD_IMAGE_BUTTON_MAX_HEIGHT;
	} else {
		cairo_surface_t* _tmp1_;
		gint _tmp2_;
		cairo_surface_t* _tmp3_;
		gint _tmp4_;
		_tmp1_ = self->surface;
		_tmp2_ = cairo_image_surface_get_width (_tmp1_);
		media_width = _tmp2_;
		_tmp3_ = self->surface;
		_tmp4_ = cairo_image_surface_get_height (_tmp3_);
		media_height = _tmp4_;
	}
	_tmp5_ = height;
	_tmp6_ = media_height;
	height_ratio = ((gdouble) _tmp5_) / ((gdouble) _tmp6_);
	_tmp7_ = media_width;
	_tmp8_ = media_width;
	_tmp9_ = MIN (_tmp7_, (gint) (_tmp8_ * height_ratio));
	width = _tmp9_;
	_tmp10_ = width;
	_tmp11_ = MAX (ADD_IMAGE_BUTTON_MIN_WIDTH, _tmp10_);
	width = _tmp11_;
	_tmp12_ = width;
	_tmp13_ = self->priv->delete_factor;
	_vala_natural = (gint) (_tmp12_ * _tmp13_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void add_image_button_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	AddImageButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_width = 0;
	cairo_surface_t* _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_tmp0_ = self->surface;
	if (_tmp0_ == NULL) {
		media_width = 1;
	} else {
		cairo_surface_t* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->surface;
		_tmp2_ = cairo_image_surface_get_width (_tmp1_);
		media_width = _tmp2_;
	}
	_tmp3_ = media_width;
	_tmp4_ = MIN (_tmp3_, ADD_IMAGE_BUTTON_MIN_WIDTH);
	_tmp5_ = self->priv->delete_factor;
	_vala_minimum = (gint) (_tmp4_ * _tmp5_);
	_tmp6_ = media_width;
	_tmp7_ = self->priv->delete_factor;
	_vala_natural = (gint) (_tmp6_ * _tmp7_);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void add_image_button_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	AddImageButton * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint media_height = 0;
	cairo_surface_t* _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_tmp0_ = self->surface;
	if (_tmp0_ == NULL) {
		media_height = 1;
	} else {
		cairo_surface_t* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->surface;
		_tmp2_ = cairo_image_surface_get_height (_tmp1_);
		media_height = _tmp2_;
	}
	_tmp3_ = media_height;
	_tmp4_ = MIN (_tmp3_, ADD_IMAGE_BUTTON_MIN_HEIGHT);
	_tmp5_ = self->priv->delete_factor;
	_vala_minimum = (gint) (_tmp4_ * _tmp5_);
	_tmp6_ = media_height;
	_tmp7_ = self->priv->delete_factor;
	_vala_natural = (gint) (_tmp6_ * _tmp7_);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static gboolean add_image_button_delete_tick_cb (AddImageButton* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	guint64 now = 0ULL;
	GdkFrameClock* _tmp0_;
	gint64 _tmp1_;
	gdouble t = 0.0;
	guint64 _tmp2_;
	guint64 _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_val_if_fail (IS_ADD_IMAGE_BUTTON (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = (guint64) _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->delete_transition_start;
	t = (_tmp2_ - _tmp3_) / ((gdouble) (TRANSITION_DURATION * 1));
	_tmp4_ = t;
	_tmp5_ = ease_out_cubic (_tmp4_);
	t = _tmp5_;
	_tmp6_ = t;
	self->priv->delete_factor = 1.0 - _tmp6_;
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = t;
	if (_tmp7_ >= 1.0) {
		self->priv->delete_factor = 1.0;
		g_signal_emit (self, add_image_button_signals[ADD_IMAGE_BUTTON_DELETED_SIGNAL], 0);
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean _add_image_button_delete_tick_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = add_image_button_delete_tick_cb ((AddImageButton*) self, widget, frame_clock);
	return result;
}


void add_image_button_start_remove (AddImageButton* self) {
	gboolean _tmp0_;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	self->priv->delete_transition_start = (guint64) _tmp2_;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _add_image_button_delete_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}


AddImageButton* add_image_button_construct (GType object_type) {
	AddImageButton * self = NULL;
	self = (AddImageButton*) gtk_widget_new (object_type, NULL);
	return self;
}


AddImageButton* add_image_button_new (void) {
	return add_image_button_construct (TYPE_ADD_IMAGE_BUTTON);
}


static GObject * add_image_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AddImageButton * self;
	parent_class = G_OBJECT_CLASS (add_image_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void add_image_button_class_init (AddImageButtonClass * klass) {
	add_image_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AddImageButtonPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) add_image_button_real_draw;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) add_image_button_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) add_image_button_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget *, gint, gint*, gint*)) add_image_button_real_get_preferred_width_for_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) add_image_button_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget *, gint*, gint*)) add_image_button_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->constructor = add_image_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = add_image_button_finalize;
	add_image_button_signals[ADD_IMAGE_BUTTON_DELETED_SIGNAL] = g_signal_new ("deleted", TYPE_ADD_IMAGE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void add_image_button_instance_init (AddImageButton * self) {
	self->priv = ADD_IMAGE_BUTTON_GET_PRIVATE (self);
	self->priv->delete_factor = 1.0;
}


static void add_image_button_finalize (GObject * obj) {
	AddImageButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_g_free0 (self->image_path);
	_cairo_surface_destroy0 (self->surface);
	G_OBJECT_CLASS (add_image_button_parent_class)->finalize (obj);
}


GType add_image_button_get_type (void) {
	static volatile gsize add_image_button_type_id__volatile = 0;
	if (g_once_init_enter (&add_image_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AddImageButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_image_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddImageButton), 0, (GInstanceInitFunc) add_image_button_instance_init, NULL };
		GType add_image_button_type_id;
		add_image_button_type_id = g_type_register_static (gtk_widget_get_type (), "AddImageButton", &g_define_type_info, 0);
		g_once_init_leave (&add_image_button_type_id__volatile, add_image_button_type_id);
	}
	return add_image_button_type_id__volatile;
}



