/* TweetListEntry.c generated by valac 0.38.7, the Vala compiler
 * generated from TweetListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTwitterItem.h"
#include "CbTweet.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "CbTextTransform.h"
#include "CbUtils.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbMedia.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "CbBundle.h"
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <pango/pango.h>


#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_DOUBLE_TAP_BUTTON (double_tap_button_get_type ())
#define DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButton))
#define DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))
#define IS_DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOUBLE_TAP_BUTTON))
#define IS_DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOUBLE_TAP_BUTTON))
#define DOUBLE_TAP_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))

typedef struct _DoubleTapButton DoubleTapButton;
typedef struct _DoubleTapButtonClass DoubleTapButtonClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	TWEET_LIST_ENTRY_0_PROPERTY,
	TWEET_LIST_ENTRY_READ_ONLY_PROPERTY,
	TWEET_LIST_ENTRY_SHOWS_ACTIONS_PROPERTY,
	TWEET_LIST_ENTRY_NUM_PROPERTIES
};
static GParamSpec* tweet_list_entry_properties[TWEET_LIST_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;

#define TYPE_MEDIA_VISIBILITY (media_visibility_get_type ())
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block62Data Block62Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block63Data Block63Data;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
enum  {
	TWEET_LIST_ENTRY_REPLY_TWEET_SIGNAL,
	TWEET_LIST_ENTRY_FAVORITE_TWEET_SIGNAL,
	TWEET_LIST_ENTRY_RETWEET_TWEET_SIGNAL,
	TWEET_LIST_ENTRY_DELETE_TWEET_SIGNAL,
	TWEET_LIST_ENTRY_QUOTE_TWEET_SIGNAL,
	TWEET_LIST_ENTRY_NUM_SIGNALS
};
static guint tweet_list_entry_signals[TWEET_LIST_ENTRY_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _TweetListEntryPrivate {
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* rt_label;
	GtkImage* rt_image;
	GtkImage* rt_status_image;
	GtkImage* fav_status_image;
	DoubleTapButton* retweet_button;
	GtkToggleButton* favorite_button;
	GtkGrid* grid;
	GtkStack* stack;
	GtkBox* action_box;
	GtkLabel* reply_label;
	GtkLabel* quote_label;
	TextButton* quote_name;
	GtkLabel* quote_time_delta;
	GtkLabel* quote_screen_name;
	GtkLabel* quote_reply_label;
	GtkGrid* quote_grid;
	GtkStack* media_stack;
	MultiMediaWidget* mm_widget;
	gboolean _read_only;
	Account* account;
	MainWindow* main_window;
	gboolean values_set;
	gboolean delete_first_activated;
	GTimeSpan last_timediff;
	gint64 start_time;
	gint64 end_time;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	gboolean restrict_height;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	MEDIA_VISIBILITY_SHOW = 1,
	MEDIA_VISIBILITY_HIDE = 2,
	MEDIA_VISIBILITY_HIDE_IN_TIMELINES = 3
} MediaVisibility;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block62Data {
	int _ref_count_;
	TweetListEntry* self;
	gchar* link_text;
};

struct _Block63Data {
	int _ref_count_;
	TweetListEntry* self;
	gulong realize_id;
};


static gpointer tweet_list_entry_parent_class = NULL;
static CbTwitterItemInterface * tweet_list_entry_cb_twitter_item_parent_iface = NULL;

GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType double_tap_button_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_ENTRY, TweetListEntryPrivate))
GSettings* settings_get (void);
static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_hide_nsfw_content_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_media_visibility_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_media_visibility_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_quote_activated (TweetListEntry* self);
static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_list_entry_delete_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void text_button_set_markup (TextButton* self, const gchar* text);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
CbTransformFlags settings_get_text_transform_flags (void);
static void tweet_list_entry_create_quote_grid (TweetListEntry* self, gboolean reply);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void tweet_list_entry_state_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_state_changed_cb_cb_tweet_state_changed (CbTweet* _sender, gpointer self);
static void tweet_list_entry_create_media_widget (TweetListEntry* self, gboolean nsfw);
void multi_media_widget_set_all_media (MultiMediaWidget* self, CbMedia** medias, int medias_length1);
static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, CbMedia* m, gint index, gdouble px, gdouble py);
static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gdouble px, gdouble py, gpointer self);
static void tweet_list_entry_media_invalid_cb (TweetListEntry* self);
static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self);
GType media_visibility_get_type (void) G_GNUC_CONST;
MediaVisibility settings_get_media_visiblity (void);
static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self);
static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self);
static void _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda187_ (TweetListEntry* self);
static void ___lambda187__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda188_ (TweetListEntry* self);
void double_tap_button_tap (DoubleTapButton* self);
static void ___lambda188__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self);
gboolean settings_hide_nsfw_content (void);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py);
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void ___lambda186_ (TweetListEntry* self);
static void ____lambda186__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt);
void double_tap_button_reset (DoubleTapButton* self);
static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt);
static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static void __lambda189_ (TweetListEntry* self);
static void ___lambda189__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static void __lambda190_ (TweetListEntry* self);
static void ___lambda190__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self);
#define PROFILE_PAGE_KEY_USER_ID 1
#define PROFILE_PAGE_KEY_SCREEN_NAME 0
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self);
static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_show_media_clicked_cb (TweetListEntry* self);
static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static void ___lambda185_ (Block62Data* _data62_);
CbFilter* utils_create_persistent_filter (const gchar* content, Account* account);
void main_window_rerun_filters (MainWindow* self);
static void ____lambda185__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self);
void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static gint tweet_list_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
static gint64 tweet_list_entry_real_get_sort_factor (CbTwitterItem* base);
static gint64 tweet_list_entry_real_get_timestamp (CbTwitterItem* base);
static GTimeSpan tweet_list_entry_real_get_last_set_timediff (CbTwitterItem* base);
static void tweet_list_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span);
static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock);
gdouble ease_out_cubic (gdouble t);
void tweet_list_entry_fade_in (TweetListEntry* self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static void __lambda18_ (Block63Data* _data63_);
#define TRANSITION_DURATION (200 * 1000)
static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void ___lambda18__gtk_widget_realize (GtkWidget* _sender, gpointer self);
MultiMediaWidget* multi_media_widget_new (void);
MultiMediaWidget* multi_media_widget_construct (GType object_type);
static void _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_list_entry_quote_link_activated_cb (TweetListEntry* self, const gchar* uri);
TextButton* text_button_new (void);
TextButton* text_button_construct (GType object_type);
static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
static void tweet_list_entry_finalize (GObject * obj);
static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_LIST_ENTRY_action_entries[2] = {{"quote", _tweet_list_entry_quote_activated_gsimple_action_activate_callback}, {"delete", _tweet_list_entry_delete_activated_gsimple_action_activate_callback}};

static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_transform_flags_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_hide_nsfw_content_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_visibility_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_media_visibility_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_delete_activated ((TweetListEntry*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch76_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch76_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally76;
	__catch76_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally76:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _tweet_list_entry_state_changed_cb_cb_tweet_state_changed (CbTweet* _sender, gpointer self) {
	tweet_list_entry_state_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gdouble px, gdouble py, gpointer self) {
	tweet_list_entry_media_clicked_cb ((TweetListEntry*) self, m, index, px, py);
}


static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self) {
	tweet_list_entry_media_invalid_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_reply_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_delete_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void __lambda187_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = self->priv->favorite_button;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, !_tmp3_);
}


static void ___lambda187__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda187_ ((TweetListEntry*) self);
}


static void __lambda188_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_tap (_tmp0_);
}


static void ___lambda188__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda188_ ((TweetListEntry*) self);
}


TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height) {
	TweetListEntry * self = NULL;
	Account* _tmp0_;
	CbTweet* _tmp1_;
	CbTweet* _tmp2_;
	MainWindow* _tmp3_;
	TextButton* _tmp4_;
	CbTweet* _tmp5_;
	const gchar* _tmp6_;
	GtkLabel* _tmp7_;
	CbTweet* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	CbTweet* _tmp12_;
	const gchar* _tmp13_;
	AvatarWidget* _tmp27_;
	CbTweet* _tmp28_;
	gboolean _tmp29_;
	GtkLabel* _tmp30_;
	CbTweet* _tmp31_;
	CbTransformFlags _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	CbTweet* _tmp37_;
	CbMiniTweet* _tmp38_;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	CbTweet* _tmp74_;
	CbMiniTweet* _tmp75_;
	CbTweet* _tmp93_;
	CbMiniTweet* _tmp94_;
	DoubleTapButton* _tmp130_;
	CbTweet* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_ = FALSE;
	CbTweet* _tmp134_;
	gboolean _tmp135_;
	DoubleTapButton* _tmp140_;
	GtkToggleButton* _tmp141_;
	CbTweet* _tmp142_;
	gboolean _tmp143_;
	CbTweet* _tmp144_;
	CbTweet* _tmp145_;
	gboolean _tmp146_;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp180_;
	GSimpleActionGroup* _tmp181_;
	GSimpleActionGroup* _tmp182_;
	CbTweet* _tmp183_;
	gint64 _tmp184_;
	Account* _tmp185_;
	gint64 _tmp186_;
	CbTweet* _tmp189_;
	gboolean _tmp190_;
	CbTweet* _tmp193_;
	gboolean _tmp194_;
	CbTweet* _tmp196_;
	gboolean _tmp197_;
	GSettings* _tmp199_;
	GSettings* _tmp200_;
	g_return_val_if_fail (CB_IS_TWEET (tweet), NULL);
	g_return_val_if_fail ((main_window == NULL) || IS_MAIN_WINDOW (main_window), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->tweet);
	self->tweet = _tmp2_;
	_tmp3_ = main_window;
	self->priv->main_window = _tmp3_;
	_tmp4_ = self->priv->name_button;
	_tmp5_ = tweet;
	_tmp6_ = cb_tweet_get_user_name (_tmp5_);
	text_button_set_markup (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->screen_name_label;
	_tmp8_ = tweet;
	_tmp9_ = cb_tweet_get_screen_name (_tmp8_);
	_tmp10_ = g_strconcat ("@", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = tweet;
	_tmp13_ = _tmp12_->avatar_url;
	if (_tmp13_ != NULL) {
		gchar* avatar_url = NULL;
		CbTweet* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gint _tmp17_;
		Twitter* _tmp20_;
		Twitter* _tmp21_;
		CbTweet* _tmp22_;
		gint64 _tmp23_;
		const gchar* _tmp24_;
		AvatarWidget* _tmp25_;
		gint _tmp26_;
		_tmp14_ = tweet;
		_tmp15_ = _tmp14_->avatar_url;
		_tmp16_ = g_strdup (_tmp15_);
		avatar_url = _tmp16_;
		_tmp17_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		if (_tmp17_ == 2) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = avatar_url;
			_tmp19_ = string_replace (_tmp18_, "_normal", "_bigger");
			_g_free0 (avatar_url);
			avatar_url = _tmp19_;
		}
		_tmp20_ = twitter_get ();
		_tmp21_ = _tmp20_;
		_tmp22_ = tweet;
		_tmp23_ = cb_tweet_get_user_id (_tmp22_);
		_tmp24_ = avatar_url;
		_tmp25_ = self->priv->avatar_image;
		_tmp26_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		twitter_get_avatar (_tmp21_, _tmp23_, _tmp24_, _tmp25_, 48 * _tmp26_, FALSE, NULL, NULL);
		_g_object_unref0 (_tmp21_);
		_g_free0 (avatar_url);
	}
	_tmp27_ = self->priv->avatar_image;
	_tmp28_ = tweet;
	_tmp29_ = cb_tweet_is_flag_set (_tmp28_, (guint) CB_TWEET_STATE_VERIFIED);
	avatar_widget_set_verified (_tmp27_, _tmp29_);
	_tmp30_ = self->priv->text_label;
	_tmp31_ = tweet;
	_tmp32_ = settings_get_text_transform_flags ();
	_tmp33_ = cb_tweet_get_trimmed_text (_tmp31_, (guint) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = string_strip (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_label_set_label (_tmp30_, _tmp36_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_tmp37_ = tweet;
	_tmp38_ = _tmp37_->retweeted_tweet;
	if (_tmp38_ != NULL) {
		GtkLabel* _tmp39_;
		GtkImage* _tmp40_;
		GString* buff = NULL;
		GString* _tmp41_;
		GString* _tmp42_;
		GString* _tmp43_;
		CbTweet* _tmp44_;
		CbMiniTweet _tmp45_;
		CbUserIdentity _tmp46_;
		gint64 _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		GString* _tmp50_;
		GString* _tmp51_;
		CbTweet* _tmp52_;
		CbMiniTweet _tmp53_;
		CbUserIdentity _tmp54_;
		const gchar* _tmp55_;
		GString* _tmp56_;
		GString* _tmp57_;
		CbTweet* _tmp58_;
		CbMiniTweet _tmp59_;
		CbUserIdentity _tmp60_;
		const gchar* _tmp61_;
		GString* _tmp62_;
		GString* _tmp63_;
		CbTweet* _tmp64_;
		CbMiniTweet _tmp65_;
		CbUserIdentity _tmp66_;
		const gchar* _tmp67_;
		GString* _tmp68_;
		GtkLabel* _tmp69_;
		GString* _tmp70_;
		const gchar* _tmp71_;
		_tmp39_ = self->priv->rt_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
		_tmp40_ = self->priv->rt_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget));
		_tmp41_ = g_string_new ("");
		buff = _tmp41_;
		_tmp42_ = buff;
		_tmp43_ = g_string_append (_tmp42_, "<span underline='none'><a href=\"@");
		_tmp44_ = tweet;
		_tmp45_ = _tmp44_->source_tweet;
		_tmp46_ = _tmp45_.author;
		_tmp47_ = _tmp46_.id;
		_tmp48_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_string_append (_tmp43_, _tmp49_);
		_tmp51_ = g_string_append (_tmp50_, "/@");
		_tmp52_ = tweet;
		_tmp53_ = _tmp52_->source_tweet;
		_tmp54_ = _tmp53_.author;
		_tmp55_ = _tmp54_.screen_name;
		_tmp56_ = g_string_append (_tmp51_, _tmp55_);
		_tmp57_ = g_string_append (_tmp56_, "\" title=\"@");
		_tmp58_ = tweet;
		_tmp59_ = _tmp58_->source_tweet;
		_tmp60_ = _tmp59_.author;
		_tmp61_ = _tmp60_.screen_name;
		_tmp62_ = g_string_append (_tmp57_, _tmp61_);
		_tmp63_ = g_string_append (_tmp62_, "\">");
		_tmp64_ = tweet;
		_tmp65_ = _tmp64_->source_tweet;
		_tmp66_ = _tmp65_.author;
		_tmp67_ = _tmp66_.user_name;
		_tmp68_ = g_string_append (_tmp63_, _tmp67_);
		g_string_append (_tmp68_, "</a></span>");
		_g_free0 (_tmp49_);
		_tmp69_ = self->priv->rt_label;
		_tmp70_ = buff;
		_tmp71_ = _tmp70_->str;
		gtk_label_set_label (_tmp69_, _tmp71_);
		_g_string_free0 (buff);
	}
	_tmp74_ = tweet;
	_tmp75_ = _tmp74_->retweeted_tweet;
	if (_tmp75_ != NULL) {
		CbTweet* _tmp76_;
		CbMiniTweet* _tmp77_;
		gint64 _tmp78_;
		_tmp76_ = tweet;
		_tmp77_ = _tmp76_->retweeted_tweet;
		_tmp78_ = (*_tmp77_).reply_id;
		_tmp73_ = _tmp78_ != ((gint64) 0);
	} else {
		_tmp73_ = FALSE;
	}
	if (_tmp73_) {
		_tmp72_ = TRUE;
	} else {
		CbTweet* _tmp79_;
		CbMiniTweet _tmp80_;
		gint64 _tmp81_;
		_tmp79_ = tweet;
		_tmp80_ = _tmp79_->source_tweet;
		_tmp81_ = _tmp80_.reply_id;
		_tmp72_ = _tmp81_ != ((gint64) 0);
	}
	if (_tmp72_) {
		GString* buff = NULL;
		GString* _tmp82_;
		CbTweet* _tmp83_;
		CbMiniTweet* _tmp84_;
		GtkLabel* _tmp89_;
		GString* _tmp90_;
		const gchar* _tmp91_;
		GtkLabel* _tmp92_;
		_tmp82_ = g_string_new ("");
		buff = _tmp82_;
		_tmp83_ = tweet;
		_tmp84_ = _tmp83_->retweeted_tweet;
		if (_tmp84_ != NULL) {
			CbTweet* _tmp85_;
			GString* _tmp86_;
			_tmp85_ = tweet;
			_tmp86_ = buff;
			cb_utils_write_reply_text (_tmp85_->retweeted_tweet, _tmp86_);
		} else {
			CbTweet* _tmp87_;
			GString* _tmp88_;
			_tmp87_ = tweet;
			_tmp88_ = buff;
			cb_utils_write_reply_text (&_tmp87_->source_tweet, _tmp88_);
		}
		_tmp89_ = self->priv->reply_label;
		_tmp90_ = buff;
		_tmp91_ = _tmp90_->str;
		gtk_label_set_label (_tmp89_, _tmp91_);
		_tmp92_ = self->priv->reply_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_widget_get_type (), GtkWidget));
		_g_string_free0 (buff);
	}
	_tmp93_ = tweet;
	_tmp94_ = _tmp93_->quoted_tweet;
	if (_tmp94_ != NULL) {
		CbTweet* _tmp95_;
		CbMiniTweet* _tmp96_;
		gint64 _tmp97_;
		GtkLabel* _tmp98_;
		CbTweet* _tmp99_;
		CbTransformFlags _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		GtkLabel* _tmp103_;
		const gchar* _tmp104_;
		const gchar* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		TextButton* _tmp109_;
		CbTweet* _tmp110_;
		CbMiniTweet* _tmp111_;
		CbUserIdentity _tmp112_;
		const gchar* _tmp113_;
		GtkLabel* _tmp114_;
		CbTweet* _tmp115_;
		CbMiniTweet* _tmp116_;
		CbUserIdentity _tmp117_;
		const gchar* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		CbTweet* _tmp121_;
		CbMiniTweet* _tmp122_;
		gint64 _tmp123_;
		_tmp95_ = tweet;
		_tmp96_ = _tmp95_->quoted_tweet;
		_tmp97_ = (*_tmp96_).reply_id;
		tweet_list_entry_create_quote_grid (self, _tmp97_ != ((gint64) 0));
		_tmp98_ = self->priv->quote_label;
		_tmp99_ = tweet;
		_tmp100_ = settings_get_text_transform_flags ();
		_tmp101_ = cb_text_transform_tweet (_tmp99_->quoted_tweet, (guint) _tmp100_, (gint64) 0);
		_tmp102_ = _tmp101_;
		gtk_label_set_label (_tmp98_, _tmp102_);
		_g_free0 (_tmp102_);
		_tmp103_ = self->priv->quote_label;
		_tmp104_ = gtk_label_get_label (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = strlen (_tmp105_);
		_tmp107_ = _tmp106_;
		if (_tmp107_ == 0) {
			GtkLabel* _tmp108_;
			_tmp108_ = self->priv->quote_label;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp109_ = self->priv->quote_name;
		_tmp110_ = tweet;
		_tmp111_ = _tmp110_->quoted_tweet;
		_tmp112_ = (*_tmp111_).author;
		_tmp113_ = _tmp112_.user_name;
		text_button_set_markup (_tmp109_, _tmp113_);
		_tmp114_ = self->priv->quote_screen_name;
		_tmp115_ = tweet;
		_tmp116_ = _tmp115_->quoted_tweet;
		_tmp117_ = (*_tmp116_).author;
		_tmp118_ = _tmp117_.screen_name;
		_tmp119_ = g_strconcat ("@", _tmp118_, NULL);
		_tmp120_ = _tmp119_;
		gtk_label_set_label (_tmp114_, _tmp120_);
		_g_free0 (_tmp120_);
		_tmp121_ = tweet;
		_tmp122_ = _tmp121_->quoted_tweet;
		_tmp123_ = (*_tmp122_).reply_id;
		if (_tmp123_ != ((gint64) 0)) {
			GString* buff = NULL;
			GString* _tmp124_;
			CbTweet* _tmp125_;
			GString* _tmp126_;
			GtkLabel* _tmp127_;
			GString* _tmp128_;
			const gchar* _tmp129_;
			_tmp124_ = g_string_new ("");
			buff = _tmp124_;
			_tmp125_ = tweet;
			_tmp126_ = buff;
			cb_utils_write_reply_text (_tmp125_->quoted_tweet, _tmp126_);
			_tmp127_ = self->priv->quote_reply_label;
			_tmp128_ = buff;
			_tmp129_ = _tmp128_->str;
			gtk_label_set_label (_tmp127_, _tmp129_);
			_g_string_free0 (buff);
		}
	}
	_tmp130_ = self->priv->retweet_button;
	_tmp131_ = tweet;
	_tmp132_ = cb_tweet_is_flag_set (_tmp131_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp132_);
	_tmp134_ = tweet;
	_tmp135_ = cb_tweet_is_flag_set (_tmp134_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp135_) {
		CbTweet* _tmp136_;
		gint64 _tmp137_;
		Account* _tmp138_;
		gint64 _tmp139_;
		_tmp136_ = tweet;
		_tmp137_ = cb_tweet_get_user_id (_tmp136_);
		_tmp138_ = account;
		_tmp139_ = _tmp138_->id;
		_tmp133_ = _tmp137_ != _tmp139_;
	} else {
		_tmp133_ = FALSE;
	}
	_tmp140_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, gtk_widget_get_type (), GtkWidget), !_tmp133_);
	_tmp141_ = self->priv->favorite_button;
	_tmp142_ = tweet;
	_tmp143_ = cb_tweet_is_flag_set (_tmp142_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp141_, _tmp143_);
	_tmp144_ = tweet;
	g_signal_connect_object (_tmp144_, "state-changed", (GCallback) _tweet_list_entry_state_changed_cb_cb_tweet_state_changed, self, 0);
	_tmp145_ = tweet;
	_tmp146_ = cb_tweet_has_inline_media (_tmp145_);
	if (_tmp146_) {
		CbTweet* _tmp147_;
		gboolean _tmp148_;
		MultiMediaWidget* _tmp149_;
		gboolean _tmp150_;
		MultiMediaWidget* _tmp151_;
		CbTweet* _tmp152_;
		gint _tmp153_;
		CbMedia** _tmp154_;
		MultiMediaWidget* _tmp155_;
		MultiMediaWidget* _tmp156_;
		MultiMediaWidget* _tmp157_;
		MainWindow* _tmp158_;
		gboolean _tmp159_ = FALSE;
		GtkLabel* _tmp160_;
		const gchar* _tmp161_;
		const gchar* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		CbTweet* _tmp172_;
		gboolean _tmp173_;
		GSettings* _tmp176_;
		GSettings* _tmp177_;
		MultiMediaWidget* _tmp178_;
		MediaVisibility _tmp179_;
		_tmp147_ = tweet;
		_tmp148_ = cb_tweet_is_flag_set (_tmp147_, (guint) CB_TWEET_STATE_NSFW);
		tweet_list_entry_create_media_widget (self, _tmp148_);
		_tmp149_ = self->priv->mm_widget;
		_tmp150_ = restrict_height;
		_tmp149_->restrict_height = _tmp150_;
		_tmp151_ = self->priv->mm_widget;
		_tmp152_ = tweet;
		_tmp154_ = cb_tweet_get_medias (_tmp152_, &_tmp153_);
		multi_media_widget_set_all_media (_tmp151_, _tmp154_, _tmp153_);
		_tmp155_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp155_, "media-clicked", (GCallback) _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked, self, 0);
		_tmp156_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp156_, "media-invalid", (GCallback) _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid, self, 0);
		_tmp157_ = self->priv->mm_widget;
		_tmp158_ = main_window;
		_tmp157_->window = G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, gtk_window_get_type (), GtkWindow);
		_tmp160_ = self->priv->text_label;
		_tmp161_ = gtk_label_get_label (_tmp160_);
		_tmp162_ = _tmp161_;
		_tmp163_ = strlen (_tmp162_);
		_tmp164_ = _tmp163_;
		if (_tmp164_ == 0) {
			CbTweet* _tmp165_;
			CbMiniTweet* _tmp166_;
			_tmp165_ = tweet;
			_tmp166_ = _tmp165_->quoted_tweet;
			_tmp159_ = _tmp166_ == NULL;
		} else {
			_tmp159_ = FALSE;
		}
		if (_tmp159_) {
			GtkStack* _tmp167_;
			_tmp167_ = self->priv->media_stack;
			if (_tmp167_ == NULL) {
				GtkGrid* _tmp168_;
				MultiMediaWidget* _tmp169_;
				_tmp168_ = self->priv->grid;
				_tmp169_ = self->priv->mm_widget;
				gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, gtk_widget_get_type (), GtkWidget), "top-attach", 2, NULL);
			} else {
				GtkGrid* _tmp170_;
				GtkStack* _tmp171_;
				_tmp170_ = self->priv->grid;
				_tmp171_ = self->priv->media_stack;
				gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp171_, gtk_widget_get_type (), GtkWidget), "top-attach", 2, NULL);
			}
		}
		_tmp172_ = tweet;
		_tmp173_ = cb_tweet_is_flag_set (_tmp172_, (guint) CB_TWEET_STATE_NSFW);
		if (_tmp173_) {
			GSettings* _tmp174_;
			GSettings* _tmp175_;
			_tmp174_ = settings_get ();
			_tmp175_ = _tmp174_;
			g_signal_connect_object (_tmp175_, "changed::hide-nsfw-content", (GCallback) _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed, self, 0);
			_g_object_unref0 (_tmp175_);
		}
		_tmp176_ = settings_get ();
		_tmp177_ = _tmp176_;
		g_signal_connect_object (_tmp177_, "changed::media-visibility", (GCallback) _tweet_list_entry_media_visibility_changed_cb_g_settings_changed, self, 0);
		_g_object_unref0 (_tmp177_);
		_tmp178_ = self->priv->mm_widget;
		_tmp179_ = settings_get_media_visiblity ();
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp178_, gtk_widget_get_type (), GtkWidget), _tmp179_ == MEDIA_VISIBILITY_SHOW);
	}
	_tmp180_ = g_simple_action_group_new ();
	actions = _tmp180_;
	_tmp181_ = actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp181_, g_action_map_get_type (), GActionMap), TWEET_LIST_ENTRY_action_entries, G_N_ELEMENTS (TWEET_LIST_ENTRY_action_entries), self);
	_tmp182_ = actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, g_action_group_get_type (), GActionGroup));
	_tmp183_ = tweet;
	_tmp184_ = cb_tweet_get_user_id (_tmp183_);
	_tmp185_ = account;
	_tmp186_ = _tmp185_->id;
	if (_tmp184_ != _tmp186_) {
		GSimpleActionGroup* _tmp187_;
		GAction* _tmp188_;
		_tmp187_ = actions;
		_tmp188_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp187_, g_action_map_get_type (), GActionMap), "delete");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp188_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_tmp189_ = tweet;
	_tmp190_ = cb_tweet_is_flag_set (_tmp189_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp190_) {
		GSimpleActionGroup* _tmp191_;
		GAction* _tmp192_;
		_tmp191_ = actions;
		_tmp192_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	g_signal_connect_object (self, "reply-tweet", (GCallback) _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet, self, 0);
	g_signal_connect_object (self, "delete-tweet", (GCallback) _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet, self, 0);
	g_signal_connect_object (self, "quote-tweet", (GCallback) _tweet_list_entry_quote_activated_tweet_list_entry_quote_tweet, self, 0);
	g_signal_connect_object (self, "favorite-tweet", (GCallback) ___lambda187__tweet_list_entry_favorite_tweet, self, 0);
	g_signal_connect_object (self, "retweet-tweet", (GCallback) ___lambda188__tweet_list_entry_retweet_tweet, self, 0);
	_tmp193_ = tweet;
	_tmp194_ = cb_tweet_is_flag_set (_tmp193_, (guint) CB_TWEET_STATE_FAVORITED);
	if (_tmp194_) {
		GtkImage* _tmp195_;
		_tmp195_ = self->priv->fav_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp196_ = tweet;
	_tmp197_ = cb_tweet_is_flag_set (_tmp196_, (guint) CB_TWEET_STATE_RETWEETED);
	if (_tmp197_) {
		GtkImage* _tmp198_;
		_tmp198_ = self->priv->rt_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp198_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
	cb_twitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (self, CB_TYPE_TWITTER_ITEM, CbTwitterItem), NULL);
	_tmp199_ = settings_get ();
	_tmp200_ = _tmp199_;
	g_signal_connect_object (_tmp200_, "changed::text-transform-flags", (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self, 0);
	_g_object_unref0 (_tmp200_);
	_g_object_unref0 (actions);
	return self;
}


TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height) {
	return tweet_list_entry_construct (TYPE_TWEET_LIST_ENTRY, tweet, main_window, account, restrict_height);
}


static void tweet_list_entry_media_visibility_changed_cb (TweetListEntry* self) {
	MediaVisibility _tmp0_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = settings_get_media_visiblity ();
	if (_tmp0_ == MEDIA_VISIBILITY_SHOW) {
		MultiMediaWidget* _tmp1_;
		_tmp1_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp2_;
		_tmp2_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
}


static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self) {
	GtkLabel* _tmp0_;
	CbTweet* _tmp1_;
	CbTransformFlags _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	CbTweet* _tmp5_;
	CbMiniTweet* _tmp6_;
	gboolean _tmp12_ = FALSE;
	MultiMediaWidget* _tmp13_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = self->tweet;
	_tmp2_ = settings_get_text_transform_flags ();
	_tmp3_ = cb_tweet_get_trimmed_text (_tmp1_, (guint) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->quoted_tweet;
	if (_tmp6_ != NULL) {
		GtkLabel* _tmp7_;
		CbTweet* _tmp8_;
		CbTransformFlags _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = self->priv->quote_label;
		_tmp8_ = self->tweet;
		_tmp9_ = settings_get_text_transform_flags ();
		_tmp10_ = cb_text_transform_tweet (_tmp8_->quoted_tweet, (guint) _tmp9_, (gint64) 0);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp13_ = self->priv->mm_widget;
	if (_tmp13_ != NULL) {
		CbTweet* _tmp14_;
		CbMiniTweet* _tmp15_;
		_tmp14_ = self->tweet;
		_tmp15_ = _tmp14_->quoted_tweet;
		_tmp12_ = _tmp15_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GtkWidget* _tmp16_ = NULL;
		GtkStack* _tmp17_;
		GtkWidget* w = NULL;
		GtkWidget* _tmp20_;
		GtkLabel* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp17_ = self->priv->media_stack;
		if (_tmp17_ != NULL) {
			GtkStack* _tmp18_;
			_tmp18_ = self->priv->media_stack;
			_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget);
		} else {
			MultiMediaWidget* _tmp19_;
			_tmp19_ = self->priv->mm_widget;
			_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget);
		}
		_tmp20_ = _g_object_ref0 (_tmp16_);
		w = _tmp20_;
		_tmp21_ = self->priv->text_label;
		_tmp22_ = gtk_label_get_label (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = strlen (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			GtkGrid* _tmp26_;
			GtkWidget* _tmp27_;
			_tmp26_ = self->priv->grid;
			_tmp27_ = w;
			gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_container_get_type (), GtkContainer), _tmp27_, "top-attach", 2, NULL);
		} else {
			GtkGrid* _tmp28_;
			GtkWidget* _tmp29_;
			_tmp28_ = self->priv->grid;
			_tmp29_ = w;
			gtk_container_child_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_container_get_type (), GtkContainer), _tmp29_, "top-attach", 8, NULL);
		}
		_g_object_unref0 (w);
	}
}


static void tweet_list_entry_hide_nsfw_content_changed_cb (TweetListEntry* self) {
	GtkStack* _tmp0_;
	gboolean _tmp1_ = FALSE;
	CbTweet* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->media_stack;
	_vala_assert (_tmp0_ != NULL, "this.media_stack != null");
	_tmp2_ = self->tweet;
	_tmp3_ = cb_tweet_is_flag_set (_tmp2_, (guint) CB_TWEET_STATE_NSFW);
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = settings_hide_nsfw_content ();
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkStack* _tmp5_;
		_tmp5_ = self->priv->media_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "nsfw");
	} else {
		GtkStack* _tmp6_;
		MultiMediaWidget* _tmp7_;
		_tmp6_ = self->priv->media_stack;
		_tmp7_ = self->priv->mm_widget;
		gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, CbMedia* m, gint index, gdouble px, gdouble py) {
	CbTweet* _tmp0_;
	MainWindow* _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (CB_IS_MEDIA (m));
	_tmp0_ = self->tweet;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = index;
	_tmp3_ = px;
	_tmp4_ = py;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


static void ___lambda186_ (TweetListEntry* self) {
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
}


static void ____lambda186__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda186_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self) {
	CbTweet* _tmp0_;
	gint64 _tmp1_;
	Account* _tmp2_;
	gint64 _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = cb_tweet_get_user_id (_tmp0_);
	_tmp2_ = self->priv->account;
	_tmp3_ = _tmp2_->id;
	if (_tmp1_ != _tmp3_) {
		return;
	}
	_tmp4_ = self->priv->delete_first_activated;
	if (_tmp4_) {
		Account* _tmp5_;
		CbTweet* _tmp6_;
		_tmp5_ = self->priv->account;
		_tmp6_ = self->tweet;
		tweet_utils_delete_tweet (_tmp5_, _tmp6_, ____lambda186__gasync_ready_callback, g_object_ref (self));
	} else {
		self->priv->delete_first_activated = TRUE;
	}
}


static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt) {
	gboolean result = FALSE;
	DoubleTapButton* _tmp0_;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	self->priv->delete_first_activated = FALSE;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_reset (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_focus_out_cb ((TweetListEntry*) self, event);
	return result;
}


static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_key_released_cb ((TweetListEntry*) self, event);
	return result;
}


/**
   * Retweets or un-retweets the tweet.
   */
static void __lambda189_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda189__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda189_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	CbTweet* _tmp1_;
	gint64 _tmp2_;
	Account* _tmp3_;
	gint64 _tmp4_;
	gboolean retweetable = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	DoubleTapButton* _tmp10_;
	Account* _tmp11_;
	CbTweet* _tmp12_;
	DoubleTapButton* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp1_ = self->tweet;
	_tmp2_ = cb_tweet_get_user_id (_tmp1_);
	_tmp3_ = self->priv->account;
	_tmp4_ = _tmp3_->id;
	if (_tmp2_ == _tmp4_) {
		_tmp0_ = TRUE;
	} else {
		CbTweet* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = self->tweet;
		_tmp6_ = cb_tweet_is_flag_set (_tmp5_, (guint) CB_TWEET_STATE_PROTECTED);
		_tmp0_ = !_tmp6_;
	}
	retweetable = _tmp0_;
	_tmp8_ = retweetable;
	if (!_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_;
		_tmp9_ = self->priv->values_set;
		_tmp7_ = !_tmp9_;
	}
	if (_tmp7_) {
		return;
	}
	_tmp10_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp11_ = self->priv->account;
	_tmp12_ = self->tweet;
	_tmp13_ = self->priv->retweet_button;
	_tmp14_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp15_ = _tmp14_;
	tweet_utils_set_retweet_status (_tmp11_, _tmp12_, _tmp15_, ___lambda189__gasync_ready_callback, g_object_ref (self));
	_tmp16_ = tweet_list_entry_get_shows_actions (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_retweet_button_toggled_cb ((TweetListEntry*) self);
}


static void __lambda190_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda190__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda190_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_;
	GtkToggleButton* _tmp1_;
	Account* _tmp2_;
	CbTweet* _tmp3_;
	GtkToggleButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->account;
	_tmp3_ = self->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_set_favorite_status (_tmp2_, _tmp3_, _tmp6_, ___lambda190__gasync_ready_callback, g_object_ref (self));
	_tmp7_ = tweet_list_entry_get_shows_actions (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_favorite_button_toggled_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self) {
	gint64 user_id = 0LL;
	gchar* screen_name = NULL;
	CbTweet* _tmp0_;
	CbMiniTweet* _tmp1_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp20_;
	gint64 _tmp21_;
	const gchar* _tmp22_;
	MainWindow* _tmp23_;
	MainWidget* _tmp24_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		CbTweet* _tmp2_;
		CbMiniTweet* _tmp3_;
		CbUserIdentity _tmp4_;
		gint64 _tmp5_;
		CbTweet* _tmp6_;
		CbMiniTweet* _tmp7_;
		CbUserIdentity _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp2_ = self->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = (*_tmp3_).author;
		_tmp5_ = _tmp4_.id;
		user_id = _tmp5_;
		_tmp6_ = self->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = (*_tmp7_).author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		CbTweet* _tmp11_;
		CbMiniTweet _tmp12_;
		CbUserIdentity _tmp13_;
		gint64 _tmp14_;
		CbTweet* _tmp15_;
		CbMiniTweet _tmp16_;
		CbUserIdentity _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = self->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_.author;
		_tmp14_ = _tmp13_.id;
		user_id = _tmp14_;
		_tmp15_ = self->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_.author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = cb_bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = user_id;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp21_);
	_tmp22_ = screen_name;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp22_);
	_tmp23_ = self->priv->main_window;
	_tmp24_ = _tmp23_->main_widget;
	main_widget_switch_page (_tmp24_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_name_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self) {
	CbTweet* _tmp0_;
	CbMiniTweet* _tmp1_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp2_;
	CbTweet* _tmp3_;
	CbMiniTweet* _tmp4_;
	CbUserIdentity _tmp5_;
	gint64 _tmp6_;
	CbTweet* _tmp7_;
	CbMiniTweet* _tmp8_;
	CbUserIdentity _tmp9_;
	const gchar* _tmp10_;
	MainWindow* _tmp11_;
	MainWidget* _tmp12_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->quoted_tweet;
	_vala_assert (_tmp1_ != NULL, "tweet.quoted_tweet != null");
	_tmp2_ = cb_bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = self->tweet;
	_tmp4_ = _tmp3_->quoted_tweet;
	_tmp5_ = (*_tmp4_).author;
	_tmp6_ = _tmp5_.id;
	cb_bundle_put_int64 (bundle, PROFILE_PAGE_KEY_USER_ID, _tmp6_);
	_tmp7_ = self->tweet;
	_tmp8_ = _tmp7_->quoted_tweet;
	_tmp9_ = (*_tmp8_).author;
	_tmp10_ = _tmp9_.screen_name;
	cb_bundle_put_string (bundle, PROFILE_PAGE_KEY_SCREEN_NAME, _tmp10_);
	_tmp11_ = self->priv->main_window;
	_tmp12_ = _tmp11_->main_widget;
	main_widget_switch_page (_tmp12_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	ComposeTweetWindow* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	_tmp4_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = tweet_list_entry_get_shows_actions (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_reply_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_show_media_clicked_cb (TweetListEntry* self) {
	GtkStack* _tmp0_;
	MultiMediaWidget* _tmp1_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->media_stack;
	_tmp1_ = self->priv->mm_widget;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}


static void tweet_list_entry_quote_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	ComposeTweetWindow* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	_tmp4_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = tweet_list_entry_get_shows_actions (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_;
	Account* _tmp1_;
	CbTweet* _tmp2_;
	ComposeTweetWindow* _tmp3_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_delete_activated (TweetListEntry* self) {
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->delete_first_activated = TRUE;
	g_signal_emit (self, tweet_list_entry_signals[TWEET_LIST_ENTRY_DELETE_TWEET_SIGNAL], 0);
	tweet_list_entry_toggle_mode (self);
}


static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	MainWindow* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = uri;
	_tmp2_ = self->priv->main_window;
	_tmp3_ = tweet_utils_activate_link (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static Block62Data* block62_data_ref (Block62Data* _data62_) {
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}


static void block62_data_unref (void * _userdata_) {
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		TweetListEntry* self;
		self = _data62_->self;
		_g_free0 (_data62_->link_text);
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}


static void ___lambda185_ (Block62Data* _data62_) {
	TweetListEntry* self;
	const gchar* _tmp0_;
	Account* _tmp1_;
	CbFilter* _tmp2_;
	CbFilter* _tmp3_;
	MainWindow* _tmp4_;
	self = _data62_->self;
	_tmp0_ = _data62_->link_text;
	_tmp1_ = self->priv->account;
	_tmp2_ = utils_create_persistent_filter (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->main_window;
	main_window_rerun_filters (_tmp4_);
}


static void ____lambda185__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda185_ (self);
}


static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu) {
	Block62Data* _data62_;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (GTK_IS_LABEL (source));
	g_return_if_fail (GTK_IS_MENU (menu));
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->self = g_object_ref (self);
	_tmp0_ = source;
	_tmp1_ = gtk_label_get_current_uri (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_data62_->link_text = _tmp2_;
	_tmp3_ = _data62_->link_text;
	_tmp4_ = g_str_has_prefix (_tmp3_, "#");
	if (_tmp4_) {
		GtkMenuItem* item = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkMenuItem* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenuItem* _tmp10_;
		GtkMenuItem* _tmp11_;
		GtkMenu* _tmp12_;
		GtkMenuItem* _tmp13_;
		_tmp5_ = _data62_->link_text;
		_tmp6_ = g_strdup_printf (_ ("Block %s"), _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp7_);
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		item = _tmp9_;
		_tmp10_ = item;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = item;
		g_signal_connect_data (_tmp11_, "activate", (GCallback) ____lambda185__gtk_menu_item_activate, block62_data_ref (_data62_), (GClosureNotify) block62_data_unref, 0);
		_tmp12_ = menu;
		_tmp13_ = item;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (item);
	}
	block62_data_unref (_data62_);
	_data62_ = NULL;
}


static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self) {
	tweet_list_entry_populate_popup_cb ((TweetListEntry*) self, _sender, menu);
}


static void tweet_list_entry_media_invalid_cb (TweetListEntry* self) {
	CbTransformFlags flags = 0;
	CbTransformFlags _tmp0_;
	gchar* new_text = NULL;
	CbTweet* _tmp1_;
	CbMiniTweet* _tmp2_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_;
	CbTweet* _tmp11_;
	CbMiniTweet* _tmp12_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = settings_get_text_transform_flags ();
	flags = _tmp0_ & (~CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS);
	_tmp1_ = self->tweet;
	_tmp2_ = _tmp1_->retweeted_tweet;
	if (_tmp2_ != NULL) {
		CbTweet* _tmp3_;
		CbTransformFlags _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->tweet;
		_tmp4_ = flags;
		_tmp5_ = cb_text_transform_tweet (_tmp3_->retweeted_tweet, (guint) _tmp4_, (gint64) 0);
		_g_free0 (new_text);
		new_text = _tmp5_;
	} else {
		CbTweet* _tmp6_;
		CbTransformFlags _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->tweet;
		_tmp7_ = flags;
		_tmp8_ = cb_text_transform_tweet (&_tmp6_->source_tweet, (guint) _tmp7_, (gint64) 0);
		_g_free0 (new_text);
		new_text = _tmp8_;
	}
	_tmp9_ = self->priv->text_label;
	_tmp10_ = new_text;
	gtk_label_set_label (_tmp9_, _tmp10_);
	_tmp11_ = self->tweet;
	_tmp12_ = _tmp11_->quoted_tweet;
	if (_tmp12_ != NULL) {
		gchar* new_quote_text = NULL;
		CbTweet* _tmp13_;
		CbTransformFlags _tmp14_;
		gchar* _tmp15_;
		GtkLabel* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = self->tweet;
		_tmp14_ = flags;
		_tmp15_ = cb_text_transform_tweet (_tmp13_->quoted_tweet, (guint) _tmp14_, (gint64) 0);
		new_quote_text = _tmp15_;
		_tmp16_ = self->priv->quote_label;
		_tmp17_ = new_quote_text;
		gtk_label_set_label (_tmp16_, _tmp17_);
		_g_free0 (new_quote_text);
	}
	_g_free0 (new_text);
}


static void tweet_list_entry_state_changed_cb (TweetListEntry* self) {
	GtkImage* _tmp0_;
	CbTweet* _tmp1_;
	gboolean _tmp2_;
	GtkToggleButton* _tmp3_;
	CbTweet* _tmp4_;
	gboolean _tmp5_;
	DoubleTapButton* _tmp6_;
	CbTweet* _tmp7_;
	gboolean _tmp8_;
	GtkImage* _tmp9_;
	CbTweet* _tmp10_;
	gboolean _tmp11_;
	CbTweet* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->fav_status_image;
	_tmp1_ = self->tweet;
	_tmp2_ = cb_tweet_is_flag_set (_tmp1_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp2_);
	_tmp3_ = self->priv->favorite_button;
	_tmp4_ = self->tweet;
	_tmp5_ = cb_tweet_is_flag_set (_tmp4_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->retweet_button;
	_tmp7_ = self->tweet;
	_tmp8_ = cb_tweet_is_flag_set (_tmp7_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp8_);
	_tmp9_ = self->priv->rt_status_image;
	_tmp10_ = self->tweet;
	_tmp11_ = cb_tweet_is_flag_set (_tmp10_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), _tmp11_);
	_tmp12_ = self->tweet;
	_tmp13_ = cb_tweet_is_flag_set (_tmp12_, (guint) CB_TWEET_STATE_DELETED);
	if (_tmp13_) {
		GtkStack* _tmp14_;
		GtkGrid* _tmp15_;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp14_ = self->priv->stack;
		_tmp15_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
}


void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface) {
	AvatarWidget* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (surface != NULL);
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = surface;
	avatar_widget_set_surface (_tmp0_, _tmp1_);
}


/**
   * Updates the time delta label in the upper right
   *
   * @return The seconds between the current time and
   *         the time the tweet was created
   */
static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint tweet_list_entry_real_update_time_delta (CbTwitterItem* base, GDateTime* now) {
	TweetListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_;
	gint64 _tmp4_ = 0LL;
	CbTweet* _tmp5_;
	CbMiniTweet* _tmp6_;
	GDateTime* then = NULL;
	GDateTime* _tmp13_;
	GtkLabel* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkLabel* _tmp19_;
	GDateTime* _tmp29_;
	GDateTime* _tmp30_;
	GTimeSpan _tmp31_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_;
		GDateTime* _tmp3_;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->retweeted_tweet;
	if (_tmp6_ != NULL) {
		CbTweet* _tmp7_;
		CbMiniTweet* _tmp8_;
		gint64 _tmp9_;
		_tmp7_ = self->tweet;
		_tmp8_ = _tmp7_->retweeted_tweet;
		_tmp9_ = (*_tmp8_).created_at;
		_tmp4_ = _tmp9_;
	} else {
		CbTweet* _tmp10_;
		CbMiniTweet _tmp11_;
		gint64 _tmp12_;
		_tmp10_ = self->tweet;
		_tmp11_ = _tmp10_->source_tweet;
		_tmp12_ = _tmp11_.created_at;
		_tmp4_ = _tmp12_;
	}
	_tmp13_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp13_;
	_tmp14_ = self->priv->time_delta_label;
	_tmp15_ = then;
	_tmp16_ = cur_time;
	_tmp17_ = utils_get_time_delta (_tmp15_, _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_label_set_label (_tmp14_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = self->priv->quote_time_delta;
	if (_tmp19_ != NULL) {
		CbTweet* _tmp20_;
		CbMiniTweet* _tmp21_;
		gint64 _tmp22_;
		GDateTime* _tmp23_;
		GtkLabel* _tmp24_;
		GDateTime* _tmp25_;
		GDateTime* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp20_ = self->tweet;
		_tmp21_ = _tmp20_->quoted_tweet;
		_tmp22_ = (*_tmp21_).created_at;
		_tmp23_ = g_date_time_new_from_unix_local (_tmp22_);
		_g_date_time_unref0 (then);
		then = _tmp23_;
		_tmp24_ = self->priv->quote_time_delta;
		_tmp25_ = then;
		_tmp26_ = cur_time;
		_tmp27_ = utils_get_time_delta (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		gtk_label_set_label (_tmp24_, _tmp28_);
		_g_free0 (_tmp28_);
	}
	_tmp29_ = cur_time;
	_tmp30_ = then;
	_tmp31_ = g_date_time_difference (_tmp29_, _tmp30_);
	result = (gint) ((_tmp31_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


static gint64 tweet_list_entry_real_get_sort_factor (CbTwitterItem* base) {
	TweetListEntry * self;
	gint64 result = 0LL;
	CbTweet* _tmp0_;
	CbMiniTweet _tmp1_;
	gint64 _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_.id;
	result = _tmp2_;
	return result;
}


static gint64 tweet_list_entry_real_get_timestamp (CbTwitterItem* base) {
	TweetListEntry * self;
	gint64 result = 0LL;
	CbTweet* _tmp0_;
	CbMiniTweet _tmp1_;
	gint64 _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_.created_at;
	result = _tmp2_;
	return result;
}


static GTimeSpan tweet_list_entry_real_get_last_set_timediff (CbTwitterItem* base) {
	TweetListEntry * self;
	GTimeSpan result = 0LL;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->priv->last_timediff;
	result = _tmp0_;
	return result;
}


static void tweet_list_entry_real_set_last_set_timediff (CbTwitterItem* base, GTimeSpan span) {
	TweetListEntry * self;
	GTimeSpan _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = span;
	self->priv->last_timediff = _tmp0_;
}


void tweet_list_entry_toggle_mode (TweetListEntry* self) {
	gboolean _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkBox* _tmp4_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->action_box;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		GtkStack* _tmp5_;
		GtkGrid* _tmp6_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
	} else {
		GtkStack* _tmp7_;
		GtkBox* _tmp8_;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->action_box;
		gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	}
}


static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gdouble t = 0.0;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->end_time;
	if (_tmp2_ > _tmp3_) {
		gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 1.0);
		result = FALSE;
		return result;
	}
	_tmp4_ = now;
	_tmp5_ = self->priv->start_time;
	_tmp6_ = self->priv->end_time;
	_tmp7_ = self->priv->start_time;
	t = (_tmp4_ - _tmp5_) / ((gdouble) (_tmp6_ - _tmp7_));
	_tmp8_ = t;
	_tmp9_ = ease_out_cubic (_tmp8_);
	t = _tmp9_;
	_tmp10_ = t;
	gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp10_);
	result = TRUE;
	return result;
}


static Block63Data* block63_data_ref (Block63Data* _data63_) {
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}


static void block63_data_unref (void * _userdata_) {
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		TweetListEntry* self;
		self = _data63_->self;
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}


static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = tweet_list_entry_anim_tick ((TweetListEntry*) self, widget, frame_clock);
	return result;
}


static void __lambda18_ (Block63Data* _data63_) {
	TweetListEntry* self;
	GdkFrameClock* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gulong _tmp3_;
	self = _data63_->self;
	_tmp0_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	self->priv->start_time = _tmp1_;
	_tmp2_ = self->priv->start_time;
	self->priv->end_time = _tmp2_ + TRANSITION_DURATION;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tweet_list_entry_anim_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
	_tmp3_ = _data63_->realize_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp3_);
}


static void ___lambda18__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	__lambda18_ (self);
}


void tweet_list_entry_fade_in (TweetListEntry* self) {
	Block63Data* _data63_;
	gboolean _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp0_) {
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		block63_data_unref (_data63_);
		_data63_ = NULL;
		return;
	}
	_data63_->realize_id = (gulong) 0;
	_tmp1_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) ___lambda18__gtk_widget_realize, block63_data_ref (_data63_), (GClosureNotify) block63_data_unref, 0);
	_data63_->realize_id = _tmp1_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	block63_data_unref (_data63_);
	_data63_ = NULL;
}


static void _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_show_media_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_create_media_widget (TweetListEntry* self, gboolean nsfw) {
	MultiMediaWidget* _tmp0_;
	MultiMediaWidget* _tmp1_;
	MultiMediaWidget* _tmp2_;
	MultiMediaWidget* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = multi_media_widget_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->mm_widget);
	self->priv->mm_widget = _tmp0_;
	_tmp1_ = self->priv->mm_widget;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
	_tmp2_ = self->priv->mm_widget;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp3_ = self->priv->mm_widget;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp4_ = nsfw;
	if (_tmp4_) {
		GtkStack* _tmp5_;
		GtkStack* _tmp6_;
		GtkStack* _tmp7_;
		MultiMediaWidget* _tmp8_;
		GtkBox* box = NULL;
		GtkBox* _tmp9_;
		GtkBox* _tmp10_;
		GtkLabel* label = NULL;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkBox* _tmp16_;
		GtkLabel* _tmp17_;
		GtkButton* button = NULL;
		GtkButton* _tmp18_;
		GtkButton* _tmp19_;
		GtkButton* _tmp20_;
		GtkButton* _tmp21_;
		GtkBox* _tmp22_;
		GtkButton* _tmp23_;
		GtkStack* _tmp24_;
		GtkBox* _tmp25_;
		GtkStack* _tmp26_;
		gboolean _tmp27_;
		CbTweet* _tmp31_;
		CbMiniTweet* _tmp32_;
		_tmp5_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->media_stack);
		self->priv->media_stack = _tmp5_;
		_tmp6_ = self->priv->media_stack;
		gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
		_tmp7_ = self->priv->media_stack;
		_tmp8_ = self->priv->mm_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
		g_object_ref_sink (_tmp9_);
		box = _tmp9_;
		_tmp10_ = box;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp11_ = (GtkLabel*) gtk_label_new (_ ("This tweet contains images marked as inappropriate"));
		g_object_ref_sink (_tmp11_);
		label = _tmp11_;
		_tmp12_ = label;
		gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 12);
		_tmp13_ = label;
		gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), 12);
		_tmp14_ = label;
		g_object_set (_tmp14_, "wrap", TRUE, NULL);
		_tmp15_ = label;
		g_object_set (_tmp15_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
		_tmp16_ = box;
		_tmp17_ = label;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		_tmp18_ = (GtkButton*) gtk_button_new_with_label (_ ("Show anyway"));
		g_object_ref_sink (_tmp18_);
		button = _tmp18_;
		_tmp19_ = button;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp20_ = button;
		gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
		_tmp21_ = button;
		g_signal_connect_object (_tmp21_, "clicked", (GCallback) _tweet_list_entry_show_media_clicked_cb_gtk_button_clicked, self, 0);
		_tmp22_ = box;
		_tmp23_ = button;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
		_tmp24_ = self->priv->media_stack;
		_tmp25_ = box;
		gtk_stack_add_named (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), "nsfw");
		_tmp26_ = self->priv->media_stack;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = settings_hide_nsfw_content ();
		if (_tmp27_) {
			GtkStack* _tmp28_;
			_tmp28_ = self->priv->media_stack;
			gtk_stack_set_visible_child_name (_tmp28_, "nsfw");
		} else {
			GtkStack* _tmp29_;
			MultiMediaWidget* _tmp30_;
			_tmp29_ = self->priv->media_stack;
			_tmp30_ = self->priv->mm_widget;
			gtk_stack_set_visible_child (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp31_ = self->tweet;
		_tmp32_ = _tmp31_->quoted_tweet;
		if (_tmp32_ != NULL) {
			GtkStack* _tmp33_;
			GtkGrid* _tmp34_;
			GtkStack* _tmp35_;
			_tmp33_ = self->priv->media_stack;
			gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), 12);
			_tmp34_ = self->priv->quote_grid;
			_tmp35_ = self->priv->media_stack;
			gtk_grid_attach (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), 0, 3, 3, 1);
		} else {
			GtkGrid* _tmp36_;
			GtkStack* _tmp37_;
			_tmp36_ = self->priv->grid;
			_tmp37_ = self->priv->media_stack;
			gtk_grid_attach (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), 1, 7, 7, 1);
		}
		_g_object_unref0 (button);
		_g_object_unref0 (label);
		_g_object_unref0 (box);
	} else {
		MultiMediaWidget* _tmp38_;
		CbTweet* _tmp39_;
		CbMiniTweet* _tmp40_;
		_tmp38_ = self->priv->mm_widget;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
		_tmp39_ = self->tweet;
		_tmp40_ = _tmp39_->quoted_tweet;
		if (_tmp40_ != NULL) {
			MultiMediaWidget* _tmp41_;
			GtkGrid* _tmp42_;
			MultiMediaWidget* _tmp43_;
			_tmp41_ = self->priv->mm_widget;
			gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget), 12);
			_tmp42_ = self->priv->quote_grid;
			_tmp43_ = self->priv->mm_widget;
			gtk_grid_attach (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget), 0, 3, 3, 1);
		} else {
			GtkGrid* _tmp44_;
			MultiMediaWidget* _tmp45_;
			_tmp44_ = self->priv->grid;
			_tmp45_ = self->priv->mm_widget;
			gtk_grid_attach (_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), 1, 7, 7, 1);
		}
	}
}


static gboolean tweet_list_entry_quote_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	MainWindow* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = uri;
	_tmp2_ = self->priv->main_window;
	_tmp3_ = tweet_utils_activate_link (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_quote_name_button_clicked_cb ((TweetListEntry*) self);
}


static gboolean _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_quote_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static void tweet_list_entry_create_quote_grid (TweetListEntry* self, gboolean reply) {
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkStyleContext* _tmp4_;
	TextButton* _tmp5_;
	TextButton* _tmp6_;
	TextButton* _tmp7_;
	TextButton* _tmp8_;
	TextButton* _tmp9_;
	TextButton* _tmp10_;
	GtkGrid* _tmp11_;
	TextButton* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkGrid* _tmp19_;
	GtkLabel* _tmp20_;
	gboolean _tmp21_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkLabel* _tmp46_;
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp47_;
	PangoAttrList* _tmp48_;
	PangoAttribute* _tmp49_;
	GtkLabel* _tmp50_;
	PangoAttrList* _tmp51_;
	gboolean _tmp52_;
	GtkLabel* _tmp57_;
	GtkLabel* _tmp58_;
	GtkLabel* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkGrid* _tmp61_;
	GtkLabel* _tmp62_;
	GtkGrid* _tmp63_;
	GtkGrid* _tmp64_;
	GtkGrid* _tmp65_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->quote_grid);
	self->priv->quote_grid = _tmp0_;
	_tmp1_ = self->priv->quote_grid;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp2_ = self->priv->quote_grid;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp3_ = self->priv->quote_grid;
	_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp4_, "quote");
	_tmp5_ = text_button_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->quote_name);
	self->priv->quote_name = _tmp5_;
	_tmp6_ = self->priv->quote_name;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp7_ = self->priv->quote_name;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp8_ = self->priv->quote_name;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), 12);
	_tmp9_ = self->priv->quote_name;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), 6);
	_tmp10_ = self->priv->quote_name;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->quote_grid;
	_tmp12_ = self->priv->quote_name;
	gtk_grid_attach (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), 0, 0, 1, 1);
	_tmp13_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->quote_screen_name);
	self->priv->quote_screen_name = _tmp13_;
	_tmp14_ = self->priv->quote_screen_name;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp15_ = self->priv->quote_screen_name;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp16_ = self->priv->quote_screen_name;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp17_ = self->priv->quote_screen_name;
	_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp18_, "dim-label");
	_tmp19_ = self->priv->quote_grid;
	_tmp20_ = self->priv->quote_screen_name;
	gtk_grid_attach (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), 1, 0, 1, 1);
	_tmp21_ = reply;
	if (_tmp21_) {
		GtkLabel* _tmp22_;
		GtkLabel* _tmp23_;
		GtkLabel* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		GtkStyleContext* _tmp30_;
		GtkLabel* _tmp31_;
		GtkStyleContext* _tmp32_;
		GtkLabel* _tmp33_;
		GtkGrid* _tmp34_;
		GtkLabel* _tmp35_;
		_tmp22_ = (GtkLabel*) gtk_label_new ("");
		g_object_ref_sink (_tmp22_);
		_g_object_unref0 (self->priv->quote_reply_label);
		self->priv->quote_reply_label = _tmp22_;
		_tmp23_ = self->priv->quote_reply_label;
		gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
		_tmp24_ = self->priv->quote_reply_label;
		gtk_label_set_use_markup (_tmp24_, TRUE);
		_tmp25_ = self->priv->quote_reply_label;
		gtk_label_set_xalign (_tmp25_, (gfloat) 0);
		_tmp26_ = self->priv->quote_reply_label;
		gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget), 12);
		_tmp27_ = self->priv->quote_reply_label;
		gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), 4);
		_tmp28_ = self->priv->quote_reply_label;
		g_signal_connect_object (_tmp28_, "activate-link", (GCallback) _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link, self, 0);
		_tmp29_ = self->priv->quote_reply_label;
		_tmp30_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp30_, "dim-label");
		_tmp31_ = self->priv->quote_reply_label;
		_tmp32_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp32_, "invisible-links");
		_tmp33_ = self->priv->quote_reply_label;
		gtk_widget_set_no_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp34_ = self->priv->quote_grid;
		_tmp35_ = self->priv->quote_reply_label;
		gtk_grid_attach (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), 0, 1, 3, 1);
	}
	_tmp36_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->quote_label);
	self->priv->quote_label = _tmp36_;
	_tmp37_ = self->priv->quote_label;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp38_ = self->priv->quote_label;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp39_ = self->priv->quote_label;
	gtk_label_set_xalign (_tmp39_, (gfloat) 0);
	_tmp40_ = self->priv->quote_label;
	gtk_label_set_use_markup (_tmp40_, TRUE);
	_tmp41_ = self->priv->quote_label;
	g_object_set (_tmp41_, "wrap", TRUE, NULL);
	_tmp42_ = self->priv->quote_label;
	g_object_set (_tmp42_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp43_ = self->priv->quote_label;
	gtk_label_set_track_visited_links (_tmp43_, FALSE);
	_tmp44_ = self->priv->quote_label;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget), 12);
	_tmp45_ = self->priv->quote_label;
	g_signal_connect_object (_tmp45_, "activate-link", (GCallback) _tweet_list_entry_quote_link_activated_cb_gtk_label_activate_link, self, 0);
	_tmp46_ = self->priv->quote_label;
	g_signal_connect_object (_tmp46_, "populate-popup", (GCallback) _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup, self, 0);
	_tmp47_ = pango_attr_list_new ();
	attrs = _tmp47_;
	_tmp48_ = attrs;
	_tmp49_ = pango_attr_style_new (PANGO_STYLE_ITALIC);
	pango_attr_list_insert (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->quote_label;
	_tmp51_ = attrs;
	gtk_label_set_attributes (_tmp50_, _tmp51_);
	_tmp52_ = reply;
	if (_tmp52_) {
		GtkGrid* _tmp53_;
		GtkLabel* _tmp54_;
		_tmp53_ = self->priv->quote_grid;
		_tmp54_ = self->priv->quote_label;
		gtk_grid_attach (_tmp53_, G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget), 0, 2, 3, 1);
	} else {
		GtkGrid* _tmp55_;
		GtkLabel* _tmp56_;
		_tmp55_ = self->priv->quote_grid;
		_tmp56_ = self->priv->quote_label;
		gtk_grid_attach (_tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_widget_get_type (), GtkWidget), 0, 1, 3, 1);
	}
	_tmp57_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->quote_time_delta);
	self->priv->quote_time_delta = _tmp57_;
	_tmp58_ = self->priv->quote_time_delta;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	_tmp59_ = self->priv->quote_time_delta;
	_tmp60_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp60_, "dim-label");
	_tmp61_ = self->priv->quote_grid;
	_tmp62_ = self->priv->quote_time_delta;
	gtk_grid_attach (_tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget), 2, 0, 1, 1);
	_tmp63_ = self->priv->quote_grid;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
	_tmp64_ = self->priv->grid;
	_tmp65_ = self->priv->quote_grid;
	gtk_grid_attach (_tmp64_, G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_widget_get_type (), GtkWidget), 1, 3, 6, 1);
	_pango_attr_list_unref0 (attrs);
}


void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value) {
	gboolean _tmp0_;
	MultiMediaWidget* _tmp1_;
	GtkGrid* _tmp4_;
	TextButton* _tmp5_;
	GtkLabel* name_label = NULL;
	CbTweet* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkGrid* _tmp14_;
	GtkStyleContext* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = value;
	_vala_assert (_tmp0_, "value");
	_tmp1_ = self->priv->mm_widget;
	if (_tmp1_ != NULL) {
		MultiMediaWidget* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->mm_widget;
		_tmp3_ = value;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), !_tmp3_);
	}
	_tmp4_ = self->priv->grid;
	_tmp5_ = self->priv->name_button;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->tweet;
	_tmp7_ = cb_tweet_get_user_name (_tmp6_);
	_tmp8_ = g_strconcat ("<b>", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "</b>", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	name_label = _tmp13_;
	gtk_label_set_use_markup (name_label, TRUE);
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	gtk_label_set_ellipsize (name_label, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (name_label, (gfloat) 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = self->priv->grid;
	gtk_grid_attach (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (name_label, gtk_widget_get_type (), GtkWidget), 1, 0, 1, 1);
	_tmp15_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp15_, "read-only");
	_tmp16_ = value;
	self->priv->_read_only = _tmp16_;
	_g_object_unref0 (name_label);
	g_object_notify_by_pspec ((GObject *) self, tweet_list_entry_properties[TWEET_LIST_ENTRY_READ_ONLY_PROPERTY]);
}


gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self) {
	gboolean result;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkBox* _tmp3_;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->action_box;
	result = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	return result;
}


static void tweet_list_entry_class_init (TweetListEntryClass * klass) {
	gint TweetListEntry_private_offset;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp0_;
	GObjectClass* _tmp1_;
	GtkBindingSet* _tmp2_;
	GtkBindingSet* _tmp3_;
	GtkBindingSet* _tmp4_;
	GtkBindingSet* _tmp5_;
	GtkBindingSet* _tmp6_;
	GtkBindingSet* _tmp7_;
	GtkBindingSet* _tmp8_;
	tweet_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_READ_ONLY_PROPERTY, tweet_list_entry_properties[TWEET_LIST_ENTRY_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SHOWS_ACTIONS_PROPERTY, tweet_list_entry_properties[TWEET_LIST_ENTRY_SHOWS_ACTIONS_PROPERTY] = g_param_spec_boolean ("shows-actions", "shows-actions", "shows-actions", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	TweetListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-list-entry.ui");
	tweet_list_entry_signals[TWEET_LIST_ENTRY_REPLY_TWEET_SIGNAL] = g_signal_new ("reply-tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tweet_list_entry_signals[TWEET_LIST_ENTRY_FAVORITE_TWEET_SIGNAL] = g_signal_new ("favorite-tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tweet_list_entry_signals[TWEET_LIST_ENTRY_RETWEET_TWEET_SIGNAL] = g_signal_new ("retweet-tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tweet_list_entry_signals[TWEET_LIST_ENTRY_DELETE_TWEET_SIGNAL] = g_signal_new ("delete-tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	tweet_list_entry_signals[TWEET_LIST_ENTRY_QUOTE_TWEET_SIGNAL] = g_signal_new ("quote-tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_delta_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, time_delta_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, fav_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_box", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, action_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, reply_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "focus_out_cb", G_CALLBACK(_tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_released_cb", G_CALLBACK(_tweet_list_entry_key_released_cb_gtk_widget_key_release_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_list_entry_name_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_list_entry_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "populate_popup_cb", G_CALLBACK(_tweet_list_entry_populate_popup_cb_gtk_label_populate_popup));
	_tmp0_ = g_type_class_ref (TYPE_TWEET_LIST_ENTRY);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	binding_set = _tmp3_;
	_tmp4_ = binding_set;
	gtk_binding_entry_add_signal (_tmp4_, (guint) GDK_KEY_r, 0, "reply-tweet", (guint) 0, NULL, NULL);
	_tmp5_ = binding_set;
	gtk_binding_entry_add_signal (_tmp5_, (guint) GDK_KEY_d, 0, "delete-tweet", (guint) 0, NULL, NULL);
	_tmp6_ = binding_set;
	gtk_binding_entry_add_signal (_tmp6_, (guint) GDK_KEY_t, 0, "retweet-tweet", (guint) 0, NULL, NULL);
	_tmp7_ = binding_set;
	gtk_binding_entry_add_signal (_tmp7_, (guint) GDK_KEY_f, 0, "favorite-tweet", (guint) 0, NULL, NULL);
	_tmp8_ = binding_set;
	gtk_binding_entry_add_signal (_tmp8_, (guint) GDK_KEY_q, 0, "quote-tweet", (guint) 0, NULL, NULL);
}


static void tweet_list_entry_cb_twitter_item_interface_init (CbTwitterItemInterface * iface) {
	tweet_list_entry_cb_twitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*) (CbTwitterItem *, GDateTime*)) tweet_list_entry_real_update_time_delta;
	iface->get_sort_factor = (gint64 (*) (CbTwitterItem *)) tweet_list_entry_real_get_sort_factor;
	iface->get_timestamp = (gint64 (*) (CbTwitterItem *)) tweet_list_entry_real_get_timestamp;
	iface->get_last_set_timediff = (GTimeSpan (*) (CbTwitterItem *)) tweet_list_entry_real_get_last_set_timediff;
	iface->set_last_set_timediff = (void (*) (CbTwitterItem *, GTimeSpan)) tweet_list_entry_real_set_last_set_timediff;
}


static void tweet_list_entry_instance_init (TweetListEntry * self) {
	self->priv = TWEET_LIST_ENTRY_GET_PRIVATE (self);
	self->priv->quote_label = NULL;
	self->priv->quote_name = NULL;
	self->priv->quote_time_delta = NULL;
	self->priv->quote_screen_name = NULL;
	self->priv->quote_reply_label = NULL;
	self->priv->quote_grid = NULL;
	self->priv->media_stack = NULL;
	self->priv->mm_widget = NULL;
	self->priv->_read_only = FALSE;
	self->priv->values_set = FALSE;
	self->priv->delete_first_activated = FALSE;
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_DOUBLE_TAP_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_list_entry_finalize (GObject * obj) {
	TweetListEntry * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	gboolean _tmp4_ = FALSE;
	CbTweet* _tmp5_;
	gboolean _tmp6_;
	MultiMediaWidget* _tmp12_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("changed::text-transform-flags", g_settings_get_type (), &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->tweet;
	_tmp6_ = cb_tweet_is_flag_set (_tmp5_, (guint) CB_TWEET_STATE_NSFW);
	if (_tmp6_) {
		GtkStack* _tmp7_;
		_tmp7_ = self->priv->media_stack;
		_tmp4_ = _tmp7_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GSettings* _tmp8_;
		GSettings* _tmp9_;
		guint _tmp10_;
		GQuark _tmp11_;
		_tmp8_ = settings_get ();
		_tmp9_ = _tmp8_;
		g_signal_parse_name ("changed::hide-nsfw-content", g_settings_get_type (), &_tmp10_, &_tmp11_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, _tmp11_, NULL, (GCallback) _tweet_list_entry_hide_nsfw_content_changed_cb_g_settings_changed, self);
		_g_object_unref0 (_tmp9_);
	}
	_tmp12_ = self->priv->mm_widget;
	if (_tmp12_ != NULL) {
		GSettings* _tmp13_;
		GSettings* _tmp14_;
		guint _tmp15_;
		GQuark _tmp16_;
		_tmp13_ = settings_get ();
		_tmp14_ = _tmp13_;
		g_signal_parse_name ("changed::media-visibility", g_settings_get_type (), &_tmp15_, &_tmp16_, TRUE);
		g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, _tmp16_, NULL, (GCallback) _tweet_list_entry_media_visibility_changed_cb_g_settings_changed, self);
		_g_object_unref0 (_tmp14_);
	}
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->rt_image);
	_g_object_unref0 (self->priv->rt_status_image);
	_g_object_unref0 (self->priv->fav_status_image);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->action_box);
	_g_object_unref0 (self->priv->reply_label);
	_g_object_unref0 (self->priv->quote_label);
	_g_object_unref0 (self->priv->quote_name);
	_g_object_unref0 (self->priv->quote_time_delta);
	_g_object_unref0 (self->priv->quote_screen_name);
	_g_object_unref0 (self->priv->quote_reply_label);
	_g_object_unref0 (self->priv->quote_grid);
	_g_object_unref0 (self->priv->media_stack);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->tweet);
	G_OBJECT_CLASS (tweet_list_entry_parent_class)->finalize (obj);
}


GType tweet_list_entry_get_type (void) {
	static volatile gsize tweet_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListEntry), 0, (GInstanceInitFunc) tweet_list_entry_instance_init, NULL };
		static const GInterfaceInfo cb_twitter_item_info = { (GInterfaceInitFunc) tweet_list_entry_cb_twitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_list_entry_type_id;
		tweet_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TweetListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_list_entry_type_id, CB_TYPE_TWITTER_ITEM, &cb_twitter_item_info);
		g_once_init_leave (&tweet_list_entry_type_id__volatile, tweet_list_entry_type_id);
	}
	return tweet_list_entry_type_id__volatile;
}


static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_SHOWS_ACTIONS_PROPERTY:
		g_value_set_boolean (value, tweet_list_entry_get_shows_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_READ_ONLY_PROPERTY:
		tweet_list_entry_set_read_only (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



