/* SettingsDialog.c generated by valac 0.36.4, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include "CbTypes.h"
#include <string.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include "CbTextTransform.h"
#include "CbSnippetManager.h"


#define TYPE_SETTINGS_DIALOG (settings_dialog_get_type ())
#define SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DIALOG, SettingsDialog))
#define SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DIALOG, SettingsDialogClass))
#define IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DIALOG))
#define IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DIALOG))
#define SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DIALOG, SettingsDialogClass))

typedef struct _SettingsDialog SettingsDialog;
typedef struct _SettingsDialogClass SettingsDialogClass;
typedef struct _SettingsDialogPrivate SettingsDialogPrivate;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_SNIPPET_LIST_ENTRY (snippet_list_entry_get_type ())
#define SNIPPET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry))
#define SNIPPET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntryClass))
#define IS_SNIPPET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_LIST_ENTRY))
#define IS_SNIPPET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_LIST_ENTRY))
#define SNIPPET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_LIST_ENTRY, SnippetListEntryClass))

typedef struct _SnippetListEntry SnippetListEntry;
typedef struct _SnippetListEntryClass SnippetListEntryClass;

#define TYPE_MODIFY_SNIPPET_DIALOG (modify_snippet_dialog_get_type ())
#define MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialog))
#define MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))
#define IS_MODIFY_SNIPPET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_SNIPPET_DIALOG))
#define IS_MODIFY_SNIPPET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_SNIPPET_DIALOG))
#define MODIFY_SNIPPET_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_SNIPPET_DIALOG, ModifySnippetDialogClass))

typedef struct _ModifySnippetDialog ModifySnippetDialog;
typedef struct _ModifySnippetDialogClass ModifySnippetDialogClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SettingsDialog {
	GtkWindow parent_instance;
	SettingsDialogPrivate * priv;
};

struct _SettingsDialogClass {
	GtkWindowClass parent_class;
};

struct _SettingsDialogPrivate {
	GtkSwitch* on_new_mentions_switch;
	GtkSwitch* round_avatar_switch;
	GtkSwitch* on_new_dms_switch;
	GtkComboBoxText* on_new_tweets_combobox;
	GtkSwitch* auto_scroll_on_new_tweets_switch;
	GtkStack* main_stack;
	GtkSwitch* double_click_activation_switch;
	GtkListBox* sample_tweet_list;
	GtkSwitch* remove_trailing_hashtags_switch;
	GtkSwitch* remove_media_links_switch;
	GtkSwitch* hide_nsfw_content_switch;
	GtkListBox* snippet_list_box;
	GtkComboBoxText* media_visibility_combobox;
	TweetListEntry* sample_tweet_entry;
	gboolean block_flag_emission;
};


static gpointer settings_dialog_parent_class = NULL;
extern CbSnippetManager* corebird_snippet_manager;

GType settings_dialog_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define SETTINGS_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS_DIALOG, SettingsDialogPrivate))
enum  {
	SETTINGS_DIALOG_DUMMY_PROPERTY
};
GType corebird_get_type (void) G_GNUC_CONST;
SettingsDialog* settings_dialog_new (Corebird* application);
SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application);
GSettings* settings_get (void);
static void __lambda186_ (SettingsDialog* self);
static void ___lambda186__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
CbTransformFlags settings_get_text_transform_flags (void);
static void __lambda187_ (SettingsDialog* self, gconstpointer key, gconstpointer value);
GType snippet_list_entry_get_type (void) G_GNUC_CONST;
SnippetListEntry* snippet_list_entry_new (const gchar* key, const gchar* value);
SnippetListEntry* snippet_list_entry_construct (GType object_type, const gchar* key, const gchar* value);
static void ___lambda187__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void settings_dialog_add_accels (SettingsDialog* self);
static void settings_dialog_load_geometry (SettingsDialog* self);
static gboolean settings_dialog_window_destroy_cb (SettingsDialog* self);
static void settings_dialog_save_geometry (SettingsDialog* self);
static gboolean _settings_dialog_window_destroy_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void settings_dialog_snippet_entry_activated_cb (SettingsDialog* self, GtkListBoxRow* row);
GType modify_snippet_dialog_get_type (void) G_GNUC_CONST;
const gchar* snippet_list_entry_get_key (SnippetListEntry* self);
const gchar* snippet_list_entry_get_value (SnippetListEntry* self);
ModifySnippetDialog* modify_snippet_dialog_new (const gchar* key, const gchar* value);
ModifySnippetDialog* modify_snippet_dialog_construct (GType object_type, const gchar* key, const gchar* value);
static void settings_dialog_snippet_updated_func (SettingsDialog* self, const gchar* old_key, const gchar* key, const gchar* value);
static void _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated (ModifySnippetDialog* _sender, const gchar* old_key, const gchar* key, const gchar* value, gpointer self);
static void _settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void settings_dialog_add_snippet_button_clicked_cb (SettingsDialog* self);
static void _settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void snippet_list_entry_reveal (SnippetListEntry* self);
void snippet_list_entry_set_key (SnippetListEntry* self, const gchar* value);
void snippet_list_entry_set_value (SnippetListEntry* self, const gchar* value);
static gboolean __lambda189_ (SettingsDialog* self);
static gboolean ___lambda189__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda190_ (SettingsDialog* self);
static gboolean ___lambda190__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda191_ (SettingsDialog* self);
static gboolean ___lambda191__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda192_ (SettingsDialog* self);
static gboolean ___lambda192__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda193_ (SettingsDialog* self);
static gboolean ___lambda193__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void settings_dialog_remove_trailing_hashtags_cb (SettingsDialog* self);
void settings_add_text_transform_flag (CbTransformFlags flag);
void settings_remove_text_transform_flag (CbTransformFlags flag);
static void _settings_dialog_remove_trailing_hashtags_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void settings_dialog_remove_media_links_cb (SettingsDialog* self);
static void _settings_dialog_remove_media_links_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void settings_dialog_finalize (GObject * obj);


static void __lambda186_ (SettingsDialog* self) {
	GtkComboBoxText* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->on_new_tweets_combobox;
	_tmp1_ = self->priv->auto_scroll_on_new_tweets_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !_tmp3_);
}


static void ___lambda186__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda186_ ((SettingsDialog*) self);
}


static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda187_ (SettingsDialog* self, gconstpointer key, gconstpointer value) {
	SnippetListEntry* e = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	SnippetListEntry* _tmp2_;
	GtkListBox* _tmp3_;
	_tmp0_ = key;
	_tmp1_ = value;
	_tmp2_ = snippet_list_entry_new ((const gchar*) _tmp0_, (const gchar*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	e = _tmp2_;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (e, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->snippet_list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (e, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (e);
}


static void ___lambda187__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda187_ ((SettingsDialog*) self, key, value);
}


SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application) {
	SettingsDialog * self = NULL;
	Corebird* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GtkSwitch* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GtkSwitch* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GtkSwitch* _tmp12_;
	GtkSwitch* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GtkSwitch* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GtkSwitch* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	GtkComboBoxText* _tmp22_;
	CbTweet* sample_tweet = NULL;
	CbTweet* _tmp23_;
	CbTweet* _tmp24_;
	CbTweet* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	CbUserIdentity _tmp28_ = {0};
	CbUserIdentity _tmp29_;
	gchar* sample_text = NULL;
	gchar* _tmp30_;
	cairo_surface_t* avatar_surface = NULL;
	CbTweet* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	CbTweet* _tmp77_;
	CbTweet* _tmp78_;
	Account* _tmp79_;
	Account* _tmp80_;
	TweetListEntry* _tmp81_;
	TweetListEntry* _tmp82_;
	cairo_surface_t* _tmp83_;
	TweetListEntry* _tmp84_;
	TweetListEntry* _tmp85_;
	TweetListEntry* _tmp86_;
	GtkListBox* _tmp87_;
	TweetListEntry* _tmp88_;
	CbTransformFlags text_transform_flags = 0;
	CbTransformFlags _tmp89_;
	GtkSwitch* _tmp90_;
	GtkSwitch* _tmp91_;
	GSettings* _tmp92_;
	GSettings* _tmp93_;
	GtkSwitch* _tmp94_;
	CbSnippetManager* _tmp95_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (application), NULL);
	self = (SettingsDialog*) g_object_new (object_type, NULL);
	_tmp0_ = application;
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->round_avatar_switch;
	g_settings_bind (_tmp2_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = settings_get ();
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->on_new_tweets_combobox;
	g_settings_bind (_tmp5_, "new-tweets-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp5_);
	_tmp7_ = settings_get ();
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->on_new_mentions_switch;
	g_settings_bind (_tmp8_, "new-mentions-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp8_);
	_tmp10_ = settings_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->on_new_dms_switch;
	g_settings_bind (_tmp11_, "new-dms-notify", G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->auto_scroll_on_new_tweets_switch;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G_TYPE_OBJECT, GObject), "notify::active", (GCallback) ___lambda186__g_object_notify, self, 0);
	_tmp14_ = settings_get ();
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->auto_scroll_on_new_tweets_switch;
	g_settings_bind (_tmp15_, "auto-scroll-on-new-tweets", G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp15_);
	_tmp17_ = settings_get ();
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->double_click_activation_switch;
	g_settings_bind (_tmp18_, "double-click-activation", G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp18_);
	_tmp20_ = settings_get ();
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->media_visibility_combobox;
	g_settings_bind (_tmp21_, "media-visibility", G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, G_TYPE_OBJECT, GObject), "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp21_);
	_tmp23_ = cb_tweet_new ();
	sample_tweet = _tmp23_;
	_tmp24_ = sample_tweet;
	cb_mini_tweet_free (&_tmp24_->source_tweet);
	cb_mini_tweet_init (&_tmp24_->source_tweet);
	_tmp25_ = sample_tweet;
	_tmp26_ = g_strdup ("corebirdclient");
	_tmp27_ = g_strdup ("Corebird");
	memset (&_tmp28_, 0, sizeof (CbUserIdentity));
	_tmp28_.id = (gint64) 12;
	_g_free0 (_tmp28_.screen_name);
	_tmp28_.screen_name = _tmp26_;
	_g_free0 (_tmp28_.user_name);
	_tmp28_.user_name = _tmp27_;
	cb_user_identity_free (&_tmp25_->source_tweet.author);
	_tmp25_->source_tweet.author = _tmp28_;
	_tmp29_ = _tmp25_->source_tweet.author;
	_tmp30_ = g_strdup (_ ("Hey, check out this new #Corebird version! \\ (•◡•) / #cool #newisalwa" \
"ysbetter"));
	sample_text = _tmp30_;
	avatar_surface = NULL;
	{
		GdkPixbuf* a = NULL;
		GtkIconTheme* _tmp31_;
		gint _tmp32_;
		GdkPixbuf* _tmp33_;
		GdkPixbuf* _tmp34_;
		gint _tmp35_;
		GdkWindow* _tmp36_;
		cairo_surface_t* _tmp37_;
		_tmp31_ = gtk_icon_theme_get_default ();
		_tmp32_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp33_ = gtk_icon_theme_load_icon (_tmp31_, "corebird", 48 * _tmp32_, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
		a = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch87_g_error;
		}
		_tmp34_ = a;
		_tmp35_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp36_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp37_ = gdk_cairo_surface_create_from_pixbuf (_tmp34_, _tmp35_, _tmp36_);
		_cairo_surface_destroy0 (avatar_surface);
		avatar_surface = _tmp37_;
		_g_object_unref0 (a);
	}
	goto __finally87;
	__catch87_g_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		const gchar* _tmp39_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _tmp38_->message;
		g_warning ("SettingsDialog.vala:93: %s", _tmp39_);
		_g_error_free0 (e);
	}
	__finally87:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_cairo_surface_destroy0 (avatar_surface);
		_g_free0 (sample_text);
		_g_object_unref0 (sample_tweet);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp40_ = sample_tweet;
	_tmp41_ = sample_text;
	_tmp42_ = g_strdup (_tmp41_);
	_g_free0 (_tmp40_->source_tweet.text);
	_tmp40_->source_tweet.text = _tmp42_;
	{
		GRegex* regex = NULL;
		GRegex* _tmp43_;
		GMatchInfo* match_info = NULL;
		gboolean matched = FALSE;
		GRegex* _tmp44_;
		const gchar* _tmp45_;
		GMatchInfo* _tmp46_ = NULL;
		gboolean _tmp47_;
		gboolean _tmp48_;
		CbTweet* _tmp49_;
		CbTextEntity* _tmp50_;
		gint i = 0;
		_tmp43_ = g_regex_new ("#\\w+", 0, 0, &_inner_error_);
		regex = _tmp43_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch88_g_regex_error;
			}
			_cairo_surface_destroy0 (avatar_surface);
			_g_free0 (sample_text);
			_g_object_unref0 (sample_tweet);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp44_ = regex;
		_tmp45_ = sample_text;
		_tmp47_ = g_regex_match (_tmp44_, _tmp45_, 0, &_tmp46_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp46_;
		matched = _tmp47_;
		_tmp48_ = matched;
		_vala_assert (_tmp48_, "matched");
		_tmp49_ = sample_tweet;
		_tmp50_ = g_new0 (CbTextEntity, 3);
		_tmp49_->source_tweet.entities = (_vala_CbTextEntity_array_free (_tmp49_->source_tweet.entities, _tmp49_->source_tweet.n_entities), NULL);
		_tmp49_->source_tweet.entities = _tmp50_;
		_tmp49_->source_tweet.n_entities = 3;
		i = 0;
		while (TRUE) {
			GMatchInfo* _tmp51_;
			gboolean _tmp52_;
			GMatchInfo* _tmp53_;
			gint _tmp54_;
			gint from = 0;
			gint to = 0;
			GMatchInfo* _tmp55_;
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			gchar* match = NULL;
			GMatchInfo* _tmp58_;
			gchar* _tmp59_;
			CbTweet* _tmp60_;
			gint _tmp61_;
			const gchar* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			const gchar* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			CbTextEntity _tmp71_ = {0};
			CbTextEntity _tmp72_;
			GMatchInfo* _tmp73_;
			gint _tmp74_;
			_tmp51_ = match_info;
			_tmp52_ = g_match_info_matches (_tmp51_);
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = match_info;
			_tmp54_ = g_match_info_get_match_count (_tmp53_);
			_vala_assert (_tmp54_ == 1, "match_info.get_match_count () == 1");
			_tmp55_ = match_info;
			g_match_info_fetch_pos (_tmp55_, 0, &_tmp56_, &_tmp57_);
			from = _tmp56_;
			to = _tmp57_;
			_tmp58_ = match_info;
			_tmp59_ = g_match_info_fetch (_tmp58_, 0);
			match = _tmp59_;
			_tmp60_ = sample_tweet;
			_tmp61_ = i;
			_tmp62_ = sample_text;
			_tmp63_ = from;
			_tmp64_ = g_utf8_strlen (_tmp62_, (gssize) _tmp63_);
			_tmp65_ = sample_text;
			_tmp66_ = to;
			_tmp67_ = g_utf8_strlen (_tmp65_, (gssize) _tmp66_);
			_tmp68_ = match;
			_tmp69_ = g_strdup (_tmp68_);
			_tmp70_ = g_strdup ("foobar");
			memset (&_tmp71_, 0, sizeof (CbTextEntity));
			_tmp71_.from = (guint) _tmp64_;
			_tmp71_.to = (guint) _tmp67_;
			_g_free0 (_tmp71_.display_text);
			_tmp71_.display_text = _tmp69_;
			_g_free0 (_tmp71_.target);
			_tmp71_.target = _tmp70_;
			cb_text_entity_free (&_tmp60_->source_tweet.entities[_tmp61_]);
			_tmp60_->source_tweet.entities[_tmp61_] = _tmp71_;
			_tmp72_ = _tmp60_->source_tweet.entities[_tmp61_];
			_tmp73_ = match_info;
			g_match_info_next (_tmp73_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (match);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch88_g_regex_error;
				}
				_g_free0 (match);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				_cairo_surface_destroy0 (avatar_surface);
				_g_free0 (sample_text);
				_g_object_unref0 (sample_tweet);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp74_ = i;
			i = _tmp74_ + 1;
			_g_free0 (match);
		}
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
	}
	goto __finally88;
	__catch88_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp75_;
		const gchar* _tmp76_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp75_ = e;
		_tmp76_ = _tmp75_->message;
		g_critical ("SettingsDialog.vala:122: %s", _tmp76_);
		_g_error_free0 (e);
	}
	__finally88:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_cairo_surface_destroy0 (avatar_surface);
		_g_free0 (sample_text);
		_g_object_unref0 (sample_tweet);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp77_ = sample_tweet;
	tweet_utils_sort_entities (&_tmp77_->source_tweet.entities, &_tmp77_->source_tweet.n_entities);
	_tmp78_ = sample_tweet;
	_tmp79_ = account_new ((gint64) 10, "", "");
	_tmp80_ = _tmp79_;
	_tmp81_ = tweet_list_entry_new (_tmp78_, NULL, _tmp80_, FALSE);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->sample_tweet_entry);
	self->priv->sample_tweet_entry = _tmp81_;
	_g_object_unref0 (_tmp80_);
	_tmp82_ = self->priv->sample_tweet_entry;
	_tmp83_ = avatar_surface;
	tweet_list_entry_set_avatar (_tmp82_, _tmp83_);
	_tmp84_ = self->priv->sample_tweet_entry;
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	_tmp85_ = self->priv->sample_tweet_entry;
	tweet_list_entry_set_read_only (_tmp85_, TRUE);
	_tmp86_ = self->priv->sample_tweet_entry;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, gtk_widget_get_type (), GtkWidget));
	_tmp87_ = self->priv->sample_tweet_list;
	_tmp88_ = self->priv->sample_tweet_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, gtk_widget_get_type (), GtkWidget));
	_tmp89_ = settings_get_text_transform_flags ();
	text_transform_flags = _tmp89_;
	self->priv->block_flag_emission = TRUE;
	_tmp90_ = self->priv->remove_trailing_hashtags_switch;
	gtk_switch_set_active (_tmp90_, (text_transform_flags & CB_TEXT_TRANSFORM_REMOVE_TRAILING_HASHTAGS) == CB_TEXT_TRANSFORM_REMOVE_TRAILING_HASHTAGS);
	_tmp91_ = self->priv->remove_media_links_switch;
	gtk_switch_set_active (_tmp91_, (text_transform_flags & CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS) == CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS);
	self->priv->block_flag_emission = FALSE;
	_tmp92_ = settings_get ();
	_tmp93_ = _tmp92_;
	_tmp94_ = self->priv->hide_nsfw_content_switch;
	g_settings_bind (_tmp93_, "hide-nsfw-content", G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, G_TYPE_OBJECT, GObject), "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp93_);
	_tmp95_ = corebird_snippet_manager;
	cb_snippet_manager_query_snippets (_tmp95_, ___lambda187__gh_func, self);
	settings_dialog_add_accels (self);
	settings_dialog_load_geometry (self);
	_cairo_surface_destroy0 (avatar_surface);
	_g_free0 (sample_text);
	_g_object_unref0 (sample_tweet);
	return self;
}


SettingsDialog* settings_dialog_new (Corebird* application) {
	return settings_dialog_construct (TYPE_SETTINGS_DIALOG, application);
}


static gboolean settings_dialog_window_destroy_cb (SettingsDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_SETTINGS_DIALOG (self), FALSE);
	settings_dialog_save_geometry (self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _settings_dialog_window_destroy_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = settings_dialog_window_destroy_cb ((SettingsDialog*) self);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated (ModifySnippetDialog* _sender, const gchar* old_key, const gchar* key, const gchar* value, gpointer self) {
	settings_dialog_snippet_updated_func ((SettingsDialog*) self, old_key, key, value);
}


static void settings_dialog_snippet_entry_activated_cb (SettingsDialog* self, GtkListBoxRow* row) {
	SnippetListEntry* snippet_row = NULL;
	GtkListBoxRow* _tmp0_;
	SnippetListEntry* _tmp1_;
	ModifySnippetDialog* d = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ModifySnippetDialog* _tmp6_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
	snippet_row = _tmp1_;
	_tmp2_ = snippet_list_entry_get_key (snippet_row);
	_tmp3_ = _tmp2_;
	_tmp4_ = snippet_list_entry_get_value (snippet_row);
	_tmp5_ = _tmp4_;
	_tmp6_ = modify_snippet_dialog_new (_tmp3_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	d = _tmp6_;
	g_signal_connect_object (d, "snippet-updated", (GCallback) _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated, self, 0);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (d);
	_g_object_unref0 (snippet_row);
}


static void _settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	settings_dialog_snippet_entry_activated_cb ((SettingsDialog*) self, row);
}


static void settings_dialog_add_snippet_button_clicked_cb (SettingsDialog* self) {
	ModifySnippetDialog* d = NULL;
	ModifySnippetDialog* _tmp0_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = modify_snippet_dialog_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	d = _tmp0_;
	g_signal_connect_object (d, "snippet-updated", (GCallback) _settings_dialog_snippet_updated_func_modify_snippet_dialog_snippet_updated, self, 0);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (d, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (d);
}


static void _settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	settings_dialog_add_snippet_button_clicked_cb ((SettingsDialog*) self);
}


static void settings_dialog_snippet_updated_func (SettingsDialog* self, const gchar* old_key, const gchar* key, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp14_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp2_ = old_key;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = key;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp5_;
		GList* _tmp6_;
		_tmp5_ = self->priv->snippet_list_box;
		_tmp6_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer));
		{
			GList* _row_collection = NULL;
			GList* _row_it = NULL;
			_row_collection = _tmp6_;
			for (_row_it = _row_collection; _row_it != NULL; _row_it = _row_it->next) {
				GtkWidget* _row = NULL;
				_row = (GtkWidget*) _row_it->data;
				{
					SnippetListEntry* srow = NULL;
					GtkWidget* _tmp7_;
					SnippetListEntry* _tmp8_;
					SnippetListEntry* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp7_ = _row;
					_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
					srow = _tmp8_;
					_tmp9_ = srow;
					_tmp10_ = snippet_list_entry_get_key (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = old_key;
					if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
						SnippetListEntry* _tmp13_;
						_tmp13_ = srow;
						snippet_list_entry_reveal (_tmp13_);
						_g_object_unref0 (srow);
						break;
					}
					_g_object_unref0 (srow);
				}
			}
			_g_list_free0 (_row_collection);
		}
		return;
	}
	_tmp14_ = old_key;
	if (_tmp14_ == NULL) {
		SnippetListEntry* e = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		SnippetListEntry* _tmp17_;
		SnippetListEntry* _tmp18_;
		GtkListBox* _tmp19_;
		SnippetListEntry* _tmp20_;
		_tmp15_ = key;
		_tmp16_ = value;
		_tmp17_ = snippet_list_entry_new (_tmp15_, _tmp16_);
		g_object_ref_sink (_tmp17_);
		e = _tmp17_;
		_tmp18_ = e;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		_tmp19_ = self->priv->snippet_list_box;
		_tmp20_ = e;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (e);
	} else {
		GtkListBox* _tmp21_;
		GList* _tmp22_;
		_tmp21_ = self->priv->snippet_list_box;
		_tmp22_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer));
		{
			GList* _row_collection = NULL;
			GList* _row_it = NULL;
			_row_collection = _tmp22_;
			for (_row_it = _row_collection; _row_it != NULL; _row_it = _row_it->next) {
				GtkWidget* _row = NULL;
				_row = (GtkWidget*) _row_it->data;
				{
					SnippetListEntry* srow = NULL;
					GtkWidget* _tmp23_;
					SnippetListEntry* _tmp24_;
					SnippetListEntry* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					_tmp23_ = _row;
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_SNIPPET_LIST_ENTRY, SnippetListEntry));
					srow = _tmp24_;
					_tmp25_ = srow;
					_tmp26_ = snippet_list_entry_get_key (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = old_key;
					if (g_strcmp0 (_tmp27_, _tmp28_) == 0) {
						SnippetListEntry* _tmp29_;
						const gchar* _tmp30_;
						SnippetListEntry* _tmp31_;
						const gchar* _tmp32_;
						_tmp29_ = srow;
						_tmp30_ = key;
						snippet_list_entry_set_key (_tmp29_, _tmp30_);
						_tmp31_ = srow;
						_tmp32_ = value;
						snippet_list_entry_set_value (_tmp31_, _tmp32_);
						_g_object_unref0 (srow);
						break;
					}
					_g_object_unref0 (srow);
				}
			}
			_g_list_free0 (_row_collection);
		}
	}
}


static void settings_dialog_load_geometry (SettingsDialog* self) {
	GVariant* geom = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint32 _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gint32 _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	gint32 _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	gint32 _tmp19_;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_value (_tmp1_, "settings-geometry");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	geom = _tmp3_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp4_ = geom;
	_tmp5_ = g_variant_get_child_value (_tmp4_, (gsize) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_get_int32 (_tmp6_);
	x = (gint) _tmp7_;
	_g_variant_unref0 (_tmp6_);
	_tmp8_ = geom;
	_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) 1);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_int32 (_tmp10_);
	y = (gint) _tmp11_;
	_g_variant_unref0 (_tmp10_);
	_tmp12_ = geom;
	_tmp13_ = g_variant_get_child_value (_tmp12_, (gsize) 2);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_variant_get_int32 (_tmp14_);
	w = (gint) _tmp15_;
	_g_variant_unref0 (_tmp14_);
	_tmp16_ = geom;
	_tmp17_ = g_variant_get_child_value (_tmp16_, (gsize) 3);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_variant_get_int32 (_tmp18_);
	h = (gint) _tmp19_;
	_g_variant_unref0 (_tmp18_);
	_tmp21_ = w;
	if (_tmp21_ == 0) {
		_tmp20_ = TRUE;
	} else {
		gint _tmp22_;
		_tmp22_ = h;
		_tmp20_ = _tmp22_ == 0;
	}
	if (_tmp20_) {
		_g_variant_unref0 (geom);
		return;
	}
	_tmp23_ = x;
	_tmp24_ = y;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp23_, _tmp24_);
	_tmp25_ = w;
	_tmp26_ = h;
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp25_, _tmp26_);
	_g_variant_unref0 (geom);
}


static void settings_dialog_save_geometry (SettingsDialog* self) {
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp0_;
	GVariantBuilder* _tmp1_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	gint _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gint _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	gint _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = G_VARIANT_TYPE_TUPLE;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	builder = _tmp1_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	gtk_window_get_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp4_, &_tmp5_);
	w = _tmp4_;
	h = _tmp5_;
	_tmp6_ = x;
	_tmp7_ = g_variant_new_int32 ((gint32) _tmp6_);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	g_variant_builder_add_value (builder, _tmp8_);
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = y;
	_tmp10_ = g_variant_new_int32 ((gint32) _tmp9_);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_variant_builder_add_value (builder, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = w;
	_tmp13_ = g_variant_new_int32 ((gint32) _tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	g_variant_builder_add_value (builder, _tmp14_);
	_g_variant_unref0 (_tmp14_);
	_tmp15_ = h;
	_tmp16_ = g_variant_new_int32 ((gint32) _tmp15_);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	g_variant_builder_add_value (builder, _tmp17_);
	_g_variant_unref0 (_tmp17_);
	_tmp18_ = settings_get ();
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_builder_end (builder);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	g_settings_set_value (_tmp19_, "settings-geometry", _tmp21_);
	_g_variant_unref0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	_g_variant_builder_unref0 (builder);
}


static gboolean __lambda189_ (SettingsDialog* self) {
	gboolean result = FALSE;
	gtk_window_close (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	result = TRUE;
	return result;
}


static gboolean ___lambda189__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda189_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda190_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "interface");
	result = TRUE;
	return result;
}


static gboolean ___lambda190__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda190_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda191_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "notifications");
	result = TRUE;
	return result;
}


static gboolean ___lambda191__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda191_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda192_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "tweet");
	result = TRUE;
	return result;
}


static gboolean ___lambda192__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda192_ ((SettingsDialog*) self);
	return result;
}


static gboolean __lambda193_ (SettingsDialog* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "snippets");
	result = TRUE;
	return result;
}


static gboolean ___lambda193__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda193_ ((SettingsDialog*) self);
	return result;
}


static void settings_dialog_add_accels (SettingsDialog* self) {
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp0_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = gtk_accel_group_new ();
	ag = _tmp0_;
	gtk_accel_group_connect (ag, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda189__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda189__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_1, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda190__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda190__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_2, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda191__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda191__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_3, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda192__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda192__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	gtk_accel_group_connect (ag, (guint) GDK_KEY_4, GDK_MOD1_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda193__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda193__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), ag);
	_g_object_unref0 (ag);
}


static void settings_dialog_remove_trailing_hashtags_cb (SettingsDialog* self) {
	gboolean _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = self->priv->block_flag_emission;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->remove_trailing_hashtags_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		settings_add_text_transform_flag (CB_TEXT_TRANSFORM_REMOVE_TRAILING_HASHTAGS);
	} else {
		settings_remove_text_transform_flag (CB_TEXT_TRANSFORM_REMOVE_TRAILING_HASHTAGS);
	}
}


static void _settings_dialog_remove_trailing_hashtags_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	settings_dialog_remove_trailing_hashtags_cb ((SettingsDialog*) self);
}


static void settings_dialog_remove_media_links_cb (SettingsDialog* self) {
	gboolean _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (IS_SETTINGS_DIALOG (self));
	_tmp0_ = self->priv->block_flag_emission;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->remove_media_links_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		settings_add_text_transform_flag (CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS);
	} else {
		settings_remove_text_transform_flag (CB_TEXT_TRANSFORM_REMOVE_MEDIA_LINKS);
	}
}


static void _settings_dialog_remove_media_links_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	settings_dialog_remove_media_links_cb ((SettingsDialog*) self);
}


static void settings_dialog_class_init (SettingsDialogClass * klass) {
	gint SettingsDialog_private_offset;
	settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SettingsDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = settings_dialog_finalize;
	SettingsDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/settings-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_mentions_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_mentions_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "round_avatar_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, round_avatar_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_dms_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_dms_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "on_new_tweets_combobox", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, on_new_tweets_combobox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "auto_scroll_on_new_tweets_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, auto_scroll_on_new_tweets_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "double_click_activation_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, double_click_activation_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sample_tweet_list", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, sample_tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_trailing_hashtags_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, remove_trailing_hashtags_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_media_links_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, remove_media_links_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hide_nsfw_content_switch", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, hide_nsfw_content_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "snippet_list_box", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, snippet_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "media_visibility_combobox", FALSE, SettingsDialog_private_offset + G_STRUCT_OFFSET (SettingsDialogPrivate, media_visibility_combobox));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_destroy_cb", G_CALLBACK(_settings_dialog_window_destroy_cb_gtk_widget_delete_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "snippet_entry_activated_cb", G_CALLBACK(_settings_dialog_snippet_entry_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_snippet_button_clicked_cb", G_CALLBACK(_settings_dialog_add_snippet_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "remove_trailing_hashtags_cb", G_CALLBACK(_settings_dialog_remove_trailing_hashtags_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "remove_media_links_cb", G_CALLBACK(_settings_dialog_remove_media_links_cb_g_object_notify));
}


static void settings_dialog_instance_init (SettingsDialog * self) {
	self->priv = SETTINGS_DIALOG_GET_PRIVATE (self);
	self->priv->block_flag_emission = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void settings_dialog_finalize (GObject * obj) {
	SettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS_DIALOG, SettingsDialog);
	_g_object_unref0 (self->priv->on_new_mentions_switch);
	_g_object_unref0 (self->priv->round_avatar_switch);
	_g_object_unref0 (self->priv->on_new_dms_switch);
	_g_object_unref0 (self->priv->on_new_tweets_combobox);
	_g_object_unref0 (self->priv->auto_scroll_on_new_tweets_switch);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->double_click_activation_switch);
	_g_object_unref0 (self->priv->sample_tweet_list);
	_g_object_unref0 (self->priv->remove_trailing_hashtags_switch);
	_g_object_unref0 (self->priv->remove_media_links_switch);
	_g_object_unref0 (self->priv->hide_nsfw_content_switch);
	_g_object_unref0 (self->priv->snippet_list_box);
	_g_object_unref0 (self->priv->media_visibility_combobox);
	_g_object_unref0 (self->priv->sample_tweet_entry);
	G_OBJECT_CLASS (settings_dialog_parent_class)->finalize (obj);
}


GType settings_dialog_get_type (void) {
	static volatile gsize settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&settings_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDialog), 0, (GInstanceInitFunc) settings_dialog_instance_init, NULL };
		GType settings_dialog_type_id;
		settings_dialog_type_id = g_type_register_static (gtk_window_get_type (), "SettingsDialog", &g_define_type_info, 0);
		g_once_init_leave (&settings_dialog_type_id__volatile, settings_dialog_type_id);
	}
	return settings_dialog_type_id__volatile;
}



