/* ListListEntry.c generated by valac 0.36.4, the Vala compiler
 * generated from ListListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <gio/gio.h>
#include <gdk/gdk.h>


#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;
typedef struct _ListListEntryPrivate ListListEntryPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block66Data Block66Data;
typedef struct _Block67Data Block67Data;
typedef struct _Block68Data Block68Data;

struct _ListListEntry {
	GtkListBoxRow parent_instance;
	ListListEntryPrivate * priv;
	gint64 id;
	gboolean user_list;
	gchar* creator_screen_name;
	gint n_subscribers;
	gint n_members;
	gint64 created_at;
	gchar* mode;
};

struct _ListListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _ListListEntryPrivate {
	GtkLabel* name_label;
	GtkLabel* description_label;
	GtkStack* stack;
	GtkButton* subscribe_button;
	GtkButton* unsubscribe_button;
	GtkButton* delete_button;
	GtkButton* cancel_button;
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block66Data {
	int _ref_count_;
	ListListEntry* self;
	RestProxyCall* call;
};

struct _Block67Data {
	int _ref_count_;
	ListListEntry* self;
	RestProxyCall* call;
};

struct _Block68Data {
	int _ref_count_;
	ListListEntry* self;
	RestProxyCall* call;
};


static gpointer list_list_entry_parent_class = NULL;

GType list_list_entry_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define LIST_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_LIST_ENTRY, ListListEntryPrivate))
enum  {
	LIST_LIST_ENTRY_DUMMY_PROPERTY,
	LIST_LIST_ENTRY_NAME,
	LIST_LIST_ENTRY_DESCRIPTION
};
gint list_list_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
const gchar* list_list_entry_get_name (ListListEntry* self);
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
static gchar* list_list_entry_normalize_name (ListListEntry* self, const gchar* name);
void list_list_entry_set_name (ListListEntry* self, const gchar* value);
void list_list_entry_set_description (ListListEntry* self, const gchar* value);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void list_list_entry_delete_button_clicked_cb (ListListEntry* self);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static void __lambda64_ (Block66Data* _data66_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda64__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_list_entry_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_list_entry_subscribe_button_clicked_cb (ListListEntry* self);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
static void __lambda65_ (Block67Data* _data67_, GObject* o, GAsyncResult* res);
static void ___lambda65__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_list_entry_subscribe_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_list_entry_unsubscribe_button_clicked_cb (ListListEntry* self);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void __lambda66_ (Block68Data* _data68_, GObject* o, GAsyncResult* res);
static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_list_entry_unsubscribe_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_list_entry_more_button_clicked_cb (ListListEntry* self);
static void _list_list_entry_more_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_list_entry_cancel_button_clicked_cb (ListListEntry* self);
static void _list_list_entry_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean list_list_entry_focus_out_cb (ListListEntry* self);
static gboolean _list_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
ListListEntry* list_list_entry_new (void);
ListListEntry* list_list_entry_construct (GType object_type);
const gchar* list_list_entry_get_description (ListListEntry* self);
static void list_list_entry_finalize (GObject * obj);
static void _vala_list_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_list_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gint list_list_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2) {
	gint result = 0;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkListBoxRow* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (r1), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (r2), 0);
	_tmp0_ = r1;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		result = -1;
		return result;
	}
	_tmp1_ = r1;
	_tmp2_ = list_list_entry_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = r2;
	_tmp5_ = list_list_entry_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIST_LIST_ENTRY, ListListEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ascii_strcasecmp (_tmp3_, _tmp6_);
	result = _tmp7_;
	return result;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account) {
	ListListEntry * self = NULL;
	Account* _tmp0_;
	JsonObject* user = NULL;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	JsonObject* _tmp8_;
	const gchar* _tmp9_;
	JsonObject* _tmp10_;
	gint64 _tmp11_;
	JsonObject* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	JsonObject* _tmp15_;
	gint64 _tmp16_;
	JsonObject* _tmp17_;
	gint64 _tmp18_;
	JsonObject* _tmp19_;
	const gchar* _tmp20_;
	GDateTime* _tmp21_;
	GDateTime* _tmp22_;
	gint64 _tmp23_;
	JsonObject* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean following = FALSE;
	JsonObject* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	JsonObject* _tmp39_;
	gint64 _tmp40_;
	Account* _tmp41_;
	gint64 _tmp42_;
	g_return_val_if_fail (obj != NULL, NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (ListListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = obj;
	_tmp2_ = json_object_get_object_member (_tmp1_, "user");
	_tmp3_ = _json_object_ref0 (_tmp2_);
	user = _tmp3_;
	_tmp4_ = obj;
	_tmp5_ = json_object_get_string_member (_tmp4_, "full_name");
	_tmp6_ = list_list_entry_normalize_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	list_list_entry_set_name (self, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = obj;
	_tmp9_ = json_object_get_string_member (_tmp8_, "description");
	list_list_entry_set_description (self, _tmp9_);
	_tmp10_ = obj;
	_tmp11_ = json_object_get_int_member (_tmp10_, "id");
	self->id = _tmp11_;
	_tmp12_ = user;
	_tmp13_ = json_object_get_string_member (_tmp12_, "screen_name");
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (self->creator_screen_name);
	self->creator_screen_name = _tmp14_;
	_tmp15_ = obj;
	_tmp16_ = json_object_get_int_member (_tmp15_, "subscriber_count");
	self->n_subscribers = (gint) _tmp16_;
	_tmp17_ = obj;
	_tmp18_ = json_object_get_int_member (_tmp17_, "member_count");
	self->n_members = (gint) _tmp18_;
	_tmp19_ = obj;
	_tmp20_ = json_object_get_string_member (_tmp19_, "created_at");
	_tmp21_ = cb_utils_parse_date (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_date_time_to_unix (_tmp22_);
	self->created_at = _tmp23_;
	_g_date_time_unref0 (_tmp22_);
	_tmp24_ = obj;
	_tmp25_ = json_object_get_string_member (_tmp24_, "mode");
	_tmp26_ = g_strdup (_tmp25_);
	_g_free0 (self->mode);
	self->mode = _tmp26_;
	_tmp27_ = obj;
	_tmp28_ = json_object_get_boolean_member (_tmp27_, "following");
	following = _tmp28_;
	_tmp30_ = following;
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		JsonObject* _tmp31_;
		gint64 _tmp32_;
		Account* _tmp33_;
		gint64 _tmp34_;
		_tmp31_ = user;
		_tmp32_ = json_object_get_int_member (_tmp31_, "id");
		_tmp33_ = account;
		_tmp34_ = _tmp33_->id;
		_tmp29_ = _tmp32_ == _tmp34_;
	}
	if (_tmp29_) {
		GtkButton* _tmp35_;
		GtkButton* _tmp36_;
		_tmp35_ = self->priv->unsubscribe_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
		_tmp36_ = self->priv->subscribe_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkButton* _tmp37_;
		GtkButton* _tmp38_;
		_tmp37_ = self->priv->unsubscribe_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
		_tmp38_ = self->priv->subscribe_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp39_ = user;
	_tmp40_ = json_object_get_int_member (_tmp39_, "id");
	_tmp41_ = account;
	_tmp42_ = _tmp41_->id;
	if (_tmp40_ == _tmp42_) {
		GtkButton* _tmp43_;
		self->user_list = TRUE;
		_tmp43_ = self->priv->unsubscribe_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkButton* _tmp44_;
		_tmp44_ = self->priv->delete_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget));
	}
	_json_object_unref0 (user);
	return self;
}


ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account) {
	return list_list_entry_construct_from_json_data (TYPE_LIST_LIST_ENTRY, obj, account);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch78_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch78_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally78;
	__catch78_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally78:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* list_list_entry_normalize_name (ListListEntry* self, const gchar* name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (IS_LIST_LIST_ENTRY (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = string_contains (_tmp0_, "/lists/");
	if (_tmp1_) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = name;
		_tmp3_ = string_replace (_tmp2_, "/lists/", "/");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = name;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}


static Block66Data* block66_data_ref (Block66Data* _data66_) {
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}


static void block66_data_unref (void * _userdata_) {
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		ListListEntry* self;
		self = _data66_->self;
		_g_object_unref0 (_data66_->call);
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}


static void __lambda64_ (Block66Data* _data66_, GObject* o, GAsyncResult* res) {
	ListListEntry* self;
	GError * _inner_error_ = NULL;
	self = _data66_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data66_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch79_g_error;
		}
	}
	goto __finally79;
	__catch79_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data66_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 117, "ListListEntry.vala", NULL);
		_g_error_free0 (e);
		return;
	}
	__finally79:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda64__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda64_ (self, source_object, res);
	block66_data_unref (self);
}


static void list_list_entry_delete_button_clicked_cb (ListListEntry* self) {
	Block66Data* _data66_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data66_->call = _tmp2_;
	rest_proxy_call_set_function (_data66_->call, "1.1/lists/destroy.json");
	rest_proxy_call_set_method (_data66_->call, "POST");
	_tmp3_ = self->id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data66_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data66_->call, NULL, ___lambda64__gasync_ready_callback, block66_data_ref (_data66_));
	block66_data_unref (_data66_);
	_data66_ = NULL;
}


static void _list_list_entry_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_list_entry_delete_button_clicked_cb ((ListListEntry*) self);
}


static Block67Data* block67_data_ref (Block67Data* _data67_) {
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}


static void block67_data_unref (void * _userdata_) {
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		ListListEntry* self;
		self = _data67_->self;
		_g_object_unref0 (_data67_->call);
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}


static void __lambda65_ (Block67Data* _data67_, GObject* o, GAsyncResult* res) {
	ListListEntry* self;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GError * _inner_error_ = NULL;
	self = _data67_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data67_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch80_g_error;
		}
	}
	goto __finally80;
	__catch80_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data67_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 137, "ListListEntry.vala", NULL);
		_g_error_free0 (e);
		{
			GtkButton* _tmp4_;
			GtkButton* _tmp5_;
			_tmp4_ = self->priv->subscribe_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp5_ = self->priv->cancel_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
		}
		return;
	}
	__finally80:
	{
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = self->priv->subscribe_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp7_ = self->priv->cancel_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->subscribe_button;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->unsubscribe_button;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda65__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda65_ (self, source_object, res);
	block67_data_unref (self);
}


static void list_list_entry_subscribe_button_clicked_cb (ListListEntry* self) {
	Block67Data* _data67_;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_data67_->self = g_object_ref (self);
	_tmp0_ = self->priv->subscribe_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->cancel_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->account;
	_tmp3_ = _tmp2_->proxy;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data67_->call = _tmp4_;
	rest_proxy_call_set_function (_data67_->call, "1.1/lists/subscribers/create.json");
	rest_proxy_call_set_method (_data67_->call, "POST");
	_tmp5_ = self->id;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	rest_proxy_call_add_param (_data67_->call, "list_id", _tmp7_);
	_g_free0 (_tmp7_);
	rest_proxy_call_invoke_async (_data67_->call, NULL, ___lambda65__gasync_ready_callback, block67_data_ref (_data67_));
	block67_data_unref (_data67_);
	_data67_ = NULL;
}


static void _list_list_entry_subscribe_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_list_entry_subscribe_button_clicked_cb ((ListListEntry*) self);
}


static Block68Data* block68_data_ref (Block68Data* _data68_) {
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}


static void block68_data_unref (void * _userdata_) {
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		ListListEntry* self;
		self = _data68_->self;
		_g_object_unref0 (_data68_->call);
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}


static void __lambda66_ (Block68Data* _data68_, GObject* o, GAsyncResult* res) {
	ListListEntry* self;
	GError * _inner_error_ = NULL;
	self = _data68_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data68_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch81_g_error;
		}
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data68_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		utils_show_error_object (_tmp1_, _tmp3_, 161, "ListListEntry.vala", NULL);
		_g_error_free0 (e);
		return;
	}
	__finally81:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda66_ (self, source_object, res);
	block68_data_unref (self);
}


static void list_list_entry_unsubscribe_button_clicked_cb (ListListEntry* self) {
	Block68Data* _data68_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data68_->call = _tmp2_;
	rest_proxy_call_set_function (_data68_->call, "1.1/lists/subscribers/destroy.json");
	rest_proxy_call_set_method (_data68_->call, "POST");
	_tmp3_ = self->id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data68_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data68_->call, NULL, ___lambda66__gasync_ready_callback, block68_data_ref (_data68_));
	block68_data_unref (_data68_);
	_data68_ = NULL;
}


static void _list_list_entry_unsubscribe_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_list_entry_unsubscribe_button_clicked_cb ((ListListEntry*) self);
}


static void list_list_entry_more_button_clicked_cb (ListListEntry* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "more");
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
}


static void _list_list_entry_more_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_list_entry_more_button_clicked_cb ((ListListEntry*) self);
}


static void list_list_entry_cancel_button_clicked_cb (ListListEntry* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "default");
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
}


static void _list_list_entry_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_list_entry_cancel_button_clicked_cb ((ListListEntry*) self);
}


static gboolean list_list_entry_focus_out_cb (ListListEntry* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	g_return_val_if_fail (IS_LIST_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "default");
	result = FALSE;
	return result;
}


static gboolean _list_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = list_list_entry_focus_out_cb ((ListListEntry*) self);
	return result;
}


ListListEntry* list_list_entry_construct (GType object_type) {
	ListListEntry * self = NULL;
	self = (ListListEntry*) g_object_new (object_type, NULL);
	return self;
}


ListListEntry* list_list_entry_new (void) {
	return list_list_entry_construct (TYPE_LIST_LIST_ENTRY);
}


const gchar* list_list_entry_get_name (ListListEntry* self) {
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (IS_LIST_LIST_ENTRY (self), NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void list_list_entry_set_name (ListListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_tmp0_ = self->priv->name_label;
	_tmp1_ = value;
	_tmp2_ = list_list_entry_normalize_name (self, _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "name");
}


const gchar* list_list_entry_get_description (ListListEntry* self) {
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (IS_LIST_LIST_ENTRY (self), NULL);
	_tmp0_ = self->priv->description_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void list_list_entry_set_description (ListListEntry* self, const gchar* value) {
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (IS_LIST_LIST_ENTRY (self));
	_tmp0_ = self->priv->description_label;
	_tmp1_ = value;
	gtk_label_set_label (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "description");
}


static void list_list_entry_class_init (ListListEntryClass * klass) {
	gint ListListEntry_private_offset;
	list_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListListEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_list_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = list_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_LIST_ENTRY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_LIST_ENTRY_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ListListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/list-list-entry.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribe_button", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, subscribe_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unsubscribe_button", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, unsubscribe_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ListListEntry_private_offset + G_STRUCT_OFFSET (ListListEntryPrivate, cancel_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_list_list_entry_delete_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "subscribe_button_clicked_cb", G_CALLBACK(_list_list_entry_subscribe_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "unsubscribe_button_clicked_cb", G_CALLBACK(_list_list_entry_unsubscribe_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "more_button_clicked_cb", G_CALLBACK(_list_list_entry_more_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_list_list_entry_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "focus_out_cb", G_CALLBACK(_list_list_entry_focus_out_cb_gtk_widget_focus_out_event));
}


static void list_list_entry_instance_init (ListListEntry * self) {
	self->priv = LIST_LIST_ENTRY_GET_PRIVATE (self);
	self->user_list = FALSE;
	self->n_members = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void list_list_entry_finalize (GObject * obj) {
	ListListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_LIST_ENTRY, ListListEntry);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->subscribe_button);
	_g_object_unref0 (self->priv->unsubscribe_button);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_free0 (self->creator_screen_name);
	_g_free0 (self->mode);
	G_OBJECT_CLASS (list_list_entry_parent_class)->finalize (obj);
}


GType list_list_entry_get_type (void) {
	static volatile gsize list_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&list_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListListEntry), 0, (GInstanceInitFunc) list_list_entry_instance_init, NULL };
		GType list_list_entry_type_id;
		list_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ListListEntry", &g_define_type_info, 0);
		g_once_init_leave (&list_list_entry_type_id__volatile, list_list_entry_type_id);
	}
	return list_list_entry_type_id__volatile;
}


static void _vala_list_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_LIST_ENTRY, ListListEntry);
	switch (property_id) {
		case LIST_LIST_ENTRY_NAME:
		g_value_set_string (value, list_list_entry_get_name (self));
		break;
		case LIST_LIST_ENTRY_DESCRIPTION:
		g_value_set_string (value, list_list_entry_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_list_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_LIST_ENTRY, ListListEntry);
	switch (property_id) {
		case LIST_LIST_ENTRY_NAME:
		list_list_entry_set_name (self, g_value_get_string (value));
		break;
		case LIST_LIST_ENTRY_DESCRIPTION:
		list_list_entry_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



