# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr7 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK

lw a0, 0(s0)
lw a1, 0(s0)
lw a2, 0(s0)
lw a3, 0(s0)

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      4
# CHECK-NEXT: Total Cycles:      9
# CHECK-NEXT: Total uOps:        4

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.44
# CHECK-NEXT: IPC:               0.44
# CHECK-NEXT: Block RThroughput: 4.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00    *                   lw	a0, 0(s0)
# CHECK-NEXT:  1      3     1.00    *                   lw	a1, 0(s0)
# CHECK-NEXT:  1      3     1.00    *                   lw	a2, 0(s0)
# CHECK-NEXT:  1      3     1.00    *                   lw	a3, 0(s0)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SCR7_ALU_DIV_IS
# CHECK-NEXT: [1]   - SCR7_ALU_MUL_IS
# CHECK-NEXT: [2]   - SCR7_DIV
# CHECK-NEXT: [3]   - SCR7_FALU
# CHECK-NEXT: [4]   - SCR7_FDIVSQRT
# CHECK-NEXT: [5]   - SCR7_FMA
# CHECK-NEXT: [6]   - SCR7_FPU_IS
# CHECK-NEXT: [7]   - SCR7_LSU
# CHECK-NEXT: [8]   - SCR7_MUL

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT:  -      -      -      -      -      -      -     4.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -     lw	a0, 0(s0)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -     lw	a1, 0(s0)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -     lw	a2, 0(s0)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -     lw	a3, 0(s0)
