; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+movrs,+avx10.2-256 -verify-machineinstrs --show-mc-encoding | FileCheck %s --check-prefixes=CHECK

define <2 x i64> @test_mm_movrsb_epu8(ptr %__A) {
; CHECK-LABEL: test_mm_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsb (%rdi), %xmm0 # encoding: [0x62,0xf5,0x7f,0x08,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i8> @llvm.x86.avx10.vmovrsb128(ptr %__A)
  %1 = bitcast <16 x i8> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_movrsb_epu8(<2 x i64> %__A, i16 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm_mask_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %xmm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x09,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i8> @llvm.x86.avx10.vmovrsb128(ptr %__C)
  %1 = bitcast <2 x i64> %__A to <16 x i8>
  %2 = bitcast i16 %__B to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i8> %0, <16 x i8> %1
  %4 = bitcast <16 x i8> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_movrsb_epu8(i16 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm_maskz_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0x89,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i8> @llvm.x86.avx10.vmovrsb128(ptr %__B )
  %1 = bitcast i16 %__A to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i8> %0, <16 x i8> zeroinitializer
  %3 = bitcast <16 x i8> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_movrsb_epu8(ptr %__A) {
; CHECK-LABEL: test_mm256_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsb (%rdi), %ymm0 # encoding: [0x62,0xf5,0x7f,0x28,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i8> @llvm.x86.avx10.vmovrsb256(ptr %__A)
  %1 = bitcast <32 x i8> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_movrsb_epu8(<4 x i64> %__A, i32 %__B, ptr %__C) {
; CHECK-LABEL: test_mm256_mask_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %ymm0 {%k1} # encoding: [0x62,0xf5,0x7f,0x29,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i8> @llvm.x86.avx10.vmovrsb256(ptr %__C)
  %1 = bitcast <4 x i64> %__A to <32 x i8>
  %2 = bitcast i32 %__B to <32 x i1>
  %3 = select <32 x i1> %2, <32 x i8> %0, <32 x i8> %1
  %4 = bitcast <32 x i8> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_movrsb_epu8(i32 %__A, ptr %__B) {
; CHECK-LABEL: test_mm256_maskz_movrsb_epu8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsb (%rsi), %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7f,0xa9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <32 x i8> @llvm.x86.avx10.vmovrsb256(ptr %__B)
  %1 = bitcast i32 %__A to <32 x i1>
  %2 = select <32 x i1> %1, <32 x i8> %0, <32 x i8> zeroinitializer
  %3 = bitcast <32 x i8> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x i64> @test_mm_movrsd_epu32(ptr %__A) {
; CHECK-LABEL: test_mm_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsd (%rdi), %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx10.vmovrsd128(ptr %__A)
  %1 = bitcast <4 x i32> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_movrsd_epu32(<2 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm_mask_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %xmm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx10.vmovrsd128(ptr %__C)
  %1 = bitcast <2 x i64> %__A to <4 x i32>
  %2 = bitcast i8 %__B to <8 x i1>
  %extract.i = shufflevector <8 x i1> %2, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> %1
  %4 = bitcast <4 x i32> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_movrsd_epu32(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm_maskz_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0x89,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i32> @llvm.x86.avx10.vmovrsd128(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i32> %0, <4 x i32> zeroinitializer
  %3 = bitcast <4 x i32> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_movrsd_epu32(ptr %__A) {
; CHECK-LABEL: test_mm256_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsd (%rdi), %ymm0 # encoding: [0x62,0xf5,0x7e,0x28,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx10.vmovrsd256(ptr %__A)
  %1 = bitcast <8 x i32> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_movrsd_epu32(<4 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm256_mask_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %ymm0 {%k1} # encoding: [0x62,0xf5,0x7e,0x29,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx10.vmovrsd256(ptr %__C)
  %1 = bitcast <4 x i64> %__A to <8 x i32>
  %2 = bitcast i8 %__B to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i32> %0, <8 x i32> %1
  %4 = bitcast <8 x i32> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_movrsd_epu32(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm256_maskz_movrsd_epu32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsd (%rsi), %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0x7e,0xa9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i32> @llvm.x86.avx10.vmovrsd256(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i32> %0, <8 x i32> zeroinitializer
  %3 = bitcast <8 x i32> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <2 x i64> @test_mm_movrsq_epu64(ptr %__A) {
; CHECK-LABEL: test_mm_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsq (%rdi), %xmm0 # encoding: [0x62,0xf5,0xfe,0x08,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx10.vmovrsq128(ptr %__A)
  ret <2 x i64> %0
}

define <2 x i64> @test_mm_mask_movrsq_epu64(<2 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm_mask_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %xmm0 {%k1} # encoding: [0x62,0xf5,0xfe,0x09,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx10.vmovrsq128(ptr %__C)
  %1 = bitcast i8 %__B to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> poison, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> %__A
  ret <2 x i64> %2
}

define <2 x i64> @test_mm_maskz_movrsq_epu64(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm_maskz_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xfe,0x89,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <2 x i64> @llvm.x86.avx10.vmovrsq128(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> poison, <2 x i32> <i32 0, i32 1>
  %2 = select <2 x i1> %extract.i, <2 x i64> %0, <2 x i64> zeroinitializer
  ret <2 x i64> %2
}

define <4 x i64> @test_mm256_movrsq_epu64(ptr %__A) {
; CHECK-LABEL: test_mm256_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsq (%rdi), %ymm0 # encoding: [0x62,0xf5,0xfe,0x28,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx10.vmovrsq256(ptr %__A)
  ret <4 x i64> %0
}

define <4 x i64> @test_mm256_mask_movrsq_epu64(<4 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm256_mask_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %ymm0 {%k1} # encoding: [0x62,0xf5,0xfe,0x29,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx10.vmovrsq256(ptr %__C)
  %1 = bitcast i8 %__B to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> %__A
  ret <4 x i64> %2
}

define <4 x i64> @test_mm256_maskz_movrsq_epu64(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm256_maskz_movrsq_epu64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsq (%rsi), %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xfe,0xa9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x i64> @llvm.x86.avx10.vmovrsq256(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %extract.i = shufflevector <8 x i1> %1, <8 x i1> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = select <4 x i1> %extract.i, <4 x i64> %0, <4 x i64> zeroinitializer
  ret <4 x i64> %2
}

define <2 x i64> @test_mm_movrsw_epu16(ptr %__A) {
; CHECK-LABEL: test_mm_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsw (%rdi), %xmm0 # encoding: [0x62,0xf5,0xff,0x08,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i16> @llvm.x86.avx10.vmovrsw128(ptr %__A)
  %1 = bitcast <8 x i16> %0 to <2 x i64>
  ret <2 x i64> %1
}

define <2 x i64> @test_mm_mask_movrsw_epu16(<2 x i64> %__A, i8 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm_mask_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %xmm0 {%k1} # encoding: [0x62,0xf5,0xff,0x09,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i16> @llvm.x86.avx10.vmovrsw128(ptr %__C)
  %1 = bitcast <2 x i64> %__A to <8 x i16>
  %2 = bitcast i8 %__B to <8 x i1>
  %3 = select <8 x i1> %2, <8 x i16> %0, <8 x i16> %1
  %4 = bitcast <8 x i16> %3 to <2 x i64>
  ret <2 x i64> %4
}

define <2 x i64> @test_mm_maskz_movrsw_epu16(i8 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm_maskz_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %xmm0 {%k1} {z} # encoding: [0x62,0xf5,0xff,0x89,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x i16> @llvm.x86.avx10.vmovrsw128(ptr %__B)
  %1 = bitcast i8 %__A to <8 x i1>
  %2 = select <8 x i1> %1, <8 x i16> %0, <8 x i16> zeroinitializer
  %3 = bitcast <8 x i16> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @test_mm256_movrsw_epu16(ptr %__A) {
; CHECK-LABEL: test_mm256_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmovrsw (%rdi), %ymm0 # encoding: [0x62,0xf5,0xff,0x28,0x6f,0x07]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i16> @llvm.x86.avx10.vmovrsw256(ptr %__A)
  %1 = bitcast <16 x i16> %0 to <4 x i64>
  ret <4 x i64> %1
}

define <4 x i64> @test_mm256_mask_movrsw_epu16(<4 x i64> %__A, i16 zeroext %__B, ptr %__C) {
; CHECK-LABEL: test_mm256_mask_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %ymm0 {%k1} # encoding: [0x62,0xf5,0xff,0x29,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i16> @llvm.x86.avx10.vmovrsw256(ptr %__C)
  %1 = bitcast <4 x i64> %__A to <16 x i16>
  %2 = bitcast i16 %__B to <16 x i1>
  %3 = select <16 x i1> %2, <16 x i16> %0, <16 x i16> %1
  %4 = bitcast <16 x i16> %3 to <4 x i64>
  ret <4 x i64> %4
}

define <4 x i64> @test_mm256_maskz_movrsw_epu16(i16 zeroext %__A, ptr %__B) {
; CHECK-LABEL: test_mm256_maskz_movrsw_epu16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; CHECK-NEXT:    vmovrsw (%rsi), %ymm0 {%k1} {z} # encoding: [0x62,0xf5,0xff,0xa9,0x6f,0x06]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <16 x i16> @llvm.x86.avx10.vmovrsw256(ptr %__B)
  %1 = bitcast i16 %__A to <16 x i1>
  %2 = select <16 x i1> %1, <16 x i16> %0, <16 x i16> zeroinitializer
  %3 = bitcast <16 x i16> %2 to <4 x i64>
  ret <4 x i64> %3
}

declare <16 x i8> @llvm.x86.avx10.vmovrsb128(ptr)
declare <32 x i8> @llvm.x86.avx10.vmovrsb256(ptr)
declare <4 x i32> @llvm.x86.avx10.vmovrsd128(ptr)
declare <8 x i32> @llvm.x86.avx10.vmovrsd256(ptr)
declare <2 x i64> @llvm.x86.avx10.vmovrsq128(ptr)
declare <4 x i64> @llvm.x86.avx10.vmovrsq256(ptr)
declare <8 x i16> @llvm.x86.avx10.vmovrsw128(ptr)
declare <16 x i16> @llvm.x86.avx10.vmovrsw256(ptr)
