; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -select-optimize -mtriple=arm64-apple-macosx -S %s | FileCheck %s
; RUN: opt -passes='require<profile-summary>,function(select-optimize)' -mtriple=arm64-apple-macosx -S %s | FileCheck %s

define void @test_add_zext(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[J]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[TMP0]], [[SELECT_TRUE_SINK]] ], [ [[J]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = zext i1 %cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_zext_first_op(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_zext_first_op(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV1:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[DST]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 1, [[J]]
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[TMP0]], [[SELECT_TRUE_SINK]] ], [ [[J]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST1:%.*]] = getelementptr inbounds ptr, ptr [[DST1:%.*]], i64 [[IV1]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST1]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV1]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV1]], [[J_START]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = zext i1 %cmp3 to i64
  %j.next = add nsw i64 %dec, %j
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_zext_not(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_zext_not(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[J]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], [[J_START]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = zext i1 %not.cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_sext(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[TMP0]], [[SELECT_TRUE_SINK]] ], [ [[J]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = sext i1 %cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_sext_not(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_sext_not(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[NOT_CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[NOT_CMP3_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_sext_not_and_regular_select(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_sext_not_and_regular_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END1:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END1]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = add nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END1]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[SINK:%.*]] = phi ptr [ [[L_I]], [[LOOP]] ], [ [[L_J]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store ptr [[SINK]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %sink = select i1 %cmp3, ptr %l.i, ptr %l.j
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store ptr %sink, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_sext_not_and_regular_select2(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_add_sext_not_and_regular_select2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END1:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARRAYIDX1]], align 8
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARRAYIDX2]], align 8
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds i64, ptr [[TMP0]], i64 [[P:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[ARRAYIDX_I]], align 8
; CHECK-NEXT:    [[ARRAYIDX1_I:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i64 [[P]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[ARRAYIDX1_I]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp slt i64 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END1]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP5:%.*]] = add nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END1]]
; CHECK:       select.end:
; CHECK-NEXT:    [[DOTSINK:%.*]] = phi ptr [ [[TMP0]], [[LOOP]] ], [ [[TMP1]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP5]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store ptr [[DOTSINK]], ptr [[TMP4]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.gep.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.gep.j = load ptr, ptr %gep.j, align 8
  %gep.i.1 = getelementptr inbounds i64, ptr %l.gep.i, i64 %p
  %2 = load i64, ptr %gep.i.1, align 8
  %gep.j.1 = getelementptr inbounds i64, ptr %l.gep.j, i64 %p
  %3 = load i64, ptr %gep.j.1, align 8
  %cmp3 = icmp slt i64 %2, %3
  %sel = select i1 %cmp3, ptr %l.gep.i, ptr %l.gep.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = add nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store ptr %sel, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_zext(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_zext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = sub nsw i64 [[J]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[TMP0]], [[SELECT_TRUE_SINK]] ], [ [[J]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = zext i1 %cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_zext_first_op(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_zext_first_op(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV1:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[DST]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[J_NEXT]] = sub nsw i64 [[DEC]], [[J]]
; CHECK-NEXT:    [[GEP_DST1:%.*]] = getelementptr inbounds ptr, ptr [[DST1:%.*]], i64 [[IV1]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST1]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV1]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV1]], [[J_START]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = zext i1 %cmp3 to i64
  %j.next = sub nsw i64 %dec, %j
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_zext_not(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_zext_not(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = zext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = sub nsw i64 [[J]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], [[J_START]]
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = zext i1 %not.cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_sext(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_sext(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = sub nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[TMP0]], [[SELECT_TRUE_SINK]] ], [ [[J]], [[LOOP]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %dec = sext i1 %cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_sext_not(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_sext_not(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[NOT_CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[NOT_CMP3_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = sub nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[J_NEXT]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store i64 %j.next, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_sext_not_and_regular_select(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_sext_not_and_regular_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END1:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[L_J:%.*]] = load ptr, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp ult ptr [[L_I]], [[L_J]]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END1]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP0:%.*]] = sub nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END1]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP0]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[SINK:%.*]] = phi ptr [ [[L_I]], [[LOOP]] ], [ [[L_J]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store ptr [[SINK]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.j = load ptr, ptr %gep.j, align 8
  %cmp3 = icmp ult ptr %l.i, %l.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %sink = select i1 %cmp3, ptr %l.i, ptr %l.j
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store ptr %sink, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_sub_sext_not_and_regular_select2(ptr %dst, ptr %src, i64 %j.start, i64 %p, i64 %i.start) {
; CHECK-LABEL: @test_sub_sext_not_and_regular_select2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END1:%.*]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[HIGH:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[J_NEXT]], [[SELECT_END1]] ]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARRAYIDX1]], align 8
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds ptr, ptr [[SRC]], i64 [[J]]
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARRAYIDX2]], align 8
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds i64, ptr [[TMP0]], i64 [[P:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[ARRAYIDX_I]], align 8
; CHECK-NEXT:    [[ARRAYIDX1_I:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i64 [[P]]
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[ARRAYIDX1_I]], align 8
; CHECK-NEXT:    [[CMP3:%.*]] = icmp slt i64 [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[CMP3_FROZEN:%.*]] = freeze i1 [[CMP3]]
; CHECK-NEXT:    br i1 [[CMP3_FROZEN]], label [[SELECT_END1]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP5:%.*]] = sub nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END1]]
; CHECK:       select.end:
; CHECK-NEXT:    [[DOTSINK:%.*]] = phi ptr [ [[TMP0]], [[LOOP]] ], [ [[TMP1]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[LOOP]] ], [ [[TMP5]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_CMP3:%.*]] = xor i1 [[CMP3]], true
; CHECK-NEXT:    [[DEC:%.*]] = sext i1 [[NOT_CMP3]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr inbounds ptr, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store ptr [[DOTSINK]], ptr [[TMP4]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV]], [[HIGH]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %l.gep.i = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds ptr, ptr %src, i64 %j
  %l.gep.j = load ptr, ptr %gep.j, align 8
  %gep.i.1 = getelementptr inbounds i64, ptr %l.gep.i, i64 %p
  %2 = load i64, ptr %gep.i.1, align 8
  %gep.j.1 = getelementptr inbounds i64, ptr %l.gep.j, i64 %p
  %3 = load i64, ptr %gep.j.1, align 8
  %cmp3 = icmp slt i64 %2, %3
  %sel = select i1 %cmp3, ptr %l.gep.i, ptr %l.gep.j
  %not.cmp3 = xor i1 %cmp3, true
  %dec = sext i1 %not.cmp3 to i64
  %j.next = sub nsw i64 %j, %dec
  %gep.dst = getelementptr inbounds ptr, ptr %dst, i64 %iv
  store ptr %sel, ptr %gep.dst, align 8
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, %j.start
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_lshr_add_regular_select(ptr %dst, ptr %src, i64 %i.start, i64 %j.start) {
; CHECK-LABEL: @test_add_lshr_add_regular_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 100000, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[I_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds i64, ptr [[TMP0]], i64 [[J]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP1]], -1
; CHECK-NEXT:    [[SHIFT:%.*]] = lshr i64 [[TMP1]], 63
; CHECK-NEXT:    [[CMP_FROZEN:%.*]] = freeze i1 [[CMP]]
; CHECK-NEXT:    br i1 [[CMP_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw i64 [[I]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i64 [[J]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[SELECT_TRUE_SINK]] ], [ [[TMP3]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[I_NEXT]] = phi i64 [ [[TMP2]], [[SELECT_TRUE_SINK]] ], [ [[I]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[COND:%.*]] = phi i64 [ [[J]], [[SELECT_TRUE_SINK]] ], [ [[I]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[INC:%.*]] = zext i1 [[CMP]] to i64
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr i64, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[COND]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], -1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 0
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 100000, %entry ], [ %iv.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %i.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %0 = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds i64, ptr %0, i64 %j
  %1 = load i64, ptr %gep.j, align 8
  %cmp = icmp sgt i64 %1, -1
  %shift = lshr i64 %1, 63
  %j.next = add nsw i64 %j, %shift
  %inc = zext i1 %cmp to i64
  %i.next = add nsw i64 %i, %inc
  %cond = select i1 %cmp, i64 %j, i64 %i
  %gep.dst = getelementptr i64, ptr %dst, i64 %iv
  store i64 %cond, ptr %gep.dst, align 8
  %iv.next = add nsw i64 %iv, -1
  %ec = icmp eq i64 %iv.next, 0
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @test_add_ashr_add_regular_select(ptr %dst, ptr %src, i64 %i.start, i64 %j.start) {
; CHECK-LABEL: @test_add_ashr_add_regular_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 100000, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ [[I_START:%.*]], [[ENTRY]] ], [ [[I_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[J:%.*]] = phi i64 [ [[J_START:%.*]], [[ENTRY]] ], [ [[J_NEXT:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr inbounds ptr, ptr [[SRC:%.*]], i64 [[I]]
; CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[GEP_I]], align 8
; CHECK-NEXT:    [[GEP_J:%.*]] = getelementptr inbounds i64, ptr [[TMP0]], i64 [[J]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[GEP_J]], align 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP1]], -1
; CHECK-NEXT:    [[SHIFT:%.*]] = ashr i64 [[TMP1]], 63
; CHECK-NEXT:    [[CMP_FROZEN:%.*]] = freeze i1 [[CMP]]
; CHECK-NEXT:    br i1 [[CMP_FROZEN]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[TMP2:%.*]] = add nsw i64 [[I]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i64 [[J]], -1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[J_NEXT]] = phi i64 [ [[J]], [[SELECT_TRUE_SINK]] ], [ [[TMP3]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[I_NEXT]] = phi i64 [ [[TMP2]], [[SELECT_TRUE_SINK]] ], [ [[I]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[COND:%.*]] = phi i64 [ [[J]], [[SELECT_TRUE_SINK]] ], [ [[I]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    [[INC:%.*]] = zext i1 [[CMP]] to i64
; CHECK-NEXT:    [[GEP_DST:%.*]] = getelementptr i64, ptr [[DST:%.*]], i64 [[IV]]
; CHECK-NEXT:    store i64 [[COND]], ptr [[GEP_DST]], align 8
; CHECK-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], -1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV_NEXT]], 0
; CHECK-NEXT:    br i1 [[EC]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 100000, %entry ], [ %iv.next, %loop ]
  %i = phi i64 [ %i.start, %entry ], [ %i.next, %loop ]
  %j = phi i64 [ %j.start, %entry ], [ %j.next, %loop ]
  %gep.i = getelementptr inbounds ptr, ptr %src, i64 %i
  %0 = load ptr, ptr %gep.i, align 8
  %gep.j = getelementptr inbounds i64, ptr %0, i64 %j
  %1 = load i64, ptr %gep.j, align 8
  %cmp = icmp sgt i64 %1, -1
  %shift = ashr i64 %1, 63
  %j.next = add nsw i64 %j, %shift
  %inc = zext i1 %cmp to i64
  %i.next = add nsw i64 %i, %inc
  %cond = select i1 %cmp, i64 %j, i64 %i
  %gep.dst = getelementptr i64, ptr %dst, i64 %iv
  store i64 %cond, ptr %gep.dst, align 8
  %iv.next = add nsw i64 %iv, -1
  %ec = icmp eq i64 %iv.next, 0
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}
