; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2 --check-prefix=AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2 --check-prefix=AVX2-FAST
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX1OR2 --check-prefix=AVX2 --check-prefix=AVX2-FAST
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX512VL --check-prefix=AVX512VL-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX512VL --check-prefix=AVX512VL-FAST --check-prefix=AVX512VL-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefix=ALL --check-prefix=AVX512VL --check-prefix=AVX512VL-FAST --check-prefix=AVX512VL-FAST-PERLANE

define <4 x double> @shuffle_v4f64_0000(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0000:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0000:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0001(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0001:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0001:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0001:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 0, i32 1>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0020(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0020:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0020:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0020:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0300(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0300:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0300:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0300:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 3, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1000(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_1000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_1000:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_1000:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_2200(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_2200:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_2200:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2200:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 2, i32 2, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_2222(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_2222:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_2222:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2222:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_2222_bc(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4f64_2222_bc:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_2222_bc:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2222_bc:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX512VL-NEXT:    retq
  %tmp0 = bitcast <4 x i64> %a to <4 x double>
  %tmp1 = bitcast <4 x i64> %b to <4 x double>
  %shuffle = shufflevector <4 x double> %tmp0, <4 x double> %tmp1, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_2233(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_2233:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0,0,3,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_2233:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,3,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2233:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,3,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 2, i32 2, i32 3, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_3330(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_3330:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_3330:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_3330:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 3, i32 3, i32 3, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_3210(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_3210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_3210:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_3210:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0023(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0023:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0,0,2,3]
; ALL-NEXT:    retq

  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0022(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0022:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64mem_0022(ptr %ptr, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64mem_0022:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovddup {{.*#+}} ymm0 = mem[0,0,2,2]
; ALL-NEXT:    retq
  %a = load  <4 x double>,  ptr %ptr
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1032(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1032:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1133(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1133:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,3,3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 1, i32 3, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1023(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1023:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 2, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1022(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1022:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 2, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0213(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0213:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0213:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0213:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0423(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_0423:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_0423:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v4f64_0423:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,2,3]
; AVX512VL-FAST-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0462(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_0462:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1OR2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0462:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,6,2]
; AVX512VL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 6, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0426(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0426:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1537(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1537:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_4062(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_4062:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 4, i32 0, i32 6, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_5173(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_5173:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 5, i32 1, i32 7, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_5163(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_5163:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[2],ymm0[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 5, i32 1, i32 6, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0527(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0527:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_4163(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_4163:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0145(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0145:
; ALL:       # %bb.0:
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_4501(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_4501:
; ALL:       # %bb.0:
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0167(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0167:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1054(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_1054:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_1054:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4f64_1054:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,5,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4f64_1054:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 5, i32 4>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_3254(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_3254:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_3254:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4f64_3254:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [3,2,5,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4f64_3254:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX512VL-FAST-PERLANE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 3, i32 2, i32 5, i32 4>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_3276(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_3276:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_3276:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4f64_3276:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [3,2,7,6]
; AVX512VL-FAST-ALL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4f64_3276:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 3, i32 2, i32 7, i32 6>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1076(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_1076:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_1076:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v4f64_1076:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,7,6]
; AVX512VL-FAST-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 0, i32 7, i32 6>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0415(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0415:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm0[1],xmm1[1]
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0415:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_0415:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,1,5]
; AVX512VL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_2741(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_2741:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[0,1]
; AVX1OR2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2741:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [2,7,4,1]
; AVX512VL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 2, i32 7, i32 4, i32 1>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_u062(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_u062:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 poison, i32 0, i32 6, i32 2>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_15uu(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_15uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 5, i32 poison, i32 poison>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_11uu(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_11uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 1, i32 poison, i32 poison>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_22uu(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_22uu:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_22uu:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_22uu:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 2, i32 2, i32 poison, i32 poison>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_3333(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_3333:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,3,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_3333:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_3333:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0456(<4 x double> %a, <4 x double> %b) {
; AVX1OR2-LABEL: shuffle_v4f64_0456:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1OR2-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_0456:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4f64_0456:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [4,0,1,2]
; AVX512VL-FAST-ALL-NEXT:    vpermi2pd %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vmovapd %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4f64_0456:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 5, i32 6>
  ret <4 x double> %shuffle
}

; PR59860
define <4 x double> @shuffle_v4f64_0437(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0437:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 4, i32 3, i32 7>
  ret <4 x double> %shuffle
}

; PR91433
define <4 x double> @shuffle_v4f64_2303(<4 x double> %a) {
; AVX1-LABEL: shuffle_v4f64_2303:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,2,3]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_2303:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4f64_2303:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> poison, <4 x i32> <i32 2, i32 3, i32 0, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_0z3z(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0z3z:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[3],ymm1[3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x double> %a, <4 x double> <double 0.000000e+00, double poison, double poison, double poison>, <4 x i32> <i32 0, i32 4, i32 3, i32 4>
  ret <4 x double> %shuffle
}

define <4 x double> @shuffle_v4f64_1z2z(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1z2z:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[2],ymm1[3]
; ALL-NEXT:    retq
  %1 = shufflevector <4 x double> %a, <4 x double> <double 0.000000e+00, double poison, double poison, double poison>, <4 x i32> <i32 1, i32 4, i32 2, i32 4>
  ret <4 x double> %1
}

define <4 x double> @shuffle_v4f64_0044(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: shuffle_v4f64_0044:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4f64_0044:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4f64_0044:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4f64_0044:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,0,4,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2pd %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4f64_0044:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %1 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 0, i32 4, i32 4>
  ret <4 x double> %1
}

define <4 x double> @shuffle_v4f64_0044_v2f64(<2 x double> %a, <2 x double> %b) {
; ALL-LABEL: shuffle_v4f64_0044_v2f64:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; ALL-NEXT:    retq
  %1 = shufflevector <2 x double> %a, <2 x double> poison, <2 x i32> <i32 0, i32 0>
  %2 = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> <i32 0, i32 0>
  %3 = shufflevector <2 x double> %1, <2 x double> %2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %3
}

define <4 x double> @shuffle_v4f64_1032_v2f64(<2 x double> %a, <2 x double> %b) {
; ALL-LABEL: shuffle_v4f64_1032_v2f64:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; ALL-NEXT:    retq
  %1 = shufflevector <2 x double> %a, <2 x double> poison, <2 x i32> <i32 1, i32 0>
  %2 = shufflevector <2 x double> %b, <2 x double> poison, <2 x i32> <i32 1, i32 0>
  %3 = shufflevector <2 x double> %1, <2 x double> %2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %3
}

;PR34359
define <4 x double> @shuffle_v4f64_2345_0567_select(<4 x double> %vec1, <4 x double> %vec2, <4 x double> %vec3) {
; ALL-LABEL: shuffle_v4f64_2345_0567_select:
; ALL:       # %bb.0:
; ALL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3,4,5,6,7]
; ALL-NEXT:    retq
  %shuf = shufflevector <4 x double> %vec1, <4 x double> %vec2, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %res = select <4 x i1> <i1 0, i1 1, i1 1, i1 1>, <4 x double> %shuf, <4 x double> %vec3
  ret <4 x double> %res
}

define <4 x i64> @shuffle_v4i64_0000(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0000:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0000:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0001(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0001:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0001:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0001:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,0,1]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 0, i32 0, i32 1>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0020(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0020:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0020:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0020:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 0, i32 2, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0112(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0112:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[3],ymm0[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0112:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0112:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,2]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 1, i32 1, i32 2>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0300(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0300:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0300:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0300:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,3,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 3, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1000(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1000:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1000:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_1000:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_2200(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_2200:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_2200:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,0,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_2200:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,0,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 2, i32 2, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_3330(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_3330:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_3330:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_3330:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 3, i32 3, i32 3, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_3210(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_3210:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_3210:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_3210:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0213(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0213:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0213:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0213:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0124(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0124:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0124:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_0124:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_0124:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,1,2,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_0124:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vbroadcastsd %xmm1, %ymm1
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 4>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0142(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0142:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0142:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,2,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0142:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,1,4,2]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 2>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0412(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0412:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm0[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0412:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm1[0,0]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0412:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,1,2]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 4, i32 1, i32 2>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_4012(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_4012:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_4012:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,2]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_4012:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,2]
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_4012:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [4,0,1,2]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_4012:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,2]
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 4, i32 0, i32 1, i32 2>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0145(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_0145:
; ALL:       # %bb.0:
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0451(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0451:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0451:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,1,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0451:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,5,1]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 4, i32 5, i32 1>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_4501(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_4501:
; ALL:       # %bb.0:
; ALL-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 4, i32 5, i32 0, i32 1>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_4015(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_4015:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm0[1],xmm1[1]
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_4015:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,1,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_4015:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [4,0,1,5]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 4, i32 0, i32 1, i32 5>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_2u35(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_2u35:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_2u35:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,1]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_2u35:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_2u35:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [2,5,3,5]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_2u35:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,1,3,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 2, i32 poison, i32 3, i32 5>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1251(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1251:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm2[0],ymm0[3],ymm2[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1251:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,1,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,2,2,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5],ymm0[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_1251:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,2,5,1]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 2, i32 5, i32 1>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1054(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1054:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1054:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_1054:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_1054:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,5,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_1054:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 0, i32 5, i32 4>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_3254(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_3254:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_3254:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_3254:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_3254:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [3,2,5,4]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_3254:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,2,1,0]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 3, i32 2, i32 5, i32 4>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_3276(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_3276:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_3276:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_3276:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-SLOW-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_3276:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [3,2,7,6]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_3276:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vperm2i128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 3, i32 2, i32 7, i32 6>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1076(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1076:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,3,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1076:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_1076:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v4i64_1076:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [1,0,7,6]
; AVX512VL-FAST-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 0, i32 7, i32 6>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0415(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0415:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm0[1],xmm1[1]
; AVX1-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0415:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0415:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,1,5]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_2741(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_2741:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[0,1]
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[0,1]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5],ymm2[6,7]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_2741:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_2741:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: shuffle_v4i64_2741:
; AVX512VL-FAST-ALL:       # %bb.0:
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [2,7,4,1]
; AVX512VL-FAST-ALL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: shuffle_v4i64_2741:
; AVX512VL-FAST-PERLANE:       # %bb.0:
; AVX512VL-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5],ymm1[6,7]
; AVX512VL-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,3,0,1]
; AVX512VL-FAST-PERLANE-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 2, i32 7, i32 4, i32 1>
  ret <4 x i64> %shuffle
}

; PR59860
define <4 x i64> @shuffle_v4i64_0437(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0437:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0437:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,3,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5],ymm1[6,7]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0437:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,4,3,7]
; AVX512VL-NEXT:    vpermt2q %ymm1, %ymm2, %ymm0
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 4, i32 3, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_z4z6(<4 x i64> %a) {
; AVX1-LABEL: shuffle_v4i64_z4z6:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_z4z6:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslldq {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,17,18,19,20,21,22,23]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_z4z6:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslldq {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,17,18,19,20,21,22,23]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> zeroinitializer, <4 x i64> %a, <4 x i32> <i32 0, i32 4, i32 0, i32 6>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_5zuz(<4 x i64> %a) {
; AVX1-LABEL: shuffle_v4i64_5zuz:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_5zuz:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrldq {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_5zuz:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrldq {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> zeroinitializer, <4 x i64> %a, <4 x i32> <i32 5, i32 0, i32 poison, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_40u2(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_40u2:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 4, i32 0, i32 poison, i32 2>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_15uu(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_15uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 5, i32 poison, i32 poison>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_11uu(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_11uu:
; ALL:       # %bb.0:
; ALL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; ALL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 1, i32 poison, i32 poison>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_22uu(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_22uu:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_22uu:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_22uu:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 2, i32 2, i32 poison, i32 poison>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_3333(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_3333:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3,2,3]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,1,3,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_3333:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_3333:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[3,3,3,3]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1z3z(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1z3z:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1z3z:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrldq {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_1z3z:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrldq {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> <i64 0, i64 poison, i64 poison, i64 poison>, <4 x i32> <i32 1, i32 4, i32 3, i32 4>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_0044_v2i64(<2 x i64> %a, <2 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_0044_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovddup {{.*#+}} ymm0 = ymm0[0,0,2,2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_0044_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,0,1,4,5,4,5]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_0044_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; AVX512VL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,1,0,1,4,5,4,5]
; AVX512VL-NEXT:    retq
  %1 = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 0, i32 0>
  %2 = shufflevector <2 x i64> %b, <2 x i64> poison, <2 x i32> <i32 0, i32 0>
  %3 = shufflevector <2 x i64> %1, <2 x i64> %2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %3
}

define <4 x i64> @shuffle_v4i64_1032_v2i64(<2 x i64> %a, <2 x i64> %b) {
; ALL-LABEL: shuffle_v4i64_1032_v2i64:
; ALL:       # %bb.0:
; ALL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,3,0,1,6,7,4,5]
; ALL-NEXT:    retq
  %1 = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 0>
  %2 = shufflevector <2 x i64> %b, <2 x i64> poison, <2 x i32> <i32 1, i32 0>
  %3 = shufflevector <2 x i64> %1, <2 x i64> %2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %3
}

define <4 x i64> @stress_test1(<4 x i64> %a, <4 x i64> %b) {
; ALL-LABEL: stress_test1:
; ALL:         retq
  %c = shufflevector <4 x i64> %b, <4 x i64> poison, <4 x i32> <i32 3, i32 1, i32 1, i32 0>
  %d = shufflevector <4 x i64> %c, <4 x i64> poison, <4 x i32> <i32 3, i32 poison, i32 2, i32 poison>
  %e = shufflevector <4 x i64> %b, <4 x i64> poison, <4 x i32> <i32 3, i32 3, i32 1, i32 poison>
  %f = shufflevector <4 x i64> %d, <4 x i64> %e, <4 x i32> <i32 5, i32 1, i32 1, i32 0>

  ret <4 x i64> %f
}

define <4 x i64> @insert_reg_and_zero_v4i64(i64 %a) {
; ALL-LABEL: insert_reg_and_zero_v4i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq %rdi, %xmm0
; ALL-NEXT:    retq
  %v = insertelement <4 x i64> poison, i64 %a, i64 0
  %shuffle = shufflevector <4 x i64> %v, <4 x i64> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x i64> @insert_mem_and_zero_v4i64(ptr %ptr) {
; ALL-LABEL: insert_mem_and_zero_v4i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    retq
  %a = load i64, ptr %ptr
  %v = insertelement <4 x i64> poison, i64 %a, i64 0
  %shuffle = shufflevector <4 x i64> %v, <4 x i64> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i64> %shuffle
}

define <4 x double> @insert_reg_and_zero_v4f64(double %a) {
; ALL-LABEL: insert_reg_and_zero_v4f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; ALL-NEXT:    retq
  %v = insertelement <4 x double> poison, double %a, i32 0
  %shuffle = shufflevector <4 x double> %v, <4 x double> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @insert_mem_and_zero_v4f64(ptr %ptr) {
; ALL-LABEL: insert_mem_and_zero_v4f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    retq
  %a = load double, ptr %ptr
  %v = insertelement <4 x double> poison, double %a, i32 0
  %shuffle = shufflevector <4 x double> %v, <4 x double> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x double> %shuffle
}

define <4 x double> @splat_mem_v4f64(ptr %ptr) {
; ALL-LABEL: splat_mem_v4f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %a = load double, ptr %ptr
  %v = insertelement <4 x double> poison, double %a, i32 0
  %shuffle = shufflevector <4 x double> %v, <4 x double> poison, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x i64> @splat_mem_v4i64(ptr %ptr) {
; ALL-LABEL: splat_mem_v4i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %a = load i64, ptr %ptr
  %v = insertelement <4 x i64> poison, i64 %a, i64 0
  %shuffle = shufflevector <4 x i64> %v, <4 x i64> poison, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x double> @splat_mem_v4f64_2(ptr %p) {
; ALL-LABEL: splat_mem_v4f64_2:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %1 = load double, ptr %p
  %2 = insertelement <2 x double> poison, double %1, i32 0
  %3 = shufflevector <2 x double> %2, <2 x double> poison, <4 x i32> zeroinitializer
  ret <4 x double> %3
}

define <4 x double> @splat_v4f64(<2 x double> %r) {
; AVX1-LABEL: splat_v4f64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovddup {{.*#+}} xmm0 = xmm0[0,0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splat_v4f64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: splat_v4f64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = shufflevector <2 x double> %r, <2 x double> poison, <4 x i32> zeroinitializer
  ret <4 x double> %1
}

define <4 x i64> @splat_mem_v4i64_from_v2i64(ptr %ptr) {
; ALL-LABEL: splat_mem_v4i64_from_v2i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %v = load <2 x i64>, ptr %ptr
  %shuffle = shufflevector <2 x i64> %v, <2 x i64> poison, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x double> @splat_mem_v4f64_from_v2f64(ptr %ptr) {
; ALL-LABEL: splat_mem_v4f64_from_v2f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %v = load <2 x double>, ptr %ptr
  %shuffle = shufflevector <2 x double> %v, <2 x double> poison, <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x double> %shuffle
}

define <4 x i64> @splat128_mem_v4i64_from_v2i64(ptr %ptr) {
; AVX1OR2-LABEL: splat128_mem_v4i64_from_v2i64:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: splat128_mem_v4i64_from_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX512VL-NEXT:    retq
  %v = load <2 x i64>, ptr %ptr
  %shuffle = shufflevector <2 x i64> %v, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  ret <4 x i64> %shuffle
}

define <4 x double> @splat128_mem_v4f64_from_v2f64(ptr %ptr) {
; ALL-LABEL: splat128_mem_v4f64_from_v2f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; ALL-NEXT:    retq
  %v = load <2 x double>, ptr %ptr
  %shuffle = shufflevector <2 x double> %v, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  ret <4 x double> %shuffle
}

define <4 x double> @broadcast_v4f64_0000_from_v2i64(<2 x i64> %a0) {
; AVX1-LABEL: broadcast_v4f64_0000_from_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,1,0,1]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: broadcast_v4f64_0000_from_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: broadcast_v4f64_0000_from_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vbroadcastsd %xmm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = shufflevector <2 x i64> %a0, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast <4 x i64> %1 to <4 x double>
  %3 = shufflevector <4 x double> %2, <4 x double> poison, <4 x i32> zeroinitializer
  ret <4 x double> %3
}

; PR114959
define <4 x double> @concat_v4f64_0213_broadcasts(ptr %src) {
; ALL-LABEL: concat_v4f64_0213_broadcasts:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; ALL-NEXT:    vbroadcastf128 {{.*#+}} ymm1 = mem[0,1,0,1]
; ALL-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[3],ymm0[3]
; ALL-NEXT:    retq
  %src.hi = getelementptr inbounds i8, ptr %src, i64 32
  %lo = load <2 x double>, ptr %src, align 1
  %hi = load <2 x double>, ptr %src.hi, align 1
  %shuffle = shufflevector <2 x double> %lo, <2 x double> %hi, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %shuffle
}

define <4 x double> @bitcast_v4f64_0426(<4 x double> %a, <4 x double> %b) {
; ALL-LABEL: bitcast_v4f64_0426:
; ALL:       # %bb.0:
; ALL-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; ALL-NEXT:    retq
  %shuffle64 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 4, i32 0, i32 6, i32 2>
  %bitcast32 = bitcast <4 x double> %shuffle64 to <8 x float>
  %shuffle32 = shufflevector <8 x float> %bitcast32, <8 x float> poison, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  %bitcast16 = bitcast <8 x float> %shuffle32 to <16 x i16>
  %shuffle16 = shufflevector <16 x i16> %bitcast16, <16 x i16> poison, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5, i32 10, i32 11, i32 8, i32 9, i32 14, i32 15, i32 12, i32 13>
  %bitcast64 = bitcast <16 x i16> %shuffle16 to <4 x double>
  ret <4 x double> %bitcast64
}

define <4 x i64> @concat_v4i64_0167(<4 x i64> %a0, <4 x i64> %a1) {
; ALL-LABEL: concat_v4i64_0167:
; ALL:       # %bb.0:
; ALL-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; ALL-NEXT:    retq
  %a0lo = shufflevector <4 x i64> %a0, <4 x i64> %a1, <2 x i32> <i32 0, i32 1>
  %a1hi = shufflevector <4 x i64> %a0, <4 x i64> %a1, <2 x i32> <i32 6, i32 7>
  %shuffle64 = shufflevector <2 x i64> %a0lo, <2 x i64> %a1hi, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %shuffle64
}

define <4 x i64> @concat_v4i64_0145_bc(<4 x i64> %a0, <4 x i64> %a1) {
; ALL-LABEL: concat_v4i64_0145_bc:
; ALL:       # %bb.0:
; ALL-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; ALL-NEXT:    retq
  %a0lo = shufflevector <4 x i64> %a0, <4 x i64> %a1, <2 x i32> <i32 0, i32 1>
  %a1lo = shufflevector <4 x i64> %a0, <4 x i64> %a1, <2 x i32> <i32 4, i32 5>
  %bc0lo = bitcast <2 x i64> %a0lo to <4 x i32>
  %bc1lo = bitcast <2 x i64> %a1lo to <4 x i32>
  %shuffle32 = shufflevector <4 x i32> %bc0lo, <4 x i32> %bc1lo, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %shuffle64 = bitcast <8 x i32> %shuffle32 to <4 x i64>
  ret <4 x i64> %shuffle64
}

define <4 x i64> @insert_dup_mem_v4i64(ptr %ptr) {
; ALL-LABEL: insert_dup_mem_v4i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vbroadcastsd (%rdi), %ymm0
; ALL-NEXT:    retq
  %tmp = load i64, ptr %ptr, align 1
  %tmp1 = insertelement <2 x i64> poison, i64 %tmp, i32 0
  %tmp2 = shufflevector <2 x i64> %tmp1, <2 x i64> poison, <4 x i32> zeroinitializer
  ret <4 x i64> %tmp2
}

define <4 x i64> @shuffle_v4i64_1234(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1234:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[0,1]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1234:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,2,3,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_1234:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    valignq {{.*#+}} ymm0 = ymm0[1,2,3],ymm1[0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_1230(<4 x i64> %a) {
; AVX1-LABEL: shuffle_v4i64_1230:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3,0,1]
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[0],ymm0[3],ymm1[2]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: shuffle_v4i64_1230:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,2,3,0]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v4i64_1230:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,2,3,0]
; AVX512VL-NEXT:    retq
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> poison, <4 x i32> <i32 1, i32 2, i32 3, i32 0>
  ret <4 x i64> %shuffle
}

define <4 x i64> @shuffle_v4i64_z0z3(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_z0z3:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[3]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v4i64_z0z3:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,3]
; AVX2-SLOW-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: shuffle_v4i64_z0z3:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31]
; AVX2-FAST-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_z0z3:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,2,3]
; AVX512VL-SLOW-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3],ymm1[4,5],ymm0[6,7]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v4i64_z0z3:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = zero,zero,zero,zero,zero,zero,zero,zero,ymm0[0,1,2,3,4,5,6,7],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[24,25,26,27,28,29,30,31]
; AVX512VL-FAST-NEXT:    retq
  %1 = shufflevector <4 x i64> %a, <4 x i64> <i64 0, i64 poison, i64 poison, i64 poison>, <4 x i32> <i32 4, i32 0, i32 4, i32 3>
  ret <4 x i64> %1
}

define <4 x i64> @shuffle_v4i64_1z2z(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: shuffle_v4i64_1z2z:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[2],ymm1[3]
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: shuffle_v4i64_1z2z:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,2,0]
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: shuffle_v4i64_1z2z:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,17,18,19,20,21,22,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-FAST-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: shuffle_v4i64_1z2z:
; AVX512VL-SLOW:       # %bb.0:
; AVX512VL-SLOW-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512VL-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,3,4,5,6,7]
; AVX512VL-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,0,2,0]
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-LABEL: shuffle_v4i64_1z2z:
; AVX512VL-FAST:       # %bb.0:
; AVX512VL-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[8,9,10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,ymm0[16,17,18,19,20,21,22,23],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512VL-FAST-NEXT:    retq
  %1 = shufflevector <4 x i64> %a, <4 x i64> <i64 0, i64 poison, i64 poison, i64 poison>, <4 x i32> <i32 1, i32 4, i32 2, i32 4>
  ret <4 x i64> %1
}

define <4 x double> @add_v4f64_0246_1357(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: add_v4f64_0246_1357:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vhaddpd %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: add_v4f64_0246_1357:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: add_v4f64_0246_1357:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %shuffle1 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %add = fadd <4 x double> %shuffle, %shuffle1
  ret <4 x double> %add
}

define <4 x double> @add_v4f64_4602_5713(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: add_v4f64_4602_5713:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vhaddpd %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: add_v4f64_4602_5713:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: add_v4f64_4602_5713:
; AVX512VL:       # %bb.0: # %entry
; AVX512VL-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,3,0,2]
; AVX512VL-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 4, i32 6, i32 0, i32 2>
  %shuffle1 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 5, i32 7, i32 1, i32 3>
  %add = fadd <4 x double> %shuffle, %shuffle1
  ret <4 x double> %add
}

define <4 x double> @add_v4f64_024u_135u_reverse(<4 x double> %a, <4 x double> %b) {
; AVX1-LABEL: add_v4f64_024u_135u_reverse:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm1
; AVX1-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: add_v4f64_024u_135u_reverse:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vhaddpd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,3,1]
; AVX2-NEXT:    retq
;
; AVX512VL-LABEL: add_v4f64_024u_135u_reverse:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vhaddpd %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,0,3,1]
; AVX512VL-NEXT:    retq
  %shuffle0 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 poison>
  %shuffle1 = shufflevector <4 x double> %a, <4 x double> %b, <4 x i32> <i32 1, i32 3, i32 5, i32 poison>
  %add = fadd <4 x double> %shuffle0, %shuffle1
  %shuffle = shufflevector <4 x double> %add, <4 x double> poison, <4 x i32> <i32 poison, i32 2, i32 1, i32 0>
  ret <4 x double> %shuffle
}

define <4 x i64> @add_v4i64_0246_1357(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: add_v4i64_0246_1357:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: add_v4i64_0246_1357:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: add_v4i64_0246_1357:
; AVX512VL-SLOW:       # %bb.0: # %entry
; AVX512VL-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VL-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX512VL-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512VL-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-SLOW-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: add_v4i64_0246_1357:
; AVX512VL-FAST-ALL:       # %bb.0: # %entry
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,2,4,6]
; AVX512VL-FAST-ALL-NEXT:    vpermi2q %ymm1, %ymm0, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,3,5,7]
; AVX512VL-FAST-ALL-NEXT:    vpermi2q %ymm1, %ymm0, %ymm3
; AVX512VL-FAST-ALL-NEXT:    vpaddq %ymm3, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: add_v4i64_0246_1357:
; AVX512VL-FAST-PERLANE:       # %bb.0: # %entry
; AVX512VL-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX512VL-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX512VL-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %shuffle1 = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %add = add <4 x i64> %shuffle, %shuffle1
  ret <4 x i64> %add
}

define <4 x i64> @add_v4i64_4602_5713(<4 x i64> %a, <4 x i64> %b) {
; AVX1-LABEL: add_v4i64_4602_5713:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[2,3],ymm0[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: add_v4i64_4602_5713:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512VL-SLOW-LABEL: add_v4i64_4602_5713:
; AVX512VL-SLOW:       # %bb.0: # %entry
; AVX512VL-SLOW-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512VL-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX512VL-SLOW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512VL-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-SLOW-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-SLOW-NEXT:    retq
;
; AVX512VL-FAST-ALL-LABEL: add_v4i64_4602_5713:
; AVX512VL-FAST-ALL:       # %bb.0: # %entry
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm2 = [0,2,4,6]
; AVX512VL-FAST-ALL-NEXT:    vpermi2q %ymm0, %ymm1, %ymm2
; AVX512VL-FAST-ALL-NEXT:    vpmovsxbq {{.*#+}} ymm3 = [1,3,5,7]
; AVX512VL-FAST-ALL-NEXT:    vpermi2q %ymm0, %ymm1, %ymm3
; AVX512VL-FAST-ALL-NEXT:    vpaddq %ymm3, %ymm2, %ymm0
; AVX512VL-FAST-ALL-NEXT:    retq
;
; AVX512VL-FAST-PERLANE-LABEL: add_v4i64_4602_5713:
; AVX512VL-FAST-PERLANE:       # %bb.0: # %entry
; AVX512VL-FAST-PERLANE-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX512VL-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX512VL-FAST-PERLANE-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX512VL-FAST-PERLANE-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-FAST-PERLANE-NEXT:    retq
entry:
  %shuffle = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 4, i32 6, i32 0, i32 2>
  %shuffle1 = shufflevector <4 x i64> %a, <4 x i64> %b, <4 x i32> <i32 5, i32 7, i32 1, i32 3>
  %add = add <4 x i64> %shuffle, %shuffle1
  ret <4 x i64> %add
}

define <4 x double> @shuffle_v4f64_0zzz_optsize(<4 x double> %a) optsize {
; ALL-LABEL: shuffle_v4f64_0zzz_optsize:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; ALL-NEXT:    retq
  %b = shufflevector <4 x double> %a, <4 x double> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x double> %b
}

define <4 x i64> @shuffle_v4i64_0zzz_optsize(<4 x i64> %a) optsize {
; ALL-LABEL: shuffle_v4i64_0zzz_optsize:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; ALL-NEXT:    retq
  %b = shufflevector <4 x i64> %a, <4 x i64> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i64> %b
}

define <8 x float> @shuffle_v8f32_0zzzzzzz_optsize(<8 x float> %a) optsize {
; ALL-LABEL: shuffle_v8f32_0zzzzzzz_optsize:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; ALL-NEXT:    retq
  %b = shufflevector <8 x float> %a, <8 x float> zeroinitializer, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x float> %b
}

define <8 x i32> @shuffle_v8i32_0zzzzzzz_optsize(<8 x i32> %a) optsize {
; ALL-LABEL: shuffle_v8i32_0zzzzzzz_optsize:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; ALL-NEXT:    retq
  %b = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i32> %b
}

define <4 x double> @shuffle_v4f64_0zzz_pgso(<4 x double> %a) !prof !14 {
; ALL-LABEL: shuffle_v4f64_0zzz_pgso:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; ALL-NEXT:    retq
  %b = shufflevector <4 x double> %a, <4 x double> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x double> %b
}

define <4 x i64> @shuffle_v4i64_0zzz_pgso(<4 x i64> %a) !prof !14 {
; ALL-LABEL: shuffle_v4i64_0zzz_pgso:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq {{.*#+}} xmm0 = xmm0[0],zero
; ALL-NEXT:    retq
  %b = shufflevector <4 x i64> %a, <4 x i64> zeroinitializer, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x i64> %b
}

define <8 x float> @shuffle_v8f32_0zzzzzzz_pgso(<8 x float> %a) !prof !14 {
; AVX1OR2-LABEL: shuffle_v8f32_0zzzzzzz_pgso:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8f32_0zzzzzzz_pgso:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX512VL-NEXT:    retq
  %b = shufflevector <8 x float> %a, <8 x float> zeroinitializer, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x float> %b
}

define <8 x i32> @shuffle_v8i32_0zzzzzzz_pgso(<8 x i32> %a) !prof !14 {
; AVX1OR2-LABEL: shuffle_v8i32_0zzzzzzz_pgso:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX1OR2-NEXT:    retq
;
; AVX512VL-LABEL: shuffle_v8i32_0zzzzzzz_pgso:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovss {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX512VL-NEXT:    retq
  %b = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 0, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i32> %b
}

define <4 x i64> @unpckh_v4i64(<4 x i64> %x, <4 x i64> %y) {
; ALL-LABEL: unpckh_v4i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; ALL-NEXT:    retq
  %unpckh = shufflevector <4 x i64> %x, <4 x i64> %y, <4 x i32> <i32 1, i32 7, i32 poison, i32 poison>
  ret <4 x i64> %unpckh
}

define <4 x double> @unpckh_v4f64(<4 x double> %x, <4 x double> %y) {
; ALL-LABEL: unpckh_v4f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vextractf128 $1, %ymm1, %xmm1
; ALL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; ALL-NEXT:    retq
  %unpckh = shufflevector <4 x double> %x, <4 x double> %y, <4 x i32> <i32 1, i32 7, i32 poison, i32 poison>
  ret <4 x double> %unpckh
}

!llvm.module.flags = !{!0}
!0 = !{i32 1, !"ProfileSummary", !1}
!1 = !{!2, !3, !4, !5, !6, !7, !8, !9}
!2 = !{!"ProfileFormat", !"InstrProf"}
!3 = !{!"TotalCount", i64 10000}
!4 = !{!"MaxCount", i64 10}
!5 = !{!"MaxInternalCount", i64 1}
!6 = !{!"MaxFunctionCount", i64 1000}
!7 = !{!"NumCounts", i64 3}
!8 = !{!"NumFunctions", i64 3}
!9 = !{!"DetailedSummary", !10}
!10 = !{!11, !12, !13}
!11 = !{i32 10000, i64 100, i32 1}
!12 = !{i32 999000, i64 100, i32 1}
!13 = !{i32 999999, i64 1, i32 2}
!14 = !{!"function_entry_count", i64 0}
