; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O2 -mtriple=x86_64-linux-android \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=ANDROID
; RUN: llc < %s -O2 -mtriple=x86_64-linux-gnu \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=GNU
; RUN: llc < %s -O2 -mtriple=i686-linux-gnu -mattr=+sse2 \
; RUN:     -enable-legalize-types-checking \
; RUN:     | FileCheck %s --check-prefix=X86

; Check all soft floating point library function calls.

define fp128 @add(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __addtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %add = call fp128 @llvm.experimental.constrained.fadd.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %add
}

define fp128 @sub(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __subtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %sub = call fp128 @llvm.experimental.constrained.fsub.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sub
}

define fp128 @mul(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __multf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %mul = call fp128 @llvm.experimental.constrained.fmul.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %mul
}

define fp128 @div(fp128 %x, fp128 %y) nounwind strictfp {
; CHECK-LABEL: div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __divtf3
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %div = call fp128 @llvm.experimental.constrained.fdiv.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %div
}

define fp128 @fma(fp128 %x, fp128 %y, fp128 %z) nounwind strictfp {
; ANDROID-LABEL: fma:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmal@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: fma:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmaf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: fma:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmal
; X86-NEXT:    addl $60, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %fma = call fp128 @llvm.experimental.constrained.fma.f128(fp128 %x, fp128 %y,  fp128 %z, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %fma
}

define fp128 @frem(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: frem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: frem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: frem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmodl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %div = call fp128 @llvm.experimental.constrained.frem.f128(fp128 %x, fp128 %y,  metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %div
}

define fp128 @ceil(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: ceil:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq ceill@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: ceil:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq ceilf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: ceil:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll ceill
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %ceil = call fp128 @llvm.experimental.constrained.ceil.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %ceil
}

define fp128 @acos(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: acos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq acosl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: acos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq acosf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: acos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll acosl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %acos = call fp128 @llvm.experimental.constrained.acos.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %acos
}

define fp128 @cos(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: cos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq cosl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq cosf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: cos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll cosl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %cos = call fp128 @llvm.experimental.constrained.cos.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %cos
}

define fp128 @cosh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: cosh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq coshl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cosh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq coshf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: cosh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll coshl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %cosh = call fp128 @llvm.experimental.constrained.cosh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %cosh
}

define fp128 @exp(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: exp:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq expl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: exp:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq expf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: exp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll expl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %exp = call fp128 @llvm.experimental.constrained.exp.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %exp
}

define fp128 @exp2(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: exp2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq exp2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: exp2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq exp2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: exp2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll exp2l
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %exp2 = call fp128 @llvm.experimental.constrained.exp2.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %exp2
}

define fp128 @floor(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: floor:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq floorl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: floor:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq floorf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: floor:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll floorl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %floor = call fp128 @llvm.experimental.constrained.floor.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %floor
}

define fp128 @log(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq logl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq logf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll logl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %log = call fp128 @llvm.experimental.constrained.log.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log
}

define fp128 @log10(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log10:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq log10l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log10:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq log10f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log10:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll log10l
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %log10 = call fp128 @llvm.experimental.constrained.log10.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log10
}

define fp128 @log2(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: log2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq log2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: log2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq log2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: log2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll log2l
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %log2 = call fp128 @llvm.experimental.constrained.log2.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %log2
}

define fp128 @maxnum(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: maxnum:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmaxl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: maxnum:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmaxf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: maxnum:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fmaxl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %maxnum = call fp128 @llvm.experimental.constrained.maxnum.f128(fp128 %x, fp128 %y, metadata !"fpexcept.strict") #0
  ret fp128 %maxnum
}

define fp128 @minnum(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: minnum:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fminl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: minnum:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fminf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: minnum:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll fminl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %minnum = call fp128 @llvm.experimental.constrained.minnum.f128(fp128 %x, fp128 %y, metadata !"fpexcept.strict") #0
  ret fp128 %minnum
}

define fp128 @nearbyint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: nearbyint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq nearbyintl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: nearbyint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq nearbyintf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: nearbyint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll nearbyintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %nearbyint = call fp128 @llvm.experimental.constrained.nearbyint.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %nearbyint
}

define fp128 @pow(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: pow:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq powl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: pow:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq powf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: pow:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll powl
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %pow = call fp128 @llvm.experimental.constrained.pow.f128(fp128 %x, fp128 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %pow
}

define fp128 @powi(fp128 %x, i32 %y) nounwind strictfp {
; CHECK-LABEL: powi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __powitf2@PLT
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: powi:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __powitf2@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: powi:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __powitf2@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: powi:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll __powitf2
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %powi = call fp128 @llvm.experimental.constrained.powi.f128(fp128 %x, i32 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %powi
}

define fp128 @rint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: rint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq rintl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: rint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq rintf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: rint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll rintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %rint = call fp128 @llvm.experimental.constrained.rint.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %rint
}

define fp128 @round(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: round:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: round:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: round:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll roundl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %round = call fp128 @llvm.experimental.constrained.round.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %round
}

define fp128 @roundeven(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: roundeven:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundevenl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: roundeven:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundevenf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: roundeven:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll roundevenl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %roundeven = call fp128 @llvm.experimental.constrained.roundeven.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %roundeven
}

define fp128 @asin(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: asin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq asinl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: asin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq asinf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: asin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll asinl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %asin = call fp128 @llvm.experimental.constrained.asin.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %asin
}

define fp128 @sin(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll sinl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %sin = call fp128 @llvm.experimental.constrained.sin.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sin
}

define fp128 @sinh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sinh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinhl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sinh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinhf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sinh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll sinhl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %sinh = call fp128 @llvm.experimental.constrained.sinh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sinh
}

define fp128 @sqrt(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: sqrt:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sqrtl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: sqrt:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sqrtf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: sqrt:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll sqrtl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %sqrt = call fp128 @llvm.experimental.constrained.sqrt.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %sqrt
}

define fp128 @atan(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: atan:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq atanl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: atan:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq atanf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: atan:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll atanl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %atan = call fp128 @llvm.experimental.constrained.atan.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %atan
}

define fp128 @atan2(fp128 %x, fp128 %y) nounwind strictfp {
; ANDROID-LABEL: atan2:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq atan2l@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: atan2:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq atan2f128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: atan2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll atan2l
; X86-NEXT:    addl $44, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %atan2 = call fp128 @llvm.experimental.constrained.atan2.f128(fp128 %x, fp128 %y, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %atan2
}

define fp128 @tan(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: tan:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq tanl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: tan:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq tanf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: tan:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll tanl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %tan = call fp128 @llvm.experimental.constrained.tan.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %tan
}

define fp128 @tanh(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: tanh:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq tanhl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: tanh:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq tanhf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: tanh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll tanhl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %tanh = call fp128 @llvm.experimental.constrained.tanh.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret fp128 %tanh
}

define fp128 @trunc(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: trunc:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq truncl@PLT
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: trunc:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq truncf128@PLT
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: trunc:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $24, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %eax
; X86-NEXT:    calll truncl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    movaps (%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $24, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl $4
entry:
  %trunc = call fp128 @llvm.experimental.constrained.trunc.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret fp128 %trunc
}

define i32 @lrint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: lrint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq lrintl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: lrint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq lrintf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: lrint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll lrintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %rint = call i32 @llvm.experimental.constrained.lrint.i32.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret i32 %rint
}

define i64 @llrint(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: llrint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq llrintl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: llrint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq llrintf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: llrint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll llrintl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %rint = call i64 @llvm.experimental.constrained.llrint.i64.f128(fp128 %x, metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret i64 %rint
}

define i32 @lround(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: lround:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq lroundl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: lround:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq lroundf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: lround:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll lroundl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %round = call i32 @llvm.experimental.constrained.lround.i32.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret i32 %round
}

define i64 @llround(fp128 %x) nounwind strictfp {
; ANDROID-LABEL: llround:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq llroundl@PLT
; ANDROID-NEXT:    popq %rcx
; ANDROID-NEXT:    retq
;
; GNU-LABEL: llround:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq llroundf128@PLT
; GNU-NEXT:    popq %rcx
; GNU-NEXT:    retq
;
; X86-LABEL: llround:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll llroundl
; X86-NEXT:    addl $28, %esp
; X86-NEXT:    retl
entry:
  %round = call i64 @llvm.experimental.constrained.llround.i64.f128(fp128 %x, metadata !"fpexcept.strict") #0
  ret i64 %round
}

define i64 @cmp(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    cmovneq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    cmovneq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $8, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    cmovneq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $8, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    retq
;
; X86-LABEL: cmp:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmps(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    cmovneq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $8, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmps:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    cmovneq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $8, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmps:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    cmovneq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $8, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    retq
;
; X86-LABEL: cmps:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmps.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmp_ueq_q(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp_ueq_q:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    sete %bpl
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    callq __unordtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    orb %bpl, %al
; CHECK-NEXT:    cmoveq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp_ueq_q:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %rbp
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    subq $32, %rsp
; ANDROID-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ANDROID-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    sete %bpl
; ANDROID-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; ANDROID-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ANDROID-NEXT:    callq __unordtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    setne %al
; ANDROID-NEXT:    orb %bpl, %al
; ANDROID-NEXT:    cmoveq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $32, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    popq %rbp
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp_ueq_q:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %rbp
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    subq $32, %rsp
; GNU-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; GNU-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    sete %bpl
; GNU-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; GNU-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; GNU-NEXT:    callq __unordtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    setne %al
; GNU-NEXT:    orb %bpl, %al
; GNU-NEXT:    cmoveq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $32, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    popq %rbp
; GNU-NEXT:    retq
;
; X86-LABEL: cmp_ueq_q:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %bl
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __unordtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setne %al
; X86-NEXT:    orb %bl, %al
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovnel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

define i64 @cmp_one_q(i64 %a, i64 %b, fp128 %x, fp128 %y) #0 {
; CHECK-LABEL: cmp_one_q:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $32, %rsp
; CHECK-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; CHECK-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; CHECK-NEXT:    movq %rsi, %rbx
; CHECK-NEXT:    movq %rdi, %r14
; CHECK-NEXT:    callq __eqtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    setne %bpl
; CHECK-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; CHECK-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; CHECK-NEXT:    callq __unordtf2@PLT
; CHECK-NEXT:    testl %eax, %eax
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    testb %bpl, %al
; CHECK-NEXT:    cmoveq %rbx, %r14
; CHECK-NEXT:    movq %r14, %rax
; CHECK-NEXT:    addq $32, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: cmp_one_q:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    pushq %rbp
; ANDROID-NEXT:    pushq %r14
; ANDROID-NEXT:    pushq %rbx
; ANDROID-NEXT:    subq $32, %rsp
; ANDROID-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; ANDROID-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; ANDROID-NEXT:    movq %rsi, %rbx
; ANDROID-NEXT:    movq %rdi, %r14
; ANDROID-NEXT:    callq __eqtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    setne %bpl
; ANDROID-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; ANDROID-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; ANDROID-NEXT:    callq __unordtf2@PLT
; ANDROID-NEXT:    testl %eax, %eax
; ANDROID-NEXT:    sete %al
; ANDROID-NEXT:    testb %bpl, %al
; ANDROID-NEXT:    cmoveq %rbx, %r14
; ANDROID-NEXT:    movq %r14, %rax
; ANDROID-NEXT:    addq $32, %rsp
; ANDROID-NEXT:    popq %rbx
; ANDROID-NEXT:    popq %r14
; ANDROID-NEXT:    popq %rbp
; ANDROID-NEXT:    retq
;
; GNU-LABEL: cmp_one_q:
; GNU:       # %bb.0:
; GNU-NEXT:    pushq %rbp
; GNU-NEXT:    pushq %r14
; GNU-NEXT:    pushq %rbx
; GNU-NEXT:    subq $32, %rsp
; GNU-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; GNU-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; GNU-NEXT:    movq %rsi, %rbx
; GNU-NEXT:    movq %rdi, %r14
; GNU-NEXT:    callq __eqtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    setne %bpl
; GNU-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; GNU-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; GNU-NEXT:    callq __unordtf2@PLT
; GNU-NEXT:    testl %eax, %eax
; GNU-NEXT:    sete %al
; GNU-NEXT:    testb %bpl, %al
; GNU-NEXT:    cmoveq %rbx, %r14
; GNU-NEXT:    movq %r14, %rax
; GNU-NEXT:    addq $32, %rsp
; GNU-NEXT:    popq %rbx
; GNU-NEXT:    popq %r14
; GNU-NEXT:    popq %rbp
; GNU-NEXT:    retq
;
; X86-LABEL: cmp_one_q:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __eqtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    setne %bl
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    pushl %esi
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl {{[0-9]+}}(%esp)
; X86-NEXT:    calll __unordtf2
; X86-NEXT:    addl $32, %esp
; X86-NEXT:    testl %eax, %eax
; X86-NEXT:    sete %al
; X86-NEXT:    testb %bl, %al
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    cmovnel %eax, %ecx
; X86-NEXT:    movl (%ecx), %eax
; X86-NEXT:    movl 4(%ecx), %edx
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
  %cond = call i1 @llvm.experimental.constrained.fcmp.f128(
                                               fp128 %x, fp128 %y,
                                               metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select i1 %cond, i64 %a, i64 %b
  ret i64 %res
}

attributes #0 = { nounwind strictfp }

declare fp128 @llvm.experimental.constrained.fadd.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fsub.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fmul.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fdiv.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fma.f128(fp128, fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.frem.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.ceil.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.acos.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.cos.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.cosh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.exp.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.exp2.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.floor.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.log.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.log10.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.log2.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.maxnum.f128(fp128, fp128, metadata)
declare fp128 @llvm.experimental.constrained.minnum.f128(fp128, fp128, metadata)
declare fp128 @llvm.experimental.constrained.nearbyint.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.pow.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.powi.f128(fp128, i32, metadata, metadata)
declare fp128 @llvm.experimental.constrained.rint.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.round.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.roundeven.f128(fp128, metadata)
declare fp128 @llvm.experimental.constrained.asin.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sin.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sinh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.sqrt.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.atan.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.atan2.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.tan.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.tanh.f128(fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.trunc.f128(fp128, metadata)
declare i32 @llvm.experimental.constrained.lrint.i32.f128(fp128, metadata, metadata)
declare i64 @llvm.experimental.constrained.llrint.i64.f128(fp128, metadata, metadata)
declare i32 @llvm.experimental.constrained.lround.i32.f128(fp128, metadata)
declare i64 @llvm.experimental.constrained.llround.i64.f128(fp128, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f128(fp128, fp128, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f128(fp128, fp128, metadata, metadata)
