@echo off

cd "%USERPROFILE%/Projects/AStyleWx"

REM Can replace --force with -D_WIN32 to for faster testing.
if not exist "src/AboutDlg.cpp.dump" (
echo Creating dump files
"C:/Program Files/Cppcheck/cppcheck.exe"  --dump --force  src/ > src\dump.txt
del src\dump.txt
)

echo.
REM Verify the number of files checked
REM Must manually add any files that are missing to the checks and change the value below.
set count=0
for %%v in (src\*.cpp) do set /a count += 1
echo checking %count% files
set /a count = %count% - 14
echo %count% files missing

echo.
REM  naming.py
REM Variables start with lower case OR underscore plus lower case OR all caps with underline allowed.
REM BOMSize is an allowed exception
REM ErrorHandler and MemoryAlloc are function pointers.
set var="[a-z].*|_[a-z].*|.[A-Z_]*$|BOMSize|ErrorHandler|MemoryAlloc"
REM Functions names start with upper case.
REM Exceptions are getters and setters.
set func="[A-Z].*|get|set"
REM Class names start with upper case.
set class="[A-Z].*"
echo running naming.py
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AboutDlg.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/ASApp.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/ASEditor.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AStyleDisplay.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AStyleDlg.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AStyleFormat.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AStyleIFace.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/AStyleWx.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/Config.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/EditorDlg.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/Encoding.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/FileManager.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/Indent.cpp.dump"
"C:/Program Files/Python37/python.exe"  "%USERPROFILE%/Projects/AStyleTest/file-py/naming.py"  --var=%var% --function=%func% --class=%class%  "src/SettingsDlg.cpp.dump"

echo.
pause
