---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, images, 
              inclure un article dans un document LaTeX, 
              inclure un document multipage, inclure un article dans une thèse,
              numéros de pages avec pdfpages
---

# Comment insérer un document PDF de plusieurs pages ?

Avant tout, notez que les réponses à cette question ne sont pas valables 
pour LaTeX, mais pour `pdfLaTeX`. En effet, le format LaTeX accepte seulement
les inclusions en EPS, et il n'est pas possible d'y inclure des documents 
au format PDF.


## Avec l'extension <ctanpkg:graphicx>

Si le document à inclure ne comporte qu'une seule page, il est possible 
d'utiliser la commande `\includegraphics` de l'extension <ctanpkg:graphicx>. 
Pour plus d'informations sur cette commande, vous pouvez consulter la question
"[](/3_composition/illustrations/images/inclure_une_image)". 


## Avec l'extension <ctanpkg:pdfpages>

L'extension <ctanpkg:pdfpages> a été écrite pour ça. Elle définit les commandes
suivantes :

- `\includepdf` qui sert à insérer les pages d'un document `pdf` ;
- `\includepdfmerge` qui peut insérer les pages de plusieurs documents `pdf` ;
- `\includepdfset` permet de définir des options communes à tous les appels 
  à `\includepdf`.

Ces commandes disposent de nombreuses options décrites 
dans la [documentation](texdoc:pdfpages) de l'extension <ctanpkg:pdfpages>. 
L'exemple ci-dessous montre une utilisation possible de la commande
`\includepdf` (cet exemple produira deux pages comportant chacune 4 pages 
du document `faqfr.pdf`).

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{pdfpages}

\begin{document}
\includepdf[pages=3-10,nup=2x2]{faqfr.pdf}
\end{document}
```


### L'affichage du numéro des pages

Par défaut, l'inclusion d'un document PDF avec l'extension <ctanpkg:pdfpages>
masque le numéro des pages du document englobant.

Cependant, l'option `pagecommand` permet d'exécuter du code sur chaque page 
lors de l'inclusion. Elle peut donc être utilisée de cette façon pour faire
réapparaître les numéros de pages :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{pdfpages}

\begin{document}
\includepdf[pages=-,pagecommand={\thispagestyle{plain}}]{fichier.pdf}
\end{document}
```


:::{sources}
- [Documentation](texdoc:graphicx) de <ctanpkg:graphicx>
- [Documentation](texdoc:pdfpages) de <ctanpkg:pdfpages>
:::