/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaRuntime;
import org.luaj.vm2.LuaStringKt;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.internal.ToolsKt;
import org.luaj.vm2.io.BytesLuaBinInput;
import org.luaj.vm2.io.LuaBinOutput;
import org.luaj.vm2.io.LuaWriter;
import org.luaj.vm2.lib.MathLib;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ~2\u00020\u0001:\u0001~B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020#H\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0000H\u0016J&\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0011\u0010)\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0011\u0010)\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0096\u0002J\u0011\u0010)\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0096\u0002J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0001H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0001H\u0016J\u0013\u0010.\u001a\u00020\t2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\n\u00101\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u00102\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u00103\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\b\u00106\u001a\u00020\u0005H\u0016J\u0016\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0005J\u0016\u00107\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0000J\b\u0010>\u001a\u00020\tH\u0016J\b\u0010?\u001a\u00020\tH\u0016J\b\u0010@\u001a\u00020\tH\u0016J\b\u0010A\u001a\u00020\tH\u0016J\u000e\u0010B\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0000J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010E\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010E\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010E\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010F\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010G\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010G\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010G\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u000e\u0010H\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010I\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010I\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010I\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010J\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010K\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010K\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010K\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\b\u0010L\u001a\u00020\u0001H\u0016J\u0010\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020\u000eH\u0016J\u0010\u0010O\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u0005H\u0016J\u0014\u0010P\u001a\u0004\u0018\u00010\u00192\b\u0010N\u001a\u0004\u0018\u00010\u0019H\u0016J\u0014\u0010Q\u001a\u0004\u0018\u00010\u001b2\b\u0010N\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010R\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020\u001dH\u0016J\u0014\u0010S\u001a\u0004\u0018\u00010\u001f2\b\u0010N\u001a\u0004\u0018\u00010\u001fH\u0016J\u0014\u0010T\u001a\u0004\u0018\u00010\u00002\b\u0010N\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010U\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010U\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010V\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010V\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0005H\u0016J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZJ\u0010\u0010[\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u0000H\u0016J\u0010\u0010[\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0001H\u0016J\b\u0010\\\u001a\u00020\u0005H\u0016J\u0018\u0010]\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0002J \u0010_\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0002J\u0006\u0010a\u001a\u00020\u000eJ\u000e\u0010a\u001a\u00020\u000e2\u0006\u0010`\u001a\u00020\u0005J\u0010\u0010b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010b\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0001H\u0016J\n\u0010c\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010d\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010d\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010d\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0016J\u0010\u0010e\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u000eH\u0016J\u0016\u0010f\u001a\u00020\u00002\u0006\u0010g\u001a\u00020\u00052\u0006\u0010h\u001a\u00020\u0005J\u0006\u0010i\u001a\u00020jJ\b\u0010k\u001a\u000209H\u0016J\b\u0010l\u001a\u00020mH\u0016J\b\u0010n\u001a\u00020\u000eH\u0016J\b\u0010o\u001a\u00020pH\u0016J\b\u0010q\u001a\u00020\u0005H\u0016J\b\u0010r\u001a\u00020\u001bH\u0016J\b\u0010s\u001a\u00020\u001dH\u0016J\b\u0010t\u001a\u00020\u0001H\u0016J\u000e\u0010t\u001a\u00020\u00012\u0006\u0010`\u001a\u00020\u0005J\b\u0010u\u001a\u00020vH\u0016J\b\u0010w\u001a\u00020\u0001H\u0016J\b\u0010x\u001a\u00020\u0005H\u0016J\b\u0010y\u001a\u00020\u001bH\u0016J\u001e\u0010z\u001a\u00020X2\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lorg/luaj/vm2/LuaString;", "Lorg/luaj/vm2/LuaValue;", "m_bytes", "", "m_offset", "", "m_length", "([BII)V", "isValidUtf8", "", "()Z", "m_hashcode", "add", "rhs", "", "byteseq", "bytes", "off", "len", "charAt", "index", "checkarith", "checkdouble", "checkint", "checkinteger", "Lorg/luaj/vm2/LuaInteger;", "checkjstring", "", "checklong", "", "checknumber", "Lorg/luaj/vm2/LuaNumber;", "msg", "checkstring", "concat", "Lorg/luaj/vm2/Buffer;", "concatTo", "lhs", "copyInto", "strOffset", "arrayOffset", "div", "divInto", "eq", "val", "eq_b", "equals", "o", "", "getmetatable", "gt", "gt_b", "gteq", "gteq_b", "hashCode", "indexOf", "b", "", "start", "s", "indexOfAny", "accept", "isint", "islong", "isnumber", "isstring", "lastIndexOf", "length", "lt", "lt_b", "lteq", "lteq_b", "luaByte", "mod", "modFrom", "mul", "neg", "optdouble", "defval", "optint", "optinteger", "optjstring", "optlong", "optnumber", "optstring", "pow", "powWith", "printToStream", "", "ps", "Lorg/luaj/vm2/io/LuaWriter;", "raweq", "rawlen", "scandouble", "end", "scanlong", "base", "scannumber", "strcmp", "strvalue", "sub", "subFrom", "substring", "beginIndex", "endIndex", "toLuaBinInput", "Lorg/luaj/vm2/io/BytesLuaBinInput;", "tobyte", "tochar", "", "todouble", "tofloat", "", "toint", "tojstring", "tolong", "tonumber", "toshort", "", "tostring", "type", "typename", "write", "writer", "Lorg/luaj/vm2/io/LuaBinOutput;", "i", "Companion", "luak"})
public final class LuaString
extends LuaValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final byte[] m_bytes;
    @JvmField
    public final int m_offset;
    @JvmField
    public final int m_length;
    private final int m_hashcode;
    public static final int RECENT_STRINGS_CACHE_SIZE = 128;
    public static final int RECENT_STRINGS_MAX_LENGTH = 32;

    private LuaString(byte[] m_bytes, int m_offset, int m_length) {
        this.m_bytes = m_bytes;
        this.m_offset = m_offset;
        this.m_length = m_length;
        this.m_hashcode = Companion.hashCode(this.m_bytes, this.m_offset, this.m_length);
    }

    public final boolean isValidUtf8() {
        int i = this.m_offset;
        int j = this.m_offset + this.m_length;
        while (i < j) {
            int n = i;
            i = n + 1;
            byte c = this.m_bytes[n];
            if (c >= 0) continue;
            if ((c & 0xE0) == 192 && i < j) {
                n = i;
                i = n + 1;
                if ((this.m_bytes[n] & 0xC0) == 128) continue;
            }
            if ((c & 0xF0) == 224 && i + 1 < j) {
                n = i;
                i = n + 1;
                if ((this.m_bytes[n] & 0xC0) == 128) {
                    n = i;
                    i = n + 1;
                    if ((this.m_bytes[n] & 0xC0) == 128) continue;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    @Nullable
    public LuaValue getmetatable() {
        return Companion.getS_metatable();
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    @NotNull
    public String typename() {
        return "string";
    }

    @Override
    @NotNull
    public String tojstring() {
        return Companion.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    @NotNull
    public LuaValue neg() {
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? super.neg() : (LuaValue)LuaValue.Companion.valueOf(-d);
    }

    @Override
    @NotNull
    public LuaValue add(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getADD(), rhs) : rhs.add(d);
    }

    @Override
    @NotNull
    public LuaValue add(double rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() + rhs);
    }

    @Override
    @NotNull
    public LuaValue add(int rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() + (double)rhs);
    }

    @Override
    @NotNull
    public LuaValue sub(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getSUB(), rhs) : rhs.subFrom(d);
    }

    @Override
    @NotNull
    public LuaValue sub(double rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() - rhs);
    }

    @Override
    @NotNull
    public LuaValue sub(int rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() - (double)rhs);
    }

    @Override
    @NotNull
    public LuaValue subFrom(double lhs) {
        return LuaValue.Companion.valueOf(lhs - this.checkarith());
    }

    @Override
    @NotNull
    public LuaValue mul(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getMUL(), rhs) : rhs.mul(d);
    }

    @Override
    @NotNull
    public LuaValue mul(double rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() * rhs);
    }

    @Override
    @NotNull
    public LuaValue mul(int rhs) {
        return LuaValue.Companion.valueOf(this.checkarith() * (double)rhs);
    }

    @Override
    @NotNull
    public LuaValue pow(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getPOW(), rhs) : rhs.powWith(d);
    }

    @Override
    @NotNull
    public LuaValue pow(double rhs) {
        return MathLib.Companion.dpow(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue pow(int rhs) {
        return MathLib.Companion.dpow(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue powWith(double lhs) {
        return MathLib.Companion.dpow(lhs, this.checkarith());
    }

    @Override
    @NotNull
    public LuaValue powWith(int lhs) {
        return MathLib.Companion.dpow(lhs, this.checkarith());
    }

    @Override
    @NotNull
    public LuaValue div(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getDIV(), rhs) : rhs.divInto(d);
    }

    @Override
    @NotNull
    public LuaValue div(double rhs) {
        return LuaDouble.Companion.ddiv(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue div(int rhs) {
        return LuaDouble.Companion.ddiv(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue divInto(double lhs) {
        return LuaDouble.Companion.ddiv(lhs, this.checkarith());
    }

    @Override
    @NotNull
    public LuaValue mod(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? this.arithmt(LuaValue.Companion.getMOD(), rhs) : rhs.modFrom(d);
    }

    @Override
    @NotNull
    public LuaValue mod(double rhs) {
        return LuaDouble.Companion.dmod(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue mod(int rhs) {
        return LuaDouble.Companion.dmod(this.checkarith(), rhs);
    }

    @Override
    @NotNull
    public LuaValue modFrom(double lhs) {
        return LuaDouble.Companion.dmod(lhs, this.checkarith());
    }

    @Override
    @NotNull
    public LuaValue lt(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) > 0 ? (LuaValue)LuaValue.Companion.getTRUE() : (LuaValue)LuaValue.Companion.getFALSE();
    }

    @Override
    public boolean lt_b(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) > 0;
    }

    @Override
    public boolean lt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean lt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public LuaValue lteq(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) >= 0 ? (LuaValue)LuaValue.Companion.getTRUE() : (LuaValue)LuaValue.Companion.getFALSE();
    }

    @Override
    public boolean lteq_b(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) >= 0;
    }

    @Override
    public boolean lteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean lteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public LuaValue gt(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) < 0 ? (LuaValue)LuaValue.Companion.getTRUE() : (LuaValue)LuaValue.Companion.getFALSE();
    }

    @Override
    public boolean gt_b(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) < 0;
    }

    @Override
    public boolean gt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean gt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public LuaValue gteq(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) <= 0 ? (LuaValue)LuaValue.Companion.getTRUE() : (LuaValue)LuaValue.Companion.getFALSE();
    }

    @Override
    public boolean gteq_b(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.strcmp(this) <= 0;
    }

    @Override
    public boolean gteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean gteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public LuaValue concat(@NotNull LuaValue rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.concatTo(this);
    }

    @Override
    @NotNull
    public Buffer concat(@NotNull Buffer rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        return rhs.concatTo(this);
    }

    @Override
    @NotNull
    public LuaValue concatTo(@NotNull LuaNumber lhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        LuaString luaString = lhs.strvalue();
        Intrinsics.checkNotNull(luaString);
        return this.concatTo(luaString);
    }

    @Override
    @NotNull
    public LuaValue concatTo(@NotNull LuaString lhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        byte[] b = new byte[lhs.m_length + this.m_length];
        ToolsKt.arraycopy(lhs.m_bytes, lhs.m_offset, b, 0, lhs.m_length);
        ToolsKt.arraycopy(this.m_bytes, this.m_offset, b, lhs.m_length, this.m_length);
        return org.luaj.vm2.LuaString$Companion.valueUsing$default(Companion, b, 0, b.length, null, 8, null);
    }

    @Override
    public int strcmp(@NotNull LuaValue lhs) {
        Intrinsics.checkNotNullParameter(lhs, "lhs");
        return -lhs.strcmp(this);
    }

    @Override
    public int strcmp(@NotNull LuaString rhs) {
        Intrinsics.checkNotNullParameter(rhs, "rhs");
        int i = 0;
        for (int j = 0; i < this.m_length && j < rhs.m_length; ++i, ++j) {
            if (this.m_bytes[this.m_offset + i] == rhs.m_bytes[rhs.m_offset + j]) continue;
            return this.m_bytes[this.m_offset + i] - rhs.m_bytes[rhs.m_offset + j];
        }
        return this.m_length - rhs.m_length;
    }

    private final double checkarith() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.aritherror();
            throw new KotlinNothingValueException();
        }
        return d;
    }

    @Override
    public int checkint() {
        return (int)this.checkdouble();
    }

    @Override
    @Nullable
    public LuaInteger checkinteger() {
        return LuaValue.Companion.valueOf(this.checkint());
    }

    @Override
    public long checklong() {
        return (long)this.checkdouble();
    }

    @Override
    public double checkdouble() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.argerror("number");
            throw new KotlinNothingValueException();
        }
        return d;
    }

    @Override
    @Nullable
    public LuaNumber checknumber() {
        return LuaValue.Companion.valueOf(this.checkdouble());
    }

    @Override
    @NotNull
    public LuaNumber checknumber(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            LuaValue.Companion.error(msg);
        }
        return LuaValue.Companion.valueOf(d);
    }

    @Override
    public boolean isnumber() {
        double d = this.scannumber();
        boolean bl = false;
        return !Double.isNaN(d);
    }

    @Override
    public boolean isint() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        int i = (int)d;
        return (double)i == d;
    }

    @Override
    public boolean islong() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    @Override
    public byte tobyte() {
        return (byte)this.toint();
    }

    @Override
    public char tochar() {
        return (char)this.toint();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double todouble() {
        void var1_1;
        double d = this.scannumber();
        boolean bl = false;
        return Double.isNaN(d) ? 0.0 : var1_1;
    }

    @Override
    public float tofloat() {
        return (float)this.todouble();
    }

    @Override
    public int toint() {
        return (int)this.tolong();
    }

    @Override
    public long tolong() {
        return (long)this.todouble();
    }

    @Override
    public short toshort() {
        return (short)this.toint();
    }

    @Override
    public double optdouble(double defval) {
        LuaNumber luaNumber = this.checknumber();
        Intrinsics.checkNotNull(luaNumber);
        return luaNumber.checkdouble();
    }

    @Override
    public int optint(int defval) {
        LuaNumber luaNumber = this.checknumber();
        Intrinsics.checkNotNull(luaNumber);
        return luaNumber.checkint();
    }

    @Override
    @Nullable
    public LuaInteger optinteger(@Nullable LuaInteger defval) {
        LuaNumber luaNumber = this.checknumber();
        Intrinsics.checkNotNull(luaNumber);
        return luaNumber.checkinteger();
    }

    @Override
    public long optlong(long defval) {
        LuaNumber luaNumber = this.checknumber();
        Intrinsics.checkNotNull(luaNumber);
        return luaNumber.checklong();
    }

    @Override
    @Nullable
    public LuaNumber optnumber(@Nullable LuaNumber defval) {
        LuaNumber luaNumber = this.checknumber();
        Intrinsics.checkNotNull(luaNumber);
        return luaNumber.checknumber();
    }

    @Override
    @Nullable
    public LuaString optstring(@Nullable LuaString defval) {
        return this;
    }

    @Override
    @NotNull
    public LuaValue tostring() {
        return this;
    }

    @Override
    @Nullable
    public String optjstring(@Nullable String defval) {
        return this.tojstring();
    }

    @Override
    @Nullable
    public LuaString strvalue() {
        return this;
    }

    @NotNull
    public final LuaString substring(int beginIndex, int endIndex) {
        int off = this.m_offset + beginIndex;
        int len = endIndex - beginIndex;
        return len >= this.m_length / 2 ? org.luaj.vm2.LuaString$Companion.valueUsing$default(Companion, this.m_bytes, off, len, null, 8, null) : org.luaj.vm2.LuaString$Companion.valueOf2$default(Companion, this.m_bytes, off, len, null, 8, null);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return o instanceof LuaString ? this.raweq((LuaString)o) : false;
    }

    @Override
    @NotNull
    public LuaValue eq(@NotNull LuaValue val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val.raweq(this) ? (LuaValue)LuaValue.Companion.getTRUE() : (LuaValue)LuaValue.Companion.getFALSE();
    }

    @Override
    public boolean eq_b(@NotNull LuaValue val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val.raweq(this);
    }

    @Override
    public boolean raweq(@NotNull LuaValue val) {
        Intrinsics.checkNotNullParameter(val, "val");
        return val.raweq(this);
    }

    @Override
    public boolean raweq(@NotNull LuaString s) {
        Intrinsics.checkNotNullParameter(s, "s");
        if (this == s) {
            return true;
        }
        if (s.m_length != this.m_length) {
            return false;
        }
        if (Intrinsics.areEqual(s.m_bytes, this.m_bytes) && s.m_offset == this.m_offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        int n = 0;
        int n2 = this.m_length;
        while (n < n2) {
            int i;
            if (s.m_bytes[s.m_offset + (i = n++)] == this.m_bytes[this.m_offset + i]) continue;
            return false;
        }
        return true;
    }

    private final boolean byteseq(byte[] bytes, int off, int len) {
        return this.m_length == len && Companion.equals(this.m_bytes, this.m_offset, bytes, off, len);
    }

    public final void write(@NotNull LuaBinOutput writer2, int i, int len) {
        Intrinsics.checkNotNullParameter(writer2, "writer");
        writer2.write(this.m_bytes, this.m_offset + i, len);
    }

    @Override
    @NotNull
    public LuaValue len() {
        return LuaInteger.Companion.valueOf2(this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public int rawlen() {
        return this.m_length;
    }

    public final int luaByte(int index) {
        return this.m_bytes[this.m_offset + index] & 0xFF;
    }

    public final int charAt(int index) {
        if (index < 0 || index >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    @Override
    @Nullable
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    @NotNull
    public LuaString checkstring() {
        return this;
    }

    @NotNull
    public final BytesLuaBinInput toLuaBinInput() {
        return new BytesLuaBinInput(this.m_bytes, this.m_offset, this.m_length);
    }

    @NotNull
    public final byte[] copyInto(int strOffset, @NotNull byte[] bytes, int arrayOffset, int len) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return ToolsKt.arraycopy(this.m_bytes, this.m_offset + strOffset, bytes, arrayOffset, len);
    }

    public final int indexOfAny(@NotNull LuaString accept2) {
        Intrinsics.checkNotNullParameter(accept2, "accept");
        int ilimit = this.m_offset + this.m_length;
        int jlimit = accept2.m_offset + accept2.m_length;
        int n = this.m_offset;
        while (n < ilimit) {
            int i = n++;
            int n2 = accept2.m_offset;
            while (n2 < jlimit) {
                int j;
                if (this.m_bytes[i] != accept2.m_bytes[j = n2++]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public final int indexOf(byte b, int start) {
        int n = start;
        int n2 = this.m_length;
        while (n < n2) {
            int i;
            if (this.m_bytes[this.m_offset + (i = n++)] != b) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(@NotNull LuaString s, int start) {
        Intrinsics.checkNotNullParameter(s, "s");
        int slen = s.length();
        int limit = this.m_length - slen;
        int n = start;
        if (n <= limit) {
            int i;
            do {
                if (!Companion.equals(this.m_bytes, this.m_offset + (i = n++), s.m_bytes, s.m_offset, slen)) continue;
                return i;
            } while (i != limit);
        }
        return -1;
    }

    public final int lastIndexOf(@NotNull LuaString s) {
        int limit;
        Intrinsics.checkNotNullParameter(s, "s");
        int slen = s.length();
        int n = limit = this.m_length - slen;
        if (0 <= n) {
            do {
                int i;
                if (!Companion.equals(this.m_bytes, this.m_offset + (i = n--), s.m_bytes, s.m_offset, slen)) continue;
                return i;
            } while (0 <= n);
        }
        return -1;
    }

    @Override
    @NotNull
    public LuaValue tonumber() {
        double d = this.scannumber();
        return Double.isNaN(d) ? LuaValue.Companion.getNIL() : (LuaValue)LuaValue.Companion.valueOf(d);
    }

    @NotNull
    public final LuaValue tonumber(int base) {
        double d = this.scannumber(base);
        return Double.isNaN(d) ? LuaValue.Companion.getNIL() : (LuaValue)LuaValue.Companion.valueOf(d);
    }

    public final double scannumber() {
        int i;
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.m_bytes[i] == 32; ++i) {
        }
        while (i < j && this.m_bytes[j - 1] == 32) {
            --j;
        }
        if (i >= j) {
            return Double.NaN;
        }
        if (this.m_bytes[i] == 48 && i + 1 < j && (this.m_bytes[i + 1] == 120 || this.m_bytes[i + 1] == 88)) {
            return this.scanlong(16, i + 2, j);
        }
        double l = this.scanlong(10, i, j);
        return Double.isNaN(l) ? this.scandouble(i, j) : l;
    }

    public final double scannumber(int base) {
        int i;
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.m_bytes[i] == 32; ++i) {
        }
        while (i < j && this.m_bytes[j - 1] == 32) {
            --j;
        }
        return i >= j ? Double.NaN : this.scanlong(base, i, j);
    }

    private final double scanlong(int base, int start, int end2) {
        int n;
        long x = 0L;
        boolean neg = this.m_bytes[start] == 45;
        int n2 = n = neg ? start + 1 : start;
        while (n < end2) {
            int i;
            int digit;
            if ((digit = (this.m_bytes[i = n++] & 0xFF) - (base <= 10 || this.m_bytes[i] >= 48 && this.m_bytes[i] <= 57 ? 48 : (this.m_bytes[i] >= 65 && this.m_bytes[i] <= 90 ? 55 : 87))) < 0 || digit >= base) {
                return Double.NaN;
            }
            if ((x = x * (long)base + (long)digit) >= 0L) continue;
            return Double.NaN;
        }
        return neg ? -x : x;
    }

    private final double scandouble(int start, int end2) {
        int i;
        int end3 = end2;
        if (end3 > start + 64) {
            end3 = start + 64;
        }
        int n = start;
        while (n < end3) {
            char c;
            if (((((((((((((((c = (char)this.m_bytes[i = n++]) == '-' ? true : c == '+') ? true : c == '.') ? true : c == 'e') ? true : c == 'E') ? true : c == '0') ? true : c == '1') ? true : c == '2') ? true : c == '3') ? true : c == '4') ? true : c == '5') ? true : c == '6') ? true : c == '7') ? true : c == '8') ? true : c == '9') continue;
            return Double.NaN;
        }
        char[] c = new char[end3 - start];
        i = start;
        while (i < end3) {
            int i2 = i++;
            c[i2 - start] = (char)this.m_bytes[i2];
        }
        try {
            return Double.parseDouble(StringsKt.concatToString(c));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public final void printToStream(@NotNull LuaWriter ps) {
        Intrinsics.checkNotNullParameter(ps, "ps");
        int i = 0;
        int n = this.m_length;
        while (i < n) {
            byte c = this.m_bytes[this.m_offset + i];
            ps.print(Character.valueOf((char)c));
            int n2 = i;
            i = n2 + 1;
        }
    }

    public /* synthetic */ LuaString(byte[] m_bytes, int m_offset, int m_length, DefaultConstructorMarker $constructor_marker) {
        this(m_bytes, m_offset, m_length);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0004J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004J\u001e\u0010 \u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\"\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0015\u0010$\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\b%J1\u0010$\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007\u00a2\u0006\u0002\b%J$\u0010$\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\u0004H\u0007J\u0015\u0010$\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\b%J0\u0010)\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020\u00042\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lorg/luaj/vm2/LuaString$Companion;", "", "()V", "RECENT_STRINGS_CACHE_SIZE", "", "RECENT_STRINGS_MAX_LENGTH", "value", "Lorg/luaj/vm2/LuaValue;", "s_metatable", "getS_metatable", "()Lorg/luaj/vm2/LuaValue;", "setS_metatable", "(Lorg/luaj/vm2/LuaValue;)V", "decodeAsUtf8", "", "bytes", "", "offset", "length", "encodeToUtf8", "chars", "", "nchars", "off", "equals", "", "a", "i", "b", "j", "n", "Lorg/luaj/vm2/LuaString;", "hashCode", "lengthAsUtf8", "valueFromCopy", "len", "valueOf", "valueOf2", "runtime", "Lorg/luaj/vm2/LuaRuntime;", "string", "valueUsing", "luak"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LuaValue getS_metatable() {
            return LuaStringKt.access$getLuaString_metatable$p();
        }

        public final void setS_metatable(@Nullable LuaValue value) {
            LuaStringKt.access$setLuaString_metatable$p(value);
        }

        @JvmName(name="valueOf2")
        @NotNull
        public final LuaString valueOf2(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            char[] c = cArray;
            byte[] b = new byte[this.lengthAsUtf8(c)];
            this.encodeToUtf8(c, c.length, b, 0);
            return org.luaj.vm2.LuaString$Companion.valueUsing$default(this, b, 0, b.length, null, 8, null);
        }

        @JvmName(name="valueOf2")
        @NotNull
        public final LuaString valueOf2(@NotNull byte[] bytes, int off, int len, @Nullable LuaRuntime runtime) {
            LuaString luaString;
            LuaString t;
            LuaString luaString2;
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            if (len > 32) {
                return this.valueFromCopy(bytes, off, len);
            }
            int hash = this.hashCode(bytes, off, len);
            int bucket = hash & 0x7F;
            LuaRuntime luaRuntime = runtime;
            if (luaRuntime == null) {
                luaString2 = null;
            } else {
                LuaString[] luaStringArray = luaRuntime.getRecent_short_strings();
                luaString2 = t = luaStringArray == null ? null : luaStringArray[bucket];
            }
            if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len)) {
                return t;
            }
            LuaString it = luaString = this.valueFromCopy(bytes, off, len);
            boolean bl = false;
            if (runtime != null) {
                runtime.getRecent_short_strings()[bucket] = it;
            }
            return luaString;
        }

        public static /* synthetic */ LuaString valueOf2$default(Companion companion, byte[] byArray, int n, int n2, LuaRuntime luaRuntime, int n3, Object object) {
            if ((n3 & 8) != 0) {
                luaRuntime = LuaRuntime.Companion.getDefault();
            }
            return companion.valueOf2(byArray, n, n2, luaRuntime);
        }

        private final LuaString valueFromCopy(byte[] bytes, int off, int len) {
            byte[] copy2 = new byte[len];
            int n = 0;
            while (n < len) {
                int i = n++;
                copy2[i] = bytes[off + i];
            }
            return new LuaString(copy2, 0, len, null);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueUsing(@NotNull byte[] bytes, int off, int len, @Nullable LuaRuntime runtime) {
            LuaString luaString;
            LuaString t;
            LuaString luaString2;
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            if (bytes.length > 32) {
                return new LuaString(bytes, off, len, null);
            }
            int hash = this.hashCode(bytes, off, len);
            int bucket = hash & 0x7F;
            LuaRuntime luaRuntime = runtime;
            if (luaRuntime == null) {
                luaString2 = null;
            } else {
                LuaString[] luaStringArray = luaRuntime.getRecent_short_strings();
                luaString2 = t = luaStringArray == null ? null : luaStringArray[bucket];
            }
            if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len)) {
                return t;
            }
            LuaString it = luaString = new LuaString(bytes, off, len, null);
            boolean bl = false;
            if (runtime != null) {
                runtime.getRecent_short_strings()[bucket] = it;
            }
            return luaString;
        }

        public static /* synthetic */ LuaString valueUsing$default(Companion companion, byte[] byArray, int n, int n2, LuaRuntime luaRuntime, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            if ((n3 & 8) != 0) {
                luaRuntime = LuaRuntime.Companion.getDefault();
            }
            return companion.valueUsing(byArray, n, n2, luaRuntime);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueOf(@NotNull char[] bytes, int off, int len) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            byte[] b = new byte[len];
            int n = 0;
            while (n < len) {
                int i = n++;
                b[i] = (byte)bytes[i + off];
            }
            return org.luaj.vm2.LuaString$Companion.valueUsing$default(this, b, 0, len, null, 8, null);
        }

        public static /* synthetic */ LuaString valueOf$default(Companion companion, char[] cArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = cArray.length;
            }
            return companion.valueOf(cArray, n, n2);
        }

        @JvmName(name="valueOf2")
        @NotNull
        public final LuaString valueOf2(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueOf2$default(this, bytes, 0, bytes.length, null, 8, null);
        }

        public final int hashCode(@NotNull byte[] bytes, int offset, int length) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            int h = length;
            int step = (length >> 5) + 1;
            for (int l1 = length; l1 >= step; l1 -= step) {
                h ^= (h << 5) + (h >> 2) + (bytes[offset + l1 - 1] & 0xFF);
            }
            return h;
        }

        public final boolean equals(@NotNull LuaString a, int i, @NotNull LuaString b, int j, int n) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            return this.equals(a.m_bytes, a.m_offset + i, b.m_bytes, b.m_offset + j, n);
        }

        public final boolean equals(@NotNull byte[] a, int i, @NotNull byte[] b, int j, int n) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            int i2 = i;
            int j2 = j;
            int n2 = n;
            if (a.length < i2 + n2 || b.length < j2 + n2) {
                return false;
            }
            while (--n2 >= 0) {
                int n3 = i2;
                i2 = n3 + 1;
                byte by = a[n3];
                n3 = j2;
                j2 = n3 + 1;
                if (by == b[n3]) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public final String decodeAsUtf8(@NotNull byte[] bytes, int offset, int length) {
            int n;
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            int i = 0;
            int j = 0;
            int n2 = 0;
            int b = 0;
            i = offset;
            j = offset + length;
            n2 = 0;
            while (i < j) {
                n = i;
                i = n + 1;
                switch (0xE0 & bytes[n]) {
                    case 224: {
                        ++i;
                        ++i;
                        break;
                    }
                    case 192: {
                        ++i;
                    }
                }
                ++n2;
            }
            char[] chars = new char[n2];
            i = offset;
            j = offset + length;
            n2 = 0;
            while (i < j) {
                int n3;
                n = n2;
                n2 = n + 1;
                Companion companion = this;
                int n4 = n;
                char[] cArray = chars;
                boolean bl = false;
                int n5 = i;
                i = n5 + 1;
                int n6 = b = bytes[n5];
                if (n6 >= 0 || i >= j) {
                    n3 = b;
                } else if (b < -32 || i + 1 >= j) {
                    n = i;
                    i = n + 1;
                    n3 = (b & 0x3F) << 6 | bytes[n] & 0x3F;
                } else {
                    n = i;
                    i = n + 1;
                    int n7 = (b & 0xF) << 12 | (bytes[n] & 0x3F) << 6;
                    n = i;
                    i = n + 1;
                    n3 = n7 | bytes[n] & 0x3F;
                }
                cArray[n4] = (char)n3;
            }
            return StringsKt.concatToString(chars);
        }

        public final int lengthAsUtf8(@NotNull char[] chars) {
            int b;
            Intrinsics.checkNotNullParameter(chars, "chars");
            int i = 0;
            char c = '\u0000';
            i = b = chars.length;
            while ((i += -1) >= 0) {
                Companion $this$lengthAsUtf8_u24lambda_u2d3 = this;
                boolean bl = false;
                c = chars[i];
                if (c < '\u0080') continue;
                b += c >= '\u0800' ? 2 : 1;
            }
            return b;
        }

        public final int encodeToUtf8(@NotNull char[] chars, int nchars, @NotNull byte[] bytes, int off) {
            Intrinsics.checkNotNullParameter(chars, "chars");
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            char c = '\u0000';
            int j = off;
            int n = 0;
            while (n < nchars) {
                int n2;
                int i = n++;
                Companion $this$encodeToUtf8_u24lambda_u2d4 = this;
                boolean bl = false;
                c = chars[i];
                if (c < '\u0080') {
                    n2 = j;
                    j = n2 + 1;
                    bytes[n2] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    n2 = j;
                    j = n2 + 1;
                    bytes[n2] = (byte)(0xC0 | c >> 6 & 0x1F);
                    n2 = j;
                    j = n2 + 1;
                    bytes[n2] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                n2 = j;
                j = n2 + 1;
                bytes[n2] = (byte)(0xE0 | c >> 12 & 0xF);
                n2 = j;
                j = n2 + 1;
                bytes[n2] = (byte)(0x80 | c >> 6 & 0x3F);
                n2 = j;
                j = n2 + 1;
                bytes[n2] = (byte)(0x80 | c & 0x3F);
            }
            return j - off;
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueUsing(@NotNull byte[] bytes, int off, int len) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueUsing$default(this, bytes, off, len, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueUsing(@NotNull byte[] bytes, int off) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueUsing$default(this, bytes, off, 0, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueUsing(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueUsing$default(this, bytes, 0, 0, null, 14, null);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueOf(@NotNull char[] bytes, int off) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueOf$default(this, bytes, off, 0, 4, null);
        }

        @JvmOverloads
        @NotNull
        public final LuaString valueOf(@NotNull char[] bytes) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            return org.luaj.vm2.LuaString$Companion.valueOf$default(this, bytes, 0, 0, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

