/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.utils;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import mu.KLogger;
import mu.KotlinLogging;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.cli.utils.DisplayUtils;
import org.islandoftex.arara.cli.utils.StringExtensionsKt;
import org.islandoftex.arara.core.configuration.ConfigurationUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0018\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0015\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020!H\u0002J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u0006\u0010-\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\fH\u0002J\u0014\u00100\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000402J\u000e\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u000e\u00107\u001a\u00020!2\u0006\u0010/\u001a\u00020\fJ\u000e\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u000e\u0010\u001f\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/islandoftex/arara/cli/utils/DisplayUtils;", "", "()V", "applicationPath", "", "getApplicationPath$cli", "()Ljava/lang/String;", "configurationFileName", "getConfigurationFileName", "setConfigurationFileName", "(Ljava/lang/String;)V", "displayException", "", "displayLine", "displayResult", "displayRolling", "isDryRunMode", "()Z", "isVerboseMode", "logger", "Lmu/KLogger;", "logoString", "getLogoString", "longestMatch", "", "getLongestMatch", "()I", "longestMatch$delegate", "Lkotlin/Lazy;", "outputWidth", "getOutputWidth", "shortenedLongestMatch", "buildDryRunEntry", "", "name", "task", "buildLongEntry", "buildShortEntry", "byteSizeToString", "size", "", "byteSizeToString$cli", "displayDetailsLine", "displayOutputSeparator", "message", "displaySeparator", "getResult", "value", "printAuthors", "authors", "", "printConditional", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "printEntry", "printEntryResult", "printException", "exception", "Lorg/islandoftex/arara/api/AraraException;", "printTime", "seconds", "", "printWrapped", "text", "cli"})
public final class DisplayUtils {
    @NotNull
    public static final DisplayUtils INSTANCE = new DisplayUtils();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private static final String logoString = "  __ _ _ __ __ _ _ __ __ _\n / _` | '__/ _` | '__/ _` |\n| (_| | | | (_| | | | (_| |\n \\__,_|_|  \\__,_|_|  \\__,_|";
    @NotNull
    private static String configurationFileName = "[none]";
    @NotNull
    private static final Lazy longestMatch$delegate = LazyKt.lazy(longestMatch.2.INSTANCE);
    private static final int shortenedLongestMatch = 10;
    private static boolean displayLine = true;
    private static boolean displayResult;
    private static boolean displayRolling;
    private static boolean displayException;

    private DisplayUtils() {
    }

    @NotNull
    public final String getLogoString() {
        return logoString;
    }

    @NotNull
    public final String getConfigurationFileName() {
        return configurationFileName;
    }

    public final void setConfigurationFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        configurationFileName = string;
    }

    private final int getLongestMatch() {
        Lazy lazy = longestMatch$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final boolean isDryRunMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getExecutionMode() == ExecutionMode.DRY_RUN;
    }

    private final boolean isVerboseMode() {
        return LinearExecutor.INSTANCE.getExecutionOptions().getVerbose();
    }

    @NotNull
    public final String getApplicationPath$cli() {
        String string;
        try {
            string = ConfigurationUtils.getApplicationPath().toString();
        }
        catch (AraraException _) {
            string = "[unknown application path]";
        }
        return string;
    }

    private final int getOutputWidth() {
        return Session.INSTANCE.getUserInterfaceOptions().getTerminalOutputWidth();
    }

    private final void buildShortEntry(String name, String task) {
        int result2 = this.getLongestMatch() >= this.getOutputWidth() ? 10 : this.getLongestMatch();
        int space = this.getOutputWidth() - result2 - 1;
        String line = StringExtensionsKt.abbreviate$default('(' + name + ") " + task + ' ', space - "... ".length(), null, 2, null);
        System.out.print((Object)(StringsKt.padEnd(line, space, '.') + ' '));
    }

    public final void printEntryResult(boolean value) {
        displayLine = false;
        displayResult = true;
        logger.info((Function0<? extends Object>)new Function0<Object>(value){
            final /* synthetic */ boolean $value;
            {
                this.$value = $value;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return LanguageController.getMessages().getLOG_INFO_TASK_RESULT() + ' ' + DisplayUtils.access$getResult(DisplayUtils.INSTANCE, this.$value);
            }
        });
        if (!this.isDryRunMode()) {
            String string = !this.isVerboseMode() ? StringsKt.padStart$default(this.getResult(value), this.getLongestMatch(), '\u0000', 2, null) : '\n' + StringsKt.padStart(' ' + this.getResult(value), this.getOutputWidth(), '-');
            System.out.println((Object)string);
        }
    }

    public final void printEntry(@NotNull String name, @NotNull String task) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(task, "task");
        logger.info((Function0<? extends Object>)new Function0<Object>(task, name){
            final /* synthetic */ String $task;
            final /* synthetic */ String $name;
            {
                this.$task = $task;
                this.$name = $name;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String[] stringArray = new String[]{this.$task, this.$name};
                return org.islandoftex.arara.core.utils.StringExtensionsKt.formatString(LanguageController.getMessages().getLOG_INFO_INTERPRET_TASK(), stringArray);
            }
        });
        displayLine = true;
        displayResult = false;
        if (!this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortEntry(name, task);
            } else {
                this.buildLongEntry(name, task);
            }
        } else {
            this.buildDryRunEntry(name, task);
        }
    }

    private final void buildLongEntry(String name, String task) {
        if (displayRolling) {
            System.out.println();
        } else {
            displayRolling = true;
        }
        System.out.println((Object)this.displaySeparator());
        String string = StringExtensionsKt.abbreviate$default('(' + name + ") " + task, this.getOutputWidth(), null, 2, null);
        System.out.println((Object)string);
        System.out.println((Object)this.displaySeparator());
    }

    private final void buildDryRunEntry(String name, String task) {
        if (displayRolling) {
            System.out.println();
        } else {
            displayRolling = true;
        }
        System.out.println((Object)StringExtensionsKt.abbreviate$default("[DR] (" + name + ") " + task, this.getOutputWidth(), null, 2, null));
        System.out.println((Object)this.displaySeparator());
    }

    public final void printException(@NotNull AraraException exception) {
        String string;
        Intrinsics.checkNotNullParameter(exception, "exception");
        displayException = true;
        if (displayResult) {
            System.out.println();
        }
        if (displayLine && !this.isDryRunMode()) {
            String string2 = !this.isVerboseMode() ? StringsKt.padStart$default(LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getLongestMatch(), '\u0000', 2, null) : StringsKt.padStart(' ' + LanguageController.getMessages().getINFO_LABEL_ON_ERROR(), this.getOutputWidth(), '-');
            System.out.println((Object)string2);
            System.out.println();
        }
        if ((string = exception.hasException() ? exception.getMessage() + ' ' + LanguageController.getMessages().getINFO_DISPLAY_EXCEPTION_MORE_DETAILS() : exception.getMessage()) == null) {
            string = "EXCEPTION PROVIDES NO MESSAGE";
        }
        String text2 = string;
        logger.error((Function0<? extends Object>)new Function0<Object>(text2){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$text;
            }
        });
        this.printWrapped(text2);
        if (exception.hasException()) {
            System.out.println();
            this.displayDetailsLine();
            Exception exception2 = exception.getException();
            Intrinsics.checkNotNull(exception2);
            String string3 = exception2.getMessage();
            Intrinsics.checkNotNull(string3);
            String details = string3;
            logger.error((Function0<? extends Object>)new Function0<Object>(details){
                final /* synthetic */ String $details;
                {
                    this.$details = $details;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$details;
                }
            });
            this.printWrapped(details);
        }
    }

    private final String getResult(boolean value) {
        return value ? LanguageController.getMessages().getINFO_LABEL_ON_SUCCESS() : LanguageController.getMessages().getINFO_LABEL_ON_FAILURE();
    }

    public final void printWrapped(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        System.out.println((Object)StringExtensionsKt.wrap(text2, this.getOutputWidth()));
    }

    public final void printAuthors(@NotNull List<String> authors) {
        Intrinsics.checkNotNullParameter(authors, "authors");
        String line = authors.size() == 1 ? LanguageController.getMessages().getINFO_LABEL_AUTHOR() : LanguageController.getMessages().getINFO_LABEL_AUTHORS();
        String text2 = authors.isEmpty() ? LanguageController.getMessages().getINFO_LABEL_NO_AUTHORS() : CollectionsKt.joinToString$default(authors, ", ", null, null, 0, null, printAuthors.text.1.INSTANCE, 30, null);
        this.printWrapped(line + ' ' + text2);
    }

    public final void printConditional(@NotNull DirectiveConditional conditional) {
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        if (conditional.getType() != DirectiveConditionalType.NONE) {
            this.printWrapped(LanguageController.getMessages().getINFO_LABEL_CONDITIONAL() + " (" + (Object)((Object)conditional.getType()) + ") " + conditional.getCondition());
        }
    }

    @NotNull
    public final String byteSizeToString$cli(long size2) {
        String string;
        double conversionFactor = 1000.0;
        if ((double)size2 < conversionFactor) {
            string = size2 + " B";
        } else {
            int exp2 = (int)(Math.log(size2) / Math.log(conversionFactor));
            boolean bl = false;
            double baseSize = (double)size2 / Math.pow(conversionFactor, exp2);
            int ones = (int)baseSize;
            int tenths = (int)((baseSize - (double)ones) * (double)10);
            String[] stringArray = new String[]{String.valueOf(ones), String.valueOf(Session.INSTANCE.getUserInterfaceOptions().getLocale().getDecimalSeparator()), String.valueOf(tenths), String.valueOf("kMGTPE".charAt(exp2 - 1))};
            string = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString("%s%s%s %sB", stringArray);
        }
        return string;
    }

    public final void printTime(double seconds) {
        if (displayLine || displayException) {
            System.out.println();
        }
        long secondDuration = Duration.Companion.seconds-UwyO8pc(seconds);
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[]{String.valueOf(Duration.getInWholeSeconds-impl(secondDuration)), String.valueOf(Session.INSTANCE.getUserInterfaceOptions().getLocale().getDecimalSeparator()), String.valueOf(Duration.getInWholeMilliseconds-impl(Duration.minus-LRDsOJo(secondDuration, Duration.Companion.seconds-UwyO8pc(Duration.getInWholeSeconds-impl(secondDuration)))))};
        stringArray[0] = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString("%s%s%s", stringArray2);
        String text2 = org.islandoftex.arara.core.utils.StringExtensionsKt.formatString(LanguageController.getMessages().getINFO_DISPLAY_EXECUTION_TIME(), stringArray);
        logger.info((Function0<? extends Object>)new Function0<Object>(text2){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$text;
            }
        });
        this.printWrapped(text2);
    }

    private final void displayDetailsLine() {
        String string = StringsKt.padEnd(StringExtensionsKt.abbreviate$default(LanguageController.getMessages().getINFO_LABEL_ON_DETAILS() + ' ', this.getOutputWidth(), null, 2, null), this.getOutputWidth(), '-');
        System.out.println((Object)string);
    }

    @NotNull
    public final String displayOutputSeparator(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return StringExtensionsKt.center(' ' + message + ' ', this.getOutputWidth(), '-');
    }

    @NotNull
    public final String displaySeparator() {
        return StringsKt.repeat("-", this.getOutputWidth());
    }

    public static final /* synthetic */ String access$getResult(DisplayUtils $this, boolean value) {
        return $this.getResult(value);
    }
}

