#! /bin/sh
# Copyright (C) 2011-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Tests that we can recover from deleted headers generated by 'yacc -d'.

required='cc yacc'
. ./defs || exit 1

cat >> configure.ac << 'END'
AC_PROG_CC
AC_PROG_YACC
AC_OUTPUT
END

cat > Makefile.am <<'END'
bin_PROGRAMS = p1 p2 p3 p4
# The order in which files are listed in the p*_SOURCES variables
# below is significant, since it causes make failures whenever
# the proper definition of BUILT_SOURCES or the declaration of
# extra dependencies for 'main3.o' are removed.
p1_SOURCES = main1.c parse1.y
p2_SOURCES = main2.c parse2.y
p3_SOURCES = main3.c parse3.y parse3.h
p4_SOURCES = parse4.y
AM_YFLAGS = -d
p2_YFLAGS = -d

BUILT_SOURCES = parse1.h p2-parse2.h

# When we know which files include a yacc-generated header, we
# should be able to just declare dependencies directly instead
# of relying on the BUILT_SOURCES hack, and things should still
# work correctly.
main3.@OBJEXT@ parse3.@OBJEXT@: parse3.h

.PHONY: clean-p3 build-p3
build-p3: p3$(EXEEXT)
clean-p3:
	rm -f p3$(EXEEXT)
END

cat > parse1.y << 'END'
%{
#include "parse1.h"
int yylex () { return 0; }
void yyerror (char *s) { return; }
%}
%token ZARDOZ
%%
x : 'x' {};
%%
END

cat > main1.c << 'END'
#include "parse1.h"
int main (void)
{
  return ZARDOZ + yyparse ();
}
END

sed 's/"parse1\.h"/"p2-parse2.h"/' parse1.y > parse2.y
sed 's/"parse1\.h"/"p2-parse2.h"/' main1.c > main2.c

sed 's/"parse1\.h"/"parse3.h"/' parse1.y > parse3.y
sed 's/"parse1\.h"/"parse3.h"/' main1.c > main3.c

cat > parse4.y << 'END'
%{
int yylex () { return 0; }
void yyerror (char *s) { return; }
%}
%%
x : 'x' {};
%%
int main (void)
{
  return 0;
}
END

$ACLOCAL
$AUTOCONF
$AUTOMAKE -a

./configure
$MAKE

headers='parse1.h p2-parse2.h parse3.h parse4.h'

# Check that we remake only the necessary headers.

rm -f $headers
$MAKE parse1.h
test -f parse1.h
test ! -e p2-parse2.h
test ! -e parse3.h
test ! -e parse4.h

rm -f $headers
$MAKE p2-parse2.h
test ! -e parse1.h
test -f p2-parse2.h
test ! -e parse3.h
test ! -e parse4.h

rm -f $headers
$MAKE parse3.h
test ! -e parse1.h
test ! -e p2-parse2.h
test -f parse3.h
test ! -e parse4.h
# Since we declared parse3.h into $(p3_SOURCES), make should be
# able to rebuild it automatically before remaking 'p3'.
rm -f $headers
$MAKE clean-p3
test ! -e parse3.h # Sanity check.
$MAKE build-p3
test -f parse3.h

$MAKE

rm -f $headers
$MAKE parse4.h
test ! -e parse1.h
test ! -e p2-parse2.h
test ! -e parse3.h
test -f parse4.h

# Now remake all the headers together.

rm -f $headers
$MAKE $headers
test -f parse1.h
test -f p2-parse2.h
test -f parse3.h
test -f parse4.h

# Most headers should be remade by "make all".

rm -f $headers
$MAKE all
test -f parse1.h
test -f p2-parse2.h
test -f parse3.h
# parse4.h is not declared in any *_SOURCES variable, nor #included
# by any C source file, so it shouldn't be rebuilt by "make all".
test ! -e parse4.h

:
