untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46JxX/oB2PXEzAQjDs/2kn9WuqDgfYx7wlw8eRwyCwZ4MV2+dBCS4kr8sN3XO19cKGrqD728UgyDiYFsyoniy+AY=

OpenBSD 6.9 errata 005, May 24, 2021:

Recent Intel machines could crash or hang as global mappings were
not flushed from TLB.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 005_pmapglobal.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/pmap.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/pmap.c,v
retrieving revision 1.141
diff -u -p -r1.141 pmap.c
--- sys/arch/amd64/amd64/pmap.c	16 Dec 2020 21:11:35 -0000	1.141
+++ sys/arch/amd64/amd64/pmap.c	22 May 2021 16:38:00 -0000
@@ -698,6 +698,14 @@ pmap_bootstrap(paddr_t first_avail, padd
 		CPUID_LEAF(0x7, 0, dummy, ebx, dummy, dummy);
 		if (ebx & SEFF0EBX_INVPCID) {
 			pmap_use_pcid = 1;
+			/*
+			 * We cannot use global mappings because
+			 * invpcid function 0 does not invalidate global
+			 * mappings. The hardware can cache kernel
+			 * mappings based on PCID_KERN, i.e. there is no
+			 * need for global mappings.
+			 */
+			pg_g_kern = 0;
 			lcr4( rcr4() | CR4_PCIDE );
 			cr3_pcid_proc = PCID_PROC;
 			cr3_pcid_temp = PCID_TEMP;
