untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3stnyVprnEpQ5o2UKDpPQZVNSGBW0UPxZP178P2gi4M2rOXTxYn02yfPnkcAqyXzNOWhmETFJ3rfayx7b/b6MQI=

OpenBSD 6.7 errata 032, December 8, 2020:

Process exit in multithreaded programs could result in the wrong exit
code being reported.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 032_exit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_exit.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_exit.c,v
retrieving revision 1.188
diff -u -p -r1.188 kern_exit.c
--- sys/kern/kern_exit.c	18 Mar 2020 15:48:21 -0000	1.188
+++ sys/kern/kern_exit.c	17 Nov 2020 09:08:34 -0000
@@ -140,7 +140,7 @@ exit1(struct proc *p, int xexit, int xsi
 			single_thread_check(p, 0);
 	}
 
-	if (flags == EXIT_NORMAL) {
+	if (flags == EXIT_NORMAL && !(pr->ps_flags & PS_EXITING)) {
 		if (pr->ps_pid == 1)
 			panic("init died (signal %d, exit %d)", xsig, xexit);
 
