untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3q5ag5IPnGiSTz7dwSxM1hCr9Aq/S5DyRDSMFFzHrCN/bfiBWJsdDxBwcp9PAy2x8/4Bqk+eFiw9GBv9y6zWXAI=

OpenBSD 6.7 errata 017, July 31, 2020:

Pixmaps inside the xserver were an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 017_dix.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/dix/pixmap.c
===================================================================
RCS file: /cvs/xenocara/xserver/dix/pixmap.c,v
retrieving revision 1.14
diff -u -p -r1.14 pixmap.c
--- xserver/dix/pixmap.c	12 Dec 2019 06:05:19 -0000	1.14
+++ xserver/dix/pixmap.c	27 Jul 2020 19:44:53 -0000
@@ -117,7 +117,7 @@ AllocatePixmap(ScreenPtr pScreen, int pi
     if (pScreen->totalPixmapSize > ((size_t) - 1) - pixDataSize)
         return NullPixmap;
 
-    pPixmap = malloc(pScreen->totalPixmapSize + pixDataSize);
+    pPixmap = calloc(1, pScreen->totalPixmapSize + pixDataSize);
     if (!pPixmap)
         return NullPixmap;
 
