untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZaolZoOaNHiZP5NzyJIlh2fLVfzDpPTCTLcezIZESfEWeD7lZRcsO3ufhx1jGkOZfZX+fCVugSYqASky7+zsfA0=

OpenBSD 6.3 errata 015, July 31, 2018:

On i386, IO port permissions were incorrectly restricted.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 015_ioport.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/i386/i386/gdt.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/gdt.c,v
retrieving revision 1.39
diff -u -p -u -r1.39 gdt.c
--- sys/arch/i386/i386/gdt.c	22 Mar 2018 19:30:18 -0000	1.39
+++ sys/arch/i386/i386/gdt.c	25 Jul 2018 12:44:53 -0000
@@ -210,7 +210,7 @@ tss_alloc(struct pcb *pcb)
 	int slot;
 
 	slot = gdt_get_slot();
-	setgdt(slot, &pcb->pcb_tss, sizeof(struct pcb) - 1,
+	setgdt(slot, &pcb->pcb_tss, sizeof(struct i386tss) - 1,
 	    SDT_SYS386TSS, SEL_KPL, 0, 0);
 	return GSEL(slot, SEL_KPL);
 }
