untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEvgDRTzDzoZ9ztaeCOuctEXLbnUIeVa661TcEjCCjsy9tuhc32xizb9ln1cgVRl7BwddbXoO600JbE7nTyFCTwY=

OpenBSD 6.1 errata 011, June 12, 2017:

Fix an integer overflow in two range checks of the sti(4) display driver.
This issue only affects the hppa architecture.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 011_sti.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/ic/sti.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/sti.c,v
retrieving revision 1.77
diff -u -p -r1.77 sti.c
--- sys/dev/ic/sti.c	9 Sep 2015 18:23:39 -0000	1.77
+++ sys/dev/ic/sti.c	11 Jun 2017 02:30:58 -0000
@@ -1130,7 +1130,7 @@ sti_ioctl(void *v, u_long cmd, caddr_t d
 		cmapp = (struct wsdisplay_cmap *)data;
 		idx = cmapp->index;
 		count = cmapp->count;
-		if (idx >= STI_NCMAP || idx + count > STI_NCMAP)
+		if (idx >= STI_NCMAP || count > STI_NCMAP - idx)
 			return EINVAL;
 		if ((ret = copyout(&scr->scr_rcmap[idx], cmapp->red, count)))
 			break;
@@ -1146,7 +1146,7 @@ sti_ioctl(void *v, u_long cmd, caddr_t d
 		cmapp = (struct wsdisplay_cmap *)data;
 		idx = cmapp->index;
 		count = cmapp->count;
-		if (idx >= STI_NCMAP || idx + count > STI_NCMAP)
+		if (idx >= STI_NCMAP || count > STI_NCMAP - idx)
 			return EINVAL;
 		if ((ret = copyin(cmapp->red, &scr->scr_rcmap[idx], count)))
 			break;
