untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEnhaOZCGWHblebkok82AorbjVlOp9yk8P5ZMEyqwddnmtSECYEB/6jDNJHVD/XzneeSELwdoKm9HDkvRqpRAdwo=

OpenBSD 6.1 errata 003, May 2, 2017:

Revert consistency check that could cause programs to incorrectly
verify certificates when using callbacks that always return 1.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 003_libressl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
        cd /usr/src/lib/libcrypto
        make obj
        make depend
        make
        make install

Index: lib/libcrypto/x509/x509_vfy.c
===================================================================
--- lib/libcrypto/x509/x509_vfy.c	5 Feb 2017 02:33:21 -0000	1.61
+++ lib/libcrypto/x509/x509_vfy.c	28 Apr 2017 23:12:04 -0000	1.61.4.1
@@ -541,15 +541,7 @@ X509_verify_cert(X509_STORE_CTX *ctx)
 	/* Safety net, error returns must set ctx->error */
 	if (ok <= 0 && ctx->error == X509_V_OK)
 		ctx->error = X509_V_ERR_UNSPECIFIED;
-
-	/*
-	 * Safety net, if user provided verify callback indicates sucess
-	 * make sure they have set error to X509_V_OK
-	 */
-	if (ctx->verify_cb != null_callback && ok == 1)
-		ctx->error = X509_V_OK;
-
-	return(ctx->error == X509_V_OK);
+	return ok;
 }
 
 /* Given a STACK_OF(X509) find the issuer of cert (if any)
